// -------------------------------------------------------------------------
// Project Name         :	MultiRouter Setup for Windows 
// File Name            :	DIAGNOST.CPP
// Description          :	Defines the CDiagnostics Class 
//									which display Diagnostic dialog and runs 
//									diagnostics.
// Start Date           :	8th May 1995
// Author               :	Pravin
// Date Last Modified	:       
// Modifications        :       
// Vidy 05/12/96		: if only one wan don't show WAN 1

// Jyothi 16/7/98 	:  made changes for small proxy
// Jyothi 16/7/98 	:  structures used instead of INI files
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "boot.h"
#include "diagnost.h"
#include "maindlg.h"
#include "hardware.h"
#include "cnffile.h"
#include "readbmp.h"

// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------
         
char *DiagMsgHeader = "ProxyServer Setup - Hardware Diagnostics";

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

BootConfigType	BootConfigHead;
HeaderType	CodeHead;	// Downloaded codes header

/* Jo */
extern CNF_WAN *wan_ptr ;

/////////////////////////////////////////////////////////////////////////////
// CDiagnostics dialog


CDiagnostics::CDiagnostics(CWnd* pParent /*=NULL*/)
	: CDialog(CDiagnostics::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDiagnostics)
	m_SCC1 = TRUE;
	m_SCC2 = FALSE;
	m_SCC3 = FALSE;
	m_SCC4 = FALSE;
	m_Async  = TRUE;
	m_Sync = FALSE;
	m_BaudStr = "";
	//}}AFX_DATA_INIT
}

void CDiagnostics::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDiagnostics)
	DDX_Control(pDX, IDC_STATIC_ETHERNET_ADDR, m_EtherAddr);
	DDX_Control(pDX, IDC_WAN_ASYNC, m_AsyncWnd);
	DDX_Control(pDX, IDC_WAN_SYNC, m_SyncWnd);
	DDX_Control(pDX, IDC_WAN_TXT, m_WANText);
	DDX_Control(pDX, IDC_STATIC_FRM_VER, m_FirmVer);
	DDX_Control(pDX, IDC_STATIC_BOOT_VER, m_BootVer);
	DDX_Control(pDX, IDC_TEXT, m_BaudText);
	DDX_Control(pDX, IDC_BAUD_RATE, m_BaudRate);
	DDX_Check(pDX, IDC_SCC1, m_SCC1);
	DDX_Check(pDX, IDC_SCC2, m_SCC2);
	DDX_Check(pDX, IDC_SCC3, m_SCC3);
	DDX_Check(pDX, IDC_SCC4, m_SCC4);
	DDX_Check(pDX, IDC_WAN_ASYNC, m_Async);
	DDX_Check(pDX, IDC_WAN_SYNC, m_Sync);
	DDX_CBString(pDX, IDC_BAUD_RATE, m_BaudStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDiagnostics, CDialog)
	//{{AFX_MSG_MAP(CDiagnostics)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_SCC1, OnSCC1)
	ON_BN_CLICKED(IDC_SCC2, OnSCC2)
	ON_BN_CLICKED(IDC_SCC3, OnSCC3)
	ON_BN_CLICKED(IDC_SCC4, OnSCC4)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_TEST, OnTest)
	ON_BN_CLICKED(IDC_WAN_ASYNC, OnWANAsync)
	ON_BN_CLICKED(IDC_WAN_SYNC, OnWANSync)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDiagnostics message handlers

void CDiagnostics::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_DIAGNOSTIC,HELP_CONTEXT);
	
}

void	CDiagnostics::ConvertEtherAddrForDisplay(LPSTR NetAddr, LPCSTR EthernetAddr)
{
	LPSTR BytePtr;
	int	i, upper_nibble, lower_nibble;

	for (i = 0, BytePtr = (LPSTR)EthernetAddr; i < 6; i++, BytePtr++) {
		upper_nibble = (*BytePtr >> 4) & 0x0F;
		lower_nibble = (*BytePtr)  & 0x0F;
		if (upper_nibble >= 0 && upper_nibble <= 9)
			*NetAddr++ = '0' + upper_nibble;
		else
			*NetAddr++ = 'A' + upper_nibble - 10;
		if (lower_nibble >= 0 && lower_nibble <= 9)
			*NetAddr++ = '0' + lower_nibble;
		else
			*NetAddr++ = 'A' + lower_nibble - 10;
		*NetAddr++ = ':';
	}
	*--NetAddr = NULL;		// remove the last ':' and terminate with a NULL
}

BOOL CDiagnostics::OnInitDialog()
{
	char	VerCRC[50];
	char	CRC[10];
	BYTE	NetAddr[25];
	CDialog::OnInitDialog();
	int	NumWANs;
	char	szBuf[100];
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!TestBmpBtn.LoadBitmaps ("TEST1", "TEST2", "TEST3", "TEST4"))
		AfxMessageBox ("Failed to load TEST bitmap");

	VERIFY (TestBmpBtn.SubclassDlgItem (IDC_TEST, this));
	TestBmpBtn.SizeToContent();

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	SetCapture();

	NumWANs = wan_ptr->wan_header.number_of_ports ;
	if (NumWANs < 1 || NumWANs > 3)
		NumWANs = 3;

	//get the number of ports
	if (NumWANs == 2) 
	{		// we need to show some port(s) less
		GetDlgItem(IDC_SCC4)->ShowWindow(SW_HIDE);
	}
	if (NumWANs == 1) 
	{
		GetDlgItem(IDC_SCC3)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_SCC4)->ShowWindow(SW_HIDE);
		switch (model)
		{
		case MODEL_MTSR1_202ST:
			GetDlgItem(IDC_SCC2)->SetWindowText("ISDN-ST");
			break;
		case MODEL_MTSR1_202NT:
			GetDlgItem(IDC_SCC2)->SetWindowText("ISDN-NT");
			break;
		default:
			// Vidy 05/12/96		: if only one wan don't show WAN 1
			GetDlgItem(IDC_SCC2)->SetWindowText("WAN");
			break;
		}
	}
	//Vidy 04/12/96. We need to disable some controls for RF200
	GetPrivateProfileString("Port Setup",
						"Application Name", StrNull, (LPSTR)szBuf, sizeof(szBuf),
						(LPCSTR) OwnIniFile);
	if ((model == MODEL_MTSR1_202ST) || (model == MODEL_MTSR1_202NT)) 
	{
		m_AsyncWnd.SetCheck (1);
		m_AsyncWnd.EnableWindow(FALSE);
		m_BaudRate.ShowWindow(SW_HIDE);
		m_BaudText.ShowWindow(SW_HIDE);
		m_SyncWnd.ShowWindow(SW_HIDE);
		m_WANText.ShowWindow(SW_HIDE);
	}
	m_BaudRate.SetCurSel(12);
	m_AsyncWnd.SetCheck (1);

	if (GetVersionDates()) {

		CRC[1] = 0;
		if (CodeHead.Version[0] <= '9' && CodeHead.Version[0] >= '0')
			wsprintf(CRC,"%4x%s",(WORD) mycMiscCom.ltl_endian_word(CodeHead.CRC),"");
		else
			CodeHead.Version[0] = 0;
		AnsiUpperBuff(CRC,lstrlen(CRC));
		wsprintf(VerCRC, "%s <CRC=0x%s>", CodeHead.Version, CRC);
		m_FirmVer.SetWindowText((LPCSTR) VerCRC);
//		m_FirmDate.SetWindowText((LPCSTR) CodeHead.DateStamp);
//		m_BootVer.SetWindowText((LPCSTR) BootConfigHead.Date);
	}
	// Boot can be still shown
#if BIG_PROXY
	if (BootConfigHead.Version[0] <= '9' && BootConfigHead.Version[0] >= '0')
		m_BootVer.SetWindowText((LPCSTR) BootConfigHead.Version);
#else
	if (	(BootConfigHead.MajorVersion <= 9) &&
			(BootConfigHead.MajorVersion >= 0) &&
			(BootConfigHead.MinorVersion <= 9) &&
			(BootConfigHead.MinorVersion >= 0) )
	{
		sprintf(szBuf, "%d.%d", BootConfigHead.MajorVersion, BootConfigHead.MinorVersion);
		m_BootVer.SetWindowText((LPCSTR) szBuf);
	}
#endif
#if BIG_PROXY
	ConvertEtherAddrForDisplay((LPSTR)NetAddr, (LPCSTR)BootConfigHead.EthernetAddr);
#else
	sprintf((LPSTR)NetAddr, "%04X%08lX", (WORD)BootConfigHead.EthernetAddr_H, (DWORD)BootConfigHead.EthernetAddr_L);
//	ConvertEtherAddrForDisplay((LPSTR)NetAddr, (LPCSTR)szBuf);
#endif
	m_EtherAddr.SetWindowText((LPCSTR) NetAddr);

	ReleaseCapture();
	m_BaudRate.EnableWindow (FALSE) ;
	m_BaudText.EnableWindow (FALSE) ;
	m_AsyncWnd.EnableWindow (FALSE) ;
	m_SyncWnd.EnableWindow (FALSE) ;
	m_WANText.EnableWindow (FALSE) ;
	UpdateData (FALSE);
	CenterWindow();
	return TRUE;  // return TRUE  unless you set the focus to a control
}	//end of OnInitDialog()

void CDiagnostics::OnTimer(UINT nIDEvent)
{
	KillTimer(nIDEvent);
	
   mycMiscCom.TimeOut = TRUE;
	
//	MessageBox("Time Out Occured",DiagMsgHeader,MB_OK | MB_ICONINFORMATION);
		// TODO: Add your message handler code here and/or call default
	
	CDialog::OnTimer(nIDEvent);
}

// Get the Router code firmware version-date and boot version-date
BOOL	CDiagnostics::GetVersionDates(void)
{
   BOOL    NoTimer = FALSE;
   int   RetryCount=0;

   ReadLocReqType read_req;
   ReadLocRespType read_resp;
 	AfxGetApp()->LoadCursor(IDC_WAIT);
 	AfxGetApp()->DoWaitCursor(1);

   UINT nTimerID = 1;
   while(nTimerID != SetTimer(nTimerID,(UINT)10000,NULL))
      if(IDCANCEL == AfxMessageBox(MSG_GEN_NO_TIMER, MB_RETRYCANCEL)) {
         NoTimer = TRUE;
      }
			
   mycMiscCom.TimeOut = FALSE;
   read_req.Address = mycMiscCom.little_endian(FL_BOOT_HDR);
   read_req.Ptype = 31; //READ_REQ_TYPE
   read_req.Length = sizeof(BootConfigHead);
   while(1)
   {    
      mycMiscCom.snd_packet((BYTE *)&read_req,sizeof(read_req));
      if(!(mycMiscCom.rcv_packet((BYTE *)&read_resp,sizeof(BootConfigHead) +3,
				(BOOL *)&mycMiscCom.TimeOut)))
			break;// No CRC Error
      
   }
   if(mycMiscCom.TimeOut) {
 		AfxGetApp()->DoWaitCursor(0);
		return FALSE;
	}

	KillTimer(nTimerID);
	memcpy(&BootConfigHead,read_resp.buffer,sizeof(BootConfigHead));
	BootConfigHead.EthernetAddr_H = SwapWord(BootConfigHead.EthernetAddr_H);
	BootConfigHead.EthernetAddr_L = SwapDWord(BootConfigHead.EthernetAddr_L);

	// Now read the Code header
   nTimerID = 1;
   while(nTimerID != SetTimer(nTimerID,(UINT)10000,NULL))
      if(IDCANCEL == AfxMessageBox(MSG_GEN_NO_TIMER,MB_RETRYCANCEL)) {
         NoTimer = TRUE;
      }
			
   mycMiscCom.TimeOut = FALSE;
   read_req.Address = mycMiscCom.little_endian(FL_CODE_HDR);
   read_req.Ptype = 31; //READ_REQ_TYPE
   read_req.Length = sizeof(CodeHead);
   while(1)
   {    
      mycMiscCom.snd_packet((BYTE *)&read_req,sizeof(read_req));
      if(!(mycMiscCom.rcv_packet((BYTE *)&read_resp,sizeof(CodeHead) +3,
				(BOOL *)&mycMiscCom.TimeOut)))
			break;// No CRC Error
      
   }
   if(mycMiscCom.TimeOut) {
 		AfxGetApp()->DoWaitCursor(0);
		return FALSE;
	}
	KillTimer(nTimerID);
	memcpy(&CodeHead,read_resp.buffer,sizeof(CodeHead));
	
	//Get the magic no.
/*	strcpy(szBuf, MAGIC_NUM);
	int count = strlen(szBuf);
	WORD MagicNum = (WORD) ((CMainDlg *) GetParent())->ConverttoHEX(szBuf, 
																	count);
	MagicNum = mycMiscCom.ltl_endian_word(MagicNum) ; */
	WORD MagicNum = mycMiscCom.ltl_endian_word ((WORD) MAGIC_NUM) ; 


	if (CodeHead.MagicNum != MagicNum)
		return FALSE;

 	AfxGetApp()->DoWaitCursor(0);
	return TRUE;
}	//end of GetVersionDates()

void CDiagnostics::OnTest()
{
   SetCapture();
   AfxGetApp()->LoadCursor(IDC_WAIT);
   AfxGetApp()->DoWaitCursor(1);

	// Update the parameters from the Dialog Box.
	UpdateData(TRUE);        

	if(m_SCC1)
		Port = 1;
	else if(m_SCC2)
		Port = 2;
	else if(m_SCC3)
		Port = 3;
	else if(m_SCC4)
		Port = 4;
	else
		Port = 0;
	switch (Port) {
		case 0:
			AfxMessageBox(MSG_DIAG_NO_PORT_SEL, MB_OK 
						| MB_ICONEXCLAMATION);
			break;
		case 1:
			test_hardware();
			break;
		default :
			if (m_Sync) {
				BaudIdx = (BYTE) 0x80;
				test_hardware();
				break;
			}
		   if (m_Async) {
				BaudIdx = m_BaudRate.GetCurSel();
				if( BaudIdx == (BYTE)CB_ERR)
					AfxMessageBox(MSG_DIAG_NO_BAUD_SEL, MB_OK 
												| MB_ICONEXCLAMATION);
				else
					test_hardware();
			}
			break;
	}
   AfxGetApp()->DoWaitCursor(0);
   ReleaseCapture();
}	//end of OnTest()

#define	NTRIALS	10

void	CDiagnostics::test_hardware()
{
	BOOL Retry = TRUE;
   TargetCmdType	cmd_type;
	ResultType	restype;
	int	PassCount, TrialCount;

	PassCount = TrialCount = 0;


RETRY:
	TrialCount++;
   mycMiscCom.TimeOut = FALSE;
   UINT nTimerID = 1;
   while(nTimerID != SetTimer(nTimerID,(UINT)32000,NULL))
			if(IDCANCEL == AfxMessageBox(MSG_GEN_NO_TIMER, MB_RETRYCANCEL)) 
                                return;			

   cmd_type.Ptype=(BYTE)0;
   cmd_type.TargetAction=(BYTE)1;
   cmd_type.Port=Port;
   cmd_type.BaudIndex=BaudIdx;
	while(1) 
   {
      mycMiscCom.snd_packet((BYTE *)&cmd_type, sizeof(cmd_type));
      if(!mycMiscCom.rcv_packet((BYTE *)&restype, sizeof(restype),
			(BOOL *)&mycMiscCom.TimeOut))
				break;	//No CRC error
	}
   if(mycMiscCom.TimeOut)
			AfxMessageBox(MSG_DIAG_NO_RTR_RESP, MB_OK | MB_ICONINFORMATION);
	
   else  
   {
      KillTimer(nTimerID);
      if(restype.Ptype == 12) 
      {

         restype.ErrorCode=mycMiscCom.ltl_endian_word(restype.ErrorCode);
         if(restype.ErrorCode==0) {
				PassCount++;
				if (TrialCount < NTRIALS)
					goto RETRY;
				switch (Port) {
					case 1:
						MessageString.LoadString(MSG_DIAG_ENET_OK);
						break;
					case 2:
						MessageString.LoadString(MSG_DIAG_WAN1_OK);
						break;
					case 3:
						MessageString.LoadString(MSG_DIAG_WAN2_OK);
						break;
					case 4:
						MessageString.LoadString(MSG_DIAG_WAN3_OK);
						break;
					default :
						MessageString.LoadString(MSG_DIAG_ERR);
						break;
				}
				MessageBox(MessageString, DiagMsgHeader, MB_OK | MB_ICONINFORMATION);
			   AfxGetApp()->DoWaitCursor(0);
			}
         else
         {
            if(restype.Dmy0==1)
            {
					MessageString.LoadString(MSG_GEN_ROUTER_IS_UP);
               MessageBox(MessageString, DiagMsgHeader, MB_OK | MB_ICONINFORMATION);
               ((CMainDlg *) GetParent())->RouterUp = TRUE;
               ((CMainDlg *) GetParent())->TargetFound = TRUE;
               ((CMainDlg *) GetParent())->InitButtonState();
            }
            else {
					switch (Port) {
					case 1:
						MessageString.LoadString(MSG_DIAG_ENET_ERR);
						break;
					case 2:
						MessageString.LoadString(MSG_DIAG_WAN1_ERR);
						break;
					case 3:
						MessageString.LoadString(MSG_DIAG_WAN2_ERR);
						break;
					case 4:
						MessageString.LoadString(MSG_DIAG_WAN3_ERR);
						break;
					default :
						MessageString.LoadString(MSG_DIAG_ERR);
						break;
					}
               MessageBox (MessageString, DiagMsgHeader, MB_OK | MB_ICONINFORMATION);
				   AfxGetApp()->DoWaitCursor(0);
				}
         }
		}
		else {
			if(Retry) {
				Retry = FALSE;
				goto RETRY;
			}
			MessageString.LoadString(MSG_GEN_UNKNOWN_PKT);
			MessageBox(MessageString, DiagMsgHeader, MB_OK | MB_ICONINFORMATION);
		}
	}
}	//end of test_hardware()

//	Update the controls depending on the user inputs.

void CDiagnostics::OnSCC1()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	m_BaudRate.EnableWindow(!m_SCC1);
	m_BaudText.EnableWindow(!m_SCC1);
	m_AsyncWnd.EnableWindow(!m_SCC1);
	m_SyncWnd.EnableWindow(!m_SCC1);
	m_WANText.EnableWindow(!m_SCC1);
}

void CDiagnostics::OnSCC2()
{
	UpdateData(TRUE);
	
	m_BaudRate.EnableWindow(m_SCC2 && m_Async);
	m_BaudText.EnableWindow(m_SCC2 && m_Async);	
	m_AsyncWnd.EnableWindow(m_SCC2);
	m_SyncWnd.EnableWindow(m_SCC2);
	m_WANText.EnableWindow(m_SCC2);
}

void CDiagnostics::OnSCC3()
{
	UpdateData(TRUE);
	
	m_BaudRate.EnableWindow(m_SCC3 && m_Async);	
	m_BaudText.EnableWindow(m_SCC3 && m_Async);
	m_AsyncWnd.EnableWindow(m_SCC3);
	m_SyncWnd.EnableWindow(m_SCC3);
	m_WANText.EnableWindow(m_SCC3);
}

void CDiagnostics::OnSCC4()
{
	UpdateData(TRUE);
	
	m_BaudRate.EnableWindow(m_SCC4 && m_Async);	
	m_BaudText.EnableWindow(m_SCC4 && m_Async);
	m_AsyncWnd.EnableWindow(m_SCC4);
	m_SyncWnd.EnableWindow(m_SCC4);
	m_WANText.EnableWindow(m_SCC4);
}

void CDiagnostics::OnWANAsync()
{
	UpdateData(TRUE);
	
	m_BaudRate.EnableWindow(m_Async);
	m_BaudText.EnableWindow(m_Async);
}

void CDiagnostics::OnWANSync()
{
	UpdateData(TRUE);
	
	m_BaudRate.EnableWindow(!m_Sync);
	m_BaudText.EnableWindow(!m_Sync);
}
