#define   NULL_TERM 		0x0000   	/* The NULL character */
#define   ZERO				0x0030		/* '0' character */
#define   BASE_TEN			 10		/* for strtoul function base */
#define   BACK_SLASH		'\\'
#define   ONE_KILO          1024
#define   COMMA_CHAR        ','

#define   SEP_SPACE         10    /* Separators between parameters */
							  			/* in the .INI file	*/

#define	 PRODUCT_NAME_LEN	20    /* Max. length of Product name */
								/* including  terminating NULL */
#define	 PROD_DESCRIP_LEN  	80    /* Max. length of Product description */
						   		/*  including  terminating NULL */

#define   DIRECTORY_NAME_LEN  (8 + 1)  /* Length of directory name */
						   		/*  including  terminating NULL */

#define   GRP_PATH_LEN        (10 + 1) /* Length of Group Name */
						   		/*  including  terminating NULL */

/* The following are for the "Sections" section */
#define   NO_OF_SECTIONS      	 20		/* Max. no. of sections */
#define   SECTION_NAME_LEN_LHS    10		/* Max. length of heading on LHS */
#define   SECTION_NAME_LEN_RHS    30		/* Max. length of section names */
														/* including  terminating NULL */

/* Related to the files in section */
#define  MAX_FILENAME_LEN 	15 					/* including  terminating NULL */
#define  FILE_DESCRIP_LEN 	PROD_DESCRIP_LEN  /* including  terminating NULL */
#define  MAX_NO_OF_FILES   150
#define  FILE_NAME_HEAD	  	SECTION_NAME_LEN_LHS   /* that on the LHS */

/* Related to Icons Section */
#define  NO_OF_ICONS  25
#define  MAX_ICON_FILENAME_LEN  80	  /* including  terminating NULL */
#define  ICON_DESCRIP_LEN  PROD_DESCRIP_LEN  /* including  terminating NULL */
#define  ICON_NAME_HEAD  SECTION_NAME_LEN_LHS  /* that on the LHS */
														

typedef struct {
	char ProductName[PRODUCT_NAME_LEN] ;
	char ProductDescription[PROD_DESCRIP_LEN] ;
} PRODUCTSTRUCT ;

typedef struct {
	char SectionNames[NO_OF_SECTIONS][SECTION_NAME_LEN_RHS] ;
} SECTIONSTRUCT ;

typedef struct {
	char Filename[MAX_FILENAME_LEN] ;
	int DisketteNo ;
	DWORD FileSize ;
	char FileDescription[FILE_DESCRIP_LEN] ;
} FILESTRUCT ;

typedef struct {
	char Filename[MAX_ICON_FILENAME_LEN] ;
	int IconNo ;
	char IconDescription[ICON_DESCRIP_LEN] ;
} ICONSTRUCT ;


/* The function Declarations */
extern void FAR PASCAL GetProductName (PRODUCTSTRUCT FAR *PS) ;
extern int FAR PASCAL GetSectionList (SECTIONSTRUCT FAR *SS) ;
extern int FAR PASCAL GetFilesInSection (LPSTR lpszSection,
															FILESTRUCT FAR *FS) ;
extern int FAR PASCAL GetCommonFiles (FILESTRUCT FAR *FS) ;
extern int FAR PASCAL GetNewIconList (ICONSTRUCT FAR *IS) ;
extern int FAR PASCAL GetOldIconList (ICONSTRUCT FAR *IS) ;
int FAR PASCAL GetIconList (LPCSTR lpcszSection, ICONSTRUCT FAR *IS) ;
int FAR PASCAL GetFilesInSpecifiedSections (LPSTR lpszSection,
																FILESTRUCT FAR *FS) ;
DWORD _fstrtoul (LPSTR lpszStr) ;
int _fstrtod (LPSTR lpszStr) ;
extern void FAR PASCAL FindInstIniPath (LPSTR lpszPath) ;
extern DWORD FAR PASCAL GetFreeSpaceInCurDrive (unsigned DriveNo) ;
extern void ConvertNumToStrWithCommas (DWORD Number, NPSTR npszStrBuf) ;
extern BOOL GetDestInstallPath (LPSTR DestPath) ;
extern BOOL GetInstallGroupName (LPSTR GrpName) ;

