
// Modifications
// 04/11/96 Vidy added support for installing NMP files also

/* For the _dos_findfirst call */
#include	<dos.h>
#include	"sys\types.h"
#include	"sys\stat.h"
#include	<errno.h>

#include	"windows.h"
#include <lzexpand.h>
#include	"install.h"
#include	"utils.h"
#include "init.h"
#include "string.h"



SECTIONSTRUCT SectionStringStruct ;
int NoOfSections ;
FILESTRUCT FilesStruct[MAX_NO_OF_FILES] ;
ICONSTRUCT IconsStruct[NO_OF_ICONS] ;
ICONSTRUCT OldIconsStruct[NO_OF_ICONS] ;
int NoOfNewIcons ;
int NoOfOldIcons ;
FILESTRUCT FAR *lpszAddrOfFilesStruct = FilesStruct ;
int Ctl3dv2Index ;


BYTE *RealExtns[] = {
".EXE", ".DLL", ".CNF", ".TRM", ".INI", ".HLP", ".BIN", ".CFG", ".DAT",
".NMP",			// 04/11/96 Vidy added
"",
};

char	*MTRMessage	= "MultiRouter Installation";
char	*DialogLib = "ctl3dv2.dll";


void	CreateFilesList(void)
{
	int i, j ;	
	int NoOfFilesInSection = 0 ;	
	BOOL fCheck = FALSE ; 

	// get a list of all the sections 
	NoOfSections = GetSectionList (&SectionStringStruct) ; 

	// get a list of all new icons
	NoOfNewIcons = GetNewIconList (&IconsStruct[0]) ;

	// get a list of all old icons
	NoOfOldIcons = GetOldIconList (&OldIconsStruct[0]) ;

	// get a list of all files in each section 
	for (i = 0 ; i < NoOfSections ; i ++) 
	{
		NoOfFilesInSection = 
			GetFilesInSection (SectionStringStruct.SectionNames[i], 
												 lpszAddrOfFilesStruct + NumFiles) ;
		for (j = 0 ; j < NoOfFilesInSection ; j ++)  
		{
			if (!fCheck)
			{
				if (! (lstrcmpi (FilesStruct[NumFiles + j].Filename, 
												"ctl3dv2.dl_")))
				{
					Ctl3dv2Index = NumFiles + j ;
					fCheck = TRUE ;
					continue ;
				}
			}
			TotalSize += FilesStruct[NumFiles + j].FileSize ;
		}
		NumFiles += NoOfFilesInSection ;  
	}
}


/* -------------------------------------------------------------------------
	Function	:	DLGCenterDialog()
	Synopsis	:	Centers the dialog on screen.
	Input		:	Dialog box handle.
	Output		:	None.
 ------------------------------------------------------------------------ */
void FAR PASCAL DLGCenterDialog (HWND hDlg)
{
	int		Left, Top, Height, Width;
	int		ScrnHeight, ScrnWidth;
	RECT	rcDlgOld;

	GetWindowRect(hDlg, (LPRECT) &rcDlgOld);

	Width = rcDlgOld.right - rcDlgOld.left;
	Height = rcDlgOld.bottom - rcDlgOld.top;

	ScrnWidth = GetSystemMetrics (SM_CXSCREEN);
	ScrnHeight = GetSystemMetrics (SM_CYSCREEN);

	Left = ((ScrnWidth - Width) / 2);
	Top = ((ScrnHeight - Height) / 2);

	MoveWindow(hDlg, Left, Top, Width, Height, TRUE);
}

BOOL CheckAndCopyCtl3dv2 (void)
{
	char WindowsDir[128] ;
	int DirNameLen ;
	char FullFileSpec[200] ;	/* buffer containing the full pathname spec */
	struct find_t fileinfo ;

	CurFileIndex = 0 ;
	DirNameLen = GetWindowsDirectory ((LPSTR) WindowsDir,
															sizeof (WindowsDir)) ;
	if (WindowsDir[DirNameLen - 1] != '\\') 
	{
		WindowsDir[DirNameLen] = '\\' ;
		WindowsDir[DirNameLen + 1] = NULL_TERM ;
	}
	// check if ctl3dv2 is present
	lstrcpy ((LPSTR) FullFileSpec, (LPCSTR) WindowsDir) ;		
	lstrcat ((LPSTR) FullFileSpec, (LPCSTR) DialogLib) ;    


	if ( ! _dos_findfirst (FullFileSpec, _A_NORMAL, &fileinfo))
	{
		return TRUE ;
	}

	/* copy the file from install directory to windows directory */
	lstrcpy ((LPSTR) DestDir, (LPCSTR) WindowsDir) ;
	CurFileIndex = Ctl3dv2Index ;
	if (! OpenSrcDestFiles (0))				// no status display while copy
		return FALSE ;
	while (CopyOneBlock (0)) ; 
	CloseSrcDestFiles () ;
	return TRUE ;
}
