// ipdnld.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "maskdot.h"
#include "ipdnld.h"
#include "dhcpk.h"
#include "hardware.h"
#include "cnffile.h"
#include "readbmp.h"
#include "utils.h"

char	*IPDnldMsgHeader="IP Setup";
LPCSTR IPDnldSectionHeader ="IP Routing" ;
extern int FirstTimeInEdit = 1;

extern CNF_IP *ip_ptr ;
extern CNF_PPP *ppp_ptr ;
extern CNF_DHCP *dhcp_ptr ;
extern CNF_DHCP_HEADER *dhcp_header_ptr ;
extern BOOL ModifyIPAddress ; /* Jo 20/1/99 */
extern CDotDecimal dotdecimal_configured_ip_address ;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIPDNLD dialog


CIPDNLD::CIPDNLD(CWnd* pParent /*=NULL*/)
	: CDialog(CIPDNLD::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIPDNLD)
	m_ISPcheck = FALSE;
	m_IPAddrStr = "";
	m_MskStr = "";
	m_sel_port = "";
	m_remote_addr = "";
	m_secondary_address = "";
	m_primary_address = "";
	m_port_static1 = "";
	m_port_static2 = "";
	//}}AFX_DATA_INIT
}

void CIPDNLD::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIPDNLD)
	DDX_Control(pDX, IDC_EDIT_REMOTE_ADDRESS, m_ctrl_remote_addr);
	DDX_Control(pDX, IDC_STATIC_REMOTE_ADDRESS, m_static_remote_addr);
	DDX_Control(pDX, IDC_EDIT_PRIMARY_ADDRESS, m_ctrl_primary);
	DDX_Control(pDX, IDC_EDIT_SECONDARY_ADDRESS, m_ctrl_secondary);
	DDX_Control(pDX, IDC_STATIC_SECONDARY_ADDRESS, m_static_secondary);
	DDX_Control(pDX, IDC_STATIC_PRIMARY_ADDRESS, m_static_primary);
	DDX_Control(pDX, IDC_STATIC_DNS, m_grp_dns);
	DDX_Control(pDX, IDC_STATIC_SEL_PORT, m_ctrl_sel_port);
	DDX_Control(pDX, IDC_RADIO_YES, m_ctrl_dhcp_yes);
	DDX_Control(pDX, IDC_RADIO_NO, m_ctrl_dhcp_no);
	DDX_Control(pDX, IDC_STATIC_MASK, m_staticMskWnd);
	DDX_Control(pDX, IDC_STATIC_ADDR, m_IPHdrWnd);
	DDX_Control(pDX, IDC_STATIC_USER_ASSIGNED, m_ctrl_user_assigned);
	DDX_Control(pDX, IDC_LIST_PORTS, m_PortListWnd);
	DDX_Control(pDX, IDC_EDIT_MSK, m_MskWnd);
	DDX_Control(pDX, IDC_EDIT_IP_ADDR, m_IPAddrWnd);
	DDX_Control(pDX, IDC_CHECK_RAS, m_ras_enable);
	DDX_Control(pDX, IDC_CHECK_IP_ADDR, m_ISPWnd);
	DDX_Control(pDX, IDC_CHECK_CLIENT, m_check_client);
	DDX_Check(pDX, IDC_CHECK_IP_ADDR, m_ISPcheck);
	DDX_Text(pDX, IDC_EDIT_IP_ADDR, m_IPAddrStr);
	DDX_Text(pDX, IDC_EDIT_MSK, m_MskStr);
	DDX_Text(pDX, IDC_STATIC_SEL_PORT, m_sel_port);
	DDX_Text(pDX, IDC_EDIT_REMOTE_ADDRESS, m_remote_addr);
	DDX_Text(pDX, IDC_EDIT_SECONDARY_ADDRESS, m_secondary_address);
	DDX_Text(pDX, IDC_EDIT_PRIMARY_ADDRESS, m_primary_address);
	DDX_Text(pDX, IDC_STATIC1, m_port_static1);
	DDX_Text(pDX, IDC_STATIC2, m_port_static2);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIPDNLD, CDialog)
	//{{AFX_MSG_MAP(CIPDNLD)
	ON_BN_CLICKED(IDC_CHECK_IP_ADDR, OnCheckIpAddr)
	ON_BN_CLICKED(IDC_CHECK_CLIENT, OnCheckClient)
	ON_BN_CLICKED(IDC_CHECK_RAS, OnCheckRas)
	ON_LBN_SELCHANGE(IDC_LIST_PORTS, OnSelchangeListPorts)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_CHECK_DHCP, OnCheckDhcp)
	ON_BN_CLICKED(IDC_RADIO_NO, OnDhcpNo)
	ON_BN_CLICKED(IDC_RADIO_YES, OnDhcpYes)
	ON_BN_CLICKED(IDCANCEL2, OnCancel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIPDNLD message handlers

void CIPDNLD::OnCheckIpAddr()
{
	// TODO: Add your control notification handler code here
	if (m_ISPWnd.GetCheck())	// Get the status of check button
	{
		UpdateData(TRUE);			//Get the dialog updates
		m_ctrl_user_assigned.ShowWindow(FALSE);
		m_ctrl_user_assigned.EnableWindow(FALSE);
		m_IPAddrWnd.EnableWindow(FALSE);
		m_IPHdrWnd.EnableWindow(FALSE);
		if (m_PortListWnd.GetCurSel() != 0)
		{
			m_staticMskWnd.EnableWindow(FALSE);
			m_MskWnd.EnableWindow(FALSE);
		}
		m_IPAddrStr = ZeroIPAddress; //reset address
		UpdateData(FALSE);		//display data in dialog
	}
	else
	{
		m_ctrl_user_assigned.ShowWindow(TRUE);
		m_ctrl_user_assigned.EnableWindow(TRUE);
		m_IPHdrWnd.EnableWindow(TRUE);
		m_IPAddrWnd.EnableWindow(TRUE);
		m_staticMskWnd.EnableWindow(TRUE);
		m_MskWnd.EnableWindow(TRUE);
	}
}

void CIPDNLD::OnCheckClient()
{
	// TODO: Add your control notification handler code here
	
}

void CIPDNLD::OnCheckRas()
{
	// TODO: Add your control notification handler code here
	if (m_ras_enable.GetCheck())
	{
		m_static_remote_addr.EnableWindow (TRUE);
		m_ctrl_remote_addr.EnableWindow (TRUE);
	}
	else
	{
		m_static_remote_addr.EnableWindow (FALSE);
		m_ctrl_remote_addr.EnableWindow (FALSE);
	}
//	UpdateData (FALSE);
}

void CIPDNLD::OnSelchangeListPorts()
{
	// TODO: Add your control notification handler code here
	int PortIndex;
	BOOL rasctrl ;
	char PortString[20];

	UpdateData(TRUE);

	// TODO: Add your control notification handler code here
	PortIndex = m_PortListWnd.GetCurSel();
	if (PortIndex == LB_ERR)
		return;

	if (m_nOldPort == PortIndex)	// Prevent any loops
		return;

	if (!ValidPortSettings())
	{
		m_PortListWnd.SetCurSel(m_nOldPort);
		return;
	}
	//Store values for Old Port
	m_ISP[m_nOldPort] = m_ISPcheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;

	if (m_ras_enable.GetCheck())
		m_RAS[m_nOldPort] = 1;
	else
		m_RAS[m_nOldPort] = 0;
	m_RemoteAddr[m_nOldPort] = m_remote_addr; 

	m_ISPcheck = m_ISP[PortIndex];
	m_IPAddrStr = m_IPAddr[PortIndex];
	m_MskStr = m_IPMask[PortIndex];

	if (m_RAS[PortIndex])
		m_ras_enable.SetCheck (1);
	else
		m_ras_enable.SetCheck (0);

	m_remote_addr = m_RemoteAddr[PortIndex];
	m_static_remote_addr.EnableWindow(m_RAS[PortIndex]);
	m_ctrl_remote_addr.EnableWindow(m_RAS[PortIndex]);

	m_ctrl_user_assigned.ShowWindow(m_ISPcheck);

	if ( m_MLPPP || !m_RAS[PortIndex])
		rasctrl = FALSE ;
	else
		rasctrl = TRUE ;

	if (PortIndex == 0)		//LAN index
	{
		//If the selected port is LAN disable ISP_Assigned_Address

		m_port_static1.LoadString(IDS_LAN_SETUP1);
		m_port_static2.LoadString(IDS_LAN_SETUP2);

		m_ISPWnd.ShowWindow(FALSE);
		m_ras_enable.ShowWindow (FALSE);
		m_ctrl_remote_addr.ShowWindow (FALSE);
		m_static_remote_addr.ShowWindow (FALSE);

		m_ISPWnd.EnableWindow(FALSE);
		m_ras_enable.EnableWindow (FALSE);     
		m_ctrl_remote_addr.EnableWindow (FALSE);
		m_static_remote_addr.EnableWindow (FALSE);

		m_ctrl_user_assigned.ShowWindow(TRUE);
		m_ctrl_user_assigned.EnableWindow(TRUE);

		//Change the group heading to that of the selected port
		strcpy(PortString,"LAN");
		m_sel_port = PortString;
	}
	else
	{
		m_ISPWnd.ShowWindow(TRUE);
		m_ras_enable.ShowWindow(TRUE);
		m_ctrl_user_assigned.ShowWindow(!m_ISPcheck);

		m_ISPWnd.EnableWindow(TRUE);
		m_ras_enable.EnableWindow (TRUE);
		m_ctrl_user_assigned.EnableWindow(!m_ISPcheck);

		m_ctrl_remote_addr.ShowWindow (TRUE);
		m_static_remote_addr.ShowWindow (TRUE);

		m_port_static1.LoadString(IDS_WAN_SETUP1);
		m_port_static2.LoadString(IDS_WAN_SETUP2);

		m_ctrl_remote_addr.EnableWindow (rasctrl);
		m_static_remote_addr.EnableWindow (rasctrl);
  
#if 0
		if (m_nPorts <= 2)
			strcpy(PortString,"WAN");
		else
			strcpy(PortString,"WAN 1");
#endif
// Jo 11/10/99 Display selected Port Name
		sprintf(PortString, "WAN %d", PortIndex) ;
		m_sel_port = PortString;
	}
	m_IPHdrWnd.EnableWindow(!m_ISPcheck);
	m_IPAddrWnd.EnableWindow(!m_ISPcheck);
	m_staticMskWnd.EnableWindow(!m_ISPcheck);
	m_MskWnd.EnableWindow(!m_ISPcheck);


	UpdateData(FALSE);
	m_nOldPort = PortIndex;
}

BOOL CIPDNLD::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow();

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	// Read the configuration file and init the variables
	int	index, ptmp ;
	char	szRHS[40];
	char PortString[20];
	CDotDecimal DotValue;
   char    temp_dot_value[20] ; 

   m_nPorts = ip_ptr->ip_header.number_of_ports ;

	if (m_nPorts > MAX_NUM_PORTS)
		m_nPorts = MAX_NUM_PORTS;

	m_MLPPP = ppp_ptr->ppp_ports[0].lcp_epd.valid ;

	for (index = 0; index < m_nPorts; index++)
	{
		//Get IP address of the port

      get_dot_decimal_ip_address (ip_ptr->ip_ports[index].ip_address, temp_dot_value) ;
		DotValue = m_IPAddr[index] = temp_dot_value ;
		if ( ! DotValue.IsValid())
			m_IPAddr[index] = ZeroIPAddress ;
/* Jo For AutoDetection 20/1/99 */
/* set LAN address for that configured during autodetection */
		if (ModifyIPAddress == TRUE)
		{
			if ( ! dotdecimal_configured_ip_address.IsValid())
				m_IPAddr[0] = ZeroIPAddress ;
			else
				m_IPAddr[0] = dotdecimal_configured_ip_address ;
		}
/* Jo For AutoDetection 20/1/99 */

		//If IP address == 0.0.0.0 then it is ISP assigned
		m_ISP[index] = FALSE;
		if (index > 0)		//not for LAN port
			if ( ! strcmp((LPCSTR)m_IPAddr[index], ZeroIPAddress))
				m_ISP[index] = TRUE;

		//Get subnet mask for the port

      get_dot_decimal_ip_address (ip_ptr->ip_ports[index].subnet_mask, temp_dot_value) ;
     	m_IPMask[index] = temp_dot_value ;
		if ( ! verify_ip_subnet_mask((LPCSTR)m_IPMask[index]))
			m_IPMask[index] = ZeroIPAddress;

		////Prabha, 11/3/98, for RAS support

		m_RAS[index] = 0;
		if ((index > 0) && !m_MLPPP)
			m_RAS[index] = ppp_ptr->ppp_ports[index-1].remote_port_client_only ;

		get_dot_decimal_ip_address (ip_ptr->ip_ports[index].remote_ip_address, temp_dot_value) ;
		m_RemoteAddr[index] = temp_dot_value ;
	}

	//Add items into the port list
 	m_PortListWnd.AddString("LAN");
	if (m_nPorts > 2)
	{
		strcpy(szRHS, "WAN 1");
		for (index = 0; index < m_nPorts-1; index++)
		{
			m_PortListWnd.AddString(szRHS);
			szRHS[4]++;	//next port name
		}
	}
	else
	{
	 	m_PortListWnd.AddString("WAN");
	}
	//Set current selection as LAN
	m_nOldPort = 0;
	m_PortListWnd.SetCurSel(m_nOldPort);

	//Set the other port dependent parameters to be of LAN
	m_IPAddrStr = m_IPAddr[m_nOldPort];
 	m_MskStr = m_IPMask[m_nOldPort];
	m_ISPcheck = m_ISP[m_nOldPort];

	strcpy(PortString,"LAN");
	m_sel_port = PortString;
	
	m_ISPWnd.ShowWindow(FALSE);
	m_ras_enable.ShowWindow (FALSE);
	m_ctrl_remote_addr.ShowWindow (FALSE);
	m_static_remote_addr.ShowWindow (FALSE); 
	
	m_ISPWnd.EnableWindow(FALSE);
	m_ras_enable.EnableWindow (FALSE);
	m_ctrl_remote_addr.EnableWindow (FALSE);
	m_static_remote_addr.EnableWindow (FALSE);

	ptmp = dhcp_header_ptr->dhcp_server_enabled;
	
	m_ctrl_dhcp_yes.SetCheck(ptmp);
	m_ctrl_dhcp_no.SetCheck(!ptmp);

	if (ip_ptr->ip_header.primary_address)
	{
      get_dot_decimal_ip_address (ip_ptr->ip_header.primary_address, temp_dot_value) ;
	   m_primary_address = temp_dot_value ;
	}
	else
	   m_primary_address = "" ;

	if (ip_ptr->ip_header.secondary_address)
   {
      get_dot_decimal_ip_address (ip_ptr->ip_header.secondary_address, temp_dot_value) ;
      m_secondary_address = temp_dot_value ;
	}
	else
	   m_secondary_address = "" ;

	m_grp_dns.EnableWindow(m_ctrl_dhcp_yes.GetCheck());
	m_static_primary.EnableWindow(m_ctrl_dhcp_yes.GetCheck());
	m_static_secondary.EnableWindow(m_ctrl_dhcp_yes.GetCheck());

	m_ctrl_primary.EnableWindow(m_ctrl_dhcp_yes.GetCheck());
	m_ctrl_secondary.EnableWindow(m_ctrl_dhcp_yes.GetCheck());
	
	m_port_static1.LoadString(IDS_LAN_SETUP1);
	m_port_static2.LoadString(IDS_LAN_SETUP2);

	UpdateData(FALSE);
	CenterWindow();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIPDNLD::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_PROXY_IP_DNLD, HELP_CONTEXT);
}

BOOL CIPDNLD::ValidPortSettings()
{
	CDotDecimal DotValue;
	unsigned long addr1, addr2, mask1, mask2;

	DotValue = m_IPAddrStr;

	if (DotValue.IsEmpty())
		DotValue = ZeroIPAddress;

	if(m_ISPcheck)			// If ISP assigns we make it 0.0.0.0
		DotValue = ZeroIPAddress;
	else
	{
		if (!DotValue.IsValid())
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
					(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_IPAddrWnd.SetFocus() ;
			return FALSE ;
		}
	}

	if ( ! verify_ip_subnet_mask((LPCSTR)m_MskStr))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.\n\
Refer to help for more details",
			(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MskWnd.SetFocus() ;
		return FALSE ;
	}

	////Prabha, 11/3/98, validity of remote address
	if (m_PortListWnd.GetCurSel())
	{
		if (m_ras_enable.GetCheck())
		{
			if (!strcmp (m_remote_addr, ZeroIPAddress) || m_remote_addr.IsEmpty()) 
			{	// remote address is not given, DHCP client must be enabled
					::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Remote Address",
							(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_remote_addr.SetFocus() ;
					return FALSE ;
			}
			else
			{
				if (!m_remote_addr.IsValid())
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Remote Address",
							(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_remote_addr.SetFocus() ;
					return FALSE ;
				}
				if (!strcmp (m_remote_addr, m_IPAddr[0]))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses are same",
						(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_IPAddrWnd.SetFocus() ;
					return FALSE ;
				}
				get_ip_address (m_IPAddr[0], &addr1);
				get_ip_address (m_IPMask[0], &mask1);
				get_ip_address (m_remote_addr, &addr2);
				get_ip_address (m_MskStr, &mask2);
				if (addr2 && ((addr1 & mask1) != (addr2 & mask2)))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses should be in same network",
						(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_IPAddrWnd.SetFocus() ;
					return FALSE ;
				}
			}
		}
	}
	return TRUE ;
}

BOOL CIPDNLD::ValidEditFields()
{

	//makesure that the current edit controls have valid entries
	char Msg[80];
	UpdateData (TRUE);
	if (!ValidPortSettings())
		return FALSE;

	//Since the data is validated we need to put into the
	//local structs before we start writing out
	m_ISP[m_nOldPort] = m_ISPcheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;

	if (m_ras_enable.GetCheck())
		m_RAS[m_nOldPort] = 1;
	else
		m_RAS[m_nOldPort] = 0;
	m_RemoteAddr[m_nOldPort] = m_remote_addr;

	////Prabha 20/2/98, check the LAN and WAN addresses are not of the same
	////network.
	unsigned long addr1, addr2, mask1, mask2;
	get_ip_address (m_IPAddr[0], &addr1);
	get_ip_address (m_IPMask[0], &mask1);
	for (int index = 1; index < m_nPorts; index++)
	{
		get_ip_address (m_IPAddr[index], &addr2);
		get_ip_address (m_IPMask[index], &mask2);

		if ((addr1 & mask1) == (addr2 & mask2))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and WAN Addresses belong to the same net",
				(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_IPAddrWnd.SetFocus() ;
			return FALSE ;
		}
		if (m_RAS[index])
		{
			get_ip_address (m_RemoteAddr[index], &addr2);
			get_ip_address (m_IPMask[index], &mask2);
			if (addr2 && ((addr1 & mask1) != (addr2 & mask2)))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses should belong to the same net",
					(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_IPAddrWnd.SetFocus() ;
				return FALSE ;
			}

			CDotDecimal rem_addr;
			rem_addr = m_RemoteAddr[index];			
			if ((!rem_addr.IsValid() || rem_addr.IsEmpty()) && !m_check_client.GetCheck())
			{
				if ( FirstTimeInEdit == 1 )
				{
					sprintf(Msg, "Enter an IP Address for Remote Client on WAN %d\n\
or reconfigure & make sure to enable DHCP after downloading the setup", index);

					::MessageBox (GetSafeHwnd(), Msg,
						(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_PortListWnd.SetCurSel(index);	//Set the selection
					OnSelchangeListPorts();				//call the handler explict
					m_ctrl_remote_addr.SetFocus();	
					return FALSE;
				}
				else
				{
					sprintf(Msg, "No IP Address for Remote Client on WAN %d\n\
Make sure to reconfigure & enable DHCP after downloading the setup", index);
					::MessageBox (GetSafeHwnd(), Msg,
						(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				}
			}
		}
		for (int index2 = index+1; index2 < m_nPorts; index2++)
		{
			if (m_RAS[index] && m_RAS[index2])
			{
				if ((m_RemoteAddr[index] == m_RemoteAddr[index2])
					&& ( strcmp ( (LPCSTR)m_RemoteAddr[index],ZeroIPAddress ) != 0 ))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "The Remote addresses should not be similar",
						(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_remote_addr.SetFocus() ;
					return FALSE ;
				}
			}
		}
	}

	if (!m_primary_address.IsEmpty())
	{
		if ((m_primary_address != ZeroIPAddress) && !m_primary_address.IsValid())
		{
			wsprintf(Msg, "Invalid DNS Primary Address");
			::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPDnldMsgHeader, 
				MB_OK|MB_ICONEXCLAMATION);
			m_ctrl_primary.SetFocus();
			return FALSE;
		}
/* Jo 22/09/99 Check if Primary address is same as Secondary address */
			if (!m_secondary_address.IsEmpty()) 
			{
				if (m_primary_address == m_secondary_address)
				{
					wsprintf(Msg, "Invalid DNS Primary Address") ;
					::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPDnldMsgHeader, 
						MB_OK|MB_ICONEXCLAMATION) ;
					m_ctrl_primary.SetFocus() ;
					return FALSE ;
				}
			}
/* Jo 22/09/99 Check if Primary address is same as Secondary address */
	}

	if (!m_secondary_address.IsEmpty())
	{
		if ((m_secondary_address != ZeroIPAddress) && !m_secondary_address.IsValid())
		{
			wsprintf(Msg, "Invalid DNS Secondary Address");
			::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPDnldMsgHeader, 
				MB_OK|MB_ICONEXCLAMATION);
			m_ctrl_secondary.SetFocus();
			return FALSE;
		}
/* Jo 22/09/99 Check if Secondary address is same as Primary address */
			if (!m_primary_address.IsEmpty()) 
			{
				if (m_secondary_address == m_primary_address)
				{
					wsprintf(Msg, "Invalid DNS Secondary Address") ;
					::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPDnldMsgHeader, 
						MB_OK|MB_ICONEXCLAMATION) ;
					m_ctrl_secondary.SetFocus() ;
					return FALSE ;
				}
			}
/* Jo 22/09/99 Check if Secondary address is same as Primary address */
	}

   return TRUE;
}

void CIPDNLD::OnOK()
{
	// TODO: Add extra validation here
	int index;
	char	szRHS[128];
	char	szLHSAddr[50];
	char	szLHSMask[40];
	char szPPPRHS[128];
	ULONG int_ip_addr ;
	char Msg[50] ;

	if (!UpdateData(TRUE))	
		return;
	//Validate the current port's setup and copy them to internal variables
	//if error return

	if (!ValidPortSettings())
		return;
	index = m_PortListWnd.GetCurSel();
	m_ISP[index] = m_ISPcheck;
	m_IPAddr[index] = m_IPAddrStr;
	m_IPMask[index] = m_MskStr;

	if (m_ras_enable.GetCheck())
		m_RAS[index] = 1;
	else
		m_RAS[index] = 0;

	m_RemoteAddr[index] = m_remote_addr; 

	if (!index)	
	{
		m_RAS[index] = 0;
		m_RemoteAddr[index].Empty();
	}  

	if (!ValidEditFields())
	{
		FirstTimeInEdit = 0;
		return ;
	}
	//write the new values out into the ini file

	for (index = 0; index < m_nPorts; index++)
	{
		//Write IP Address
      get_cstring_to_ulong_ip_address(m_IPAddr[index], &int_ip_addr) ;
      ip_ptr->ip_ports[index].ip_address = int_ip_addr ;

		//If ISP assigned WAN address write 0.0.0.0 and
		// In PPP make local option negotiable
		if (index > 0)		//not for LAN port
		{
		 	if (m_ISP[index] == TRUE)
			{
				// PPP local address is 0.0.0.0 and negotiable
				ppp_ptr->ppp_ports[index-1].ipcp_ip_address.option_type = 3 ;
	  			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.Auto = 1 ;
				ppp_ptr->ppp_ports[index-1].ipcp_ip_address.NegNotReqd = 1 ;
	  			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.Negotiable = 1 ;
	  			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.value_type = IP ;
	  			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.valid = 1 ;
	         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ipcp_ip_address.option_value, "0.0.0.0") ;
			}
			else
			{
				// PPP local address is user assinged (non-0.0.0.0) and NOT negotiable
				ppp_ptr->ppp_ports[index-1].ipcp_ip_address.option_type = 3 ;
    			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.Auto = 1 ;
				ppp_ptr->ppp_ports[index-1].ipcp_ip_address.NegNotReqd = 1 ;
	  			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.Negotiable = 0 ;
	  			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.value_type = IP ;
	  			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.valid = 1 ;
	         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ipcp_ip_address.option_value, m_IPAddr[index]) ;
			}
	
			if (m_RAS[index] == TRUE)
			{	
				ppp_ptr->ppp_ports[index-1].remote_port_client_only = 1 ;
				if (m_RemoteAddr[index].IsEmpty())				
				{
					ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.option_type = 3 ;
   	 			ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.NegNotReqd = 1 ;
    				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.value_type = IP ;
	    			ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.valid = 1 ;
   	         strcpy ((char *)ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.option_value, ZeroIPAddress) ;
			
					ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.option_type = 3 ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.NegNotReqd = 1 ;
		    		ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.value_type = IP ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.valid = 1 ;
		         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.option_value, m_IPAddr[0]) ;
					
					ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.option_type = 3 ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.NegNotReqd = 1 ;
		    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.value_type = IP ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.valid = 1 ;
		         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.option_value, ZeroIPAddress) ;
						
			      ip_ptr->ip_ports[index].remote_ip_address = 0 ;
				}
				else
				{
					ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.option_type = 3 ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.NegNotReqd = 1 ;
		    		ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.value_type = IP ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.valid = 1 ;
		         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.option_value, m_IPAddr[0]) ;

					ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.option_type = 3 ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.NegNotReqd = 1 ;
		    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.value_type = IP ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.valid = 1 ;
		         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.option_value, m_RemoteAddr[index]) ;

					get_cstring_to_ulong_ip_address(m_RemoteAddr[index], &int_ip_addr) ;
			      ip_ptr->ip_ports[index].remote_ip_address = int_ip_addr ;
				}
			}
			else
			{
				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.option_type = 3 ;
  	 			ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.Auto = 1 ;
				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.NegNotReqd = 1 ;
  				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.Negotiable = 1 ;
  				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.value_type = IP ;
    			ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.valid = 1 ;
  	         strcpy ((char *)ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.option_value, ZeroIPAddress) ;
			 	
  				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.valid = 0 ;
  				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.valid = 0 ;
			   ip_ptr->ip_ports[index].remote_ip_address = 0 ;
				ppp_ptr->ppp_ports[index-1].remote_port_client_only = 0 ;
			}	
		}
		else		// the LAN IP address is to be copied into SNMP section also
		{
		}

		//write subnet mask for the port
	   get_cstring_to_ulong_ip_address (m_IPMask[index], &int_ip_addr) ;
      ip_ptr->ip_ports[index].subnet_mask =  int_ip_addr ;
	}
	
   get_cdotdecimal_to_ulong_ip_address (m_primary_address, &int_ip_addr) ;
   ip_ptr->ip_header.primary_address = int_ip_addr ;

	if (!m_primary_address.IsEmpty())
	{
		for (index = 1; index < m_nPorts; index++)
		{
	  		ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.valid = 0 ;
			
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.option_type = 129 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.Negotiable = 0 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.option_value, m_primary_address) ;
		}
	}
	else
	{
		for (index = 1; index < m_nPorts; index++)
		{
			ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.option_type = 129 ;
	   	ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.NegNotReqd = 1 ;
	   	ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.Negotiable = 1 ;
	   	ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.value_type = IP ;
	   	ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.valid = 1 ;
	      strcpy ((char *)ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.option_value, ZeroIPAddress) ;
		
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.option_type = 129 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.Negotiable = 0 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.option_value, ZeroIPAddress) ;
		} 
	}

   get_cdotdecimal_to_ulong_ip_address (m_secondary_address, &int_ip_addr) ;
   ip_ptr->ip_header.secondary_address = int_ip_addr ;
	if (!m_secondary_address.IsEmpty())
	{
		for (index = 1; index < m_nPorts; index++)
		{
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.valid = 0 ;

			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.option_type = 131 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.Negotiable = 0 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.option_value, m_secondary_address) ;
		}
	}	 	
	else
	{
		for (index = 1; index < m_nPorts; index++)
		{
			ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.option_type = 131 ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.Negotiable = 1 ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.valid = 1 ;
         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.option_value, ZeroIPAddress) ;

			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.option_type = 131 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.Negotiable = 0 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.option_value, ZeroIPAddress) ;
		}  
	}

	OnDhcpServerEnabled();

	CDialog::OnOK();
}

BOOL CIPDNLD::check_for_unique_entry_for_the_same_net(const char *IPAddr, const char *IPMask)
{
	int TagIndex = 0, index;
	unsigned long laddr1,mask1,naddr2,mask2;
	char szLHS[40];
	char szRHS[MAX_INI_OPTN_LEN*3];
	char LAddr[20], HAddr[20], Mask[20];
	
	CNF_DHCP_ADDRESS_RANGE *dhcp_address_range_ptr ;

	TagIndex = dhcp_header_ptr->number_of_address_range_entries ;

	for( index = 0; index < TagIndex; index++)
	{
		ULONG offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
		calculate_offset_of_dhcp_address_range_entries (&offset, index) ;
      dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;
	
		laddr1 = dhcp_address_range_ptr->lower_ip_address ;	   	
		mask1 = dhcp_address_range_ptr->address_mask ;
	
		get_ip_address (IPAddr, &naddr2);
		get_ip_address (IPMask, &mask2);

		if ((laddr1 & mask1) == (naddr2 & mask2))
		{
			dhcp_address_range_ptr->options_entries.router_address = naddr2 ;
			dhcp_address_range_ptr->options_entries.lease_time = 0x0000FFFF;
			
			return FALSE;
		}
	}
	return TRUE;
}

void CIPDNLD::OnCheckDhcp()
{
	// TODO: Add your control notification handler code here

}


void CIPDNLD::OnDhcpNo()
{
	// TODO: Add your control notification handler code here
	m_grp_dns.EnableWindow(FALSE);
	m_static_primary.EnableWindow(FALSE);
	m_static_secondary.EnableWindow(FALSE);

	m_ctrl_primary.EnableWindow(FALSE);
	m_ctrl_secondary.EnableWindow(FALSE);
	
}

void CIPDNLD::OnDhcpYes()
{
	// TODO: Add your control notification handler code here
	m_grp_dns.EnableWindow(TRUE);
	m_static_primary.EnableWindow(TRUE);
	m_static_secondary.EnableWindow(TRUE);

	m_ctrl_primary.EnableWindow(TRUE);
	m_ctrl_secondary.EnableWindow(TRUE);
		
}

void CIPDNLD::OnDhcpServerEnabled()
{
	// TODO: Add your control notification handler code here

	int TagIndex;
	char szRHS[MAX_INI_OPTN_LEN*3];
	char LAddr[20], HAddr[20] ;
	unsigned long addr1, addr2, addr3, addr4,laddr1,haddr1, gaddr ;

	ULONG offset, return_offset, int_ip_addr ;
	CNF_BINDING_INFO *dhcp_binding_ptr ;
	CNF_DHCP_ADDRESS_RANGE *dhcp_address_range_ptr ;
	
	int ptmp;

	TagIndex = ip_ptr->ip_header.number_of_ports ; 
	if (m_ctrl_dhcp_yes.GetCheck())
/* Sachin, Oct. 4th, 1997 */
	{
		ptmp = 1 ;
		for (int index = 0; index < TagIndex; index++)
		   ip_ptr->ip_ports[index].bootp = ptmp	;
	}
	else
	{
		ptmp = 0 ;
		for (int index = 0; index < TagIndex; index++)
		   ip_ptr->ip_ports[index].bootp = ptmp	;

	}
	dhcp_header_ptr->dhcp_server_enabled = ptmp ;

	addr1 = addr2 = addr3 = addr4 = 0L ;
	laddr1 = haddr1 = gaddr = 0L ;

	get_ip_address(m_IPAddr[0], &gaddr);

	TagIndex = dhcp_header_ptr->number_of_address_range_entries ;

   offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
	calculate_offset_of_dhcp_address_range_entries (&offset, TagIndex - 1) ;
   dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;

	sscanf (m_IPAddr[0], "%03u.%03u.%03u.%03u", &addr1, &addr2, &addr3, &addr4) ;

	if ( addr4 > 150 )
	{
		laddr1 = 1;
		haddr1 = 100;
	}
	else
	{
		laddr1 = addr4 + 3;
		haddr1 = addr4 + 100;
	}

	LAddr[0] = 0;
	HAddr[0] = 0;

	sprintf(LAddr,"%lu.%lu.%lu.%lu",addr1,addr2,addr3,laddr1);
	sprintf(HAddr,"%lu.%lu.%lu.%lu",addr1,addr2,addr3,haddr1);

//Write the TagString first
	get_ip_address (HAddr, &addr1) ;
	dhcp_address_range_ptr->higher_ip_address = addr1 ;
	get_ip_address (LAddr, &addr1) ;
	dhcp_address_range_ptr->lower_ip_address = addr1 ;
   get_cstring_to_ulong_ip_address(m_IPMask[0], &addr1) ;
	dhcp_address_range_ptr->address_mask = addr1 ;

	dhcp_address_range_ptr->exclude_lower_ip_address = 0 ;
	dhcp_address_range_ptr->exclude_higher_ip_address = 0 ;

//write properties next
	dhcp_address_range_ptr->options_entries.router_address = gaddr ;
	dhcp_address_range_ptr->options_entries.lease_time = 0x0000FFFF ;

	dhcp_address_range_ptr->number_of_bindings_entries = 0 ;

#if 0
	if(check_for_unique_entry_for_the_same_net(m_IPAddr[0],m_IPMask[0]) == TRUE)
	{
		ULONG temp_no_addr_range_entries = dhcp_header_ptr->number_of_address_range_entries ;
		dhcp_header_ptr->number_of_address_range_entries += 1 ;

	  	ULONG SizeToRealloc = (dhcp_header_ptr->section_length + (sizeof(CNF_DHCP_ADDRESS_RANGE) * (dhcp_header_ptr->number_of_address_range_entries - temp_no_addr_range_entries))) ;
		all_structures[DHCP_ID].glblck = GlobalReAlloc (all_structures[DHCP_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[DHCP_ID].ptr_to_struct = GlobalLock (all_structures[DHCP_ID].glblck) ;
		all_structures[DHCP_ID].size_of_struct = (USHORT) SizeToRealloc ;
		dhcp_header_ptr = (CNF_DHCP_HEADER *) all_structures[DHCP_ID].ptr_to_struct ;
		dhcp_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
		calculate_offset_of_dhcp_address_range_entries (&offset,temp_no_addr_range_entries - 1 ) ;
	   	dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;

		sscanf (m_IPAddr[0], "%03u.%03u.%03u.%03u", &addr1, &addr2, &addr3, &addr4) ;

		if ( addr4 > 150 )
		{
			laddr1 = 1;
			haddr1 = 100;
		}
		else
		{
			laddr1 = addr4 + 3;
			haddr1 = addr4 + 100;
		}

		LAddr[0] = 0;
		HAddr[0] = 0;

		sprintf(LAddr,"%lu.%lu.%lu.%lu",addr1,addr2,addr3,laddr1);
		sprintf(HAddr,"%lu.%lu.%lu.%lu",addr1,addr2,addr3,haddr1);

//Write the TagString first
		get_ip_address (HAddr, &addr1) ;
		dhcp_address_range_ptr->higher_ip_address = addr1 ;
		get_ip_address (LAddr, &addr1) ;
		dhcp_address_range_ptr->lower_ip_address = addr1 ;
                get_cstring_to_ulong_ip_address(m_IPMask[0], &addr1) ;
		dhcp_address_range_ptr->address_mask = addr1 ;

		dhcp_address_range_ptr->exclude_lower_ip_address = 0 ;
		dhcp_address_range_ptr->exclude_higher_ip_address = 0 ;

//write properties next
		dhcp_address_range_ptr->options_entries.router_address = gaddr ;
		dhcp_address_range_ptr->options_entries.lease_time = 0x0000FFFF ;

		dhcp_address_range_ptr->number_of_bindings_entries = 0 ;

	}
#endif

	return;
}

void CIPDNLD::OnCancel()
{
	// TODO: Add your control notification handler code here
	CDialog::OnCancel();	
}
