// ipprx.cpp : implementation file
//
// Jyothi 1/6/98 :  made changes for small proxy
// Jyothi 1/6/98 :  structures used instead of INI files

#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "iproutes.h"
#include "maskdot.h"
#include "ipprx.h"
#include "hardware.h"
#include "cnffile.h"
#include "readbmp.h"

char	*IPMsgHeader="IP Setup";
LPCSTR IPSectionHeader ="IP Routing" ;
LPCSTR DHCPSectionHeader = "DHCP" ;
extern LPCSTR TNETSectionHeader;

extern BOOL DefaultSetup ; /* Jo 13/11/98 */

#define MIN_DEFAULT_TTL			0
#define MAX_DEFAULT_TTL			255
#define MIN_REASSM_TMOUT		1
#define MAX_REASSM_TMOUT		100


/* Jo 1/6/98 */

extern CNF_IP *ip_ptr ;
extern CNF_PPP *ppp_ptr ;
extern CNF_DHCP_HEADER  *dhcp_header_ptr ;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ipprx dialog


ipprx::ipprx(CWnd* pParent /*=NULL*/)
	: CDialog(ipprx::IDD, pParent)
{
	//{{AFX_DATA_INIT(ipprx)
	m_ISPCheck = FALSE;
	m_MskStr = "";
	m_GwayStr = "";
	m_nDefaultTTL = 0;
	m_IPAddrStr = "";
	m_primary_address = "";
	m_secondary_address = "";
	m_remote_address = "";
	m_server_address = "";
	m_nReassemTimeout = 0;
	//}}AFX_DATA_INIT
}

void ipprx::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ipprx)
	DDX_Control(pDX, IDC_BUTTON_STAT_HOST, m_static_routes);
	DDX_Control(pDX, IDC_STATIC_OTHER, m_other_setup);
	DDX_Control(pDX, IDC_STATIC_DHCP, m_static_dhcp);
	DDX_Control(pDX, IDC_EDIT_SERVER_ADDRESS, m_ctrl_server_address);
	DDX_Control(pDX, IDC_EDIT_REMOTE_ADDRESS, m_ctrl_remote_address);
	DDX_Control(pDX, IDC_STATIC_SERVER_ADDRESS, m_static_server_address);
	DDX_Control(pDX, IDC_CHECK_CLIENT, m_check_client);
	DDX_Control(pDX, IDC_STATIC_REMOTE_ADDRESS, m_static_remote_address);
	DDX_Control(pDX, IDC_CHECK_RAS, m_ras_enable);
	DDX_Control(pDX, IDC_STATIC_SECONDARY_ADDRESS, m_ctrl_static_secondary_address);
	DDX_Control(pDX, IDC_STATIC_PRIMARY_ADDRESS, m_ctrl_static_primary_address);
	DDX_Control(pDX, IDC_EDIT_SECONDARY_ADDRESS, m_ctrl_secondary_address);
	DDX_Control(pDX, IDC_EDIT_PRIMARY_ADDRESS, m_ctrl_primary_address);
	DDX_Control(pDX, IDC_STATIC_MASK, m_staticMskWnd);
	DDX_Control(pDX, IDC_LIST_PORTS, m_PortListWnd);
	DDX_Control(pDX, IDC_STATIC_SEL_PORT, m_SelPortGrp);
	DDX_Control(pDX, IDC_STATIC_ADDR, m_IPHdrWnd);
	DDX_Control(pDX, IDC_EDIT_REASSM, m_RTOWnd);
	DDX_Control(pDX, IDC_EDIT_TTL, m_TTLWnd);
	DDX_Control(pDX, IDC_EDIT_GATEWAY, m_GwayWnd);
	DDX_Control(pDX, IDC_EDIT_MSK, m_MskWnd);
	DDX_Control(pDX, IDC_EDIT_IP_ADDR, m_IPAddrWnd);
	DDX_Control(pDX, IDC_CHECK_IP_ADDR, m_ISPWnd);
	DDX_Check(pDX, IDC_CHECK_IP_ADDR, m_ISPCheck);
	DDX_Text(pDX, IDC_EDIT_MSK, m_MskStr);
	DDX_Text(pDX, IDC_EDIT_GATEWAY, m_GwayStr);
	DDX_Text(pDX, IDC_EDIT_TTL, m_nDefaultTTL);
	DDX_Text(pDX, IDC_EDIT_IP_ADDR, m_IPAddrStr);
	DDX_Text(pDX, IDC_EDIT_PRIMARY_ADDRESS, m_primary_address);
	DDX_Text(pDX, IDC_EDIT_SECONDARY_ADDRESS, m_secondary_address);
	DDX_Text(pDX, IDC_EDIT_REMOTE_ADDRESS, m_remote_address);
	DDX_Text(pDX, IDC_EDIT_SERVER_ADDRESS, m_server_address);
	DDX_Text(pDX, IDC_EDIT_REASSM, m_nReassemTimeout);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(ipprx, CDialog)
	//{{AFX_MSG_MAP(ipprx)
	ON_BN_CLICKED(IDC_CHECK_IP_ADDR, OnCheckIpAddr)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_LBN_SELCHANGE(IDC_LIST_PORTS, OnSelchangeListPorts)
	ON_BN_CLICKED(IDC_CHECK_RAS, OnCheckRas)
	ON_BN_CLICKED(IDC_CHECK_CLIENT, OnCheckClient) 
	ON_BN_CLICKED(IDC_BUTTON_STAT_HOST, OnButtonStatHost)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// ipprx message handlers

void ipprx::OnCheckIpAddr()
{
	// TODO: Add your control notification handler code here

	if (m_ISPWnd.GetCheck())	// Get the status of check button
	{
		UpdateData(TRUE);			//Get the dialog updates
		m_IPAddrWnd.EnableWindow(FALSE);
		m_IPHdrWnd.EnableWindow(FALSE);
		if (m_PortListWnd.GetCurSel() != 0)
		{
			m_staticMskWnd.EnableWindow(FALSE);
			m_MskWnd.EnableWindow(FALSE);
		}
		m_IPAddrStr = ZeroIPAddress; //reset address
		UpdateData(FALSE);		//display data in dialog
	}
	else
	{
		m_IPHdrWnd.EnableWindow(TRUE);
		m_IPAddrWnd.EnableWindow(TRUE);
		m_staticMskWnd.EnableWindow(TRUE);
		m_MskWnd.EnableWindow(TRUE);
	}
}

BOOL ipprx::OnInitDialog()
{
	CDialog::OnInitDialog();
////////////////////////////////////////////////////////////////////////////
	CenterWindow();
	/* Change the title of the dialog as usual */
	{
		char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

		GetWindowText (CurrentHeading, 80) ;
		SubHeadingPointer = strchr (CurrentHeading, '-') ;
		if (SubHeadingPointer == NULL)
			SubHeadingPointer = CurrentHeading ;
		else
			SubHeadingPointer += 2 ;

		sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);

		SetWindowText (WindowHeader) ;
	}
////////////////////////////////////////////////////////////////////////////

	if (!FiltBitmapBtn.LoadBitmaps ("FILT1", "FILT2", "FILT3", "FILT4"))
		AfxMessageBox ("Failed to load Filtering bitmap");

	VERIFY (FiltBitmapBtn.SubclassDlgItem (IDC_FILTERING, this));
	FiltBitmapBtn.SizeToContent();

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	if (!StaticBitmapBtn.LoadBitmaps ("STATIC1", "STATIC2", "STATIC3", "STATIC4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (StaticBitmapBtn.SubclassDlgItem (IDC_BUTTON_STAT_HOST, this));
	StaticBitmapBtn.SizeToContent();

	// Read the configuration file and init the variables
	int	index;
	char	szRHS[40];
	CDotDecimal DotValue;
   char    temp_dot_value[20] ; 

   m_nPorts = ip_ptr->ip_header.number_of_ports ;

	if (m_nPorts > MAX_NUM_PORTS)
		m_nPorts = MAX_NUM_PORTS;

/* Jo 23/06/99 Added for RAS */
	
	m_MLPPP = ppp_ptr->ppp_ports[0].lcp_epd.valid ;

	for (index = 0; index < m_nPorts; index++)
	{
		//Get IP address of the port

      get_dot_decimal_ip_address (ip_ptr->ip_ports[index].ip_address, temp_dot_value) ;
		DotValue = m_IPAddr[index] = temp_dot_value ;
		if ( ! DotValue.IsValid())
			m_IPAddr[index] = ZeroIPAddress ;

		//If IP address == 0.0.0.0 then it is ISP assigned
		m_ISP[index] = FALSE;
		if (index > 0)		//not for LAN port
			if ( ! strcmp((LPCSTR)m_IPAddr[index], ZeroIPAddress))
				m_ISP[index] = TRUE;

		//Get subnet mask for the port

		get_dot_decimal_ip_address (ip_ptr->ip_ports[index].subnet_mask, temp_dot_value) ;
      m_IPMask[index] = temp_dot_value ;
		if ( ! verify_ip_subnet_mask((LPCSTR)m_IPMask[index]))
			m_IPMask[index] = ZeroIPAddress;

/* Jo 23/06/99 Added for RAS */

		m_RAS[index] = 0;
		if ((index > 0) && !m_MLPPP)
			m_RAS[index] = ppp_ptr->ppp_ports[index-1].remote_port_client_only ;

		get_dot_decimal_ip_address (ip_ptr->ip_ports[index].remote_ip_address, temp_dot_value) ;
		m_RemoteAddr[index] = temp_dot_value ;

/* Jo 23/06/99 Added for RAS */
	}

/* Jo 13/11/98 */
	if ( DefaultSetup == TRUE )
	{
		RECT FullRect ;
		RECT ClipRect ;
		
		GetWindowRect (&FullRect) ;
		m_other_setup.GetWindowRect (&ClipRect) ;
		FullRect.bottom = ClipRect.top ;
		MoveWindow (&FullRect, TRUE) ;

		m_other_setup.EnableWindow ( FALSE  ) ;

//		m_GwayWnd.EnableWindow (FALSE) ;
		m_TTLWnd.EnableWindow (FALSE) ;
		m_RTOWnd.EnableWindow (FALSE) ;
		m_ctrl_primary_address.EnableWindow (FALSE) ;
		m_ctrl_secondary_address.EnableWindow (FALSE) ;
		m_ctrl_static_primary_address.EnableWindow (FALSE) ;
		m_ctrl_static_secondary_address.EnableWindow (FALSE) ;
		m_check_client.EnableWindow (FALSE) ;
		m_static_server_address.EnableWindow (FALSE) ;
		m_ctrl_server_address.EnableWindow (FALSE) ;
		m_static_dhcp.EnableWindow (FALSE) ;
	}

	//Readin the other information

//	get_dot_decimal_ip_address (ip_ptr->ip_header.default_gateway, temp_dot_value) ;
//	DotValue = m_GwayStr = temp_dot_value ; 
//	if (!DotValue.IsEmpty() && !DotValue.IsValid())
//		m_GwayStr= "" ;
	m_nDefaultMetric = 1 ; // Jo If not provided, default to 1

	if (ip_ptr->ip_header.primary_address)
	{
		get_dot_decimal_ip_address (ip_ptr->ip_header.primary_address, temp_dot_value) ;
	   m_primary_address = temp_dot_value ;
	}
	else
	   m_primary_address = "" ;

	if (ip_ptr->ip_header.secondary_address)
	{
		get_dot_decimal_ip_address (ip_ptr->ip_header.secondary_address, temp_dot_value) ;
	   m_secondary_address = temp_dot_value ;
	}
	else
	   m_secondary_address = "" ;

/* Jo 23/06/99 Added for DHCP Client */

	if (dhcp_header_ptr->dhcp_client_enabled)
	{
		m_check_client.SetCheck(1);
	 	get_dot_decimal_ip_address (dhcp_header_ptr->dhcp_server_ip_address, temp_dot_value) ;
		m_server_address = temp_dot_value ;
	}	
	else
	{
		m_check_client.SetCheck(0);
		m_static_server_address.EnableWindow (FALSE);
		m_ctrl_server_address.EnableWindow (FALSE);
	}	

/* Jo 23/06/99 Added for DHCP Client */

	//Add items into the port list
 	m_PortListWnd.AddString("LAN");
	if (m_nPorts > 2)
	{
		strcpy(szRHS, "WAN 1");
		for (index = 0; index < m_nPorts-1; index++)
		{
			m_PortListWnd.AddString(szRHS);
			szRHS[4]++;	//next port name
		}
	}
	else
	{
	 	m_PortListWnd.AddString("WAN");
	}
	//Set current selection as LAN
	m_nOldPort = 0;
	m_PortListWnd.SetCurSel(m_nOldPort);

	//Set the other port dependent parameters to be of LAN
	m_IPAddrStr = m_IPAddr[m_nOldPort];
 	m_MskStr = m_IPMask[m_nOldPort];
	m_ISPCheck = m_ISP[m_nOldPort];
	m_ISPWnd.EnableWindow(FALSE);
	m_SelPortGrp.SetWindowText("LAN");
	m_ras_enable.EnableWindow (FALSE) ;
	m_ctrl_remote_address.EnableWindow (FALSE) ;
	m_static_remote_address.EnableWindow (FALSE) ; 
	UpdateData(FALSE) ;
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

void ipprx::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_PROXY_IP, HELP_CONTEXT);
	
}

BOOL ipprx::ValidPortSettings()
{
	CDotDecimal DotValue;

	DotValue = m_IPAddrStr;

	if (DotValue.IsEmpty())
		DotValue = ZeroIPAddress;

	if(m_ISPCheck)			// If ISP assigns we make it 0.0.0.0
		DotValue = ZeroIPAddress;
	else
	{
		if (!DotValue.IsValid())
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_IPAddrWnd.SetFocus() ;
			return FALSE ;
		}
	}

	if ( ! verify_ip_subnet_mask((LPCSTR)m_MskStr))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.\n\
Refer to help for more details",
			(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MskWnd.SetFocus() ;
		return FALSE ;
	}

/* Jo 23/06/99 Added for RAS */

	////Prabha, 11/3/98, validity of remote address
	if (m_PortListWnd.GetCurSel())
	{
		if (m_ras_enable.GetCheck())
		{
			if (!strcmp (m_remote_address, ZeroIPAddress) || m_remote_address.IsEmpty()) 
			{	// remote address is not given, DHCP client must be enabled
				if (!m_check_client.GetCheck())
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "Need IP address or DHCP client enabled",
							(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_remote_address.SetFocus() ;
					return FALSE ;
				}
			}
			else
			{
				if (!m_remote_address.IsValid())
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Remote Address",
							(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_remote_address.SetFocus() ;
					return FALSE ;
				}
				if (!strcmp (m_remote_address, m_IPAddr[0]))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses are same",
						(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_IPAddrWnd.SetFocus() ;
					return FALSE ;
				}
				unsigned long addr1, addr2, mask1, mask2;
				get_ip_address (m_IPAddr[0], &addr1);
				get_ip_address (m_IPMask[0], &mask1);
				get_ip_address (m_remote_address, &addr2);
				get_ip_address (m_MskStr, &mask2);
				if (addr2 && ((addr1 & mask1) != (addr2 & mask2)))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses should be in same network",
						(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_IPAddrWnd.SetFocus() ;
					return FALSE ;
				}
			}
		}
	}
/* Jo 23/06/99 Added for RAS */
	return TRUE ;
}

BOOL ipprx::ValidEditFields()
{

	//makesure that the current edit controls have valid entries
	char Msg[80];
	UpdateData (TRUE);
	if (!ValidPortSettings())
		return FALSE;

	//Since the data is validated we need to put into the
	//local structs before we start writing out
	m_ISP[m_nOldPort] = m_ISPCheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;

/* Jo 23/06/99 Added for RAS */
	if (m_ras_enable.GetCheck())
		m_RAS[m_nOldPort] = 1;
	else
		m_RAS[m_nOldPort] = 0;
	m_RemoteAddr[m_nOldPort] = m_remote_address;
/* Jo 23/06/99 Added for RAS */

	////Prabha 20/2/98, check the LAN and WAN addresses are not of the same
	////network.
	unsigned long addr1, addr2, mask1, mask2;
	get_ip_address (m_IPAddr[0], &addr1);
	get_ip_address (m_IPMask[0], &mask1);
	for (int index = 1; index < m_nPorts; index++)
	{
		get_ip_address (m_IPAddr[index], &addr2);
		get_ip_address (m_IPMask[index], &mask2);

		if ((addr1 & mask1) == (addr2 & mask2))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and WAN Addresses belong to the same net",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_IPAddrWnd.SetFocus() ;
			return FALSE ;
		}

/* Jo 23/06/99 Added for RAS */
		if (m_RAS[index])
		{
			get_ip_address (m_RemoteAddr[index], &addr2);
			get_ip_address (m_IPMask[index], &mask2);
			if (addr2 && ((addr1 & mask1) != (addr2 & mask2)))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses should belong to the same net",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_IPAddrWnd.SetFocus() ;
				return FALSE ;
			}

			CDotDecimal rem_addr;
			rem_addr = m_RemoteAddr[index];			
			if ((!rem_addr.IsValid() || rem_addr.IsEmpty()) && !m_check_client.GetCheck())
			{
				sprintf(Msg, "Remote Client on WAN %d needs an IP Address.\n\
Enter an IP Address or enable DHCP", index);

				::MessageBox (GetSafeHwnd(), Msg,
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_PortListWnd.SetCurSel(index);	//Set the selection
				OnSelchangeListPorts();				//call the handler explict
				m_ctrl_remote_address.SetFocus();	
				return FALSE;
			}
		}
		if (m_check_client.GetCheck())
		{
		  if (m_server_address.IsEmpty() || !m_server_address.IsValid())
		  {
		  		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid DHCP server address",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_ctrl_server_address.SetFocus();
				return FALSE;
			}
			if (m_server_address == m_IPAddr[0])
			{
		  		::MessageBox (GetSafeHwnd(), (LPCSTR) "DHCP Server and LAN Address must be different",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_ctrl_server_address.SetFocus();
				return FALSE;
			}
		}
		for (int index2 = index+1; index2 < m_nPorts; index2++)
		{
			if (m_RAS[index] && m_RAS[index2])
				if ((!m_check_client.GetCheck()) && (m_RemoteAddr[index] == m_RemoteAddr[index2]))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "The Remote addresses should not be similar",
						(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_remote_address.SetFocus() ;
					return FALSE ;
				}
		}
/* Jo 23/06/99 Added for RAS */
	}

   if ( DefaultSetup != TRUE )
   {
		CDotDecimal DotValue;
#if 0 /* Jo 31/08 For removing Gateway */
		DotValue = m_GwayStr;

		if ( ! DotValue.IsValid())
		{
			if (DotValue != ZeroIPAddress)
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid gateway address",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_GwayWnd.SetFocus() ;
				return FALSE ;
			}
		}
		//Check to see that the gateway address, if entered
		//is in the same network as the LAN
		if (DotValue != ZeroIPAddress)
		{
			DWORD LANIPAddress, GWAYIPAddress, NETMask;
			get_ip_address((LPCSTR) m_IPAddr[0], &LANIPAddress);
			get_ip_address((LPCSTR) m_IPMask[0], &NETMask);
			get_ip_address((LPCSTR) m_GwayStr, &GWAYIPAddress);
			if ((LANIPAddress & NETMask) != (GWAYIPAddress & NETMask))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN port IP address and Gateway \
					IP address\nmust be in the same IP network", 
						(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_GwayWnd.SetFocus() ;
				return FALSE ;
			}
			if (LANIPAddress == GWAYIPAddress)
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Gateway IP address must \
					point to another\nhost or router on the same IP network",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_GwayWnd.SetFocus() ;
				return FALSE ;
			}
		}
		if (m_GwayStr.IsEmpty())
			m_GwayStr = ZeroIPAddress;
#endif  /* Jo 31/08 For removing Gateway */
			
		if (!m_primary_address.IsEmpty())
		{
			if ((m_primary_address != ZeroIPAddress) && !m_primary_address.IsValid())
			{
				wsprintf(Msg, "Invalid DNS Primary Address");
				::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPMsgHeader, 
					MB_OK|MB_ICONEXCLAMATION);
				m_ctrl_primary_address.SetFocus();
				return FALSE;
			}
/* Jo 22/09/99 Check if Primary address is same as Secondary address */
			if (!m_secondary_address.IsEmpty()) 
			{
				if (m_primary_address == m_secondary_address)
				{
					wsprintf(Msg, "Invalid DNS Primary Address") ;
					::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPMsgHeader, 
						MB_OK|MB_ICONEXCLAMATION) ;
					m_ctrl_primary_address.SetFocus() ;
					return FALSE ;
				}
			}
/* Jo 22/09/99 Check if Primary address is same as Secondary address */
		}
		if (!m_secondary_address.IsEmpty())
		{
			if ((m_secondary_address != ZeroIPAddress) && !m_secondary_address.IsValid())
			{
				wsprintf(Msg, "Invalid DNS Secondary Address");
				::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPMsgHeader, 
					MB_OK|MB_ICONEXCLAMATION);
				m_ctrl_secondary_address.SetFocus();
				return FALSE;
			}
/* Jo 22/09/99 Check if Secondary address is same as Primary address */
			if (!m_primary_address.IsEmpty()) 
			{
				if (m_secondary_address == m_primary_address)
				{
					wsprintf(Msg, "Invalid DNS Secondary Address") ;
					::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPMsgHeader, 
						MB_OK|MB_ICONEXCLAMATION) ;
					m_ctrl_secondary_address.SetFocus() ;
					return FALSE ;
				}
			}
/* Jo 22/09/99 Check if Secondary address is same as Primary address */
		}
	}
   return TRUE;
}

void ipprx::OnOK()
{
	// TODO: Add extra validation here
	int index;
	char	szRHS[128];
	char	szLHSAddr[50];
	char	szLHSMask[40];
	char szPPPRHS[128];
	ULONG int_ip_addr ;

	if (!UpdateData(TRUE))	
		return;
	//Validate the current port's setup and copy them to internal variables
	//if error return

	if (!ValidPortSettings())
		return;
	index = m_PortListWnd.GetCurSel();
	m_ISP[index] = m_ISPCheck;
	m_IPAddr[index] = m_IPAddrStr;
	m_IPMask[index] = m_MskStr;

/* Jo 23/06/99 Added for RAS */

	if (m_ras_enable.GetCheck())
		m_RAS[index] = 1;
	else
		m_RAS[index] = 0;
	m_RemoteAddr[index] = m_remote_address; 

	if (!index)	
	{
		m_RAS[index] = 0;
		m_RemoteAddr[index].Empty();
	}  

	if (!ValidEditFields())
		return ;

	//write the new values out into the ini file

	for (index = 0; index < m_nPorts; index++)
	{
		//Write IP Address
		get_cstring_to_ulong_ip_address(m_IPAddr[index], &int_ip_addr) ;
      ip_ptr->ip_ports[index].ip_address = int_ip_addr ;

		//If ISP assigned WAN address write 0.0.0.0 and
		// In PPP make local option negotiable
		if (index > 0)		//not for LAN port
		{
		 	if (m_ISP[index] == TRUE)
			{
				ip_ptr->ip_ports[index].isp_assigns_address = 1 ;
				// PPP local address is 0.0.0.0 and negotiable
				ppp_ptr->ppp_ports[index-1].ipcp_ip_address.option_type = 3 ;
    			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.Auto = 1 ;
				ppp_ptr->ppp_ports[index-1].ipcp_ip_address.NegNotReqd = 1 ;
    			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.Negotiable = 1 ;
    			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.value_type = IP ;
    			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.valid = 1 ;
            strcpy ((char *)ppp_ptr->ppp_ports[index-1].ipcp_ip_address.option_value, ZeroIPAddress) ;
			}
			else
			{
				ip_ptr->ip_ports[index].isp_assigns_address = 0 ;

				// PPP local address is user assinged (non-0.0.0.0) and NOT negotiable
				ppp_ptr->ppp_ports[index-1].ipcp_ip_address.option_type = 3 ;
    			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.Auto = 1 ;
				ppp_ptr->ppp_ports[index-1].ipcp_ip_address.NegNotReqd = 1 ;
    			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.Negotiable = 0 ;
    			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.value_type = IP ;
    			ppp_ptr->ppp_ports[index-1].ipcp_ip_address.valid = 1 ;
            strcpy ((char *)ppp_ptr->ppp_ports[index-1].ipcp_ip_address.option_value, m_IPAddr[index]) ;
			}

/* Jo 23/06/99 Added for RAS */

			if (m_RAS[index] == TRUE)
			{	
				if (m_RemoteAddr[index].IsEmpty())				
				{
					ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.option_type = 3 ;
   	 			ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.NegNotReqd = 1 ;
    				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.value_type = IP ;
	    			ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.valid = 1 ;
   	         strcpy ((char *)ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.option_value, ZeroIPAddress) ;

					ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.option_type = 3 ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.NegNotReqd = 1 ;
		    		ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.value_type = IP ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.valid = 1 ;
		         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.option_value, m_IPAddr[0]) ;

					ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.option_type = 3 ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.NegNotReqd = 1 ;
		    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.value_type = IP ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.valid = 1 ;
		         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.option_value, ZeroIPAddress) ;

			      ip_ptr->ip_ports[index].remote_ip_address = 0 ;
				}
				else
				{
					ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.option_type = 3 ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.NegNotReqd = 1 ;
		    		ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.value_type = IP ;
    				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.valid = 1 ;
		         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.option_value, m_IPAddr[0]) ;

					ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.option_type = 3 ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.Auto = 1 ;
					ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.NegNotReqd = 1 ;
		    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.Negotiable = 1 ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.value_type = IP ;
    				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.valid = 1 ;
		         strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.option_value, m_RemoteAddr[index]) ;


					get_cstring_to_ulong_ip_address(m_RemoteAddr[index], &int_ip_addr) ;
			      ip_ptr->ip_ports[index].remote_ip_address = int_ip_addr ;
				}
			}
			else
			{
				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.option_type = 3 ;
  	 			ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.Auto = 1 ;
				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.NegNotReqd = 1 ;
  				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.Negotiable = 1 ;
  				ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.value_type = IP ;
    			ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.valid = 1 ;
  	         strcpy ((char *)ppp_ptr->ppp_ports[index-1].remote_ipcp_ip_address.option_value, ZeroIPAddress) ;

  				ppp_ptr->ppp_ports[index-1].ras_ipcp_ip_address.valid = 0 ;
  				ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_ip_address.valid = 0 ;
				
			   ip_ptr->ip_ports[index].remote_ip_address = 0 ;
			}
		}
		else		// the LAN IP address is to be copied into SNMP section also
		{
		}

		//write subnet mask for the port
      get_cstring_to_ulong_ip_address (m_IPMask[index], &int_ip_addr) ;
      ip_ptr->ip_ports[index].subnet_mask =  int_ip_addr ;
	}

/* Jo 23/06/99 Added for RAS */

   if ( DefaultSetup != TRUE )
   {
		if (m_check_client.GetCheck())
		{	
			dhcp_header_ptr->dhcp_client_enabled = 1 ;
			get_cdotdecimal_to_ulong_ip_address (m_server_address, &int_ip_addr) ;
			dhcp_header_ptr->dhcp_server_ip_address = int_ip_addr ;

			for (index = 0; index < m_nPorts; index++)
				ip_ptr->ip_ports[index].bootp = 1 ;				
		}
		else
		{
			dhcp_header_ptr->dhcp_client_enabled = 0 ;
			dhcp_header_ptr->dhcp_server_ip_address = 0 ;
			if (dhcp_header_ptr->dhcp_server_enabled == 0)
			{
				for (index = 0; index < m_nPorts; index++)
					ip_ptr->ip_ports[index].bootp = 0 ;	
			}			
		}
/* Jo 23/06/99 Added for RAS */

//	get_cstring_to_ulong_ip_address(m_GwayStr, &int_ip_addr) ;
//   ip_ptr->ip_header.default_gateway = int_ip_addr ;

   get_cdotdecimal_to_ulong_ip_address (m_primary_address, &int_ip_addr) ;
   ip_ptr->ip_header.primary_address = int_ip_addr ;

	if (!m_primary_address.IsEmpty())
	{
		for (index = 1; index < m_nPorts; index++)
		{
	    	ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.valid = 0 ;

/* Jo 23/06/99 Added for RAS */
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.option_type = 129 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.Negotiable = 0 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.option_value, m_primary_address) ;
/* Jo 23/06/99 Added for RAS */
		}
	}
	else
	{
		for (index = 1; index < m_nPorts; index++)
		{
			ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.option_type = 129 ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.Negotiable = 1 ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index-1].ipcp_dns_address1.option_value, ZeroIPAddress) ;

/* Jo 23/06/99 Added for RAS */
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.option_type = 129 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.Negotiable = 0 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address1.option_value, ZeroIPAddress) ;
/* Jo 23/06/99 Added for RAS */
			
		} 
	}

   get_cdotdecimal_to_ulong_ip_address (m_secondary_address, &int_ip_addr) ;
   ip_ptr->ip_header.secondary_address = int_ip_addr ;
	if (!m_secondary_address.IsEmpty())
	{
		for (index = 1; index < m_nPorts; index++)
		{
	    	ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.valid = 0 ;

/* Jo 23/06/99 Added for RAS */
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.option_type = 131 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.Negotiable = 0 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.option_value, m_secondary_address) ;
/* Jo 23/06/99 Added for RAS */
		}
	}	 	
	else
	{
		for (index = 1; index < m_nPorts; index++)
		{
			ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.option_type = 131 ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.Negotiable = 1 ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.valid = 1 ;
	      strcpy ((char *)ppp_ptr->ppp_ports[index-1].ipcp_dns_address2.option_value, ZeroIPAddress) ;

/* Jo 23/06/99 Added for RAS */
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.option_type = 131 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.Auto = 1 ;
			ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.NegNotReqd = 1 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.Negotiable = 0 ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.value_type = IP ;
    		ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index-1].ras_remote_ipcp_dns_address2.option_value, ZeroIPAddress) ;
/* Jo 23/06/99 Added for RAS */
		}  
	 }
  }
  CDialog::OnOK();
  return;
}

void ipprx::OnSelchangeListPorts()
{
	// TODO: Add your control notification handler code here
	
	int PortIndex;
	UpdateData(TRUE);

	// TODO: Add your control notification handler code here
	PortIndex = m_PortListWnd.GetCurSel();
	if (PortIndex == LB_ERR)
		return;

	if (m_nOldPort == PortIndex)	// Prevent any loops
		return;

	if (!ValidPortSettings())
	{
		m_PortListWnd.SetCurSel(m_nOldPort);
		return;
	}
	//Store values for Old Port
	m_ISP[m_nOldPort] = m_ISPCheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;

/* Jo 23/06/99 Added for RAS */
	if (m_ras_enable.GetCheck())
		m_RAS[m_nOldPort] = 1;
	else
		m_RAS[m_nOldPort] = 0;
	m_RemoteAddr[m_nOldPort] = m_remote_address;  

	m_ISPCheck = m_ISP[PortIndex];
	m_IPAddrStr = m_IPAddr[PortIndex];
	m_MskStr = m_IPMask[PortIndex];

/* Jo 23/06/99 Added for RAS */
 if (m_RAS[PortIndex])
		m_ras_enable.SetCheck (1);
	else
		m_ras_enable.SetCheck (0);
	m_remote_address = m_RemoteAddr[PortIndex]; 

/* Jo 28/06/99 Added for RAS */
	m_ras_enable.EnableWindow (FALSE);  

	if (PortIndex == 0)		//LAN index
	{
		//If the selected port is LAN disable ISP_Assigned_Address
		m_ISPWnd.EnableWindow(FALSE);
		m_ras_enable.EnableWindow (FALSE);     
		m_ctrl_remote_address.EnableWindow (FALSE);
		m_static_remote_address.EnableWindow (FALSE);  
		//Change the group heading to that of the selected port
		m_SelPortGrp.SetWindowText("LAN");
	}
	else
	{
		//If the selected port is NOT LAN enable ISP_Assigned_Address
		m_ISPWnd.EnableWindow(TRUE);
		//Change the group heading to that of the selected port

/* Jo 23/06/99 Added for RAS */
		if (m_MLPPP)
			m_ras_enable.EnableWindow (FALSE);
//		else
//			m_ras_enable.EnableWindow (TRUE);

		if (m_RAS[PortIndex])
		{
			m_ctrl_remote_address.EnableWindow (TRUE);
			m_static_remote_address.EnableWindow (TRUE);
		}
		else
		{
			m_ctrl_remote_address.EnableWindow (FALSE);
			m_static_remote_address.EnableWindow (FALSE);
		}  
/* Jo 23/06/99 Added for RAS */

		char Buf[10];

		sprintf(Buf, "WAN %d", PortIndex);
		m_SelPortGrp.SetWindowText(Buf);
	}

	m_IPHdrWnd.EnableWindow(!m_ISPCheck);
	m_IPAddrWnd.EnableWindow(!m_ISPCheck);
	m_staticMskWnd.EnableWindow(!m_ISPCheck);
	m_MskWnd.EnableWindow(!m_ISPCheck);


	UpdateData(FALSE);
	m_nOldPort = PortIndex;
}

void ipprx::OnCheckRas()
{
	// TODO: Add your control notification handler code here
	if (m_ras_enable.GetCheck())
	{
		m_static_remote_address.EnableWindow (TRUE);
		m_ctrl_remote_address.EnableWindow (TRUE);
	}
	else
	{
		m_static_remote_address.EnableWindow (FALSE);
		m_ctrl_remote_address.EnableWindow (FALSE);
	}
	UpdateData (FALSE);
}

void ipprx::OnCheckClient()
{
	// TODO: Add your control notification handler code here
	if (m_check_client.GetCheck())
	{
		m_static_server_address.EnableWindow (TRUE);
		m_ctrl_server_address.EnableWindow (TRUE);
	}
	else
	{
		m_static_server_address.EnableWindow (FALSE);
		m_ctrl_server_address.EnableWindow (FALSE);
	}	
	UpdateData (FALSE);
}

void ipprx::OnButtonStatHost()
{
	// TODO: Add your control notification handler code here

	ipprx *pParent = (ipprx *) GetParent() ;
	CIPHRoute IIPHRoute (pParent);
	CDotDecimal IPAddrDotValue, IPMaskDotValue ;

	int index = m_PortListWnd.GetCurSel();

	if (!UpdateData(TRUE))	
		return ;
	if (!ValidPortSettings())
		return ;
	
	m_IPAddr[index] =	m_IPAddrStr ;
	m_IPMask[index] =	m_MskStr ;

	for (index = 0; index < m_nPorts; index++)
	{	
		IPAddrDotValue = m_IPAddr[index] ;
		IPMaskDotValue = m_IPMask[index] ;

		if (!IPAddrDotValue.IsValid())
			continue ;
		if (!IPMaskDotValue.IsValid())
			continue ;

		IIPHRoute.IPAddr[index] = IPAddrDotValue ;
		IIPHRoute.IPMask[index] = IPMaskDotValue ;
	}

	AfxGetApp()->LoadCursor(IDC_WAIT);
   AfxGetApp()->DoWaitCursor(1);
	IIPHRoute.DoModal() ;
	m_static_routes.SetFocus();
}
