// iproutes.cpp : implementation file
//	Jo 30/06/99 : Static routes 

#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "maskdot.h"
#include "iproutes.h"
#include "hardware.h"
#include "cnffile.h"
#include "readbmp.h"
#include "utils.h"

#define MIN_METRIC			1
#define MAX_METRIC			16
#define NO_SUCH_PORT			255

char	*StaticMsgHeader = "ProxyServer Setup - Static Route" ;
BOOL edit = FALSE ;

extern CNF_IP *ip_ptr ;
extern CNF_PPP *ppp_ptr ;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddRoute dialog


CAddRoute::CAddRoute(CWnd* pParent /*=NULL*/)
	: CDialog(CAddRoute::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddRoute)
	m_nAddStatRoutMetric = 1;
	m_HostNetAddr = "";
	m_HostNetGwayAddr = "";
	m_port = "";
	m_AddressMask = "";
	//}}AFX_DATA_INIT
}

void CAddRoute::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddRoute)
	DDX_Control(pDX, IDC_COMBO_PORT, m_combo_port);
	DDX_Control(pDX, IDC_STATIC_PORT, m_static_port);
	DDX_Control(pDX, IDC_EDIT4, m_MaskWnd);
	DDX_Control(pDX, IDC_STATIC_MASK, m_static_mask);
	DDX_Control(pDX, IDC_STATIC_GATEWAY_ADDRESS, m_static_gateway_address);
	DDX_Control(pDX, IDC_EDIT2, m_GwayWnd);
	DDX_Control(pDX, IDC_EDIT1, m_AddrWnd);
	DDX_Control(pDX, IDC_ADD_STAT_ROUT_METRIC, m_AddStatRoutMetricWnd);
	DDX_Text(pDX, IDC_ADD_STAT_ROUT_METRIC, m_nAddStatRoutMetric);
	DDX_Text(pDX, IDC_EDIT1, m_HostNetAddr);
	DDX_Text(pDX, IDC_EDIT2, m_HostNetGwayAddr);
	DDX_CBString(pDX, IDC_COMBO_PORT, m_port);
	DDX_Text(pDX, IDC_EDIT4, m_AddressMask);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAddRoute, CDialog)
	//{{AFX_MSG_MAP(CAddRoute)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_CBN_SELCHANGE(IDC_COMBO_PORT, OnSelchangeComboPort)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CAddRoute message handlers

void CAddRoute::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_IP_ADD_ROUTE,HELP_CONTEXT);
}

void CAddRoute::OnCancel()
{
	CDialog::OnCancel();
}

void CAddRoute::OnOK()
{
	if(!UpdateData(TRUE))
		return ;
	
	if (!m_HostNetAddr.IsValid() || m_HostNetAddr.IsEmpty()
				|| m_HostNetAddr == ZeroIPAddress)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Host IP Address",
				(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_AddrWnd.SetFocus() ;
		return ;
	}

	if (!m_AddressMask.IsValid())
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.",
			(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MaskWnd.SetFocus() ;
		return ;
	}

	if (!verify_ip_subnet_mask((LPCSTR)m_AddressMask))
	{
		ULONG subnet_mask ;
		get_ip_address ((const char *) m_AddressMask, &subnet_mask) ;
		if (subnet_mask != 0xFFFFFFFF)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.",
				(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_MaskWnd.SetFocus() ;
			return ;
		}
	}
	
	if (!m_HostNetGwayAddr.IsValid() && (strcmp (m_HostNetGwayAddr, "ISP Assigned") != 0)) 
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Host Gateway Address",
			(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_GwayWnd.SetFocus() ;
		return ;
	}

	if ((m_nAddStatRoutMetric < MIN_METRIC) || (m_nAddStatRoutMetric > MAX_METRIC))
	{
	   char Buf[128] ;
		sprintf (Buf, "Invalid Metric.\n Must be %d to %d",
				   	MIN_METRIC, MAX_METRIC) ;
		::MessageBox (GetSafeHwnd(), Buf,
				(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_AddStatRoutMetricWnd.SetFocus() ;
		return ;
	}

	if (strcmp (m_HostNetGwayAddr, "ISP Assigned") != 0)
		if (!GateWayAddressMatches())  
		{
			m_GwayWnd.SetFocus() ;
			return ;
		}

	char temp[10] ;
	int index = m_combo_port.GetCurSel() ;
	sprintf (temp, "%d", index) ;
	PortStr = temp ;
	
	CDialog::OnOK();
}

BOOL CAddRoute::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
	WindowText.GetBuffer(0),SubHeadingPointer) ;

	SetWindowText (WindowHeader) ;
	
	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Filtering bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this)) ;
	HelpBitmapBtn.SizeToContent() ;

	PutStringsInPortCombo() ;

	int index = 0 ;
	if (edit)
	{
		sscanf (PortStr, "%d", &index) ;
		m_combo_port.SetCurSel (index) ;
	}

	CIPHRoute *ipparent = (CIPHRoute *) GetParent() ;
	ULONG addr1 ;
	get_cdotdecimal_to_ulong_ip_address (ipparent->IPAddr[index], &addr1) ;

	if (((strcmp (m_HostNetGwayAddr, ZeroIPAddress) == 0) || 
			(strcmp (m_HostNetGwayAddr, "ISP Assigned") == 0)) && (index))
	{
		if (!addr1)
		{
			m_HostNetGwayAddr = "ISP Assigned" ;
			m_static_gateway_address.EnableWindow (FALSE) ;
			m_GwayWnd.EnableWindow (FALSE) ;
		}
		else
			m_HostNetGwayAddr = "" ;
	}

	UpdateData (FALSE) ;
	return TRUE ;
}

BOOL CAddRoute::GateWayAddressMatches()
{
	CIPHRoute *ipparent = (CIPHRoute *) GetParent() ;
	int index ;
	ULONG addr1, addr2, mask1 ;
	addr1 = addr2 = 0	;
	index = m_combo_port.GetCurSel() ;

	get_cdotdecimal_to_ulong_ip_address (ipparent->IPAddr[index], &addr1) ;
	get_cdotdecimal_to_ulong_ip_address (m_HostNetGwayAddr, &addr2) ;
	get_cdotdecimal_to_ulong_ip_address (ipparent->IPMask[index], &mask1) ;

	if ((addr1 == addr2) && !index)
	{  
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Gateway Address is same as LAN Address. Please Reenter Gateway Address",
			(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		return FALSE;
	}

	if ((m_HostNetGwayAddr.IsEmpty() || m_HostNetGwayAddr == ZeroIPAddress)
			&& (!index))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "If Port is LAN then Gateway Address is a must. Please enter gateway address...",
			(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		return FALSE;
	}

	if (((addr1 & mask1) != (addr2 & mask1)) && !index)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Gateway Address should be of the same net as that of ProxyServer",
			(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		return FALSE ;
	}

	if (index)
	{
		if (addr1 != 0 && (m_HostNetGwayAddr != ZeroIPAddress))
		{
			if ((addr1 & mask1) != (addr2 & mask1))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Gateway Address should be of the same net",
					(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				return FALSE ;
	 		}
		}
		
		if ((addr1 == 0) && (m_HostNetGwayAddr != ZeroIPAddress))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "IP Address is ISP Assigned Dynamic for this port. Do not enter Gateway Address",
				(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			return FALSE ;
		}
	}
	return TRUE ;
}

/////////////////////////////////////////////////////////////////////////////
// CIPHRoute dialog


CIPHRoute::CIPHRoute(CWnd* pParent /*=NULL*/)
	: CDialog(CIPHRoute::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIPHRoute)
	//}}AFX_DATA_INIT
}

void CIPHRoute::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIPHRoute)
	DDX_Control(pDX, IDC_BUTTON_HOST_REMOVE, m_HRemove);
	DDX_Control(pDX, IDC_LIST_HOST_ROUTES, m_HRouteList);
	DDX_Control(pDX, IDC_EDIT, m_Edit);
	DDX_Control(pDX, IDC_BUTTON_HOST_ADD, m_HAdd);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIPHRoute, CDialog)
	//{{AFX_MSG_MAP(CIPHRoute)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnHelp)
	ON_BN_CLICKED(IDC_BUTTON_HOST_ADD, OnButtonHostAdd)
	ON_BN_CLICKED(IDC_BUTTON_HOST_REMOVE, OnButtonHostRemove)
	ON_BN_CLICKED(IDC_EDIT, OnEdit)
	ON_LBN_SELCANCEL(IDC_LIST_HOST_ROUTES, OnSelcancelListHostRoutes)
	ON_LBN_SELCHANGE(IDC_LIST_HOST_ROUTES, OnSelchangeListHostRoutes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIPHRoute message handlers

BOOL CIPHRoute::OnInitDialog()
{
	CDialog::OnInitDialog();

	CenterWindow() ; 
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat, WindowText.GetBuffer(0),SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap") ;

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this)) ;
	OKBitmapBtn.SizeToContent() ;

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap") ;

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this)) ;
	CancelBitmapBtn.SizeToContent() ;

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap") ;

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_BUTTON_HELP, this)) ;
	HelpBitmapBtn.SizeToContent() ;

	if (!AddMapBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap") ;

	VERIFY (AddMapBmpBtn.SubclassDlgItem (IDC_BUTTON_HOST_ADD, this)) ;
	AddMapBmpBtn.SizeToContent() ;

	if (!DeleteMapBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap") ;

	VERIFY (DeleteMapBmpBtn.SubclassDlgItem (IDC_BUTTON_HOST_REMOVE, this));
	DeleteMapBmpBtn.SizeToContent() ;

	if (!EditMapBmpBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load EDIT bitmap") ;

	VERIFY (EditMapBmpBtn.SubclassDlgItem (IDC_EDIT, this)) ;
	EditMapBmpBtn.SizeToContent() ;

	int TabStops[] = {65, 130, 160, 230} ;
	m_HRouteList.SetTabStops (4, (LPINT) &TabStops) ;

	CNF_STATIC_ROUTES_INFO *static_routes_info_ptr ;
	CNF_STATIC_ROUTES_HEADER *static_routes_header_ptr ;
	int i, number_of_static_route_entries ;
	char Str[50], temp_dot_value1[20], temp_dot_value2[20], temp_dot_value3[20], szMetric[10], port_string[5] ;

	static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) all_structures[STATIC_ROUTES_ID].ptr_to_struct ;
	static_routes_info_ptr = (CNF_STATIC_ROUTES_INFO *) ((char *)static_routes_header_ptr + sizeof (CNF_STATIC_ROUTES_HEADER)) ;

	for (i = 0; i < static_routes_header_ptr->number_of_static_routes; i++)
	{
      get_dot_decimal_ip_address (static_routes_info_ptr->host_ip_address, temp_dot_value1) ;
		if (static_routes_info_ptr->host_gateway != 0)
	      get_dot_decimal_ip_address (static_routes_info_ptr->host_gateway, temp_dot_value2) ;
		else
		{
			ULONG addr1 ;
			get_cdotdecimal_to_ulong_ip_address (IPAddr[static_routes_info_ptr->port_number], &addr1) ;
			if (!addr1)
				sprintf (temp_dot_value2, "ISP Assigned") ;
			else
				sprintf (temp_dot_value2, "0.0.0.0") ;
		}
		if (!static_routes_info_ptr->port_number)
			sprintf (port_string, "LAN")	;
		else
			sprintf (port_string, "WAN%d", static_routes_info_ptr->port_number) ;
			
      get_dot_decimal_ip_address (static_routes_info_ptr->host_address_mask, temp_dot_value3) ;
		itoa (static_routes_info_ptr->metric, szMetric, 10) ;
		sprintf (Str, "%s\t%s\t%s\t%s\t%s", temp_dot_value1, temp_dot_value2, port_string, temp_dot_value3, szMetric)	;
		m_HRouteList.AddString(Str) ;
		static_routes_info_ptr++ ;
	}

	if (!m_HRouteList.GetCount())
	{
		m_HRemove.EnableWindow (FALSE) ;
		m_Edit.EnableWindow (FALSE) ;
	}

	UpdateData (FALSE) ;
	return TRUE;
}

void CIPHRoute::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_IP_HOST_ROUTES,HELP_CONTEXT) ;
}

void CIPHRoute::OnButtonHostAdd()
{
	char temp[10] ;
	CString tempstr ;

	CAddRoute IAddRoute (this) ;
	edit = FALSE ;
	if (IDOK == IAddRoute.DoModal())
	{
		if (IAddRoute.m_HostNetAddr.IsEmpty() &&
				IAddRoute.m_AddressMask.IsEmpty() && 
					(IAddRoute.m_nAddStatRoutMetric == 0))
			return ;
		
		CString Str ;
		char szMetric[10] ;

		Str = IAddRoute.m_HostNetAddr + '\t' ;
		if (strcmp (IAddRoute.m_HostNetGwayAddr, "") == 0)
		{
			sprintf ((char *) temp, "0.0.0.0") ;
			tempstr = temp ;
	  		Str += tempstr + '\t' ;
		}
		else
  			Str += IAddRoute.m_HostNetGwayAddr + '\t' ;

		int index ;	
		sscanf (IAddRoute.PortStr, "%d", &index) ;
		if (!index)
			sprintf ((char *) temp, "LAN") ;
		else
			sprintf ((char *) temp, "WAN%d", index) ;
		tempstr = temp ;
		Str += tempstr + '\t';

		Str += IAddRoute.m_AddressMask + '\t' ;
		itoa (IAddRoute.m_nAddStatRoutMetric, szMetric, 10) ;
		Str += szMetric ;

		if (!DuplicateString (Str))
			m_HRouteList.AddString (Str) ;
	}
	m_HRemove.EnableWindow (m_HRouteList.GetCount()) ;
	m_Edit.EnableWindow (m_HRouteList.GetCount()) ;
}

void CIPHRoute::OnButtonHostRemove()
{
	int SelIndex ;
	if ((SelIndex = m_HRouteList.GetCurSel()) == CB_ERR)
		return ;

	m_HRouteList.DeleteString (SelIndex) ;
	m_HRouteList.SetCurSel(SelIndex)	;
	m_HRemove.EnableWindow (m_HRouteList.GetCount()) ;
	m_Edit.EnableWindow (m_HRouteList.GetCount()) ;
	m_HAdd.SetFocus() ;
}

void CIPHRoute::OnEdit()
{
	int SelIndex;
	
	if ((SelIndex = m_HRouteList.GetCurSel()) == CB_ERR)
		return ;

	BYTE Str[80] ;
	char *temp_ptr ;

	CAddRoute IAddRoute (this) ;
	if (m_HRouteList.GetText (SelIndex, (LPSTR) Str) == LB_ERR)
		return ;

	if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL) 
	{
		*temp_ptr = '\0' ;
	 	IAddRoute.m_HostNetAddr = (char *) Str ;
	 	temp_ptr++ ;

		while (*temp_ptr == '\t')
			temp_ptr++ ;	
		_fstrcpy ((char *) Str, temp_ptr) ;

	   if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL)
		{
	   	*temp_ptr = '\0' ;
	  		IAddRoute.m_HostNetGwayAddr = (char *) Str ;
			temp_ptr++ ;	
  
			while (*temp_ptr == '\t')
				temp_ptr++ ;	
			_fstrcpy ((char *) Str, temp_ptr) ;

			if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL)
			{
	   		*temp_ptr = '\0' ;
				int index = 0 ;
				char temp [10] ;
				index = atoi ((const char *)&Str[3]) ;
				sprintf (temp, "%d", index) ;
				IAddRoute.PortStr = temp ;

				temp_ptr++ ;	

				while (*temp_ptr == '\t')
					temp_ptr++ ;	
				_fstrcpy ((char *) Str, temp_ptr) ;

				if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL)
				{
	   			*temp_ptr = '\0' ;
					IAddRoute.m_AddressMask = (char *) Str ;
					temp_ptr++ ;	

					while (*temp_ptr == '\t')
						temp_ptr++ ;	
					IAddRoute.m_nAddStatRoutMetric = atoi ((const char *)temp_ptr) ;
				}
			}
		}
	}
	edit = TRUE ;
	if (IDOK == IAddRoute.DoModal()) 
	{
		if (IAddRoute.m_HostNetAddr.IsEmpty() &&
				IAddRoute.m_AddressMask.IsEmpty() && 
				(IAddRoute.m_nAddStatRoutMetric == 0))
		{  
			m_HAdd.SetFocus() ;
			return ;		
		}

		CString Str;
		char szMetric[10] ;
  		CString tempstr ;
  		char temp[10] ;

		Str = IAddRoute.m_HostNetAddr + '\t' ;
		if (strcmp (IAddRoute.m_HostNetGwayAddr, "") == 0)
		{
			sprintf ((char *) temp, "0.0.0.0") ;
			tempstr = temp ;
	  		Str += tempstr + '\t' ;
		}
		else
		  	Str += IAddRoute.m_HostNetGwayAddr + '\t' ;
  		
		int index ;	
  		sscanf (IAddRoute.PortStr, "%d", &index) ;
		if (!index)
			sprintf ((char *) temp, "LAN") ;
		else
			sprintf ((char *) temp, "WAN%d", index) ;
  		tempstr = temp ;
  		Str += tempstr + '\t';
		
		Str += IAddRoute.m_AddressMask + '\t' ;
		itoa (IAddRoute.m_nAddStatRoutMetric, szMetric, 10) ;
		Str += szMetric ;

		if (!DuplicateString (Str))
		{
			m_HRouteList.DeleteString(SelIndex) ;
			m_HRouteList.AddString(Str) ;
		}
	} 

	m_HRemove.EnableWindow(m_HRouteList.GetCount()) ;
	m_Edit.EnableWindow(m_HRouteList.GetCount()) ;
	m_HAdd.SetFocus() ;
}

void CIPHRoute::OnSelcancelListHostRoutes()
{
	// TODO: Add your control notification handler code here
	
}

void CIPHRoute::OnSelchangeListHostRoutes()
{
	((CIPHRoute *)this)->m_Edit.EnableWindow(((CIPHRoute *)this)->m_HRouteList.GetSelCount()) ;
	((CIPHRoute *)this)->m_HRemove.EnableWindow(((CIPHRoute *)this)->m_HRouteList.GetSelCount()) ;
}

void CIPHRoute::OnCancel()
{
	CDialog::OnCancel();
}

void CIPHRoute::OnOK()
{
	if (!UpdateData(TRUE))
		return ;

	CNF_STATIC_ROUTES_INFO *static_routes_info_ptr ;
	CNF_STATIC_ROUTES_HEADER *static_routes_header_ptr ;
	ULONG offset, int_ip_addr ;

	int i, number_of_static_route_entries ;
	BYTE	Str[80] ;
	char *temp_ptr ;

	int n_Count = m_HRouteList.GetCount() ;

	static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) all_structures[STATIC_ROUTES_ID].ptr_to_struct ;
   USHORT temp_number_of_entries = static_routes_header_ptr->number_of_static_routes ;
	static_routes_header_ptr->number_of_static_routes = n_Count ;

   if (temp_number_of_entries < static_routes_header_ptr->number_of_static_routes)
   {
   	ULONG SizeToRealloc = (static_routes_header_ptr->section_length + (sizeof(CNF_STATIC_ROUTES_INFO) * (static_routes_header_ptr->number_of_static_routes - temp_number_of_entries))) ;
		all_structures[STATIC_ROUTES_ID].glblck = GlobalReAlloc (all_structures[STATIC_ROUTES_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[STATIC_ROUTES_ID].ptr_to_struct = GlobalLock (all_structures[STATIC_ROUTES_ID].glblck) ;
		all_structures[STATIC_ROUTES_ID].size_of_struct = (USHORT) SizeToRealloc ;
		static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) all_structures[STATIC_ROUTES_ID].ptr_to_struct ;
		static_routes_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[STATIC_ROUTES_ID].ptr_to_struct ;

		calculate_offset_of_static_route_info_entry (&offset) ;
   	static_routes_info_ptr = (CNF_STATIC_ROUTES_INFO *) offset ;

		offset += (temp_number_of_entries * sizeof(CNF_STATIC_ROUTES_INFO)) ;

		ULONG SizeToMove = ((ULONG) all_structures[STATIC_ROUTES_ID].ptr_to_struct + static_routes_header_ptr->section_length - offset - 
		(sizeof(CNF_STATIC_ROUTES_INFO) * (static_routes_header_ptr->number_of_static_routes - temp_number_of_entries))) ;
		ULONG dst_offset = (offset + ((static_routes_header_ptr->number_of_static_routes - temp_number_of_entries) * sizeof(CNF_STATIC_ROUTES_INFO))) ; 
		memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;
   }
	else
	{
		if (temp_number_of_entries > static_routes_header_ptr->number_of_static_routes)
		{
			offset = (ULONG) all_structures[STATIC_ROUTES_ID].ptr_to_struct ;
			calculate_offset_of_static_route_info_entry (&offset) ;
   		static_routes_info_ptr = (CNF_STATIC_ROUTES_INFO *) offset ;

			offset += (temp_number_of_entries * sizeof(CNF_STATIC_ROUTES_INFO)) ;

   		ULONG SizeToMove = ((ULONG) all_structures[STATIC_ROUTES_ID].ptr_to_struct + static_routes_header_ptr->section_length - offset) ;
	   	ULONG dst_offset = (ULONG) (offset - ((temp_number_of_entries - static_routes_header_ptr->number_of_static_routes) * sizeof(CNF_STATIC_ROUTES_INFO))) ;
   		_fmemmove ((void FAR *) dst_offset, (void FAR *) offset, (int) SizeToMove) ;

		  	ULONG SizeToRealloc = (static_routes_header_ptr->section_length + (sizeof(CNF_STATIC_ROUTES_INFO) * (static_routes_header_ptr->number_of_static_routes - temp_number_of_entries))) ;
   		all_structures[STATIC_ROUTES_ID].glblck = GlobalReAlloc (all_structures[STATIC_ROUTES_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	   	all_structures[STATIC_ROUTES_ID].ptr_to_struct = GlobalLock (all_structures[STATIC_ROUTES_ID].glblck) ;
   		all_structures[STATIC_ROUTES_ID].size_of_struct = (USHORT) SizeToRealloc ;
   		static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) all_structures[STATIC_ROUTES_ID].ptr_to_struct ;
	   	static_routes_header_ptr->section_length = (USHORT) SizeToRealloc ;
     }
   }
	offset = (ULONG) all_structures[STATIC_ROUTES_ID].ptr_to_struct ;
	calculate_offset_of_static_route_info_entry (&offset) ;
   static_routes_info_ptr = (CNF_STATIC_ROUTES_INFO *) offset ;

	for (i = 0; i < n_Count; i ++) 
	{
		m_HRouteList.GetText (i, (LPSTR) Str) ;  

		if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL) 
		{
			*temp_ptr = '\0' ;

		   get_ip_address ((const char *)Str, &int_ip_addr) ;
	 		static_routes_info_ptr->host_ip_address = int_ip_addr ;
		 	temp_ptr++ ;

			while (*temp_ptr == '\t')
				temp_ptr++ ;	
			_fstrcpy ((char *) Str, temp_ptr) ;

		   if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL)
			{
	   		*temp_ptr = '\0' ;
				if ((strcmp ((char *)Str, ZeroIPAddress) == 0) || (strcmp ((char *)Str, "ISP Assigned") == 0))
			 		static_routes_info_ptr->host_gateway = 0 ;
				else
				{
		   		get_ip_address ((const char *)Str, &int_ip_addr) ;
			 		static_routes_info_ptr->host_gateway = int_ip_addr ;
				}

				temp_ptr++ ;	
				while (*temp_ptr == '\t')
					temp_ptr++ ;	

				_fstrcpy ((char *) Str, temp_ptr) ;
			   if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL)
				{
	   			*temp_ptr = '\0' ;

					if (strcmp ((char *)Str, "LAN") == 0)
						static_routes_info_ptr->port_number = 0 ;
					else
						static_routes_info_ptr->port_number = atoi ((const char *) &Str[3]) ;

					temp_ptr++ ;	
					while (*temp_ptr == '\t')
						temp_ptr++ ;	

					_fstrcpy ((char *) Str, temp_ptr) ;
				   if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL)
					{
	   				*temp_ptr = '\0' ;
					   get_ip_address ((const char *)Str, &int_ip_addr) ;
			 			static_routes_info_ptr->host_address_mask = int_ip_addr ;

					 	temp_ptr++ ;
						while (*temp_ptr == '\t')
							temp_ptr++ ;	
				 		static_routes_info_ptr->metric = atoi ((const char *)temp_ptr) ;
					}
				}
			}
		}
	 	static_routes_info_ptr++ ;
	}
	CDialog::OnOK();
}

BOOL CIPHRoute::DuplicateString (CString StrInBox)
{
	int nCount = m_HRouteList.GetCount() ;
	int cur_sel ;
	CString Str ;
	if (edit)
		cur_sel = m_HRouteList.GetCurSel() ;		

	for (int i = 0 ; i < nCount ; i ++)
	{
		if (edit && (i == cur_sel))
			continue ;
		m_HRouteList.GetText (i, Str) ;
		if (Str == StrInBox)
		{
			::MessageBox (GetParent()->GetSafeHwnd(), "Duplicate Entry will not be added", 
						"Warning", MB_OK | MB_ICONINFORMATION) ;
			return TRUE ;
		}
	}
	edit = FALSE ;
	return FALSE ;
}

void CAddRoute::OnSelchangeComboPort()
{
	CIPHRoute *ipparent = (CIPHRoute *) GetParent() ;
	ULONG addr1 ;
	int index ;

	index = m_combo_port.GetCurSel() ;		
	get_cdotdecimal_to_ulong_ip_address (ipparent->IPAddr[index], &addr1) ;
	if (!addr1)
	{
		m_HostNetGwayAddr = "ISP Assigned" ;
		m_static_gateway_address.EnableWindow (FALSE) ;
		m_GwayWnd.EnableWindow (FALSE) ;
	}
	else
	{
		m_HostNetGwayAddr = "" ;
		m_static_gateway_address.EnableWindow (TRUE) ;
		m_GwayWnd.EnableWindow (TRUE) ;
	}
	UpdateData (FALSE) ;
}

void CAddRoute::PutStringsInPortCombo()
{
	char str[10] ;

	m_combo_port.ResetContent();

	sprintf (str, "LAN") ;
	m_combo_port.AddString (str) ;
	for (int index = 1; index <= ppp_ptr->ppp_header.number_of_ports; index++)
	{
		sprintf (str, "WAN%d", index) ;
		m_combo_port.AddString (str) ;
	}
	m_combo_port.SetCurSel (0);
}
