// isdnta.cpp : implementation file
//
// Sudha 23 Dec 1997 - ISDN Configuration UI

#include "stdafx.h"
#include "procon.h"
#include "wandlg.h"
#include "isdnta.h"
#include "hardware.h"
#include <ctype.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

// This type is used to hold a string-value pair
// An array of these structures provides a mapping for AT command integers to the
// strings stored in the INI file

ini_tValuePair cfg_NetworkSwitchTypes[] = {
	IDS_ATT5ESS,			0,
	IDS_DMS100,				1,
	IDS_NI1,					5,
	IDS_NET3,				2,
	IDS_VN4,					6,
	IDS_1TR6,				3,
	IDS_INS64,				4,
	0,							0
};

ini_tValuePair cfg_NetworkSwitchTypesDom[] = {
	IDS_ATT5ESS,			0,
	IDS_DMS100,				1,
	IDS_NI1,					5,
	0,							0
};

ini_tValuePair cfg_DialingMethods[] = {
	IDS_ENBLOC,				0,
	IDS_OVERLAP,			1,	
	0,							0
};

ini_tValuePair cfg_DataProtocols[] = {
	IDS_V110,				6,
	IDS_V120,				5,
	IDS_MLPPP,				9,
//	IDS_X25,					2,
	IDS_X75,					12,
	IDS_SOFTBOND,			8,
	0,							0
};

ini_tValuePair cfg_DataProtocolsDom[] = {
	IDS_V120,				5,
	IDS_MLPPP,				9,
	IDS_SOFTBOND,			8,
	0,							0
};

ini_tValuePair cfg_DataProtocolsInt[] = {
	IDS_V110,				6,
	IDS_V120,				5,
	IDS_MLPPP,				9,
	IDS_SOFTBOND,			8,
	IDS_X75,					12,
	0,							0
};

ini_tValuePair cfg_DataCompression[] = {
	IDS_NONE,				0,
	IDS_HiFn,				1,
	0,						0,
};

ini_tValuePair cfg_TEI[] = {
	IDS_AUTOTEI,				240,	IDS_DISABLED,				241,
	IDS_0,	0,		IDS_1,	1,		IDS_2,	2,		IDS_3,	3,		IDS_4,	4,
	IDS_5,	5,		IDS_6,	6,		IDS_7,	7,		IDS_8,	8,		IDS_9,	9,
	IDS_10,	10,	IDS_11,	11,	IDS_12,	12,	IDS_13,	13,	IDS_14,	14,
	IDS_15,	15,	IDS_16,	16,	IDS_17,	17,	IDS_18,	18,	IDS_19,	19,
	IDS_20,	20,	IDS_21,	21,	IDS_22,	22,	IDS_23,	23,	IDS_24,	24,
	IDS_25,	25,	IDS_26,	26,	IDS_27,	27,	IDS_28,	28,	IDS_29,	29,
	IDS_30,	30,	IDS_31,	31,	IDS_32,	32,	IDS_33,	33,	IDS_34,	34,
	IDS_35,	35,	IDS_36,	36,	IDS_37,	37,	IDS_38,	38,	IDS_39,	39,
	IDS_40,	40,	IDS_41,	41,	IDS_42,	42,	IDS_43,	43,	IDS_44,	44,
	IDS_45,	45,	IDS_46,	46,	IDS_47,	47,	IDS_48,	48,	IDS_49,	49,
	IDS_50,	50,	IDS_51,	51,	IDS_52,	52,	IDS_53,	53,	IDS_54,	54,
	IDS_55,	55,	IDS_56,	56,	IDS_57,	57,	IDS_58,	58,	IDS_59,	59,
	IDS_60,	60,	IDS_61,	61,	IDS_62,	62,	IDS_63,	63,
	0,	0
};


ini_tValuePair cfg_null[] = {
	0,							0	
};

//following tNoYes should only be used when int portion assoc with No is 0, Yes is 1

ini_tValuePair cfg_NoYes[] = {
	IDS_NO,			0,
	IDS_YES,			1,	
	0,					0
};

extern char TempSection[40];

extern LPCSTR IsdnMsgHeader;

extern LPCSTR WANSectionHeader;
extern char WanPortNum[12];
extern LPCSTR MapHeader;
extern int m_cfgtype;

/////////////////////////////////////////////////////////////////////////////
// CIsdnTa dialog


CIsdnTa::CIsdnTa(CWnd* pParent /*=NULL*/)
	: CDialog(CIsdnTa::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIsdnTa)
	m_szPPSectionName = "";
	m_szPPNetworkSwitchType = "";
	m_szPPDataTEI = "";
	m_szPPVoiceTEI = "";
	m_szPPDataSpid = "";
	m_szPPVoiceSpid = "";
	m_szPPDataDirNum = "";
	m_szPPVoiceDirNum = "";
	m_szPPDataISDN = "";
	m_szPPVoiceISDN = "";
	m_szPPVoiceSub = "";
	m_szPPDataSub = "";
	m_szPPDataMSN = "";
	m_szPPVoiceMSN = "";
	m_bPPPersistentDTRDialing = FALSE;
	m_bPPCallLineId = FALSE;
	m_bPPAutoAnswer = FALSE;
	m_szRings = "";
	m_szPPDialingMethod = "";
	m_bPPAutoDetection = FALSE;
	m_szPPDataProtocol = "";
	m_szPPDataCompression = "";
	m_bUS = FALSE;
	m_nType = isdnta_kInternational;
	
	//}}AFX_DATA_INIT
}

void CIsdnTa::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIsdnTa)
	DDX_Control(pDX, IDC_STATIC_TA_TYPE, m_static_ta_type);
	DDX_Control(pDX, IDC_STATIC_EUROPE, m_StatEurope);
	DDX_Control(pDX, IDC_STATIC_US, m_StatUS);
	DDX_Control(pDX, IDCANCEL, m_bCancel);
	DDX_Control(pDX, IDC_DATA_COMPRESSION, m_bDataCompression);
	DDX_Control(pDX, IDC_DATA_PROTOCOL, m_bDataProtocol);
	DDX_Control(pDX, IDC_AUTO_PROTOCOL_DETECTION, m_bAutoDetection);
	DDX_Control(pDX, IDC_DIALING_METHOD, m_bDialingMethod);
	DDX_Control(pDX, IDC_RINGS_TO_ANSWER_DATA, m_bRingsToAnswer);
	DDX_Control(pDX, IDC_AUTO_ANSWER_DATA_CALLS, m_bPPAutoAnswerCalls);
	DDX_Control(pDX, IDC_CALL_LINE_ID, m_bCallLineId);
	DDX_Control(pDX, IDC_PERSISTENT_DTR_DIALING, m_bPersistentDTRDialing);
	DDX_Control(pDX, IDC_ST_TYPE, m_RBtnST);
	DDX_Control(pDX, IDC_NT_TYPE, m_RBtnNT);
	DDX_Control(pDX, IDC_DATA_SUB, m_bDataSub);
	DDX_Control(pDX, IDC_VOICE_SUB, m_bVoiceSub);
	DDX_Control(pDX, IDC_VOICE_ISDN, m_bVoiceIsdn);
	DDX_Control(pDX, IDC_DATA_ISDN, m_bDataIsdn);
	DDX_Control(pDX, IDC_VOICE_DIR_NUMBER, m_bVoiceDirNum);
	DDX_Control(pDX, IDC_DATA_DIR_NUMBER, m_bDataDirNum);
	DDX_Control(pDX, IDC_VOICE_SPID, m_bVoiceSpid);
	DDX_Control(pDX, IDC_DATA_SPID, m_bDataSpid);
	DDX_Control(pDX, IDC_VOICE_TEI, m_szPPVoiceTEIControl);
	DDX_Control(pDX, IDC_DATA_TEI, m_szPPDataTEIControl);
	DDX_Control(pDX, IDC_NETWORK_SWITCH_TYPE, m_bNetworkSwitchType);
	DDX_Control(pDX, IDC_SECTION_NAME, m_bSectionName);
	DDX_Text(pDX, IDC_SECTION_NAME, m_szPPSectionName);
	DDV_MaxChars(pDX, m_szPPSectionName, 25);
	DDX_CBString(pDX, IDC_NETWORK_SWITCH_TYPE, m_szPPNetworkSwitchType);
	DDX_CBString(pDX, IDC_DATA_TEI, m_szPPDataTEI);
	DDX_CBString(pDX, IDC_VOICE_TEI, m_szPPVoiceTEI);
	DDX_Text(pDX, IDC_DATA_SPID, m_szPPDataSpid);
	DDV_MaxChars(pDX, m_szPPDataSpid, 20);
	DDX_Text(pDX, IDC_VOICE_SPID, m_szPPVoiceSpid);
	DDV_MaxChars(pDX, m_szPPVoiceSpid, 20);
	DDX_Text(pDX, IDC_DATA_DIR_NUMBER, m_szPPDataDirNum);
	DDV_MaxChars(pDX, m_szPPDataDirNum, 24);
	DDX_Text(pDX, IDC_VOICE_DIR_NUMBER, m_szPPVoiceDirNum);
	DDV_MaxChars(pDX, m_szPPVoiceDirNum, 24);
	DDX_Text(pDX, IDC_DATA_ISDN, m_szPPDataISDN);
	DDV_MaxChars(pDX, m_szPPDataISDN, 20);
	DDX_Text(pDX, IDC_VOICE_ISDN, m_szPPVoiceISDN);
	DDV_MaxChars(pDX, m_szPPVoiceISDN, 20);
	DDX_Text(pDX, IDC_VOICE_SUB, m_szPPVoiceSub);
	DDV_MaxChars(pDX, m_szPPVoiceSub, 24);
	DDX_Text(pDX, IDC_DATA_SUB, m_szPPDataSub);
	DDV_MaxChars(pDX, m_szPPDataSub, 24);
	DDX_Check(pDX, IDC_PERSISTENT_DTR_DIALING, m_bPPPersistentDTRDialing);
	DDX_Check(pDX, IDC_CALL_LINE_ID, m_bPPCallLineId);
	DDX_Check(pDX, IDC_AUTO_ANSWER_DATA_CALLS, m_bPPAutoAnswer);
	DDX_Text(pDX, IDC_RINGS_TO_ANSWER_DATA, m_szRings);
	DDV_MaxChars(pDX, m_szRings, 3);
	DDX_CBString(pDX, IDC_DIALING_METHOD, m_szPPDialingMethod);
	DDX_Check(pDX, IDC_AUTO_PROTOCOL_DETECTION, m_bPPAutoDetection);
	DDX_CBString(pDX, IDC_DATA_PROTOCOL, m_szPPDataProtocol);
	DDX_CBString(pDX, IDC_DATA_COMPRESSION, m_szPPDataCompression);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIsdnTa, CDialog)
	//{{AFX_MSG_MAP(CIsdnTa)
	ON_BN_CLICKED(IDC_PERSISTENT_DTR_DIALING, OnDtrDialing)
	ON_BN_CLICKED(IDC_NT_TYPE, OnNtType)
	ON_BN_CLICKED(IDC_ST_TYPE, OnStType)
	ON_BN_CLICKED(IDC_CALL_LINE_ID, OnCallLineId)
	ON_BN_CLICKED(IDC_AUTO_ANSWER_DATA_CALLS, OnAutoAnswer)
	ON_BN_CLICKED(IDC_AUTO_PROTOCOL_DETECTION, OnAutoDetection)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_CBN_SELCHANGE(IDC_VOICE_TEI, OnSelVoiceTei)
	ON_CBN_SELCHANGE(IDC_NETWORK_SWITCH_TYPE, OnSwitch)
	ON_CBN_SELCHANGE(IDC_DATA_TEI, OnSelDataTei)
	ON_EN_UPDATE(IDC_SECTION_NAME, OnUpName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIsdnTa message handlers

BOOL CIsdnTa::OnInitDialog()
{
	CDialog::OnInitDialog();
        char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	// TODO: Add extra initialization here
	char strRHS[40],Name[40] ;
	CString String;

	BOOL DataTEI = FALSE;
	BOOL VoiceTEI = FALSE;
	
	m_bDataSpid.LimitText (20);
 	m_bVoiceSpid.LimitText (20);
	m_bDataDirNum.LimitText (24);
	m_bVoiceDirNum.LimitText (24);

	m_bDataIsdn.LimitText (20);
	m_bVoiceIsdn.LimitText (20);
	m_bDataSub.LimitText (24);
	m_bVoiceSub.LimitText (24);

	m_bSectionName.LimitText(25);
	m_bRingsToAnswer.LimitText(3);

	if (m_cfgtype==kEdit)
	{
		m_bSectionName.SetWindowText ( TempSection );
		m_bSectionName.GetWindowText( m_szPPSectionName);

		sprintf ( Name,"%s",TempSection );

		::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_CONFIG_NAME),FALSE );
		::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_SECTION_NAME),FALSE );
		
		if ((model == MODEL_MTSR1_202ST) || (model == MODEL_MTSR1_202NT)) 
		{
			m_RBtnNT.ShowWindow (SW_HIDE);
			m_RBtnST.ShowWindow (SW_HIDE);
			m_static_ta_type.ShowWindow (SW_HIDE);
			TaType();
		}
		else
		{
			GetPrivateProfileString ( TempSection,"TA Type","ST",strRHS,
				sizeof (strRHS),ini_INIFilename );
			if ( strcmp ( strRHS,"ST") == 0 )
				OnStType();
			else
				OnNtType();
	
			::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_STATIC_TA_TYPE),FALSE );
			::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_ST_TYPE),FALSE );
			::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_NT_TYPE),FALSE );
		}
	}
	else if(m_cfgtype==kAdd)
	{
		if ((model == MODEL_MTSR1_202ST) || (model == MODEL_MTSR1_202NT)) 
		{
			m_RBtnNT.ShowWindow (SW_HIDE);
			m_RBtnST.ShowWindow (SW_HIDE);
			m_static_ta_type.ShowWindow (SW_HIDE);
			TaType();
		}
		::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_CONFIG_NAME),TRUE );
		::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_SECTION_NAME),TRUE );
		
		::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_STATIC_TA_TYPE), TRUE );
		::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_ST_TYPE),TRUE );
		::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_NT_TYPE),TRUE );

		OnStType();

	}
	if ( m_cfgtype == kEdit )
	{
		strcpy(strRHS,GetStr(Name, "NetworkSwitchType"));
		m_bNetworkSwitchType.SetCurSel(m_bNetworkSwitchType.FindString(-1,strRHS));
		m_bNetworkSwitchType.GetLBText 
                 ( m_bNetworkSwitchType.GetCurSel(),m_szPPNetworkSwitchType );

		DetermineType();

		if ( IsThisADefaultCfg ( Name ) )
			::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_NETWORK_SWITCH_TYPE),FALSE );
		
		strcpy(strRHS,GetStr ( Name, "DataTEI")) ;
		m_szPPDataTEIControl.SetCurSel(m_szPPDataTEIControl.FindStringExact(-1,strRHS));
		
		m_szPPDataTEIControl.GetLBText (m_szPPDataTEIControl.GetCurSel(), m_szPPDataTEI );
		String.LoadString ( IDS_DISABLED );
		if ( String.CompareNoCase ( m_szPPDataTEI ) == 0 )
			DataTEI = TRUE;
		
		strcpy(strRHS,GetStr ( Name, "VoiceTEI")) ;
		m_szPPVoiceTEIControl.SetCurSel(m_szPPVoiceTEIControl.FindStringExact(-1,strRHS));
		
		m_szPPVoiceTEIControl.GetLBText ( m_szPPVoiceTEIControl.GetCurSel(),m_szPPVoiceTEI );
		String.LoadString ( IDS_DISABLED );
		if ( String.CompareNoCase ( m_szPPVoiceTEI ) == 0 )
			VoiceTEI = TRUE;
	
		if ( !m_bUS )
		{
			m_StatUS.EnableWindow ( FALSE );
			m_StatEurope.EnableWindow ( TRUE );
		  	if ( DataTEI == TRUE )
				EuroData ( FALSE );
			else				
			{
				strcpy(strRHS,GetStr ( Name, "DataMSN" ));
				if ( strRHS != NULL )
				{
					MSNtoISDNSubAddress ( strRHS, m_szPPDataISDN, m_szPPDataSub );
					m_bDataIsdn.SetWindowText(m_szPPDataISDN);
			   	m_bDataSub.SetWindowText(m_szPPDataSub);
				}
			}
   
  			if ( VoiceTEI == TRUE )
				EuroVoice ( FALSE ) ;
 			else
	 		{
				strcpy(strRHS,GetStr ( Name, "VoiceMSN" ));
				if ( strRHS != NULL )
				{
					MSNtoISDNSubAddress ( strRHS, m_szPPVoiceISDN, m_szPPVoiceSub );
					m_bVoiceIsdn.SetWindowText(m_szPPVoiceISDN);
					m_bVoiceSub.SetWindowText(m_szPPVoiceSub);
				}
			}
		}
		else if (m_bUS)
		{
			m_StatEurope.EnableWindow ( FALSE );
			m_StatUS.EnableWindow ( TRUE );
		  	if ( DataTEI == TRUE )
				UsData ( FALSE ) ;
 			else
		  	{
				strcpy(strRHS,GetStr ( Name,"DataSPID"));
				if ( strRHS	!= NULL )
					m_bDataSpid.SetWindowText ( strRHS );
				strcpy ( strRHS,GetStr ( Name,"DataDirectoryNumber"));
				if ( strRHS != NULL )
					m_bDataDirNum.SetWindowText ( strRHS );
			}
			
		  	if ( VoiceTEI == TRUE )
				UsVoice ( FALSE );
  			else
			{
				strcpy ( strRHS,GetStr ( Name,"VoiceSPID"));
				if ( strRHS != NULL )
					m_bVoiceSpid.SetWindowText ( strRHS );
				strcpy ( strRHS,GetStr ( Name,"VoiceDirectoryNumber"));
				if ( strRHS != NULL )
					m_bVoiceDirNum.SetWindowText ( strRHS );
  			}
  			
		}
		
		strcpy(strRHS,GetStr ( Name, "DialingMethod")) ;
		m_bDialingMethod.SetCurSel(m_bDialingMethod.FindString(-1,strRHS));

		strcpy(strRHS,GetStr ( Name, "AutoAnswer")) ;
		if(!strcmp(strRHS,"Yes"))
		{
			m_bPPAutoAnswerCalls.SetCheck(1);
			strcpy(strRHS,GetStr ( Name, "RingsToAnswer")) ;
			m_bRingsToAnswer.SetWindowText(strRHS);
			::EnableWindow ( ::GetDlgItem ( m_hWnd,IDC_RINGS_TO_ANSWER_DATA ),TRUE );
			::EnableWindow ( ::GetDlgItem ( m_hWnd,IDC_RINGS_TO_ANSWER_TEXT ),TRUE );

		}
		else
		{

			m_bPPAutoAnswerCalls.SetCheck(0);
			m_bRingsToAnswer.SetWindowText("0");
			::EnableWindow ( ::GetDlgItem ( m_hWnd,IDC_RINGS_TO_ANSWER_DATA ),FALSE );
			::EnableWindow ( ::GetDlgItem ( m_hWnd,IDC_RINGS_TO_ANSWER_TEXT ),FALSE );
		}

		strcpy(strRHS,GetStr ( Name, "PersistentDTRDialing")) ;
		if(!strcmp(strRHS,"Yes"))
			m_bPersistentDTRDialing.SetCheck(1);
		else
			m_bPersistentDTRDialing.SetCheck(0);

		strcpy(strRHS,GetStr ( Name, "CallLineId")) ;
		if(!strcmp(strRHS,"Yes"))
			m_bCallLineId.SetCheck(1);
		else
			m_bCallLineId.SetCheck(0);
	
		strcpy(strRHS,GetStr ( Name, "DataProtocol"));
		m_bDataProtocol.SetCurSel(m_bDataProtocol.FindString(-1,strRHS));
		m_bDataProtocol.GetLBText
			(m_bDataProtocol.GetCurSel(),m_szPPDataProtocol);
      m_bDataProtocol.EnableWindow ( FALSE );
      m_bDataProtocol.EnableWindow ( TRUE );

		strcpy(strRHS,GetStr ( Name, "DataCompression"));
		if ( !strcmp(strRHS,StrNull))
  			m_bDataCompression.SetCurSel(0);
		else
			m_bDataCompression.SetCurSel(m_bDataCompression.FindString(-1,strRHS));
		
		strcpy(strRHS,GetStr ( Name, "AutoDetection")) ;
		if(!strcmp(strRHS,"Yes"))
			m_bAutoDetection.SetCheck(1);
		else
			m_bAutoDetection.SetCheck(0);

		GetValues();

		OnDtrDialing () ;
		OnCallLineId () ;
		OnAutoAnswer () ;
		OnAutoDetection () ;

	}
	
	UpdateData ( FALSE );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIsdnTa::OnName()
{
	char TempName[40], strRHS[40];
	CString String;


	if ( m_cfgtype == kAdd )
	{
		m_bSectionName.GetWindowText ( m_szPPSectionName );
		if ( m_szPPSectionName.IsEmpty())
		{
			::MessageBox(GetSafeHwnd(),(LPCSTR)"Enter a name for the new configuration",
				IsdnMsgHeader,MB_OK);
			m_bSectionName.SetFocus();
			return;
		}

		sprintf(TempName,"%s",m_szPPSectionName);

		int index = 0;
		if  ( !isalnum(TempName[index]))
		{
			AfxMessageBox ( "Enter an alphabet or a digit as the first letter");
			m_bSectionName.SetFocus();
			return;
		}
		index++;
		while ( TempName[index] != '\0' )
		{
			if ( !(__iscsym(TempName[index])) && (TempName[index] != '_') )
			{
				String.LoadString ( IDS_NAMEINVALID );
				AfxMessageBox ( String );
				AfxMessageBox ( "Enter only alphabets,digits & underscore (a-z,A-Z,0-9,_) \
for the config name",MB_OK,0);
				//m_szPPSectionName = "";
				//UpdateData ( FALSE );
				m_bSectionName.SetFocus();
				return;
			}
			index++;
		}

		if ( IsThisADefaultCfg ( m_szPPSectionName ) )
		{
			AfxMessageBox ( IDS_NOTDEFAULT );
			m_szPPSectionName = "";
			UpdateData ( FALSE );
			m_bSectionName.SetFocus();
			return;
		}
		
		if ( GetPrivateProfileString ( m_szPPSectionName,NULL,StrNull,strRHS,
			sizeof(strRHS),ini_INIFilename ) != 0 )
		{
			::MessageBox(GetSafeHwnd(),"This Configuration Name already exists.\
Enter a new name",IsdnMsgHeader,MB_OK);
			m_szPPSectionName = "";
			UpdateData ( FALSE );
			m_bSectionName.SetFocus();	
			return;
		}
		m_bSectionName.GetWindowText ( m_szPPSectionName );
	}
}

void CIsdnTa::OnSwitch()
{
	// TODO: Add your control notification handler code here
	
	m_bNetworkSwitchType.GetLBText 
		( m_bNetworkSwitchType.GetCurSel(),m_szPPNetworkSwitchType );

	DetermineType ();

	m_szPPDataTEIControl.ResetContent();
	m_szPPVoiceTEIControl.ResetContent();
	
	FillComboBox ( ::GetDlgItem (m_hWnd,IDC_DATA_TEI), cfg_TEI );
	FillComboBox ( ::GetDlgItem (m_hWnd,IDC_VOICE_TEI), cfg_TEI );	
	
	m_szPPDataTEIControl.SetCurSel(0);
	m_szPPVoiceTEIControl.SetCurSel(0);
}


void CIsdnTa::OnSelDataTei()
{
	// TODO: Add your control notification handler code here
	
	CString String;

	m_szPPDataTEIControl.GetLBText 
		( m_szPPDataTEIControl.GetCurSel(),m_szPPDataTEI );
	
	String.LoadString ( IDS_DISABLED );
	if ( String.CompareNoCase ( m_szPPDataTEI ) == 0 )
	{
		if ( m_bUS )
			UsData ( FALSE );
		else
			EuroData ( FALSE );
	}
	else
	{
		if ( m_bUS )
			UsData ( TRUE );
		else
			EuroData ( TRUE );
	}
}

void CIsdnTa::OnSelVoiceTei()
{
	// TODO: Add your control notification handler code here
	
	CString String;
	
	m_szPPVoiceTEIControl.GetLBText 
		( m_szPPVoiceTEIControl.GetCurSel(),m_szPPVoiceTEI );

	String.LoadString ( IDS_DISABLED );
	if ( String.CompareNoCase ( m_szPPVoiceTEI ) == 0 )
	{
		if ( m_bUS )
			UsVoice ( FALSE );
		else
			EuroVoice ( FALSE );
	}
	else
	{
		if ( m_bUS )
			UsVoice ( TRUE );
		else
			EuroVoice ( TRUE );
	}
}

void CIsdnTa::OnNtType()
{
	// TODO: Add your control notification handler code here
  	m_RBtnNT.SetCheck (1);
	m_RBtnST.SetCheck (0);

	TaType();

}

void CIsdnTa::OnStType()
{
	// TODO: Add your control notification handler code here

	m_RBtnST.SetCheck (1);
	m_RBtnNT.SetCheck (0);

	TaType();

}

void CIsdnTa::OnDtrDialing()
{
	// TODO: Add your control notification handler code here
	if ( m_bPersistentDTRDialing.GetCheck() )
		m_bPPPersistentDTRDialing = TRUE;
	else
		m_bPPPersistentDTRDialing = FALSE;

}

void CIsdnTa::OnCallLineId()
{
	// TODO: Add your control notification handler code here
	if ( m_bCallLineId.GetCheck () )
		m_bPPCallLineId = TRUE;
	else
		m_bPPCallLineId = FALSE;

}

void CIsdnTa::OnAutoDetection()
{
	// TODO: Add your control notification handler code here

	if ( m_bAutoDetection.GetCheck () )
		m_bPPAutoDetection = TRUE ;
	else
		m_bPPAutoDetection = FALSE ;
}

void CIsdnTa::OnAutoAnswer()
{
	// TODO: Add your control notification handler code here
  	if ( m_bPPAutoAnswerCalls.GetCheck() )
	{
		m_bPPAutoAnswer = TRUE;
		::EnableWindow ( ::GetDlgItem ( m_hWnd,IDC_RINGS_TO_ANSWER_TEXT ),TRUE );
		::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_RINGS_TO_ANSWER_DATA),TRUE );
	}
	else
	{
		m_bPPAutoAnswer = FALSE;
		::EnableWindow ( ::GetDlgItem ( m_hWnd,IDC_RINGS_TO_ANSWER_TEXT ),FALSE );
		::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_RINGS_TO_ANSWER_DATA),FALSE );
	}	
}

void CIsdnTa::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp(0x20000 + IDD_ISDN_DEFAULT_PARAMETERS,HELP_CONTEXT);
	
}

void CIsdnTa::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CIsdnTa::OnOK()
{
	// TODO: Add extra validation here
	
	char TempName[40], strRHS[40];
	CString String;
	
	CString szDisabled;
	const int knMaxMSNLength = 24;
	const int knMaxDirLength = 24;
	const int knMaxSpidLength = 20 ;

	
	UpdateData ( TRUE );

	if ( m_cfgtype == kAdd )
	{
		m_bSectionName.GetWindowText ( m_szPPSectionName );
		if ( m_szPPSectionName.IsEmpty())
		{
			::MessageBox(GetSafeHwnd(),(LPCSTR)"Enter a name for the new configuration",
				IsdnMsgHeader,MB_OK);
			m_bSectionName.SetFocus();
			return;
		}

		sprintf(TempName,"%s",m_szPPSectionName);

		int index = 0;
		if  ( !isalnum(TempName[index]))
		{
			AfxMessageBox ( "Enter an alphabet or a digit as the first letter");
			m_bSectionName.SetFocus();
			return;
		}
		index++;

		while ( TempName[index] != '\0' )
		{
			if ( !(__iscsym(TempName[index])) && (TempName[index] != '_') )
			{
				String.LoadString ( IDS_NAMEINVALID );
				AfxMessageBox ( String );
				AfxMessageBox ( "Enter only alphabets,digits & underscore (a-z,A-Z,0-9,_) \
for the config name",MB_OK,0);
				//m_szPPSectionName = "";
				//UpdateData ( FALSE );
				m_bSectionName.SetFocus();
				return;
			}
			index++;
		}

		if ( IsThisADefaultCfg ( m_szPPSectionName ) )
		{
			AfxMessageBox ( IDS_NOTDEFAULT );
			m_szPPSectionName = "";
			UpdateData ( FALSE );
			m_bSectionName.SetFocus();
			return;
		}
		
		if ( GetPrivateProfileString ( m_szPPSectionName,NULL,StrNull,strRHS,
			sizeof(strRHS),ini_INIFilename ) != 0 )
		{
			::MessageBox(GetSafeHwnd(),"This Configuration Name already exists.\
Enter a new name",IsdnMsgHeader,MB_OK);
			m_szPPSectionName = "";
			UpdateData ( FALSE );
			m_bSectionName.SetFocus();	
			return;
		}
	}

	if ( m_bNetworkSwitchType.GetCurSel() == CB_ERR )
	{
		::MessageBox ( GetSafeHwnd(),"Please select a Switch Type",IsdnMsgHeader,MB_OK );
		m_bNetworkSwitchType.SetFocus();
 		return;
	}
	
	if ( m_szPPDataTEIControl.GetCurSel() == CB_ERR )
	{
		::MessageBox ( GetSafeHwnd(),"Please select a Data TEI",IsdnMsgHeader,MB_OK );
		m_szPPDataTEIControl.SetFocus();
 		return;
	}

	if ( m_szPPVoiceTEIControl.GetCurSel() == CB_ERR )
	{
		::MessageBox ( GetSafeHwnd(),"Please select a Voice TEI",IsdnMsgHeader,MB_OK );
		m_szPPVoiceTEIControl.SetFocus();
 		return;
	}

	if ( m_bDataProtocol.GetCurSel () == CB_ERR )
	{
		::MessageBox ( GetSafeHwnd(), "Please select a Data Protocol",IsdnMsgHeader,MB_OK );
		m_bDataProtocol.SetFocus();
		return;
	}
	
	if ( m_bDataCompression.GetCurSel () == CB_ERR )
	{
		::MessageBox ( GetSafeHwnd(), "Please select a Data Compression Technic",IsdnMsgHeader,MB_OK );
		m_bDataCompression.SetFocus();
		return;
	}

	if ( m_bDialingMethod.GetCurSel() == CB_ERR )
	{
		::MessageBox ( GetSafeHwnd(),"Please select a Dialing Method",IsdnMsgHeader,MB_OK );
		m_bDialingMethod.SetFocus ();
		return;
	}
	
	GetValues();

	szDisabled.LoadString ( IDS_DISABLED );
	if ( strcmp (m_szPPDataTEI,szDisabled ) ) 
	{
		if ( m_bUS )
		{
		 	if( m_szPPDataSpid.IsEmpty() )
			{
				::MessageBox(GetSafeHwnd(),"Enter Data SPID Number",IsdnMsgHeader,MB_OK);
				m_bDataSpid.SetFocus();
				return;
			}
			else
			{
				if ( (!IsValid ( m_szPPDataSpid )) || (strlen ( m_szPPDataSpid ) > knMaxSpidLength ))
				{
					::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 of length 20. ",IsdnMsgHeader,MB_OK );
					m_szPPDataSpid = "";
					UpdateData ( FALSE );
					m_bDataSpid.SetFocus();
					return;
				}
			}
			if ( m_szPPDataDirNum.IsEmpty () )
			{
				::MessageBox(GetSafeHwnd(),"Enter Data Directory Number",IsdnMsgHeader,MB_OK);
				m_bDataDirNum.SetFocus();
				return;
			}
			else
			{
				if (( !IsValid ( m_szPPDataDirNum )) || (strlen ( m_szPPDataDirNum ) > knMaxDirLength ))
				{
					::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 of length 24.",IsdnMsgHeader,MB_OK );
					m_szPPDataDirNum = "";
					UpdateData ( FALSE );
					m_bDataDirNum.SetFocus();
					return;
				}	
			}
		}
		else
		{
			if( m_szPPDataISDN.IsEmpty() )
			{
				::MessageBox(GetSafeHwnd(),"Enter Data ISDN Number",IsdnMsgHeader,MB_OK);
				m_bDataIsdn.SetFocus();
				return;
			
			}
			else
			{
				if ( !IsValid ( m_szPPDataISDN ) )
				{
					::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
					m_szPPDataISDN = "";
					UpdateData ( FALSE );
					m_bDataIsdn.SetFocus();
					return;
				 }
			}
			if ( m_szPPDataSub.IsEmpty () )
			{
				::MessageBox(GetSafeHwnd(),"Enter Data SubDirectory Address",IsdnMsgHeader,MB_OK);
				m_bDataSub.SetFocus();
				return;
			}
			else
			{
				if ( !IsValid ( m_szPPDataSub ))
				{
					::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
					m_szPPDataSub = "";
					UpdateData ( FALSE );
					m_bDataSub.SetFocus();
					return;
				}	
			}
		}
	}

  	if ( strcmp (m_szPPVoiceTEI,szDisabled ) ) 
	{
		if ( m_bUS )
		{
		 	if( m_szPPVoiceSpid.IsEmpty() )
			{
				::MessageBox(GetSafeHwnd(),"Enter Voice SPID Number",IsdnMsgHeader,MB_OK);
				m_bVoiceSpid.SetFocus();
				return;
			}
			else
			{
				if ( (!IsValid ( m_szPPVoiceSpid ))	|| (strlen ( m_szPPVoiceSpid ) > knMaxSpidLength))
				{
					::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
					m_szPPVoiceSpid = "";
					UpdateData ( FALSE );
					m_bVoiceSpid.SetFocus();
					return;
				 }
			}
			if ( m_szPPVoiceDirNum.IsEmpty () )
			{
				::MessageBox(GetSafeHwnd(),"Enter Voice Directory Number",IsdnMsgHeader,MB_OK);
				m_bVoiceDirNum.SetFocus();
				return;
			}
			else
			{
				if ( (!IsValid ( m_szPPVoiceDirNum )) || (strlen( m_szPPVoiceDirNum ) > knMaxDirLength )) 
				{
					::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
					m_szPPVoiceDirNum = "";
					UpdateData ( FALSE );
					m_bVoiceDirNum.SetFocus();
					return;
				}	
			}
		}
		else
		{
			if( m_szPPVoiceISDN.IsEmpty() )
			{
				::MessageBox(GetSafeHwnd(),"Enter Voice ISDN Number",IsdnMsgHeader,MB_OK);
				m_bVoiceIsdn.SetFocus();
				return;
			}
			else
			{
				if ( !IsValid ( m_szPPVoiceISDN ) )
				{
					::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
					m_szPPVoiceISDN = "";
					UpdateData ( FALSE );
					m_bVoiceIsdn.SetFocus();
					return;
				 }
			}
			if ( m_szPPVoiceSub.IsEmpty () )
			{
				::MessageBox(GetSafeHwnd(),"Enter Voice SubDirectory Address",IsdnMsgHeader,MB_OK);
				m_bVoiceSub.SetFocus();
				return;
			}
			else
			{
				if ( !IsValid ( m_szPPVoiceSub ))
				{
					::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
					m_szPPVoiceSub = "";
					UpdateData ( FALSE );
					m_bVoiceSub.SetFocus();
					return;
				}	
			}
		}
	}

	if ( !m_bUS )
	{
		ISDNSubAddressToMSN ( m_szPPDataMSN, m_szPPDataISDN, m_szPPDataSub );
		if ( (!m_szPPDataMSN.IsEmpty()) && (strlen(m_szPPDataMSN) > knMaxMSNLength ))
		{
			::MessageBox ( GetSafeHwnd(),"Length of Data ISDN:Data Sub exceeds 24.Enter new value",
				IsdnMsgHeader,MB_OK );
			m_szPPDataSub = "";
			UpdateData ( FALSE );
			m_bDataSub.SetFocus ();
			return ;
		}
		ISDNSubAddressToMSN ( m_szPPVoiceMSN, m_szPPVoiceISDN, m_szPPVoiceSub );
		if ( (!m_szPPVoiceMSN.IsEmpty()) && (strlen(m_szPPVoiceMSN) > 24 ))
		{
			::MessageBox ( GetSafeHwnd(),"Length of Voice ISDN:Voice Sub exceeds 24.Enter new value",
				IsdnMsgHeader,MB_OK );
			m_szPPVoiceSub = "";
			UpdateData ( FALSE );
			m_bVoiceSub.SetFocus ();
			return ;
		}
	}

	if ( m_bPPAutoAnswer == TRUE)
	{
		m_bRingsToAnswer.GetWindowText ( m_szRings );
		if ( m_szRings.IsEmpty ())
		{
			::MessageBox ( GetSafeHwnd(),"Please enter an integer value.",IsdnMsgHeader,MB_OK);
			m_bRingsToAnswer.SetFocus ();
			return;
		}

		if ( !ValidValue ( m_szRings) )
		{
			::MessageBox(GetSafeHwnd(),"Invalid Value.Enter only 1-255 range.",IsdnMsgHeader,MB_OK);
			UpdateData ( TRUE );
			m_szRings = "";
 			UpdateData ( FALSE );
			m_bRingsToAnswer.SetFocus() ;
			return ;
		}
	}

	if ( m_RBtnST.GetCheck()) 
		WriteStr("TA Type","ST");
	else if ( m_RBtnNT.GetCheck () )
		WriteStr("TA Type","NT");

	if ( model == MODEL_MTSR1_202ST)
		WriteStr("TA Type","ST");
	else if ( model == MODEL_MTSR1_202NT)
		WriteStr("TA Type","NT");
	WriteStr("NetworkSwitchType",m_szPPNetworkSwitchType);
	WriteStr("DataTEI",m_szPPDataTEI);
	WriteStr("VoiceTEI",m_szPPVoiceTEI);

	WriteStr ( "DataSPID",m_szPPDataSpid);
	WriteStr ( "DataDirectoryNumber",m_szPPDataDirNum);
	WriteStr ( "VoiceSPID", m_szPPVoiceSpid );
	WriteStr ( "VoiceDirectoryNumber", m_szPPVoiceDirNum );

	WriteStr("DataMSN",m_szPPDataMSN );
	WriteStr("VoiceMSN",m_szPPVoiceMSN );
	
	if ( m_bPPPersistentDTRDialing == TRUE )
		WriteStr ( "PersistentDTRDialing","Yes");
 	else
		WriteStr ( "PersistentDTRDialing","No");


	if ( m_bPPCallLineId == TRUE )
		WriteStr ( "CallLineId","Yes" );
	else
		WriteStr ( "CallLineId","No" );

	if ( m_bPPAutoDetection == TRUE )
		WriteStr ( "AutoDetection", "Yes" );
	else
		WriteStr ( "AutoDetection", "No" );

	if ( m_bPPAutoAnswer == TRUE)
	{
		WriteStr ( "AutoAnswer","Yes");
		WriteStr ( "RingsToAnswer",m_szRings );
	}
	else 
	{
		WriteStr ( "AutoAnswer","No");
		WriteStr ( "RingsToAnswer","1" );
	}

	WriteStr ( "DataProtocol", m_szPPDataProtocol );
	WriteStr ( "DataCompression", m_szPPDataCompression );
	WriteStr ( "DialingMethod",m_szPPDialingMethod );
 
	if ( IsThisADefaultCfg ( m_szPPSectionName ) == FALSE )
	{
		if ( IsThisNameAlreadyExists ( m_szPPSectionName ) == FALSE )
		{
			WritePrivateProfileString ( "User Config",m_szPPSectionName,
				"Defined",ini_INIFilename );
		}
	}

	CDialog::OnOK();

}

BOOL CIsdnTa::IsThisNameAlreadyExists ( CString Section )
{
	char buffer[512];
	char *token;
	char *seps = "\0";
	int dwCount = 0;
	int length = 0;
	int total;

 	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	if ( total != 0 )
	{
		token = strtok ( buffer, seps );
		while ( token != NULL)
		{
			if ( !Section.CompareNoCase ( token ))
				return TRUE;
			else
			{
				length = length + strlen ( token ) + 1;	// +1 for the NULL character
		      token = strtok( &buffer[length], seps );
			}
		}
	}
	return FALSE;			
}

void  CIsdnTa::FillComboBox ( HWND hCtrlWnd, ini_tpValuePair Table )
{
	CString	String;
	WORD		wPosition;
	int		i;
	
	for ( i=0; Table[i].StringID; i++ )
	{
		String.LoadString ( Table[i].StringID );
		wPosition = LOWORD ( ::SendMessage( hCtrlWnd, CB_ADDSTRING, 0, 
									(LPARAM) (LPCTSTR) String) );
	}
} 

BOOL CIsdnTa::IsThisADefaultCfg ( CString SectionName )
{
	// This function checks if the name selected is a Default 
	// configuration.  The return values are as follows.
	// TRUE	if m_szPPSectionName is a Default
	// FALSE	if m_szPPSectionName is not a Default

	CString	szSection, szEntry;
	char		szDefaultName[80], buff[3];
	int		i = 1;

	szSection.LoadString ( IDS_DEFAULTCONFIG );
	szEntry.LoadString ( IDS_CONFIG );
	_itoa ( i, buff, 10 );
	szEntry += buff;
	while ( GetPrivateProfileString ( szSection, szEntry, "", szDefaultName, 80, ini_INIFilename ) )
	{
		if ( (SectionName.CompareNoCase ( szDefaultName )) == 0 )
		{
			return TRUE;
		}
		i++;
		szEntry.LoadString ( IDS_CONFIG );
		_itoa ( i, buff, 10 );
		szEntry += buff;
	}
	return FALSE;
}

void CIsdnTa::WriteStr(LPCSTR strLHS,LPCSTR strRHS)
{
	WritePrivateProfileString(m_szPPSectionName,strLHS,strRHS,ini_INIFilename);
	return;
}

LPCSTR CIsdnTa::GetStr(LPCSTR section,LPCSTR strLHS)
{
	char strRHS[32];
	GetPrivateProfileString(section,strLHS,StrNull,strRHS,32,ini_INIFilename);
	return strRHS;
}

BOOL CIsdnTa::IsValid ( CString Value )
{
	char TempValue[40];
	int index = 0;

	sprintf(TempValue,"%s",Value );
	while ( TempValue[index] != '\0' )
	{
		if ( !isdigit(TempValue[index]))
 		{
			return FALSE ;
  		}
		index++;
	}
	return TRUE ;
}

void CIsdnTa::MSNtoISDNSubAddress ( CString szMSN, CString& szISDN, CString& szSubAddress )
{
	int	nPosition;
	int	nLength;

	// Convert the MSN's to ISDN and SubAddress
	if ( !szMSN.IsEmpty () )
	{
		// Look for the : separating the ISDN and Subaddress
		if ( (nPosition = szMSN.Find ( ":" )) > 0 )
		{
			szISDN = szMSN.Left ( nPosition );
			nLength = szMSN.GetLength ();
			szSubAddress = szMSN.Right ( nLength - nPosition - 1 );
		}
		else
		{
			szISDN = szMSN;
			szSubAddress.Empty ();
		}
	}
}

void CIsdnTa::ISDNSubAddressToMSN ( CString& szMSN, CString szISDN, CString szSubAddress )
{
	// Convert the ISDN Number and Subaddress to the MSN Number
	// MSN = ISDN:Subaddress
	szMSN.Empty ();
	if ( !szISDN.IsEmpty() )
	{
		szMSN = szISDN;
		if ( !szSubAddress.IsEmpty() )
		{
			szMSN += ":";
			szMSN += szSubAddress;
		}
	}
}

void CIsdnTa::GetValues ()
{
	m_bNetworkSwitchType.GetLBText 
		( m_bNetworkSwitchType.GetCurSel(),m_szPPNetworkSwitchType );
	m_szPPDataTEIControl.GetLBText 
		( m_szPPDataTEIControl.GetCurSel(),m_szPPDataTEI );
	m_szPPVoiceTEIControl.GetLBText 
		( m_szPPVoiceTEIControl.GetCurSel(),m_szPPVoiceTEI );

 	m_bDataSpid.GetWindowText ( m_szPPDataSpid );
	m_bVoiceSpid.GetWindowText ( m_szPPVoiceSpid );
	m_bDataDirNum.GetWindowText ( m_szPPDataDirNum );
	m_bVoiceDirNum.GetWindowText ( m_szPPVoiceDirNum );

	m_bDataIsdn.GetWindowText ( m_szPPDataISDN );
	m_bVoiceIsdn.GetWindowText ( m_szPPVoiceISDN );
	m_bDataSub.GetWindowText ( m_szPPDataSub );
	m_bVoiceSub.GetWindowText ( m_szPPVoiceSub );

	m_bRingsToAnswer.GetWindowText ( m_szRings );

	m_bDataProtocol.GetLBText 
		( m_bDataProtocol.GetCurSel(),m_szPPDataProtocol );
	m_bDataCompression.GetLBText 
		( m_bDataCompression.GetCurSel(),m_szPPDataCompression );

	m_bDialingMethod.GetLBText 
		( m_bDialingMethod.GetCurSel(),m_szPPDialingMethod );

	return;
}

BOOL CIsdnTa::SwitchType ( CString String )
{
	CString str;
	for ( int i = 0;cfg_NetworkSwitchTypesDom[i].StringID;i++ )
	{
		str.LoadString ( cfg_NetworkSwitchTypesDom[i].StringID ) ;
		if ( String.CompareNoCase ( str ) == 0 )
		{
			return TRUE ;
			break ;
		}
	}
	return FALSE;
}

void CIsdnTa::UsData ( BOOL set )
{
	if ( set == FALSE )
	{
		UpdateData ( TRUE );
		m_szPPDataSpid = "";
		m_szPPDataDirNum = "";
		UpdateData ( FALSE );
	}
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_SPID_TEXT),set );
  	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_SPID),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_DIR_TEXT),set ); 
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_DIR_NUMBER),set );
	
	return;
}

void CIsdnTa::UsVoice ( BOOL set )
{
  	if ( set == FALSE )
	{
	 	UpdateData ( TRUE );
		m_szPPVoiceSpid = "";
		m_szPPVoiceDirNum = "";
		UpdateData ( FALSE );
	} 
  	
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_SPID_TEXT),set ); 
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_SPID),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_DIR_TEXT),set ); 
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_DIR_NUMBER),set);

	return;
}

void CIsdnTa::EuroData ( BOOL set )
{
	if ( set == FALSE )
	{
		UpdateData ( TRUE );
		m_szPPDataISDN = "";
		m_szPPDataSub = "";
		UpdateData ( FALSE );
	}
	
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_ISDN_TEXT),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_SUB_TEXT),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_ISDN),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_SUB),set );

	return;

}

void CIsdnTa::EuroVoice ( BOOL set )
{
	if ( set == FALSE )
	{
		UpdateData ( TRUE );
		m_szPPVoiceISDN = "";
		m_szPPVoiceSub = "";
		UpdateData ( FALSE );
  	}
  	
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_ISDN_TEXT),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_SUB_TEXT),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_ISDN),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_SUB),set );

	return;

}

void CIsdnTa::DetermineType ()
{
 	m_bUS = SwitchType ( m_szPPNetworkSwitchType );

 	if ( m_bUS )
	{
		m_StatUS.EnableWindow ( TRUE );
		m_StatEurope.EnableWindow ( FALSE );
		
		UsData ( TRUE );
		UsVoice ( TRUE );

		EuroData ( FALSE );
		EuroVoice ( FALSE );
	}
	else
	{
		m_StatUS.EnableWindow ( FALSE );
		m_StatEurope.EnableWindow ( TRUE );

		UsData ( FALSE );
		UsVoice ( FALSE );

		EuroData ( TRUE );
		EuroVoice ( TRUE );
	}
	return;
}
	
BOOL CIsdnTa::ValidValue ( CString TimeValue )
{
	char TempValue[40];
	int index = 0;
	int TempIntValue ;

	sprintf(TempValue,"%s",TimeValue );
	while ( TempValue[index] != '\0' )
	{
		if ( (!isdigit(TempValue[index])) || (index > 2) )
 		{
			return FALSE ;
  		}
		index++;
	}
	TempIntValue = StrToInt ( TimeValue ) ;
	if (( TempIntValue < 1) || (TempIntValue > 255 ))
		return FALSE ;
	else
		return TRUE ;
}

int CIsdnTa::StrToInt ( CString szStr )
{
	int nInt = 0;
	int nLength = szStr.GetLength ();
	int i,nDec = 1;

	for ( i=nLength-1 ; i>=0 ; i-- )
	{
		nInt += ( nDec * (szStr[i] - '0') );
		nDec *= 10;
	}

	return nInt;
}

void CIsdnTa::TaType()
{
	if (model == MODEL_MTSR1_202NT)
		m_nType = isdnta_kDomestic;
	if ( model == MODEL_MTSR1_202ST)
		m_nType = isdnta_kInternational;

	if ((model != MODEL_MTSR1_202ST) && (model != MODEL_MTSR1_202NT)) 
	{
		if ( m_RBtnNT.GetCheck() )
			m_nType = isdnta_kDomestic;
		else if ( m_RBtnST.GetCheck () )
			m_nType = isdnta_kInternational;
		else
			m_nType = isdnta_kUndefined;
	}

	m_bNetworkSwitchType.ResetContent();
	m_szPPDataTEIControl.ResetContent();
	m_szPPVoiceTEIControl.ResetContent();
	m_bDataProtocol.ResetContent();
	m_bDialingMethod.ResetContent();
	m_bDataCompression.ResetContent();
	
	UpdateData ( FALSE );

	if ( m_nType == isdnta_kDomestic )
		FillComboBox ( ::GetDlgItem (m_hWnd,IDC_NETWORK_SWITCH_TYPE), cfg_NetworkSwitchTypesDom );
	else 
		FillComboBox ( ::GetDlgItem (m_hWnd,IDC_NETWORK_SWITCH_TYPE), cfg_NetworkSwitchTypes );

	FillComboBox ( ::GetDlgItem (m_hWnd,IDC_DATA_TEI), cfg_TEI );
	FillComboBox ( ::GetDlgItem (m_hWnd,IDC_VOICE_TEI), cfg_TEI );	

	if ( m_nType == isdnta_kInternational )
		FillComboBox ( ::GetDlgItem (m_hWnd,IDC_DATA_PROTOCOL), cfg_DataProtocolsInt );
	else if ( m_nType == isdnta_kDomestic )
		FillComboBox ( ::GetDlgItem (m_hWnd,IDC_DATA_PROTOCOL), cfg_DataProtocolsDom );
	else if ( m_nType == isdnta_kUndefined )
		FillComboBox ( ::GetDlgItem (m_hWnd,IDC_DATA_PROTOCOL), cfg_DataProtocols );
	
	
	FillComboBox ( ::GetDlgItem (m_hWnd,IDC_DATA_COMPRESSION), cfg_DataCompression );
	FillComboBox ( ::GetDlgItem (m_hWnd,IDC_DIALING_METHOD), cfg_DialingMethods );

	if ( m_cfgtype == kAdd )
	{
		m_bNetworkSwitchType.SetCurSel(0);

		m_szPPDataTEIControl.SetCurSel(0);
		m_szPPVoiceTEIControl.SetCurSel(0);

		m_bPersistentDTRDialing.SetCheck(0);
		m_bCallLineId.SetCheck(1);
		m_bAutoDetection.SetCheck (0);
		m_bPPAutoAnswerCalls.SetCheck(0);
		m_bRingsToAnswer.SetWindowText("0");

  		m_bDataProtocol.SetCurSel(m_bDataProtocol.FindStringExact ( -1,"MLPPP"));
		m_bDataProtocol.GetLBText ( m_bDataProtocol.GetCurSel(),m_szPPDataProtocol );
		m_bDataProtocol.EnableWindow ( FALSE );
		m_bDataCompression.SetCurSel(0);
		m_bDialingMethod.SetCurSel(0);

		GetValues();
		DetermineType();

		OnDtrDialing () ;
		OnCallLineId () ;
		OnAutoAnswer () ;
		OnAutoDetection () ;

	}

}

void CIsdnTa::OnUpName()
{
	// TODO: Add your control notification handler code here
	
	OnName();
} 
