//Sudha 9 Dec 1997
#ifndef ISDN_H
#define ISDN_H 1

#define	isdnta_kUndefined			0
#define	isdnta_kInternational	1
#define	isdnta_kDomestic			2

// isdnta.h : header file
//

typedef struct {
	int		StringID;
	int		nNum;
} ini_tValuePair, *ini_tpValuePair;

ini_tValuePair	cfg_DataProtocols[];
ini_tValuePair	cfg_DataProtocolsDom[];
ini_tValuePair	cfg_DataProtocolsInt[];
ini_tValuePair	cfg_DataCompression[];
ini_tValuePair	cfg_DialingMethods[];
ini_tValuePair	cfg_NetworkSwitchTypes[];
ini_tValuePair	cfg_NetworkSwitchTypesDom[];
ini_tValuePair	cfg_TEI[];
ini_tValuePair cfg_NoYes[];
ini_tValuePair cfg_null[];

/////////////////////////////////////////////////////////////////////////////
// CIsdnTa dialog

class CIsdnTa : public CDialog
{
// Construction
public:
	CIsdnTa(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CIsdnTa)
	enum { IDD = IDD_ISDN_DIALOG };
	CButton	m_static_ta_type;
	CButton	m_StatEurope;
	CButton	m_StatUS;
	CButton	m_bCancel;
	CComboBox	m_bDataCompression;
	CComboBox	m_bDataProtocol;
	CButton	m_bAutoDetection;
	CComboBox	m_bDialingMethod;
	CEdit	m_bRingsToAnswer;
	CButton	m_bPPAutoAnswerCalls;
	CButton	m_bCallLineId;
	CButton	m_bPersistentDTRDialing;
	CButton	m_RBtnST;
	CButton	m_RBtnNT;
	CEdit	m_bDataSub;
	CEdit	m_bVoiceSub;
	CEdit	m_bVoiceIsdn;
	CEdit	m_bDataIsdn;
	CEdit	m_bVoiceDirNum;
	CEdit	m_bDataDirNum;
	CEdit	m_bVoiceSpid;
	CEdit	m_bDataSpid;
	CComboBox	m_szPPVoiceTEIControl;
	CComboBox	m_szPPDataTEIControl;
	CComboBox	m_bNetworkSwitchType;
	CEdit	m_bSectionName;
	CString	m_szPPSectionName;
	CString	m_szPPNetworkSwitchType;
	CString	m_szPPDataTEI;
	CString	m_szPPVoiceTEI;
	CString	m_szPPDataSpid;
	CString	m_szPPVoiceSpid;
	CString	m_szPPDataDirNum;
	CString	m_szPPVoiceDirNum;
	CString	m_szPPDataISDN;
	CString	m_szPPVoiceISDN;
	CString  m_szPPDataMSN;
	CString  m_szPPVoiceMSN;
	CString	m_szPPVoiceSub;
	CString	m_szPPDataSub;
	BOOL	m_bPPPersistentDTRDialing;
	BOOL	m_bPPCallLineId;
	BOOL	m_bPPAutoAnswer;
	CString	m_szRings;
	CString	m_szPPDialingMethod;
	BOOL	m_bPPAutoDetection;
	CString	m_szPPDataProtocol;
	CString	m_szPPDataCompression;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;

//Operations
public:
	BOOL							m_bUS;
   int							m_nType;
	
	BOOL IsThisNameAlreadyExists ( CString Section );

   void FillComboBox ( HWND hCtrlWnd, ini_tpValuePair Table);
   BOOL IsThisADefaultCfg ( CString SectionName );

   void WriteStr(LPCSTR strLHS,LPCSTR strRHS );
   LPCSTR GetStr(LPCSTR Section,LPCSTR strLHS );

	BOOL IsValid ( CString Value );

	BOOL ValidValue ( CString TimeValue );
	int StrToInt ( CString szStr );
	
  	void TaType ();
	void ISDNSubAddressToMSN ( CString& szMSN, CString szISDN, CString szSubAddress );
	void MSNtoISDNSubAddress ( CString szMSN, CString& szISDN, CString& szSubAddress );

	void GetValues () ;

	BOOL SwitchType ( CString String );

	void UsData ( BOOL set );
	void UsVoice ( BOOL set );

	void EuroData ( BOOL set );
	void EuroVoice ( BOOL set );
	
	void DetermineType ();
	void OnName();

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CIsdnTa)
	virtual BOOL OnInitDialog();
	afx_msg void OnDtrDialing();
	afx_msg void OnNtType();
	afx_msg void OnStType();
	afx_msg void OnCallLineId();
	afx_msg void OnAutoAnswer();
	afx_msg void OnAutoDetection();
	afx_msg void OnHelp();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnSelVoiceTei();
	afx_msg void OnSwitch();
	afx_msg void OnSelDataTei();
	afx_msg void OnUpName();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif     
