// logview.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "logview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define MaxINIString 150   // Maximum length of string in the CNF File.

/////////////////////////////////////////////////////////////////////////////
// Clogview dialog


Clogview::Clogview(CWnd* pParent /*=NULL*/)
	: CDialog(Clogview::IDD, pParent)
{
	//{{AFX_DATA_INIT(Clogview)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void Clogview::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Clogview)
	DDX_Control(pDX, IDC_LIST_LOG, m_ctrl_list_log);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(Clogview, CDialog)
	//{{AFX_MSG_MAP(Clogview)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Clogview message handlers

BOOL Clogview::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
		char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

		GetWindowText (CurrentHeading, 80) ;
		SubHeadingPointer = strchr (CurrentHeading, '-') ;
		if (SubHeadingPointer == NULL)
			SubHeadingPointer = CurrentHeading ;
		else
			SubHeadingPointer += 2 ;

		sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);

		SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("CLOSE1", "CLOSE2", "CLOSE3", "CLOSE4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	char Buf[128];	
	char *ch;

	CStdioFile input;
	char *FileName = LogFileName;
	if (!input.Open(FileName, CFile::modeRead | CFile::typeText))
	{
		::MessageBox (GetSafeHwnd(), "Could not open log file", "Log View", MB_OK);
		return (FALSE);
	}
	////Read the strings and if there is a newline character, don't display it
	////Also if the buffer is empty, don't add the empty string to the listbox.
	while((input.ReadString(Buf , MaxINIString)) != NULL)
	{
		if ((ch = strchr (Buf, (int)'\n')) != NULL)
			*ch = '\0';
		if ((ch = strchr (Buf, (int)'#')) != NULL)  /* ..Imran*/
			*ch = '\0';
		if (Buf[0])
			m_ctrl_list_log.InsertString (m_ctrl_list_log.GetCount(), Buf);
	}
	input.Close();

	CenterWindow();
	UpdateData (FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}
