// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	LSLDLG.CPP
// Description       :	Defines Classes :
//									CLSLDlg		: Function of LSL Dialog
//									CLSLPortDlg	: Function of LSL Port Tabs
//									CLSLTab		: Function of LSL Port TabDialog
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "lsldlg.h"
#include "tabdlg.h"

// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------

LPCSTR LSLSectionHeader = "LSL Multiplex Layer";         
LPCSTR LSLMsgHeader = "MultiRouter LSL Setup";

#define Max_BufferSize 0xffffffff
#define Min_BufferSize 0

#define Max_RxMinLimit 0xffff
#define Min_RxMinLimit 0

#define Max_TxMaxLimit 0xffff
#define Min_TxMaxLimit 0

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLSLDlg dialog


CLSLDlg::CLSLDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLSLDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLSLDlg)
	m_PrintfBuffer = FALSE;
	m_LocalConsole = FALSE;
	m_Printf = FALSE;
	m_PrintfAlarm = FALSE;
	m_PrintfSNAP = FALSE;
	m_PrintfSNMP = FALSE;
//	m_nWANPort = 0;
//	m_nBufferSize = 0;
	//}}AFX_DATA_INIT
}

void CLSLDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLSLDlg)
//	DDX_Control(pDX, IDC_WAN_PORTS, m_WANPortWnd);
//	DDX_Control(pDX, IDC_BUFFER_SIZE, m_BufSizeWnd);
	DDX_Check(pDX, IDC_BUFFER, m_PrintfBuffer);
	DDX_Check(pDX, IDC_LOCAL_CONSOLE, m_LocalConsole);
	DDX_Check(pDX, IDC_PRINTF, m_Printf);
	DDX_Check(pDX, IDC_PRINTF_ALARM, m_PrintfAlarm);
	DDX_Check(pDX, IDC_SNAP, m_PrintfSNAP);
	DDX_Check(pDX, IDC_SNMP, m_PrintfSNMP);
//	DDX_Text(pDX, IDC_WAN_PORTS, m_nWANPort);
//	DDX_Text(pDX, IDC_BUFFER_SIZE, m_nBufferSize);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLSLDlg, CDialog)
	//{{AFX_MSG_MAP(CLSLDlg)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
//	ON_BN_CLICKED(IDC_LSLPORT_CONFIG, OnLSLPortConfig)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLSLDlg message handlers

BOOL CLSLDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	char szBuf[30];

//Get the values of all LSL parameters from INI file.
	
   //Get the BOOL parameters.
	GetPrivateProfileString(LSLSectionHeader, (LPCSTR) "LSL Printf",
					 StrDisabled,(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_Printf = TRUE;
	else m_Printf = FALSE;

	GetPrivateProfileString(LSLSectionHeader, (LPCSTR) "LSL Printf Alarm",
					 StrDisabled,(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_PrintfAlarm = TRUE;
	else m_PrintfAlarm = FALSE;

	GetPrivateProfileString(LSLSectionHeader, (LPCSTR) "LSL Printf Buffer",
					 StrDisabled,(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_PrintfBuffer = TRUE;
	else m_PrintfBuffer = FALSE;

	GetPrivateProfileString(LSLSectionHeader, (LPCSTR) "LSL Printf SNAP",
					 StrDisabled,(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_PrintfSNAP = TRUE;
	else m_PrintfSNAP = FALSE;

	GetPrivateProfileString(LSLSectionHeader, (LPCSTR) "LSL Printf SNMP",
					 StrDisabled,(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_PrintfSNMP = TRUE;
	else m_PrintfSNMP = FALSE;

	GetPrivateProfileString(LSLSectionHeader, (LPCSTR) "LSL Local Console Printing",
					 StrDisabled,(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_LocalConsole = TRUE;
	else m_LocalConsole = FALSE;

#if 0
   //Get the uint parameters.
	m_nWANPort = GetPrivateProfileInt(LSLSectionHeader, 
				(LPCSTR) "LSL Number of WAN Ports",0,
				(LPCSTR) IniInWinForm);

	GetPrivateProfileString(LSLSectionHeader, 
				(LPCSTR) "LSL Total Buffer Size",(LPCSTR) "200000",
				(LPSTR) szBuf,sizeof(szBuf),
				(LPCSTR) IniInWinForm);
	m_nBufferSize = atol(szBuf);
#endif

	// TODO: Add extra initialization here
	
//Update the Dialog Box fields.
	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLSLDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_LSL_CONFIG,HELP_CONTEXT);
	
}
BOOL CLSLDlg::ValidEditFields()
{
//Validate the integer edit fields
#if 0
   char  ErMessage[128];
	if((m_nWANPort < MIN_TAB_NUM) || (m_nWANPort > Max_WANPort))
	{
      sprintf(ErMessage,"Invalid Number of ports.\n Must be %d to %d",
               MIN_TAB_NUM, Max_WANPort);
		RouMsgBox( ErMessage, LSLMsgHeader, MB_OK | MB_ICONEXCLAMATION);
		m_WANPortWnd.SetFocus();
      return(FALSE);
   }	
	if((m_nBufferSize < Min_BufferSize) || (m_nBufferSize > Max_BufferSize))
	{
		RouMsgBox("Invalid Buffer Size",LSLMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		m_BufSizeWnd.SetFocus();
      return(FALSE);
   }	
#endif
   return(TRUE);
}

void CLSLDlg::OnOK()
{
// Update the parameters from the Dialog Box.
   if(!UpdateData(TRUE))
      return;

//if the parameters are invalid return
   if(!ValidEditFields())
	   return;
	
	LPCSTR temp;
	char m_szTempBuf[12];
	temp = (char *)m_szTempBuf;

// Write the LSL parameters to the INI file.

   //Write the BOOL parameters
	if(m_LocalConsole)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(LSLSectionHeader, 
			(LPCSTR) "LSL Local Console Printing", temp, 
			(LPCSTR) IniInWinForm);

	if(m_Printf)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(LSLSectionHeader, (LPCSTR) "LSL Printf", temp, 
			(LPCSTR) IniInWinForm);

	if(m_PrintfSNMP)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(LSLSectionHeader, 
			(LPCSTR) "LSL Printf SNMP", temp, 
			(LPCSTR) IniInWinForm);

	if(m_PrintfAlarm)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(LSLSectionHeader, 
			(LPCSTR) "LSL Printf Alarm", temp, 
			(LPCSTR) IniInWinForm);

	if(m_PrintfBuffer)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(LSLSectionHeader, 
			(LPCSTR) "LSL Printf Buffer", temp, 
			(LPCSTR) IniInWinForm);

	if(m_PrintfSNAP)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(LSLSectionHeader, 
			(LPCSTR) "LSL Printf SNAP", temp, 
			(LPCSTR) IniInWinForm);

#if 0
   //Write the uint Parameters.
	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_nWANPort,"");
	WritePrivateProfileString(LSLSectionHeader,
			(LPCSTR) "WAN Number of Ports",(LPSTR)m_szTempBuf,
			(LPCSTR) IniInWinForm);

	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10ld%s", m_nBufferSize,"");
	WritePrivateProfileString(LSLSectionHeader,
			(LPCSTR) "LSL Total Buffer Size",(LPSTR)m_szTempBuf,
			(LPCSTR) IniInWinForm);
#endif
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CLSLDlg::OnLSLPortConfig()
{
	if(!UpdateData(TRUE))	//Update the no. of ports
	 	return;
#if 0
   char  ErMessage[128];
	if((m_nWANPort < MIN_TAB_NUM) || (m_nWANPort > Max_WANPort))
	{
      sprintf(ErMessage,"Invalid Number of ports.\n Must be %d to %d",
               MIN_TAB_NUM, Max_WANPort);
		MessageBox( ErMessage, LSLMsgHeader, MB_OK | MB_ICONEXCLAMATION);
		m_WANPortWnd.SetFocus();
      return;
   }	
#endif

   AfxGetApp()->LoadCursor(IDC_WAIT);
   AfxGetApp()->DoWaitCursor(1);

	CLSLTab cLSLTab(this);
	cLSLTab.DoModal();      
}
/////////////////////////////////////////////////////////////////////////////
// CLSLPortDlg dialog


CLSLPortDlg::CLSLPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLSLPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLSLPortDlg)
	m_MACAddress = "";
	m_PortEnable = FALSE;
	m_Speed = "";
	//}}AFX_DATA_INIT
     
	Create(IDD,NULL);
}

void CLSLPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLSLPortDlg)
//	DDX_Control(pDX, IDC_ADD_MAC, m_MACAddTxt);
//	DDX_Control(pDX, IDC_MAC_ADDRESS, m_edMACAddress);
//	DDX_Text(pDX, IDC_MAC_ADDRESS, m_MACAddress);
	DDX_Check(pDX, IDC_PORT_ENABLE, m_PortEnable);
	DDX_CBString(pDX, IDC_SPEED, m_Speed);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLSLPortDlg, CDialog)
	//{{AFX_MSG_MAP(CLSLPortDlg)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLSLPortDlg message handlers
void CLSLPortDlg::OnOK()
{
	// TODO: Add extra validation here
	
	if(!UpdateData(TRUE))
		return;
   if(!ValidEditFields())
      return;
	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK);
}

void CLSLPortDlg::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void CLSLPortDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_LSL_PORT_CONFIG,HELP_CONTEXT);
	
}
LRESULT CLSLPortDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}
void CLSLPortDlg::PostNcDestroy(void)
{
	delete this;
}
BOOL CLSLPortDlg::ValidEditFields()
{
#if 0
	if((m_nRxMinLimit < Min_RxMinLimit) || (m_nRxMinLimit > Max_RxMinLimit))
	{
		RouMsgBox("Invalid Rx Minimum Limit",LSLMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		m_RxMinWnd.SetFocus();
		return(FALSE);
	}
	if((m_nTxMaxLimit < Min_TxMaxLimit) || (m_nTxMaxLimit > Max_TxMaxLimit))
	{
		RouMsgBox("Invalid Tx Maximum Limit", LSLMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		m_TxMaxWnd.SetFocus();
		return(FALSE);
	}
#endif
   return(TRUE);
}

int	CLSLPortDlg::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}
/////////////////////////////////////////////////////////////////////////////
// CLSLTab Tabdialog


CLSLTab::CLSLTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(CLSLTab::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLSLTab)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	tabcount = ((CLSLDlg *) pParent)->m_nWANPort;
	//Limit the tabcount
	if(tabcount > Max_WANPort) tabcount = Max_WANPort;
	if(tabcount < MIN_TAB_NUM) tabcount = MIN_TAB_NUM;
	
	for(int i=0; i < tabcount ; i++)
		m_pdlgLSL[i] = new CLSLPortDlg(this);
}

void CLSLTab::DoDataExchange(CDataExchange* pDX)
{
	CTabDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLSLTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLSLTab, CTabDialog)
	//{{AFX_MSG_MAP(CLSLTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLSLTab message handlers

void CLSLTab::GetConfig()
{
	char szBuf[30];
 //Get all the parameters for Ports

   //Get the BOOL parameters.
   
   	char field[35];
   	for(int i = 0; i < tabcount ; i++)
   	{
		char Buf[12];
		_itoa(i, Buf, 10);
		
		//char* field;
		strcpy(field, "LSL Port");
		strcat(field,Buf);
		strcpy(Buf,field);

	GetPrivateProfileString(LSLSectionHeader,
		(LPCSTR) Buf,  StrDisabled,
		(LPSTR) szBuf ,sizeof(szBuf), 
		(LPCSTR) IniInWinForm);

	if(!strcmp(szBuf,StrEnabled))
		m_pdlgLSL[i]->m_PortEnable = TRUE;
	else m_pdlgLSL[i]->m_PortEnable = FALSE;

   //Get the CString parameters.
	strcpy(field, Buf);
    strcat(field," Speed");	
	GetPrivateProfileString(LSLSectionHeader, (LPCSTR) field,
					StrNull,(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) IniInWinForm);
	m_pdlgLSL[i]->m_Speed = szBuf ;
    
#if 0
    strcpy(field, strchr(Buf,(int) 'P'));
    strcat(field," MAC Address");
	GetPrivateProfileString(LSLSectionHeader, (LPCSTR) field,
					StrNull,(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) IniInWinForm);
	m_pdlgLSL[i]->m_MACAddress = szBuf ;
	if (i==0) {
		m_pdlgLSL[i]->m_MACAddTxt.EnableWindow(FALSE);
		m_pdlgLSL[i]->m_edMACAddress.EnableWindow(FALSE);
	} else {
		m_pdlgLSL[i]->m_MACAddTxt.EnableWindow(TRUE);
		m_pdlgLSL[i]->m_edMACAddress.EnableWindow(TRUE);
	}
   //Get the uint parameters.          
	strcpy(field, Buf);
    strcat(field," Rx Minimum Buffer Limit");   
	m_pdlgLSL[i]->m_nRxMinLimit = GetPrivateProfileInt(LSLSectionHeader, 
				(LPCSTR) field,4,
				(LPCSTR) IniInWinForm);
    
    strcpy(field, Buf);
    strcat(field," Tx Maximum Buffer Limit");
	m_pdlgLSL[i]->m_nTxMaxLimit = GetPrivateProfileInt(LSLSectionHeader, 
				(LPCSTR) field,16,
				(LPCSTR) IniInWinForm);
#endif
    //Update the Dialog fields  
	m_pdlgLSL[i]->UpdateData(FALSE);
	}
}

BOOL CLSLTab::OnInitDialog()
{
	CDialog::OnInitDialog();
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;


	//Add the Tabs
	for (int i=0; i < tabcount ; i++)               
	{
		char Buf[3];
		_itoa(i,Buf,10);
		addTabView(m_pdlgLSL[i],Buf,TRUE,(i==0),30);
	}
	
   //Get all the parameters of all the ports from INI file
	GetConfig();
   AfxGetApp()->DoWaitCursor(0);

    CTabDialog::OnInitDialog();
    CenterWindow();                                               
	return FALSE;
}
int CLSLTab::AcceptConfig()
{
	LPCSTR	temp;
	char m_szTempBuf[12];
	temp = (char *)m_szTempBuf;

  //Write all parameters for PORT0      

     //Write BOOL parameters
	char field[35];
	for(int i = 0; i < tabcount; i++)
	{
		char Buf[12];
		_itoa(i, Buf, 10);
		
		strcpy(field,"LSL Port");
		strcat(field,Buf);
		strcpy(Buf,field);
		     
	if(m_pdlgLSL[i]->m_PortEnable)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(LSLSectionHeader, (LPCSTR) Buf ,
					temp, (LPCSTR) IniInWinForm);

     //Write CString Parameters
    strcpy(field, Buf);
    strcat(field," Speed"); 
	WritePrivateProfileString(LSLSectionHeader, (LPCSTR) field,
					(LPCSTR) m_pdlgLSL[i]->m_Speed, (LPCSTR) IniInWinForm);
#if 0    
    strcpy(field, strchr(Buf,(int) 'P'));
    strcat(field," MAC Address");
	WritePrivateProfileString(LSLSectionHeader, (LPCSTR) field,
					(LPCSTR) m_pdlgLSL[i]->m_MACAddress, (LPCSTR) IniInWinForm);
   //Write the uint Parameters.
    strcpy(field, Buf);
    strcat(field," Rx Minimum Buffer Limit");
	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_pdlgLSL[i]->m_nRxMinLimit,"");
	WritePrivateProfileString(LSLSectionHeader,
			(LPCSTR) field,(LPSTR)m_szTempBuf,
			(LPCSTR) IniInWinForm);
    
    strcpy(field, Buf);
    strcat(field," Tx Maximum Buffer Limit");
	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_pdlgLSL[i]->m_nTxMaxLimit,"");
	WritePrivateProfileString(LSLSectionHeader,
			(LPCSTR) field,(LPSTR)m_szTempBuf,
			(LPCSTR) IniInWinForm);
#endif    
    }
	return(TRUE);           
}

void CLSLTab::OnOK()
{
   for (int i=0; i<tabcount ; i++)
   {
      if( !m_pdlgLSL[i]->ValidEditFields())
      {
         switchTab(i);
         enableView(i,TRUE);
         return;
      }
   }
	if(!AcceptConfig())
		return;
	CTabDialog::OnOK();
}

void CLSLTab::OnCancel()
{
	CTabDialog::OnCancel();
}

int	CLSLTab::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}
