// modem.h : header file
//

#ifndef _MODEM_H_

#define _MODEM_H_

#include "stdio.h"

#define		MDM_TYPE_LEN			50
#define		LEN_DIAL_PREFIX		21
#define		LEN_DIAL_SUFFIX		21
#define		LEN_RING_MESG			21
#define		LEN_HANGUP_STR			41
#define		LEN_MDM_STR				41
#define		LEN_RESP_OK				21
#define		LEN_RESP_ERROR			21
#define		LEN_RESP_BUSY			21
#define		LEN_RESP_NO_CARRIER	21
#define		LEN_RESP_NO_DIALTONE	21
#define		LEN_RESP_NO_ANSWER	21
#define		LEN_RESP_CONNECT		41

typedef struct tagMdmHdr
{
	WORD ChkSum ;
	char Version ;
	WORD NumEntries ;
} MODEMS_HDR ;


typedef struct	tagMdmSetup 
{
	char	ModemType [MDM_TYPE_LEN];
	char	InitStr1 [LEN_MDM_STR];
	char	InitStr2 [LEN_MDM_STR];
	char	InitStr3 [LEN_MDM_STR];
	char	InitStr4 [LEN_MDM_STR];
	char	InitStr5 [LEN_MDM_STR];
	char	DialPrefix [LEN_DIAL_PREFIX];
	char	DialSuffix [LEN_DIAL_SUFFIX];
	char	RingMesg [LEN_RING_MESG];
	char	HangupStr [LEN_HANGUP_STR];
	char	RespOK [LEN_RESP_OK];
	char	RespError [LEN_RESP_ERROR];
	char	RespBusy [LEN_RESP_BUSY];
	char	RespNoCarrier [LEN_RESP_NO_CARRIER];
	char	RespNoDialtone [LEN_RESP_NO_DIALTONE];
	char	RespNoAnswer [LEN_RESP_NO_ANSWER];
	char	RespConnect [LEN_RESP_CONNECT];
} MODEM_SETUP ;


/////////////////////////////////////////////////////////////////////////////
// CModemTypes dialog

class CModemTypes : public CDialog
{
// Construction
public:
	CModemTypes(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CModemTypes)
	enum { IDD = IDD_DIALOG_MODEM_TYPES };
	CEdit	m_EditConnectWnd;
	CEdit	m_EditNoAnswerWnd;
	CEdit	m_EditLineBusyWnd;
	CEdit	m_EditNoDialToneWnd;
	CEdit	m_EditCmdErrWnd;
	CEdit	m_EditNoCarrierWnd;
	CEdit	m_EditCmdOKWnd;
	CEdit	m_EditMdmCmd5Wnd;
	CEdit	m_EditMdmCmd4Wnd;
	CEdit	m_EditMdmCmd3Wnd;
	CEdit	m_EditMdmCmd2Wnd;
	CEdit	m_EditMdmCmd1Wnd;
	CEdit	m_EditHangUpWnd;
	CEdit	m_EditRingMsgWnd;
	CEdit	m_EditDialSuffixWnd;
	CEdit	m_EditDialPrefixWnd;
	CEdit	m_EditModemTypeWnd;
	CStatic	m_StatModemTypeWnd;
	CString	m_StrModemType;
	CString	m_StrDialPrefix;
	CString	m_StrRingMsg;
	CString	m_StrDialSuffix;
	CString	m_StrHangUp;
	CString	m_StrMdmCmd1;
	CString	m_StrMdmCmd2;
	CString	m_StrMdmCmd3;
	CString	m_StrMdmCmd4;
	CString	m_StrMdmCmd5;
	CString	m_StrCmdOK;
	CString	m_StrNoCarrier;
	CString	m_StrCmdErr;
	CString	m_StrNoDialTone;
	CString	m_StrLineBusy;
	CString	m_StrNoAnswer;
	CString	m_StrConnect;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;

	BOOL m_bActionAdd;
	void LimitAllFields (void) ;
	void SetAllFields (void) ;
	void GetAllFields (MODEM_SETUP *pModem) ;
	BOOL FoundDuplicate (CString &Cstr) ;
	BOOL AreEditControlsModified (void) ;

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CModemTypes)
	virtual void OnCancel();
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#define MODEMS_FILE "MODEMS.CNF"

#define MODEM_TYPE "Modem Type"
#define DIAL_PREFIX "Dial Prefix"
#define RING_MSG "Ring Message"
#define DIAL_SUFFIX "Dial Suffix"
#define HANGUP_STR "Hangup String"
#define MDM_CMD_1 "Modem Initialization String1"
#define MDM_CMD_2 "Modem Initialization String2"
#define MDM_CMD_3 "Modem Initialization String3"
#define MDM_CMD_4 "Modem Initialization String4"
#define MDM_CMD_5 "Modem Initialization String5"
#define CMD_OK "OK Message"
#define NO_CARRIER "No Carrier Message"
#define CMD_ERROR "Error Message"
#define NO_DIAL_TONE "No Dial Tone Message"
#define LINE_BUSY "Busy Message"
#define NO_ANSWER "No Answer Message"
#define CONNECT "Response String"

BOOL VerifyCheckSum (FILE *fptr) ;
BOOL WriteCheckSum (FILE *fptr) ;
void WriteModemStringsToIni (int nPortNumber, MODEM_SETUP *pModemSetup) ;
void ConvertBackSlashesToBlanks (char *szDestination, char *szLocal) ;
void ConvertBlanksToBackSlashes (char *szDestination, char *szLocal) ;

#endif
