// Author : JYOTHI
// Date   : 04/06/98
// Changes contents of structures from Motorola to Intel format
// Flag == 1 : Intel to Motorola
// Flag == 0 : Motorola to Intel
#include "stdafx.h"
#include "cnffile.h"
#include "readbmp.h"
#include "utils.h"  // commented 'coz of prxfilt.h is included in utils.h 

extern CNF_IP  *ip_ptr ;
extern CNF_WAN *wan_ptr ;
extern CNF_PPP *ppp_ptr ;
extern CNF_PROXY_HEADER *proxy_header_ptr ;
extern CNF_DHCP_HEADER  *dhcp_header_ptr ;
extern CNF_STATIC_ROUTES_HEADER *static_routes_header_ptr ;
extern unsigned short change_endian (unsigned short num) ;
extern DWORD ltl_endian_word (DWORD num) ;
int i, k ;

enum CNF_DATA_VALUE_DATA_TYPE change_endian_enum (enum CNF_DATA_VALUE_DATA_TYPE num) ;
void change_ip_structure(int flag) ;
void change_wan_structure(int flag) ;
void change_ppp_structure(int flag) ;
void change_proxy_structure(int flag) ;
void change_dhcp_structure(int flag) ;
void change_static_routes_structure (int flag) ; 

enum CNF_DATA_VALUE_DATA_TYPE change_endian_enum (enum CNF_DATA_VALUE_DATA_TYPE num)
{
	enum CNF_DATA_VALUE_DATA_TYPE num2 ;
	unsigned char *str1, *str2 ;

	str1 = (unsigned char *) &num ;
	str2 = (unsigned char *) &num2 ;
	str2[0] = str1[1] ;
	str2[1] = str1[0] ;
	return num2 ;
}

void  change_ip_structure(int flag)
{
   int number_of_ports = 0 ;
	if (flag)
		number_of_ports = ip_ptr->ip_header.number_of_ports ;
	else
      number_of_ports = change_endian (ip_ptr->ip_header.number_of_ports) ;

   ip_ptr->ip_header.magic_number = change_endian(ip_ptr->ip_header.magic_number) ;
   ip_ptr->ip_header.section_length = change_endian(ip_ptr->ip_header.section_length) ;
   ip_ptr->ip_header.number_of_ports = change_endian(ip_ptr->ip_header.number_of_ports) ;
//   ip_ptr->ip_header.default_gateway = ltl_endian_word(ip_ptr->ip_header.default_gateway) ;
   ip_ptr->ip_header.primary_address = ltl_endian_word(ip_ptr->ip_header.primary_address) ;
   ip_ptr->ip_header.secondary_address = ltl_endian_word(ip_ptr->ip_header.secondary_address) ;

   for (i = 0; i < number_of_ports; i++)
   {
     ip_ptr->ip_ports[i].ip_address = ltl_endian_word(ip_ptr->ip_ports[i].ip_address) ;
     ip_ptr->ip_ports[i].subnet_mask = ltl_endian_word(ip_ptr->ip_ports[i].subnet_mask) ;
     ip_ptr->ip_ports[i].remote_ip_address = ltl_endian_word(ip_ptr->ip_ports[i].remote_ip_address) ;
   }
}

void change_wan_structure (int flag)
{
   int number_of_ports = 0 ;
   if (flag)
   	number_of_ports = wan_ptr->wan_header.number_of_ports ;
   else
      number_of_ports = change_endian (wan_ptr->wan_header.number_of_ports) ;

   wan_ptr->wan_header.magic_number = change_endian(wan_ptr->wan_header.magic_number) ;
   wan_ptr->wan_header.section_length = change_endian(wan_ptr->wan_header.section_length) ;
   wan_ptr->wan_header.number_of_ports = change_endian(wan_ptr->wan_header.number_of_ports) ;

	for (i = 0; i < number_of_ports; i++)
		wan_ptr->wan_ports[i].speed = ltl_endian_word(wan_ptr->wan_ports[i].speed) ;
}

void change_ppp_structure (int flag)
{
	int number_of_ports = 0 ;
   if (flag)
		number_of_ports = ppp_ptr->ppp_header.number_of_ports ;
   else
      number_of_ports = change_endian (ppp_ptr->ppp_header.number_of_ports) ;

   ppp_ptr->ppp_header.magic_number = change_endian(ppp_ptr->ppp_header.magic_number) ;
   ppp_ptr->ppp_header.section_length = change_endian(ppp_ptr->ppp_header.section_length) ;
   ppp_ptr->ppp_header.number_of_ports = change_endian(ppp_ptr->ppp_header.number_of_ports) ;
   
   for (i = 0; i < number_of_ports; i++)
   {
      ppp_ptr->ppp_ports[i].hangup_time = change_endian(ppp_ptr->ppp_ports[i].hangup_time) ;
      ppp_ptr->ppp_ports[i].lcp_accm.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].lcp_accm.value_type) ;
      ppp_ptr->ppp_ports[i].remote_lcp_accm.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].remote_lcp_accm.value_type) ;
      ppp_ptr->ppp_ports[i].lcp_mru.value_type =  change_endian_enum(ppp_ptr->ppp_ports[i].lcp_mru.value_type) ;   
      ppp_ptr->ppp_ports[i].remote_lcp_mru.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].remote_lcp_mru.value_type) ;   
      ppp_ptr->ppp_ports[i].remote_lcp_authentication.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].remote_lcp_authentication.value_type) ;
      ppp_ptr->ppp_ports[i].lcp_magic_number.value_type =  change_endian_enum(ppp_ptr->ppp_ports[i].lcp_magic_number.value_type) ;   
      ppp_ptr->ppp_ports[i].remote_lcp_magic_number.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].remote_lcp_magic_number.value_type) ;
      ppp_ptr->ppp_ports[i].ipcp_ip_address.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].ipcp_ip_address.value_type) ;   
      ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.value_type) ; 
      ppp_ptr->ppp_ports[i].lcp_epd.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].lcp_epd.value_type) ;
      ppp_ptr->ppp_ports[i].remote_lcp_epd.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].remote_lcp_epd.value_type) ;
      ppp_ptr->ppp_ports[i].lcp_mrru.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].lcp_mrru.value_type) ;
      ppp_ptr->ppp_ports[i].remote_lcp_mrru.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].remote_lcp_mrru.value_type) ;
      ppp_ptr->ppp_ports[i].remote_lcp_callback.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].remote_lcp_callback.value_type) ;
      ppp_ptr->ppp_ports[i].ipcp_dns_address1.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].ipcp_dns_address1.value_type) ;
      ppp_ptr->ppp_ports[i].ipcp_dns_address2.value_type =  change_endian_enum(ppp_ptr->ppp_ports[i].ipcp_dns_address2.value_type) ;
      ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address1.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address1.value_type) ;
      ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address2.value_type =  change_endian_enum(ppp_ptr->ppp_ports[i].ras_remote_ipcp_dns_address2.value_type) ;
      ppp_ptr->ppp_ports[i].ras_lcp_authentication.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].ras_lcp_authentication.value_type) ;
      ppp_ptr->ppp_ports[i].ras_ipcp_ip_address.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].ras_ipcp_ip_address.value_type) ;   
      ppp_ptr->ppp_ports[i].ras_remote_ipcp_ip_address.value_type = change_endian_enum(ppp_ptr->ppp_ports[i].ras_remote_ipcp_ip_address.value_type) ; 
   }
}  

void change_proxy_structure (int flag)
{
	CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
   CNF_PROXY_APPLICATION   *proxy_application_ptr ;
   CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;
   CNF_PROXY_FILTER *proxy_filter_ptr ; 
   CNF_PROXY_PORT *proxy_port_ptr ; 
   CNF_PROXY_ADDRESS_INFO *proxy_global_ptr ;
   CNF_PROXY_STATIC_INFO *static_mapping_ptr ;
   CNF_PROXY_DYNAMIC_INFO *dynamic_mapping_ptr ;
   CNF_PROXY_ADDRESS_INFO *proxy_forbidden_sites_ptr ;
   CNF_PROXY_ADDRESS_INFO *proxy_restricted_clients_ptr ;
   CNF_PROXY_APP *proxy_restricted_application_ptr ;

   int number_of_application_entries, number_of_user_defined_application_entries, number_of_ports ;
   int number_of_global_address_entries, number_of_static_mapping_entries, number_of_dynamic_mapping_entries ;
   int number_of_forbidden_sites_entries, number_of_restricted_clients_entries, number_of_mac_address_entries ;
   int number_of_domain_name_entries, number_of_restricted_application_entries, number_of_address_entries ;

   proxy_header_ptr = ((CNF_PROXY_HEADER *)(all_structures[PROXY_ID].ptr_to_struct)) ;

   proxy_header_ptr->magic_number = change_endian(proxy_header_ptr->magic_number) ;
   proxy_header_ptr->section_length = change_endian(proxy_header_ptr->section_length) ;

	if (flag)
		number_of_ports = proxy_header_ptr->number_of_ports ;
	else
		number_of_ports = change_endian (proxy_header_ptr->number_of_ports) ;

	proxy_header_ptr->number_of_ports = change_endian(proxy_header_ptr->number_of_ports) ;
	proxy_header_ptr->ftp_control_port = change_endian (proxy_header_ptr->ftp_control_port) ;
	proxy_header_ptr->ftp_data_port = change_endian (proxy_header_ptr->ftp_data_port) ;

   proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)proxy_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 

   if (flag)
		number_of_application_entries = proxy_application_ptr->number_of_application_entries ;
	else
		number_of_application_entries = change_endian (proxy_application_ptr->number_of_application_entries) ;

	proxy_application_ptr->number_of_application_entries = change_endian(proxy_application_ptr->number_of_application_entries) ;
   for (i = 0; i < number_of_application_entries; i++)
   {
		proxy_application_ptr->application_entries[i].port = change_endian(proxy_application_ptr->application_entries[i].port) ;
      proxy_application_ptr->application_entries[i].protocol = change_endian(proxy_application_ptr->application_entries[i].protocol) ;
	}

   proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (number_of_application_entries - 1))))) ; 

   if (flag)
		number_of_user_defined_application_entries = proxy_user_defined_application_ptr->number_of_user_defined_application_entries ;
	else
		number_of_user_defined_application_entries = change_endian (proxy_user_defined_application_ptr->number_of_user_defined_application_entries) ;

	proxy_user_defined_application_ptr->number_of_user_defined_application_entries = change_endian (proxy_user_defined_application_ptr->number_of_user_defined_application_entries) ;

   for (i = 0; i < number_of_user_defined_application_entries; i++)
	{
		proxy_user_defined_application_ptr->user_defined_application_entries[i].protocol = change_endian(proxy_user_defined_application_ptr->user_defined_application_entries[i].protocol) ;
		proxy_user_defined_application_ptr->user_defined_application_entries[i].lower_port_number = change_endian(proxy_user_defined_application_ptr->user_defined_application_entries[i].lower_port_number) ; 
      proxy_user_defined_application_ptr->user_defined_application_entries[i].higher_port_number = change_endian(proxy_user_defined_application_ptr->user_defined_application_entries[i].higher_port_number) ;
	}

   proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *)proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (number_of_user_defined_application_entries - 1))))) ;

   if (flag)
   {
		number_of_global_address_entries = proxy_virtual_server_ptr->number_of_global_address_entries ;
		number_of_static_mapping_entries = proxy_virtual_server_ptr->number_of_static_mapping_entries ;
		number_of_dynamic_mapping_entries = proxy_virtual_server_ptr->number_of_dynamic_mapping_entries	;
   }
   else
   {
		number_of_global_address_entries = change_endian (proxy_virtual_server_ptr->number_of_global_address_entries) ;
		number_of_static_mapping_entries = change_endian (proxy_virtual_server_ptr->number_of_static_mapping_entries) ;
		number_of_dynamic_mapping_entries = change_endian (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries) ;
   }
   proxy_virtual_server_ptr->number_of_global_address_entries = change_endian(proxy_virtual_server_ptr->number_of_global_address_entries) ;
   proxy_virtual_server_ptr->number_of_static_mapping_entries = change_endian(proxy_virtual_server_ptr->number_of_static_mapping_entries) ;
   proxy_virtual_server_ptr->number_of_dynamic_mapping_entries = change_endian(proxy_virtual_server_ptr->number_of_dynamic_mapping_entries) ;
   proxy_virtual_server_ptr->dynamic_mapping_global_address = ltl_endian_word(proxy_virtual_server_ptr->dynamic_mapping_global_address) ;

   proxy_global_ptr = ((CNF_PROXY_ADDRESS_INFO *) ((char *) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG))) ;

   for (i = 0; i < number_of_global_address_entries; i++)
   {
		proxy_global_ptr->address = ltl_endian_word(proxy_global_ptr->address) ;
		proxy_global_ptr++ ;
   }

   static_mapping_ptr = ((CNF_PROXY_STATIC_INFO *) ((char *) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG) +
		  (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_global_address_entries))) ;

   for (i = 0; i < number_of_static_mapping_entries; i++)
   {
		static_mapping_ptr->global_address = ltl_endian_word(static_mapping_ptr->global_address) ;
		static_mapping_ptr->local_address = ltl_endian_word(static_mapping_ptr->local_address) ;
		static_mapping_ptr++ ;
   }

   dynamic_mapping_ptr = ((CNF_PROXY_DYNAMIC_INFO *) ((char *) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG) +
		   (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_global_address_entries) +
		   (sizeof(CNF_PROXY_STATIC_INFO) * number_of_static_mapping_entries))) ;

   for (i = 0; i < number_of_dynamic_mapping_entries; i++)
   {
		dynamic_mapping_ptr->local_address = ltl_endian_word(dynamic_mapping_ptr->local_address) ;
		dynamic_mapping_ptr->port = change_endian(dynamic_mapping_ptr->port) ;
		dynamic_mapping_ptr->protocol = change_endian(dynamic_mapping_ptr->protocol) ;
		dynamic_mapping_ptr++ ;
   }

   proxy_filter_ptr = ((CNF_PROXY_FILTER *)(((char *)proxy_virtual_server_ptr + sizeof(CNF_PROXY_VIRTUAL_SERVER)) + ( 
                          (number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                          (number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
                          (number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO)))) ; 

   if (flag)
   { 
   	number_of_forbidden_sites_entries = proxy_filter_ptr->number_of_forbidden_sites_entries ;  
		number_of_restricted_clients_entries = proxy_filter_ptr->number_of_restricted_clients_entries ;  
		number_of_restricted_application_entries = proxy_filter_ptr->number_of_restricted_application_entries ;  
		number_of_mac_address_entries = proxy_filter_ptr->number_of_mac_address_entries ;  
		number_of_domain_name_entries = proxy_filter_ptr->number_of_domain_name_entries ;  
   }
   else
   {
   	number_of_forbidden_sites_entries = change_endian(proxy_filter_ptr->number_of_forbidden_sites_entries) ;  
		number_of_restricted_clients_entries = change_endian(proxy_filter_ptr->number_of_restricted_clients_entries) ;  
		number_of_restricted_application_entries = change_endian(proxy_filter_ptr->number_of_restricted_application_entries) ;  
		number_of_mac_address_entries = change_endian(proxy_filter_ptr->number_of_mac_address_entries) ;  
		number_of_domain_name_entries = change_endian(proxy_filter_ptr->number_of_domain_name_entries) ;  
   }
   proxy_filter_ptr->number_of_forbidden_sites_entries = change_endian(proxy_filter_ptr->number_of_forbidden_sites_entries) ;  
   proxy_filter_ptr->number_of_restricted_clients_entries = change_endian(proxy_filter_ptr->number_of_restricted_clients_entries) ;  
   proxy_filter_ptr->number_of_restricted_application_entries = change_endian(proxy_filter_ptr->number_of_restricted_application_entries) ;  
   proxy_filter_ptr->number_of_mac_address_entries = change_endian(proxy_filter_ptr->number_of_mac_address_entries) ;  
   proxy_filter_ptr->number_of_domain_name_entries = change_endian(proxy_filter_ptr->number_of_domain_name_entries) ;  

   proxy_forbidden_sites_ptr = ((CNF_PROXY_ADDRESS_INFO *) ((char*) proxy_filter_ptr + (5 * sizeof(USHORT)))) ;

   for (i = 0; i < number_of_forbidden_sites_entries; i++)
   {
		proxy_forbidden_sites_ptr->address = ltl_endian_word(proxy_forbidden_sites_ptr->address) ;
		proxy_forbidden_sites_ptr++ ;
   }

   proxy_restricted_clients_ptr = ((CNF_PROXY_ADDRESS_INFO *) ((char*) proxy_filter_ptr + (5 * sizeof(USHORT)) +
				   (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_forbidden_sites_entries))) ;

   for (i = 0; i < number_of_restricted_clients_entries; i++)
   {
		proxy_restricted_clients_ptr->address = ltl_endian_word(proxy_restricted_clients_ptr->address) ;
		proxy_restricted_clients_ptr++ ;
   }

   proxy_restricted_application_ptr = ((CNF_PROXY_APP *) ((char*) proxy_filter_ptr + (5 * sizeof(USHORT)) +
				       (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_forbidden_sites_entries) +
				       (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_restricted_clients_entries))) ;

   for (i = 0; i < number_of_restricted_application_entries; i++)
   {
		proxy_restricted_application_ptr->port = change_endian(proxy_restricted_application_ptr->port) ;
      proxy_restricted_application_ptr->protocol = change_endian(proxy_restricted_application_ptr->protocol) ; 
		proxy_restricted_application_ptr++ ;
   }

   proxy_port_ptr = ((CNF_PROXY_PORT *)((char*) proxy_filter_ptr + sizeof(CNF_PROXY_FILTER) + (
                      (number_of_forbidden_sites_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (number_of_restricted_clients_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (number_of_restricted_application_entries - 1) * sizeof(CNF_PROXY_APP) +
                      (number_of_mac_address_entries - 1) * sizeof(CNF_PROXY_MAC_ADDRESS_INFO) +
                      (number_of_domain_name_entries - 1) * sizeof(CNF_PROXY_DOMAIN_NAME_INFO)))) ; 

   for (i = 0; i < number_of_ports; i++) 
   {
		if (flag)
			number_of_address_entries = proxy_port_ptr->number_of_address_entries ;
		else
			number_of_address_entries = change_endian (proxy_port_ptr->number_of_address_entries) ;
		proxy_port_ptr->number_of_address_entries = change_endian(proxy_port_ptr->number_of_address_entries) ;
		proxy_port_ptr->number_of_connections_to_trigger = change_endian(proxy_port_ptr->number_of_connections_to_trigger) ;
		proxy_port_ptr->number_of_hosts_to_trigger = change_endian(proxy_port_ptr->number_of_hosts_to_trigger) ;
		for (k = 0; k < number_of_address_entries; k++) 
	   	proxy_port_ptr->port_address[k].address = ltl_endian_word(proxy_port_ptr->port_address[k].address) ;

		proxy_port_ptr =  ((CNF_PROXY_PORT *)((char*)proxy_port_ptr + sizeof(CNF_PROXY_PORT) + (number_of_address_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO))) ;
   }
}

void change_dhcp_structure (int flag)
{
	CNF_DHCP_ADDRESS_RANGE *dhcp_address_range_entries_ptr ;
   int number_of_address_range_entries, number_of_bindings_entries ;

   dhcp_header_ptr = (CNF_DHCP_HEADER *) all_structures[DHCP_ID].ptr_to_struct ;

   if (flag)
   	number_of_address_range_entries = dhcp_header_ptr->number_of_address_range_entries ;
   else
	   number_of_address_range_entries = change_endian (dhcp_header_ptr->number_of_address_range_entries) ;

   dhcp_header_ptr->magic_number = change_endian(dhcp_header_ptr->magic_number) ;
   dhcp_header_ptr->section_length = change_endian(dhcp_header_ptr->section_length) ;
   dhcp_header_ptr->number_of_address_range_entries = change_endian(dhcp_header_ptr->number_of_address_range_entries) ;
   dhcp_header_ptr->dhcp_server_ip_address = ltl_endian_word(dhcp_header_ptr->dhcp_server_ip_address) ;

   dhcp_address_range_entries_ptr = ((CNF_DHCP_ADDRESS_RANGE *)((char *)dhcp_header_ptr + sizeof(CNF_DHCP_HEADER))) ;
   for (i = 0; i < number_of_address_range_entries; i++)
   {
		if (flag)
      	number_of_bindings_entries = dhcp_address_range_entries_ptr->number_of_bindings_entries ;
		else
      	number_of_bindings_entries = change_endian(dhcp_address_range_entries_ptr->number_of_bindings_entries) ;

		dhcp_address_range_entries_ptr->lower_ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->lower_ip_address) ; 
		dhcp_address_range_entries_ptr->higher_ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->higher_ip_address) ; 
		dhcp_address_range_entries_ptr->address_mask = ltl_endian_word (dhcp_address_range_entries_ptr->address_mask) ; 
		dhcp_address_range_entries_ptr->number_of_bindings_entries = change_endian(dhcp_address_range_entries_ptr->number_of_bindings_entries) ;
		dhcp_address_range_entries_ptr->exclude_lower_ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->exclude_lower_ip_address) ; 
		dhcp_address_range_entries_ptr->exclude_higher_ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->exclude_higher_ip_address) ; 

		dhcp_address_range_entries_ptr->options_entries.router_address = ltl_endian_word (dhcp_address_range_entries_ptr->options_entries.router_address) ;      
		dhcp_address_range_entries_ptr->options_entries.reassembly_size = change_endian (dhcp_address_range_entries_ptr->options_entries.reassembly_size) ;      
		dhcp_address_range_entries_ptr->options_entries.mtu = change_endian (dhcp_address_range_entries_ptr->options_entries.mtu) ;      
		dhcp_address_range_entries_ptr->options_entries.lease_time = ltl_endian_word (dhcp_address_range_entries_ptr->options_entries.lease_time) ;      

		for (k = 0; k < number_of_bindings_entries; k++) 
      	dhcp_address_range_entries_ptr->bindings_entries[k].ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->bindings_entries[k].ip_address) ;      

		dhcp_address_range_entries_ptr = ((CNF_DHCP_ADDRESS_RANGE *)((char *)dhcp_address_range_entries_ptr + sizeof(CNF_DHCP_ADDRESS_RANGE) +
                                  (number_of_bindings_entries - 1) * sizeof(CNF_BINDING_INFO))) ;  
   }
}

void change_static_routes_structure (int flag)  
{
	CNF_STATIC_ROUTES_INFO *static_routes_info_ptr ;
	int i, number_of_static_route_entries ;

	static_routes_header_ptr = ((CNF_STATIC_ROUTES_HEADER *)(all_structures[STATIC_ROUTES_ID].ptr_to_struct)) ;  
   static_routes_header_ptr->magic_number = change_endian(static_routes_header_ptr->magic_number) ;
   static_routes_header_ptr->section_length = change_endian(static_routes_header_ptr->section_length) ;

	if (flag)
		number_of_static_route_entries = static_routes_header_ptr->number_of_static_routes ;
	else
		number_of_static_route_entries = change_endian (static_routes_header_ptr->number_of_static_routes) ;

	static_routes_header_ptr->number_of_static_routes = change_endian (static_routes_header_ptr->number_of_static_routes) ;

	static_routes_info_ptr = ((CNF_STATIC_ROUTES_INFO *)((char *)static_routes_header_ptr + sizeof(CNF_STATIC_ROUTES_HEADER))) ;

   for (i = 0; i < number_of_static_route_entries; i++)
	{
		static_routes_info_ptr->host_ip_address = ltl_endian_word (static_routes_info_ptr->host_ip_address) ;
		static_routes_info_ptr->host_gateway = ltl_endian_word (static_routes_info_ptr->host_gateway) ;
		static_routes_info_ptr->host_address_mask = ltl_endian_word (static_routes_info_ptr->host_address_mask) ;
	   static_routes_info_ptr->port_number = change_endian(static_routes_info_ptr->port_number) ;
		static_routes_info_ptr++ ;
	}
}
