// -------------------------------------------------------------------------
// Project Name			:	Standard progress gauges for MultiExpress Suite
//							programs.
// Module Name			:	Gauges implementation file.
// File Name			:	MSGUVIEW.CPP
// Description			:	Implements horizontal, vertical, circular,
// 							counter and meter gauge for use in
//							MultiExpress Suite for Windows.
// Start Date			:	19 Oct 1994
// Author				:	Srini
// Date Last Modified	:	
// Modifications		:	
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "math.h"
#include "msgumain.h"
#include "msguview.h"

// -------------------------------------------------------------------------
// External Function Definitions
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// External Variable Definitions
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Global Variable Declarations
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Static Variable Declarations
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------
         
#define		PEN_WIDTH			2
#define		INNER_PEN_WIDTH		1
#define		HORZ_GAP			5
#define		VERT_GAP			10
#define		INNER_HORZ_GAP		4
#define		INNER_VERT_GAP		3
#define		PI					3.142


DWORD	absDWORD(DWORD x)
{
/*	if (x < 0)
		return (-(x));
	else
*/
		return (x);
}                                                 

DWORD	maxDWORD(DWORD a, DWORD b)
{
	if (a < b)
		return (b);
	else
		return (a);
}

// -------------------------------------------------------------------------
// 						HORIZONTAL GUAGE IMPLEMENTATION
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Function			:	CHorzGauge::CalcGaugeWndSize()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Calculates the minimum window that has to be created
// 						for displaying the horizontal gauge, scalings and 
// 						caption.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CHorzGauge::CalcGaugeWndSize(CWnd* pGaugeWnd)
{
	// We need to add for the caption below the progress gauge.
	CDC			*pDC;
	TEXTMETRIC	tm;
	
	pDC = pGaugeWnd->GetDC();
	pDC->GetTextMetrics(&tm);
	
	int		nWidth, nHeight;
	CSize	sizeCapt;

	// Calculate the width of the window by checking for caption size and gauge size.	
	nWidth = HORZ_GAP + INNER_HORZ_GAP + m_rcDim.Width() + HORZ_GAP + INNER_HORZ_GAP;
	sizeCapt = pDC->GetTextExtent(m_strCaption, m_strCaption.GetLength());
	pGaugeWnd->ReleaseDC(pDC);

	if (sizeCapt.cx > nWidth)
		nWidth = HORZ_GAP + INNER_HORZ_GAP + sizeCapt.cx + HORZ_GAP + INNER_HORZ_GAP;
	
	// Calculate the height of the window by making provision for the scalings and caption
	nHeight = VERT_GAP + INNER_VERT_GAP + m_rcDim.Height() + VERT_GAP + INNER_VERT_GAP +
																sizeCapt.cy + VERT_GAP;
	m_rcWndDim = m_rcDim;
	m_rcWndDim.right = m_rcWndDim.left + nWidth;
	m_rcWndDim.bottom = m_rcWndDim.top + nHeight;
}

// -------------------------------------------------------------------------
// Function			:	CHorzGauge::DoPaint()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the horizontal gauge in response to a 
// 						WM_PAINT message.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CHorzGauge::DoPaint(CWnd* pGaugeWnd)
{
	DWORD		dwXPos;
	CRect		rcClnt;
	TEXTMETRIC	tm;

	// The coordinates of the gauge.
	pGaugeWnd->GetClientRect(&rcClnt);
	rcClnt.left += (HORZ_GAP + INNER_HORZ_GAP);
	rcClnt.right -= (HORZ_GAP + INNER_HORZ_GAP);
	rcClnt.top += (VERT_GAP + INNER_VERT_GAP);
	rcClnt.bottom -= (VERT_GAP * 2 + INNER_VERT_GAP);
	
	CPaintDC dc(pGaugeWnd); 			// Device context for painting
	
	dc.GetTextMetrics(&tm);
	rcClnt.bottom -= tm.tmHeight;
	
	// Display the divisions
	if (m_bInclScale) {
		dc.MoveTo(rcClnt.left+rcClnt.Width()/4, rcClnt.top-INNER_VERT_GAP+1);
		dc.LineTo(rcClnt.left+rcClnt.Width()/4, rcClnt.bottom+INNER_VERT_GAP-1);
	
		dc.MoveTo(rcClnt.left+rcClnt.Width()/2, rcClnt.top-INNER_VERT_GAP+1);
		dc.LineTo(rcClnt.left+rcClnt.Width()/2, rcClnt.bottom+INNER_VERT_GAP-1);

		dc.MoveTo(rcClnt.left+rcClnt.Width()/2+rcClnt.Width()/4, rcClnt.top-INNER_VERT_GAP+1);
		dc.LineTo(rcClnt.left+rcClnt.Width()/2+rcClnt.Width()/4, rcClnt.bottom+INNER_VERT_GAP-1);
	}
	
	CBrush	brBk;
	CPen	penNull;

	dwXPos = (DWORD)((DWORD) rcClnt.right * 
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal))));
	if (dwXPos > (DWORD) rcClnt.right)
		dwXPos = (DWORD) rcClnt.right;
                
	// First fill the entire rectangle with background color.
	brBk.CreateSolidBrush(m_RGBClrBk);
	CBrush	*brOld = dc.SelectObject(&brBk);

	penNull.CreateStockObject(NULL_PEN);
	CPen 	*penOld = dc.SelectObject(&penNull);

	if (dwXPos < (DWORD) (rcClnt.left+1))
		dwXPos = (DWORD) (rcClnt.left+1);
	dc.Rectangle((WORD) dwXPos, rcClnt.top+1, rcClnt.right, rcClnt.bottom+1);
	dc.SelectObject(brOld);
	brBk.DeleteObject();
	
	// Now fill the progress area with the fill color.
	
	if (dwXPos >  0) {
	
		CBrush	brFill;
	
		brFill.CreateSolidBrush(m_RGBClrFill);
		brOld = dc.SelectObject(&brFill);
		dc.Rectangle(rcClnt.left+1, rcClnt.top+1, (WORD) dwXPos, rcClnt.bottom+1);
		dc.SelectObject(brOld);
		brFill.DeleteObject();
	}
	dc.SelectObject(penOld);

	// Output the percent text if the option is set.
	if (m_bInclPercent) {
	
		int		nXPos, nYPos;
		char	strPercent[6];
		CRect	rcTmp;
		CSize	sizeTextExt;
        
        int		nPercent = (int)((DWORD) (DWORD)((DWORD) 100 * 
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)))));

		::wsprintf(strPercent, "%d %%", nPercent);
		int		nLen = ::lstrlen(strPercent);
			                               
		dc.SetBkMode(TRANSPARENT);
		dc.SetTextAlign(TA_CENTER);
	
		nXPos = rcClnt.left + rcClnt.Width() / 2;
		sizeTextExt = dc.GetTextExtent(strPercent, nLen);
		nYPos = rcClnt.top + ((rcClnt.Height() - sizeTextExt.cy) / 2);

		dc.SetTextColor(m_RGBClrFill);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, rcClnt.right, rcClnt.bottom);
		dc.ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);

		dc.SetTextColor(m_RGBClrBk);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, (WORD) dwXPos, rcClnt.bottom);
		dc.ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);
	}
	
	// We need to decide whether the gauge style is normal, depressed or elevated and choose
	// the pens for drawing the border appropriately.
	
	CPen	penBorder, penInBorder;

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// The inner border style
	if (m_nInGaugeStyle == GU_ELEVATED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderUp);
	else if (m_nInGaugeStyle == GU_DEPRESSED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderDn);
	else
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, RGB(0x00, 0x00, 0x00));
	
	// Outer border	
	penOld = dc.SelectObject(&penBorder);
	dc.MoveTo(rcClnt.left - INNER_HORZ_GAP, rcClnt.bottom + INNER_VERT_GAP);
	dc.LineTo(rcClnt.left - INNER_HORZ_GAP, rcClnt.top - INNER_VERT_GAP);
	dc.LineTo(rcClnt.right + INNER_HORZ_GAP - 2, rcClnt.top - INNER_VERT_GAP);
	dc.SelectObject(penOld);
	penBorder.DeleteObject();

	// Inner border
	penOld = dc.SelectObject(&penInBorder);
	dc.MoveTo(rcClnt.left, rcClnt.bottom);
	dc.LineTo(rcClnt.left, rcClnt.top);
	dc.LineTo(rcClnt.right, rcClnt.top);
	dc.SelectObject(penOld);
	penInBorder.DeleteObject();
	
	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// The inner border style
	if (m_nInGaugeStyle == GU_ELEVATED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderDn);
	else if (m_nInGaugeStyle == GU_DEPRESSED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderUp);
	else
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// Outer border
	penOld = dc.SelectObject(&penBorder);
	dc.MoveTo(rcClnt.right + INNER_HORZ_GAP, rcClnt.top - INNER_VERT_GAP);
	dc.LineTo(rcClnt.right + INNER_HORZ_GAP, rcClnt.bottom + INNER_VERT_GAP);
	dc.LineTo(rcClnt.left - INNER_HORZ_GAP + 2, rcClnt.bottom + INNER_VERT_GAP);
	dc.SelectObject(penOld);
	penBorder.DeleteObject();

	// Inner border
	penOld = dc.SelectObject(&penInBorder);
	dc.MoveTo(rcClnt.right, rcClnt.top);
	dc.LineTo(rcClnt.right, rcClnt.bottom);
	dc.LineTo(rcClnt.left + 2, rcClnt.bottom);
	dc.SelectObject(penOld);
	penInBorder.DeleteObject();
                           
	// Display the range minimum val left justified and maxlongimum val right justified
	CRect	rcTmp(rcClnt.left - HORZ_GAP + 1, rcClnt.bottom + VERT_GAP, rcClnt.right + HORZ_GAP,
						rcClnt.bottom+INNER_VERT_GAP+VERT_GAP+tm.tmHeight+VERT_GAP);

	dc.SetTextColor(m_RGBClrTxt);
	dc.SetBkMode(TRANSPARENT);
	
	if (m_bInclRange) {
	
		char	strRange[20];
		
		dc.SetTextAlign(TA_LEFT);
		::wsprintf(strRange, "%d", m_nMinVal);
		dc.ExtTextOut(rcTmp.left, rcTmp.top + 2,
					ETO_CLIPPED, &rcTmp, strRange, ::lstrlen(strRange), NULL);
					
		dc.SetTextAlign(TA_RIGHT);
		::wsprintf(strRange, "%lu", m_nMaxVal);
		dc.ExtTextOut(rcTmp.right, rcTmp.top + 2,
					ETO_CLIPPED, &rcTmp, strRange, ::lstrlen(strRange), NULL);
	}
	
	// Display the caption.
	if (!m_strCaption.IsEmpty()) {
	
		dc.SetTextAlign(TA_CENTER);
		dc.ExtTextOut(rcTmp.right / 2, rcTmp.top + 2,
					ETO_CLIPPED, &rcTmp, m_strCaption, m_strCaption.GetLength(), NULL);
	}
}

// -------------------------------------------------------------------------
// Function			:	CHorzGauge::DrawProgress()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the horizontal gauge in response to a 
// 						UpdateProgress() call.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CHorzGauge::DrawProgress(CWnd* pGaugeWnd)
{
	DWORD		dwXPos;
	CPen		*penOld;
	CRect		rcClnt;
	TEXTMETRIC	tm;

	// The coordinates of the gauge.
	pGaugeWnd->GetClientRect(&rcClnt);
	rcClnt.left += (HORZ_GAP + INNER_HORZ_GAP);
	rcClnt.right -= (HORZ_GAP + INNER_HORZ_GAP);
	rcClnt.top += (VERT_GAP + INNER_VERT_GAP);
	rcClnt.bottom -= (VERT_GAP * 2 + INNER_VERT_GAP);
	
	CDC *pDC = pGaugeWnd->GetDC(); 				// Device context for painting
	
	pDC->GetTextMetrics(&tm);
	rcClnt.bottom -= tm.tmHeight;
	
	dwXPos = (DWORD)((DWORD) rcClnt.right * (DWORD)
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal))));
						
	if (dwXPos > (DWORD) rcClnt.right)
		dwXPos = (DWORD) rcClnt.right;
                
	// First fill the entire rectangle with background color.
	CBrush	brBk;
	CPen	penNull;

	brBk.CreateSolidBrush(m_RGBClrBk);
	CBrush	*brOld = pDC->SelectObject(&brBk);

	penNull.CreateStockObject(NULL_PEN);
	penOld = pDC->SelectObject(&penNull);

	if (dwXPos < (DWORD) (rcClnt.left+1))
		dwXPos = (DWORD) (rcClnt.left+1);
	pDC->Rectangle((WORD) dwXPos, rcClnt.top+1, rcClnt.right, rcClnt.bottom+1);
	pDC->SelectObject(brOld);
	pDC->SelectObject(penOld);
	brBk.DeleteObject();

	// Now fill the progress area with the fill color.
	if (dwXPos >  0) {
	
		CBrush	brFill;

		penOld = pDC->SelectObject(&penNull);	// Use the null pen created above
		brFill.CreateSolidBrush(m_RGBClrFill);
		CBrush*	brOld = pDC->SelectObject(&brFill);
		pDC->Rectangle(rcClnt.left+1, rcClnt.top+1, (WORD) dwXPos, rcClnt.bottom+1);
		pDC->SelectObject(brOld);
		pDC->SelectObject(penOld);				// Deselect the null pen
		brFill.DeleteObject();
	}

	// Output the percent text if the option is set.
	if (m_bInclPercent) {
	
		int		nXPos, nYPos;
		char	strPercent[6];
		CRect	rcTmp;
		CSize	sizeTextExt;
        
        int		nPercent = (int)((DWORD) (DWORD)((DWORD) 100 * 
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)))));

		::wsprintf(strPercent, "%d %%", nPercent);
		int		nLen = ::lstrlen(strPercent);
			                               
		pDC->SetBkMode(TRANSPARENT);
		pDC->SetTextAlign(TA_CENTER);
	
		nXPos = rcClnt.left + rcClnt.Width() / 2;
		sizeTextExt = pDC->GetTextExtent(strPercent, nLen);
		nYPos = rcClnt.top + ((rcClnt.Height() - sizeTextExt.cy) / 2);

		pDC->SetTextColor(m_RGBClrFill);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, rcClnt.right, rcClnt.bottom);
		pDC->ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);
		pDC->SetTextColor(m_RGBClrBk);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, (WORD) dwXPos, rcClnt.bottom);
		pDC->ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);
	}
	
	// We need to decide whether the gauge style is normal. depressed or elevated and choose
	// the pens for drawing the border appropriately.
	
	CPen	penBorder, penInBorder;

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// The inner border style
	if (m_nInGaugeStyle == GU_ELEVATED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderUp);
	else if (m_nInGaugeStyle == GU_DEPRESSED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderDn);
	else
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// Outer border
	penOld = pDC->SelectObject(&penBorder);
	pDC->MoveTo(rcClnt.left - INNER_HORZ_GAP, rcClnt.bottom + INNER_VERT_GAP);
	pDC->LineTo(rcClnt.left - INNER_HORZ_GAP, rcClnt.top - INNER_VERT_GAP);
	pDC->LineTo(rcClnt.right + INNER_HORZ_GAP - 2, rcClnt.top - INNER_VERT_GAP);
	pDC->SelectObject(penOld);
	penBorder.DeleteObject();

	if (dwXPos > (DWORD) (rcClnt.left+1)) {

		// Inner border
		penOld = pDC->SelectObject(&penInBorder);
		pDC->MoveTo(rcClnt.left, rcClnt.bottom);
		pDC->LineTo(rcClnt.left, rcClnt.top);
		pDC->LineTo((WORD) dwXPos, rcClnt.top);
		pDC->SelectObject(penOld);
	}

	penInBorder.DeleteObject();

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// The inner border style
	if (m_nInGaugeStyle == GU_ELEVATED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderDn);
	else if (m_nInGaugeStyle == GU_DEPRESSED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderUp);
	else
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// Outer border
	penOld = pDC->SelectObject(&penBorder);
	pDC->MoveTo(rcClnt.right + INNER_HORZ_GAP, rcClnt.top - INNER_VERT_GAP);
	pDC->LineTo(rcClnt.right + INNER_HORZ_GAP, rcClnt.bottom + INNER_VERT_GAP);
	pDC->LineTo(rcClnt.left - INNER_HORZ_GAP + 2, rcClnt.bottom + INNER_VERT_GAP);
	pDC->SelectObject(penOld);
	penBorder.DeleteObject();

	if (dwXPos > (DWORD) (rcClnt.left+1)) {

		// Inner border
		penOld = pDC->SelectObject(&penInBorder);
		pDC->MoveTo((WORD) dwXPos, rcClnt.top);
		pDC->LineTo((WORD) dwXPos, rcClnt.bottom);
		pDC->LineTo(rcClnt.left + 2, rcClnt.bottom);
		pDC->SelectObject(penOld);
	}

	penInBorder.DeleteObject();
	pGaugeWnd->ReleaseDC(pDC); 				// Device context for painting
}

// -------------------------------------------------------------------------
// 						VERTICAL GUAGE IMPLEMENTATION
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Function			:	CVertGauge::CalcGaugeWndSize()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Calculates the minimum window that has to be created
// 						for displaying the vertical gauge, scalings and caption.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CVertGauge::CalcGaugeWndSize(CWnd* pGaugeWnd)
{
	// We need to add for the caption below the progress gauge.
	CDC			*pDC;
	TEXTMETRIC	tm;
	
	pDC = pGaugeWnd->GetDC();
	pDC->GetTextMetrics(&tm);
	
	int		nWidth, nHeight;
	char	strRange[20];
	CSize	sizeCapt;
	CSize	sizeRange;

	// Calculate the width of the window by checking for caption size and gauge size.
	// The gauge size will have to include the range text width also in this case.
	::wsprintf(strRange, "%d", m_nMinVal);
	sizeRange = pDC->GetTextExtent(strRange, ::lstrlen(strRange));
	m_nRangeWd = sizeRange.cx;
	m_nRangeHt = sizeRange.cy;
	::wsprintf(strRange, "%d", m_nMaxVal);
	sizeRange = pDC->GetTextExtent(strRange, ::lstrlen(strRange));
	m_nRangeWd = (int) maxDWORD(m_nRangeWd, (DWORD) sizeRange.cx);
	m_nRangeHt = (int) maxDWORD(m_nRangeHt, (DWORD) sizeRange.cy);
	nWidth = (HORZ_GAP+ m_rcDim.Width() + HORZ_GAP + m_nRangeWd);
	
	sizeCapt = pDC->GetTextExtent(m_strCaption, m_strCaption.GetLength());
	pGaugeWnd->ReleaseDC(pDC);

	if ((sizeCapt.cx + 2 * HORZ_GAP + 2 * INNER_HORZ_GAP) > nWidth)
		nWidth = 2 * HORZ_GAP + sizeCapt.cx + 2 * HORZ_GAP + 2 * INNER_HORZ_GAP;
	
	// Calculate the height of the window by making provision for the scalings and caption
	nHeight = VERT_GAP + INNER_VERT_GAP + m_rcDim.Height() + VERT_GAP + 
									INNER_VERT_GAP + sizeCapt.cy + VERT_GAP;
		
	m_rcWndDim = m_rcDim;
	m_rcWndDim.right = m_rcWndDim.left + nWidth;
	m_rcWndDim.bottom = m_rcWndDim.top + nHeight;
}

// -------------------------------------------------------------------------
// Function			:	CVertGauge::DoPaint()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the vertical gauge in response to a 
// 						WM_PAINT message.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CVertGauge::DoPaint(CWnd* pGaugeWnd)
{
	DWORD		dwXPos;
	CRect		rcClnt;
	TEXTMETRIC	tm;

	// The coordinates of the gauge.
	pGaugeWnd->GetClientRect(&rcClnt);
	rcClnt.left += (INNER_HORZ_GAP + HORZ_GAP);
	rcClnt.right = rcClnt.left + m_rcDim.Width();
	rcClnt.top += (VERT_GAP + INNER_VERT_GAP);
	rcClnt.bottom -= (VERT_GAP * 2 + INNER_VERT_GAP);
	
	CPaintDC dc(pGaugeWnd); 			// Device context for painting
	
	dc.GetTextMetrics(&tm);
	rcClnt.bottom -= tm.tmHeight;
	
	// Display the divisions
	if (m_bInclScale) {
		dc.MoveTo(rcClnt.left-HORZ_GAP+1, rcClnt.top+rcClnt.Height()/4);
		dc.LineTo(rcClnt.right+HORZ_GAP-1, rcClnt.top+rcClnt.Height()/4);
	
		dc.MoveTo(rcClnt.left-HORZ_GAP+1, rcClnt.top+rcClnt.Height()/2);
		dc.LineTo(rcClnt.right+HORZ_GAP-1, rcClnt.top+rcClnt.Height()/2);

		dc.MoveTo(rcClnt.left-HORZ_GAP+1, rcClnt.top+rcClnt.Height()/2+rcClnt.Height()/4);
		dc.LineTo(rcClnt.right+HORZ_GAP-1, rcClnt.top+rcClnt.Height()/2+rcClnt.Height()/4);
	}
	
	CBrush	brBk;
	CPen	penNull;

	dwXPos = (DWORD)((DWORD) (rcClnt.bottom - rcClnt.top) * 
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal))));
	if (dwXPos > (DWORD) rcClnt.Height())
		dwXPos = (DWORD) rcClnt.Height();
                
	// First fill the entire rectangle with background color.
	brBk.CreateSolidBrush(m_RGBClrBk);
	CBrush	*brOld = dc.SelectObject(&brBk);

	penNull.CreateStockObject(NULL_PEN);
	CPen 	*penOld = dc.SelectObject(&penNull);

	dc.Rectangle(rcClnt.left+1, (rcClnt.bottom - (WORD) dwXPos), rcClnt.right, rcClnt.top+1);
	dc.SelectObject(brOld);
	brBk.DeleteObject();
	
	// Now fill the progress area with the fill color.
	
	if (dwXPos >  0) {
	
		CBrush	brFill;
	
		brFill.CreateSolidBrush(m_RGBClrFill);
		brOld = dc.SelectObject(&brFill);
		dc.Rectangle(rcClnt.left+1, rcClnt.bottom, rcClnt.right, (rcClnt.bottom - (WORD) dwXPos));
		dc.SelectObject(brOld);
		brFill.DeleteObject();
	}
	dc.SelectObject(penOld);

#if 0
	// Output the percent text if the option is set.
	if (m_bInclPercent) {
	
		int		nXPos, nYPos;
		char	strPercent[6];
		CRect	rcTmp;
		CSize	sizeTextExt;
        
        int		nPercent = (int)((DWORD) (DWORD)((DWORD) 100 * 
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)))));

		::wsprintf(strPercent, "%d %%", nPercent);
		int		nLen = ::lstrlen(strPercent);
			                               
		dc.SetBkMode(TRANSPARENT);
		dc.SetTextAlign(TA_CENTER);
	
		nXPos = (rcClnt.Width()) / 2;
		sizeTextExt = dc.GetTextExtent(strPercent, nLen);
		nYPos = rcClnt.top + ((rcClnt.Height() - sizeTextExt.cy) / 2);

		dc.SetTextColor(m_RGBClrFill);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, rcClnt.right, rcClnt.bottom);
		dc.ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);

		dc.SetTextColor(m_RGBClrBk);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, (WORD) dwXPos, rcClnt.bottom);
		dc.ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);
	}
#endif
	
	// We need to decide whether the gauge style is normal, depressed or elevated and choose
	// the pens for drawing the border appropriately.
	
	CPen	penBorder, penInBorder;

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));
	
	// The inner border style
	if (m_nInGaugeStyle == GU_ELEVATED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderUp);
	else if (m_nInGaugeStyle == GU_DEPRESSED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderDn);
	else
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// Outer border	
	penOld = dc.SelectObject(&penBorder);
	dc.MoveTo(rcClnt.left - INNER_HORZ_GAP, rcClnt.bottom + INNER_VERT_GAP);
	dc.LineTo(rcClnt.left - INNER_HORZ_GAP, rcClnt.top - INNER_VERT_GAP);
	dc.LineTo(rcClnt.right + INNER_HORZ_GAP - 2, rcClnt.top - INNER_VERT_GAP);
	dc.SelectObject(penOld);
	penBorder.DeleteObject();
	
	// Inner border
	penOld = dc.SelectObject(&penInBorder);
	dc.MoveTo(rcClnt.left, rcClnt.bottom);
	dc.LineTo(rcClnt.left, rcClnt.top);
	dc.LineTo(rcClnt.right, rcClnt.top);
	dc.SelectObject(penOld);
	penInBorder.DeleteObject();

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// The inner border style
	if (m_nInGaugeStyle == GU_ELEVATED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderDn);
	else if (m_nInGaugeStyle == GU_DEPRESSED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderUp);
	else
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// Outer border
	penOld = dc.SelectObject(&penBorder);
	dc.MoveTo(rcClnt.right + INNER_HORZ_GAP, rcClnt.top - INNER_VERT_GAP);
	dc.LineTo(rcClnt.right + INNER_HORZ_GAP, rcClnt.bottom + INNER_VERT_GAP);
	dc.LineTo(rcClnt.left - INNER_HORZ_GAP + 2, rcClnt.bottom + INNER_VERT_GAP);
	dc.SelectObject(penOld);
	penBorder.DeleteObject();

	// Inner border
	penOld = dc.SelectObject(&penInBorder);
	dc.MoveTo(rcClnt.right, rcClnt.top);
	dc.LineTo(rcClnt.right, rcClnt.bottom);
	dc.LineTo(rcClnt.left + 2, rcClnt.bottom);
	dc.SelectObject(penOld);
	penInBorder.DeleteObject();

	// Display the range minimum val at bottom and range maxlongimum val at top
	
	CRect	rcTmp;
	dc.SetTextColor(m_RGBClrTxt);
	dc.SetBkMode(TRANSPARENT);

	if (m_bInclRange) {
	
		char	strRange[20];
	
		rcTmp.SetRect(rcClnt.right + HORZ_GAP + 1, rcClnt.top,
				rcClnt.right + m_nRangeWd + HORZ_GAP + 1,
				rcClnt.top + m_nRangeHt + INNER_VERT_GAP);

		dc.SetTextAlign(TA_LEFT);
		::wsprintf(strRange, "%d", m_nMaxVal);
		dc.ExtTextOut(rcTmp.left, rcTmp.top,
					ETO_CLIPPED, &rcTmp, strRange, ::lstrlen(strRange), NULL);
					
		rcTmp.SetRect(rcClnt.right + HORZ_GAP + 1, rcClnt.bottom - m_nRangeHt - INNER_VERT_GAP,
						rcClnt.right + m_nRangeWd + HORZ_GAP + 1, rcClnt.bottom);
		::wsprintf(strRange, "%d", m_nMinVal);
		dc.ExtTextOut(rcTmp.left, rcTmp.top,
					ETO_CLIPPED, &rcTmp, strRange, ::lstrlen(strRange), NULL);
	}
	
	// Display the caption.
	if (!m_strCaption.IsEmpty()) {
	
		rcTmp.SetRect(rcClnt.left - HORZ_GAP + 1, rcClnt.bottom + VERT_GAP,
						m_rcWndDim.Width() - HORZ_GAP-HORZ_GAP,
						rcClnt.bottom + VERT_GAP + m_nRangeHt + INNER_VERT_GAP);
		dc.SetTextAlign(TA_LEFT);
		dc.ExtTextOut(rcTmp.left, rcTmp.top,
					ETO_CLIPPED, &rcTmp, m_strCaption, m_strCaption.GetLength(), NULL);
	}
}

// -------------------------------------------------------------------------
// Function			:	CVertGauge::DrawProgress()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the vertical gauge in response to a 
// 						UpdateProgress() call.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CVertGauge::DrawProgress(CWnd* pGaugeWnd)
{
	DWORD		dwXPos;
	CPen		*penOld;
	CRect		rcClnt;
	TEXTMETRIC	tm;

	// The coordinates of the gauge.
	pGaugeWnd->GetClientRect(&rcClnt);
	rcClnt.left += (INNER_HORZ_GAP + HORZ_GAP);
	rcClnt.right = rcClnt.left + m_rcDim.Width();
	rcClnt.top += (VERT_GAP + INNER_VERT_GAP);
	rcClnt.bottom -= (VERT_GAP * 2 + INNER_VERT_GAP);
	
	CDC *pDC = pGaugeWnd->GetDC(); 				// Device context for painting
	
	pDC->GetTextMetrics(&tm);
	rcClnt.bottom -= tm.tmHeight;
	
	dwXPos = (DWORD)((DWORD) (rcClnt.bottom - rcClnt.top) * (DWORD)
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal))));
						
	if (dwXPos > (DWORD) rcClnt.Height())
		dwXPos = (DWORD) rcClnt.Height();
                
	// First fill the entire rectangle with background color.
	CBrush	brBk;
	CPen	penNull;

	brBk.CreateSolidBrush(m_RGBClrBk);
	CBrush	*brOld = pDC->SelectObject(&brBk);

	penNull.CreateStockObject(NULL_PEN);
	penOld = pDC->SelectObject(&penNull);

	pDC->Rectangle(rcClnt.left+1, (rcClnt.bottom - (WORD) dwXPos), rcClnt.right+1, rcClnt.top+1);
	pDC->SelectObject(brOld);
	brBk.DeleteObject();

	// Now fill the progress area with the fill color.
	if (dwXPos >  0) {
	
		CBrush	brFill;

		penNull.CreateStockObject(NULL_PEN);
		penOld = pDC->SelectObject(&penNull);
		
		brFill.CreateSolidBrush(m_RGBClrFill);
		CBrush*	brOld = pDC->SelectObject(&brFill);
		pDC->Rectangle(rcClnt.left+1, rcClnt.bottom, rcClnt.right+1, (rcClnt.bottom - (WORD) dwXPos));
		pDC->SelectObject(brOld);
		pDC->SelectObject(penOld);
		brFill.DeleteObject();
	}

#if 0
	// Output the percent text if the option is set.
	if (m_bInclPercent) {
	
		int		nXPos, nYPos;
		char	strPercent[6];
		CRect	rcTmp;
		CSize	sizeTextExt;
        
        int		nPercent = (int)((DWORD) (DWORD)((DWORD) 100 * 
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)))));

		::wsprintf(strPercent, "%d %%", nPercent);
		int		nLen = ::lstrlen(strPercent);
			                               
		pDC->SetBkMode(TRANSPARENT);
		pDC->SetTextAlign(TA_CENTER);
	
		nXPos = (rcClnt.Width()) / 2;
		sizeTextExt = pDC->GetTextExtent(strPercent, nLen);
		nYPos = rcClnt.top + ((rcClnt.Height() - sizeTextExt.cy) / 2);

		pDC->SetTextColor(m_RGBClrFill);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, rcClnt.right, rcClnt.bottom);
		pDC->ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);
		pDC->SetTextColor(m_RGBClrBk);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, (WORD) dwXPos, rcClnt.bottom);
		pDC->ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);
	}
#endif
	
	// We need to decide whether the gauge style is normal. depressed or elevated and choose
	// the pens for drawing the border appropriately.
	
	CPen	penBorder, penInBorder;

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));
	
	// The inner border style
	if (m_nInGaugeStyle == GU_ELEVATED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderUp);
	else if (m_nInGaugeStyle == GU_DEPRESSED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderDn);
	else
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// Outer border	
	penOld = pDC->SelectObject(&penBorder);
	pDC->MoveTo(rcClnt.left - INNER_HORZ_GAP, rcClnt.bottom + INNER_VERT_GAP);
	pDC->LineTo(rcClnt.left - INNER_HORZ_GAP, rcClnt.top - INNER_VERT_GAP);
	pDC->LineTo(rcClnt.right + INNER_HORZ_GAP - 2, rcClnt.top - INNER_VERT_GAP);
	pDC->SelectObject(penOld);
	penBorder.DeleteObject();
	
	// Inner border
	if ((rcClnt.bottom - (WORD) dwXPos) > 0) {
		penOld = pDC->SelectObject(&penInBorder);
		pDC->MoveTo(rcClnt.left, rcClnt.bottom);
		pDC->LineTo(rcClnt.left, (rcClnt.bottom - (WORD) dwXPos));
		pDC->LineTo(rcClnt.right, (rcClnt.bottom - (WORD) dwXPos));
		pDC->SelectObject(penOld);
	}
	penInBorder.DeleteObject();

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// The inner border style
	if (m_nInGaugeStyle == GU_ELEVATED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderDn);
	else if (m_nInGaugeStyle == GU_DEPRESSED)
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, m_RGBClrBorderUp);
	else
		penInBorder.CreatePen(PS_SOLID, INNER_PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	// Outer border
	penOld = pDC->SelectObject(&penBorder);
	pDC->MoveTo(rcClnt.right + INNER_HORZ_GAP, rcClnt.top - INNER_VERT_GAP);
	pDC->LineTo(rcClnt.right + INNER_HORZ_GAP, rcClnt.bottom + INNER_VERT_GAP);
	pDC->LineTo(rcClnt.left - INNER_HORZ_GAP + 2, rcClnt.bottom + INNER_VERT_GAP);
	pDC->SelectObject(penOld);
	penBorder.DeleteObject();
	
	// Inner border
	if ((rcClnt.bottom - (WORD) dwXPos) > 0) {
		penOld = pDC->SelectObject(&penInBorder);
		pDC->MoveTo(rcClnt.right, (rcClnt.bottom - (WORD) dwXPos));
		pDC->LineTo(rcClnt.right, rcClnt.bottom);
		pDC->LineTo(rcClnt.left + 2, rcClnt.bottom);
		pDC->SelectObject(penOld);
	}
	penInBorder.DeleteObject();

	pGaugeWnd->ReleaseDC(pDC); 				// Device context for painting
}

// -------------------------------------------------------------------------
// 							CIRCULAR GUAGE IMPLEMENTATION
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Function			:	CCircleGauge::CalcGaugeWndSize()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Calculates the minimum window that has to be created
// 						for displaying the circular gauge, scalings and caption.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CCircleGauge::CalcGaugeWndSize(CWnd* pGaugeWnd)
{
	// We need to add for the caption below the progress gauge.
	CDC			*pDC;
	TEXTMETRIC	tm;
	
	pDC = pGaugeWnd->GetDC();
	pDC->GetTextMetrics(&tm);
	
	int		nWidth, nHeight;
	char	strRange[20];
	CSize	sizeCapt;
	CSize	sizeRange;

	// Calculate the width of the window by checking for caption size and gauge size.
	// The gauge size will have to include the range text width also in this case.
	::wsprintf(strRange, "%d", m_nMinVal);
	sizeRange = pDC->GetTextExtent(strRange, ::lstrlen(strRange));
	m_nRangeWd = sizeRange.cx;
	m_nRangeHt = sizeRange.cy;
	::wsprintf(strRange, "%d", m_nMaxVal);
	sizeRange = pDC->GetTextExtent(strRange, ::lstrlen(strRange));
	m_nRangeWd = (int) maxDWORD(m_nRangeWd, (DWORD) sizeRange.cx);
	m_nRangeHt = (int) maxDWORD(m_nRangeHt, (DWORD) sizeRange.cy);
	
	m_nCircleDia = min(m_rcDim.Width(), m_rcDim.Height());
	nWidth = (HORZ_GAP + m_nCircleDia + HORZ_GAP + m_nRangeWd);
	
	sizeCapt = pDC->GetTextExtent(m_strCaption, m_strCaption.GetLength());
	pGaugeWnd->ReleaseDC(pDC);

	if (sizeCapt.cx > nWidth)
		nWidth = HORZ_GAP + sizeCapt.cx + HORZ_GAP;
	
	// Calculate the height of the window by making provision for the scalings and caption
	nHeight = VERT_GAP + m_nCircleDia + VERT_GAP + sizeCapt.cy + VERT_GAP;
		
	m_rcWndDim = m_rcDim;
	m_rcWndDim.right = m_rcWndDim.left + nWidth;
	m_rcWndDim.bottom = m_rcWndDim.top + nHeight;
}

// -------------------------------------------------------------------------
// Function			:	CCircleGauge::DoPaint()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the circular gauge in response to a 
// 						WM_PAINT message.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CCircleGauge::DoPaint(CWnd* pGaugeWnd)
{
#if 0
	double		Degree;
	CRect		rcClnt;
	CPoint		ptCentre, ptStart, ptEnd;
	TEXTMETRIC	tm;

	// The coordinates of the gauge.
	pGaugeWnd->GetClientRect(&rcClnt);
	rcClnt.left += HORZ_GAP;
	rcClnt.right = rcClnt.left + m_nCircleDia;
	rcClnt.top += VERT_GAP;
	rcClnt.bottom = rcClnt.top + m_nCircleDia;

	// The centre of the circular gauge.
	ptCentre.x = rcClnt.left + (m_nCircleDia / 2);
	ptCentre.y = rcClnt.top + (m_nCircleDia / 2);

	CPaintDC dc(pGaugeWnd); 			// Device context for painting
	
	dc.GetTextMetrics(&tm);
	
	// Display the divisions
	if (m_bInclScale) {
		dc.MoveTo(rcClnt.left-HORZ_GAP+1, ptCentre.y);
		dc.LineTo(rcClnt.right+HORZ_GAP-1, ptCentre.y);
	
		dc.MoveTo(ptCentre.x, rcClnt.top - VERT_GAP + 1);
		dc.LineTo(ptCentre.x, rcClnt.bottom + VERT_GAP - 1);
	}
	
	CBrush	brBk;
	CPen	penNull;
	CRect	rcTmp;

	// First fill the circle with background color.
	brBk.CreateSolidBrush(m_RGBClrBk);
	CBrush	*brOld = dc.SelectObject(&brBk);

	penNull.CreateStockObject(NULL_PEN);
	CPen 	*penOld = dc.SelectObject(&penNull);

	dc.Ellipse((LPCRECT) &rcClnt);
	dc.SelectObject(brOld);
	brBk.DeleteObject();
	
	// Now fill the progress area with the fill color.

	Degree = (double) (2 * PI * (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal)))) /
							(maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)));
	if (Degree >  0) {
	
		CBrush	brFill;

		// Starting chord.
		ptStart.x = (m_nCircleDia / 2) + ptCentre.x;
		ptStart.y = ptCentre.y;
		
		// Ending chord
		if (m_nCurVal == m_nMaxVal) {
			ptEnd.x = ptStart.x;
			ptEnd.y = ptStart.y;
		}
		else {
			ptEnd.x = (int) (((m_nCircleDia / 2) * cos(Degree)) + ptCentre.x);
			ptEnd.y = (int) (ptCentre.y - ((m_nCircleDia / 2) * sin(Degree)));
		}
		
		brFill.CreateSolidBrush(m_RGBClrFill);
		brOld = dc.SelectObject(&brFill);
		rcTmp.SetRect(rcClnt.left+2, rcClnt.top+2, rcClnt.right-1, rcClnt.bottom-1);
		dc.Pie(&rcTmp, ptStart, ptEnd);
		dc.SelectObject(brOld);
		brFill.DeleteObject();
	}
	dc.SelectObject(penOld);

#if 0
	// Output the percent text if the option is set.
	if (m_bInclPercent) {
	
		int		nXPos, nYPos;
		char	strPercent[6];
		CSize	sizeTextExt;
        
        int		nPercent = (int)((DWORD) (DWORD)((DWORD) 100 * 
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)))));

		::wsprintf(strPercent, "%d %%", nPercent);
		int		nLen = ::lstrlen(strPercent);
			                               
		dc.SetBkMode(TRANSPARENT);
		dc.SetTextAlign(TA_CENTER);
	
		nXPos = (rcClnt.Width()) / 2;
		sizeTextExt = dc.GetTextExtent(strPercent, nLen);
		nYPos = rcClnt.top + ((rcClnt.Height() - sizeTextExt.cy) / 2);

		dc.SetTextColor(m_RGBClrFill);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, rcClnt.right, rcClnt.bottom);
		dc.ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);

		dc.SetTextColor(m_RGBClrBk);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, (WORD) dwXPos, rcClnt.bottom);
		dc.ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);
	}
#endif
	
	// We need to decide whether the gauge style is normal, depressed or elevated and choose
	// the pens for drawing the border appropriately.
	
	CPen	penBorder;
	CBrush	brNull;

	brNull.CreateStockObject(NULL_BRUSH);
	brOld = dc.SelectObject(&brNull);

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderUp);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderDn);
	else
		penBorder.CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));
	
	rcTmp.SetRect(rcClnt.left, rcClnt.top, rcClnt.right, rcClnt.bottom);
	penOld = dc.SelectObject(&penBorder);
	dc.Ellipse((LPCRECT) &rcTmp);
	dc.SelectObject(penOld);
	penBorder.DeleteObject();
	
	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderDn);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderUp);
	else
		penBorder.CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));

	rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, rcClnt.right-1, rcClnt.bottom-1);
	penOld = dc.SelectObject(&penBorder);
	dc.Ellipse((LPCRECT) &rcTmp);
	dc.SelectObject(penOld);
	dc.SelectObject(brOld);
	penBorder.DeleteObject();

	// Display the range minimum val left justified and maxlongimum val right justified
	
	dc.SetTextColor(m_RGBClrTxt);
	dc.SetBkMode(TRANSPARENT);
	
	if(m_bInclRange) {

		char	strRange[20];

		rcTmp.SetRect(rcClnt.right + HORZ_GAP + 1, ptCentre.y - VERT_GAP - m_nRangeHt,
				rcClnt.right + m_nRangeWd + HORZ_GAP + 1, ptCentre.y - VERT_GAP);
		dc.SetTextAlign(TA_LEFT);
		::wsprintf(strRange, "%d", m_nMinVal);
		dc.ExtTextOut(rcTmp.left, rcTmp.top,
					ETO_CLIPPED, &rcTmp, strRange, ::lstrlen(strRange), NULL);
					
		rcTmp.SetRect(rcClnt.right + HORZ_GAP + 1, ptCentre.y + VERT_GAP,
				rcClnt.right + m_nRangeWd + HORZ_GAP + 1, ptCentre.y + VERT_GAP +  m_nRangeHt);
		::wsprintf(strRange, "%d", m_nMaxVal);
		dc.ExtTextOut(rcTmp.left, rcTmp.top,      
					ETO_CLIPPED, &rcTmp, strRange, ::lstrlen(strRange), NULL);
	}
	
	// Display the caption.
	if (!m_strCaption.IsEmpty()) {
	
		rcTmp.SetRect(rcClnt.left - HORZ_GAP + 1, rcClnt.bottom + VERT_GAP,
						m_rcWndDim.Width() - HORZ_GAP - HORZ_GAP,
						rcClnt.bottom + VERT_GAP + m_nRangeHt);
		dc.SetTextAlign(TA_CENTER);
		dc.ExtTextOut(rcTmp.right/2, rcTmp.top,
					ETO_CLIPPED, &rcTmp, m_strCaption, m_strCaption.GetLength(), NULL);
	}
#endif
}

// -------------------------------------------------------------------------
// Function			:	CCircleGauge::DrawProgress()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the circular gauge in response to a 
// 						UpdateProgress() call.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CCircleGauge::DrawProgress(CWnd* pGaugeWnd)
{
#if 0
	double		Degree;
	CRect		rcClnt;
	CPoint		ptCentre, ptStart, ptEnd;

	// The coordinates of the gauge.
	pGaugeWnd->GetClientRect(&rcClnt);
	rcClnt.left += HORZ_GAP;
	rcClnt.right = rcClnt.left + m_nCircleDia;
	rcClnt.top += VERT_GAP;
	rcClnt.bottom = rcClnt.top + m_nCircleDia;

	// The centre of the circular gauge.
	ptCentre.x = rcClnt.left + (m_nCircleDia / 2);
	ptCentre.y = rcClnt.top + (m_nCircleDia / 2);

	CDC 	*pDC = pGaugeWnd->GetDC();
	CBrush	*brOld;
	CPen	penNull;
	CRect	rcTmp;

	// First fill the circle with background color.
	penNull.CreateStockObject(NULL_PEN);
	CPen 	*penOld = pDC->SelectObject(&penNull);
	
	// Now fill the progress area with the fill color.

	Degree = (double) (2 * PI * (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal)))) /
							(maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)));
	if (Degree >  0) {
	
		CBrush	brFill;

		// Starting chord.
		ptStart.x = (m_nCircleDia / 2) + ptCentre.x;
		ptStart.y = ptCentre.y;
		
		// Ending chord
		if (m_nCurVal == m_nMaxVal) {
			ptEnd.x = ptStart.x;
			ptEnd.y = ptStart.y;
		}
		else {
			ptEnd.x = (int) (((m_nCircleDia / 2) * cos(Degree)) + ptCentre.x);
			ptEnd.y = (int) (ptCentre.y - ((m_nCircleDia / 2) * sin(Degree)));
		}
		
		brFill.CreateSolidBrush(m_RGBClrFill);
		brOld = pDC->SelectObject(&brFill);
		rcTmp.SetRect(rcClnt.left+2, rcClnt.top+2, rcClnt.right-1, rcClnt.bottom-1);
		pDC->Pie(&rcTmp, ptStart, ptEnd);
		pDC->SelectObject(brOld);
		brFill.DeleteObject();
	}
	pDC->SelectObject(penOld);

#if 0
	// Output the percent text if the option is set.
	if (m_bInclPercent) {
	
		int		nXPos, nYPos;
		char	strPercent[6];
		CSize	sizeTextExt;
        
        int		nPercent = (int)((DWORD) (DWORD)((DWORD) 100 * 
					(DWORD) (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal))) /
					(DWORD) (maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)))));

		::wsprintf(strPercent, "%d %%", nPercent);
		int		nLen = ::lstrlen(strPercent);
			                               
		pDC->SetBkMode(TRANSPARENT);
		pDC->SetTextAlign(TA_CENTER);
	
		nXPos = (rcClnt.Width()) / 2;
		sizeTextExt = pDC->GetTextExtent(strPercent, nLen);
		nYPos = rcClnt.top + ((rcClnt.Height() - sizeTextExt.cy) / 2);

		pDC->SetTextColor(m_RGBClrFill);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, rcClnt.right, rcClnt.bottom);
		pDC->ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);

		pDC->SetTextColor(m_RGBClrBk);
		rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, (WORD) dwXPos, rcClnt.bottom);
		pDC->ExtTextOut(nXPos, nYPos, ETO_CLIPPED, &rcTmp, strPercent,
														nLen, NULL);
	}
#endif
	
	// We need to decide whether the gauge style is normal, depressed or elevated and choose
	// the pens for drawing the border appropriately.
	
	CPen	penBorder;
	CBrush	brNull;

	brNull.CreateStockObject(NULL_BRUSH);
	brOld = pDC->SelectObject(&brNull);

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderUp);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderDn);
	else
		penBorder.CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));
	
	rcTmp.SetRect(rcClnt.left, rcClnt.top, rcClnt.right, rcClnt.bottom);
	penOld = pDC->SelectObject(&penBorder);
	pDC->Ellipse((LPCRECT) &rcTmp);
	pDC->SelectObject(penOld);
	penBorder.DeleteObject();
	
	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderDn);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderUp);
	else
		penBorder.CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));

	rcTmp.SetRect(rcClnt.left+1, rcClnt.top+1, rcClnt.right-1, rcClnt.bottom-1);
	penOld = pDC->SelectObject(&penBorder);
	pDC->Ellipse((LPCRECT) &rcTmp);
	pDC->SelectObject(penOld);
	pDC->SelectObject(brOld);
	penBorder.DeleteObject();

	pGaugeWnd->ReleaseDC(pDC);
#endif
}

// -------------------------------------------------------------------------
// 							COUNTER GUAGE IMPLEMENTATION
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Function			:	CCounterGauge::CalcGaugeWndSize()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Calculates the minimum window that has to be created
// 						for displaying the counter gauge and caption.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CCounterGauge::CalcGaugeWndSize(CWnd* pGaugeWnd)
{
	DWORD		nMaxRange;
	int			nNumDigits;
	int			nWidth, nHeight;
	CDC			*pDC;
	TEXTMETRIC	tm;
	
	// First compute the number of digits based on Maximum value.
	nNumDigits = (m_nMaxVal >= 0) ? 0 : 1;		// One char for '-' sign
	nMaxRange = absDWORD(m_nMaxVal);
	while (nMaxRange > 0) {
		nMaxRange /= 10;
		nNumDigits++;
	}
	m_nNumDigits = nNumDigits;
	
	// Now compute the number of digits based on Minimum value.
	nNumDigits = (m_nMinVal >= 0) ? 0 : 1;		// One char for '-' sign
	nMaxRange = absDWORD(m_nMinVal);
	while (nMaxRange > 0) {
		nMaxRange /= 10;
		nNumDigits++;
	}
	if (nNumDigits > m_nNumDigits)
		m_nNumDigits = nNumDigits;
	
	pDC = pGaugeWnd->GetDC();
	pDC->GetTextMetrics(&tm);

//	nWidth = HORZ_GAP + (((tm.tmMaxCharWidth * 120) / 100) * m_nNumDigits) + HORZ_GAP;
	nWidth = HORZ_GAP + (((tm.tmMaxCharWidth * 120) / 100) * m_nNumDigits) + HORZ_GAP * 2;
	nHeight = VERT_GAP + tm.tmHeight + VERT_GAP;

	if (!m_strCaption.IsEmpty()) {
	
		CSize	sizeCapt;

		sizeCapt = pDC->GetTextExtent(m_strCaption, m_strCaption.GetLength());
		m_nCaptWidth = sizeCapt.cx;
		nWidth += (sizeCapt.cx + HORZ_GAP);
	}
	else
		m_nCaptWidth = 0;			// No caption

	m_rcWndDim = m_rcDim;
	m_rcWndDim.right = m_rcDim.left + nWidth;
	m_rcWndDim.bottom = m_rcDim.top + nHeight;

	pGaugeWnd->ReleaseDC(pDC);
}

// -------------------------------------------------------------------------
// Function			:	CCounterGauge::DoPaint()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the counter gauge in response to a
// 						WM_PAINT message.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CCounterGauge::DoPaint(CWnd* pGaugeWnd)
{
	CRect		rcClnt;
	TEXTMETRIC	tm;
	
	CPaintDC	dc(pGaugeWnd);
	dc.GetTextMetrics(&tm);

	pGaugeWnd->GetClientRect(&rcClnt);
	rcClnt.left += HORZ_GAP;
	rcClnt.top += VERT_GAP;
	rcClnt.right -= (HORZ_GAP + m_nCaptWidth + HORZ_GAP);
	rcClnt.bottom -= VERT_GAP;
	
	// First fill the entire rectangle with background color.
	CBrush	brBk;
	brBk.CreateSolidBrush(m_RGBClrBk);
	CBrush	*brOld = dc.SelectObject(&brBk);

	CPen	penNull;
	penNull.CreateStockObject(NULL_PEN);
	CPen 	*penOld = dc.SelectObject(&penNull);

	dc.Rectangle(rcClnt.left + 1, rcClnt.top + 1, rcClnt.right - 1, rcClnt.bottom - 1);
	dc.SelectObject(brOld);
	brBk.DeleteObject();
	
	// We need to decide whether the gauge style is normal, depressed or elevated and choose
	// the pens for drawing the border appropriately.
	
	CPen	penBorder;

	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));
	
	penOld = dc.SelectObject(&penBorder);
	
	dc.MoveTo(rcClnt.left, rcClnt.bottom);
	dc.LineTo(rcClnt.left, rcClnt.top);
	dc.LineTo(rcClnt.right-2, rcClnt.top);
	dc.SelectObject(penOld);
	penBorder.DeleteObject();
	
	if (m_nGaugeStyle == GU_ELEVATED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	else if (m_nGaugeStyle == GU_DEPRESSED)
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	else
		penBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));

	penOld = dc.SelectObject(&penBorder);
	dc.MoveTo(rcClnt.right, rcClnt.top);
	dc.LineTo(rcClnt.right, rcClnt.bottom);
	dc.LineTo(rcClnt.left+2, rcClnt.bottom);
	dc.SelectObject(penOld);
	penBorder.DeleteObject();

	penBorder.CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));
	penOld = dc.SelectObject(&penBorder);
	
	for (int i=1; i < m_nNumDigits; i++) {
		dc.MoveTo(rcClnt.left + (((tm.tmMaxCharWidth * 120) / 100) * i), rcClnt.top + 1);
		dc.LineTo(rcClnt.left + (((tm.tmMaxCharWidth * 120) / 100) * i), rcClnt.bottom - 1);
	}
	
	dc.SelectObject(penOld);
	penBorder.DeleteObject();

	// In case there is a caption we need to draw it.
	int		nOldMode = dc.SetBkMode(TRANSPARENT);
	
	if (!m_strCaption.IsEmpty()) {	
	
		COLORREF	nOldClr = dc.SetTextColor(m_RGBClrTxt);
		CRect		rcTmp(rcClnt.right + HORZ_GAP, rcClnt.top,
								rcClnt.right + HORZ_GAP + m_nCaptWidth, rcClnt.bottom);
								
		dc.ExtTextOut(rcTmp.left, rcTmp.top,
					ETO_CLIPPED, &rcTmp, m_strCaption, m_strCaption.GetLength(), NULL);

		dc.SetTextColor(nOldClr);
	}
	
	char	strBuf[20];
	char	strFormat[20];
	::wsprintf((LPSTR) strFormat, "%%0%dd", m_nNumDigits);
	::wsprintf((LPSTR) strBuf, (LPSTR) strFormat, m_nCurVal);

	CRect	rcTmp;

	rcTmp.top = rcClnt.top + 1;
	rcTmp.bottom = rcClnt.bottom - 1;
	for (i=0; i < m_nNumDigits; i++) {
		rcTmp.left = rcClnt.left + (((tm.tmMaxCharWidth * 120) / 100) * i);
		rcTmp.right = rcClnt.left + (((tm.tmMaxCharWidth * 120) / 100) * (i+1));
		dc.DrawText((LPSTR) &strBuf[i], 1, &rcTmp, DT_CENTER | DT_SINGLELINE | DT_VCENTER);
	}
	dc.SetBkMode(nOldMode);
	dc.SelectObject(brOld);
}

// -------------------------------------------------------------------------
// Function			:	CCounterGauge::DrawProgress()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the counter gauge in response to a 
// 						UpdateProgress() call.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CCounterGauge::DrawProgress(CWnd* pGaugeWnd)
{
	CRect		rcClnt;
	TEXTMETRIC	tm;
	
	CDC		*pDC = pGaugeWnd->GetDC();

	pDC->GetTextMetrics(&tm);

	pGaugeWnd->GetClientRect(&rcClnt);
	rcClnt.left += HORZ_GAP;
	rcClnt.top += VERT_GAP;
	rcClnt.right -= (HORZ_GAP + m_nCaptWidth + HORZ_GAP);
	rcClnt.bottom -= VERT_GAP;
	
	// First fill the entire rectangle with background color.
	CBrush	brBk;
	brBk.CreateSolidBrush(m_RGBClrBk);
	CBrush	*brOld = pDC->SelectObject(&brBk);

	CPen	penNull;
	penNull.CreateStockObject(NULL_PEN);
	CPen 	*penOld = pDC->SelectObject(&penNull);

	pDC->Rectangle(rcClnt.left + 1, rcClnt.top + 1, rcClnt.right - 1, rcClnt.bottom - 1);
	pDC->SelectObject(brOld);
	brBk.DeleteObject();
	
	CPen	penBorder;
	penBorder.CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));
	penOld = pDC->SelectObject(&penBorder);
	
	for (int i=1; i < m_nNumDigits; i++) {
		pDC->MoveTo(rcClnt.left + (((tm.tmMaxCharWidth * 120) / 100) * i), rcClnt.top + 1);
		pDC->LineTo(rcClnt.left + (((tm.tmMaxCharWidth * 120) / 100) * i), rcClnt.bottom - 1);
	}
	
	pDC->SelectObject(penOld);
	penBorder.DeleteObject();
	
	char	strBuf[20];
	char	strFormat[20];
	::wsprintf((LPSTR) strFormat, "%%0%dd", m_nNumDigits);
	::wsprintf((LPSTR) strBuf, (LPSTR) strFormat, m_nCurVal);

	CRect	rcTmp;

	rcTmp.top = rcClnt.top + 1;
	rcTmp.bottom = rcClnt.bottom - 1;
	int	nOldMode = pDC->SetBkMode(TRANSPARENT);
	for (i=0; i < m_nNumDigits; i++) {
		rcTmp.left = rcClnt.left + (((tm.tmMaxCharWidth * 120) / 100) * i);
		rcTmp.right = rcClnt.left + (((tm.tmMaxCharWidth * 120) / 100) * (i+1));
		pDC->DrawText((LPSTR) &strBuf[i], 1, &rcTmp, DT_CENTER | DT_SINGLELINE | DT_VCENTER);
	}
	pDC->SetBkMode(nOldMode);
	pDC->SelectObject(brOld);
	pGaugeWnd->ReleaseDC(pDC);
}

// -------------------------------------------------------------------------
// 							METER GUAGE IMPLEMENTATION
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Function			:	CMeterGauge::CalcGaugeWndSize()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Calculates the minimum window that has to be created
// 						for displaying the meter gauge and caption.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CMeterGauge::CalcGaugeWndSize(CWnd* pGaugeWnd)
{
	// We need to add for the caption below the progress gauge.
	CDC			*pDC;
	TEXTMETRIC	tm;
	CSize		sizeCapt;
	
	// Get the gauge caption height
	pDC = pGaugeWnd->GetDC();
	pDC->GetTextMetrics(&tm);
	sizeCapt = pDC->GetTextExtent(m_strCaption, m_strCaption.GetLength());
	pGaugeWnd->ReleaseDC(pDC);
	
	int		nWidth, nHeight;

	// Calculate the width of the window by checking for caption size and gauge size.
	nWidth = HORZ_GAP * 2 + m_rcDim.Height() * 2 + HORZ_GAP * 2;

	int		nCaptWidth;
	char	strRange[20];
	
	nCaptWidth = HORZ_GAP + sizeCapt.cx + HORZ_GAP;
	::wsprintf(strRange, "%d", m_nMinVal);
	sizeCapt = pDC->GetTextExtent(strRange, ::lstrlen(strRange));
	nCaptWidth += sizeCapt.cx;

	::wsprintf(strRange, "%d", m_nMaxVal);
	sizeCapt = pDC->GetTextExtent(strRange, ::lstrlen(strRange));
	nCaptWidth += sizeCapt.cx;

	if (nCaptWidth > nWidth)
		nWidth = HORZ_GAP + nCaptWidth + HORZ_GAP;
	
	// Calculate the height of the window by making provision for the scalings and caption
	nHeight = VERT_GAP + m_rcDim.Height() + VERT_GAP + tm.tmHeight + VERT_GAP;
		
	m_rcWndDim = m_rcDim;
	m_rcWndDim.right = m_rcWndDim.left + nWidth;
	m_rcWndDim.bottom = m_rcWndDim.top + nHeight;
	m_nCircleDia = m_rcDim.Height() * 2;
	
	m_ptPrevPos.x = HORZ_GAP * 2 + HORZ_GAP * 2;
	m_ptPrevPos.y = VERT_GAP + m_rcDim.Height();
}

// -------------------------------------------------------------------------
// Function			:	CMeterGauge::DoPaint()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the Meter gauge in response to a
// 						WM_PAINT message.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CMeterGauge::DoPaint(CWnd* pGaugeWnd)
{
	CRect		rcClnt, rcMeter;
	CPaintDC	dc(pGaugeWnd);
	
	pGaugeWnd->GetClientRect(&rcClnt);
	rcMeter.CopyRect(&rcClnt);
	
	// Rectangle for drawing the meter
	rcMeter.left += (HORZ_GAP * 2);
	rcMeter.right = rcMeter.left + m_nCircleDia;
	rcMeter.top += VERT_GAP;
	rcMeter.bottom = rcMeter.top + m_nCircleDia;
	
	CPen	penNull, *penOld;
	CBrush	brFill, *brOld;

	penNull.CreateStockObject(NULL_PEN);
	brFill.CreateSolidBrush(m_RGBClrBk);
	penOld = dc.SelectObject(&penNull);
	brOld = dc.SelectObject(&brFill);
	dc.RoundRect(rcClnt.left + 4, rcClnt.top + 4, rcClnt.right - 4, rcClnt.bottom - 4, 6, 6);
	dc.SelectObject(brOld);
	dc.SelectObject(penOld);
	brFill.DeleteObject();
	
	// We need to decide whether the gauge style is normal, depressed or elevated and choose
	// the pens for drawing the border appropriately.
	
	CPen	penBorder, penThickBorder;
	CBrush	brNull;

	brNull.CreateStockObject(NULL_BRUSH);
	brOld = dc.SelectObject(&brNull);

	if (m_nGaugeStyle == GU_ELEVATED) {
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderUp);
		penThickBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	}
	else if (m_nGaugeStyle == GU_DEPRESSED) {
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderDn);
		penThickBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	}
	else {
		penBorder.CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));
		penThickBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));
	}
	
	CRect	rcTmp;
	CPoint	ptStart, ptEnd;
	
	rcTmp.SetRect(rcMeter.left, rcMeter.top, rcMeter.right, rcMeter.bottom);
	ptStart.x = rcTmp.right;
	ptStart.y = rcMeter.top + m_nCircleDia/2;
	ptEnd.x = rcTmp.left;
	ptEnd.y = rcMeter.top + m_nCircleDia/2;
	
	penOld = dc.SelectObject(&penBorder);
	dc.Arc((LPCRECT) &rcTmp, ptStart, ptEnd);
	
	rcTmp.SetRect(rcMeter.left + HORZ_GAP, rcMeter.top + HORZ_GAP,
							rcMeter.right - HORZ_GAP, rcMeter.bottom - HORZ_GAP);
	dc.Arc((LPCRECT) &rcTmp, ptStart, ptEnd);
	
	dc.MoveTo(rcMeter.left, rcMeter.top + m_nCircleDia/2);
	dc.LineTo(rcTmp.left, rcMeter.top + m_nCircleDia/2);

	dc.MoveTo(rcMeter.right - HORZ_GAP, rcMeter.top + m_nCircleDia/2);
	dc.LineTo(rcMeter.right, rcMeter.top + m_nCircleDia/2);

	dc.SelectObject(penOld);
	penBorder.DeleteObject();

	penOld = dc.SelectObject(&penThickBorder);
	dc.MoveTo(rcClnt.left, rcClnt.bottom);
	dc.LineTo(rcClnt.left, rcClnt.top);
	dc.LineTo(rcClnt.right - 2, rcClnt.top);
	dc.SelectObject(penOld);
	penThickBorder.DeleteObject();
	
	if (m_nGaugeStyle == GU_ELEVATED) {
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderDn);
		penThickBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderDn);
	}
	else if (m_nGaugeStyle == GU_DEPRESSED) {
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBorderUp);
		penThickBorder.CreatePen(PS_SOLID, PEN_WIDTH, m_RGBClrBorderUp);
	}
	else {
		penBorder.CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));
		penThickBorder.CreatePen(PS_SOLID, PEN_WIDTH, RGB(0x00, 0x00, 0x00));
	}

	rcTmp.SetRect(rcMeter.left + 1, rcMeter.top + 1, rcMeter.right - 1, rcMeter.bottom - 1);
	ptStart.x = rcTmp.right;
	ptStart.y = rcMeter.top + m_nCircleDia/2;
	ptEnd.x = rcTmp.left;
	ptEnd.y = rcMeter.top + m_nCircleDia/2;
	
	penOld = dc.SelectObject(&penBorder);
	dc.Arc((LPCRECT) &rcTmp, ptStart, ptEnd);
	
	rcTmp.SetRect(rcMeter.left + HORZ_GAP + 1, rcMeter.top + HORZ_GAP + 1,
							rcMeter.right - HORZ_GAP - 1, rcMeter.bottom - HORZ_GAP - 1);
	dc.Arc((LPCRECT) &rcTmp, ptStart, ptEnd);
	
	dc.SelectObject(penOld);
	dc.SelectObject(brOld);
	penBorder.DeleteObject();
	
	// The filling color arc
	penBorder.CreatePen(PS_SOLID, HORZ_GAP - 3, m_RGBClrFill);
	penOld = dc.SelectObject(&penBorder);
	rcTmp.SetRect(rcMeter.left + 2, rcMeter.top + 2,
							rcMeter.right - 2, rcMeter.bottom - 2);
	dc.Arc((LPCRECT) &rcTmp, ptStart, ptEnd);
	dc.SelectObject(penOld);
	penBorder.DeleteObject();

	penOld = dc.SelectObject(&penThickBorder);
	dc.MoveTo(rcClnt.right, rcClnt.top);
	dc.LineTo(rcClnt.right, rcClnt.bottom);
	dc.LineTo(rcClnt.left + 2, rcClnt.bottom);
	dc.SelectObject(penOld);
	penThickBorder.DeleteObject();
	
	// Divisions
	if (m_bInclScale) {
		// Left
		dc.MoveTo(rcMeter.left - HORZ_GAP + PEN_WIDTH, rcMeter.top + m_nCircleDia/2);
		dc.LineTo(rcMeter.left + HORZ_GAP, rcMeter.top + m_nCircleDia/2);

		// Right
		dc.MoveTo(rcMeter.right - HORZ_GAP, rcMeter.top + m_nCircleDia/2);
		dc.LineTo(rcMeter.right + HORZ_GAP - PEN_WIDTH, rcMeter.top + m_nCircleDia/2);
	
		// Middle
		dc.MoveTo(rcMeter.left + m_nCircleDia/2, rcMeter.top - HORZ_GAP + PEN_WIDTH);
		dc.LineTo(rcMeter.left + m_nCircleDia/2, rcMeter.top + HORZ_GAP);
	}
	
	// Display the current progress
	penBorder.CreatePen(PS_SOLID, 1, m_RGBClrTxt);
	penOld = dc.SelectObject(&penBorder);
	
	rcTmp.SetRect(rcMeter.left + m_nCircleDia/2 - 4, rcMeter.top + m_nCircleDia/2 - 4,
				rcMeter.left + m_nCircleDia/2 + 4, rcMeter.top + m_nCircleDia/2 + 4);
	dc.MoveTo(rcTmp.left + 4, rcTmp.top + 4);
	dc.LineTo(m_ptPrevPos.x, m_ptPrevPos.y);

	brFill.CreateSolidBrush(m_RGBClrFill);
	brOld = dc.SelectObject(&brFill);
	dc.Ellipse(&rcTmp);
	dc.SelectObject(brOld);
	dc.SelectObject(penOld);
	brFill.DeleteObject();
	penBorder.DeleteObject();
	
	// Display the range minimum val left justified and maxlongimum val right justified
	
	rcTmp.SetRect(rcClnt.left + HORZ_GAP, (rcMeter.top + m_nCircleDia/2 + VERT_GAP),
							rcClnt.right - HORZ_GAP, rcClnt.bottom - VERT_GAP);
	dc.SetTextColor(m_RGBClrTxt);
	dc.SetBkMode(TRANSPARENT);
	
	
	if (m_bInclRange) {
	
		char	strRange[20];
	
		dc.SetTextAlign(TA_LEFT);
		::wsprintf(strRange, "%d", m_nMinVal);
		dc.ExtTextOut(rcTmp.left, rcTmp.top,
					ETO_CLIPPED, &rcTmp, strRange, ::lstrlen(strRange), NULL);
					
		dc.SetTextAlign(TA_RIGHT);
		::wsprintf(strRange, "%d", m_nMaxVal);
		dc.ExtTextOut(rcTmp.right, rcTmp.top,
					ETO_CLIPPED, &rcTmp, strRange, ::lstrlen(strRange), NULL);
	}
	
	// Display the caption.
	if (!m_strCaption.IsEmpty()) {
	
		dc.SetTextAlign(TA_CENTER);
		dc.ExtTextOut(rcTmp.right / 2, rcTmp.top,
					ETO_CLIPPED, &rcTmp, m_strCaption, m_strCaption.GetLength(), NULL);
	}
}

// -------------------------------------------------------------------------
// Function			:	CMeterGauge::DrawProgress()
// Arguments		:	Gauge CWnd pointer.
// Synopsis			:	Updates the Meter gauge in response to a 
// 						UpdateProgress() call.
// Returns			:	None.
// Globals Affected	:	None.
// -------------------------------------------------------------------------
void
CMeterGauge::DrawProgress(CWnd* pGaugeWnd)
{
#if 0
	CRect	rcMeter;
	CDC		*pDC;
	
	pDC = pGaugeWnd->GetDC();
	pGaugeWnd->GetClientRect(&rcMeter);
	
	// Rectangle for drawing the meter
	rcMeter.left += (HORZ_GAP * 2);
	rcMeter.right = rcMeter.left + m_nCircleDia;
	rcMeter.top += VERT_GAP;
	rcMeter.bottom = rcMeter.top + m_nCircleDia;
	
	int		nXPos, nYPos;
	double	Degree = (double) (135 - ((2 * PI * (maxDWORD(absDWORD(m_nCurVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nCurVal), absDWORD(m_nMinVal)))) /
							(maxDWORD(absDWORD(m_nMaxVal), absDWORD(m_nMinVal)) - 
							min(absDWORD(m_nMaxVal), absDWORD(m_nMinVal))) / 2));
	CPoint	ptCentre;
	
	ptCentre.x = rcMeter.left + m_nCircleDia/2;
	ptCentre.y = rcMeter.top + m_nCircleDia/2;
							
	if (Degree >  0) {
	
		// Current position on the meter
		
		if (m_nCurVal == m_nMaxVal) {
			nXPos = m_nCircleDia;
			nYPos = ptCentre.y;
		}
		else {
			nXPos = (int) (ptCentre.x + (((m_nCircleDia / 2) - HORZ_GAP*2) * cos(Degree)));
			nYPos = (int) (ptCentre.y - (((m_nCircleDia / 2) - HORZ_GAP*2) * sin(Degree)));
			if (nYPos > ptCentre.y)
				nYPos = ptCentre.y;
		}

		// Erase the old line.
		CPen		penBorder, *penOld;
		
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrBk);
		penOld = pDC->SelectObject(&penBorder);

		pDC->MoveTo(ptCentre.x, ptCentre.y);
		pDC->LineTo(m_ptPrevPos.x, m_ptPrevPos.y);

		pDC->SelectObject(penOld);
		penBorder.DeleteObject();
	
		// Draw the new line.
		penBorder.CreatePen(PS_SOLID, 1, m_RGBClrTxt);
		penOld = pDC->SelectObject(&penBorder);
		pDC->MoveTo(ptCentre.x, ptCentre.y);
		pDC->LineTo(nXPos, nYPos);
	
		CRect		rcTmp;
		CBrush		brFill, *brOld;
		
		brFill.CreateSolidBrush(m_RGBClrFill);
		brOld = pDC->SelectObject(&brFill);
		rcTmp.SetRect(rcMeter.left + m_nCircleDia/2 - 4, rcMeter.top + m_nCircleDia/2 - 4,
				rcMeter.left + m_nCircleDia/2 + 4, rcMeter.top + m_nCircleDia/2 + 4);
		pDC->Ellipse(&rcTmp);

		pDC->SelectObject(brOld);
		pDC->SelectObject(penOld);
		brFill.DeleteObject();
		penBorder.DeleteObject();
		
		m_ptPrevPos.x = nXPos;
		m_ptPrevPos.y = nYPos;
	}

	pGaugeWnd->ReleaseDC(pDC);
#endif
}

// -------------------------------------------------------------------------
// End of file - MSGUVIEW.CPP
// -------------------------------------------------------------------------

