// natdlg.cpp : implementation file
//
// 04/07/98  : Jyothi made changes for Small Proxy
// 04/07/98  : Jyothi, uses structures instead of Ini file.

#include "stdafx.h"
#include "procon.h"
#include "natdlg.h"
#include "maskdot.h"
#include "proxy.h"
#include "cnffile.h"
#include "readbmp.h"
#include "utils.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

char *NATHeader = "NAT Setup";
STATIC_MAP_STRUCT *static_start, *static_entry_start ;
DYNAMIC_MAP_STRUCT *dyn_start, *dynamic_entry_start ;
BOOL static_map_added = 0, dynamic_map_added = 0, madd = 0, medit = 0;
char dyn_global_addr[16] = "\0";

extern CNF_PROXY_HEADER *proxy_header_ptr ;
extern int add_proxy_static_mapping (STATIC_MAP_STRUCT *static_entry_start, int static_maps) ;
extern int add_proxy_dynamic_mapping (DYNAMIC_MAP_STRUCT *dynamic_entry_start, char dyn_global_addr[16], int dyn_maps) ;

static char *ErrorMessage[] = {
		"Memory Allocation Failed",
		"A mapping exists for this entry. Cannot delete",
		"Enter an address to add",
		"Invalid IP Address",
		"This address already exists",
		"Select a global address to map",
		"Enter a local address to map",
		"Invalid Local Address",
		"Select a protocol type to map",
		"Select/Enter a port type to map",
		"This port number already exists",
		"Mapping for this port already exists",
		"The mappings entered will be restored",
		"This mapping already exists"
};

////Function that prefixes 0s before an userdefined port value
void PadWithZeroes (char *dest, char *source, int size)
{
	int i ;
	int Temp, SrcStringLength = strlen (source) ;

	for (i = 0 ; i < size ; i++)
		dest[i] = '0' ;
	dest[size] = 0 ;

	Temp = SrcStringLength ;
	while (Temp--)
	{
		dest[size-1] = source[SrcStringLength-1] ;

		SrcStringLength-- ;
		size-- ;
	}

   return ;
}

////To get the protocol number for a protocol value
void GetProtocolNumber (char *dest, char *source)
{
	int index = 0;
	while (ProtocolNameNumberMap[index].Name)
	{
		if (!strcmp (source, ProtocolNameNumberMap[index].Name))
		{
			strcpy (dest, ProtocolNameNumberMap[index].Number1);
			break;
		}
		index++;
	}
}

int GetNumberOfPorts (char *port, char *protocol)
{
	int index1 = 0, index2 = 0;
	while (ProtocolNameNumberMap[index1].Name)
	{
		if (!strcmp (protocol, ProtocolNameNumberMap[index1].Name))
			break;
		index1++;
	}
	while (PortNameNumberMap[index1][index2].Name)
	{
		if (!strcmp (port, PortNameNumberMap[index1][index2].Name))
			return (PortNameNumberMap[index1][index2].NumberOfPorts);
		index2++;
	}
	return 1;
}

////To get the port number for a port value
void GetPortNumber (char *dest, char *source, char *protocol, int number)
{
	int index1 = 0, index2 = 0;
	while (ProtocolNameNumberMap[index1].Name)
	{
		if (!strcmp (protocol, ProtocolNameNumberMap[index1].Name))
			break;
		index1++;
	}
	while (PortNameNumberMap[index1][index2].Name)
	{
		if (!strcmp (source, PortNameNumberMap[index1][index2].Name))
		{
			if (number == 1)
				strcpy (dest, PortNameNumberMap[index1][index2].Number1);
			else
				strcpy (dest, PortNameNumberMap[index1][index2].Number2);
			return;
		}
		index2++;
	}
	strcpy (dest, source);
}

void GetProtocolName (char *dest, char *source)
{
	int index = 0;
	while (ProtocolNameNumberMap[index].Name)
	{
		if (!strcmp (source, ProtocolNameNumberMap[index].Number1))
		{
			strcpy (dest, ProtocolNameNumberMap[index].Name);
			break;
		}
		index++;
	}
}

void GetPortName (char *dest, char *source, char *protocol)
{
	int portno, index1 = 0, index2 = 0;
	while (ProtocolNameNumberMap[index1].Name)
	{
		if (!strcmp (protocol, ProtocolNameNumberMap[index1].Name))
			break;
		index1++;
	}
	while (PortNameNumberMap[index1][index2].Name)
	{
		for (portno = 1; portno <= PortNameNumberMap[index1][index2].NumberOfPorts; portno++)		
		{
			if (portno == 1)
			{
				if (!strcmp (source, PortNameNumberMap[index1][index2].Number1))
				{
					strcpy (dest, PortNameNumberMap[index1][index2].Name);
					return;
				}
			}
			else
			{
				if (!strcmp (source, PortNameNumberMap[index1][index2].Number2))
				{
					strcpy (dest, PortNameNumberMap[index1][index2].Name);
					return;
				}
			}
		}
		index2++;
	}
	strcpy (dest, source);
	return;
}

/////////////////////////////////////////////////////////////////////////////
// CNATDlg dialog


CNATDlg::CNATDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNATDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNATDlg)
	m_edit_global_addr1 = "";
	//}}AFX_DATA_INIT
	address_added = FALSE;
}

void CNATDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNATDlg)
	DDX_Control(pDX, IDC_EDIT_MAP, m_ctrl_edit_map);
	DDX_Control(pDX, IDC_DELETE_MAP, m_ctrl_delete_map);
	DDX_Control(pDX, IDC_ADD_MAP, m_ctrl_add_map);
	DDX_Control(pDX, IDC_BUTTON_DELETE, m_ctrl_delete);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_ctrl_add);
	DDX_Control(pDX, IDC_LIST_MAPPING_DETAILS, m_ctrl_mapping_details);
	DDX_Control(pDX, IDC_EDIT_GLOBAL_ADDR, m_ctrl_edit_global_addr1);
	DDX_Control(pDX, IDC_LIST_GLOBAL_IP, m_ctrl_global_ip);
	DDX_Text(pDX, IDC_EDIT_GLOBAL_ADDR, m_edit_global_addr1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNATDlg, CDialog)
	//{{AFX_MSG_MAP(CNATDlg)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_BN_CLICKED(IDC_ADD_MAP, OnAddMap)
	ON_BN_CLICKED(IDC_EDIT_MAP, OnEditMap)
	ON_BN_CLICKED(IDC_DELETE_MAP, OnDeleteMap)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CNATDlg message handlers

BOOL CNATDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!AddBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn.SubclassDlgItem (IDC_BUTTON_ADD, this));
	AddBmpBtn.SizeToContent();

	if (!DeleteBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn.SubclassDlgItem (IDC_BUTTON_DELETE, this));
	DeleteBmpBtn.SizeToContent();

	if (!AddMapBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddMapBmpBtn.SubclassDlgItem (IDC_ADD_MAP, this));
	AddMapBmpBtn.SizeToContent();

	if (!DeleteMapBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteMapBmpBtn.SubclassDlgItem (IDC_DELETE_MAP, this));
	DeleteMapBmpBtn.SizeToContent();

	if (!EditMapBmpBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditMapBmpBtn.SubclassDlgItem (IDC_EDIT_MAP, this));
	EditMapBmpBtn.SizeToContent();

/* Jo 31/08/99 For Proper Tabs */
	int TabStops[] = {22, 90, 150, 195};

	m_ctrl_mapping_details.SetTabStops (4, (LPINT)&TabStops); 

	static_start = NULL;
	dyn_start = NULL;
   static_entry_start = NULL ;	
	dynamic_entry_start = NULL ;

	GetConfig() ;
	if (!m_ctrl_global_ip.GetCount() && !m_ctrl_mapping_details.GetCount())
	{
		m_ctrl_delete.EnableWindow (FALSE);		
		m_ctrl_add_map.EnableWindow (FALSE);
		m_ctrl_edit_map.EnableWindow (FALSE);
		m_ctrl_delete_map.EnableWindow (FALSE);
	}
	UpdateData (FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNATDlg::OnButtonAdd()
{
	// TODO: Add your control notification handler code here
	CString buf;
	UpdateData (TRUE);			
	if (ValidateAdd())
	{
		address_added = TRUE;		////This variable will be checked if the user 
											////quits from the dialog with cancel button
		m_ctrl_global_ip.AddString ( m_edit_global_addr1);
		m_edit_global_addr1.Empty();
		m_ctrl_delete.EnableWindow (TRUE);		
		m_ctrl_add_map.EnableWindow (TRUE);
		m_ctrl_edit_map.EnableWindow (TRUE);
	}
	UpdateData(FALSE);
}

void CNATDlg::OnButtonDelete()
{
	// TODO: Add your control notification handler code here
	char buf[16];
	m_ctrl_global_ip.GetText (m_ctrl_global_ip.GetCurSel(), buf);
	STATIC_MAP_STRUCT *static_entry;
	static_entry = static_start;
	while (static_entry != NULL)
	{////Check whether a mapping exists for this entry, if so return
		if (!strcmp (static_entry->global_addr, buf))
 		{
			ShowMessageBox (1);
			return;
		}
		static_entry = static_entry->ptr_to_next;
	}

	DYNAMIC_MAP_STRUCT *dyn_entry;
	dyn_entry = dyn_start;
	if (dyn_entry != NULL)
	{////Check whether a mapping exists for this entry, if so return
		if (!strcmp (dyn_entry->global_addr, buf))
 		{
			ShowMessageBox (1);
			return;
		}
	}
	m_ctrl_global_ip.DeleteString (m_ctrl_global_ip.GetCurSel());
	UpdateData (FALSE);
}

void CNATDlg::OnOK()
{
	// TODO: Add extra validation here
	AcceptConfig();
	free_memory();

	CDialog::OnOK();
}

void CNATDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	if (address_added)
	{
		int nRetVal = MessageBox ("Do you want to save the global address list?",
					(LPSTR)NATHeader, MB_YESNO | MB_ICONQUESTION) ;
		if (nRetVal == IDYES)
			save_global_list();
	}
	free_memory();	
	CDialog::OnCancel();
}

void CNATDlg::free_memory()
{////Free whatever memory was allocated
	STATIC_MAP_STRUCT *static_entry;
	static_entry = static_start;
	while (static_entry != NULL)
	{
		static_start = static_entry->ptr_to_next;
		free (static_entry);
		static_entry = static_start;
	}
	static_entry = static_entry_start;
	while (static_entry != NULL)
	{
		static_entry_start = static_entry->ptr_to_next;
		free (static_entry);
		static_entry = static_entry_start;
	}

	DYNAMIC_MAP_STRUCT *dyn_entry;
	dyn_entry = dyn_start;
	while (dyn_entry != NULL)
	{
		dyn_start = dyn_entry->ptr_to_next;
		free (dyn_entry);
		dyn_entry = dyn_start;
	}
	dyn_entry = dynamic_entry_start ;
	while (dyn_entry != NULL)
	{
		dynamic_entry_start = dyn_entry->ptr_to_next ;
		free (dyn_entry) ;
		dyn_entry = dynamic_entry_start ;
	}

}

void CNATDlg::OnAddMap()
{
	// TODO: Add your control notification handler code here
	madd = TRUE;
	medit = FALSE ; /* Jo 31/08/99 To handle ADD and EDIT cases properly */
	CNATMap natmap;
	natmap.DoModal();
}

void CNATDlg::OnEditMap()
{
	// TODO: Add your control notification handler code here
	if (m_ctrl_mapping_details.GetCurSel() != CB_ERR)
	{
		medit = TRUE;
		madd = FALSE ; /* Jo 31/08/99 To handle ADD and EDIT cases properly */
		CNATMap natmap (this);
		natmap.DoModal();
	}
}

void CNATDlg::OnDeleteMap()
{
	UpdateData (TRUE);
	// TODO: Add your control notification handler code here
	if (m_ctrl_mapping_details.GetCurSel() == CB_ERR)
		return;
	char buf[100];
	char temp_global_addr[16], temp_local_addr[16], temp_protocol[16];
	char temp_port[30];
	char *ch;
	m_ctrl_mapping_details.GetText (m_ctrl_mapping_details.GetCurSel(), buf);
	ch = strchr (buf, (int) '\t');
	*ch = '\0';
	if (!strcmp (buf, "S"))			////To delete a static map
	{
		strcpy (buf, ++ch);
		ch = strchr (buf, (int) '\t');
		*ch = '\0';
		STATIC_MAP_STRUCT *static_entry;
		STATIC_MAP_STRUCT *prev_entry;
		static_entry = static_start;
		prev_entry = static_start;
		while (static_entry != NULL)
		{
			if (!strcmp (static_entry->global_addr, buf))
				if (static_entry == static_start)
				{
					static_start = static_start->ptr_to_next;
					free (static_entry);
					break;
				}
				else
				{
					prev_entry->ptr_to_next = static_entry->ptr_to_next;
					free (static_entry);
					break;
				}
			prev_entry = static_entry;
			static_entry = static_entry->ptr_to_next;
		}
	}		 
	else					////Deleting Dynamic map
	{
		strcpy (buf, ++ch);
//		sscanf (buf, "%s\t%s\t%s\t%s", temp_global_addr, temp_local_addr,
//			 temp_protocol, temp_port);
  		for (int i = 0; i < 3; i++)
  		{
  			ch = strchr (buf, (int) '\t');
  			*ch = '\0';
  			if (i == 0)
  				strcpy (temp_global_addr, buf);
  			else if (i == 1)
  				strcpy (temp_local_addr, buf);
  			else if (i == 2)
  				strcpy (temp_protocol, buf);
  			strcpy (buf, ++ch);
  		}
		strcpy (temp_port, buf);				
		DYNAMIC_MAP_STRUCT *dyn_entry;
		DYNAMIC_MAP_STRUCT *prev_entry;
		dyn_entry = dyn_start;
		prev_entry = dyn_start;
		while (dyn_entry != NULL)
		{
			if (!strcmp (dyn_entry->local_addr, temp_local_addr))
				if (!strcmp (dyn_entry->protocol, temp_protocol))
					if (!strcmp (dyn_entry->port, temp_port))
					{
						if (dyn_entry == dyn_start)
						{
							dyn_start = dyn_entry->ptr_to_next;
							free (dyn_entry);
						}
						else
						{
							prev_entry->ptr_to_next = dyn_entry->ptr_to_next;
							free (dyn_entry);
						}
						if (dyn_start == NULL)
							strcpy (dyn_global_addr, "\0"); 
						break;
					}
			prev_entry = dyn_entry;
			dyn_entry = dyn_entry->ptr_to_next;
		}
	}
	m_ctrl_mapping_details.DeleteString (m_ctrl_mapping_details.GetCurSel());
	UpdateData (FALSE);
}

BOOL CNATDlg::ValidateAdd()
{////To validate whatever added is correct
	char addr_buf[16];
	if (m_edit_global_addr1.IsEmpty())
	{			////If the address is empty
		ShowMessageBox (2);
		m_ctrl_edit_global_addr1.SetFocus();
		return FALSE;
	}

/* Jo 07/04/99 Allow Global Zero IP Address */
	if (!m_edit_global_addr1.IsValidIfZero())
	{				////If address is not valid
		ShowMessageBox (3);
		m_ctrl_edit_global_addr1.SetFocus() ;
		return FALSE;
	}

	unsigned long addr1, addr2;
	strcpy (addr_buf, m_edit_global_addr1);
	get_ip_address (addr_buf, &addr1);
	for (int index = 0; index < m_ctrl_global_ip.GetCount(); index++)
	{ ////Check whether the address entered already exists
		m_ctrl_global_ip.GetText (index, addr_buf);
		get_ip_address (addr_buf, &addr2);				
		if (addr1 == addr2)
		{
			ShowMessageBox (4);
			m_ctrl_edit_global_addr1.SetFocus() ;
			return FALSE;
		}
	}

	return TRUE;
}

/* Jo */
void CNATDlg::GetConfig()
{
	char rhsbuf[50], temp_protocol[20], temp_port[30], temp_addr[16] ;
	int i, index = 0 ;
	ULONG offset, return_offset ;
	USHORT number_of_entries ;
	CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr ;
	CNF_PROXY_ADDRESS_INFO *proxy_global_address_ptr ;
	CNF_PROXY_STATIC_INFO *proxy_static_entry_ptr ;  	
	CNF_PROXY_DYNAMIC_INFO *proxy_dynamic_entry_ptr ;

	m_ctrl_global_ip.ResetContent();

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_virtual_entry (&offset) ;
	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
	number_of_entries = proxy_virtual_ptr->number_of_global_address_entries ;

   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 0) ;
	proxy_global_address_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

	for (i = 0; i < number_of_entries; i++)
	{
		get_dot_decimal_ip_address (proxy_global_address_ptr->address, rhsbuf) ;
	   m_ctrl_global_ip.AddString (rhsbuf);
	   proxy_global_address_ptr++ ;
	}

	number_of_entries = proxy_virtual_ptr->number_of_static_mapping_entries ;

  	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 1) ;
	proxy_static_entry_ptr = (CNF_PROXY_STATIC_INFO *) return_offset ;

	for (i = 0; i < number_of_entries; i++)
	{
	      STATIC_MAP_STRUCT *static_entry ;
	      if ((static_entry = (STATIC_MAP_STRUCT *) malloc (sizeof (STATIC_MAP_STRUCT))) == NULL)
	      {
	      	   ShowMessageBox (0) ;
	      	   return ;
	      }		
         get_dot_decimal_ip_address (proxy_static_entry_ptr->global_address, static_entry->global_addr) ;
         get_dot_decimal_ip_address (proxy_static_entry_ptr->local_address, static_entry->local_addr) ;
	      wsprintf (rhsbuf, "S\t%s\t%s", static_entry->global_addr, static_entry->local_addr) ;
	      m_ctrl_mapping_details.AddString (rhsbuf);
	      static_entry->ptr_to_next = static_start ;
	      static_start = static_entry ;
	      proxy_static_entry_ptr++ ;
	}

	number_of_entries = proxy_virtual_ptr->number_of_dynamic_mapping_entries ;

	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 2) ;
	proxy_dynamic_entry_ptr = (CNF_PROXY_DYNAMIC_INFO *) return_offset ;

	for (i = 0; i < number_of_entries; i++)
	{
		DYNAMIC_MAP_STRUCT *dyn_entry ;
		if ((dyn_entry = (DYNAMIC_MAP_STRUCT *) malloc (sizeof (DYNAMIC_MAP_STRUCT))) == NULL)
		{
			ShowMessageBox (0) ;
			return ;
		}
      get_dot_decimal_ip_address (proxy_dynamic_entry_ptr->local_address, dyn_entry->local_addr) ;
		
		sprintf((LPSTR)temp_protocol, "%05u", proxy_dynamic_entry_ptr->protocol) ;			
		GetProtocolName (dyn_entry->protocol, temp_protocol) ;	
		sprintf((LPSTR)temp_port, "%05u", proxy_dynamic_entry_ptr->port) ;			
		GetPortName (dyn_entry->port, temp_port, dyn_entry->protocol) ;

		if ((dyn_start != NULL) && (!strcmp (dyn_entry->port, dyn_start->port)))
		{
			//Bugfix, if protocols are different, then don't go inside if condition
			if (!strcmp (dyn_entry->protocol, dyn_start->protocol))
			{				
				////This is for checking ports with more than one port numbers.
				////They shouldn't be repeated in the list box.
				proxy_dynamic_entry_ptr++ ;
				free (dyn_entry) ;
				continue ;

			}
		}

      get_dot_decimal_ip_address (proxy_virtual_ptr->dynamic_mapping_global_address, temp_addr) ;
		wsprintf (rhsbuf, "D\t%s\t%s\t%s\t%s", temp_addr, dyn_entry->local_addr,
				dyn_entry->protocol, dyn_entry->port) ;
		m_ctrl_mapping_details.AddString (rhsbuf) ;

		strcpy (dyn_entry->global_addr, temp_addr) ;
		dyn_entry->ptr_to_next = dyn_start ;
		dyn_start = dyn_entry ;
		proxy_dynamic_entry_ptr++ ;
	}
}

/* Jo */

void CNATDlg::AcceptConfig()
{
	if (!UpdateData (TRUE))
		return ;
	int index, static_maps = 0, dyn_maps = 0, static_prefix_num = 0, dyn_prefix_num = 0 ;
	int count = 0 ;
	char *templhs, *temprhs, *ch ;
	char temp_local_addr[16], temp_protocol[5], temp_port[20] ;
	STATIC_MAP_STRUCT *static_entry ;
	DYNAMIC_MAP_STRUCT *dynamic_entry ;

	if ((templhs = (char *) malloc (128)) == NULL)
	{
		ShowMessageBox (0);
		return;
	}		
	if ((temprhs = (char *) malloc (128)) == NULL)
	{
		ShowMessageBox (0);
		return;
	}		

	save_global_list() ;

	for (index = 0; index < m_ctrl_mapping_details.GetCount(); index++)
	{
		m_ctrl_mapping_details.GetText (index, temprhs) ;
		ch = strchr (temprhs, (int) '\t') ;
		*ch = '\0' ;
		if (!strcmp (temprhs, "S"))
		{
			static_maps++ ;		////Stores the number of static mappings
     		if ((static_entry = (STATIC_MAP_STRUCT *) malloc (sizeof (STATIC_MAP_STRUCT))) == NULL)
     		{
  	   		ShowMessageBox (0) ;
  	   		return ;
     		}		
			strcpy (temprhs, ++ch) ;
			sscanf (temprhs, "%s\t%s", static_entry->global_addr, static_entry->local_addr) ;
			static_entry->ptr_to_next = static_entry_start ;
			static_entry_start = static_entry ;
		}
		else
		{
			strcpy (temprhs, ++ch) ;
			for (int i = 0; i < 3; i++)
			{
				ch = strchr (temprhs, (int) '\t') ;
				*ch = '\0' ;				 
/* Jo 31/08/99 To store Proper Global Addr for Dynamic mappings */
				if (i == 0)
					strcpy (dyn_global_addr, temprhs) ;
/* Jo 31/08/99 To store Proper Global Addr for Dynamic mappings */
				if (i == 1)
					strcpy (temp_local_addr, temprhs) ;
				if (i == 2)
					strcpy (temp_protocol, temprhs) ;
				strcpy (temprhs, ++ch) ;
			}

			strcpy (temp_port, temprhs) ;
			int ports = GetNumberOfPorts (temp_port, temp_protocol);
			for (i = 1; i <= ports; i++)
			{  ////If more than one port number, they have to be written as separate entries

			     dyn_maps++ ;
			     if ((dynamic_entry = (DYNAMIC_MAP_STRUCT *) malloc (sizeof (DYNAMIC_MAP_STRUCT))) == NULL)
			     {
			         ShowMessageBox (0) ;
						return ;
			     }		

			     strcpy (dynamic_entry->local_addr, temp_local_addr) ;
			     GetProtocolNumber (dynamic_entry->protocol, temp_protocol) ;
			     GetPortNumber (dynamic_entry->port, temp_port, temp_protocol, i) ; 
			     dynamic_entry->ptr_to_next = dynamic_entry_start ;
			     dynamic_entry_start = dynamic_entry ;
			}
		}
	}
	add_proxy_static_mapping (static_entry_start, static_maps) ;
	add_proxy_dynamic_mapping (dynamic_entry_start, dyn_global_addr, dyn_maps) ;
	free_memory () ; 
	free (temprhs);
	free (templhs);
}

/* Jo */

void CNATDlg::save_global_list()
{
   int index, static_prefix_num = 0;
   int count = 0;
   char tempbuf[128] ;
   ULONG offset, return_offset, int_ip_addr ;
   USHORT temp_number_of_entries ;
   CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr ;
   CNF_PROXY_ADDRESS_INFO *proxy_global_address_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_virtual_entry (&offset) ;
   proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
   temp_number_of_entries = proxy_virtual_ptr->number_of_global_address_entries ;

   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 0) ;
   proxy_global_address_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

   proxy_virtual_ptr->number_of_global_address_entries = m_ctrl_global_ip.GetCount() ;

   if (temp_number_of_entries < proxy_virtual_ptr->number_of_global_address_entries)
   {
   	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(ULONG) * (proxy_virtual_ptr->number_of_global_address_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_virtual_entry (&offset) ;
   	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
   	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 0) ;
   	proxy_global_address_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

		return_offset += (temp_number_of_entries * sizeof(ULONG)) ;

		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset - 
			(sizeof(ULONG) * (proxy_virtual_ptr->number_of_global_address_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (return_offset + ((proxy_virtual_ptr->number_of_global_address_entries - temp_number_of_entries) * sizeof(ULONG))) ;
		memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
   }
   else
   {
     if (temp_number_of_entries > proxy_virtual_ptr->number_of_global_address_entries)
     {
		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_virtual_entry (&offset) ;
   	proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
   	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 0) ;
   	proxy_global_address_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

		return_offset += (temp_number_of_entries * sizeof(ULONG)) ;

   	ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset) ;
   	ULONG dst_offset = (ULONG) (return_offset - ((temp_number_of_entries - proxy_virtual_ptr->number_of_global_address_entries) * sizeof(ULONG))) ;
   	_fmemmove ((void FAR *) dst_offset, (void FAR *) return_offset, (int) SizeToMove) ;

	  	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(ULONG) * (proxy_virtual_ptr->number_of_global_address_entries - temp_number_of_entries))) ;
   	all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
   	all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   	all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
   	proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
   	proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

     }
   }

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_virtual_entry (&offset) ;
   proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 0) ;
   proxy_global_address_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

   for (index = 0; index < proxy_virtual_ptr->number_of_global_address_entries; index++)
   {
   	m_ctrl_global_ip.GetText (index, tempbuf);		
		get_ip_address (tempbuf, &int_ip_addr) ;
		proxy_global_address_ptr->address = int_ip_addr ;
		proxy_global_address_ptr++ ;
   }
}



void CNATDlg::ShowMessageBox (int index)
{
	::MessageBox (GetSafeHwnd(), ErrorMessage[index], (LPSTR)NATHeader, MB_OK|MB_ICONEXCLAMATION);
	return;
}

void CNATDlg::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp(0x20000 + IDD_NAT_SETUP,HELP_CONTEXT);
}

/////////////////////////////////////////////////////////////////////////////
// CNATMap dialog


CNATMap::CNATMap(CWnd* pParent /*=NULL*/)
	: CDialog(CNATMap::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNATMap)
	m_global_address = "";
	m_local_address = "";
	m_protocol = "";
	m_port = "";
	//}}AFX_DATA_INIT
	mappings = 0;
}

void CNATMap::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNATMap)
	DDX_Control(pDX, IDC_EDIT_LOCAL_ADDR, m_ctrl_local_address);
	DDX_Control(pDX, IDC_COMBO_PORT, m_ctrl_combo_port);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_ctrl_combo_protocol);
	DDX_Control(pDX, IDC_STATIC_PORT, m_ctrl_static_port);
	DDX_Control(pDX, IDC_STATIC_PROTOCOL, m_ctrl_static_protocol);
	DDX_Control(pDX, IDC_LIST_GLOBAL_IP_ADDR, m_ctrl_global_address);
	DDX_Control(pDX, IDC_RADIO_STATIC, m_ctrl_radio_static);
	DDX_Control(pDX, IDC_RADIO_DYNAMIC, m_ctrl_radio_dynamic);
	DDX_LBString(pDX, IDC_LIST_GLOBAL_IP_ADDR, m_global_address);
	DDX_Text(pDX, IDC_EDIT_LOCAL_ADDR, m_local_address);
	DDX_CBString(pDX, IDC_COMBO_PROTOCOL, m_protocol);
	DDX_CBString(pDX, IDC_COMBO_PORT, m_port);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNATMap, CDialog)
	//{{AFX_MSG_MAP(CNATMap)
	ON_BN_CLICKED(IDC_BUTTON_MAP, OnButtonMap)
	ON_BN_CLICKED(IDC_RADIO_STATIC, OnRadioStatic)
	ON_BN_CLICKED(IDC_RADIO_DYNAMIC, OnRadioDynamic)
	ON_CBN_SELCHANGE(IDC_COMBO_PROTOCOL, OnSelchangeComboProtocol)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CNATMap message handlers

void CNATMap::OnOK()
{
	// TODO: Add extra validation here
	UpdateData (TRUE);
	if (!m_local_address.IsEmpty())
	{		////If the user presses Ok without pressing the map btn for the current
			////entry added, this message box will be displayed
		int nRetVal = MessageBox ("Do you want to save the mapping?",
					(LPSTR)NATHeader, MB_YESNO | MB_ICONQUESTION) ;
		if (nRetVal == IDYES)
			OnButtonMap();
	}
	PutMappingInParentList();
	CDialog::OnOK();
}

void CNATMap::OnButtonMap()
{
	// TODO: Add your control notification handler code here
	char port_buf[50];
	if (ValidateMapping())
	{
		if (madd)		////If the mapping has to be done for a new entry
		{
			mappings++;
			if (m_ctrl_radio_static.GetCheck())				////If it's a static mapping
			{
				static_map_added = TRUE;
				STATIC_MAP_STRUCT *static_entry;
				if ((static_entry = (STATIC_MAP_STRUCT *) malloc (sizeof (STATIC_MAP_STRUCT))) == NULL)
				{
					ShowMessageBox (0);
					return;
				}		

				strcpy (static_entry->global_addr, m_global_address);
				strcpy (static_entry->local_addr, m_local_address);
				static_entry->ptr_to_next = static_start;
				static_start = static_entry;
				m_ctrl_global_address.DeleteString (m_ctrl_global_address.GetCurSel());
			}		
			else					////If it's a dynamic mapping entry
			{
				dynamic_map_added = TRUE;
				DYNAMIC_MAP_STRUCT *dyn_entry;
				if ((dyn_entry = (DYNAMIC_MAP_STRUCT *) malloc (sizeof (DYNAMIC_MAP_STRUCT))) == NULL)
				{
					ShowMessageBox (0);
					return;
				}		
				strcpy (dyn_entry->global_addr, m_global_address);
				strcpy (dyn_entry->local_addr, m_local_address);
				strcpy (dyn_entry->protocol, m_protocol);
				if (m_ctrl_combo_port.FindString (0, m_port) == CB_ERR)
				{////If it's an user defined port
					strcpy (port_buf, m_port);
					PadWithZeroes (dyn_entry->port, port_buf, 4);
				}
				else 
					strcpy (dyn_entry->port, m_port);
				strcpy (dyn_global_addr, dyn_entry->global_addr) ;
				dyn_entry->ptr_to_next = dyn_start;
				dyn_start = dyn_entry ;
				m_ctrl_global_address.ResetContent();
				m_ctrl_global_address.AddString (dyn_entry->global_addr);
			}		
		}
		else			////If the mapping for a given entry has been changed
		{
			if (m_ctrl_radio_static.GetCheck())
			{
				STATIC_MAP_STRUCT *static_entry;
				static_entry = static_start;
				while (static_entry != NULL)
				{
					if (!strcmp (static_entry->global_addr, m_global_address))
					{
						strcpy (static_entry->local_addr, m_local_address);
					 	break;
					}
					else
						static_entry = static_entry->ptr_to_next;
				}
			}
			else
			{
				DYNAMIC_MAP_STRUCT *dyn_entry;
				dyn_entry = dyn_start;
				while (dyn_entry != NULL)
				{
					if (!strcmp (dyn_entry->local_addr, edit_lo_addr))
						if (!strcmp (dyn_entry->protocol, edit_protocol))
							if (!strcmp (dyn_entry->port, edit_port))
							{
								strcpy (dyn_entry->local_addr, m_local_address);
								strcpy (dyn_entry->protocol, m_protocol);
								strcpy (dyn_entry->port, m_port);
							 	break;
							}
							dyn_entry = dyn_entry->ptr_to_next;
				}
			}
		}
		m_ctrl_global_address.SetCurSel (0);
		m_local_address.Empty();
		UpdateData (FALSE);
	}
}

BOOL CNATMap::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!MapBmpBtn.LoadBitmaps ("MAP1", "MAP2", "MAP3", "MAP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (MapBmpBtn.SubclassDlgItem (IDC_BUTTON_MAP, this));
	MapBmpBtn.SizeToContent();

	SetWindowText (WindowHeader) ;
	// TODO: Add extra initialization here
	m_ctrl_global_address.ResetContent();
	BOOL entry_in_list = FALSE;
	if (madd)			////If the dialog has come up after pressing Add button
	{
		CString Buf;
		int index = 0;
		CNATDlg *pParent = (CNATDlg *) GetParent();
		STATIC_MAP_STRUCT *static_entry;
		for (index = 0; index < pParent->m_ctrl_global_ip.GetCount(); index++)
		{
			pParent->m_ctrl_global_ip.GetText (index, Buf);
			if (!strcmp (Buf, dyn_global_addr))
				entry_in_list = TRUE;
			if (!entry_in_list)
			{
				static_entry = static_start;
				while (static_entry != NULL)
				{
					if (!strcmp (static_entry->global_addr, Buf))
					{
						entry_in_list = TRUE;
						break;
					}
					static_entry = static_entry->ptr_to_next;
				}		
			}
			if (!entry_in_list)
				m_ctrl_global_address.AddString (Buf);
			entry_in_list = FALSE;
		}
		m_ctrl_global_address.SetCurSel (0);
		for (index = 0; index < 2; index++)
			m_ctrl_combo_protocol.AddString (ProtocolNameNumberMap[index].Name);
		m_protocol = ProtocolNameNumberMap[0].Name;
		index = 0;
		while (TCPPortStrings[index].Name != NULL)
		{
			m_ctrl_combo_port.AddString (TCPPortStrings[index].Name);
			index++;
		}
		m_ctrl_radio_static.SetCheck(1);
		m_ctrl_radio_dynamic.SetCheck(0);
		m_ctrl_static_protocol.EnableWindow (FALSE);
		m_ctrl_static_port.EnableWindow (FALSE);
		m_ctrl_combo_protocol.EnableWindow (FALSE);
		m_ctrl_combo_port.EnableWindow (FALSE);
	}
/* Jo 31/08/99 To handle ADD and EDIT cases properly */
	else if (medit)	////If the dialog has come up for editing an existing mapping
		  {
				m_ctrl_radio_static.EnableWindow (FALSE);
				m_ctrl_radio_dynamic.EnableWindow (FALSE);
				for (int index = 0; index < 2; index++)
					m_ctrl_combo_protocol.AddString (ProtocolNameNumberMap[index].Name);
		
				char buf[100];
				char *ch;
				CNATDlg *pParent = (CNATDlg *) GetParent();
				pParent->m_ctrl_mapping_details.GetText (pParent->m_ctrl_mapping_details.GetCurSel(), buf);
				ch = strchr (buf, (int) '\t');
				*ch = '\0';
				if (!strcmp (buf, "S"))
				{
					m_ctrl_radio_static.SetCheck(1);
					m_ctrl_radio_dynamic.SetCheck(0);
					m_ctrl_static_protocol.EnableWindow (FALSE);
					m_ctrl_static_port.EnableWindow (FALSE);
					m_ctrl_combo_protocol.EnableWindow (FALSE);
					m_ctrl_combo_port.EnableWindow (FALSE);
					strcpy (buf, ++ch);
					ch = strchr (buf, (int) '\t');
					*ch = '\0';
					m_ctrl_global_address.AddString (buf);
					m_local_address = ++ch;
				}		
				else
				{
					strcpy (buf, ++ch);
					for (int i = 0; i < 3; i++)
					{////This is done for changing the items in the link list after finishing
						ch = strchr (buf, (int) '\t');
						*ch = '\0';
						if (i == 0)
							strcpy (edit_gl_addr, buf);
						else if (i == 1)
							strcpy (edit_lo_addr, buf);
						else if (i == 2)
							strcpy (edit_protocol, buf);
						strcpy (buf, ++ch);
					}
					strcpy (edit_port, buf);
					m_ctrl_radio_dynamic.SetCheck(1);
					m_ctrl_radio_static.SetCheck(0);
					m_ctrl_global_address.AddString (edit_gl_addr);
					m_local_address = edit_lo_addr;
					m_protocol = edit_protocol;
					int index = 0;
					if (!strcmp (edit_protocol, ProtocolNameNumberMap[0].Name))
					{
						while (TCPPortStrings[index].Name != NULL)
						{
							m_ctrl_combo_port.AddString (TCPPortStrings[index].Name);
							index++;
						}		
					}
					else
					{
						while (UDPPortStrings[index].Name != NULL)
						{
							m_ctrl_combo_port.AddString (UDPPortStrings[index].Name);
							index++;
						}
					}
					m_port = edit_port;
				}
				m_ctrl_global_address.SetCurSel (0);
			}
	CenterWindow();
	UpdateData (FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNATMap::OnRadioStatic()
{
	// TODO: Add your control notification handler code here
	BOOL entry_in_list = FALSE;
	char Buf[16];
	if (m_ctrl_radio_static.GetCheck())
	{
		m_ctrl_global_address.ResetContent();
		CNATDlg *pParent = (CNATDlg *) GetParent();
		STATIC_MAP_STRUCT *static_entry;
		for (int index = 0; index < pParent->m_ctrl_global_ip.GetCount(); index++)
		{
			pParent->m_ctrl_global_ip.GetText (index, Buf);
			if (!strcmp (Buf, dyn_global_addr))
				entry_in_list = TRUE;
			if (!entry_in_list)
			{
				static_entry = static_start;
				while (static_entry != NULL)
				{
					if (!strcmp (static_entry->global_addr, Buf))
					{
						entry_in_list = TRUE;
						break;
					}
					static_entry = static_entry->ptr_to_next;
				}
			}
			if (!entry_in_list)
				m_ctrl_global_address.AddString (Buf);
			entry_in_list = FALSE;
		}
		m_ctrl_static_protocol.EnableWindow (FALSE);
		m_ctrl_static_port.EnableWindow (FALSE);
		m_ctrl_combo_protocol.EnableWindow (FALSE);
		m_ctrl_combo_port.EnableWindow (FALSE);
	}
	else
	{
		m_ctrl_static_protocol.EnableWindow (TRUE);
		m_ctrl_static_port.EnableWindow (TRUE);
		m_ctrl_combo_protocol.EnableWindow (TRUE);
		m_ctrl_combo_port.EnableWindow (TRUE);
	}
	m_ctrl_global_address.SetCurSel (0);
	UpdateData (FALSE);
}

void CNATMap::OnRadioDynamic()
{
	// TODO: Add your control notification handler code here
	char Buf[16];
	BOOL entry_in_list = FALSE;
	if (m_ctrl_radio_dynamic.GetCheck())
	{
		m_ctrl_global_address.ResetContent();
		if (dyn_start != NULL)
		{
			m_ctrl_global_address.AddString (dyn_start->global_addr);
		}
		else
		{
			CNATDlg *pParent = (CNATDlg *) GetParent();
			for (int index = 0; index < pParent->m_ctrl_global_ip.GetCount(); index++)
			{
				pParent->m_ctrl_global_ip.GetText (index, Buf);
				STATIC_MAP_STRUCT *static_entry;
				static_entry = static_start;
				while (static_entry != NULL)
				{
					if (!strcmp (static_entry->global_addr, Buf))
					{
						entry_in_list = TRUE;
						break;
					}
					static_entry = static_entry->ptr_to_next;
				}
				if (!entry_in_list)
					m_ctrl_global_address.AddString (Buf);
				entry_in_list = FALSE;
			}
		}
		m_ctrl_static_protocol.EnableWindow (TRUE);
		m_ctrl_static_port.EnableWindow (TRUE);
		m_ctrl_combo_protocol.EnableWindow (TRUE);
		m_ctrl_combo_port.EnableWindow (TRUE);
	}
	else
	{
		m_ctrl_static_protocol.EnableWindow (FALSE);
		m_ctrl_static_port.EnableWindow (FALSE);
		m_ctrl_combo_protocol.EnableWindow (FALSE);
		m_ctrl_combo_port.EnableWindow (FALSE);
	}
	m_ctrl_global_address.SetCurSel (0);
	UpdateData (FALSE);
}

BOOL CNATMap::ValidateMapping()
{
	UpdateData (TRUE);
	char buf[16];
	int index;
	unsigned long addr1, addr2;
	if (m_ctrl_global_address.GetCurSel() == LB_ERR)
	{	
		ShowMessageBox (5);
		return FALSE;
	}
	if (m_local_address.IsEmpty())
	{	
		ShowMessageBox (6);
		m_ctrl_local_address.SetFocus();
		return FALSE;
	}
	if (!m_local_address.IsValid())
	{	
		ShowMessageBox (7);
		m_ctrl_local_address.SetFocus();
		return FALSE;
	}

	if (m_ctrl_radio_dynamic.GetCheck())
	{
		DYNAMIC_MAP_STRUCT *dyn_entry;
		dyn_entry = dyn_start;
		m_ctrl_global_address.GetText (m_ctrl_global_address.GetCurSel(), buf);
		if (dyn_entry != NULL)
		{
			if (strcmp (dyn_entry->global_addr, buf)) 
			{
				::MessageBox (GetSafeHwnd(), "Selected global address is different from the previous one", NATHeader, MB_OK);
				return FALSE;
			}
		}
		if (m_ctrl_combo_protocol.GetCurSel() == LB_ERR)		
		{	
			ShowMessageBox (8);
			m_ctrl_combo_protocol.SetFocus();
			return FALSE;
		}
		if (m_port.IsEmpty())
		{	
			ShowMessageBox (9);
			m_ctrl_combo_port.SetFocus();
			return FALSE;
		}
		char pr_buf[6], port_buf1[6], port_buf2[50];
		strcpy (pr_buf, m_protocol);
		if (m_ctrl_combo_port.FindString (0, m_port) == CB_ERR)
		{////Check the user-defined port is not equal to the default ones
			strcpy (buf, m_port);
			PadWithZeroes (port_buf1, buf, 5);
			for (index = 0; index < m_ctrl_combo_port.GetCount(); index++)
			{
				m_ctrl_combo_port.GetLBText (index, port_buf2);
				int ports = GetNumberOfPorts (port_buf2, pr_buf);
				for (int i = 1; i <= ports; i++)
				{
					GetPortNumber (buf, port_buf2, pr_buf, i);
					if (!strcmp (buf, port_buf1))
					{
						ShowMessageBox (10);
						m_ctrl_combo_port.SetFocus();
						return FALSE;
					}
				}
			}
		}
		////Check the local address,protocol,port triplet is unique
		char port_buf[50], buf[50];
		dyn_entry = dyn_start;
		while (dyn_entry != NULL)
		{
			if (!strcmp (dyn_entry->protocol, m_protocol))
			{
				if (m_ctrl_combo_port.FindString (0, m_port) == CB_ERR)
				{
					strcpy (buf, m_port);
					PadWithZeroes (port_buf, buf, 4);
				}
				else
					strcpy (port_buf, m_port);
				if (!strcmp (dyn_entry->port, port_buf))
				{
					if (medit)
					{
						strcpy (buf, m_local_address);
						get_ip_address (buf, &addr1);
						get_ip_address (dyn_entry->local_addr, &addr2);
//						if (!strcmp (buf, dyn_entry->local_addr))
						if (addr1 == addr2)
						{
							ShowMessageBox (13);
							return FALSE;
						}
					}
					else
					{
						ShowMessageBox (11);
						return FALSE;
					}
				}
			}
			dyn_entry = dyn_entry->ptr_to_next;
		}
	}
	UpdateData (FALSE);
	return TRUE;
}

void CNATMap::OnSelchangeComboProtocol()
{
	// TODO: Add your control notification handler code here
	////The ports list differs for different protocols, so load the corresponding entries
	UpdateData (TRUE);
	int index = 0;
	if (!strcmp (m_protocol, ProtocolNameNumberMap[0].Name))
	{
		m_ctrl_combo_port.ResetContent();
		while (TCPPortStrings[index].Name != NULL)
		{
			m_ctrl_combo_port.AddString (TCPPortStrings[index].Name);
			index++;
		}
	}
	else
	{
		m_ctrl_combo_port.ResetContent();
		while (UDPPortStrings[index].Name != NULL)
		{
			m_ctrl_combo_port.AddString (UDPPortStrings[index].Name);
			index++;
		}
	}
}

void CNATMap::OnCancel()
{
	// TODO: Add extra cleanup here
	if (static_map_added || dynamic_map_added)
	{
		ShowMessageBox (12);
		PutMappingInParentList();
	}
	CDialog::OnCancel();
}

void CNATMap::PutMappingInParentList()
{
	char listbuf[200];
	char buf[10];
	CNATDlg *pParent = (CNATDlg *) GetParent();
	pParent->m_ctrl_mapping_details.ResetContent();
	STATIC_MAP_STRUCT *static_entry;
	static_entry = static_start;
	while (static_entry != NULL)
	{
		wsprintf (listbuf, "S\t%s\t%s", static_entry->global_addr, static_entry->local_addr);		
		pParent->m_ctrl_mapping_details.AddString(listbuf);
		static_entry = static_entry->ptr_to_next;
	}
	DYNAMIC_MAP_STRUCT *dyn_entry;
	dyn_entry = dyn_start;
	while (dyn_entry != NULL)
	{
 		wsprintf (listbuf, "D\t%s\t%s\t%s\t", dyn_entry->global_addr, 
				dyn_entry->local_addr, dyn_entry->protocol);		
		if ((medit && m_ctrl_radio_dynamic.GetCheck()) || madd)
		{ 
			if (m_ctrl_combo_port.FindString (0, dyn_entry->port) == CB_ERR)
			{
				PadWithZeroes (buf, dyn_entry->port, 4);
				strcat (listbuf, buf);
			}
			else
				strcat (listbuf, dyn_entry->port);	 
		}
		else
			strcat (listbuf, dyn_entry->port);	 
		pParent->m_ctrl_mapping_details.AddString(listbuf);
		dyn_entry = dyn_entry->ptr_to_next;
	}
	pParent->m_ctrl_delete_map.EnableWindow (TRUE);
	pParent->UpdateData (FALSE);
	madd = FALSE;
	medit = FALSE;
}

void CNATMap::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp(0x20000 + IDD_NAT_MAPPING,HELP_CONTEXT);
}

void CNATMap::ShowMessageBox (int index)
{
	::MessageBox (GetSafeHwnd(), ErrorMessage[index], (LPSTR)NATHeader, MB_OK|MB_ICONEXCLAMATION);
	return;
}
