/// -------------------------------------------------------------------------
// Project Name                 :   MultiRouter Setup for Windows 
// File Name                    :   PORTSTAT.CPP
// Description                  :   Defines the functions of statistics button
// Start Date                   :   23rd Sept 1997
// Author                   	  :   Sudha
// Date Last Modified   		  :   16 Nov 1999
// Modifications                : 	Jo 26 Oct 1999 Modified Global var port_status_desc[]
//												to display proper statistics.
//										  :	Jo 16 Nov 1999 Introduced one more message string for DialIn Port Type 
//												in Global var port_status_desc[].
/// -------------------------------------------------------------------------

// portstat.cpp : implementation file
//


#include "stdafx.h"
#include "procon.h"
#include "portstat.h"
#include "boot.h"
#include "paramtr.h"
#include "maindlg.h"
#include "portinfo.h"
#include "tftpread.h"
#include "logview.h"
#include "waitdlg.h"

#if PROXY_SERVER
#include	"tftpif.h"
extern void far *malloc (int) ;
extern void free (void far *) ;
#endif

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/* Sachin, 27/10/1997 */

unsigned long SwapDWord (unsigned long) ;
unsigned short SwapWord (unsigned short) ;
void modify_port_info (PortStatusInfo *) ;

extern void *malloc (int) ;

#if PROXY_SERVER
#define PORT_STATUS_FILE "PORTSTAT.ONL"
#define	TFTP_READ_TIMER_ID			10			// timer id for ftp_read
#define	TFTP_55_MS_TIMER_ID			20
#define	TFTP_READ_TIMER_PERIOD	1000		// one second timer
#endif

#define ReadLogTimerID 3
#define OPEN_LOG_TIMER_PERIOD  3000
#define READ_LOG_TIMER_PERIOD  6000

/* ...Modified by Jo on 26 Oct 1999 */
char *port_status_desc[] =
{
	"Idle",
	"Off-line",
	"WAN link up",
	"LCP up",
	"Internet connect(PPP)",
	"Internet connect(MLPPP)",
	"Initializing modem",
	"Waiting for OK",
	"Dialing number",
	"Waiting connect message",
	"SLIP client up",
	"Disabled",
	"Callback in progress",
	"RAS client connected",
	"Waiting call/demand",			/* if dod_down and ras enabled */
/* Jo 16 Nov 1999. New Message string if Port Type is Dialin only and RAS is enabled */
	"Waiting call",			
	"Hangup in progress",
	"Down By No Demand"
} ;

/* Modified by Jo on 26 Oct 1999... */
/* Sachin, 27/10/1997 */



#define GET_STATUS 0 
#define GET_INFO 1 
#define START_PORT 0
#define MAJOR_VERSION 2
#define MINOR_VERSION 2
#define PORT_STATUS_TIMER_ID 120

FILE *port ;

/////////////////////////////////////////////////////////////////////////////
// CPortStat dialog


CPortStat::CPortStat(CWnd* pParent /*=NULL*/)
	: CDialog(CPortStat::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPortStat)
	m_ListportStatWnd = "";
	m_UpTime = "";
	m_Calls = "";
	m_PktRcv = "";
	m_PktSnt = "";
	m_BytRcv = "";
	m_BytSnt = "";
	m_sys_uptime = "";
	//}}AFX_DATA_INIT
}

void CPortStat::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPortStat)
	DDX_Control(pDX, IDC_PORT_STATUS_LIST, m_ListPortStatWndControl);
	DDX_LBString(pDX, IDC_PORT_STATUS_LIST, m_ListportStatWnd);
	DDX_Text(pDX, IDC_STATIC_UP_TIME, m_UpTime);
	DDX_Text(pDX, IDC_STATIC_CALLS, m_Calls);
	DDX_Text(pDX, IDC_STATIC_PKTRCV, m_PktRcv);
	DDX_Text(pDX, IDC_STATIC_PKTSNT, m_PktSnt);
	DDX_Text(pDX, IDC_STATIC_BYTRCV, m_BytRcv);
	DDX_Text(pDX, IDC_STATIC_BYTSNT, m_BytSnt);
	DDX_Text(pDX, IDC_STATIC_SYS_UP_TIME, m_sys_uptime);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPortStat, CDialog)
	//{{AFX_MSG_MAP(CPortStat)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnButtonHelp)
	ON_WM_TIMER()
	ON_LBN_DBLCLK(IDC_PORT_STATUS_LIST, OnDblclkList1PortStat)
	ON_BN_CLICKED(IDC_BUTTON_DETAILS, OnButtonDetails)
	ON_MESSAGE(WM_TFTP, OnTFTPReadCallBack)
	ON_BN_CLICKED(IDC_BUTTON_LOGVIEW, OnButtonLogview)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPortStat message handlers
// -------------------------------------------------------------------------
// Function             :	CPortStat::OnInitDialog.
// Arguments            :  None.
// Synopsis             :  Initialilzes the port statistics dialog box.
// Returns              :  TRUE.
// Globals Affected     :  None.
// -------------------------------------------------------------------------

BOOL CPortStat::OnInitDialog()
{
   int tabStops[] = {25, 120, 120, 120} ;
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDCANCEL, this));
	OKBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_BUTTON_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!DetailsBmpBtn.LoadBitmaps ("DETAILS1", "DETAILS2", "DETAILS3", "DETAILS4"))
		AfxMessageBox ("Failed to load DETAILS bitmap");

	VERIFY (DetailsBmpBtn.SubclassDlgItem (IDC_BUTTON_DETAILS, this));
	DetailsBmpBtn.SizeToContent();

	if (!LogBmpBtn.LoadBitmaps ("LOG1", "LOG2", "LOG3", "LOG4"))
		AfxMessageBox ("Failed to load Log View bitmap");

	VERIFY (LogBmpBtn.SubclassDlgItem (IDC_BUTTON_LOGVIEW, this));
	LogBmpBtn.SizeToContent();
	m_tftp_log_request_made = FALSE;

#if PROXY_SERVER
	int i ;
	unsigned long UpdatePeriod ;
	PortStatusInfo *ptr_PortInformation ;

	_fmemset (&PortInformation[0][0], 0, sizeof (PortInformation)) ;
	for (i = 0 ; i < NUMBER_OF_PROXY_PORTS ; i++)
	{
		ptr_PortInformation = (PortStatusInfo *) &PortInformation[i][0] ;
		ptr_PortInformation->port_number = i ;
	}
#endif

	CDialog::OnInitDialog();
	reenter_flag = 0 ;
	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
	    SubHeadingPointer = CurrentHeading ;
	else
	    SubHeadingPointer += 2 ;

#if PROXY_SERVER
	/* Change it later to get the number of ports from the ini file */
	if (IsPortIP)
	{
		port_status_ram_file = (char far *) malloc (TFTP_HEADER_SIZE + sizeof (PortStatusResp)) ;
		if (port_status_ram_file == NULL)
			CDialog::OnCancel() ;

		if (TFTP_READ_TIMER_ID != SetTimer (TFTP_READ_TIMER_ID,
														TFTP_READ_TIMER_PERIOD, NULL))
		{
			CDialog::OnCancel() ;
		}

		if (TFTP_55_MS_TIMER_ID != SetTimer (TFTP_55_MS_TIMER_ID,
														55, NULL))
		{
			KillTimer (TFTP_READ_TIMER_ID) ;
			CDialog::OnCancel() ;
		}
	}
	if (IsPortIP)
		m_tftp_request_made = FALSE ;
#endif

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
   strcat (WindowHeader, " - ") ;
   strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;
   CenterWindow() ;

   m_ListPortStatWndControl.SetTabStops (3, &tabStops[0]) ;
	  
	SetCapture() ;

   SelectedPort = - 1 ;

	// TODO: Add extra initialization here
	GetPortInfo(MAJOR_VERSION,MINOR_VERSION,START_PORT) ;
   m_ListPortStatWndControl.SetCurSel(0) ;

   UINT DisplayTimerID = PORT_STATUS_TIMER_ID ;
#if PROXY_SERVER
	if (IsPortIP)
		UpdatePeriod = 10000 ;
	else
		UpdatePeriod = 4000 ;
#endif
   while (DisplayTimerID != SetTimer (DisplayTimerID, (UINT) UpdatePeriod, NULL))
   {
      if (IDCANCEL == ::MessageBox(GetSafeHwnd(),"Timer Not Set","",
                                                     MB_RETRYCANCEL))
      {
          SendMessage (WM_CLOSE) ;
          return TRUE ; 
      } 
   }

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// -------------------------------------------------------------------------
// Function             :	CPortStat::AddListBox.
// Arguments            :  three -> int, char* ,unsigned long.
// Synopsis             :  Adds port number,status & baud_rate to the listbox.
// Returns              :  None.
// Globals Affected     :  None.
// -------------------------------------------------------------------------

void CPortStat::AddListBox(int Num,char *Status,unsigned long Bau)
{
	char Pstring[60];

   sprintf (Pstring, "%2d\t%s\t%lu", Num + 1, Status, Bau) ;	//Vidy
   m_ListPortStatWndControl.AddString(Pstring) ;

}

void CPortStat::OnButtonHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_PORT_STATISTICS, HELP_CONTEXT) ;
}

void CPortStat::OnDblclkList1PortStat()
{
   PortList() ;
}

// -------------------------------------------------------------------------
// Function             :	CPortStat::PortList.
// Arguments            :  None.
// Synopsis             :  Assigning port statistics information to temp vars.
// Returns              :  None.
// Globals Affected     :  None.
// -------------------------------------------------------------------------

void CPortStat::PortList()
{
   if (m_ListPortStatWndControl.GetCurSel() == LB_ERR)
      return ;
   else
      SelectedPort = m_ListPortStatWndControl.GetCurSel() ;

   CPortInfo pdlg(this) ;
   pdlg.DoModal() ;	

   SelectedPort = -1 ;
}

void CPortStat::OnTimer(UINT nIDEvent)
{
#if PROXY_SERVER
	enum TFTP_FILE_TRANSFER_STATUS ReadTFTPStatus ;
	enum TFTP_COMPLETION_CODE_STATUS ReadTFTPComplete ;
	PortStatusResp *ptr_PortStatusResponse ;
#endif

	// TODO: Add your message handler code here and/or call default
   if (nIDEvent == PORT_STATUS_TIMER_ID)
   {
      cPortSta.TimeOut = TRUE ;

      GetPortInfo(MAJOR_VERSION, MINOR_VERSION, START_PORT) ;

      if (SelectedPort != -1)
      {
         ((CPortInfo *)pChild)->DisplayPortInfo() ;
      }
   }
#if PROXY_SERVER
	else if (nIDEvent == TFTP_READ_TIMER_ID)
	{
		////Prabha, to check if some log read request has been made
		if (m_tftp_log_request_made)
		{
			m_tftp_request_made = FALSE;
   	   cPortSta.TimeOut = TRUE ;
			OnButtonLogview();
			return;
		}
		if (m_tftp_request_made)
		{
			ReadTFTPComplete = TFTPGetCompletionCode() ; 
			ReadTFTPStatus = TFTPGetFileTransferStatus() ;
			if (ReadTFTPComplete == TFTP_COMPLETE)
			{
				m_tftp_request_made = 0 ;
				if (ReadTFTPStatus != TFTP_FILE_TRANSFER_SUCCESSFUL)
				{
					int Response;

					KillTimer (TFTP_READ_TIMER_ID) ;

					if (SelectedPort == -1)
					{	
						Response = RouMsgBox (GetSafeHwnd(), ONLINE_STATUS_TFTP_FAILED,
						"Port Status", MB_YESNO);
					}
					else
					{
						Response = (((CPortInfo *)pChild)->RouMsgBox)(GetSafeHwnd(), ONLINE_STATUS_TFTP_FAILED,
						"Port Status", MB_YESNO);
					}

					if (IDNO == Response)
					{
      				if (SelectedPort != -1)
							((CPortInfo *)pChild)->OnCancel() ;
						OnCancel() ;
					}
					else
					{
						if (TFTP_READ_TIMER_ID != SetTimer (TFTP_READ_TIMER_ID,
														TFTP_READ_TIMER_PERIOD, NULL))
						{
      					if (SelectedPort != -1)
								((CPortInfo *)pChild)->OnCancel() ;
							OnCancel() ;
						}
					}
				}
				else
				{
					ptr_PortStatusResponse = (PortStatusResp *)&port_status_ram_file[TFTP_HEADER_SIZE] ;
					_fmemcpy (&PortInformation[0][0], &ptr_PortStatusResponse->port_information[0], PORT_STATUS_SIZE * NUMBER_OF_PROXY_PORTS) ;
					int i ;
					for (i = 0 ; i < NUMBER_OF_PROXY_PORTS ; i++)
					{
						modify_port_info ((PortStatusInfo *)&PortInformation[i][0]) ;
					}
					DisplaySummaryInfo (ptr_PortStatusResponse->number_of_records, ptr_PortStatusResponse->system_up_time) ;
				}
			}
		}
	}
	else if (nIDEvent == TFTP_55_MS_TIMER_ID)
	{
		if (m_tftp_request_made)
		{
			TFTPTimer () ;
		}
	}
#endif
   else
   { 
      KillTimer(nIDEvent) ;	
      cPortSta.TimeOut = TRUE ;
   }
   CDialog::OnTimer(nIDEvent) ;
}

// -------------------------------------------------------------------------
// Function             :	CPortStat::GetPortInfo.
// Arguments            :  five -> int,int,int,int,PortStatusInfo.
// Synopsis             :  Retriving port statistics information.
// Returns              :  None.
// Globals Affected     :  None.
// -------------------------------------------------------------------------

void CPortStat::GetPortInfo(int Major, int Minor, int StartPort)
{
   PortStatusRequest PSReq ;
   int nRetry = 0, j = 0 ;
   PortStatusResp PSResp ;
#if PROXY_SERVER
	HWND ThisWindowHandle ;
	char IPAddress[20] ;
	enum TFTP_FILE_TRANSFER_RESULT TFTPReadResult ;
#endif
	if (reenter_flag)
		return ;
	reenter_flag = 1 ;

#if PROXY_SERVER
	if (IsPortIP)
	{
		/* Later get it from the INI instead of using this #defined symbol */
		DisplaySummaryInfo (NUMBER_OF_PROXY_PORTS, 0) ;
		if (m_tftp_request_made) /* The last request itself has not completed */
		{
			reenter_flag = 0 ;
			return ;
		}

		ThisWindowHandle = GetSafeHwnd() ; // Sachin 27.11.95
		if (GetPrivateProfileString ((LPCSTR) "Port Setup",
			(LPCSTR) "Router IP Address",	(LPCSTR) "", (LPSTR) IPAddress,
				sizeof (IPAddress), (LPCSTR) OwnIniFile) <= 0)
			CDialog::OnCancel() ;


		TFTPReadResult = TFTPGetFile (port_status_ram_file, PORT_STATUS_FILE, IPAddress, ThisWindowHandle) ;
		if (TFTPReadResult != TFTP_SUCCESS)
			CDialog::OnCancel() ;

		m_tftp_request_made = TRUE ;
	}
	else
	{
#endif

   PSReq.Ptype = GET_PORT_STATUS  ;
   PSReq.major_version = MAJOR_VERSION ;
   PSReq.minor_version = MINOR_VERSION ;
   PSReq.request_id = 0 ;
   PSReq.start_port = START_PORT ;
   PSReq.end_port = 2 ;

   cPortSta.TimeOut = FALSE ;
 
   UINT PortsTimerID = 110 ;
   while (PortsTimerID != SetTimer (PortsTimerID, (UINT) 4000, NULL))
   {
      if (IDCANCEL == ::MessageBox(GetSafeHwnd(),"Timer Not Set","",
                                                    MB_RETRYCANCEL))
      {
         SendMessage (WM_CLOSE) ;
			reenter_flag = 0 ;
         return ; 
      }
   }
   while(1)
   {
      cPortSta.snd_packet ((BYTE *) &PSReq ,sizeof(PortStatusRequest)) ;
         if (!(cPortSta.rcv_packet((BYTE *) &PSResp,
                      sizeof (PortStatusResp), (BOOL *)&cPortSta.TimeOut)))
         {
            break ;
         }   
   }
   KillTimer (PortsTimerID) ;

   if ((PSResp.error_code != 0) || (PSResp.packet_type != GET_PORT_STATUS))
   {
		reenter_flag = 0 ;
      return ;
   }

#if PROXY_SERVER
   	_fmemcpy (&PortInformation[0][0], &PSResp.port_information[0],
      	sizeof (PortStatusInfo) * PSResp.number_of_records) ;
		for (j = 0 ; j < PSResp.number_of_records ; j++)
			modify_port_info ((PortStatusInfo *)&PortInformation[j][0]) ;

		DisplaySummaryInfo (PSResp.number_of_records, PSResp.system_up_time) ;
	}
	reenter_flag = 0 ;
#endif
}

/* Sachin, 27/10/1997 */

void reconvert_controls (char *string)
{
   char new_string[200], *x = string ;
   int i = 0 ;

   while (*string)
   {
      if ((*string == '\\') && (*(string + 1) == 'b'))
      {
         new_string[i++]  = ' ' ;
         string += 2 ;
      }
      else
         new_string[i++]  = *string++ ;
   }
   new_string[i] = 0 ;
   strcpy (x, &new_string[0]) ;
}


void modify_port_info (PortStatusInfo *sptr_port_status)
{
   int i = 0 ;

   /* Convert to Intel Format */
   sptr_port_status->BaudRate = SwapDWord (sptr_port_status->BaudRate) ;
   sptr_port_status->local_ip_address = SwapDWord (sptr_port_status->local_ip_address) ;
   sptr_port_status->remote_ip_address = SwapDWord (sptr_port_status->remote_ip_address) ;
   sptr_port_status->subnet_mask = SwapDWord (sptr_port_status->subnet_mask) ;
   sptr_port_status->connection_up_time = SwapDWord (sptr_port_status->connection_up_time) ;
   sptr_port_status->connection_tx_count = SwapDWord (sptr_port_status->connection_tx_count) ;
   sptr_port_status->connection_rx_count = SwapDWord (sptr_port_status->connection_rx_count) ;

   sptr_port_status->aggregate_tx_count = SwapDWord (sptr_port_status->aggregate_tx_count) ;
   sptr_port_status->aggregate_rx_count = SwapDWord (sptr_port_status->aggregate_rx_count) ;
   sptr_port_status->number_of_calls = SwapDWord (sptr_port_status->number_of_calls) ;
   sptr_port_status->aggregate_connection_time = SwapDWord (sptr_port_status->aggregate_connection_time) ;

	//Vidy 31/10/97
   sptr_port_status->connection_tx_pkt_count = SwapDWord(sptr_port_status->connection_tx_pkt_count) ;
   sptr_port_status->connection_rx_pkt_count = SwapDWord(sptr_port_status->connection_rx_pkt_count) ;

   sptr_port_status->aggregate_tx_pkt_count = SwapDWord(sptr_port_status->aggregate_tx_pkt_count) ;
   sptr_port_status->aggregate_rx_pkt_count = SwapDWord(sptr_port_status->aggregate_rx_pkt_count) ;

   /* Just to make sure that we dont crash in case a wrong status field is obtained */
   for (i = 0 ; port_status_desc[i] ; i++)
      ;

   if (sptr_port_status->status >= i-1)
      sptr_port_status->status = i-1 ;
   
   reconvert_controls (&sptr_port_status->modem_name[0]) ;
}

/* Sachin, 27/10/1997 */


void CPortStat::OnButtonDetails()
{
	// TODO: Add your control notification handler code here
   OnDblclkList1PortStat();	
}

void CPortStat::OnCancel()
{
	// TODO: Add extra cleanup here
	
   KillTimer (PORT_STATUS_TIMER_ID) ;
#if PROXY_SERVER
	if (IsPortIP)
	{
		if (m_tftp_request_made)
			TFTPAbortProcess () ;
   	KillTimer (TFTP_READ_TIMER_ID) ;
   	KillTimer (TFTP_55_MS_TIMER_ID) ;
		free (port_status_ram_file) ;
	}
#endif
	CDialog::OnCancel();
	reenter_flag = 0 ;
}

#if PROXY_SERVER

LRESULT CPortStat::OnTFTPReadCallBack(WPARAM wParam, LPARAM lParam)
{
	TFTPProcess() ;
	return NULL ;
}


int CPortStat::RouMsgBox (HWND hWnd, int StrId, LPCSTR Header, int Opts)
{
	CString Message ;
	int Ret_val ;
	char NewHeader[50] ;

	Message.LoadString (StrId) ;
	ModifyHeader (Header, (LPCSTR) &NewHeader[0]) ;
	Ret_val = MessageBox (Message, (LPCSTR) &NewHeader[0], Opts) ;
	return Ret_val ;
}

#endif

// Takes information from the PortInformation[][] and displays
void CPortStat::DisplaySummaryInfo (int NumberOfRecords, unsigned long system_up_time)
{
	char Status[100] ;
	DWORD TCalls, TUpTime, TPktRcv, TPktSnt, TBytRcv, TBytSnt;
   int CurrentSelection ;
	int r ;
	PortStatusInfo *ptr_PortInformation = (PortStatusInfo *) &PortInformation[0][0] ;
	
	TCalls = TUpTime = TPktRcv = TPktSnt = TBytRcv = TBytSnt = 0;
   CurrentSelection = m_ListPortStatWndControl.GetCurSel() ;
   m_ListPortStatWndControl.ResetContent() ;
   for (r = 0 ; r < NumberOfRecords ; r++, ptr_PortInformation++)
   {
      AddListBox(ptr_PortInformation->port_number,
      port_status_desc[ptr_PortInformation->status],
      ptr_PortInformation->BaudRate) ;
	
		TCalls +=  ptr_PortInformation->number_of_calls;
		TUpTime += ptr_PortInformation->aggregate_connection_time;
		TBytRcv += ptr_PortInformation->aggregate_rx_count;
		TBytSnt += ptr_PortInformation->aggregate_tx_count;
		TPktRcv += ptr_PortInformation->aggregate_rx_pkt_count;
		TPktSnt += ptr_PortInformation->aggregate_tx_pkt_count;

   }

   m_ListPortStatWndControl.SetCurSel(CurrentSelection) ;

	PunctuateLong(Status, TCalls);
	m_Calls = Status;

	PunctuateLong(Status, TBytRcv);
	m_BytRcv = Status;

	PunctuateLong(Status, TBytSnt);
	m_BytSnt = Status;

	PunctuateLong(Status, TPktRcv);
	m_PktRcv = Status;

	PunctuateLong(Status, TPktSnt);
	m_PktSnt = Status;

	DwordToDayHrMinSecs(Status, TUpTime);
	m_UpTime = Status;

	//Only the information per port is in intel format.
	//convert the system_up_time now
	system_up_time = SwapDWord(system_up_time);
	DwordToDayHrMinSecs(Status, system_up_time);
	m_sys_uptime = Status;

	UpdateData(FALSE);
}

////Prabha, 12/2/1998, to show the logview 
void CPortStat::OnButtonLogview()
{
	// TODO: Add your control notification handler code here
	if (IsPortIP)   ////thro' TFTP
	{
		if (m_tftp_request_made)
		{
			m_tftp_log_request_made = TRUE;
		 	return;
		}
		m_tftp_log_request_made = TRUE;
   	KillTimer (PORT_STATUS_TIMER_ID) ;
	  	KillTimer (TFTP_READ_TIMER_ID) ;
		KillTimer (TFTP_55_MS_TIMER_ID) ;
		strcpy (TFTPGetRemoteFileName, "events.log") ;
		strcpy (TFTPGetLocalFileName, LogFileName) ;

		tftpread TFTPReadDlg ;
		if (TFTPReadDlg.DoModal() == IDOK)
		{
			Clogview logview;
			logview.DoModal();
		}
		m_tftp_log_request_made = FALSE ;
		RestoreTimers();
	}
	else			////Through COM port
	{
   	KillTimer (PORT_STATUS_TIMER_ID) ;
		CFile input ;				
   	if (!input.Open (LogFileName, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary))
	   {
   	  	AfxMessageBox (MSG_COM_ERR_FILE_OPEN, MB_OK | MB_ICONINFORMATION) ;
	     	return ;
		}
		////Request for open log
		BOOL log_transferred = FALSE;
		ReqType LogViewPkt;
		ResultType LogViewRes;
		LogViewPkt.Ptype = (BYTE) OPEN_EVENT_LOG;
		LogViewPkt.ReqType = 0;
		LogViewPkt.ReqSubType = 0;
		LogViewPkt.Dmy0 = 0;
	  	cPortSta.TimeOut = FALSE;

   	UINT nTimerID = ReadLogTimerID ;
	  	while (nTimerID != SetTimer (nTimerID, (UINT) OPEN_LOG_TIMER_PERIOD, NULL))
		{
  	   	if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
						ProxySectionHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
			{
  		   	break;
     		}
		}
		
   	while (1)
	  	{
			cPortSta.snd_packet ((BYTE *) &LogViewPkt, sizeof (ReqType));
			if (!(cPortSta.rcv_packet2 ((BYTE *) &LogViewRes,
				sizeof (ResultType), (BOOL *) &cPortSta.TimeOut)))
			{
				break ;   // No CRC error
			}
	  	}
		
	   KillTimer (nTimerID) ;
   	if (cPortSta.TimeOut)
		{
			////If timed out, return
   		if (IDOK == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_RESP,
						ProxySectionHeader,  MB_OK | MB_ICONINFORMATION)) 
				return;
		}
		////If OPEN_LOG is successful, give a call for READ LOG
		if (LogViewRes.ErrorCode != ERR_NO_LOGGING)
		{
			////Request for read log
			ReadLocReqType ReadLocReqPkt;
			ReadLocRespType ReadLocRespPkt;
			int	BlockAddr = 0;
			int	CumRetries = 0;
			ReadLocReqPkt.Ptype = (BYTE) READ_EVENT_LOG;
			ReadLocReqPkt.Length = 128;
			ReadLocReqPkt.Address = cPortSta.little_endian(BlockAddr);
			CWaitDlg wait(AfxGetMainWnd());
			wait.InvalidateRect(NULL);
			wait.UpdateWindow();
REPEATREAD:			
	   	cPortSta.TimeOut = FALSE;
		   UINT nTimerID = ReadLogTimerID ;
  			while (nTimerID != SetTimer (nTimerID, (UINT) READ_LOG_TIMER_PERIOD, NULL))
			{
  			   if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
							ProxySectionHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
				{
  			   	break;
	      	}
			}

			cPortSta.FlushReadBuf();
			cPortSta.snd_packet ((BYTE *) &ReadLocReqPkt, sizeof (ReadLocReqType));
			if (cPortSta.rcv_packet2 ((BYTE *) &ReadLocRespPkt,
				sizeof (ReadLocRespType), (BOOL *) &cPortSta.TimeOut))
			{	//This indicates a CRC error in received packet
				//We need to reread the same packet
			   KillTimer (nTimerID) ;
				goto REPEATREAD;
			}

		   KillTimer (nTimerID) ;
  			if (cPortSta.TimeOut) 
			{
				if (CumRetries++ < 5)	//beyond these many, we giveup!
				{
					goto REPEATREAD;
				}
				if (!log_transferred)		 ////If something has been transferred
				{									 ////don't show the 'no response' box.
					wait.DestroyWindow();
	   			RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_RESP, ProxySectionHeader,  
						MB_OK | MB_ICONINFORMATION); 
					closelog();
					return;					
				}
				else
				{
					wait.DestroyWindow();
					input.Close();
				 	Clogview logview;
				 	logview.DoModal();
				 	closelog();
					return;
				}
			}
			if (ReadLocRespPkt.ErrCode == ERR_READ_EVENT_LOG)
			{////Error in reading
	   		if (IDOK == RouMsgBox (GetSafeHwnd(), MSG_COM_ERR_LOG_READ,
						ProxySectionHeader,  MB_OK | MB_ICONINFORMATION)) 
					closelog();
				return;
			}
			if (ReadLocReqPkt.Address != ReadLocRespPkt.Address)
			{	//check if request and response match
				goto REPEATREAD;
			}

			log_transferred = TRUE;
			input.Write ((LPCSTR)ReadLocRespPkt.buffer, ReadLocRespPkt.Length);

			if (ReadLocRespPkt.Length == 128)
			{////If the length = 128, then there may be still more to read
				cPortSta.FlushReadBuf();
				BlockAddr++;
				ReadLocReqPkt.Address = cPortSta.little_endian(BlockAddr);
				goto REPEATREAD;
			}
			else
			{
				wait.DestroyWindow();
				input.Close();
				Clogview logview;
				logview.DoModal();
				closelog();
			}
		}
	}
	return;			  
}

void CPortStat::closelog()
{
	////Send a request to close log	
	ReqType CloseLogPkt;
	ResultType CloseLogRes;
	CloseLogPkt.Ptype = (BYTE) CLOSE_EVENT_LOG;
	CloseLogPkt.ReqType = 0;
	CloseLogPkt.ReqSubType = 0;
	CloseLogPkt.Dmy0 = 0;
  	cPortSta.TimeOut = FALSE;
   UINT nTimerID = ReadLogTimerID ;
  	while (nTimerID != SetTimer (nTimerID, (UINT) OPEN_LOG_TIMER_PERIOD, NULL))
	{
  	   if (IDCANCEL == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_TIMER,
					ProxySectionHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
  	   	break;
     	}
	}
   while (1)
	{
		cPortSta.snd_packet ((BYTE *) &CloseLogPkt, sizeof (ReqType));
		if (!(cPortSta.rcv_packet2 ((BYTE *) &CloseLogRes,
			sizeof (ResultType), (BOOL *) &cPortSta.TimeOut)))
		{
			break ;   // No CRC error
		}
	}
	KillTimer (nTimerID);
	if (cPortSta.TimeOut)
	{
  		if (IDOK == RouMsgBox (GetSafeHwnd(), MSG_GEN_NO_RESP,
				ProxySectionHeader,  MB_OK | MB_ICONINFORMATION)) 
		return;
	}
	RestoreTimers();
}

void CPortStat::RestoreTimers()
{
	////Restore all the timers for port statistics

	if (IsPortIP) 
	{
		if (TFTP_READ_TIMER_ID != SetTimer (TFTP_READ_TIMER_ID,
													TFTP_READ_TIMER_PERIOD, NULL))
		{
      	::MessageBox(GetSafeHwnd(),"Timer Not Set","", MB_OK);
			CDialog::OnCancel() ;
		}
		if (TFTP_55_MS_TIMER_ID != SetTimer (TFTP_55_MS_TIMER_ID,
															55, NULL))
		{
      	::MessageBox(GetSafeHwnd(),"Timer Not Set","", MB_OK);
			KillTimer (TFTP_READ_TIMER_ID) ;
			CDialog::OnCancel() ;
		}
		m_tftp_request_made = FALSE ;
		m_tftp_log_request_made = FALSE ;
	}

   SelectedPort = -1 ;

	GetPortInfo(MAJOR_VERSION,MINOR_VERSION,START_PORT) ;
   m_ListPortStatWndControl.SetCurSel(0) ;
	unsigned long UpdatePeriod ;
   UINT DisplayTimerID = PORT_STATUS_TIMER_ID ;
#if PROXY_SERVER
	if (IsPortIP)
		UpdatePeriod = 10000 ;
	else
		UpdatePeriod = 4000 ;
#endif
   while (DisplayTimerID != SetTimer (DisplayTimerID, (UINT) UpdatePeriod, NULL))
   {
      if (IDCANCEL == ::MessageBox(GetSafeHwnd(),"Timer Not Set","",
                                                     MB_RETRYCANCEL))
      {
          SendMessage (WM_CLOSE) ;
          return; 
      } 
   }
	return;
}


