// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	PPPDLG.CPP
// Description       :	Defines Classes :
//								CPPPDlg 		: Function of PPP Dialog
//								CPPortDlg	: Function of PPP Port Tabs
//								CPTab			: Function of PPP Port TabDialog
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:  17 Nov 1999     
// Modifications     :	10/01/96 Vidy added DOD support
// -------------------------------------------------------------------------
// Vidy 05/12/96	 : if only one wan, don't show WAN 1 (show WAN) - got it?
//
// Jyothi 15/07/98 :  made changes for small proxy
// Jyothi 15/07/98 :  structures used instead of INI files

//	Jyothi			 : 17 Nov 1999. Made changes to handle MLPPP and Link Control Dependencies

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "maindlg.h"
#include "pppdlg.h"
#include "tabdlg.h"
#include	"cryptfns.h"
#include "hardware.h"
#include "cnffile.h"
#include "readbmp.h"

// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------
         

LPCSTR	PPPSectionHeader = "PPP Device Driver";
LPCSTR	PPPMsgHeader = "ProxyServer Setup - PPP";
BOOL fClientOnly;

#define Max_BackoffInterval 65535
#define Min_BackoffInterval 5

#define Max_MaxConfigReq 65535
#define Min_MaxConfigReq 3

#define Max_MaxEchoReq 20
#define Min_MaxEchoReq 1

#define Max_MaxTermReq 20
#define Min_MaxTermReq 1

#define Max_MaxSendConfigInter 65535
#define Min_MaxSendConfigInter 5

#define Max_MaxSendEchoInter 65535
#define Min_MaxSendEchoInter 0

#define Max_MaxSendTermInter 65535
#define Min_MaxSendTermInter 5

#define Max_MaxAuthRetry 65535
#define Min_MaxAuthRetry 3

#define Max_AuthTimer 65535
#define Min_AuthTimer 5

#define Max_MaxReceive 4500
#define Min_MaxReceive 1500

#define Max_MaxRemoteReceive 4500
#define Min_MaxRemoteReceive 1500

#define Max_AsyncCount 65535
#define Min_AsyncCount 0

#define Max_AsyncSize 65535
#define Min_AsyncSize 0

#define Max_TimetoSendLQR 65535
#define Min_TimetoSendLQR 0

#define Max_SLIPMTU 1006
#define Min_SLIPMTU 100

#define Max_DODIdleTime 5 * 24 * 60		//hangup after hours idle
#define Min_DODIdleTime	1			//idle time before hangup
#define Def_DODIdleTime	3


/* Jo 15/07/98 */

extern CNF_PPP *ppp_ptr ;
extern CNF_WAN *wan_ptr ;

/* Jo 15/07/98 */

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CPPPDlg dialog


CPPPDlg::CPPPDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPPPDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPPPDlg)
	m_nBackoffInterval = 5 ;
	m_nMaxConfigReq = 3 ;
	m_nMaxEchoReq = 1 ;
	m_nMaxTermReq = 1 ;
	m_Printf = FALSE;
	m_PrintfAlarm = FALSE;
	m_PrintfLCP = FALSE;
	m_PrintfNCP = FALSE;
	m_nMaxSendConfigInter = 5 ;
	m_nMaxSendEchoInter = 0 ;
	m_nMaxSendTermInter = 5 ;
	m_MLPPP = FALSE;
	m_DialOut = FALSE;
	//}}AFX_DATA_INIT
	Create(IDD,NULL);
}

void CPPPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPPPDlg)
	DDX_Control(pDX, IDC_CHECK1, m_MLPPPWnd);
	DDX_Control(pDX, IDC_SEND_TERM_INTERVAL, m_SendTermWnd);
	DDX_Control(pDX, IDC_SEND_ECHO_INTERVAL, m_SendEchoWnd);
	DDX_Control(pDX, IDC_SEND_CONFIG_INTERVAL, m_SendConfigWnd);
	DDX_Control(pDX, IDC_MAX_TERM_REQ, m_MaxTermReqWnd);
	DDX_Control(pDX, IDC_MAX_ECHO_REQ, m_MaxEchoReqWnd);
	DDX_Control(pDX, IDC_MAX_CONFIG_REQ, m_MaxConfigReqWnd);
	DDX_Control(pDX, IDC_BACKOFF_CONFIG, m_BackoffWnd);
	DDX_Text(pDX, IDC_BACKOFF_CONFIG, m_nBackoffInterval);
	DDX_Text(pDX, IDC_MAX_CONFIG_REQ, m_nMaxConfigReq);
	DDX_Text(pDX, IDC_MAX_ECHO_REQ, m_nMaxEchoReq);
	DDX_Text(pDX, IDC_MAX_TERM_REQ, m_nMaxTermReq);
	DDX_Check(pDX, IDC_PRINTF, m_Printf);
	DDX_Check(pDX, IDC_PRINTF_ALARM, m_PrintfAlarm);
	DDX_Check(pDX, IDC_PRINTF_LCP, m_PrintfLCP);
	DDX_Check(pDX, IDC_PRINTF_NCP, m_PrintfNCP);
	DDX_Text(pDX, IDC_SEND_CONFIG_INTERVAL, m_nMaxSendConfigInter);
	DDX_Text(pDX, IDC_SEND_ECHO_INTERVAL, m_nMaxSendEchoInter);
	DDX_Text(pDX, IDC_SEND_TERM_INTERVAL, m_nMaxSendTermInter);
	DDX_Check(pDX, IDC_CHECK1, m_MLPPP);
	DDX_Check(pDX, IDC_CHECK2, m_DialOut);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPPPDlg, CDialog)
	//{{AFX_MSG_MAP(CPPPDlg)
	ON_BN_CLICKED(IDC_PPP_HELP, OnHelp)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPPPDlg message handlers

/* Jo */
BOOL CPPPDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_PPP_HELP, this));			  
	HelpBmpBtn.SizeToContent();

//Get the values of all PPP parameters from INI file.
	
   //Get the BOOL parameters.

// Jo Modem inital Dialout
   m_DialOut = ppp_ptr->ppp_header.need_to_dial_out_initially ;
   m_Printf = ppp_ptr->ppp_header.printf ;
   m_PrintfAlarm = ppp_ptr->ppp_header.printf_alarm ;
   m_PrintfLCP = ppp_ptr->ppp_header.printf_LCP ;
   m_PrintfNCP = ppp_ptr->ppp_header.printf_NCP ;

// TODO: Add extra initialization here

     m_MLPPP = ppp_ptr->ppp_ports[0].lcp_epd.valid ;
   MLPPPENABLED = m_MLPPP ;

//Update the Dialog Box fields.
   UpdateData(FALSE) ;
		
   return TRUE ;  // return TRUE  unless you set the focus to a control

}

// Removed by cfp on 28-3-96

void CPPPDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_PPP_CONFIG,HELP_CONTEXT);
	
}

BOOL CPPPDlg::ValidEditFields()
{
/* Jo */
	return(TRUE);
}

void CPPPDlg::OnOK()
{
// Update the parameters from the Dialog Box.
	if(!UpdateData(TRUE))
      return;

//if the parameters are invalid return
   if(!ValidEditFields())
	   return;
   if((!MLPPPENABLED) && m_MLPPP)
   {
/* ...Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies */
      ::MessageBox(GetSafeHwnd(),(LPCSTR)"1. Make sure that the UserName & PassWord\
\n    are the same for all the participating links.\
\n2. Remote Access will be disabled on all Ports.", PPPMsgHeader,
            MB_OK);
/* Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies... */
   }
	LPCSTR temp;
	char m_szTempBuf[12];
	temp = (char *)m_szTempBuf;

// Write the parameters to the INI file.

// Jo Modem inital dialout

   ppp_ptr->ppp_header.need_to_dial_out_initially = m_DialOut ;

   //Write the BOOL parameters
   ppp_ptr->ppp_header.printf = m_Printf ;
   ppp_ptr->ppp_header.printf_alarm = m_PrintfAlarm ;
   ppp_ptr->ppp_header.printf_LCP = m_PrintfLCP ;
   ppp_ptr->ppp_header.printf_NCP = m_PrintfNCP ;


	// TODO: Add extra validation here

	//If MLPPP is enabled, we need to write the end point descriminator
	//string to the PPP Section
	//PPP Port0 Option%LCP%EPD=19,Auto,Negotiation Not Required,Not Negotiable,H7,03000000000000
	//PPP Port0 Remote Option%LCP%EPD=19,Auto,Negotiation Not Required,Negotiable,H7,03000000000000

	int	index;
	int m_nPorts = ppp_ptr->ppp_header.number_of_ports ;

	if (m_MLPPP)
	{
	   for( index = 0; index < m_nPorts; index++)
	   {
	   	ppp_ptr->ppp_ports[index].lcp_epd.option_type = 19 ;
			ppp_ptr->ppp_ports[index].lcp_epd.Auto = 1 ;
			ppp_ptr->ppp_ports[index].lcp_epd.NegNotReqd = 1 ;
			ppp_ptr->ppp_ports[index].lcp_epd.Negotiable = 0 ;
			ppp_ptr->ppp_ports[index].lcp_epd.value_type = H7 ;
			ppp_ptr->ppp_ports[index].lcp_epd.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index].lcp_epd.option_value, "03000000000000") ;

		  	ppp_ptr->ppp_ports[index].remote_lcp_epd.option_type = 19 ;
			ppp_ptr->ppp_ports[index].remote_lcp_epd.Auto = 1 ;
			ppp_ptr->ppp_ports[index].remote_lcp_epd.NegNotReqd = 1 ;
			ppp_ptr->ppp_ports[index].remote_lcp_epd.Negotiable = 1 ;
			ppp_ptr->ppp_ports[index].remote_lcp_epd.value_type = H7 ;
			ppp_ptr->ppp_ports[index].remote_lcp_epd.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index].remote_lcp_epd.option_value, "03000000000000") ;

		   ppp_ptr->ppp_ports[index].lcp_mrru.option_type = 17 ;
			ppp_ptr->ppp_ports[index].lcp_mrru.Auto = 1 ;
			ppp_ptr->ppp_ports[index].lcp_mrru.NegNotReqd = 1 ;
			ppp_ptr->ppp_ports[index].lcp_mrru.Negotiable = 1 ;
			ppp_ptr->ppp_ports[index].lcp_mrru.value_type = D2 ;
			ppp_ptr->ppp_ports[index].lcp_mrru.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index].lcp_mrru.option_value, "1600") ;
			
		   ppp_ptr->ppp_ports[index].remote_lcp_mrru.option_type = 17 ;
			ppp_ptr->ppp_ports[index].remote_lcp_mrru.Auto = 1 ;
			ppp_ptr->ppp_ports[index].remote_lcp_mrru.NegNotReqd = 1 ;
			ppp_ptr->ppp_ports[index].remote_lcp_mrru.Negotiable = 1 ;
			ppp_ptr->ppp_ports[index].remote_lcp_mrru.value_type = D2 ;
			ppp_ptr->ppp_ports[index].remote_lcp_mrru.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[index].remote_lcp_mrru.option_value, "1600") ;
/* Jo 23/06/99 Added for RAS */
			ppp_ptr->ppp_ports[index].remote_port_client_only = 0 ;
			wan_ptr->wan_ports[index].auto_answer = 0 ;

/* ...Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies */
		
			if (!index)
				ppp_ptr->ppp_ports[index].hangup_time = ppp_ptr->ppp_ports[0].hangup_time ;
				
/* Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies... */
	   }
	}
	else
	{
	   for( index = 0; index < m_nPorts; index++)
	   {
			ppp_ptr->ppp_ports[index].lcp_epd.valid = 0 ;
			ppp_ptr->ppp_ports[index].remote_lcp_epd.valid = 0 ;
			ppp_ptr->ppp_ports[index].lcp_mrru.valid = 0 ;
			ppp_ptr->ppp_ports[index].remote_lcp_mrru.valid = 0 ;
	   }
	}
	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK);
}

void CPPPDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
	
}

LRESULT CPPPDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}
void CPPPDlg::PostNcDestroy(void)
{
	delete this;
}

/////////////////////////////////////////////////////////////////////////////
// CPPortDlg dialog


CPPortDlg::CPPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPPortDlg)
	m_nMaxAuthRetry = 3 ;
	m_nAuthTimer = 5 ;
	m_Password = "";
	m_PortOption = "";
	m_RemoteOption = "";
	m_UserName = "";
	m_bVJC = FALSE;
	m_bDataCompression = FALSE;
	m_PPP = FALSE;
	m_SLIPEnable = FALSE;
	m_CSLIPEnable = FALSE;
	m_nSLIPMTU = 0;
	m_StrDialNumber = "";
	//}}AFX_DATA_INIT

	m_bClientOnly = FALSE;
	
	Create(IDD,NULL);
}

void CPPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPPortDlg)
	DDX_Control(pDX, IDC_STATIC_DIAL_NUMBER, m_StatDialNumber);
	DDX_Control(pDX, IDC_EDIT_DIAL_NUMBER, m_EditDialNumber);
	DDX_Control(pDX, IDC_RADIO_PAP_OR_CHAP, m_radio_pap_or_chap);
	DDX_Control(pDX, IDC_RADIO_CHAP, m_radio_chap);
	DDX_Control(pDX, IDC_RADIO_PAP, m_radio_pap);
	DDX_Control(pDX, IDC_STAT_NUM_RTRIES, m_NumRtryWnd);
	DDX_Control(pDX, IDC_STAT_PER_TIMER, m_PerTmrWnd);
	DDX_Control(pDX, IDC_STAT_AUTH_GRP, m_AuthGrpWnd);
	DDX_Control(pDX, IDC_CHECK_VJC, m_VJCWnd);
	DDX_Control(pDX, IDC_STATIC_GRP_PPP, m_PPPGrpWnd);
	DDX_Control(pDX, IDC_ENABLE_PPP, m_PPPWnd);
	DDX_Control(pDX, IDC_STATIC_GRP_SLIP, m_SLIPGrpWnd);
	DDX_Control(pDX, IDC_STATIC_SLIP_MTU, m_SLIPMTUStatWnd);
	DDX_Control(pDX, IDC_SLIP_MAX_TRANSMIT_UNIT, m_SLIPMTUWnd);
	DDX_Control(pDX, IDC_CHECK_CSLIP, m_CSLIPEnableWnd);
	DDX_Control(pDX, IDC_ENABLE_SLIP, m_SLIPEnableWnd);
	DDX_Control(pDX, IDC_CHECK_DATA_COMP, m_DataCompCtrl);
	DDX_Control(pDX, IDC_PASSWORD, m_EditUserPassword);
	DDX_Control(pDX, IDC_STATIC_USR_PASSWD, m_StatUserPassword);
	DDX_Control(pDX, IDC_USER_NAME, m_EditUserName);
	DDX_Control(pDX, IDC_STATIC_USR_NAME, m_StatUserName);
	DDX_Control(pDX, IDC_AUTH_TIMER, m_AuthTimerWnd);
	DDX_Control(pDX, IDC_AUTH_RETRIES, m_AuthRetryWnd);
	DDX_Text(pDX, IDC_AUTH_RETRIES, m_nMaxAuthRetry);
	DDX_Text(pDX, IDC_AUTH_TIMER, m_nAuthTimer);
	DDX_Text(pDX, IDC_PASSWORD, m_Password);
	DDV_MaxChars(pDX, m_Password, 60);
	DDX_Text(pDX, IDC_USER_NAME, m_UserName);
	DDV_MaxChars(pDX, m_UserName, 60);
	DDX_Check(pDX, IDC_CHECK_VJC, m_bVJC);
	DDX_Check(pDX, IDC_CHECK_DATA_COMP, m_bDataCompression);
	DDX_Check(pDX, IDC_ENABLE_PPP, m_PPP);
	DDX_Check(pDX, IDC_ENABLE_SLIP, m_SLIPEnable);
	DDX_Check(pDX, IDC_CHECK_CSLIP, m_CSLIPEnable);
	DDX_Text(pDX, IDC_SLIP_MAX_TRANSMIT_UNIT, m_nSLIPMTU);
	DDX_Text(pDX, IDC_EDIT_DIAL_NUMBER, m_StrDialNumber);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPPortDlg, CDialog)
	//{{AFX_MSG_MAP(CPPortDlg)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_ENABLE_PPP, OnEnablePPP)
	ON_BN_CLICKED(IDC_ENABLE_SLIP, OnEnableSLIP)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPPortDlg message handlers

BOOL CPPortDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPPortDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_PPP_PORT_CONFIG,HELP_CONTEXT);
	
}

void CPPortDlg::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void CPPortDlg::OnOK()
{
	// TODO: Add extra validation here
	
	if(!UpdateData(TRUE))
		return;
   if(!ValidEditFields())  
      return;
/*   if (m_SLIPEnable && SLIPEnablednewly)
   {
      wsprintf(sLHS,"IP Port%d Address",GetMyID() + 1);
      GetPrivateProfileString ((LPCSTR) IPSectionHeader,
         (LPCSTR) sLHS,NULL, (LPSTR) sRHS,
             sizeof(sRHS), (LPCSTR) IniInWinForm) ;
      if(!(strcmp(sRHS,"0.0.0.0"))) 
      {
         ::MessageBox(GetSafeHwnd(),(LPCSTR) "Make sure to assign a valid WAN Ip Address\
            \nin the IP Port Setup Dialog.", (LPCSTR) "Check Box",MB_OK);
      }
   }*/
	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK);
}

LRESULT CPPortDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CPPortDlg::PostNcDestroy(void)
{
	delete this;
}

BOOL CPPortDlg::ValidEditFields()
{
/* Jo */
   return(TRUE);
}

void CPPortDlg::EnableDisableUsrNameAndPassWd()
{   
	char szLHS[100], szRHS[30];
	BOOL IsDirectConnect;
	int index ;

/* Jo 	wsprintf (szLHS, "WAN Port%d Direct Connect", GetMyID());
	GetPrivateProfileString (WANSectionHeader, szLHS, StrNull, (LPSTR) szRHS,
                               sizeof(szRHS), (LPCSTR)IniInWinForm) ;
    
	IsDirectConnect = (strcmp (szRHS, StrEnabled) == 0); */

	index = GetMyID() ;
	IsDirectConnect = wan_ptr->wan_ports[index].direct_connect ;

}


void CPPortDlg::EnablePPPControls (BOOL pEnable)
{
	// Other controls need to be handled here.
	m_StatDialNumber.EnableWindow (pEnable) ;
	m_EditDialNumber.EnableWindow (pEnable) ;
	m_PPPGrpWnd.EnableWindow (pEnable);
	m_PPPWnd.EnableWindow (pEnable);
	m_DataCompCtrl.EnableWindow (pEnable);
	m_VJCWnd.EnableWindow (pEnable); 
	m_AuthGrpWnd.EnableWindow (pEnable);
	m_StatUserName.EnableWindow (pEnable);
	m_EditUserName.EnableWindow (pEnable);
	m_StatUserPassword.EnableWindow (pEnable);
	m_EditUserPassword.EnableWindow (pEnable);
	m_PerTmrWnd.EnableWindow (pEnable);
	m_AuthTimerWnd.EnableWindow (pEnable);
	m_NumRtryWnd.EnableWindow (pEnable);
	m_AuthRetryWnd.EnableWindow (pEnable); 
	m_radio_pap.EnableWindow (pEnable);
	m_radio_chap.EnableWindow (pEnable);
	m_radio_pap_or_chap.EnableWindow (pEnable);

	if (!pEnable) m_PPP = FALSE;
	if (pEnable) EnableDisableUsrNameAndPassWd() ;
	int index = GetMyID() ;
	BOOL IsDirectConnect = wan_ptr->wan_ports[index].direct_connect ;
	
	UpdateData (FALSE);
}


void CPPortDlg::EnableSLIPControls (BOOL pEnable)
{
	m_SLIPGrpWnd.EnableWindow (pEnable);
	m_SLIPEnableWnd.EnableWindow (pEnable);
	m_CSLIPEnableWnd.EnableWindow (pEnable);
	m_SLIPMTUStatWnd.EnableWindow (pEnable);
	m_SLIPMTUWnd.EnableWindow (pEnable);
	
	if (!pEnable) m_SLIPEnable = FALSE;
	if (!pEnable) m_CSLIPEnable = FALSE;  
	UpdateData (FALSE);
}

void CPPortDlg::OnEnablePPP()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	CMainDlg *maindlg = ((CMainDlg *)(GetParent()->GetParent()));
	if (!maindlg->IsWanPortAnswering(GetMyID()))
		EnableSLIPControls (!m_PPP);
}

void CPPortDlg::OnEnableSLIP()
{
/* Jo No SLIP */
#if 0
   char sLHS[40],sRHS[40];
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	
	CMainDlg *maindlg = ((CMainDlg *)(GetParent()->GetParent()));
   if (m_SLIPEnable)
   {
      wsprintf(sLHS,"IP Port%d Address",GetMyID() + 1);
      GetPrivateProfileString ((LPCSTR) IPSectionHeader,
         (LPCSTR) sLHS,NULL, (LPSTR) sRHS,
             sizeof(sRHS), (LPCSTR) IniInWinForm) ;
      if(!(strcmp(sRHS,"0.0.0.0"))) 
      {
         ::MessageBox(GetSafeHwnd(),(LPCSTR) "Make sure to assign a valid WAN Ip Address\
            \nin the IP Port Setup Dialog.", (LPCSTR) "Check Box",MB_OK);
      }
   }
	if (!maindlg->IsWanPortAnswering(GetMyID()))
		EnablePPPControls (!m_SLIPEnable);
#endif
/* Jo */
}

int CPPortDlg::GetMyID (void)
{
	CPTab *parent = (CPTab *)GetParent();
	int tabcount = parent->tabcount;
	
	for (int index = 0 ; index < tabcount ; index ++)
	{
			if (parent->m_pdlgPP[index] == this)
			{
				return (index);
			}
	}
	ASSERT (FALSE);
	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CPTab Tabdialog


CPTab::CPTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(CPTab::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPTab)
		// NOTE: the ClassWizard will add member initialization here

   // Added by cfp on 28-3-96
	m_nPort = 0 ;

	//}}AFX_DATA_INIT

	// Modified by cfp on 28-3-96

	m_nPort = ppp_ptr->ppp_header.number_of_ports ;
	tabcount = m_nPort ;
	
// Chidanand - 25 Mar 1997		
	if (tabcount > 1 && pParent && ((CMainDlg *)pParent)->IsBackupEnabled())
		tabcount--;
// Chidanand - 25 Mar 1997		

	//Limit the tabcount
	if(tabcount > n_PORTMAX_PPP) tabcount = n_PORTMAX_PPP;

	for(int i=0; i < tabcount ; i++)
		m_pdlgPP[i] = new CPPortDlg(this);
	m_advdlgPP = new CPPPDlg(this);	
}

void CPTab::DoDataExchange(CDataExchange* pDX)
{
	CTabDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPTab, CTabDialog)
	//{{AFX_MSG_MAP(CPTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPTab message handlers
BOOL ConfigRead = FALSE ;

/* Jo */
void CPTab::GetConfig()
{
	char szBuf[200] ;
   // Changes by Sachin
   char TempBuff[30], String1[] = "WAN Port", String2[] = " Auto Answer" ;
	char String3[] = " Direct Connect" ;
   char PortNum[5] ;
	BOOL IsDirectConnect, IsAutoAnswer ;
   char EnableString[] = "enabled", EnableDisable[10] ;
	char szLHS[80], szRHS[130];
	char szPWord[PPP_PASSWORD_SIZE+10];
	char *ch;

	// Get all parameters for PORT
	// Get the BOOL parameters

	for(int i = 0; i < tabcount ; i++)
	{
		m_pdlgPP[i]->m_PPP = ppp_ptr->ppp_ports[i].enabled ;
             
	   IsAutoAnswer = wan_ptr->wan_ports[i].auto_answer ; 
	   IsDirectConnect = wan_ptr->wan_ports[i].direct_connect ;
	   
	   m_pdlgPP[i]->m_EditUserPassword.LimitText (PPP_PASSWORD_SIZE - 1) ;
	   strcpy (szBuf, (char *)ppp_ptr->ppp_ports[i].user_password) ;
	   Decrypt(szBuf, szPWord) ;
	   m_pdlgPP[i]->m_Password = szPWord ;

	   m_pdlgPP[i]->m_EditUserName.LimitText (PPP_USER_NAME_SIZE - 1) ;
	   strcpy (szRHS, (char *)ppp_ptr->ppp_ports[i].user_name) ;
	   m_pdlgPP[i]->m_UserName = szRHS ;

	   m_pdlgPP[i]->m_EditDialNumber.LimitText (LEN_DIAL_NUMBER - 1) ;
	   strcpy (szRHS, (char *)wan_ptr->wan_ports[i].dial_number) ;
	   m_pdlgPP[i]->m_StrDialNumber = szRHS ;

/* Jo 23/06/99 WAN port can be configured to be only Proxy port or 
		only RAS port or both Proxy and RAS port */

	   if (wan_ptr->wan_ports[i].auto_answer == RAS_ONLY)
 	   {
	    	m_pdlgPP[i]->m_EditDialNumber.EnableWindow (FALSE);
	    	m_pdlgPP[i]->m_StatDialNumber.EnableWindow (FALSE);
	   }
	   else
		{
		  	m_pdlgPP[i]->m_EditDialNumber.EnableWindow (TRUE);
		  	m_pdlgPP[i]->m_StatDialNumber.EnableWindow (TRUE);
	   }

	   int auth_type = ppp_ptr->ppp_ports[i].authentication_type ;	
	   if (auth_type == 0) 
			m_pdlgPP[i]->m_radio_pap.SetCheck (1) ;			
	   else
	   	if (auth_type == 1) 
		    m_pdlgPP[i]->m_radio_chap.SetCheck(1) ;
		else
		    m_pdlgPP[i]->m_radio_pap_or_chap.SetCheck(1) ;

   	//Update the Dialog Box fields

		m_pdlgPP[i]->UpdateData(FALSE) ;  

/* Jo 19/02/99 Not reqd. PPP is always enabled irrespective of WAN */
#if 0
		if (!((CMainDlg *)GetParent())->IsWanPortEnabled(i))
		{
			m_pdlgPP[i]->m_StatDialNumber.EnableWindow (FALSE) ;
			m_pdlgPP[i]->m_EditDialNumber.EnableWindow (FALSE) ;
			m_pdlgPP[i]->EnablePPPControls (FALSE) ;
			m_pdlgPP[i]->EnableSLIPControls (FALSE) ;
		}
		else
		{
			BOOL Ans, IPOn, Async ;
			Async = ((CMainDlg *)GetParent())->IsWanPortAsync(i) ;
			Ans = ((CMainDlg *)GetParent())->IsWanPortAnswering(i) ;
			IPOn = ((CMainDlg *)GetParent())->IsIPEnabled(i+1) ;

			if (Async)
			{
				if (Ans)
				{
					if (m_pdlgPP[i]->m_SLIPEnable && IPOn)
						m_pdlgPP[i]->EnableSLIPControls (TRUE) ;
					if (!m_pdlgPP[i]->m_PPP)
						m_pdlgPP[i]->EnablePPPControls (FALSE) ;
				}
				else	//dialing
				{
					if (IPOn && m_pdlgPP[i]->m_SLIPEnable)
					{
					    m_pdlgPP[i]->EnableSLIPControls (TRUE) ;
					    m_pdlgPP[i]->EnablePPPControls (FALSE) ;
					}
					else
					    m_pdlgPP[i]->EnableSLIPControls (FALSE) ;

					if (!m_pdlgPP[i]->m_SLIPEnable)
					    m_pdlgPP[i]->EnablePPPControls (TRUE) ;
					else
						m_pdlgPP[i]->EnablePPPControls (FALSE) ;
					if (!m_pdlgPP[i]->m_PPP)
						m_pdlgPP[i]->EnableSLIPControls (TRUE) ;
				}
			}
			else
			{
			     m_pdlgPP[i]->EnablePPPControls (TRUE) ;
			     m_pdlgPP[i]->EnableSLIPControls (FALSE) ;
			}
		}
#endif 
/* Jo 19/02/99 Not reqd. PPP is always enabled irrespective of WAN */
/* Jo 05/04/99 Enable/Disable PPP controls w.r.t WAN */
		if (!((CMainDlg *)GetParent())->IsWanPortEnabled(i))
		{
			m_pdlgPP[i]->EnablePPPControls (FALSE) ;
		}
		else
			m_pdlgPP[i]->EnablePPPControls (TRUE) ;
	}
   ConfigRead = TRUE ;
}

BOOL CPTab::OnInitDialog()
{
	CDialog::OnInitDialog();

	ConfigRead = FALSE ;
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	char Buf[4][10] ;
	switch (tabcount)
	{
	  case 1:
	    	  strcpy(Buf[0], " &WAN ") ;
		  strcpy(Buf[1], "&Advanced") ;
		  break ;
	  case 2:
	    	  strcpy(Buf[0], "WAN  &1") ;
		  strcpy(Buf[1], "WAN  &2") ;
		  strcpy(Buf[2], "&Advanced") ;
		  break ;
	  case 3:
		  strcpy(Buf[0], "WAN  &1") ;
		  strcpy(Buf[1], "WAN  &2") ;
		  strcpy(Buf[2], "WAN  &3") ; 
	          strcpy(Buf[3], "&Advanced") ;
	          break ;
	default:
		break ;
	}

	//Add the Tabs
	for (int i=0; i < tabcount ; i++)               
		addTabView(m_pdlgPP[i],Buf[i], TRUE, (i==0), 100) ;
	addTabView(m_advdlgPP, Buf[tabcount], TRUE, FALSE, 100) ;
	
	
   //Get all the parameters of all the ports from INI file
	GetConfig() ;
   AfxGetApp()->DoWaitCursor(0) ;

   CTabDialog::OnInitDialog() ;
   CenterWindow() ;                                               
   return FALSE ;
}

/* Jo */
int CPTab::AcceptConfig()
{
   // Write parameters of Ports to INI file

	#define MAX_HANGUP_TIME (5*24*60)
	#define MIN_HANGUP_TIME (1)
	

   // Write the BOOL parameters
	LPCSTR temp ;
	char m_szTempBuf[12] ;
	temp = (char *) m_szTempBuf ;
	
	char field[100] ;
	char TempBuff[100] ;
	char Buf[100] ;
	char Msg[50] ;

	// Added by cfp on 4-4-96
	BOOL fDODWriteZero = FALSE ;
	int i ;

	for (i = 0 ; i < tabcount ; i ++)
	{
	    BOOL OldDialOnDemand ;
	    if (tabcount > 1) 
	    {			//We don't know why! but this is needed
	         switchTab (1) ;			//for the dialog to redraw - Vidy
   	         enableView (1, TRUE) ;
	    }
            switchTab (i) ;
            enableView (i, TRUE) ;
		
	    // Chida - 22 Apr 1997 - Additions for SLIP          
	    CMainDlg *pParent =  (CMainDlg *)GetParent();
            pParent->EnablePPP  (i, m_pdlgPP[i]->m_PPP);

/* SLIP AND CSLIP not supported */
#if 0
	    pParent->EnableSLIP  (i, m_pdlgPP[i]->m_SLIPEnable);
	    pParent->EnableCSLIP (i, m_pdlgPP[i]->m_CSLIPEnable);
#endif
      
	    OldDialOnDemand = ppp_ptr->ppp_ports[i].connection_dod ;

//Vidy 29/10/96. If CIPX is disabled, remove the strings from PPP
//PPP Port0 Option%IPXCP%Compression=3,Auto,Negotiation Not Required,Negotiable,H4,00020F00
//PPP Port0 Remote Option%IPXCP%Compression=3,Auto,Negotiation Not Required,Negotiable,H4,00020F00

// Chida - 23 Apr 1997 - For ASYNC ports, have 000A0000 as control map


	    ppp_ptr->ppp_ports[i].lcp_accm.option_type = 2 ;
	    ppp_ptr->ppp_ports[i].lcp_accm.Auto = 1 ;
	    ppp_ptr->ppp_ports[i].lcp_accm.NegNotReqd = 1 ;
	    ppp_ptr->ppp_ports[i].lcp_accm.Negotiable = 1 ;
	    ppp_ptr->ppp_ports[i].lcp_accm.value_type = H4S ;
	    ppp_ptr->ppp_ports[i].lcp_accm.valid = 1 ;

	    if (((CMainDlg *)GetParent())->IsWanPortAsync(i))
	       	strcpy ((char *)ppp_ptr->ppp_ports[i].lcp_accm.option_value, "000A0000") ;
	    else
	       	strcpy ((char *)ppp_ptr->ppp_ports[i].lcp_accm.option_value, "00000000") ;  

//Vidy 29/10/96. If VJC is disabled, remove the strings from PPP
//PPP Port0 Option%IPCP%Compression=2,Auto,Negotiation Not Required,Negotiable,H4,002d0f00
//PPP Port0 Remote Option%IPCP%Compression=2,Auto,Negotiation Not Required,Negotiable,H4,002d0f00

/*	
	Chida - 23 Apr 1997	
	Change of handling VJC.
		If PPP's VJC is checked, then write string "PPP Port%d VJC=enabled" string in PPP Section
			and also write string "VJC Port%d=enabled" in VJC Section.
		But if PPP's VJC is unchecked, then write only the string "PPP Port%d VJC=disabled" in PPP Section.
*/


		// Chidanand - 25 Mar 1997 - UI Support for PPP Dial Backup 

		char szEncryptPassWd[PPP_PASSWORD_SIZE+10] ;
		char PWord[PPP_PASSWORD_SIZE] ;

		strcpy(PWord, (LPCSTR)m_pdlgPP[i]->m_Password) ;
		Encrypt (PWord, szEncryptPassWd) ;
		strcpy ((char *)ppp_ptr->ppp_ports[i].user_password, szEncryptPassWd) ;
		strcpy ((char *)ppp_ptr->ppp_ports[i].user_name, m_pdlgPP[i]->m_UserName) ;
		strcpy ((char *)wan_ptr->wan_ports[i].dial_number, m_pdlgPP[i]->m_StrDialNumber) ;

		if (m_pdlgPP[i]->m_radio_pap.GetCheck())
		{
		     ppp_ptr->ppp_ports[i].authentication_type = 0 ; 
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_type = 3 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.Auto = 1 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.NegNotReqd = 1 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.Negotiable = 0 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.value_type = H2 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.valid = 1 ;
		     strcpy ((char *)ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_value, "c023") ;
		}
		else 
		 if (m_pdlgPP[i]->m_radio_pap_or_chap.GetCheck ())
		 {
		     ppp_ptr->ppp_ports[i].authentication_type = 2 ; 
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_type = 3 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.Auto = 1 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.NegNotReqd = 1 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.Negotiable = 1 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.value_type = H2 ;
		     ppp_ptr->ppp_ports[i].remote_lcp_authentication.valid = 1 ;
		     strcpy ((char *)ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_value, "c023") ;
		 }
		 else 
		   if (m_pdlgPP[i]->m_radio_chap.GetCheck())
		   {
		       ppp_ptr->ppp_ports[i].authentication_type = 1 ; 
		       ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_type = 3 ;
		       ppp_ptr->ppp_ports[i].remote_lcp_authentication.Auto = 1 ;
		       ppp_ptr->ppp_ports[i].remote_lcp_authentication.NegNotReqd = 1 ;
		       ppp_ptr->ppp_ports[i].remote_lcp_authentication.Negotiable = 0 ;
		       ppp_ptr->ppp_ports[i].remote_lcp_authentication.value_type = H3 ;
		       ppp_ptr->ppp_ports[i].remote_lcp_authentication.valid = 1 ;
		       strcpy ((char *)ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_value, "c22305") ;
		   }
	}
	return TRUE ;
}

void CPTab::OnOK()
{
   for (int i = 0 ; i < tabcount ; i ++)
   {
      if (!m_pdlgPP[i]->ValidEditFields())
      {
         switchTab (i) ;
         enableView (i, TRUE) ;
         return ;
      }
   }
	if (!AcceptConfig())
		return ;
	CTabDialog::OnOK() ;
}

void CPTab::OnCancel()
{
	CTabDialog::OnCancel();
}

CString Str1 = "If you enable the Dial on Demand feature for this port, " ;
CString Str3 = "it will result in the following side effects : \n\n" ;
CString Str4 = "1. Spanning Tree Bridging for this port will\n     be disabled\n" ;
CString Str5 = "2. IP RIP for this port will be disabled\n" ;
CString Str6 = "3. IP RIP Aging for this port will be disabled\n" ;
CString Str7 = "";
CString Str8 = "";
CString Str9 = "Do you want to enable Dial on Demand ?" ;
