// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	ROUCON.CPP
// Description       :	Defines the class behaviors for the application.
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:  Jo 09 Dec 1999
// Modifications     :  Vidy 20/10/95
//								Vidy 7/11/95	added LSL and PPP dependency of WAN
// Jyothi 16/7/98 :  made changes for small proxy
// Jyothi 16/7/98 :  structures used instead of INI files
// Jyothi 			:  09 Dec 1999. If the current version is 2.00(not 1.00 or 1.01) 
//							then don't upgrade. Changed function InitInstance(). Added few variables.
 
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "ctl3d.h"
#include "maindlg.h"
#include "mainfrm.h"
#include "roudoc.h"
#include "rouvw.h"
#include "poweron.h"
#include "wandefs.h"
#include "powercod.h"
#include "tftpread.h"
#include "tftpwrit.h"		// name was longer than 8.3 format. win95 wont work
#include "boot.h"
#include "usersdlg.h"
#include "compress.h"
#include "userscom.h"
#include "userdata.h"
#include "bootvers.h"
#include "tftpdnld.h"
#include "ipprx.h"
#include "ipdnld.h" /* sudha 04 Dec 1998 */
#include "hardware.h"
#include "isddnld.h"
#include "cnffile.h"
#include "readbmp.h"
#include "autodete.h"
#include "ipdetect.h"
#include "tftpif.h"
#include "dot.h"
#include "upgrade.h"
#include "utils.h"

// -------------------------------------------------------------------------
// Global Variable Declarations
// -------------------------------------------------------------------------
// #define PollingTimerID 420	//Vidy removed the redefinition
#define PollingInterval 55	//55mSec timer for polling

#define CodeTimerID	840
#define CodeInterval 65000   // 65 Sec. timer for downloading code.

// #define Max_exitcount 0xff00 //Comeout if packet is not expected.

#define MaxINIString 150   // Maximum length of string in the CNF File.
#define TimerCount 4000    //Used for setting 4 Sec. timer.
#define AutoDetectTimerCount 5000    //Used for setting 5 Sec. timer.
#define AUTODETECT_TIMER	0xfe11
#define WAIT_FOR_BOOT_TIMER	0xfe12
#define MAX_UDP_RESPONSE_TIMER 10000  // Jo timer for 10 secs.
#define  MTR_SETUP   "ProxyServer Setup"

BYTE model;
char LoadPath[FILE_NAME_SIZE] ;				// directory pathname of executable file
char OwnIniFile[FILE_NAME_SIZE] ;			// configuration ini file "SETUP.INI"
char IniInWinForm[FILE_NAME_SIZE] ;			// Router ini file in windows form
char ini_INIFilename[128] ;		//Isdnta ini file in windows form
char IniInRtrWareForm[FILE_NAME_SIZE] ;	// Router ini file in RouterWare form
char IniInRtrWareFormDef[FILE_NAME_SIZE] ;	// Router ini file in RouterWare form
char UDBCompressedDBaseFile[FILE_NAME_SIZE] ;    // Compressed User DBase File
char UDBUnCompressedDBaseFile[FILE_NAME_SIZE] ; //  Uncompressed User DBase File
char LogFileName[FILE_NAME_SIZE];
char RouterBitmapFile[128] ;    // Jo Router bitmap file
char TempFile[128] ;    		  // Jo Temp file to check if configuration has changed
char TempUpgradeFile[128] ; 	  // Jo Temp file for Upgrade

char EtherNetAddr[13] ;			// ethernet address - printable string
BOOL LookForTargetOnly ;
BOOL DownloadSetupOnly ;
BOOL DefaultSetup = FALSE; /* Jo 13/11/98 */
BOOL ModifyIPAddress = FALSE ; /* Jo 20/1/99 */
CString MessageString ;
CString WindowText ;

LPCSTR StrEnabled = "enabled" ;
LPCSTR StrDisabled = "disabled" ;
LPCSTR StrNull = "" ;

extern LPCSTR MainMsgHeader ;

BOOL DontReadConfiguration = FALSE ;
int CommandLineArgument = 0 ;
int reset_needed = 0 ;
int ShowRas = 1 ;
BOOL IsPortIP = FALSE ;		// is true if we are going to use TFTP
char TFTPPutLocalFileName[FILE_NAME_SIZE] ;
char TFTPPutRemoteFileName[TFTP_NAME_SIZE] ;
char TFTPGetLocalFileName[FILE_NAME_SIZE] ;
char TFTPGetRemoteFileName[TFTP_NAME_SIZE] ;

UINT NumberOfPorts = 2 ; // Just in case no assignment takes place

/* 9/7/97 chetan */
BOOL IsLanTalker = FALSE ;
BOOL IsRF200 = FALSE ;
/* 9/7/97 chetan */


#ifdef NEW_BOOT_2
DWORD CodeLoadAddress ;
DWORD CodeStartAddress ;
DWORD FlCodeStartAddress ;

char *DialogTitleFormat = "%s - %s";

TFTPCodeBurnStruct TFTPCodeAddressDetails ;
#endif /* NEW_BOOT_2 */

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


// If these sizes are changed same changes
// should be carried out in \roucon\tftp\tftpcomp.c
// and in mtrouter.bin
#define MAX_READ_SIZE (8 * 1024) 
#define MAX_UNCOMP_SIZE (10 * 1024)

// Jo 09 Dec 1999 If the current version is 2.00(not 1.00 or 1.01) then don't upgrade...
int RebootForUpgrade = FALSE ;
// ...Jo 09 Dec 1999 If the current version is 2.00(not 1.00 or 1.01) then don't upgrade

/* Jo */

extern CNF_IP  *ip_ptr ;
extern CNF_PPP *ppp_ptr ;
extern CNF_WAN *wan_ptr ;
extern CNF_PROXY_HEADER *proxy_header_ptr ;
extern CNF_DHCP_HEADER  *dhcp_header_ptr ;
extern CNF_UPGRADE_IP *upgrade_ip_ptr ;
extern CNF_WAN *upgrade_wan_ptr ;
extern CNF_UPGRADE_PPP *upgrade_ppp_ptr ;
extern CNF_UPGRADE_PROXY_HEADER *upgrade_proxy_header_ptr ;
extern CNF_UPGRADE_DHCP_HEADER *upgrade_dhcp_header_ptr ; 

extern DetectSuccess ;
extern int ras_is_enabled() ;
CDotDecimal dotdecimal_configured_ip_address ;
/* Jo */

// Jo 09 Dec 1999 If the current version is 2.00(not 1.00 or 1.01) then don't upgrade...
extern char	FirmwareVersion[25] ;
// ...Jo 09 Dec 1999 If the current version is 2.00(not 1.00 or 1.01) then don't upgrade

/////////////////////////////////////////////////////////////////////////////
// CRouconApp

BEGIN_MESSAGE_MAP(CRouconApp, CWinApp)
	//{{AFX_MSG_MAP(CRouconApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRouconApp construction

CRouconApp::CRouconApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

int	CRouconApp::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	HWND	WindowWithFocus;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	WindowWithFocus = GetFocus();

	Ret_val = AfxGetMainWnd()->MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);

	SetFocus(WindowWithFocus);

	return Ret_val;

}


// vidy added this 19th Aug 95
void	RouconCrossCheckPPP(void)		
{
	int	port, number_of_enabled_wan_ports;

/* Jo WAN is always Asynchronous */	
#if 0
	char	szBuf[30];
	char	WANPortStr[80], LSLPortStr[80], PPPPortStr[80];
	char	PPPAsyncStr[80];
	char	WANAsyncStr[80];

	strcpy(PPPAsyncStr, "PPP Port0 Asynchronous Link");
	strcpy(WANAsyncStr, "WAN Port0 ASYNC");  

	for (port = 0; port < 3; port++) {
		// make string for the proper port number
		PPPAsyncStr[8] = '0' + port;
		WANAsyncStr[8] = '0' + port;
		// read the port WAN async type
		GetPrivateProfileString(WANSectionHeader,
			(LPCSTR) WANAsyncStr, StrNull,(LPSTR) szBuf ,sizeof(szBuf),
			(LPCSTR) IniInWinForm);
		if (szBuf[0]) {
			WritePrivateProfileString(PPPSectionHeader, 
				(LPCSTR) PPPAsyncStr, (LPCSTR) szBuf, (LPCSTR) IniInWinForm);
		}
	}

#endif
/* Jo */

	/* we need to update the LSL section and PPP section setup
	based on the WAN port setup, for number of ports and their
	enabled/disabled state, this is for SNMP to report correctly
	7.11.95*/

	number_of_enabled_wan_ports = 0;

	for (port = 0; port < 3; port++) 
	{
	//Vidy 14/12/98
	/* all PPP ports to be enabled even if WAN is disabled */
		ppp_ptr->ppp_ports[port].enabled = TRUE;
#if 0
//Vidy 14/12/98
//		ppp_ptr->ppp_ports[port].enabled = wan_ptr->wan_ports[port].enabled ;
		if (wan_ptr->wan_ports[port].enabled)
		    number_of_enabled_wan_ports++ ;
#endif
	}
}

/* Jo 03/08/98 Not reqd for Small Proxy */

#if 0

// -------------------------------------------------------------------------
// Function 			:	CRouconApp::RAWriteRouterINI()
// Arguments			:  None.
// Synopsis 			:  Converts Windows INI to MTRouter CNF, only if the Windows 
//                  		INI is changed after Reading.
// Returns  			:  TRUE if it is changed, else FALSE.
// Globals Affected  :  None.
// -------------------------------------------------------------------------
BOOL CRouconApp::RAWriteRouterINI()
{

   char* pInFileName = IniInWinForm ; 
	CStdioFile input;
	if(!input.Open( pInFileName, CFile::modeRead | CFile::typeText ))
        {
       		DoMessageBox("Could not open `ROUCON.INI'", MB_OK, 0);
	        return(FALSE);
	}

	char* pOutFileName = IniInRtrWareFormDef;
	CStdioFile output( pOutFileName, CFile::modeCreate | CFile::modeWrite 
						| CFile::typeBinary );  //VIDY changed from TXT to BIN

	char* pRtrCnf = IniInRtrWareForm;
	CStdioFile output_rtrcnf( pRtrCnf, CFile::modeCreate | CFile::modeWrite 
						| CFile::typeBinary );

	char sBuf[MaxINIString];
	char *ch, *ptr;
	char pBuf[MaxINIString];

	while((input.ReadString(sBuf , MaxINIString)) != NULL)
	{
		// PINTO 28/1/97
		// There must not be any "0d"s in the sBuf by now
		while (ptr = strchr (sBuf, '\r'))
		{
			strcpy (ptr, ptr + 1) ;
		}
		// To remove blank lines
		if (sBuf[0] == '\n')
			continue ;
		// PINTO 28/1/97

		if((ch = strchr(sBuf,(int) '[')) != NULL) //Check for section header
		{
			*ch = '\0';
			strcpy(pBuf,sBuf);
			strcat(pBuf,"[[ ");
			strcpy(sBuf,++ch);
			if((ch = strchr(sBuf,(int) ']')) != NULL)
			{
				*ch = '\0' ;
				strcat(pBuf,sBuf);
				strcat(pBuf," = Section Start ]]");     //Change the section header
				strcat(pBuf,++ch);
				strcpy(sBuf, pBuf);
			}
			else
			{
				strcat(pBuf,sBuf);
				strcpy(sBuf,pBuf);      
			}
		}                      
		else
		{
			// Changes by Vidy for PPP local and remote options 22nd Sept
			if ( !wildstrcmp("PPP Port? Option%*",sBuf) ||
							!wildstrcmp("PPP Port? Remote Option%*",sBuf)) {
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// to the RHS 
				// <words>%<words>%<words>=<words> ==> 
				// <words>=<words>,<words>,<words>
				char *ChrPtr;

				ChrPtr = strchr(sBuf,(int) '%');
				*ChrPtr++ = '=';
				ChrPtr = strchr(ChrPtr,(int) '%');
				*ChrPtr++ = ',';
				ChrPtr = strchr(ChrPtr,(int) '=');
				*ChrPtr = ',';
			}
			if ( !wildstrcmp("PPP Port? RAS Option%*",sBuf) ||
							!wildstrcmp("PPP Port? RAS Remote Option%*",sBuf)) 
			{
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// to the RHS 
				// <words>%<words>%<words>=<words> ==> 
				// <words>=<words>,<words>,<words>
				char *ChrPtr;

				ChrPtr = strchr(sBuf,(int) '%');
				*ChrPtr++ = '=';
				ChrPtr = strchr(ChrPtr,(int) '%');
				*ChrPtr++ = ',';
				ChrPtr = strchr(ChrPtr,(int) '=');
				*ChrPtr = ',';
			}

			if((ch = strstr(sBuf,"Port")) != NULL)
			{
				ch += 4;		//Look after "Port"
				int c = *ch;
				if((c >= 0x30) && (c <= 0x39))	//Check for digit.
				{
					*ch = '\0' ;                  
					strcpy(pBuf, sBuf);
					int c2 = *(++ch);
					BOOL flag = FALSE;
					if((c2 >= 0x30) && (c2 <= 0x39))	//Check for digit.
					{
						ch++;
						flag = TRUE ;
					}       
					strcpy(sBuf,ch);        
					if((ch = strchr(sBuf, (int) '=')) != NULL)
					{
						*ch = '\0' ;
						strcat(pBuf, sBuf);
						strcat(pBuf, "=");
						char temp[4];
						temp[0] = flag ? c  : '0';
						temp[1] = flag ? c2 :  c;
						temp[2] = ',';
						temp[3] = '\0' ;
						strcat(pBuf, temp);
						strcat(pBuf, ++ch);
						strcpy(sBuf, pBuf);
					}       
				}
			}       
		// Put " = " inplace of "="
			if((ch = strchr(sBuf,(int) '=')) != NULL)
			{
				*ch = '\0';
				strcpy(pBuf, sBuf);
				strcat(pBuf, " = ");
				strcat(pBuf, ++ch);
				strcpy(sBuf, pBuf);
			}
		}
		output.WriteString(sBuf);               
		output_rtrcnf.WriteString(sBuf);               
	}
	output.Write("\0\0", 2);
	output_rtrcnf.Write("\0\0", 2);
	return (TRUE);
}       //End of WriteRouterINI

// -------------------------------------------------------------------------
// Function        :       CRouconApp::WriteWinINI()
// Arguments       :       None.
// Synopsis        :       Converts Router CNF to Windows INI.
// Returns         :       None.
// -------------------------------------------------------------------------
BOOL CRouconApp::RAWriteWinINI()
{
	char Buf[80];

	char *pInFileName = IniInRtrWareFormDef ;
	CStdioFile input ;
	if (!input.Open (pInFileName, CFile::modeRead | CFile::typeText ))
	{
		sprintf(Buf, "Couldn't open file %s", pInFileName);
		DoMessageBox (Buf, MB_OK, 0) ;
		return FALSE ;
	}
									   
	char *pOutFileName = IniInWinForm ;
//	CStdioFile output (pOutFileName, CFile::modeCreate | CFile::modeWrite 
//				| CFile::typeText ) ;
	CStdioFile output;
	if ( !output.Open(pOutFileName, CFile::modeCreate | CFile::modeWrite 
											| CFile::typeText ))
	{
		sprintf(Buf, "Couldn't open file %s", pOutFileName);
		DoMessageBox (Buf, MB_OK, 0) ;
		return FALSE ;
	}

	char sBuf[MaxINIString] ;
	char *ch ;
	char *pBuf = new char[MaxINIString] ;
		
	while ((input.ReadString (sBuf, MaxINIString)) != NULL)
	{
		if ((ch = strchr (sBuf, (int) '[')) != NULL)    //Check for section header
		{
			*(++ ch) = '\0' ;
			strcpy (pBuf, sBuf) ;
			ch += 2 ;
			strcpy (sBuf, ch) ;
			if ((ch = strchr (sBuf, (int) '=')) != NULL)
			{
				*(-- ch) = '\0' ;
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, ++ ch) ;
				ch = strstr (sBuf, "]]") ;
				if (ch != NULL)
				{
					strcat (pBuf, ++ ch) ;
					strcpy (sBuf, pBuf) ;
				}
			}
			else
			{
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, pBuf) ;
			}
		}
		else
		{
			if ((ch = strstr (sBuf, "Virtual Port to DLCI")) != NULL)
			{
				ch += 20;       //Look after "Virtual Port to DLCI"
				char *ch2 ;
				if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
				{
					*ch = '\0';
					strcpy(pBuf, sBuf);
					strcat(pBuf, " ");
					ch2++;
					char storing[2];
					storing[0] = *(ch2 +4);
					storing[1] = '\0';
					*(ch2 + 4) = '\0';
					strcat(pBuf, ch2);
					ch2 --;
					*ch2 = '\0';
					strcat(pBuf, " ");
					ch ++;
					strcat(pBuf, ch);
					strcat(pBuf, storing);
					strcpy(sBuf, pBuf);
				}
			}

			if ((ch = strstr (sBuf, "Port")) != NULL)
			{   
				char *ch2 ;
				if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
				{
					ch += 4 ;                               //Look after "Port"
					*ch = '\0' ;
					strcpy (pBuf, sBuf) ;
					strcpy (sBuf, ++ ch) ;
					ch2 = strchr (sBuf, (int) ',') ;
					if (ch2 != NULL)
					{       
						*ch2 = '\0' ;
						if ((*(ch2-2)) == '0')
							strcat (pBuf, (ch2-1)) ;
						else
							strcat (pBuf, (ch2-2)) ;
						*(ch2-2) = '\0' ;
						strcat (pBuf, " ") ;         
						strcat (pBuf, sBuf) ;
						strcat (pBuf, ++ ch2) ;
						strcpy (sBuf, pBuf) ;
					}       
				}                   
			}
			else
			{
				if ((ch = strstr (sBuf, "Channel")) != NULL)    
				{   
					char *ch2 ;
					if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
					{
						ch += 7 ;                               //Look after "Channel"
						*ch = '\0' ;
						strcpy (pBuf, sBuf) ;
						strcpy (sBuf, ++ ch) ;
						ch2 = strchr (sBuf, (int) ',') ;
						if (ch2 != NULL)
						{       
							*ch2 = '\0' ;
							if ((*(ch2-2)) == '0')
								strcat (pBuf, (ch2-1)) ;
							else
								strcat (pBuf, (ch2-2)) ;
							*(ch2-2) = '\0' ;
							strcat (pBuf, " ") ;         
							strcat (pBuf, sBuf) ;
							strcat (pBuf, ++ ch2) ;
							strcpy (sBuf, pBuf) ;
						}       
					}                   
				}
				else
				{
					if ((ch = strstr (sBuf, "Frame Relay DLCI")) != NULL)
					{
						char *ch1;
						if ((ch1 = strstr (sBuf, "Number")) != NULL)
						{
							ch1 += 6;        // add 6 for the number
							*ch1 = '\0';
							strcpy(pBuf, sBuf);
							ch1 += 3;
							char store_temp[3];
							store_temp[0] = *ch1;
							store_temp[1] = *(ch1 + 1);
							store_temp[2] = '\0';
							strcat(pBuf, store_temp);
							strcat(pBuf, " = ");
							ch1 += 3; // two for numbers and one for comma
							strcat(pBuf, ch1);
							strcpy(sBuf, pBuf);
						}
						else
						{
							ch += 16;               // add 16 for "Frame Relay DLCI"
							*ch = '\0';
							ch++;
							strcpy(pBuf, sBuf);
							if ((ch1 = strchr (ch, (int) '=')) != NULL)
							{
								ch1 ++;
								*(ch1 + 5) = '\0';
								strcat(pBuf, ch1);
								strcat(pBuf, " ");
								*ch1 = '\0';
								strcat(pBuf, ch);
								strcat(pBuf, " ");
								ch1 += 6;
								strcat(pBuf, ch1);
								strcpy(sBuf, pBuf);
							}
						}
					}
				}
			}
			// Put "=" in place of " = "
			if ((ch = strchr (sBuf, (int) '=')) != NULL)
			{
				*(ch - 1) = '\0';
				strcpy (pBuf, sBuf) ;
				strcat (pBuf, "=") ;
				ch += 2 ;
				strcat (pBuf, ch) ;
				strcpy (sBuf, pBuf) ;
			}
			// Changes by Vidy for PPP local and remote options 22nd Sept
			if ( !wildstrcmp ("PPP Port? Option=*", sBuf) ||
							!wildstrcmp ("PPP Port? Remote Option=*", sBuf))
			{
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// also to the LHS for making unique LHS strings for
				// Windows ini APIs to work

				// <words>=<words>,<words>,<words> ==>
				// <words>%<words>%<words>=<words> 
				char *ChrPtr ;

				ChrPtr = strchr (sBuf, (int) '=') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr = '=' ;
			}
			if ( !wildstrcmp ("PPP Port? RAS Option=*", sBuf) ||
							!wildstrcmp ("PPP Port? RAS Remote Option=*", sBuf))
			{
				// <words>=<words>,<words>,<words> ==>
				// <words>%<words>%<words>=<words> 
				char *ChrPtr ;

				ChrPtr = strchr (sBuf, (int) '=') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr = '=' ;
			}
		}
		output.WriteString (sBuf) ;
	}
	output.Close() ;
//	output.Open (pOutFileName, CFile::modeRead | CFile::typeText) ; 
	output.Open (pOutFileName, CFile::modeRead | CFile::typeText) ; 
	output.Flush() ;
	output.Close() ;

	WritePrivateProfileString(NULL, NULL, NULL, (LPCSTR) IniInWinForm);

	delete [] pBuf ;  
	return TRUE ;
}       // End of WriteWinINI

#endif
/* Jo 03/08/98 Not reqd for Small Proxy */

/////////////////////////////////////////////////////////////////////////////
// The one and only CRouconApp object

CRouconApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CRouconApp initialization

void CRouconApp::GetBootVersionAndSetVars (CWnd *pWnd, char *VerStr)
{
	if (GetBootVersion (pWnd, VerStr) == TRUE)
	{
#if 0
		switch (model)
		{
		case MODEL_MTSR3_200:
					WindowText = "MTPSR3_200" ;
				   strcat (IniInRtrWareFormDef, DEF_CNF_File) ;  // Mtrouter.Cnf
					break;
		case MODEL_MTSR3_201:
					WindowText = "MTPSR3_201" ;
				   strcat (IniInRtrWareFormDef, DEF_DSU_File) ;  // Def File for DSU
					break;
		case MODEL_MTSR1_202ST:
					WindowText = "MTPSR1_202ST" ;
				   strcat (IniInRtrWareFormDef, DEF_ISDN_File) ;  // ISDN Def file
					break;
		case MODEL_MTSR1_202NT:
					WindowText = "MTPSR1_202NT" ;
				   strcat (IniInRtrWareFormDef, DEF_ISDN_File) ;  // ISDN Def file
					break;
		default:
					WindowText = "ProxyServer 2.00" ;
				   strcat (IniInRtrWareFormDef, DEF_CNF_File) ;  // Mtrouter.Cnf
					break;
		}
#endif

	   strcpy (IniInRtrWareFormDef, LoadPath) ;
		WindowText = "ProxyServer 2.00" ;
 	  strcat (IniInRtrWareFormDef, DEF_CNF_File) ;  // Mtrouter.Cnf
	}
}

/* Jo 06/09/99 Added for Upgrade */
BOOL CRouconApp::UpGradeProxy()
{
	int i ;
	ULONG offset, temp_offset, return_offset, SizeToRealloc ;
	CNF_PROXY_PORT *proxy_port_ptr, *upgrade_proxy_port_ptr ;
	CNF_PROXY_USER_DEFINED_APPLICATION *upgrade_proxy_user_defined_application_ptr, *proxy_user_defined_application_ptr ;
	CNF_PROXY_VIRTUAL_SERVER *upgrade_proxy_virtual_ptr, *proxy_virtual_ptr ;
	CNF_PROXY_ADDRESS_INFO *upgrade_proxy_global_address_ptr, *upgrade_proxy_forbidden_sites_ptr, *upgrade_proxy_restricted_clients_ptr ;
	CNF_PROXY_ADDRESS_INFO *proxy_global_address_ptr, *proxy_forbidden_sites_ptr, *proxy_restricted_clients_ptr ;
	CNF_PROXY_STATIC_INFO *upgrade_static_mapping_ptr, *static_mapping_ptr ;
	CNF_PROXY_DYNAMIC_INFO *upgrade_dynamic_mapping_ptr, *dynamic_mapping_ptr ;
	CNF_PROXY_FILTER *upgrade_proxy_filter_ptr, *proxy_filter_ptr ;
	CNF_PROXY_APP *upgrade_proxy_restricted_application_ptr, *proxy_restricted_application_ptr ;
	CNF_PROXY_MAC_ADDRESS_INFO *upgrade_proxy_mac_address_ptr, *proxy_mac_address_ptr ;
	CNF_PROXY_DOMAIN_NAME_INFO *upgrade_proxy_domain_name_ptr, *proxy_domain_name_ptr ;
	CNF_PROXY_PORT *upgrade_proxy_port0_ptr, *upgrade_proxy_port1_ptr ;
	CNF_PROXY_PORT *upgrade_proxy_port2_ptr, *upgrade_proxy_port3_ptr ;
	CNF_DHCP_ADDRESS_RANGE *upgrade_dhcp_address_range_ptr, *dhcp_address_range_ptr ;
	CNF_BINDING_INFO *upgrade_dhcp_binding_ptr, *dhcp_binding_ptr ;

	if (!Read_from_bmp_to_struct(RouterBitmapFile))
	{
		::MessageBox (NULL, "Error : Could Not Read Configuration", "", MB_OK) ;
		return FALSE ;
	}
	if (!Read_from_old_bmp_to_temp_struct(TempUpgradeFile))
	{
		::MessageBox (NULL, "Error : Could Not Read Configuration", "", MB_OK) ;
		return FALSE ;
	}

	ip_ptr->ip_header.number_of_ports =	upgrade_ip_ptr->ip_header.number_of_ports ;
	ip_ptr->ip_header.dns_enabled = upgrade_ip_ptr->ip_header.dns_enabled ;
	ip_ptr->ip_header.primary_address = upgrade_ip_ptr->ip_header.primary_address ;
	ip_ptr->ip_header.secondary_address = upgrade_ip_ptr->ip_header.secondary_address ;

   for (i = 0; i < ip_ptr->ip_header.number_of_ports; i++)
   {
		ip_ptr->ip_ports[i].isp_assigns_address = upgrade_ip_ptr->ip_ports[i].isp_assigns_address ;
		ip_ptr->ip_ports[i].bootp = upgrade_ip_ptr->ip_ports[i].bootp ;
		ip_ptr->ip_ports[i].ip_address = upgrade_ip_ptr->ip_ports[i].ip_address ;
		ip_ptr->ip_ports[i].subnet_mask = upgrade_ip_ptr->ip_ports[i].subnet_mask ;
   }

	wan_ptr->wan_header.enabled = upgrade_wan_ptr->wan_header.enabled ;
	wan_ptr->wan_header.number_of_ports = upgrade_wan_ptr->wan_header.number_of_ports ;
	
	for (i = 0; i < wan_ptr->wan_header.number_of_ports; i++)
	{
		wan_ptr->wan_ports[i].enabled = upgrade_wan_ptr->wan_ports[i].enabled ;
		wan_ptr->wan_ports[i].speed = upgrade_wan_ptr->wan_ports[i].speed ;
		strcpy ((char *) wan_ptr->wan_ports[i].modem_type, (char *) upgrade_wan_ptr->wan_ports[i].modem_type) ;
		strcpy ((char *) wan_ptr->wan_ports[i].modem_init_string1, (char *) upgrade_wan_ptr->wan_ports[i].modem_init_string1) ;
		strcpy ((char *) wan_ptr->wan_ports[i].modem_init_string2, (char *) upgrade_wan_ptr->wan_ports[i].modem_init_string2) ;
		strcpy ((char *) wan_ptr->wan_ports[i].modem_init_string3, (char *) upgrade_wan_ptr->wan_ports[i].modem_init_string3) ;
		strcpy ((char *) wan_ptr->wan_ports[i].modem_init_string4, (char *) upgrade_wan_ptr->wan_ports[i].modem_init_string4) ;
		strcpy ((char *) wan_ptr->wan_ports[i].modem_init_string5, (char *) upgrade_wan_ptr->wan_ports[i].modem_init_string5) ;
		strcpy ((char *) wan_ptr->wan_ports[i].dial_prefix, (char *) upgrade_wan_ptr->wan_ports[i].dial_prefix) ;
		strcpy ((char *) wan_ptr->wan_ports[i].dial_number, (char *) upgrade_wan_ptr->wan_ports[i].dial_number) ;
		strcpy ((char *) wan_ptr->wan_ports[i].dial_suffix, (char *) upgrade_wan_ptr->wan_ports[i].dial_suffix) ;
		strcpy ((char *) wan_ptr->wan_ports[i].ring_message, (char *) upgrade_wan_ptr->wan_ports[i].ring_message) ;
		strcpy ((char *) wan_ptr->wan_ports[i].hangup_string, (char *) upgrade_wan_ptr->wan_ports[i].hangup_string) ;
		strcpy ((char *) wan_ptr->wan_ports[i].ok_message, (char *) upgrade_wan_ptr->wan_ports[i].ok_message) ;
		strcpy ((char *) wan_ptr->wan_ports[i].no_carrier_message, (char *) upgrade_wan_ptr->wan_ports[i].no_carrier_message) ;
		strcpy ((char *) wan_ptr->wan_ports[i].error_message, (char *) upgrade_wan_ptr->wan_ports[i].error_message) ;
		strcpy ((char *) wan_ptr->wan_ports[i].no_dial_tone_message, (char *) upgrade_wan_ptr->wan_ports[i].no_dial_tone_message) ;
		strcpy ((char *) wan_ptr->wan_ports[i].busy_message, (char *) upgrade_wan_ptr->wan_ports[i].busy_message) ;
		strcpy ((char *) wan_ptr->wan_ports[i].no_answer_message, (char *) upgrade_wan_ptr->wan_ports[i].no_answer_message) ;
		strcpy ((char *) wan_ptr->wan_ports[i].response_string, (char *) upgrade_wan_ptr->wan_ports[i].response_string) ;
	}
	
	ppp_ptr->ppp_header.enabled = upgrade_ppp_ptr->ppp_header.enabled ;
	ppp_ptr->ppp_header.number_of_ports = upgrade_ppp_ptr->ppp_header.number_of_ports ;

	for (i = 0; i < ppp_ptr->ppp_header.number_of_ports; i++)
	{
		ppp_ptr->ppp_ports[i].enabled = upgrade_ppp_ptr->ppp_ports[i].enabled ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].user_name, (char *) upgrade_ppp_ptr->ppp_ports[i].user_name) ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].user_password, (char *) upgrade_ppp_ptr->ppp_ports[i].user_password) ;

// LCP EPD

		ppp_ptr->ppp_ports[i].lcp_epd.option_type = upgrade_ppp_ptr->ppp_ports[i].lcp_epd.option_type ;
		ppp_ptr->ppp_ports[i].lcp_epd.Auto = upgrade_ppp_ptr->ppp_ports[i].lcp_epd.Auto ;
		ppp_ptr->ppp_ports[i].lcp_epd.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].lcp_epd.NegNotReqd ;
		ppp_ptr->ppp_ports[i].lcp_epd.Negotiable = upgrade_ppp_ptr->ppp_ports[i].lcp_epd.Negotiable ;
		ppp_ptr->ppp_ports[i].lcp_epd.value_type = upgrade_ppp_ptr->ppp_ports[i].lcp_epd.value_type ;
		ppp_ptr->ppp_ports[i].lcp_epd.valid = upgrade_ppp_ptr->ppp_ports[i].lcp_epd.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].lcp_epd.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].lcp_epd.option_value) ;

// REMOTE LCP EPD

		ppp_ptr->ppp_ports[i].remote_lcp_epd.option_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_epd.option_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_epd.Auto = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_epd.Auto ;
		ppp_ptr->ppp_ports[i].remote_lcp_epd.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_epd.NegNotReqd ;
		ppp_ptr->ppp_ports[i].remote_lcp_epd.Negotiable = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_epd.Negotiable ;
		ppp_ptr->ppp_ports[i].remote_lcp_epd.value_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_epd.value_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_epd.valid = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_epd.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].remote_lcp_epd.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].remote_lcp_epd.option_value) ;

// LCP MRRU

		ppp_ptr->ppp_ports[i].lcp_mrru.option_type = upgrade_ppp_ptr->ppp_ports[i].lcp_mrru.option_type ;
		ppp_ptr->ppp_ports[i].lcp_mrru.Auto = upgrade_ppp_ptr->ppp_ports[i].lcp_mrru.Auto ;
		ppp_ptr->ppp_ports[i].lcp_mrru.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].lcp_mrru.NegNotReqd ;
		ppp_ptr->ppp_ports[i].lcp_mrru.Negotiable = upgrade_ppp_ptr->ppp_ports[i].lcp_mrru.Negotiable ;
		ppp_ptr->ppp_ports[i].lcp_mrru.value_type = upgrade_ppp_ptr->ppp_ports[i].lcp_mrru.value_type ;
		ppp_ptr->ppp_ports[i].lcp_mrru.valid = upgrade_ppp_ptr->ppp_ports[i].lcp_mrru.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].lcp_mrru.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].lcp_mrru.option_value) ;

// REMOTE LCP MRRU

		ppp_ptr->ppp_ports[i].remote_lcp_mrru.option_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mrru.option_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_mrru.Auto = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mrru.Auto ;
		ppp_ptr->ppp_ports[i].remote_lcp_mrru.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mrru.NegNotReqd ;
		ppp_ptr->ppp_ports[i].remote_lcp_mrru.Negotiable = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mrru.Negotiable ;
		ppp_ptr->ppp_ports[i].remote_lcp_mrru.value_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mrru.value_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_mrru.valid = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mrru.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].remote_lcp_mrru.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mrru.option_value) ;

// IPCP DNS ADDRESS1

		ppp_ptr->ppp_ports[i].ipcp_dns_address1.option_type = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address1.option_type ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address1.Auto = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address1.Auto ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address1.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address1.NegNotReqd ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address1.Negotiable = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address1.Negotiable ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address1.value_type = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address1.value_type ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address1.valid = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address1.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].ipcp_dns_address1.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address1.option_value) ;

// IPCP DNS ADDRESS2

		ppp_ptr->ppp_ports[i].ipcp_dns_address2.option_type = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address2.option_type ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address2.Auto = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address2.Auto ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address2.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address2.NegNotReqd ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address2.Negotiable = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address2.Negotiable ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address2.value_type = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address2.value_type ;
		ppp_ptr->ppp_ports[i].ipcp_dns_address2.valid = upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address2.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].ipcp_dns_address2.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address2.option_value) ;

// IPCP IP ADDRESS
		
		ppp_ptr->ppp_ports[i].ipcp_ip_address.option_type = upgrade_ppp_ptr->ppp_ports[i].ipcp_ip_address.option_type ;
		ppp_ptr->ppp_ports[i].ipcp_ip_address.Auto = upgrade_ppp_ptr->ppp_ports[i].ipcp_ip_address.Auto ;
		ppp_ptr->ppp_ports[i].ipcp_ip_address.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].ipcp_ip_address.NegNotReqd ;
		ppp_ptr->ppp_ports[i].ipcp_ip_address.Negotiable = upgrade_ppp_ptr->ppp_ports[i].ipcp_ip_address.Negotiable ;
		ppp_ptr->ppp_ports[i].ipcp_ip_address.value_type = upgrade_ppp_ptr->ppp_ports[i].ipcp_ip_address.value_type ;
		ppp_ptr->ppp_ports[i].ipcp_ip_address.valid = upgrade_ppp_ptr->ppp_ports[i].ipcp_ip_address.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].ipcp_ip_address.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].ipcp_ip_address.option_value) ;
	}

	proxy_header_ptr->number_of_ports = upgrade_proxy_header_ptr->number_of_ports ;
	proxy_header_ptr->enabled = upgrade_proxy_header_ptr->enabled ;

	dhcp_header_ptr->dhcp_server_enabled = upgrade_dhcp_header_ptr->dhcp_server_enabled ;
	
	if (!Write_from_struct_to_bmp (RouterBitmapFile, FALSE))
	{
		::MessageBox (NULL, "Error : Could not write default setup", 
			(LPCSTR) "Configuration Write", MB_OK | MB_ICONHAND) ;
		return FALSE ;
	}

	for (i = 0; i < wan_ptr->wan_header.number_of_ports; i++)
	{
		wan_ptr->wan_ports[i].script_enabled = upgrade_wan_ptr->wan_ports[i].script_enabled ;
		wan_ptr->wan_ports[i].restart_script_on_comm_failure = upgrade_wan_ptr->wan_ports[i].restart_script_on_comm_failure ;
		wan_ptr->wan_ports[i].direct_connect = upgrade_wan_ptr->wan_ports[i].direct_connect ;
		wan_ptr->wan_ports[i].auto_answer = upgrade_wan_ptr->wan_ports[i].auto_answer ;
	}

	ppp_ptr->ppp_header.need_to_dial_out_initially = upgrade_ppp_ptr->ppp_header.need_to_dial_out_initially ;
	ppp_ptr->ppp_header.printf = upgrade_ppp_ptr->ppp_header.printf ;
	ppp_ptr->ppp_header.printf_LCP = upgrade_ppp_ptr->ppp_header.printf_LCP ;
	ppp_ptr->ppp_header.printf_NCP = upgrade_ppp_ptr->ppp_header.printf_NCP ;
	ppp_ptr->ppp_header.printf_alarm = upgrade_ppp_ptr->ppp_header.printf_alarm ;

	for (i = 0; i < ppp_ptr->ppp_header.number_of_ports; i++)
	{
		ppp_ptr->ppp_ports[i].connection_dod = upgrade_ppp_ptr->ppp_ports[i].connection_dod ;
		ppp_ptr->ppp_ports[i].hangup_time = upgrade_ppp_ptr->ppp_ports[i].hangup_time ;
		ppp_ptr->ppp_ports[i].ip = upgrade_ppp_ptr->ppp_ports[i].ip ;
		ppp_ptr->ppp_ports[i].authentication_type = upgrade_ppp_ptr->ppp_ports[i].authentication_type ;

// LCP ACCM

		ppp_ptr->ppp_ports[i].lcp_accm.option_type = upgrade_ppp_ptr->ppp_ports[i].lcp_accm.option_type ;
		ppp_ptr->ppp_ports[i].lcp_accm.Auto = upgrade_ppp_ptr->ppp_ports[i].lcp_accm.Auto ;
		ppp_ptr->ppp_ports[i].lcp_accm.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].lcp_accm.NegNotReqd ;
		ppp_ptr->ppp_ports[i].lcp_accm.Negotiable = upgrade_ppp_ptr->ppp_ports[i].lcp_accm.Negotiable ;
		ppp_ptr->ppp_ports[i].lcp_accm.value_type = upgrade_ppp_ptr->ppp_ports[i].lcp_accm.value_type ;
		ppp_ptr->ppp_ports[i].lcp_accm.valid = upgrade_ppp_ptr->ppp_ports[i].lcp_accm.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].lcp_accm.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].lcp_accm.option_value) ;

// REMOTE LCP ACCM

		ppp_ptr->ppp_ports[i].remote_lcp_accm.option_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_accm.option_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_accm.Auto = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_accm.Auto ;
		ppp_ptr->ppp_ports[i].remote_lcp_accm.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_accm.NegNotReqd ;
		ppp_ptr->ppp_ports[i].remote_lcp_accm.Negotiable = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_accm.Negotiable ;
		ppp_ptr->ppp_ports[i].remote_lcp_accm.value_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_accm.value_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_accm.valid = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_accm.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].remote_lcp_accm.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].remote_lcp_accm.option_value) ;

// LCP MRU

		ppp_ptr->ppp_ports[i].lcp_mru.option_type = upgrade_ppp_ptr->ppp_ports[i].lcp_mru.option_type ;
		ppp_ptr->ppp_ports[i].lcp_mru.Auto = upgrade_ppp_ptr->ppp_ports[i].lcp_mru.Auto ;
		ppp_ptr->ppp_ports[i].lcp_mru.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].lcp_mru.NegNotReqd ;
		ppp_ptr->ppp_ports[i].lcp_mru.Negotiable = upgrade_ppp_ptr->ppp_ports[i].lcp_mru.Negotiable ;
		ppp_ptr->ppp_ports[i].lcp_mru.value_type = upgrade_ppp_ptr->ppp_ports[i].lcp_mru.value_type ;
		ppp_ptr->ppp_ports[i].lcp_mru.valid = upgrade_ppp_ptr->ppp_ports[i].lcp_mru.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].lcp_mru.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].lcp_mru.option_value) ;

// REMOTE LCP MRU

		ppp_ptr->ppp_ports[i].remote_lcp_mru.option_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mru.option_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_mru.Auto = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mru.Auto ;
		ppp_ptr->ppp_ports[i].remote_lcp_mru.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mru.NegNotReqd ;
		ppp_ptr->ppp_ports[i].remote_lcp_mru.Negotiable = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mru.Negotiable ;
		ppp_ptr->ppp_ports[i].remote_lcp_mru.value_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mru.value_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_mru.valid = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mru.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].remote_lcp_mru.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mru.option_value) ;

//	REMOTE LCP AUTHENTICATION

		ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_authentication.Auto = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_authentication.Auto ;
		ppp_ptr->ppp_ports[i].remote_lcp_authentication.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_authentication.NegNotReqd ;
		ppp_ptr->ppp_ports[i].remote_lcp_authentication.Negotiable = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_authentication.Negotiable ;
		ppp_ptr->ppp_ports[i].remote_lcp_authentication.value_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_authentication.value_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_authentication.valid = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_authentication.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].remote_lcp_authentication.option_value) ;

// LCP MAGIC NUMBER 

		ppp_ptr->ppp_ports[i].lcp_magic_number.option_type = upgrade_ppp_ptr->ppp_ports[i].lcp_magic_number.option_type ;
		ppp_ptr->ppp_ports[i].lcp_magic_number.Auto = upgrade_ppp_ptr->ppp_ports[i].lcp_magic_number.Auto ;
		ppp_ptr->ppp_ports[i].lcp_magic_number.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].lcp_magic_number.NegNotReqd ;
		ppp_ptr->ppp_ports[i].lcp_magic_number.Negotiable = upgrade_ppp_ptr->ppp_ports[i].lcp_magic_number.Negotiable ;
		ppp_ptr->ppp_ports[i].lcp_magic_number.value_type = upgrade_ppp_ptr->ppp_ports[i].lcp_magic_number.value_type ;
		ppp_ptr->ppp_ports[i].lcp_magic_number.valid = upgrade_ppp_ptr->ppp_ports[i].lcp_magic_number.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].lcp_magic_number.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].lcp_magic_number.option_value) ;

// REMOTE LCP MAGIC NUMBER 

		ppp_ptr->ppp_ports[i].remote_lcp_magic_number.option_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_magic_number.option_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_magic_number.Auto = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_magic_number.Auto ;
		ppp_ptr->ppp_ports[i].remote_lcp_magic_number.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_magic_number.NegNotReqd ;
		ppp_ptr->ppp_ports[i].remote_lcp_magic_number.Negotiable = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_magic_number.Negotiable ;
		ppp_ptr->ppp_ports[i].remote_lcp_magic_number.value_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_magic_number.value_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_magic_number.valid = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_magic_number.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].remote_lcp_magic_number.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].remote_lcp_magic_number.option_value) ;
		
// REMOTE IPCP IP ADDRESS

		ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.option_type = upgrade_ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.option_type ;
		ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.Auto = upgrade_ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.Auto ;
		ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.NegNotReqd ;
		ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.Negotiable = upgrade_ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.Negotiable ;
		ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.value_type = upgrade_ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.value_type ;
		ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.valid = upgrade_ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.option_value) ;
		
// REMOTE LCP CALLBACK		

		ppp_ptr->ppp_ports[i].remote_lcp_callback.option_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_callback.option_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_callback.Auto = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_callback.Auto ;
		ppp_ptr->ppp_ports[i].remote_lcp_callback.NegNotReqd = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_callback.NegNotReqd ;
		ppp_ptr->ppp_ports[i].remote_lcp_callback.Negotiable = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_callback.Negotiable ;
		ppp_ptr->ppp_ports[i].remote_lcp_callback.value_type = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_callback.value_type ;
		ppp_ptr->ppp_ports[i].remote_lcp_callback.valid = upgrade_ppp_ptr->ppp_ports[i].remote_lcp_callback.valid ;
		strcpy ((char *) ppp_ptr->ppp_ports[i].remote_lcp_callback.option_value, (char *) upgrade_ppp_ptr->ppp_ports[i].remote_lcp_callback.option_value) ;
	}

	proxy_header_ptr->proxy_any_app = upgrade_proxy_header_ptr->proxy_any_app ;

// Add the dynamic entries 
// Calculate the total number of dynamic entries and find the size to be reallocated

// Proxy User defined entries
	offset = (ULONG) temp_upgrade_structures[PROXY_ID].ptr_to_struct ;
	temp_offset = offset ;
   calculate_offset_of_proxy_user_defined_application_entries_for_upgrading (&offset) ;
   upgrade_proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;

// Proxy Virtual Server entries
	offset = temp_offset ;
   calculate_offset_of_proxy_virtual_entry_for_upgrading (&offset) ;
   upgrade_proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;

// Proxy Global Address entries
	if (upgrade_proxy_virtual_ptr->number_of_global_address_entries)
	{
	   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 0) ;
   	upgrade_proxy_global_address_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;
	}		

// Proxy Static Mapping entries
	if (upgrade_proxy_virtual_ptr->number_of_static_mapping_entries)
	{
	   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 1) ;
	   upgrade_static_mapping_ptr = (CNF_PROXY_STATIC_INFO *) return_offset ;
	}
		
// Proxy Dynamic Mapping entries
	if (upgrade_proxy_virtual_ptr->number_of_dynamic_mapping_entries)
	{
	   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 2) ;
	   upgrade_dynamic_mapping_ptr = (CNF_PROXY_DYNAMIC_INFO *) return_offset ;
	}
		
// Proxy Filter entries
	offset = temp_offset ;
   calculate_offset_of_proxy_filter_for_upgrading (&offset) ;
   upgrade_proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;

// Proxy Forbidden sites entries
	if (upgrade_proxy_filter_ptr->number_of_forbidden_sites_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 0) ;
   	upgrade_proxy_forbidden_sites_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;
	}

// Proxy Restricted Clients entries
	if (upgrade_proxy_filter_ptr->number_of_restricted_clients_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 1) ;
     	upgrade_proxy_restricted_clients_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;
	}

// Proxy Restricted Application entries
	if (upgrade_proxy_filter_ptr->number_of_restricted_application_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 2) ;
     	upgrade_proxy_restricted_application_ptr = (CNF_PROXY_APP *) return_offset ;
	}

// Proxy MAC Address entries
	if (upgrade_proxy_filter_ptr->number_of_mac_address_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 3) ;
     	upgrade_proxy_mac_address_ptr = (CNF_PROXY_MAC_ADDRESS_INFO *) return_offset ;
	}

// Proxy Domain Name entries
	if (upgrade_proxy_filter_ptr->number_of_domain_name_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 4) ;
     	upgrade_proxy_domain_name_ptr = (CNF_PROXY_DOMAIN_NAME_INFO *) return_offset ;
	}

// Proxy Port 0
	offset = temp_offset ;
	calculate_offset_of_proxy_port_for_upgrading (&offset, 0) ;
	upgrade_proxy_port0_ptr = (CNF_PROXY_PORT *) offset ;

// Proxy Port 1
	offset = temp_offset ;
	calculate_offset_of_proxy_port_for_upgrading (&offset, 1) ;
	upgrade_proxy_port1_ptr = (CNF_PROXY_PORT *) offset ;

// Proxy Port 2
	offset = temp_offset ;
	calculate_offset_of_proxy_port_for_upgrading (&offset, 2) ;
	upgrade_proxy_port2_ptr = (CNF_PROXY_PORT *) offset ;

// Proxy Port 3
	offset = temp_offset ;
	calculate_offset_of_proxy_port_for_upgrading (&offset, 3) ;
	upgrade_proxy_port3_ptr = (CNF_PROXY_PORT *) offset ;

// Reallocate the struct size
	
	SizeToRealloc = proxy_header_ptr->section_length + 
					upgrade_proxy_user_defined_application_ptr->number_of_user_defined_application_entries * sizeof(CNF_PROXY_USER_DEFINED_APP) +
					upgrade_proxy_virtual_ptr->number_of_global_address_entries * sizeof(CNF_PROXY_ADDRESS_INFO)	+
					upgrade_proxy_virtual_ptr->number_of_static_mapping_entries * sizeof(CNF_PROXY_STATIC_INFO) +
					upgrade_proxy_virtual_ptr->number_of_dynamic_mapping_entries * sizeof(CNF_PROXY_DYNAMIC_INFO) +
					upgrade_proxy_filter_ptr->number_of_forbidden_sites_entries * sizeof(CNF_PROXY_ADDRESS_INFO) +
					upgrade_proxy_filter_ptr->number_of_restricted_clients_entries * sizeof(CNF_PROXY_ADDRESS_INFO) +
					upgrade_proxy_filter_ptr->number_of_restricted_application_entries * sizeof(CNF_PROXY_APP) +
					upgrade_proxy_filter_ptr->number_of_mac_address_entries * sizeof(CNF_PROXY_MAC_ADDRESS_INFO) +
					upgrade_proxy_filter_ptr->number_of_domain_name_entries * sizeof(CNF_PROXY_DOMAIN_NAME_INFO) +
					upgrade_proxy_port2_ptr->number_of_address_entries * sizeof(CNF_PROXY_ADDRESS_INFO) +
					upgrade_proxy_port3_ptr->number_of_address_entries	* sizeof(CNF_PROXY_ADDRESS_INFO) ;

	all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
	all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
	proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;

	proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

// Copy Proxy User defined entries
	offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
	temp_offset = offset ;
   calculate_offset_of_proxy_user_defined_application_entries (&offset) ;
   proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;
	proxy_user_defined_application_ptr->number_of_user_defined_application_entries = 
		upgrade_proxy_user_defined_application_ptr->number_of_user_defined_application_entries ;
	
	if (upgrade_proxy_user_defined_application_ptr->number_of_user_defined_application_entries)
	{
		for (i = 0; i <upgrade_proxy_user_defined_application_ptr->number_of_user_defined_application_entries; i++)
		{
			proxy_user_defined_application_ptr->user_defined_application_entries[i].protocol = 
				upgrade_proxy_user_defined_application_ptr->user_defined_application_entries[i].protocol ;
			proxy_user_defined_application_ptr->user_defined_application_entries[i].lower_port_number = 
				upgrade_proxy_user_defined_application_ptr->user_defined_application_entries[i].lower_port_number ;
			proxy_user_defined_application_ptr->user_defined_application_entries[i].higher_port_number =
				upgrade_proxy_user_defined_application_ptr->user_defined_application_entries[i].higher_port_number ;
			strcpy ((char *) proxy_user_defined_application_ptr->user_defined_application_entries[i].port_description,
 				(char *) upgrade_proxy_user_defined_application_ptr->user_defined_application_entries[i].port_description) ;
		}
	}

// Copy Proxy Virtual Server entries
	offset = temp_offset ;
   calculate_offset_of_proxy_virtual_entry (&offset) ;
   proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;

	proxy_virtual_ptr->number_of_global_address_entries = upgrade_proxy_virtual_ptr->number_of_global_address_entries ;
	proxy_virtual_ptr->number_of_static_mapping_entries = upgrade_proxy_virtual_ptr->number_of_static_mapping_entries ;
	proxy_virtual_ptr->number_of_dynamic_mapping_entries = upgrade_proxy_virtual_ptr->number_of_dynamic_mapping_entries ;
	proxy_virtual_ptr->dynamic_mapping_global_address = upgrade_proxy_virtual_ptr->dynamic_mapping_global_address ;

// Copy Proxy Global Address entries
	if (upgrade_proxy_virtual_ptr->number_of_global_address_entries)
	{
	   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 0) ;
   	proxy_global_address_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;
		for (i = 0; i < upgrade_proxy_virtual_ptr->number_of_global_address_entries; i++)
		{
			proxy_global_address_ptr->address = upgrade_proxy_global_address_ptr->address ;
			proxy_global_address_ptr++ ;
			upgrade_proxy_global_address_ptr++ ;
		}
	}		

// Copy Proxy Static Mapping entries
	if (upgrade_proxy_virtual_ptr->number_of_static_mapping_entries)
	{
	   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 1) ;
	   static_mapping_ptr = (CNF_PROXY_STATIC_INFO *) return_offset ;
		for (i = 0; i < upgrade_proxy_virtual_ptr->number_of_static_mapping_entries; i++)
		{
			static_mapping_ptr->local_address = upgrade_static_mapping_ptr->local_address ;
			static_mapping_ptr->global_address = upgrade_static_mapping_ptr->global_address ;
			static_mapping_ptr++	;
			upgrade_static_mapping_ptr++ ;
		}
	}

// Copy Proxy Dynamic Mapping entries
	if (upgrade_proxy_virtual_ptr->number_of_dynamic_mapping_entries)
	{
	   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 2) ;
	   dynamic_mapping_ptr = (CNF_PROXY_DYNAMIC_INFO *) return_offset ;
		for (i = 0; i < upgrade_proxy_virtual_ptr->number_of_dynamic_mapping_entries; i++)
		{	
			dynamic_mapping_ptr->local_address = upgrade_dynamic_mapping_ptr->local_address ;
			dynamic_mapping_ptr->port = upgrade_dynamic_mapping_ptr->port ;
			dynamic_mapping_ptr->protocol = upgrade_dynamic_mapping_ptr->protocol ;
			dynamic_mapping_ptr++ ;
			upgrade_dynamic_mapping_ptr++ ;
		}
	}

// Copy Proxy Filter entries
	offset = temp_offset ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;

	proxy_filter_ptr->number_of_forbidden_sites_entries = upgrade_proxy_filter_ptr->number_of_forbidden_sites_entries ;
	proxy_filter_ptr->number_of_restricted_clients_entries = upgrade_proxy_filter_ptr->number_of_restricted_clients_entries ;
	proxy_filter_ptr->number_of_restricted_application_entries = upgrade_proxy_filter_ptr->number_of_restricted_application_entries ;
	proxy_filter_ptr->number_of_mac_address_entries = upgrade_proxy_filter_ptr->number_of_mac_address_entries ;
	proxy_filter_ptr->number_of_domain_name_entries = upgrade_proxy_filter_ptr->number_of_domain_name_entries ;

// Copy Proxy Forbidden sites entries
	if (upgrade_proxy_filter_ptr->number_of_forbidden_sites_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 0) ;
   	proxy_forbidden_sites_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;
		for (i = 0; i < upgrade_proxy_filter_ptr->number_of_forbidden_sites_entries; i++)
		{	
			proxy_forbidden_sites_ptr->address = upgrade_proxy_forbidden_sites_ptr->address ;
			proxy_forbidden_sites_ptr++ ;
			upgrade_proxy_forbidden_sites_ptr++ ;
		}
	}

// Copy Proxy Restricted Clients entries
	if (upgrade_proxy_filter_ptr->number_of_restricted_clients_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 1) ;
   	proxy_restricted_clients_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;
		for (i = 0; i < upgrade_proxy_filter_ptr->number_of_restricted_clients_entries; i++)
		{	
			proxy_restricted_clients_ptr->address = upgrade_proxy_restricted_clients_ptr->address ;
			proxy_restricted_clients_ptr++ ;
			upgrade_proxy_restricted_clients_ptr++ ;
		}
	}
	
// Copy Proxy Restricted Application entries
	if (upgrade_proxy_filter_ptr->number_of_restricted_application_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 2) ;
   	proxy_restricted_application_ptr = (CNF_PROXY_APP *) return_offset ;
		for (i = 0; i < upgrade_proxy_filter_ptr->number_of_restricted_application_entries; i++)
		{	
			proxy_restricted_application_ptr->port = upgrade_proxy_restricted_application_ptr->port ;
			proxy_restricted_application_ptr->protocol = upgrade_proxy_restricted_application_ptr->protocol ;
			proxy_restricted_application_ptr++ ;
			upgrade_proxy_restricted_application_ptr++ ;
		}
	}
	
// Copy Proxy MAC Address entries
	if (upgrade_proxy_filter_ptr->number_of_mac_address_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 3) ;
   	proxy_mac_address_ptr = (CNF_PROXY_MAC_ADDRESS_INFO *) return_offset ;
		for (i = 0; i < upgrade_proxy_filter_ptr->number_of_mac_address_entries; i++)
		{	
			strcpy ((char *) proxy_mac_address_ptr->address, (char *) upgrade_proxy_mac_address_ptr->address) ;
			proxy_mac_address_ptr++ ;
			upgrade_proxy_mac_address_ptr++ ;
		}
	}
	
// Copy Proxy Domain Name entries
	if (upgrade_proxy_filter_ptr->number_of_domain_name_entries)
	{
	   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 4) ;
   	proxy_domain_name_ptr = (CNF_PROXY_DOMAIN_NAME_INFO *) return_offset ;
		for (i = 0; i < upgrade_proxy_filter_ptr->number_of_domain_name_entries; i++)
		{	
			strcpy ((char *) proxy_domain_name_ptr->domain_name, (char *) upgrade_proxy_domain_name_ptr->domain_name) ;
			proxy_domain_name_ptr++ ;
			upgrade_proxy_domain_name_ptr++ ;
		}
	}

// Copy Proxy Port parameters
	
	for (i = 0; i < proxy_header_ptr->number_of_ports; i++)
	{
		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_port (&offset, i) ;
		proxy_port_ptr = (CNF_PROXY_PORT *) offset ;

		offset = (ULONG) temp_upgrade_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_port_for_upgrading (&offset, i) ;
		upgrade_proxy_port_ptr = (CNF_PROXY_PORT *) offset ;

		proxy_port_ptr->enabled = upgrade_proxy_port_ptr->enabled ;
		proxy_port_ptr->number_of_address_entries = upgrade_proxy_port_ptr->number_of_address_entries ;
		proxy_port_ptr->number_of_connections_to_trigger =	upgrade_proxy_port_ptr->number_of_connections_to_trigger ;
		proxy_port_ptr->number_of_hosts_to_trigger = upgrade_proxy_port_ptr->number_of_hosts_to_trigger ;

		for (int j = 0; j < upgrade_proxy_port_ptr->number_of_address_entries; j++)
		{
			proxy_port_ptr->port_address[j].address = upgrade_proxy_port_ptr->port_address[j].address ;
		}
	}

// DHCP Parameters
	
	USHORT temp_number_of_entries = dhcp_header_ptr->number_of_address_range_entries ;
	dhcp_header_ptr->number_of_address_range_entries = upgrade_dhcp_header_ptr->number_of_address_range_entries ;

  	SizeToRealloc = (dhcp_header_ptr->section_length + (sizeof(CNF_DHCP_ADDRESS_RANGE) * (dhcp_header_ptr->number_of_address_range_entries - temp_number_of_entries))) ;
	all_structures[DHCP_ID].glblck = GlobalReAlloc (all_structures[DHCP_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	all_structures[DHCP_ID].ptr_to_struct = GlobalLock (all_structures[DHCP_ID].glblck) ;
	all_structures[DHCP_ID].size_of_struct = (USHORT) SizeToRealloc ;
	dhcp_header_ptr = (CNF_DHCP_HEADER *) all_structures[DHCP_ID].ptr_to_struct ;
	dhcp_header_ptr->section_length = (USHORT) SizeToRealloc ;

// Copy DHCP Address Ranges
	for (i = 0; i < upgrade_dhcp_header_ptr->number_of_address_range_entries; i++)
	{
		offset = (ULONG) temp_upgrade_structures[DHCP_ID].ptr_to_struct ;
		calculate_offset_of_dhcp_address_range_entries_for_upgrading (&offset, i) ;
	   upgrade_dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;

		offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
		calculate_offset_of_dhcp_address_range_entries (&offset, i) ;
	   dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;

		dhcp_address_range_ptr->lower_ip_address = upgrade_dhcp_address_range_ptr->lower_ip_address ;
		dhcp_address_range_ptr->higher_ip_address = upgrade_dhcp_address_range_ptr->higher_ip_address ;
		dhcp_address_range_ptr->address_mask = upgrade_dhcp_address_range_ptr->address_mask ;
		dhcp_address_range_ptr->exclude_lower_ip_address = upgrade_dhcp_address_range_ptr->exclude_lower_ip_address ;
		dhcp_address_range_ptr->exclude_higher_ip_address = upgrade_dhcp_address_range_ptr->exclude_higher_ip_address ;
      dhcp_address_range_ptr->options_entries.router_address = upgrade_dhcp_address_range_ptr->options_entries.router_address ;
      strcpy ((char *) dhcp_address_range_ptr->options_entries.domain_name, (char *) upgrade_dhcp_address_range_ptr->options_entries.domain_name) ;
      dhcp_address_range_ptr->options_entries.reassembly_size = upgrade_dhcp_address_range_ptr->options_entries.reassembly_size ;
      dhcp_address_range_ptr->options_entries.default_ip_ttl = upgrade_dhcp_address_range_ptr->options_entries.default_ip_ttl ;
      dhcp_address_range_ptr->options_entries.mtu = upgrade_dhcp_address_range_ptr->options_entries.mtu ;
      dhcp_address_range_ptr->options_entries.default_tcp_ttl = upgrade_dhcp_address_range_ptr->options_entries.default_tcp_ttl ;
      dhcp_address_range_ptr->options_entries.lease_time = upgrade_dhcp_address_range_ptr->options_entries.lease_time ;

// Copy DHCP Bindings
		temp_number_of_entries = dhcp_address_range_ptr->number_of_bindings_entries ;
		dhcp_address_range_ptr->number_of_bindings_entries = upgrade_dhcp_address_range_ptr->number_of_bindings_entries ;

		ULONG SizeToRealloc = (dhcp_header_ptr->section_length + (sizeof(CNF_BINDING_INFO) * (dhcp_address_range_ptr->number_of_bindings_entries - temp_number_of_entries))) ;
		all_structures[DHCP_ID].glblck = GlobalReAlloc (all_structures[DHCP_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[DHCP_ID].ptr_to_struct = GlobalLock (all_structures[DHCP_ID].glblck) ;
		all_structures[DHCP_ID].size_of_struct = (USHORT) SizeToRealloc ;
		dhcp_header_ptr = (CNF_DHCP_HEADER *) all_structures[DHCP_ID].ptr_to_struct ;
		dhcp_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[DHCP_ID].ptr_to_struct ;
		calculate_offset_of_dhcp_address_range_entries (&offset, i) ;
   	dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) offset ;
	   calculate_offset_of_dhcp_binding_entries (&offset, &return_offset) ;
   	dhcp_binding_ptr = (CNF_BINDING_INFO *) return_offset ;

		offset = (ULONG) temp_upgrade_structures[DHCP_ID].ptr_to_struct ;

		calculate_offset_of_dhcp_address_range_entries_for_upgrading (&offset, i) ;
   	calculate_offset_of_dhcp_binding_entries (&offset, &return_offset) ;
	   upgrade_dhcp_binding_ptr = (CNF_BINDING_INFO *) return_offset ;
		
		for (int j = 0; j < upgrade_dhcp_address_range_ptr->number_of_bindings_entries; j++)
		{
			dhcp_binding_ptr->ip_address = upgrade_dhcp_binding_ptr->ip_address ;
			dhcp_binding_ptr->mac_address_length = upgrade_dhcp_binding_ptr->mac_address_length ;
			strcpy ((char *) dhcp_binding_ptr->mac_address, (char *) upgrade_dhcp_binding_ptr->mac_address) ;
			dhcp_binding_ptr++ ;
			upgrade_dhcp_binding_ptr++ ;
		}
	}
	return TRUE ;
}
/* Jo 06/09/99 Added for Upgrade */

BOOL CRouconApp::InitInstance()
{
	CMainDlg mdlg;

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	int length ;
  	char *ptr ;
	char szBuf[30] ;
	char ApplicationName[50] ;
	BootConfigType ConfigHeader ;
	char *NetAddrPointer ;

	length = GetModuleFileName (m_hInstance, LoadPath, FILE_NAME_SIZE) ;
	ptr = &LoadPath[length] ;
	while (*ptr != '\\')
	      ptr -- ;
	*(ptr + 1) = NULL ;

	/* create all the ini File names */
	strcpy (OwnIniFile, LoadPath) ;
	strcat (OwnIniFile, LocalINI) ; // Setup.Ini

	strcpy (IniInWinForm, LoadPath) ;
	strcat (IniInWinForm, TempINI) ;  // Roucon.Ini

	strcpy (IniInRtrWareForm, LoadPath) ;
	strcat (IniInRtrWareForm, CNF_File) ;  // Router.Cnf
	// IniInRtrWareForm contains the configuration file

	strcpy (IniInRtrWareFormDef, LoadPath) ;
	strcat (IniInRtrWareFormDef, DEF_CNF_File) ;
	// IniInRtrWareFormDef contains the default configuration file

	strcpy (ini_INIFilename, LoadPath);
	strcat (ini_INIFilename, IsdnTempINI);

	strcpy (UDBCompressedDBaseFile, LoadPath) ;  // Compressed User DBase
	strcat (UDBCompressedDBaseFile, UDB_COMPR_DBASE_FILE) ; 

	strcpy (UDBUnCompressedDBaseFile, LoadPath) ;  // UnCompressed User DBase
	strcat (UDBUnCompressedDBaseFile, UDB_UNCOMPR_DBASE_FILE) ; 

	strcpy (LogFileName, LoadPath) ;  // Log File
	strcat (LogFileName, LOG_FILE) ; 
/* Jo */
	strcpy(RouterBitmapFile, LoadPath) ;
	strcat(RouterBitmapFile, BMP_FILE) ; 

	strcpy(TempFile, LoadPath) ;
	strcat(TempFile, TEMP_FILE) ; 

	strcpy(TempUpgradeFile, LoadPath) ;
	strcat(TempUpgradeFile, TEMP_UPGRADE_FILE) ; 

/* Jo */

	Ctl3dRegister (m_hInstance) ;
	Ctl3dAutoSubclass (m_hInstance) ;

	SetDialogBkColor() ;        // Set dialog background color to gray
	LoadStdProfileSettings() ;  // Load standard INI file
									    // options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	// create main window
	CMainFrame *p_MainFrame;
	if (m_lpCmdLine[0] != 0)
	{
		p_MainFrame = new CMainFrame ;
		if (!p_MainFrame->LoadFrame (IDR_MAINFRAME))
			return FALSE ;
	}
	else
		p_MainFrame = (CMainFrame *)&mdlg;

	m_pMainWnd = p_MainFrame ;

	((CWnd *) p_MainFrame)->CenterWindow() ;

	CommandLineArgument = 0 ;

	DownloadSetupOnly = FALSE ;
	LookForTargetOnly = FALSE ;
	DontReadConfiguration = FALSE ;

	// Check if the port is TFTP
	GetPrivateProfileString((LPCSTR) "Port Setup", (LPCSTR) "Communication type",
		(LPCSTR) "Serial", (LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;

	if (!strcmpi (szBuf, "IP"))
		IsPortIP = TRUE ;
        WindowText = "ProxyServer 2.00" ;  // Jo
	/* 9/7/97 */
	IsLanTalker = !strcmpi (ApplicationName, "LANTalker") ;
	IsRF200 = !strcmpi (ApplicationName, "RouteFinder200") ;
	/* 9/7/97 */
	MainMsgHeader = ApplicationName ;

	////Prabha, 6/2/98, to get the boot header for the model number
	char BootVerString[20] ;
	memset (BootVerString, 0, sizeof (BootVerString)) ;
	/* Look if the router is up */


//	GetBootVersionAndSetVars(p_MainFrame, BootVerString);

	CodeLoadAddress = COD_LOAD_ADDR ;
	CodeStartAddress = COD_START_ADDR ;
	FlCodeStartAddress = FL_CODE_START ;
	TFTPCodeAddressDetails.TFTP_FlCodeStartAddress = FL_CODE_START ;
	TFTPCodeAddressDetails.TFTP_CodeLoadAddress = COD_LOAD_ADDR ;
	TFTPCodeAddressDetails.TFTP_CodeStartAddress = COD_START_ADDR ;

	if (m_lpCmdLine[0] == '2')
	{
		CommandLineArgument = 2;
		if (!IsPortIP) // For COM Port
		{
			GetBootVersionAndSetVars(p_MainFrame, BootVerString);
			CPowerCode cPowerCode ((CWnd *) p_MainFrame) ;
			if (IDCANCEL == cPowerCode.DoModal())
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}
		else // using TFTP
		{
			AfxMessageBox ("Download firmware is not supported via network.\nDownload firmware supported only via local Command port") ;
		}

/* Jo Download firmware via TFTP not supported */
#if 0	
		{
			if (RouMsgBox (MSG_MAIN_ASK_DOWN,
						MainMsgHeader, MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
			{
				CFileDialog cFileDialog (TRUE, (LPCSTR) "*.BIN",
							NULL, OFN_HIDEREADONLY /*| OFN_CREATEPROMPT*/,
			   	         (LPCSTR) "Firmware Files (*.bin) | *.bin ||", NULL) ;
				cFileDialog.CenterWindow () ;
				if (IDOK != cFileDialog.DoModal())
				{
					PostQuitMessage (0) ;
					return TRUE ;
				}

				CString CodeFileName = cFileDialog.GetPathName() ;
				char *Ptr = CodeFileName.GetBuffer(0) ;

				struct
				{
					BYTE Version[8] ;
					BYTE DateStamp[24] ;
					BYTE MagicNumber[5] ;
				} FileHeader ;

				CStdioFile Input ;

				if (!Input.Open (CodeFileName,
						CFile::modeRead | CFile::typeBinary))
				{
					RouMsgBox (MSG_GEN_FILE_OPEN_ERR, MainMsgHeader, 
													MB_OK | MB_ICONINFORMATION) ;

					PostQuitMessage (0) ;
					return (TRUE) ;
				}

				Input.Read (&FileHeader, 37) ;
				Input.Close() ;

				char szMagic[10] ;
				sprintf (szMagic, "%X", (WORD) MAGIC_NUM) ;
				if (strcmp ((LPCSTR) &FileHeader.MagicNumber, szMagic)) 
				{
					RouMsgBox (MSG_PWN_INV_CODE, MainMsgHeader,
														MB_OK | MB_ICONSTOP) ;
					PostQuitMessage (0) ;
					return TRUE ;
				}

				strcpy (TFTPPutLocalFileName, Ptr) ;
				strcpy (TFTPPutRemoteFileName, "MTROUTER.BIN") ;

//				TFTPWaitMessage TFTPCompressionProgress ((CWnd *) p_MainFrame) ;
//				TFTPCompressionProgress.ShowWindow (SW_SHOW) ;
//				TFTPCompressionProgress.ShowWindow (SW_SHOW) ;

				SetCapture(NULL);
				tftpwrit TFTPFirmwareUpdate ;
				if (IDOK != TFTPFirmwareUpdate.DoModal())
				{
					PostQuitMessage (0) ;
					return TRUE ;
				}
			}
			else
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}
#endif
		PostQuitMessage (0) ;		// exit out after firmwareupdate
		return TRUE ;
	}

	/* Download default setup */
	/* 3 --> while installing roucon */
	/* 1 --> while downloading default setup */
	if ((m_lpCmdLine[0] == '3') || (m_lpCmdLine[0] == '1'))
	{
		CommandLineArgument = 3 ;
		DefaultSetup = TRUE; /* Jo 13/11/98 */

		/* Using TFTP for Download Default setup */
		if (IsPortIP)
		{
/* Jo 09/01/99 */
			GetPrivateProfileString((LPCSTR) "Port Setup", (LPCSTR) "Auto Detect",
				(LPCSTR) "Disabled", (LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;
			if (!strcmpi (szBuf, "Enabled"))
			{
				// Create Modeless AutoDetect Box...
				CAutodetect Autodetect ;

				// Now the Dialog Box is Created.. So Initialise the Sockets..
				int retry = 0 ;
				BOOL result = Autodetect.InitialiseSockets(retry);

				if (result == FALSE)
				{
		  		  	AfxMessageBox("Unable to proceed with autodetection....") ;
					UnInitUDP() ;
					return TRUE ;
				}

				MSG Msg;
				BOOL bMsgFound;
				BOOL bTimerExpired = FALSE;
				BOOL return_value ;

				while(bTimerExpired == FALSE)
				{
				   bMsgFound = PeekMessage(&Msg, Autodetect.m_hWnd,0,0,PM_REMOVE);
					if(bMsgFound == TRUE)
					{
						switch(Msg.message)
						{
							case WM_TIMER:
										Autodetect.TimerExpired(Msg.wParam);
										if (Msg.wParam == AUTODETECT_TIMERID)
											bTimerExpired = TRUE;
										else
											if (Msg.wParam == AUTODETECT_RETRY_TIMERID)
											{
												retry = 1 ;
												Autodetect.InitialiseSockets(retry);
											}
										break;
							case WM_UDP_EVENT_OCCURED:
							        	return_value = Autodetect.ResponseReceived();
									   break;
							default:break;
						}
						TranslateMessage(&Msg);
						DispatchMessage(&Msg);
					}
				}

				if (DetectSuccess == FALSE)
				{
			        	AfxMessageBox ("Auto Detection Failed") ;
						UnInitUDP() ;
				   	return FALSE ;
				}
				else
				{
				   CIPDetect ipdetect ;	
				   ipdetect.DoModal() ;
				}
				bTimerExpired = FALSE;
				UINT nTimerID = Autodetect.SetTimer(WAIT_FOR_BOOT_TIMER, MAX_UDP_RESPONSE_TIMER, NULL) ;
				while(bTimerExpired == FALSE)
				{
		         bMsgFound = PeekMessage(&Msg, Autodetect.m_hWnd, 0, 0, PM_REMOVE);
					if(bMsgFound == TRUE)
					{
						switch(Msg.message)
						{
							case WM_TIMER:
										if (Msg.wParam == WAIT_FOR_BOOT_TIMER)
										{
											Autodetect.TimerExpired(Msg.wParam);
											bTimerExpired = TRUE;
										}
										break;
							case WM_UDP_EVENT_OCCURED:
							        	return_value = Autodetect.ResponseReceived();
										break;
							default:break;
						}
						TranslateMessage(&Msg);
						DispatchMessage(&Msg);
					}
				}
				UnInitUDP() ;

				if (dotdecimal_configured_ip_address.IsEmpty())
				{
					PostQuitMessage(0);
					return TRUE;
				}

				WritePrivateProfileString ((LPCSTR) "Port Setup",
					(LPCSTR) "Router IP Address", (LPCSTR) dotdecimal_configured_ip_address, (LPCSTR) OwnIniFile) ;

				ModifyIPAddress = TRUE ;
			}
		}

/* Jo 20/07/99 Added UDB in Wizard Setup */
		int nRetVal = MessageBox (NULL, (LPCSTR) "Do You Want to Download Default Setup?",
			(LPCSTR) "Default Setup", MB_YESNO | MB_ICONQUESTION) ;

		if (nRetVal == IDNO)
		{
			PostQuitMessage (0) ;
			return TRUE ;
		}

		GetBootVersionAndSetVars(p_MainFrame, BootVerString);
		if (IsPortIP)
		{
			strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
			strcpy (TFTPGetLocalFileName, LoadPath) ;
			strcat (TFTPGetLocalFileName, "BOOT.CFG") ;

			tftpread TFTPReadDialog ;
			if (TFTPReadDialog.DoModal() != IDOK)
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}

			FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;
			if (FilePointer != NULL)
			{
				fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;
				ConfigHeader.EthernetAddr_H = SwapWord(ConfigHeader.EthernetAddr_H);
				ConfigHeader.EthernetAddr_L = SwapDWord(ConfigHeader.EthernetAddr_L);
				NetAddrPointer = &EtherNetAddr[0] ;

				sprintf(NetAddrPointer, "%04X%08lX", ConfigHeader.EthernetAddr_H,
				ConfigHeader.EthernetAddr_L);
			}
			else
			{
				::MessageBox (((CWnd *) p_MainFrame)->GetSafeHwnd(), "Could not initialize configuration read. Quitting ...", "",
											MB_OK | MB_ICONINFORMATION) ;
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}

		// read ether net address and check if router network corresponds
		// to that of the one in roucon.ini. if same, just download
		// else invoke the dialog boxes

		LookForTargetOnly = TRUE ;   // Just read ethernet address
											  // Do not download setup now	
		reset_needed = 0 ;
		if (!IsPortIP)
		{
			CPowerOn cPowerOn ((CWnd *) p_MainFrame) ;
			if (IDCANCEL == cPowerOn.DoModal() )
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}

		// Ask the user to connect the router and power on
		// If already connected just power off and power on

      if (!Read_from_bmp_to_struct(RouterBitmapFile))
		   ::MessageBox (NULL, "Error : Could Not Read Configuration", "",MB_OK);

		CIPDNLD ipdnld ((CWnd *) p_MainFrame) ;
		ipdnld.DoModal() ;
		
		CWandefs cWANDefs ((CWnd *) p_MainFrame) ;
		cWANDefs.DoModal() ;


		if (ras_is_enabled() && ShowRas)
		{
			if (IsPortIP)    // If via Ethernet port
			{
				// This is done to find the number of ports
				// From the Configuration
				strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
				strcpy (TFTPGetLocalFileName, LoadPath) ;
				strcat (TFTPGetLocalFileName, "BOOT.CFG") ;	
			
				tftpread TFTPReadDialog ;	
				if (TFTPReadDialog.DoModal() != IDOK)
				{	
					PostQuitMessage (0) ;	
					return TRUE ;	
				}	

				// Open the BOOT.CFG in the Executable's path dir	
				FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;	
				if (FilePointer != NULL)
				{
					fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;	
					NumberOfPorts = (UINT) ConfigHeader.NumberOfPorts ;
					fclose (FilePointer) ;

					// Delete BOOT.CFG file
					remove (TFTPGetLocalFileName) ;
				}
				else
				{
					// Remote Possibility
					::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 						(LPCSTR) "Could not read/create header file",
						(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
					PostQuitMessage (0) ;
					return TRUE ;
				}

/* Jo 	29/06/99 Modified UDB read and write */

				// Get the User data Base from the Box
				// which is uncompressed and without the Header

				strcpy (TFTPGetRemoteFileName, UDB_COMPR_DBASE_FILE) ;
				strcpy (TFTPGetLocalFileName, UDBCompressedDBaseFile) ;

				tftpread TFTPReadUserDBDialog ;
				if (TFTPReadUserDBDialog.DoModal() != IDOK)
				{
					PostQuitMessage (0) ;
					return (TRUE) ;
				}

				char UDBHeaderFilePath[200] ;
				FILE *UDBHeaderFile ;
				char UDBVer[20] ;

				memset (UDBVer, 0, sizeof (UDBVer)) ;
				strcpy (UDBHeaderFilePath, LoadPath) ;
				strcat (UDBHeaderFilePath, UDB_HDR_FILE) ;
				UDBHeaderFile = fopen (UDBHeaderFilePath, "rb") ;
				if (UDBHeaderFile == NULL)
				{
					// Remote Possibility
					::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 						(LPCSTR) "Couldn't read UDB Version",
						(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
					PostQuitMessage (0) ;
					return TRUE ;
				}
				else
				{
					fread (UDBVer, sizeof (UDBVer), 1, UDBHeaderFile) ;
				}

		   	rename (TFTPGetLocalFileName, UDBUnCompressedDBaseFile) ;
			
				// Pop up the Users List Dialog
				CUsersDlg cUsers ((CWnd *) p_MainFrame) ;
				if (cUsers.DoModal() == IDCANCEL)
				{		
				}
				else
				{	
					strcpy (TFTPPutLocalFileName, UDBUnCompressedDBaseFile) ;
					strcpy (TFTPPutRemoteFileName, UDB_COMPR_DBASE_FILE) ;

					// Use TFTP write
					tftpwrit TFTPWriteUserDataBase ;
					TFTPWriteUserDataBase.DoModal() ; 

					// Delete the uncompressed data base 
					// first destroying the contents
					FILE *FileUnCompressedDBase =	fopen (UDBUnCompressedDBaseFile, "wb") ;		
					fclose (FileUnCompressedDBase) ;
					remove (UDBUnCompressedDBaseFile) ;
				}
   		}
			else // via COM Port
			{
				CUsersComDlg cUsersComDlg ((CWnd *) p_MainFrame) ;
				cUsersComDlg.DoModal() ;
			}
		}
		reset_needed = 1 ;
		if (!IsPortIP)
		{
			CPowerOn cPowerOn ((CWnd *) p_MainFrame) ;
			if (IDCANCEL == cPowerOn.DoModal() )
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}

/* Jo 20/07/99 Added UDB in Wizard Setup */

		BOOL WanAsync = TRUE ;

		if (!Write_from_struct_to_bmp (RouterBitmapFile, TRUE))
		{
		   ::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 		   (LPCSTR) "Could not write default setup",
		   		(LPCSTR) "Configuration Write", MB_OK | MB_ICONHAND) ;		
		   PostQuitMessage (0);
		   return TRUE ;
		}
		
		// Now we are actually going to download the setup
		LookForTargetOnly = FALSE ;
		reset_needed = 1 ;
		if (!IsPortIP)
		{
			CPowerOn c1PowerOn ((CWnd *) p_MainFrame) ;
			c1PowerOn.DoModal() ;
		}
		else
		{
// Jo commented this out
//			if (RouMsgBox (MSG_MAIN_ASK_DOWN, MainMsgHeader,
//									MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
//			{
				strcpy (TFTPPutLocalFileName, RouterBitmapFile);
				strcpy (TFTPPutRemoteFileName, "CONFIG.INI") ;

				tftpwrit TFTPPutDefaultSetup ;
				TFTPPutDefaultSetup.DoModal() ;
//			}
		}
		//Copy the mtrouter.cnf to router.cnf to avoid reading of cnf
		//when tyring to configure next time

		PostQuitMessage (0) ;
		return TRUE ;
	}

	if (m_lpCmdLine[0] == '4')
	{
		GetBootVersionAndSetVars(p_MainFrame, BootVerString);
		DontReadConfiguration = TRUE;
		CommandLineArgument = 4;
	}

	if (m_lpCmdLine[0] == '5')
	{
		GetBootVersionAndSetVars(p_MainFrame, BootVerString);
		DontReadConfiguration = TRUE;
		CommandLineArgument = 5;
	}

/* Jo 06/09/99 Added for Upgrade */

	if (m_lpCmdLine[0] == '6')
	{
		if (IsPortIP)
		{
			AfxMessageBox ("ProxyServer Upgrade is not supported via network.\nProxyServer Upgrade supported only via local Command port") ;

			PostQuitMessage (0) ;
			return TRUE ;
		}
// Jo 09 Dec 1999 If the current version is 2.00(not 1.00 or 1.01) then don't upgrade...

		CommandLineArgument = 6 ;
		LookForTargetOnly = TRUE ;   // Just read ethernet address
		RebootForUpgrade = FALSE ; // Read Version of Firmware only
		CPowerOn cPoweOn ((CWnd *) p_MainFrame) ;
		cPoweOn.DoModal() ;

		if (!strcmp (FirmwareVersion, "2.00"))
		{
			::MessageBox (NULL, "Cannot Upgrade : You are running the latest version.", "Upgrade ProxyServer 2.00", MB_OK) ;
			PostQuitMessage (0) ;
			return TRUE ;
		}
// Jo ...09 Dec 1999 If the current version is 2.00(not 1.00 or 1.01) then don't upgrade
	
		GetBootVersionAndSetVars(p_MainFrame, BootVerString) ;

		CUPGrade cUPgrade(p_MainFrame) ;
      cUPgrade.InvalidateRect(NULL) ;
      cUPgrade.UpdateWindow() ;

      DefaultSetup = TRUE ; /* Default  Setup  */

		LookForTargetOnly = TRUE ;   // Just read ethernet address

		RebootForUpgrade = TRUE ; // Read Version of Firmware only
		CPowerOn cPowOn ((CWnd *) p_MainFrame) ;
		if (IDCANCEL == cPowOn.DoModal() )
		{
      	cUPgrade.DestroyWindow() ;
			PostQuitMessage (0) ;
			return TRUE ;
		}

		RebootForUpgrade = FALSE ; // Read Version of Firmware only

      CMainDlg mdlg(p_MainFrame) ;
		mdlg.DoModal() ;

      AfxGetApp()->LoadCursor (IDC_WAIT) ;
      AfxGetApp()->DoWaitCursor (1) ;

		if (!UpGradeProxy())
		{
	      cUPgrade.DestroyWindow() ;
			PostQuitMessage (0) ;
		   return TRUE ;
		}

		remove (TempUpgradeFile) ;
      cUPgrade.DestroyWindow() ;

		if (!Write_from_struct_to_bmp (IniInRtrWareForm, TRUE))
		{
		   ::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 	   	(LPCSTR) "Could not write setup",
	   		(LPCSTR) "Configuration Write", MB_OK | MB_ICONHAND) ;		
			PostQuitMessage (0) ;
		   return TRUE ;
		}

// Download Setup
		rename (RouterBitmapFile, TempFile)	;
		remove (RouterBitmapFile) ;
		rename (IniInRtrWareForm, RouterBitmapFile)	;
		
		reset_needed = 1 ;
		LookForTargetOnly = FALSE ;
		BOOL FLAG = TRUE ;

		CPowerOn cPowerOn ((CWnd *) p_MainFrame) ;
		if (IDCANCEL == cPowerOn.DoModal())
			FLAG = FALSE ;

		remove (RouterBitmapFile) ;
		rename (TempFile, RouterBitmapFile)	;
		remove (TempFile)	;

		if (!FLAG)
		{
			PostQuitMessage (0) ;
			return TRUE ;
		}

// Download firmware
      CPowerCode cPowCode ((CWnd *) p_MainFrame) ;
		if (IDCANCEL == cPowCode.DoModal())
		{
			PostQuitMessage (0) ;
			return TRUE ;
		} 
		PostQuitMessage (0) ;		// exit out after firmwareupdate
		return TRUE ;
	}

/* Jo 06/09/99 Added for Upgrade */

	GetBootVersionAndSetVars(p_MainFrame, BootVerString) ;
	// This is for USER DATABASE
	if (m_lpCmdLine[0] == '7')
	{
		CommandLineArgument = 7 ;
		if (IsPortIP)    // If via Ethernet port
		{
			// This is done to find the number of ports
			// From the Configuration
			strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
			strcpy (TFTPGetLocalFileName, LoadPath) ;
			strcat (TFTPGetLocalFileName, "BOOT.CFG") ;	
			
			tftpread TFTPReadDialog ;	
			if (TFTPReadDialog.DoModal() != IDOK)
			{	
				PostQuitMessage (0) ;	
				return TRUE ;	
			}	

			// Open the BOOT.CFG in the Executable's path dir	
			FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;	
			if (FilePointer != NULL)
			{
				fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;	
				NumberOfPorts = (UINT) ConfigHeader.NumberOfPorts ;
				fclose (FilePointer) ;

				// Delete BOOT.CFG file
				remove (TFTPGetLocalFileName) ;
			}
			else
			{
				// Remote Possibility
				::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 					(LPCSTR) "Could not read/create header file",
					(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;
				return TRUE ;
			}

/* Jo 29/06/99 Modified UDB read and write */

			// Get the User data Base from the Box
			// which is compressed and without the
			// Header
			strcpy (TFTPGetRemoteFileName, UDB_COMPR_DBASE_FILE) ;
			strcpy (TFTPGetLocalFileName, UDBCompressedDBaseFile) ;

			tftpread TFTPReadUserDBDialog ;
			if (TFTPReadUserDBDialog.DoModal() != IDOK)
			{
				PostQuitMessage (0) ;
				return (TRUE) ;
			}

			char UDBHeaderFilePath[200] ;
			FILE *UDBHeaderFile ;
			char UDBVer[20] ;

			memset (UDBVer, 0, sizeof (UDBVer)) ;
			strcpy (UDBHeaderFilePath, LoadPath) ;
			strcat (UDBHeaderFilePath, UDB_HDR_FILE) ;
			UDBHeaderFile = fopen (UDBHeaderFilePath, "rb") ;
			if (UDBHeaderFile == NULL)
			{
				// Remote Possibility
				::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 					(LPCSTR) "Couldn't read UDB Version",
					(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;
				return TRUE ;
			}
			else
			{
				fread (UDBVer, sizeof (UDBVer), 1, UDBHeaderFile) ;
			}

		   rename (TFTPGetLocalFileName, UDBUnCompressedDBaseFile) ;
			
			// Pop up the Users List Dialog
			CUsersDlg cUsers ((CWnd *) p_MainFrame) ;
			if (cUsers.DoModal() == IDCANCEL)
			{		
				PostQuitMessage (0) ;
				return TRUE ;
			}

			strcpy (TFTPPutLocalFileName, UDBUnCompressedDBaseFile) ;
			strcpy (TFTPPutRemoteFileName, UDB_COMPR_DBASE_FILE) ;

			// Use TFTP write
			tftpwrit TFTPWriteUserDataBase ;
			TFTPWriteUserDataBase.DoModal() ; 

			// Delete the uncompressed data base 
			// first destroying the contents
			FILE *FileUnCompressedDBase =
							fopen (UDBUnCompressedDBaseFile, "wb") ;		
			fclose (FileUnCompressedDBase) ;
			remove (UDBUnCompressedDBaseFile) ;

		   PostQuitMessage (0) ;
			return TRUE ;
   	}
		else // via COM Port
		{
			CUsersComDlg cUsersComDlg ((CWnd *) p_MainFrame) ;
			cUsersComDlg.DoModal() ;
		   	PostQuitMessage (0) ;
			return TRUE ;
		}
	}

	mdlg.DoModal() ;

	((CWnd *) p_MainFrame)->SendMessage (WM_CLOSE) ;
	return TRUE ;
}

int CRouconApp::ExitInstance()
{
	Ctl3dUnregister(m_hInstance);
	return(CWinApp::ExitInstance());
}
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CRouconApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

int CRouconApp::wildstrcmp(LPSTR str1, LPSTR str2)
{
	while (*str1 && *str2)
	{
		if (*str1 == '?' || *str2 == '?')
		{	// is any of them a ? char
			str1 ++ ; 
			str2 ++ ;						// if yes skip compare at this char
			continue ;
		}
		if (*str1 == '*' || *str2 == '*') 	// is any of them a * char
			return 0 ;								// if yes return match

		if (*str1 < *str2)
			return -1 ;
		else
			if (*str1 > *str2)
				return 1 ;

		str1 ++ ;
		str2 ++ ;
	}
	return ((int)*str1 - (int)*str2) ;
}

/////////////////////////////////////////////////////////////////////////////
// CRouconApp commands

void LZWExpandFromFile (FILE *sfp, FILE *dfp)
{
	int read_block_len ;
	unsigned short nread, decomp_size ;

	BYTE *read_buf = new BYTE[MAX_READ_SIZE] ;
	if (read_buf == NULL)
		return ;

	BYTE *comp_buf = new BYTE[MAX_UNCOMP_SIZE] ;
	if (comp_buf == NULL)
	{
		delete [] read_buf ;
		return ;
	} 

	do
	{
		if (fread (&read_block_len, 1, sizeof (read_block_len), sfp) !=
													sizeof (read_block_len))
			break;

		read_block_len = change_endian ((WORD) read_block_len);

		if (read_block_len < 0)
		{
			nread = decomp_size = fread (comp_buf, sizeof (char), -read_block_len, sfp);
		}
		else
		{
			nread = fread (read_buf, sizeof(char), read_block_len, sfp);
			decomp_size = LZ15VExpandBuf ((unsigned char far *) read_buf,
						nread, (unsigned char far *) comp_buf, MAX_UNCOMP_SIZE) ;
		}

		fwrite (comp_buf, sizeof (char), decomp_size, dfp);
	}
	while (1) ;

	delete [] read_buf ;
	delete [] comp_buf ; 

	return ;
}


static unsigned short change_endian (unsigned short num)
{
	unsigned short num2 ;
	unsigned char *str1, *str2 ;

	str1 = (unsigned char *) &num ;
	str2 = (unsigned char *) &num2 ;
	str2[0] = str1[1] ;
	str2[1] = str1[0] ;
	return num2 ;
}

/*----------------------------------------------------------------------------
	Module : PutLeadingZeroes
	Author : Chetan
	Input  : IPX Address Buffer
	Output : none
----------------------------------------------------------------------------*/
void PutLeadingZeroes (LPSTR lpszIPXNetAddr)
{
	char szAddr[8 + 1] ;

	int nAddrLen = strlen (lpszIPXNetAddr) ;

	// If length is 8 no need of adding leading zeroes
	// or may be "AutoLearn"
	if (nAddrLen >= 8)
		return ;

	// Add the leading zeroes
	for (int i = 0 ; i < (8 - nAddrLen) ; i ++)
		szAddr[i] = '0' ;
	szAddr[i] = 0x00 ;

	// Concatenate the address
	strcat (szAddr, lpszIPXNetAddr) ;
	strcpy (lpszIPXNetAddr, szAddr) ;
	return ;
}

#ifdef NEW_BOOT_2
BOOL CRouconApp::GetBootVersion (CWnd *pWnd, char *VerStr)
{
	BootConfigType ConfigHeader ;

	if (IsPortIP)
	{
		strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
		strcpy (TFTPGetLocalFileName, LoadPath) ;
		strcat (TFTPGetLocalFileName, "BOOT.CFG") ;

		tftpread TFTPReadDialog ;
		if (TFTPReadDialog.DoModal() != IDOK)
		{
			return FALSE ;
		}

		FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;
		if (FilePointer != NULL)
		{
			fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;
#if BIG_PROXY
			strcpy (VerStr, (LPCSTR) ConfigHeader.Version) ;
#else
			sprintf(VerStr, "%d.%d", ConfigHeader.MajorVersion,
							ConfigHeader.MinorVersion);
#endif
			model = ConfigHeader.ModelNumber;
			fclose (FilePointer) ;
			remove (TFTPGetLocalFileName) ;
			return TRUE ;
		}
		return FALSE ;
	}
	else
	{
		CBootVersion BootDlg (pWnd) ;
		BootDlg.VersionString = VerStr ;

		if (BootDlg.DoModal() == IDCANCEL)
 			return FALSE ;
		else 
			return TRUE ; 
//		BootDlg.DoModal() ;
//		return TRUE ;
	}
}
#endif /* NEW_BOOT_2 */

BOOL IsValidHexadecimalString(LPCSTR pstr)
{
	for (	; *pstr; pstr++)
	{
		if (*pstr >= '0' && *pstr <='9')
			continue;
		if (*pstr >= 'a' && *pstr <='f')
			continue;
		if (*pstr >= 'A' && *pstr <='F')
			continue;
		return FALSE;
	}
	return TRUE;
}

DWORD SwapDWord (DWORD IntelMotorola)
{
	DWORD TempDWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempDWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 3) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 2) ;
	*(TempPtrDest + 2) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 3) = *(TempPtrSrc + 0) ;

	return TempDWord ;
}

WORD SwapWord (WORD IntelMotorola)
{
	WORD TempWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 0) ;

	return TempWord ;
}

void PunctuateLong(LPSTR OutStr, DWORD number)
{
	char tBuf[40];
	int	src_idx, dst_idx, length, copy_len;

	length = sprintf(tBuf, "%lu", number);

	for(src_idx = 0, dst_idx = 0, copy_len = length;
					tBuf[src_idx]; copy_len--, src_idx++, dst_idx++)
	{
		if (src_idx && !((copy_len) % 3))
		{
			OutStr[dst_idx++] = ',';
		}
		OutStr[dst_idx] = tBuf[src_idx];
	}
	OutStr[dst_idx] = 0;

}

void DwordToDayHrMinSecs(LPSTR OutStr, DWORD time)
{
	long days, hours, mins, secs;

	days = time / ((long)60 * 60 * 24);   // number of days

	time %= ((long)60 * 60 * 24);			// remaining hours

	hours = time / (60 * 60);			// number of hours

	time %= (60 * 60);					// remaining minutes

	mins = time / 60;					// number of minutes

	secs = time % 60;					// remaing seconds

	sprintf(OutStr, " %03ld : %02ld : %02ld : %02ld", days, hours, mins, secs);

}
