// roucon.h : main header file for the ROUCON application
//

#ifndef _ROUCON_H_

#define _ROUCON_H_

//#define	BIG_PROXY	1
#undef	BIG_PROXY

#ifdef	BIG_PROXY
#define	REBOOT_TIME	60000l
#else
#define	REBOOT_TIME	15000l
#endif

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif
#define	FILE_NAME_SIZE		128
#define	TFTP_NAME_SIZE		15

#include "resource.h"       // main symbols
#include	"secthdr.h"		//config ini sections
#include "dot.h"
/* Sachin, 03rd October */
#define PPP_USER_NAME_SIZE 61
#define PPP_PASSWORD_SIZE 61
/* Sachin, 03rd October */

#define	NUM_WAN_PORTS	3
#define	NUM_LAN_PORTS	1
#define	MAX_NUM_PORTS	(NUM_WAN_PORTS + NUM_LAN_PORTS)

/* Jo 23/06/99 */
#define	PROXY_ONLY		0 
#define	RAS_ONLY			1 
/* Jo 23/06/99 */

extern UINT NumberOfPorts ;

#define  TempINI  		"ROUCON.INI"
#define  LocalINI 		"SETUP.INI"
#define  IsdnTempINI    "ISDNTA.INI"
#define	CNF_File			"ROUTER.CNF"
#define	DEF_CNF_File	"MTROUTER.CNF"
#define  DEF_ISDN_File  "ISDNDEF.CNF"
#define  DEF_DSU_File   "DSUDEF.CNF"
#define  UDB_COMPR_DBASE_FILE "USER.DTB"
#define  UDB_UNCOMPR_DBASE_FILE "USER.TMR"
#define  LOG_FILE   "PROCON.LOG"
#define	BMP_FILE	  "PRO_DEF.BMP"    // Jo
#define	TEMP_FILE  "TEMP.BMP"    // Jo
#define	TEMP_UPGRADE_FILE  "TMPUPGRD.BMP"    // Jo
#define	UPGRADE_BIN_FILE   "PROXY200.BIN"    // Jo


extern   char LoadPath[FILE_NAME_SIZE];			 // directory pathname of executable file
extern   char OwnIniFile[FILE_NAME_SIZE];		 // configuration ini file "SETUP.INI"
extern   char IniInWinForm[FILE_NAME_SIZE];		 // Router ini file in windows form "ROUCON.INI"
extern   char IniInRtrWareForm[FILE_NAME_SIZE] ; // Router ini file in RouterWare form "ROUTER.CNF"
extern   char ini_INIFilename[FILE_NAME_SIZE];   //Isdnta ini file in windows form "ISDNTA.INI"
extern   char IniInRtrWareFormDef[FILE_NAME_SIZE]; // Router ini file in RouterWare form "ROUTER.CNF"
extern   char LogFileName[FILE_NAME_SIZE];
extern   char RouterBitmapFile[FILE_NAME_SIZE];		//Jo pro_def.bmp
extern   char TempFile[FILE_NAME_SIZE];   			//Jo temp.bmp
extern char TempUpgradeFile[FILE_NAME_SIZE] ; 	// Jo TMPUPGRD.BMP

extern char UDBCompressedDBaseFile[FILE_NAME_SIZE] ;   // Compressed User DBase File
extern char UDBUnCompressedDBaseFile[FILE_NAME_SIZE] ; //  Uncompressed User DBase File
extern	char EtherNetAddr[13];		 // ethernet address printable string form

extern	BOOL	IsPortIP;				// is true if we are going to use TFTP
extern	char	TFTPPutLocalFileName[FILE_NAME_SIZE];
extern	char	TFTPPutRemoteFileName[TFTP_NAME_SIZE];
extern	char	TFTPGetLocalFileName[FILE_NAME_SIZE];
extern	char	TFTPGetRemoteFileName[TFTP_NAME_SIZE];

extern	void RouconCrossCheckPPP(void);
extern	int	ValidIPXNetAddr(LPCSTR NetAddr);
extern   void  PutLeadingZeroes (LPSTR lpszIPXNetAddr) ;

extern void ModifyEndOfRouconIniString (LPCSTR lpcszSection, LPCSTR lpcszLHS, int nCommas, LPCSTR lpcszModifier) ;


extern	CString	MessageString;

extern CString WindowText ;
extern BYTE model;	

extern	LPCSTR	StrEnabled;
extern	LPCSTR	StrDisabled;
extern	LPCSTR	StrNull;

extern	char *DialogTitleFormat;
extern BOOL DefaultSetup ; /* Jo 13/11/98 */

/* 9/7/97 chetan */
extern BOOL IsLanTalker ;
extern BOOL IsRF200 ;
/* 9/7/97 chetan */

#ifdef NEW_BOOT_2
#define BOOT_VER_2 "2.00"
#endif /* NEW_BOOT_2 */



/////////////////////////////////////////////////////////////////////////////
// CRouconApp:
// See roucon.cpp for the implementation of this class
//

class CRouconApp : public CWinApp
{
public:
	CRouconApp();
//	Jo BOOL RAWriteRouterINI();
//	Jo BOOL RAWriteWinINI();
	int wildstrcmp(LPSTR, LPSTR);
	BOOL UpGradeProxy() ;

// Overrides
	virtual BOOL InitInstance();
	int ExitInstance();
// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
	
#ifdef NEW_BOOT_2
	BOOL GetBootVersion (CWnd *pWnd, char *VerStr) ;
	void	GetBootVersionAndSetVars (CWnd *pWnd, char *VerStr);
#endif /* NEW_BOOT_2 */	

	//{{AFX_MSG(CRouconApp)
	afx_msg void OnAppAbout();
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

BOOL RmtLocalIpAddressesOfSameNet (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR AddrMask) ;
BOOL RmtLocalIpAddressesOfSameNet_2 (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR LocalMask, LPCSTR RmtMask);
BOOL RmtLocalIpAddressesHaveDiffHost (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR AddrMask) ;
void ConvertDotDecimal (LPCSTR Addr, unsigned char *pAddr) ;
BOOL IsValidHexadecimalString(LPCSTR pStr);
DWORD SwapDWord (DWORD IntelMotorola);
WORD SwapWord (WORD IntelMotorola);
void PunctuateLong(LPSTR OutStr, DWORD number);
void DwordToDayHrMinSecs(LPSTR OutStr, DWORD time);

/////////////////////////////////////////////////////////////////////////////
#endif
