// prxaddit.cpp : implementation file
//
// Jyothi : 02/07/98. Made changes for Small Proxy.
// Jyothi : 02/07/98. Uses structures instead of Ini file.
//
#include "stdafx.h"
#include "procon.h"
#include "prxaddit.h"
#include "proxy.h"

static LPCSTR ErrMsgHdr = "Proxy Add/Edit Entry";

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// PrxAddit dialog


PrxAddit::PrxAddit(CWnd* pParent /*=NULL*/)
	: CDialog(PrxAddit::IDD, pParent)
{
	//{{AFX_DATA_INIT(PrxAddit)
	m_DescrpWnd = "";
	m_Port = "";
	m_HigherRange = "";
	m_check = FALSE;
	//}}AFX_DATA_INIT
}

void PrxAddit::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(PrxAddit)
	DDX_Control(pDX, IDC_STATIC_2, m_RangeDesWnd);
	DDX_Control(pDX, IDC_EDIT2, m_HighRangeWnd);
	DDX_Control(pDX, IDC_CHECK_RANGE, m_Range);
	DDX_Control(pDX, IDC_COMBO_PORT, m_PortWnd);
	DDX_Control(pDX, IDC_CHECK_UDP, m_UDPCheck);
	DDX_Control(pDX, IDC_CHECK_TCP, m_TCPCheck);
	DDX_Control(pDX, IDC_STATIC1, m_DesStatWnd);
	DDX_Control(pDX, IDC_EDIT1, m_DesEdtWnd);
	DDX_Control(pDX, IDC_STATIC_LINE_HELP, m_LineHelp);
	DDX_Text(pDX, IDC_EDIT1, m_DescrpWnd);	
	DDV_MaxChars(pDX, m_DescrpWnd, 15);
	DDX_CBString(pDX, IDC_COMBO_PORT, m_Port);
	DDX_Text(pDX, IDC_EDIT2, m_HigherRange);
	DDV_MaxChars(pDX, m_HigherRange, 5);
	DDX_Check(pDX, IDC_CHECK_RANGE, m_check);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(PrxAddit, CDialog)
	//{{AFX_MSG_MAP(PrxAddit)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnButtonHelp)
	ON_BN_CLICKED(IDC_CHECK_TCP, OnCheckTcp)
	ON_BN_CLICKED(IDC_CHECK_UDP, OnCheckUdp)
	ON_CBN_SELCHANGE(IDC_COMBO_PORT, OnSelchangeComboPort)
	ON_CBN_EDITCHANGE(IDC_COMBO_PORT, OnEditchangeComboPort)
	ON_BN_CLICKED(IDC_CHECK_RANGE, OnCheckRange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL IsStrNumericAndValid(LPCSTR String)
{
	LPCSTR tmpStr;
	int	LenStr;

	tmpStr = String;

	while (*String)
		if (*String < '0' || *String > '9')
			return FALSE;
		else
			String++;

	LenStr = strlen(tmpStr);	//If string id more than 5 digits error
	if (LenStr > 5)
		return FALSE;

	unsigned long Value;

	sscanf(tmpStr, "%ld", &Value);

	if (Value > 0xFFFFl)
		return FALSE;

	return TRUE;
}

BOOL IsValidDesc(LPCSTR String)
{
	while(*String)
	{
		if((*String < 'a') || (*String > 'z')) 
			if((*String < 'A') || (*String > 'Z')) 
			 	if((*String < '0') || (*String > '9')) 
					return FALSE;
		String++;
	}
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// PrxAddit message handlers

BOOL PrxAddit::OnInitDialog()
{
	CDialog::OnInitDialog();
 
	// TODO: Add extra initialization here
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
   	char Desc[DESC_LEN],dmy3,dmy1,dmy2,tmpPort[PORT_NAME_SIZE];
	char Port1[PORT_NAME_SIZE], Port2[PORT_NAME_SIZE]; // Imran,10/10/98

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
										WindowText.GetBuffer(0),SubHeadingPointer);
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_BUTTON_HELP, this));
	HelpBmpBtn.SizeToContent();

	m_DesEdtWnd.LimitText(DESC_LEN-1);

	m_OProtocol = ((Proxy *)GetParent())->m_CurProtocol;
	m_Port = ((Proxy *)GetParent())->m_CurPort;
	m_OPort = m_Port;					//Store these as we need them in case
	if(strstr(m_Port, pFootNote))
	{
      	    sscanf(m_Port,"%c%[^(]%c%[^)]%c",&dmy3,Desc,&dmy1,tmpPort,&dmy2);
// Imran,10/10/98
		   	if(strchr(tmpPort, (int) ','))
				 {
				 	sscanf(tmpPort,"%[^,]%c%s",Port1,&dmy1,Port2);
					m_Range.SetCheck(TRUE);
					m_Port = Port1;
					m_HigherRange = Port2;
					m_check = TRUE ;   
				 }
				 else
				 {
	      	    m_Port = tmpPort;
					 m_Range.SetCheck(FALSE);
					 m_Range.EnableWindow(FALSE);
					 m_HigherRange = StrNull;
					 m_HighRangeWnd.EnableWindow(FALSE);
					 m_RangeDesWnd.EnableWindow(FALSE);
				  }
// Imran,10/10/98
      	    m_DescrpWnd = Desc;
   	}

	// Update dialog data.
	UpdateData(FALSE);		// The following function gets it from dialog

/* Jo 11/11/98 */
#if 0
	m_TCPWnd.SetCheck(TRUE);
	m_UDPWnd.SetCheck(FALSE);
	if (m_OProtocol == "UDP") 
   	{
		m_TCPWnd.SetCheck(FALSE);
		m_UDPWnd.SetCheck(TRUE);
	}


#endif
/* Jo 11/11/98 */
/* added */

//Imran,8/1/99
	if(m_check==FALSE)
	{
		GetDlgItem(IDC_EDIT2)->EnableWindow(FALSE);
		m_Range.SetCheck(FALSE);
		m_HighRangeWnd.EnableWindow(FALSE);
		m_RangeDesWnd.EnableWindow(FALSE);
	
	}
	else
	{
		GetDlgItem(IDC_EDIT2)->EnableWindow(TRUE);
		m_Range.SetCheck(TRUE);
		m_HighRangeWnd.EnableWindow(TRUE);
		m_RangeDesWnd.EnableWindow(TRUE);
	}
//Imran,8/1/99

	if ( ! m_OProtocol.IsEmpty())
	{	
		if (m_OProtocol == "TCP")
		{
			m_TCPCheck.SetCheck(TRUE);
			m_UDPCheck.SetCheck(FALSE);
			m_UDPCheck.EnableWindow(FALSE);
			m_TCPCheck.EnableWindow(FALSE);
		}
		else
		{
			m_TCPCheck.SetCheck(FALSE);
			m_UDPCheck.SetCheck(TRUE);
			m_TCPCheck.EnableWindow(FALSE);
			m_UDPCheck.EnableWindow(FALSE);
		}
	}
	else
	{
		m_TCPCheck.SetCheck(TRUE);
		m_UDPCheck.SetCheck(TRUE);
	
		AddTcpUdpPorts();
	}

	//Since the above function clears the port field
	if(strstr(m_OPort, pFootNote))
	{
// Imran,10/10/98
		   	if(strchr(tmpPort, (int) ','))
				m_Port = Port1;
		 else
	         m_Port = tmpPort;
	}
// Imran,10/10/98
        else
	      m_Port = ((Proxy *)GetParent())->m_CurPort;
	UpdateData(FALSE);
	OnSelchangeComboPort() ;	//display single line help message

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void PrxAddit::OnButtonHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_PROXY_ADD_EDIT, HELP_CONTEXT);
}

#if 0
/* Jo 11/11/98 */
void PrxAddit::OnOK()
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	char	Protocol[PROTOCOL_NAME_SIZE], Port[PORT_NAME_SIZE];
	//WORD	IntVal;
   int list_index = 0;

	// Validate the Protocol and port values return if wrong
	if (!IsValidEditFields())
		return;
/* Jo 11/11/98 */
#if 0

	if (m_TCPWnd.GetCheck())
		strcpy(Protocol, "TCP");
	else 
		strcpy(Protocol, "UDP");

#endif
/* Jo 11/11/98 */
/* Added */

	if (! m_OProtocol.IsEmpty())
		strcpy(Protocol, m_OProtocol);
 	strcpy(Port, m_Port);

   // Check if this is going to be duplicate, if yes show msg and return
   if(m_DescrpWnd != StrNull) 
   {
      sprintf(Port, "%s%s(%s)", pFootNote, (LPCSTR)m_DescrpWnd, (LPCSTR)m_Port);
   }

	if (m_OProtocol.IsEmpty())		//We are adding a new Protocol-Port to Porxy
	{
		// Check if this is going to be duplicate, if yes show msg and return
      if(m_DescrpWnd != StrNull) 
      {
         if(!((Proxy *)GetParent())->IsUserEntryUnique((LPCSTR)Protocol,(LPCSTR)Port))
         {
            ::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry of same Port for same Protocol.\
               \nCan't add.",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION);
            m_PortWnd.SetFocus();
            return;
         }
      }
      else
      {
		   if ( ! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)Protocol, (LPCSTR)Port))
		   {
			   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry. Can't Add.\
               \nPlease refer to Notes in Help for details",
					   (LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			   return;
		   }
      }
		// Add Entry to list box
		if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached.\n\
            Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			return;
		}
	}
	else		// This means that we are Editing an entry
	{
		if ( ! ((Protocol == m_OProtocol) && (Port == m_OPort)))
		{
			// Check if this is a duplicate, if yes show msg and return
         if(m_DescrpWnd == StrNull)
         {
			   if ( ! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)Protocol, (LPCSTR)Port))
			   {
				   ::MessageBox (GetSafeHwnd(), (LPCSTR) "New entry exists.\
                  \nPlease refer to Notes in Help for details",
					      (LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				   return;
			   }
         }
         if(m_DescrpWnd != StrNull)
         {
            if(!((Proxy *)GetParent())->IsUserEntryUnique((LPCSTR)Protocol,(LPCSTR)Port))
            {
              ::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry of same Port for same Protocol.\
                 \nCan't add.",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION);
              m_PortWnd.SetFocus();
              return;
            }
         }
			//Remove the old entry, since it is to be replaced
			if ( !((Proxy *)GetParent())->DeleteEntry((LPCSTR)m_OProtocol, (LPCSTR)m_OPort))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Internal Error.\n\
               Couldn't Delete selection.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				return;
			}
			// Add Entry the new entry to list box
			if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached!\n\
               Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				return;
			}
			
		}	//else means the new entry and old entry match so nothing to do
	}

	CDialog::OnOK();
}

#endif 
/* Jo 11/11/98 */


void PrxAddit::OnOK()
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	char	Protocol[PROTOCOL_NAME_SIZE], Port[PORT_NAME_SIZE];
	//WORD	IntVal;
	int list_index = 0;

	// Validate the Protocol and port values return if wrong
	if (!IsValidEditFields())
		return;
	
	if (! m_OProtocol.IsEmpty())
		strcpy(Protocol, m_OProtocol);

 	strcpy(Port, m_Port);

	// Check if this is going to be duplicate, if yes show msg and return
	if(m_DescrpWnd != StrNull) 
	{
		//strncpy(Descrptn, m_DescrpWnd, DESC_LEN);
		if(!m_Range.GetCheck())  
			sprintf(Port, "%s%s(%s)", pFootNote, (LPCSTR)m_DescrpWnd, (LPCSTR)m_Port);
		else
			sprintf(Port, "%s%s(%s,%s)", pFootNote, (LPCSTR)m_DescrpWnd, (LPCSTR)m_Port, (LPCSTR) m_HigherRange);
		
	}

	if (m_OProtocol.IsEmpty())		//We are adding a new Protocol-Port to Proxy
	{
	// Check if this is going to be duplicate, if yes show msg and return
		if(m_DescrpWnd != StrNull) 
		{
		/* The Above Check is for user defined Ports */
// Imran, 4/1/99
			if(m_TCPCheck.GetCheck())
			{
				strcpy(Protocol, "TCP");
				if (!((Proxy *)GetParent())->IsUserEntryUnique((LPCSTR)Protocol,(LPCSTR)Port))
				{
 				   m_PortWnd.SetFocus();
				   return;
				}
		 	}

		 	if(m_UDPCheck.GetCheck())
		 	{
   	 			strcpy(Protocol, "UDP");
		 		if (!((Proxy *)GetParent())->IsUserEntryUnique((LPCSTR)Protocol,(LPCSTR)Port))
		 		{
	 		          m_PortWnd.SetFocus();
 		                  return;
				}
			}

		 	if(m_TCPCheck.GetCheck())
			{
				strcpy(Protocol, "TCP");
		     		 if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
	 		   	 { 
		  			::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached.\n\
			  		Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			  		return;
			   	 }
			 }

		 	if(m_UDPCheck.GetCheck())
			{
				strcpy(Protocol, "UDP");
			   if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
 			   {
 					::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached.\n\
 					Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
	 				return;
		 	   }
			}
// Imran, 4/1/99
		}
		else  //Some Reserved Ports are to be added
		{
			if (m_TCPCheck.GetCheck())
			{
				strcpy(Protocol, "TCP");
				if (  ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)Protocol, (LPCSTR)Port))
				{
					if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
					{
						::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached.\n\
						Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
						return;
					}
				}
			}

			// Code added for UDP Port 

			if (m_UDPCheck.GetCheck())
			{
				strcpy(Protocol, "UDP");
				if (  ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)Protocol, (LPCSTR)Port))
				{
/*					::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry. Can't Add.\
	       	       			\nPlease refer to Notes in Help for details",
					   (LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
					return; */

					if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
					{
						::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached.\n\
						Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
						return;
					}
				}
			}
		
      		}
	}
	else		// This means that we are Editing an entry
	{
// Imran,7/1/99
		char Desc[20],dmy1,dmy2;
		int LoPortVal,HiPortVal;
  		if(strstr(m_OPort, pFootNote))
		{
			if(strchr(m_OPort, (int) ','))
			{
			 	sscanf(m_OPort,"%c%[^(]%c%d%c%d",&dmy1,Desc,&dmy1,&LoPortVal,&dmy1,&HiPortVal);
				if ((Protocol == m_OProtocol) && (m_Port == LoPortVal) && 
							(m_HigherRange == HiPortVal) && (!strcmpi(Desc,m_DescrpWnd)))
					goto NOCHANGE;
			}
			else
			{
			  	sscanf(m_OPort,"%c%[^(]%c%d",&dmy1, Desc,&dmy1,&LoPortVal);
				if ((Protocol == m_OProtocol) && (m_Port == LoPortVal) && 
							(!strcmpi(Desc,m_DescrpWnd)))
					goto NOCHANGE;
			}
		}
// Imran,7/1/99
	
		if ( ! ((Protocol == m_OProtocol) && (Port == m_OPort)))
		{
			// Check if this is a duplicate, if yes show msg and return
			if(m_DescrpWnd == StrNull)
         		{
			   if ( ! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)Protocol, (LPCSTR)Port))
			   {
				   ::MessageBox (GetSafeHwnd(), (LPCSTR) "New entry exits.\
		                  \nPlease refer to Notes in Help for details",
					      (LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				   return;
			   }
		        }

		        if(m_DescrpWnd != StrNull)
		        {
		            if(!((Proxy *)GetParent())->IsUserEntryUnique((LPCSTR)Protocol,(LPCSTR)Port))
		            {
/*			              ::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry of same Port for same Protocol.\
		        	      \nCan't add.",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION); */
			              m_PortWnd.SetFocus();
			              return;
		            }
		        }
			
			//Remove the old entry, since it is to be replaced
			if ( !((Proxy *)GetParent())->DeleteEntry((LPCSTR)m_OProtocol, (LPCSTR)m_OPort))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Internal Error.\n\
               			Couldn't Delete selection.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				return;
			}

			// Add Entry the new entry to list box
			if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached!\n\
		                Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				return;
			}
			
		}	//else means the new entry and old entry match so nothing to do
	}

NOCHANGE:
	((Proxy *)GetParent())->GlbIndex = 0; 
	CDialog::OnOK();
}

BOOL PrxAddit::IsValidEditFields(void)
{
	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char	Protocol[PROTOCOL_NAME_SIZE];
	char	Port[PORT_NAME_SIZE];
	CString m_Protocol;

	if (m_Port.IsEmpty())
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Port can't be empty",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return FALSE;
	}

#if 0 /* Jo for User defined entries */
   if (m_PortWnd.GetCurSel() == CB_ERR)
   {
	::MessageBox (GetSafeHwnd(), (LPCSTR) "Select a port",
		(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
	return FALSE;
   }
#endif
   if (m_Range.GetCheck() && m_HigherRange == StrNull)
   {
      ::MessageBox(GetSafeHwnd(),(LPCSTR) "Enter a higher port range",
        (LPCSTR) ErrMsgHdr,MB_OK);
       m_HighRangeWnd.SetFocus();
      return FALSE;
   }

   if(m_DesEdtWnd.IsWindowEnabled() && m_DescrpWnd == StrNull)
   {
      ::MessageBox(GetSafeHwnd(),(LPCSTR) "Enter a description for the port",
         (LPCSTR) ErrMsgHdr,MB_OK);
      m_DesEdtWnd.SetFocus();
      return FALSE;
   }

	if(m_DesEdtWnd.IsWindowEnabled() && m_DescrpWnd == " ")
   {
      ::MessageBox(GetSafeHwnd(),(LPCSTR) "Enter a description for the port",
         (LPCSTR) ErrMsgHdr,MB_OK);
      m_DesEdtWnd.SetFocus();
      return FALSE;
   }

	if (strstr((LPCSTR) m_DescrpWnd, pFootNote))
	{
		char szBuf[80];
		sprintf(szBuf, "Can't use '%s' in description", pFootNote);
	        ::MessageBox(GetSafeHwnd(),(LPCSTR) szBuf,
        	 (LPCSTR) ErrMsgHdr,MB_OK);
	        m_DesEdtWnd.SetFocus();
	        return FALSE;
	}


	if (!IsValidDesc(m_DescrpWnd))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid description",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
	   m_DesEdtWnd.SetFocus();
		return FALSE;
	}

	int port;
	port = atoi (m_Port);
	if(m_DesEdtWnd.IsWindowEnabled())
	{
		if(port == 0)
		{	
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Port entered",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		        m_PortWnd.SetFocus();
			return FALSE;
		}

		port = atoi (m_HigherRange);
		if(m_Range.GetCheck() && !port)
		{	
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Port entered",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			   m_HighRangeWnd.SetFocus();
	 		return FALSE;
		}
	}	

 	if(strchr(m_DescrpWnd, (int) ','))
	{
		char szBuf[80];
		sprintf(szBuf, "Can't use '%s' in description", PortSeparator);
	        ::MessageBox(GetSafeHwnd(),(LPCSTR) szBuf,
        	 (LPCSTR) ErrMsgHdr,MB_OK);
	        m_DesEdtWnd.SetFocus();
	        return FALSE;
	}

	if (m_TCPCheck.GetCheck())
		m_Protocol = "TCP";
	else 
		m_Protocol = "UDP";

	//Form the ProtocolPortName
	((Proxy *)GetParent())->GetProtocolPortName(m_Protocol, m_Port, ProtocolPort);

	//Now get the ProtocolPortNumber from the ProtocolPortName
	((Proxy *)GetParent())->GetProtocolPortNumber(ProtocolPort, Protocol, Port, 0);

	if ( ! IsStrNumericAndValid(Port))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_PortWnd.SetFocus();
		return FALSE;
	}
	if (m_Range.GetCheck())
	{
		//Form the ProtocolPortName
		((Proxy *)GetParent())->GetProtocolPortName(m_Protocol, m_HigherRange, ProtocolPort);

		//Now get the ProtocolPortNumber from the ProtocolPortName
		((Proxy *)GetParent())->GetProtocolPortNumber(ProtocolPort, Protocol, Port, 0);

		 if ( ! IsStrNumericAndValid(Port))
		 {
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_HighRangeWnd.SetFocus();
			return FALSE;
		 }

		int LoRangeVal,HiRangeVal;
		
		sscanf(m_Port,"%d",&LoRangeVal);
		sscanf(m_HigherRange,"%d",&HiRangeVal);

//		if((strcmp(m_Port,m_HigherRange) > 0) || (!strcmp(m_Port,m_HigherRange)))
		if((LoRangeVal > HiRangeVal) || (LoRangeVal == HiRangeVal))
		{
		  ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Port Range",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_HighRangeWnd.SetFocus();
			return FALSE;
		 }
	}
	
	return TRUE;
}

/* Jo 11/11/98 */
#if 0
void PrxAddit::OnRadioTcp()
{
	// TODO: Add your control notification handler code here
	int	ProtocolIndex, PortIndex = 0;
	char PortName[PORT_NAME_SIZE];
	char ProtocolName[PROTOCOL_NAME_SIZE];

	UpdateData(TRUE);		//update the variables from dialog
	
	//First rest the contents of the list in combobox
	m_PortWnd.ResetContent();

	if (m_TCPWnd.GetCheck())
	{
		ProtocolIndex = 0;
		strcpy(ProtocolName, "TCP");
	}
	else
	{
		ProtocolIndex = 1;
		strcpy(ProtocolName, "UDP");
	}

	// add the ports known for this protocol
	while (((Proxy *) GetParent())->GetPortName(ProtocolIndex,
															PortIndex, PortName))
	{
		//Add this port if not present in list already
		if (((Proxy *) GetParent())->IsEntryUnique(ProtocolName, PortName))
			m_PortWnd.AddString(PortName);
		PortIndex++;
	}
	
}

void PrxAddit::OnRadioUdp()
{
	// TODO: Add your control notification handler code here
	OnRadioTcp();
}
#endif

/* Jo */
#if 0
void PrxAddit::OnSelchangeListPort()
{
	// TODO: Add your control notification handler code here
	
	char PortName[PORT_NAME_SIZE];
	char ProtocolName[PROTOCOL_NAME_SIZE];
	int	SelIndex;

/* Jo 11/11/98 */
#if 0
	if (m_TCPCheck.GetCheck())
	{
		strcpy(ProtocolName, "TCP");
	}
	else
	{
		strcpy(ProtocolName, "UDP");
	}
#endif

	if (  m_OProtocol.IsEmpty()) // When Add Option Choosed
	{
		m_TCPCheck.SetCheck(TRUE);
		m_TCPCheck.EnableWindow(TRUE);
		m_UDPCheck.SetCheck(TRUE);
		m_UDPCheck.EnableWindow(TRUE);
	}

	if ((SelIndex = m_PortWnd.GetCurSel()) != LB_ERR)
	{
		m_PortWnd.GetText(SelIndex, PortName);		
		m_LineHelp.SetWindowText(((Proxy *) GetParent())->GetProtocolPortHelp(ProtocolName, PortName));
		m_DesEdtWnd.EnableWindow(FALSE);
		m_DesStatWnd.EnableWindow(FALSE);

		strcpy(ProtocolName, "TCP");
		if (! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)ProtocolName,(LPCSTR)PortName))
		{
			m_TCPCheck.SetCheck(TRUE);
			m_TCPCheck.EnableWindow(FALSE);
		}

		strcpy(ProtocolName, "UDP");
		if (! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)ProtocolName,(LPCSTR)PortName))
		{
			m_UDPCheck.SetCheck(TRUE);
			m_UDPCheck.EnableWindow(FALSE);
		}

		m_LineHelp.SetWindowText("Note : Protocol that is grayed-out is already mapped.");

		// Till Here
	}
	else if(m_OProtocol.IsEmpty())
	{
		m_LineHelp.SetWindowText("Select from list");
		m_DesEdtWnd.EnableWindow(TRUE);
		m_DesStatWnd.EnableWindow(TRUE);
	}
}
#endif
/* Jo */

/* 11/11/98 check */
void PrxAddit::AddTcpUdpPorts()
{
	int	ProtocolIndex, PortIndex = 0;
	char PortName[PORT_NAME_SIZE];
	char ProtocolName[PROTOCOL_NAME_SIZE];

	UpdateData(TRUE);		//update the variables from dialog
	
	//First rest the contents of the list in combobox
	m_PortWnd.ResetContent();

	ProtocolIndex = 0;
	strcpy(ProtocolName, "TCP");

	// add the ports known for this protocol
	while (((Proxy *) GetParent())->GetPortName(ProtocolIndex, PortIndex, PortName))
	{
		//Add this port if not present in list already
		if (((Proxy *) GetParent())->IsEntryUnique(ProtocolName, PortName))
			m_PortWnd.AddString(PortName);
		PortIndex++;
	}

	ProtocolIndex = 1;
        PortIndex = 0;
	strcpy(ProtocolName, "UDP");
      
	while (((Proxy *) GetParent())->GetPortName(ProtocolIndex, PortIndex, PortName))
	{
		//Add this port if not present in list already
		if (((Proxy *) GetParent())->IsEntryUnique(ProtocolName, PortName) && (m_PortWnd.FindStringExact(-1, PortName) == CB_ERR))
			m_PortWnd.AddString(PortName);
		PortIndex++;
	}
}

void PrxAddit::OnCheckTcp()
{
	// TODO: Add your control notification handler code here
	
}

void PrxAddit::OnCheckUdp()
{
	// TODO: Add your control notification handler code here
	
}

void PrxAddit::OnSelchangeComboPort()
{
	// TODO: Add your control notification handler code here
	
	char PortName[PORT_NAME_SIZE];
	char ProtocolName[PROTOCOL_NAME_SIZE];
	int	SelIndex;

 
/* Jo 11/11/98 */
#if 0
	if (m_TCPWnd.GetCheck())
	{
		strcpy(ProtocolName, "TCP");
	}
	else
	{
		strcpy(ProtocolName, "UDP");
	}
#endif
/* Jo TCP/UPD checkbox */

	if (  m_OProtocol.IsEmpty()) // When Add Option Choosed
	{
		m_TCPCheck.SetCheck(TRUE);
		m_TCPCheck.EnableWindow(TRUE);
		m_UDPCheck.SetCheck(TRUE);
		m_UDPCheck.EnableWindow(TRUE);
	}

	if ((SelIndex = m_PortWnd.GetCurSel()) != LB_ERR)
	{
		m_PortWnd.GetLBText(SelIndex, PortName);		
		m_LineHelp.SetWindowText(((Proxy *) GetParent())->GetProtocolPortHelp(ProtocolName, PortName));
		m_DesEdtWnd.EnableWindow(FALSE);
		m_DesStatWnd.EnableWindow(FALSE);
// Imran
		m_Range.SetCheck(FALSE);
		m_Range.EnableWindow(FALSE);
		m_RangeDesWnd.EnableWindow(FALSE);
		m_HighRangeWnd.EnableWindow(FALSE);
// Imran
		strcpy(ProtocolName, "TCP");
		if (! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)ProtocolName,(LPCSTR)PortName))
		{
			m_TCPCheck.SetCheck(TRUE);
			m_TCPCheck.EnableWindow(FALSE);
		}

		strcpy(ProtocolName, "UDP");
		if (! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)ProtocolName,(LPCSTR)PortName))
		{
			m_UDPCheck.SetCheck(TRUE);
			m_UDPCheck.EnableWindow(FALSE);
		}

		m_LineHelp.SetWindowText("Note : Protocol that is grayed-out is already mapped.");

		// Till Here
	}
	else if(m_OProtocol.IsEmpty())
	{
		m_LineHelp.SetWindowText("Enter a decimal Port number or select from list");
		m_DesEdtWnd.EnableWindow(TRUE);
		m_DesStatWnd.EnableWindow(TRUE);
	}
}

void PrxAddit::OnEditchangeComboPort()
{
	// TODO: Add your control notification handler code here
	
	if (m_PortWnd.GetCurSel() != LB_ERR)
	{
		m_PortWnd.SetCurSel(-1);	//remove the selection, reset edit box
		OnSelchangeComboPort();		//change the single line help message
	}
}

// Imran,8/1/99
void PrxAddit::OnCheckRange()
{
	// TODO: Add your control notification handler code here
	 UpdateData(TRUE);
	if(m_check==TRUE)
	{
		GetDlgItem(IDC_EDIT2)->EnableWindow(TRUE); 
		m_Range.SetCheck(TRUE);
		m_HighRangeWnd.EnableWindow(TRUE);
		m_RangeDesWnd.EnableWindow(TRUE);
	
	}
	else
	{	
		GetDlgItem(IDC_EDIT2)->EnableWindow(FALSE); 
		m_Range.SetCheck(FALSE);
		m_HighRangeWnd.EnableWindow(FALSE);
		m_RangeDesWnd.EnableWindow(FALSE);
	}
}
// Imran,8/1/99
