// Jyothi : Reads contents from the .bmp file in motorola format to the 
//	    corresponding structure in Intel format
//	  : Writes to the .bmp file in motorola format from structures in intel format

#include <io.h>
#include <stdio.h>
#include "stdafx.h"
#include "procon.h"
#include "cnffile.h"
#include "utils.h"
#include "readbmp.h"
#include "upgrade.h"

// #define FULL_FILE_NAME_LEN   8
#define NO_OF_SECTIONS      7
#define NO_OF_OLD_SECTIONS	 6	      
ULONG offset ;
ULONG sectlen ;
extern char RouterBitmapFile[FILE_NAME_SIZE] ;

CNF_IP *ip_ptr ;
CNF_WAN *wan_ptr ;
CNF_PPP *ppp_ptr ;
CNF_PROXY_HEADER *proxy_header_ptr ;
CNF_DHCP_HEADER *dhcp_header_ptr ;
CNF_STATIC_ROUTES_HEADER *static_routes_header_ptr ;


CNF_UPGRADE_IP *upgrade_ip_ptr ;
CNF_WAN *upgrade_wan_ptr ;
CNF_UPGRADE_PPP *upgrade_ppp_ptr ;
CNF_UPGRADE_PROXY_HEADER *upgrade_proxy_header_ptr ;
CNF_UPGRADE_DHCP_HEADER *upgrade_dhcp_header_ptr ; 

ALL_STRUCTURES all_structures[NO_OF_SECTIONS] = 
{
	{ 0x5580, (void *) NULL, 	sizeof (CNF_IP)    			},
	{ 0x5582, (void *) NULL, 	sizeof (CNF_WAN)   			},
	{ 0x5581, (void *) NULL, 	sizeof (CNF_PPP)   			},
	{ 0x5583, (void *) NULL, 	sizeof (CNF_PROXY) 			},
	{ 0x5584, (void *) NULL, 	sizeof (CNF_DHCP)  			},
	{ 0x5585, (void *) NULL, 	sizeof (CNF_STATIC_ROUTES) },
	{ END_OF_SECTION, (void *) NULL,            NULL   	}
};

ALL_STRUCTURES temp_upgrade_structures[NO_OF_OLD_SECTIONS] = 
{
	{ 0x5580, (void *) NULL, 	sizeof (CNF_UPGRADE_IP)		},
	{ 0x5582, (void *) NULL, 	sizeof (CNF_WAN)   			},
	{ 0x5581, (void *) NULL, 	sizeof (CNF_UPGRADE_PPP)   },
	{ 0x5583, (void *) NULL, 	sizeof (CNF_UPGRADE_PROXY)	},
	{ 0x5584, (void *) NULL, 	sizeof (CNF_UPGRADE_DHCP)	},
	{ END_OF_SECTION, (void *) NULL,            NULL   	}
};

void initialize_size_of_struct()
{	
	all_structures[0].size_of_struct = sizeof (CNF_IP) ;		
	all_structures[1].size_of_struct = sizeof (CNF_PPP) ;		
	all_structures[2].size_of_struct = sizeof (CNF_WAN) ;		
	all_structures[3].size_of_struct = sizeof (CNF_PROXY) ;		
	all_structures[4].size_of_struct = sizeof (CNF_DHCP) ;	
	all_structures[5].size_of_struct = sizeof (CNF_STATIC_ROUTES) ;	
}																		

void	free_struct_mem(void)
{
	int  section_no ;
	for (section_no = 0; all_structures[section_no].section_id != END_OF_SECTION; section_no++)
	{
		if (all_structures[section_no].glblck)
		{
			GlobalUnlock(all_structures[section_no].glblck) ;
  			GlobalFree(all_structures[section_no].glblck) ;
			all_structures[section_no].glblck = NULL ;
			all_structures[section_no].ptr_to_struct = NULL ;
		}
	}
}

void GetSectionLength(int i)
{
	switch(i)
   {
		case IP_ID:
				sectlen = change_endian (((CNF_IP *) all_structures[IP_ID].ptr_to_struct)->ip_header.section_length) ;
				break;
		case PPP_ID:
				sectlen = change_endian (((CNF_PPP *) all_structures[PPP_ID].ptr_to_struct)->ppp_header.section_length) ;
				break;
		case WAN_ID:
				sectlen = change_endian (((CNF_WAN *) all_structures[WAN_ID].ptr_to_struct)->wan_header.section_length) ;
				break;
		case PROXY_ID:
				sectlen = change_endian (((CNF_PROXY *) all_structures[PROXY_ID].ptr_to_struct)->proxy_header.section_length) ;
				break;
		case DHCP_ID:
				sectlen = change_endian (((CNF_DHCP *) all_structures[DHCP_ID].ptr_to_struct)->dhcp_header.section_length) ;
				break;
		case STATIC_ROUTES_ID:
				sectlen = change_endian (((CNF_STATIC_ROUTES *) all_structures[STATIC_ROUTES_ID].ptr_to_struct)->static_routes_header.section_length) ;
				break;
	}
}

BOOL Read_from_bmp_to_struct(char filename[])
{
	CFile routbin;
	int fileopened = 1, section_no = 0, flag ;
	USHORT sectlen;
	HeaderTagType HeaderTag;

	if (routbin.Open (filename, CFile::modeRead|CFile::typeBinary,NULL) != FALSE) 
	{
		initialize_size_of_struct() ;
		for (section_no = 0; all_structures[section_no].section_id != END_OF_SECTION; section_no++)
		{
			if (routbin.Read((void far *)&HeaderTag, sizeof(HeaderTagType)) != 
						sizeof(HeaderTagType))
			{
				MessageBox(NULL,"Could not read header from bitmap file","",MB_OK);
				free_struct_mem();
				return FALSE;
			}

			sectlen = change_endian(HeaderTag.SectionLength); 
			routbin.Seek(-(long)(sizeof(HeaderTag)), CFile::current);
		
			all_structures[section_no].glblck = GlobalAlloc (GPTR,sectlen);
 
			all_structures[section_no].ptr_to_struct = GlobalLock
							(all_structures[section_no].glblck);

			if (all_structures[section_no].ptr_to_struct == NULL)
			{
       		MessageBox (NULL, "Global alloc Failed", "Utility", MB_OK);
				free_struct_mem();
				return FALSE;
			}
		
			if(routbin.Read(all_structures[section_no].ptr_to_struct, sectlen) != sectlen)
			{
				MessageBox(NULL,"Could not read struct from file","",MB_OK);
				free_struct_mem();
				return FALSE;
			}
		}
      routbin.Close() ;
		ip_ptr = ((CNF_IP *)(all_structures[IP_ID].ptr_to_struct))	;
		wan_ptr = ((CNF_WAN *)(all_structures[WAN_ID].ptr_to_struct)) ;
		ppp_ptr = ((CNF_PPP *)(all_structures[PPP_ID].ptr_to_struct)) ;
		proxy_header_ptr = ((CNF_PROXY_HEADER *)(all_structures[PROXY_ID].ptr_to_struct)) ;
		dhcp_header_ptr = ((CNF_DHCP_HEADER *)(all_structures[DHCP_ID].ptr_to_struct)) ;  
		static_routes_header_ptr = ((CNF_STATIC_ROUTES_HEADER *)(all_structures[STATIC_ROUTES_ID].ptr_to_struct)) ;  

	 } 
	 else
 	 {
		MessageBox(NULL,"Could not .bmpfile","",MB_OK) ;
	 	return FALSE ;
	 }
	 flag = 0 ;
	 change_ip_structure (flag) ; 
  	 change_wan_structure (flag) ;
	 change_ppp_structure (flag) ;
	 change_proxy_structure (flag) ;
	 change_dhcp_structure (flag) ; 
	 change_static_routes_structure (flag) ; 
	 return TRUE;
}


BOOL Write_from_struct_to_bmp(char filename[], BOOL FreeMemoryFlag)
{
   FILE *bmpfile ;
   int cnt, flag ;
   char bmpfilename[128] ;

   int index = 0, storeindex = 0, section_no = 0, length = 2 ;
   USHORT dummy_value ;

   flag = 1 ;
   strcpy(bmpfilename, filename) ;
   
   if ((bmpfile=fopen(bmpfilename,"wb"))==NULL)
   {
      MessageBox(NULL,"Could not open bitmap file", "", MB_OK) ;
      return FALSE ;
   }

   section_no = 0 ;

   ip_ptr = ((CNF_IP *)(all_structures[IP_ID].ptr_to_struct))	;
   wan_ptr = ((CNF_WAN *)(all_structures[WAN_ID].ptr_to_struct)) ;
   ppp_ptr = ((CNF_PPP *)(all_structures[PPP_ID].ptr_to_struct)) ;
   proxy_header_ptr = ((CNF_PROXY_HEADER *)(all_structures[PROXY_ID].ptr_to_struct)) ;
   dhcp_header_ptr = ((CNF_DHCP_HEADER *)(all_structures[DHCP_ID].ptr_to_struct)) ;  
	static_routes_header_ptr = ((CNF_STATIC_ROUTES_HEADER *)(all_structures[STATIC_ROUTES_ID].ptr_to_struct)) ;  

   change_ip_structure (flag) ; 
   change_wan_structure (flag) ;
   change_ppp_structure (flag) ;
   change_proxy_structure (flag) ;
   change_dhcp_structure (flag) ; 
	change_static_routes_structure (flag) ; 

   while (all_structures[section_no].section_id != END_OF_SECTION)
   {
		GetSectionLength (section_no) ;
		if ((cnt = fwrite(all_structures[section_no].ptr_to_struct, sectlen, 1, bmpfile)) < 1)
		{
			MessageBox(NULL, "Could not write into bitmap file", "", MB_OK) ;
			fclose(bmpfile) ;
			free_struct_mem() ;
			return FALSE ;
		}
		section_no++ ; 
   }
   dummy_value = change_endian (65535) ;
   cnt = fwrite ((void *)&dummy_value, length, 1, bmpfile) ;
   fclose(bmpfile) ;

   if (FreeMemoryFlag)
		free_struct_mem() ;
   else
   {
		flag = 0 ;
		change_ip_structure (flag) ; 
		change_wan_structure (flag) ;
		change_ppp_structure (flag) ;
		change_proxy_structure (flag) ;
		change_dhcp_structure (flag) ; 
		change_static_routes_structure (flag) ; 
   }
   return TRUE ;
}		  							 	          							

BOOL check_if_setup_has_changed ()
{
	FILE *cnfptr, *tempptr ;
	BYTE cnf_value, temp_value ;
	BOOL flag ;

	cnfptr = fopen(IniInRtrWareForm, "rb") ;
	if (cnfptr == NULL)
	{
		MessageBox (NULL, "Error Opening File", "", MB_OK) ;
		return FALSE ;
	}
 	tempptr = fopen (TempFile, "rb") ;
	if (tempptr == NULL)
	{
		MessageBox (NULL, "Error Opening File", "", MB_OK) ;
		return FALSE ;
	}

	while(!feof(cnfptr) && !feof(tempptr))
	{
		fread (&cnf_value, sizeof(BYTE), 1, cnfptr) ;
		fread (&temp_value, sizeof(BYTE), 1, tempptr) ;
		if (cnf_value != temp_value)
			break ;
	}
	if (!feof(cnfptr) || !feof(tempptr))
		flag = TRUE ;
	else
		flag = FALSE ;

	fclose(cnfptr)	;
	fclose(tempptr) ;
	remove(TempFile) ;
	return flag ;
}

void	free_temp_upgrade_struct_mem(void)
{
	int  section_no ;
	for (section_no = 0; temp_upgrade_structures[section_no].section_id != END_OF_SECTION; section_no++)
	{
		if (temp_upgrade_structures[section_no].glblck)
		{
			GlobalUnlock(temp_upgrade_structures[section_no].glblck) ;
  			GlobalFree(temp_upgrade_structures[section_no].glblck) ;
			temp_upgrade_structures[section_no].glblck = NULL ;
			temp_upgrade_structures[section_no].ptr_to_struct = NULL ;
		}
	}
}

BOOL Read_from_old_bmp_to_temp_struct(char filename[])
{
	CFile routbin;
	int fileopened = 1, section_no = 0, flag ;
	USHORT sectlen;
	HeaderTagType HeaderTag;

	if (routbin.Open (filename, CFile::modeRead|CFile::typeBinary,NULL) != FALSE) 
	{
		for (section_no = 0; temp_upgrade_structures[section_no].section_id != END_OF_SECTION; section_no++)
		{
			if (routbin.Read((void far *)&HeaderTag, sizeof(HeaderTagType)) != 
						sizeof(HeaderTagType))
			{
				MessageBox(NULL,"Could not read header from bitmap file","",MB_OK);
				free_temp_upgrade_struct_mem();
				return FALSE;
			}

			sectlen = change_endian(HeaderTag.SectionLength) ; 
			routbin.Seek(-(long)(sizeof(HeaderTag)), CFile::current);
		
			temp_upgrade_structures[section_no].glblck = GlobalAlloc (GPTR,sectlen) ;
 
			temp_upgrade_structures[section_no].ptr_to_struct = GlobalLock
							(temp_upgrade_structures[section_no].glblck);

			if (temp_upgrade_structures[section_no].ptr_to_struct == NULL)
			{
       		MessageBox (NULL, "Global alloc Failed", "Utility", MB_OK);
				free_struct_mem();
				return FALSE;
			}
		
			if(routbin.Read(temp_upgrade_structures[section_no].ptr_to_struct, sectlen) != sectlen)
			{
				MessageBox(NULL,"Could not read struct from file","",MB_OK);
				free_struct_mem();
				return FALSE;
			}
		}
      routbin.Close() ;
		upgrade_ip_ptr = ((CNF_UPGRADE_IP *)(temp_upgrade_structures[IP_ID].ptr_to_struct)) ;
		upgrade_wan_ptr = ((CNF_WAN *)(temp_upgrade_structures[WAN_ID].ptr_to_struct)) ;
		upgrade_ppp_ptr = ((CNF_UPGRADE_PPP *)(temp_upgrade_structures[PPP_ID].ptr_to_struct)) ;
		upgrade_proxy_header_ptr = ((CNF_UPGRADE_PROXY_HEADER *)(temp_upgrade_structures[PROXY_ID].ptr_to_struct)) ;
		upgrade_dhcp_header_ptr = ((CNF_UPGRADE_DHCP_HEADER *)(temp_upgrade_structures[DHCP_ID].ptr_to_struct)) ;  
	 } 
	 else
 	 {
		MessageBox(NULL,"Could not .bmpfile","",MB_OK) ;
	 	return FALSE ;
	 }
	 flag = 0 ;
  	 change_old_ip_structure (flag) ;
  	 change_old_wan_structure (flag) ;
	 change_old_ppp_structure (flag) ;
	 change_old_proxy_structure (flag) ; 
	 change_old_dhcp_structure (flag) ; 
	 return TRUE;
}
