/*--------------------------------------------------------------------------*/
/*	File		:	LOOPS.C													*/
/*	Purpose		:	This file contains loop statement routines.				*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#ifdef WIN
#include	"windows.h"
#endif

#include	"errcons.h"
#include	"scrtcons.h"
#include	"scrtmesg.h"

#include	"scrttype.h"
#include	"scrtdata.h"
#include	"scrtfuns.h"

/*--------------------------------------------------------------------------*/
/*	Name		:	PforStatement											*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <for_statement>									*/
/*--------------------------------------------------------------------------*/

int		PforStatement(CodeTypeFptr *c_ptr)
{
	byte	endfor_label[LABEL_NAME_LEN];	/*	End of loop.	*/
	byte	loopbody_label[LABEL_NAME_LEN];	/*	Beginning of loop body.	*/
	byte	stepexpr_label[LABEL_NAME_LEN];	/*	Step expression label.	*/
	byte	termcondn_label[LABEL_NAME_LEN];	/*	Terminating condition.	*/
	byte	temp_name[MAX_TOKEN_LEN];
	byte	up_direction;	/*	Control variable goes up or down.	*/
	int		sym_type;
	SymInfoType	*sym_ptr;
	ExprNodeType	*expr_ptr;
	CodeTypeFptr	c_ptr1;
	CodeTypeFptr	c_ptr2;

	*c_ptr = c_ptr1 = c_ptr2 = 0;
	sym_ptr = 0;
	up_direction = 1;	/*	Assume control variable goes up.	*/
	sym_type = E_INTEGER;	/*	Assume integer type.	*/
	c_ptr1 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
	GetToken();
	if (Token == Q_ID) {
		sym_ptr = FindSymbol(TokenStr);
		if (sym_ptr) {
			switch (sym_ptr->SymClass) {
				case Q_INTEGER : sym_type = E_INTEGER; break;
				case Q_REAL : sym_type = E_REAL; break;
				case Q_STRING : sym_type = E_STRING; break;
			}
			if (sym_ptr->SymClass == Q_PROC)
				Error(ERR_ASSIGNMENT_TO_FN_NAME);
		}
		else
			Error(ERR_ID_NOT_DECLARED);
		GetToken();
	}
	else {
		Error(ERR_ID_EXPECTED);
		goto error_exit;
	}
	if (Token == Q_ASSIGNMENT)
		GetToken();
	else {
		Error(ERR_ASSIGNMENT_EXPECTED);
		goto error_exit;
	}
	Pexpression(&expr_ptr);
	if (expr_ptr) {
		TempVarCount = 0;	/*	Reset temporaries count.	*/
		EmitExpression(expr_ptr, &c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		if (sym_ptr) {
			CheckAssignment(sym_ptr, expr_ptr);
			c_ptr2 = EmitCode(Q_MOV, expr_ptr->ExprType, expr_ptr->Name,
									expr_ptr->ExprType, 0, sym_ptr->Name);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		}
		KillTemporaries(&c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		ReleaseNodes(expr_ptr);
	}
	if (Token == Q_TO || Token == Q_DOWNTO) {
		up_direction = (byte) (Token == Q_TO);
		GetToken();
	}
	else {
		Error(ERR_TO_DOWNTO_EXPECTED);
		goto error_exit;
	}
	/*	Put the terminating condition check label here.	*/
	GenerateLabelName(termcondn_label);
	c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, termcondn_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	/* c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0); */
	/* c_ptr1 = MergeCodes(c_ptr1, c_ptr2);					  */

	Pexpression(&expr_ptr);
	if (expr_ptr) {
		/*	Check if expression is of integer/real type.	*/
		switch (expr_ptr->ExprType) {
			case E_INTEGER :
			case E_INT_CONST :
			case E_REAL :
			case E_REAL_CONST :
				break;
			default :
				Error(ERR_EXP_INT_REAL_EXPECTED);
		}
		TempVarCount = 0;	/*	Reset temporaries count.	*/
		if (sym_ptr) {
			EmitExpression(expr_ptr, &c_ptr2);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
			c_ptr2 = EmitCode((up_direction ? Q_GREATER : Q_LESS),
						sym_type, sym_ptr->Name, expr_ptr->ExprType,
						expr_ptr->Name, PreDefVars[CONDN_VARIABLE].VarName);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		}
		ReleaseNodes(expr_ptr);
		GenerateLabelName(endfor_label);
		KillTemporaries(&c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		c_ptr2 = EmitCode(Q_JNZ, E_INTEGER,
					PreDefVars[CONDN_VARIABLE].VarName, 0, 0, endfor_label);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		/*	Generate a jump to the beginning of for loop body.	*/
		GenerateLabelName(loopbody_label);
		c_ptr2 = EmitCode(Q_JMP, 0, loopbody_label, 0, 0, 0);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	}
	/*	Generate a label to jump to after the end of loop body.	*/
	GenerateLabelName(stepexpr_label);
	c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, stepexpr_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	if (Token == Q_STEP) {
		GetToken();
		Pexpression(&expr_ptr);
		if (expr_ptr) {
			TempVarCount = 0;	/*	Reset temporaries count.	*/
			EmitExpression(expr_ptr, &c_ptr2);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		}
		if (sym_ptr) {
			/*	Generate code to add step expr to loop control variable.	*/
			c_ptr2 = EmitCode(Q_PLUS, sym_type, sym_ptr->Name,
						expr_ptr->ExprType, expr_ptr->Name, sym_ptr->Name);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		}
		if (expr_ptr)
			ReleaseNodes(expr_ptr);
	}
	else {
		/*	Optional step expression is not given. So generate code	*/
		/*	to add/subtract 1 to loop control variable depending on	*/
		/*	the value of direction.	*/
		if (sym_ptr) {
			GenerateTempVar(temp_name);
			c_ptr2 = EmitCode(Q_MOV, E_INT_CONST, "1", E_INTEGER, 0, temp_name);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
			c_ptr2 = EmitCode((up_direction ? Q_PLUS : Q_MINUS), sym_type,
					sym_ptr->Name, E_INTEGER, temp_name, sym_ptr->Name);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		}
	}
	KillTemporaries(&c_ptr2);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	/*	Generate a jump to termination condition check label.	*/
	c_ptr2 = EmitCode(Q_JMP, 0, termcondn_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	if (Token == Q_DO)
		GetToken();
	else {
		Error(ERR_DO_EXPECTED);
		goto error_exit;
	}
	/*	Generate a label for the loop body.	*/
	c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, loopbody_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	PstatementList(&c_ptr2);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);

	c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);	 
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);		 			 

	/*	Generate a jump to step expression computation label.	*/
	c_ptr2 = EmitCode(Q_JMP, 0, stepexpr_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	/*	Generate a label to signal end of loop body.	*/
	c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, endfor_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	/* c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0); */
	/* c_ptr1 = MergeCodes(c_ptr1, c_ptr2);					  */	
	*c_ptr = c_ptr1;
	if (Token == Q_ENDFOR)
		GetToken();
	else {
		Error(ERR_ENDFOR_EXPECTED);
		goto error_exit;
	}
	return(0);

	error_exit :
	return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	PwhileStatement											*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <while_statement>								*/
/*--------------------------------------------------------------------------*/

int		PwhileStatement(CodeTypeFptr *c_ptr)
{
	byte	endwhile_label[LABEL_NAME_LEN];
	byte	expr_label[LABEL_NAME_LEN];
	ExprNodeType	*expr_ptr;
	CodeTypeFptr	c_ptr1;
	CodeTypeFptr	c_ptr2;

	*c_ptr = c_ptr1 = c_ptr2 = 0;
	c_ptr1 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
	GetToken();
	/*	Generate a label to jump to after the end of loop iteration.	*/
	GenerateLabelName(expr_label);
	c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, expr_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2); 
	Pexpression(&expr_ptr);
	if (expr_ptr) {
		/*	Check if expression is of integer/real type.	*/
		switch (expr_ptr->ExprType) {
			case E_INTEGER :
			case E_INT_CONST :
			case E_REAL :
			case E_REAL_CONST :
				break;
			default :
				Error(ERR_EXP_INT_REAL_EXPECTED);
		}
		TempVarCount = 0;	/*	Reset temporaries count.	*/
		EmitExpression(expr_ptr, &c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		c_ptr2 = EmitCode(Q_MOV, expr_ptr->ExprType, expr_ptr->Name,
					expr_ptr->ExprType, 0, PreDefVars[CONDN_VARIABLE].VarName);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		KillTemporaries(&c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		/*	Generate code to check expression value and jump.	*/
		GenerateLabelName(endwhile_label);
		c_ptr2 = EmitCode(Q_JZ, expr_ptr->ExprType,
					PreDefVars[CONDN_VARIABLE].VarName, 0, 0, endwhile_label);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
		ReleaseNodes(expr_ptr);
	}
	if (Token == Q_DO)
		GetToken();
	else {
		Error(ERR_DO_EXPECTED);
		goto error_exit;
	}
	/*	c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0); */
	/*	c_ptr1 = MergeCodes(c_ptr1, c_ptr2); 				   */
	PstatementList(&c_ptr2);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);

	c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);	 
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);		 			 

	/*	Generate jump to beginning of expression evaluation.	*/
	c_ptr2 = EmitCode(Q_JMP, 0, expr_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	/*	Generate the endwhile label to signal end of loop body.	*/
	c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, endwhile_label, 0, 0, 0);
	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	/*	c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);	 */
	/*	c_ptr1 = MergeCodes(c_ptr1, c_ptr2);		 			 */
	*c_ptr = c_ptr1;
	if (Token == Q_ENDWHILE)
		GetToken();
	else {
		Error(ERR_ENDWHILE_EXPECTED);
		goto error_exit;
	}
	return(0);

	error_exit :
	return(-1);
}
