/*--------------------------------------------------------------------------*/
/*	File		:	PROGRAM.C												*/
/*	Purpose		:	This file contains script language routines.			*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#ifdef WIN
#include	"windows.h"
#endif

#include	"errcons.h"
#include	"scrtcons.h"
#include	"scrtmesg.h"

#include	"scrttype.h"
#include	"scrtdata.h"
#include	"scrtfuns.h"

#include	<string.h>
#include	<stdlib.h>


/*--------------------------------------------------------------------------*/
/*	Name		:	Pprogram												*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <program>										*/
/*--------------------------------------------------------------------------*/

int		Pprogram(void)
{
	CodeTypeFptr	c_ptr;

	GetToken();
	Pdeclarations(&c_ptr);
	WriteQuads(c_ptr);
	PrintCodes(c_ptr);
	FreeCodes(c_ptr);
	PprocDeclarations();
	if (Token != -1)
		Error(ERR_PROC_EXPECTED);
	return(0);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	Pdeclarations											*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <declarations>									*/
/*--------------------------------------------------------------------------*/

int		Pdeclarations(CodeTypeFptr *c_ptr)
{
	int		var_type;
	int		expr_type;
	int		var_count;
	CodeTypeFptr	c_ptr1;
	CodeTypeFptr	c_ptr2;
	SymInfoType	*sym_ptr;

	if (!Scope) {
		/*	Add the pre-defined globals to the symbol table.	*/
		var_count = AddPreDefinedVariables();
		if (var_count < 0)
			goto error_exit;
	}
	else
		var_count = 0;	/*	Start counting the locals.	*/
	*c_ptr = 0;
	c_ptr1 = c_ptr2 = 0;
	while (Token == Q_INTEGER || Token == Q_REAL || Token == Q_STRING) {
		var_type = Token;
		GetToken();
		if (Token == Q_ID) {
			if (AddSymbol(TokenStr, var_type, &sym_ptr)) {
				if (sym_ptr)
					Error(ERR_ID_ALREADY_DECLARED);
				else {
					Error(ERR_OUT_OF_MEMORY);
					goto error_exit;
				}
			}
			else {	/*	Set the variable type (global/local).	*/
				sym_ptr->SymType = (byte) (!Scope ? VAR_GLOBAL : VAR_LOCAL);
				sym_ptr->Status = var_count++;
			}
			switch (var_type) {
				case Q_INTEGER :
					expr_type = E_INTEGER;
					break;
				case Q_REAL :
					expr_type = E_REAL;
					break;
				case Q_STRING :
					expr_type = E_STRING;
					break;
			}
			c_ptr2 = EmitCode(Q_DECLARE, expr_type, TokenStr, 0, 0, 0);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
			GetToken();
		}
		else {
			Error(ERR_ID_EXPECTED);
			goto error_exit;
		}
		while (Token == Q_COMMA) {
			GetToken();
			if (Token == Q_ID) {
				if (AddSymbol(TokenStr, var_type, &sym_ptr)) {
					if (sym_ptr)
						Error(ERR_ID_ALREADY_DECLARED);
					else {
						Error(ERR_OUT_OF_MEMORY);
						goto error_exit;
					}
				}
				else {	/*	Set the variable type (global/local).	*/
					sym_ptr->SymType = (byte)
										(!Scope ? VAR_GLOBAL : VAR_LOCAL);
					sym_ptr->Status = var_count++;
				}
				c_ptr2 = EmitCode(Q_DECLARE, expr_type, TokenStr, 0, 0, 0);
				c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
				GetToken();
			}
			else {
				Error(ERR_ID_EXPECTED);
				goto error_exit;
			}
		}
		if (Token == Q_SEMICOLON)
			GetToken();
		else {
			Error(ERR_SEMICOLON_EXPECTED);
			goto error_exit;
		}
	}
	*c_ptr = c_ptr1;
	return(0);

	error_exit :
	return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	PprocDeclarations										*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <proc_declarations>								*/
/*--------------------------------------------------------------------------*/

int		PprocDeclarations(void)
{
	byte	str[6];	/*	Enough space for converting an int.	*/
	DefnArgType	*arg_list;
	CodeTypeFptr	c_ptr1;
	CodeTypeFptr	c_ptr2;		/*	Code for the line number quad.	*/
	CodeTypeFptr	c_ptr3;		/*	Code for argument list.	*/
	CodeTypeFptr	c_ptr4;		/*	Code for max. temporaries quad.	*/
	byte	forward_declared;
	SymInfoType	*sym_ptr;

	while (Token == Q_PROC) {
		ProcNamePtr = 0;
		TotalTempCount = -1;	/*	Max. temporaries used within fn body.	*/
		c_ptr1 = c_ptr2 = c_ptr3 = 0;
		/*	Generate a quad for the line number and remember it.	*/
		c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
		/*	Since the labels are visible only within the body of the	*/
		/*	function, reset the label count.	*/
		LabelCount = 0;
		GetToken();
		forward_declared = false;	/*	Assume new declaration.	*/
		if (Token == Q_ID) {
			/*	Add the procedure name to symbol table.	*/
			if (AddSymbol(TokenStr, Q_PROC, &ProcNamePtr)) {
				if (ProcNamePtr) {
					if (ProcNamePtr->SymClass == Q_PROC &&
								(ProcNamePtr->Status & FORWARD_DEFINED)) {
						/*	Procedure template was defined earlier, so	*/
						/*	skip processing argument list.	*/
						forward_declared = true;
						/*	Indicate that procedure body also defined.	*/
						ProcNamePtr->Status |= PROC_BODY_DEFINED;
					}
					else
						Error(ERR_ID_ALREADY_DECLARED);
				}
				else {
					Error(ERR_OUT_OF_MEMORY);
					goto error_exit;
				}
			}
			else {
				/*	Create node for procedure information.	*/
				ProcNamePtr->ProcInfoPtr =
#ifndef WIN
							(ProcInfoType *) malloc(sizeof(ProcInfoType));
#else
							(ProcInfoType *) LocalAlloc(LMEM_FIXED, sizeof(ProcInfoType));
#endif
				if (ProcNamePtr->ProcInfoPtr) {
					/*	Initialize the proc info.	*/
					ProcNamePtr->ProcInfoPtr->RetValue = Q_VOID;
					ProcNamePtr->ProcInfoPtr->ArgList = 0;
					ProcNamePtr->ProcInfoPtr->SymTablePtr = 0;
					ProcNamePtr->ProcInfoPtr->ParamList = 0;
				}
				else {
					Error(ERR_OUT_OF_MEMORY);
					goto error_exit;
				}
			}
				/*	Assume void return value for the procedure.	*/
			if (!forward_declared && ProcNamePtr->ProcInfoPtr)
				ProcNamePtr->ProcInfoPtr->RetValue = Q_VOID;
			GetToken();
		}
		else {
			Error(ERR_ID_EXPECTED);
			goto error_exit;
		}
		if (!forward_declared) {
			/*	The optional argument list may be given.	*/
			if (Token == Q_LP) {
				GetToken();
				Scope++;	/*	Function arguments are one level higher.	*/
				PargumentList(&arg_list, &c_ptr3);
											/*	Put argument list.	*/
				if (ProcNamePtr && ProcNamePtr->ProcInfoPtr)
					ProcNamePtr->ProcInfoPtr->ArgList = arg_list;
				Scope--;
				if (Token == Q_RP)
					GetToken();
				else {
					Error(ERR_RP_EXPECTED);
					goto error_exit;
				}
			}
			if (Token == Q_COLON) {
				GetToken();
				if (Token == Q_INTEGER || Token == Q_REAL ||
													Token == Q_STRING) {
					if (ProcNamePtr) {
						if (ProcNamePtr->ProcInfoPtr)
							ProcNamePtr->ProcInfoPtr->RetValue = (byte) Token;
						if (!strcmp(ProcNamePtr->Name, MainFnName)) {
							/*	proc main can't have return value.	*/
							Error(ERR_PROC_MAIN_HAS_RETVALUE);
						}
					}
					GetToken();
				}
				else {
					Error(ERR_TYPE_EXPECTED);
					goto error_exit;
				}
			}
			if (Token == Q_SEMICOLON)
				GetToken();
			else {
				Error(ERR_SEMICOLON_EXPECTED);
				goto error_exit;
			}
		}
		if (Token == Q_FORWARD) {
			/*	Remember the symbol table pointer for formal	*/
			/*	parameters in the procedure name node and invalidate	*/
			/*	the pointer in display to avoid dangling pointers	*/
			/*	and proper processing of the next procedure arguments	*/
			/*	and locals. Indicate procedure body is defined forward.	*/
			/*	Remember the code for parameter list.	*/
			if (ProcNamePtr) {
				ProcNamePtr->Status |= FORWARD_DEFINED;
				if (ProcNamePtr->ProcInfoPtr) {
					ProcNamePtr->ProcInfoPtr->SymTablePtr = Display[Scope + 1];
						/*	Put code for procedure beginning.	*/
					c_ptr1 = EmitCode(Q_PROCEDURE, 0, ProcNamePtr->Name,
																0, 0, 0);
					/*	Add the code for parameter list and save it.	*/
					ProcNamePtr->ProcInfoPtr->ParamList =
												MergeCodes(c_ptr1, c_ptr3);
					/*	Release the line no quad because we need to take	*/
					/*	only the actual procedure body beginning line no.	*/
					FreeCodes(c_ptr2);
				}
			}
			Display[Scope + 1] = 0;
			GetToken();
			if (Token == Q_SEMICOLON)
				GetToken();
			else {
				Error(ERR_SEMICOLON_EXPECTED);
				goto error_exit;
			}
		}
		else {
			if (forward_declared) {
				if (Token == Q_SEMICOLON)
					GetToken();
				else
					Error(ERR_SEMICOLON_EXPECTED);
				if (Token == Q_FORWARD)
					Error(ERR_ALREADY_FORWARD_DECLARED);
			}
			/*	Process the procedure body.	*/
			Scope++;	/*	Symbols inside proc are one level higher.	*/
			if (forward_declared) {
				if (ProcNamePtr->ProcInfoPtr) {
					Display[Scope] = ProcNamePtr->ProcInfoPtr->SymTablePtr;
					/*	Code for procedure beginning and formal parameters	*/
					/*	is available in the symbol table. Put code for line	*/
					/*	number and add code for formal parameters.	*/
					c_ptr1 = MergeCodes(c_ptr2,
									ProcNamePtr->ProcInfoPtr->ParamList);
												/*	Invalidate code list.	*/
					ProcNamePtr->ProcInfoPtr->ParamList = 0;
				}
				else {
					Display[Scope] = 0;	/*	Assume no parameters given.	*/
					c_ptr1 = c_ptr2;	/*	Take just line no quad.	*/
				}
			}
			else {
				/*	Put code for line number, procedure beginning.	*/
				c_ptr1 = EmitCode(Q_PROCEDURE, 0, ProcNamePtr->Name, 0, 0, 0);
				c_ptr1 = MergeCodes(c_ptr2, c_ptr1);
				/*	Add code for parameter list.	*/
				c_ptr1 = MergeCodes(c_ptr1, c_ptr3);
			}
			Pdeclarations(&c_ptr2);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
			PstatementList(&c_ptr2);

			/*	If temporaries used inside the function body, generate	*/
			/*	code to reserve space for temporaries at run time.	*/
			if (TotalTempCount > -1) {
				TotalTempCount++;
				/*	Generate a quad to allocate space for temporaries.	*/
				itoa(TotalTempCount, str, 10);
				c_ptr4 = EmitCode(Q_TEMPCOUNT, 0, str, 0, 0, 0);
				c_ptr1 = MergeCodes(c_ptr1, c_ptr4);
			}

			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);

			/*	Check for labels used but not defined, and report error.	*/
			CheckUndefinedLabels(Display[Scope]);

			/*	The symbol table nodes for the formal parameters will be	*/
			/*	released. So invalidate the pointers to these nodes from	*/
			/*	the formal parameter list to avoid dangling pointers.	*/
			if (ProcNamePtr && ProcNamePtr->ProcInfoPtr) {
				arg_list = ProcNamePtr->ProcInfoPtr->ArgList;
				while (arg_list) {
					/*	Invalidate pointers to argument symbol nodes.	*/
					arg_list->VarPtr = 0;
					arg_list = arg_list->NextArgPtr;
				}
			}
			if (ProcNamePtr) {
				ProcNamePtr->Status |= END_PROC_REACHED;
				/*	Generate code to force RET from the function.	*/
				c_ptr2 = EmitCode(Q_RET, 0, 0, 0, 0, 0);
				c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
				/*	If the function is supposed to return a value and there	*/
				/*	was no RETURN statement, report error.	*/
				if (ProcNamePtr->ProcInfoPtr &&
							ProcNamePtr->ProcInfoPtr->RetValue != Q_VOID &&
							!(ProcNamePtr->Status & FUNCTION_ASSIGNED) &&
							strcmp(ProcNamePtr->Name, MainFnName))
					Error(ERR_FN_NO_RETURN_VALUE);
			}
			if (Token == Q_ENDPROC) {
				if (ProcNamePtr) {
					c_ptr2 = EmitCode(Q_ENDPROCEDURE, 0, ProcNamePtr->Name,
																0, 0, 0);
					c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
				}
				GetToken();
			}
			else {
				Error(ERR_ENDPROC_EXPECTED);
				goto error_exit;
			}
			c_ptr2 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);

			if (Optimize) {
				OptTransMovs(c_ptr1);	/*	Remove transitive moves.	*/
				OptTemps(c_ptr1);	/*	Remove kill for unused temps.	*/
			}

			ProcCode = c_ptr1;	/*	To resolve label offsets.	*/
			ResolveLabels(c_ptr1);	/*	Compute label addresses.	*/
			WriteQuads(c_ptr1);
			PrintCodes(c_ptr1);
			FreeCodes(c_ptr1);
			/*	Release local and formal parameter symbols.	*/
			PurgeSymbols(Display[Scope]);
			Display[Scope] = 0;
			Scope--;
		}
	}
	/*	Check for forward defined procedures whose body is not given.	*/
	CheckForwardProcedures(Display[0]);
	sym_ptr = FindSymbol(MainFnName);	/*	Check if proc main is defined.	*/
	if (!sym_ptr) {
		Error(ERR_MAIN_FN_NOT_DECLARED);
		goto error_exit;
	}
	else {
		if (sym_ptr->ProcInfoPtr->ArgList) {
			Error(ERR_PROC_MAIN_HAS_ARGS);	/*	main can't have arguments.	*/
			goto error_exit;
		}
	}
	return(0);

	error_exit :
	return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	PargumentList											*/
/*	Input		:	n_ptr, pointer to argument list,						*/
/*					c_ptr, pointer to code list.							*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <argument_list>									*/
/*--------------------------------------------------------------------------*/

int		PargumentList(DefnArgType **a_ptr, CodeTypeFptr *c_ptr)
{
	DefnArgType *arg_ptr;
	DefnArgType	*ptr;
	CodeTypeFptr	c_ptr1;
	CodeTypeFptr	c_ptr2;

	*c_ptr = c_ptr1 = c_ptr2 = 0;
	ParamCount = 0;		/*	Start counting the parameters.	*/
	Pargument(a_ptr, &c_ptr1);
	while (Token == Q_SEMICOLON) {
		GetToken();
		Pargument(&arg_ptr, &c_ptr2);
		ptr = *a_ptr;
		while (ptr->NextArgPtr)	/*	Append following arg list.	*/
			ptr = ptr->NextArgPtr;
		ptr->NextArgPtr = arg_ptr;
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	}
	*c_ptr = c_ptr1;
	return(0);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	Pargument												*/
/*	Input		:	n_ptr, pointer to argument list,						*/
/*					c_ptr, pointer to code list.							*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <argument>										*/
/*--------------------------------------------------------------------------*/

int		Pargument(DefnArgType **a_ptr, CodeTypeFptr *c_ptr)
{
	byte	attribute;
	byte	var_type;
	int		expr_type;
	SymInfoType	*sym_ptr;
	DefnArgType	*arg_list;
	DefnArgType	*arg_ptr;
	CodeTypeFptr	c_ptr1;
	CodeTypeFptr	c_ptr2;

	*a_ptr = 0;
	attribute = 0;
	sym_ptr = 0;
	*c_ptr = c_ptr1 = c_ptr2 = 0;
	if (Token == Q_VAR) {
		attribute = Q_VAR;
		GetToken();
	}
	if (Token == Q_INTEGER || Token == Q_REAL || Token == Q_STRING) {
		var_type = (byte) Token;
		GetToken();
		if (Token == Q_ID) {
			if (AddSymbol(TokenStr, var_type, &sym_ptr)) {
				if (sym_ptr)
					Error(ERR_ID_ALREADY_DECLARED);
				else {
					Error(ERR_OUT_OF_MEMORY);
					goto error_exit;
				}
			}
			else {	/*	Set the variable type (parameter).	*/
				sym_ptr->SymType = VAR_PARAM;
				sym_ptr->Status = ParamCount++;
			}
			switch (var_type) {
				case Q_INTEGER :
					expr_type = E_INTEGER;
					break;
				case Q_REAL :
					expr_type = E_REAL;
					break;
				case Q_STRING :
					expr_type = E_STRING;
					break;
			}
			/*	Generate code to indicate the parameter list.	*/
			/*	This is necessary to enter parameter into symbol table.	*/
			c_ptr2 = EmitCode(Q_PARAM, expr_type, TokenStr, 0, 0, 0);
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
#ifndef WIN
			arg_ptr = (DefnArgType *) malloc(sizeof(DefnArgType));
#else
			arg_ptr = (DefnArgType *) LocalAlloc(LMEM_FIXED, sizeof(DefnArgType));
#endif
			if (!arg_ptr) {
				Error(ERR_OUT_OF_MEMORY);
				goto error_exit;
			}
			arg_ptr->ArgClass = var_type;
			arg_ptr->Attribute = attribute;
			arg_ptr->VarPtr = sym_ptr;
			arg_ptr->NextArgPtr = 0;
			*a_ptr = arg_list = arg_ptr;	/*	Remember first arg in list.	*/
			GetToken();
		}
		else {
			Error(ERR_ID_EXPECTED);
			goto error_exit;
		}
		while (Token == Q_COMMA) {
			GetToken();
			if (Token == Q_ID) {
				if (AddSymbol(TokenStr, var_type, &sym_ptr)) {
					if (sym_ptr)
						Error(ERR_ID_ALREADY_DECLARED);
					else {
						Error(ERR_OUT_OF_MEMORY);
						goto error_exit;
					}
				}
				else {	/*	Set the variable type (parameter).	*/
					sym_ptr->SymType = VAR_PARAM;
					sym_ptr->Status = ParamCount++;
				}
				c_ptr2 = EmitCode(Q_PARAM, expr_type, TokenStr, 0, 0, 0);
				c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
#ifndef WIN
				arg_ptr = (DefnArgType *) malloc(sizeof(DefnArgType));
#else
				arg_ptr = (DefnArgType *) LocalAlloc(LMEM_FIXED, sizeof(DefnArgType));
#endif
				if (!arg_ptr) {
					Error(ERR_OUT_OF_MEMORY);
					goto error_exit;
				}
				arg_ptr->ArgClass = var_type;
				arg_ptr->Attribute = attribute;
				arg_ptr->VarPtr = sym_ptr;
				arg_ptr->NextArgPtr = 0;
				arg_ptr->Attribute = attribute;
				arg_list->NextArgPtr = arg_ptr;	/*	Append arg to list.	*/
				arg_list = arg_ptr;
				GetToken();
			}
			else {
				Error(ERR_ID_EXPECTED);
				goto error_exit;
			}
		}
	}
	else {
		Error(ERR_TYPE_EXPECTED);
		goto error_exit;
	}
	*c_ptr = c_ptr1;
	return(0);

	error_exit :
	return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	PstatementList											*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <statement_list>								*/
/*--------------------------------------------------------------------------*/

int		PstatementList(CodeTypeFptr *c_ptr)
{
	CodeTypeFptr	c_ptr1;
	CodeTypeFptr	c_ptr2;

	*c_ptr = c_ptr1 = c_ptr2 = 0;
	while (Token == Q_IF || Token == Q_FOR || Token == Q_WHILE ||
					Token == Q_SWITCH || Token == Q_ID || Token == Q_GOTO ||
					Token == Q_SEMICOLON || Token == Q_RETURN) {
		Pstatement(&c_ptr2);
		c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
	}
	*c_ptr = c_ptr1;
	return(0);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	Pstatement												*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <statement>										*/
/*--------------------------------------------------------------------------*/

int		Pstatement(CodeTypeFptr *c_ptr)
{
	*c_ptr = 0;
	switch (Token) {
		case Q_IF :
			PifStatement(c_ptr);
			break;
		case Q_FOR :
			PforStatement(c_ptr);
			break;
		case Q_WHILE :
			PwhileStatement(c_ptr);
			break;
		case Q_SWITCH :
			PswitchStatement(c_ptr);
			break;
		case Q_ID :
		case Q_RETURN :
		case Q_SEMICOLON :
		case Q_GOTO :
			PelemtStatement(c_ptr);
			break;
		default :
			Error(ERR_STAT_EXPECTED);
			goto error_exit;
	}
	return(0);

	error_exit :
	return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	PelemtStatement											*/
/*	Input		:	None													*/
/*	Output		:	0														*/
/*	Synopsis	:	Reduces <element_statement>								*/
/*--------------------------------------------------------------------------*/

int		PelemtStatement(CodeTypeFptr *c_ptr)
{
	SymInfoType	*sym_ptr;
	ExprNodeType	*expr_ptr;
	CodeTypeFptr	c_ptr1;
	CodeTypeFptr	c_ptr2;
	byte	name[MAX_TOKEN_LEN];
	int		expr_type;

	*c_ptr = c_ptr1 = c_ptr2 = 0;
	c_ptr1 = EmitCode(Q_LINENO, 0, CnvtLineNo(), 0, 0, 0);
	switch (Token) {
		case Q_ID :
			sym_ptr = FindSymbol(TokenStr);
			if (sym_ptr && sym_ptr->SymClass == Q_PROC) {
				Pexpression(&expr_ptr);	/*	Must be function call.	*/
				if (expr_ptr) {
					if (expr_ptr->Operator != Q_FN_CALL)
						Error(ERR_STATEMENT_ILL_FORMED);
					TempVarCount = 0;	/*	Reset temporaries count.	*/
					EmitExpression(expr_ptr, &c_ptr2);
					c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
					KillTemporaries(&c_ptr2);
					c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
					ReleaseNodes(expr_ptr);
				}
				if (Token == Q_SEMICOLON)
					GetToken();
				else {
					Error(ERR_SEMICOLON_EXPECTED);
					goto error_exit;
				}
				*c_ptr = c_ptr1;
			}
			else {
				strcpy(name, TokenStr);	/*	Remember, could be label name.	*/
				GetToken();
				switch (Token) {
					case Q_ASSIGNMENT :
						if (!sym_ptr)
							Error(ERR_ID_NOT_DECLARED);
						GetToken();
						Pexpression(&expr_ptr);
						if (expr_ptr) {
							TempVarCount = 0;	/*	Reset temps count.	*/
							EmitExpression(expr_ptr, &c_ptr2);
							c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
							if (sym_ptr) {
								CheckAssignment(sym_ptr, expr_ptr);
								switch (sym_ptr->SymClass) {
									case Q_INTEGER :
										expr_type = E_INTEGER;
										break;
									case Q_REAL :
										expr_type = E_REAL;
										break;
									case
									Q_STRING :
										expr_type = E_STRING;
										break;
								}
								c_ptr2 = EmitCode(Q_MOV, expr_ptr->ExprType,
										expr_ptr->Name, expr_type, 0,
										sym_ptr->Name);
								c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
							}
							KillTemporaries(&c_ptr2);
							c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
							ReleaseNodes(expr_ptr);
						}
						if (Token == Q_SEMICOLON)
							GetToken();
						else {
							Error(ERR_SEMICOLON_EXPECTED);
							goto error_exit;
						}
						*c_ptr = c_ptr1;
						break;
					case Q_COLON :
						if (sym_ptr) {
							if (sym_ptr->SymClass == Q_LABEL)
								if (sym_ptr->SymType & LABEL_DEFINED)
									Error(ERR_LABEL_ALREADY_DECLARED);
								else {
									/*	Generate the label definition here.	*/
									c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, name,
																	0, 0, 0);
									sym_ptr->SymType |= LABEL_DEFINED;
								}
							else
								Error(ERR_ID_ALREADY_DECLARED);
						}
						else {	/*	Add label to symbol table.	*/
							if (AddSymbol(name, Q_LABEL, &sym_ptr)) {
								if (!sym_ptr) {
									Error(ERR_OUT_OF_MEMORY);
									goto error_exit;
								}
							}
							/*	Generate the label definition here.	*/
							c_ptr2 = EmitCode(Q_LABEL_DEFN, 0, name, 0, 0, 0);
							sym_ptr->SymType |= LABEL_DEFINED;
						}
						c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
						GetToken();
						*c_ptr = c_ptr1;
						break;
					default :
						if (sym_ptr)
							Error(ERR_ASSIGNMENT_COLON_EXPECTED);
						else
							Error(ERR_ID_NOT_DECLARED);
						*c_ptr = c_ptr1;
						goto error_exit;
				}
			}
			break;
		case Q_GOTO :
			GetToken();
			if (Token == Q_ID) {
				/*	Generate an unconditional jump to label.	*/
				c_ptr2 = EmitCode(Q_JMP, 0, TokenStr, 0, 0, 0);
				sym_ptr = FindSymbol(TokenStr);
				if (sym_ptr) {
					if (sym_ptr->SymClass != Q_LABEL)
						Error(ERR_JUMP_TO_NON_LABEL);
				}
				else {
					/*	Add label to symbol table, and indicate that it	*/
					/*	was added at the point of usage as target in a	*/
					/*	jump, but is not defined yet.	*/
					if (AddSymbol(TokenStr, Q_LABEL, &sym_ptr)) {
						if (!sym_ptr) {
							Error(ERR_OUT_OF_MEMORY);
							goto error_exit;
						}
					}
					sym_ptr->SymType |= LABEL_USED;
				}
				GetToken();
			}
			else {
				Error(ERR_ID_EXPECTED);
				goto error_exit;
			}
			c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
			*c_ptr = c_ptr1;
			break;
		case Q_RETURN :
			GetToken();
			if (Token == Q_ID || Token == Q_INT_CONST ||
					Token == Q_REAL_CONST || Token == Q_STRING_CONST ||
					Token == Q_NOT || Token == Q_UNARY_MINUS ||
					Token == Q_MINUS || Token == Q_LP) {
				Pexpression(&expr_ptr);
				if (expr_ptr) {
					TempVarCount = 0;	/*	Reset temporaries count.	*/
					EmitExpression(expr_ptr, &c_ptr1);

					/*	Save return value in global and kill temporaries.	*/
					c_ptr2 = EmitCode(Q_MOV, expr_ptr->ExprType,
									expr_ptr->Name, expr_ptr->ExprType, 0,
									PreDefVars[RETURN_VARIABLE].VarName);
					c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
					KillTemporaries(&c_ptr2);
					c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
					c_ptr2 = EmitCode(Q_RET, 0, 0, 0, 0, 0);
					c_ptr1 = MergeCodes(c_ptr1, c_ptr2);
				}
				if (ProcNamePtr) {
					CheckAssignment(ProcNamePtr, expr_ptr);
					if (expr_ptr)
						ReleaseNodes(expr_ptr);
				}	
			}
			else
				c_ptr1 = EmitCode(Q_RET, 0, 0, 0, 0, 0);
			if (Token == Q_SEMICOLON)
				GetToken();
			else {
				Error(ERR_SEMICOLON_EXPECTED);
				goto error_exit;
			}
			*c_ptr = c_ptr1;
			break;
		case Q_SEMICOLON :	/*	Null statement.	*/
			GetToken();
			*c_ptr = c_ptr1;
			break;
		default :
			Error(ERR_SEMICOLON_EXPECTED);
			*c_ptr = c_ptr1;
			goto error_exit;
	}
	return(0);

	error_exit :
	return(-1);
}
