/*--------------------------------------------------------------------------*/
/*	File		:	TOKEN.C													*/
/*	Purpose		:	This file contains script language routines.			*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#ifdef WIN
#include	"windows.h"
#endif

#include	"errcons.h"
#include	"scrtcons.h"
#include	"scrtmesg.h"

#include	"scrttype.h"
#include	"scrtdata.h"
#include	"scrtfuns.h"

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>

extern	void	WriteLine(char *DispStr);
int SourceLines;
/*--------------------------------------------------------------------------*/
/*	Name		:	GetToken												*/
/*	Input		:	None													*/
/*	Output		:	Next token in input, -1 if EOF.							*/
/*	Synopsis	:	Reads the next token in the input.						*/
/*--------------------------------------------------------------------------*/

int		GetToken(void)
{
	static	int	ch = -1;
	int		sign;

	get_token :

	TokenLen = 0;
	TokenStr[0] = 0;
	if (ch == -1)
		ch = GetChar();
	while (ch == ' ' || ch == '\t' || ch == 0x0d || ch == 0x0a) {
		if (ch == 0x0a)
			LineNo++;
		ch = GetChar();	/*	Skip white space.	*/
	}
	if (ch == -1)
		return(Token = -1);	/*	End of file.	*/
	if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
		while (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' ||
								ch >= '0' && ch <= '9' || ch == '_') {
			if (TokenLen < MAX_TOKEN_LEN - 1)
				TokenStr[TokenLen++] = (byte) ch;
			ch = GetChar();
		}
		TokenStr[TokenLen] = 0;
		CnvtToUpper(TokenStr);	  
		return(Token = CheckForResdWord(TokenStr));
	}
	else {
		if (ch == '+' || ch == '-' || ch == '.' || ch >= '0' && ch <= '9') {
			sign = (ch == '-' ? -1 : 1);
			if (ch == '-' || ch == '+') {
				TokenStr[TokenLen++] = (byte) ch;
				ch = GetChar();
				if (ch != '.' && (ch < '0' || ch > '9')) {
					TokenStr[TokenLen] = 0;
					if (sign == 1)
						return(Token = Q_PLUS);
					else {
						if (Token == Q_UNARY_MINUS ||
							Token == Q_PLUS || Token == Q_MINUS ||
							Token == Q_TIMES || Token == Q_DIV ||
							Token == Q_LESS_OR_EQUAL ||
							Token == Q_GREATER_OR_EQUAL ||
							Token == Q_IS_EQUAL ||
							Token == Q_IS_NOT_EQUAL ||
							Token == Q_LESS || Token == Q_GREATER ||
							Token == Q_NOT || Token == Q_LP ||
							Token == Q_COMMA || Token == Q_ASSIGNMENT)
							return(Token = Q_UNARY_MINUS);
						else
							return(Token = Q_MINUS);
					}
				}
				if (ch == '.' || ch >= '0' && ch <= '9') {
					/*	Check previous token to decide whether a+5	*/
					/*	should be treated as a, +, 5, or a, +5.	*/
					if (Token == Q_ID || Token == Q_INT_CONST ||
							Token == Q_REAL_CONST ||
							Token == Q_STRING_CONST || Token == Q_RP) {
						TokenStr[TokenLen] = 0;
						if (sign == 1)
							return(Token = Q_PLUS);
						else
							return(Token = Q_MINUS);
					}
				}
			}
			while (ch >= '0' && ch <= '9') {
				if (TokenLen < MAX_TOKEN_LEN - 1)
					TokenStr[TokenLen++] = (byte) ch;
				ch = GetChar();
			}
			if (ch == '.') {
				if (TokenLen < MAX_TOKEN_LEN - 1)
					TokenStr[TokenLen++] = (byte) ch;
				ch = GetChar();
				while (ch >= '0' && ch <= '9') {
					if (TokenLen < MAX_TOKEN_LEN - 1)
						TokenStr[TokenLen++] = (byte) ch;
					ch = GetChar();
				}
				TokenStr[TokenLen] = 0;
				return(Token = Q_REAL_CONST);
			}
			else {
				TokenStr[TokenLen] = 0;
				return(Token = Q_INT_CONST);
			}
		}
		else {
			switch (ch) {
				case '"' :
					while (1) {
						ch = GetChar();
						if (ch == -1)
							break;
						switch (ch) {
							case '"' :
								ch = GetChar();
								if (ch == '"') {
									/*	Quote inside string.	*/
									if (TokenLen < MAX_TOKEN_LEN - 1)
										TokenStr[TokenLen++] = '"';
									break;
								}
								else
									goto got_string_const;
							case '^' :
								ch = GetChar();
								if (ch == -1)	/*	End of file ?	*/
									break;
								if (TokenLen < MAX_TOKEN_LEN - 1)
									TokenStr[TokenLen++] = (byte) (ch == '^' ?
											'^' : ch - 'A' + 1);
								break;
							case '\\' :
								ch = GetChar();
								if (ch == -1)	/*	End of file ?	*/
									break;
								switch (ch) {
									case '\\' :
										if (TokenLen < MAX_TOKEN_LEN - 1)
											TokenStr[TokenLen++] = '\\';
										break;
									case 'n' :
										if (TokenLen < MAX_TOKEN_LEN - 1)
											TokenStr[TokenLen++] = 0x0a;
										break;
									case 'r' :
										if (TokenLen < MAX_TOKEN_LEN - 1)
											TokenStr[TokenLen++] = 0x0d;
										break;
									case 'x' :
									case 'X' :
										ch = GetChar();
										sign = HexValue(ch);
										if (sign != -1 &&
												TokenLen < MAX_TOKEN_LEN - 1)
											TokenStr[TokenLen] =
														(byte) (sign * 16);
										ch = GetChar();
										sign = HexValue(ch);
										if (sign != -1 &&
												TokenLen < MAX_TOKEN_LEN - 1)
											TokenStr[TokenLen] += sign;
										TokenLen++;
										break;
									default :
										if (TokenLen < MAX_TOKEN_LEN - 1)
											TokenStr[TokenLen++] = ch;
										#if 0
										Error(ERR_STRING_CONST);
										#endif
										break;
								}
								break;
							default :
								if (ch == 0x0a)
									LineNo++;
								if (TokenLen < MAX_TOKEN_LEN - 1)
									TokenStr[TokenLen++] = (byte) ch;
								break;
						}
					}

					got_string_const :

					TokenStr[TokenLen] = 0;
					if (ch == -1) {
						Error(ERR_STRING_CONST);
						return(Token = Q_ILLEGAL);
					}
					return(Token = Q_STRING_CONST);
				case '(' :
					TokenStr[TokenLen++] = (byte) ch;
					TokenStr[TokenLen] = 0;
					ch = GetChar();
					return(Token = Q_LP);
				case ')' :
					TokenStr[TokenLen++] = (byte) ch;
					TokenStr[TokenLen] = 0;
					ch = GetChar();
					return(Token = Q_RP);
				case ',' :
					TokenStr[TokenLen++] = (byte) ch;
					TokenStr[TokenLen] = 0;
					ch = GetChar();
					return(Token = Q_COMMA);
				case ';' :
					TokenStr[TokenLen++] = (byte) ch;
					TokenStr[TokenLen] = 0;
					ch = GetChar();
					return(Token = Q_SEMICOLON);
				case ':' :
					TokenStr[TokenLen++] = (byte) ch;
					TokenStr[TokenLen] = 0;
					ch = GetChar();
					return(Token = Q_COLON);
				case '*' :
					TokenStr[TokenLen++] = (byte) ch;
					TokenStr[TokenLen] = 0;
					ch = GetChar();
					return(Token = Q_TIMES);
				case '/' :
					TokenStr[TokenLen++] = (byte) ch;
					TokenStr[TokenLen] = 0;
					ch = GetChar();
					if (ch != '*')
						return(Token = Q_DIV);
					else {
						if (SkipComment(&ch) < 0) {
							Error(ERR_COMMENTS);
							return(Token = Q_ILLEGAL);
						}
						goto get_token;
					}
				case '<' :
					TokenStr[TokenLen++] = (byte) ch;
					ch = GetChar();
					if (ch == '=') {
						TokenStr[TokenLen++] = (byte) ch;
						TokenStr[TokenLen] = 0;
						ch = GetChar();
						return(Token = Q_LESS_OR_EQUAL);
					}
					else {
						TokenStr[TokenLen] = 0;
						return(Token = Q_LESS);
					}
				case '>' :
					TokenStr[TokenLen++] = (byte) ch;
					ch = GetChar();
					if (ch == '=') {
						TokenStr[TokenLen++] = (byte) ch;
						TokenStr[TokenLen] = 0;
						ch = GetChar();
						return(Token = Q_GREATER_OR_EQUAL);
					}
					else {
						TokenStr[TokenLen] = 0;
						return(Token = Q_GREATER);
					}
				case '=' :
					TokenStr[TokenLen++] = (byte) ch;
					ch = GetChar();
					if (ch == '=') {
						TokenStr[TokenLen++] = (byte) ch;
						TokenStr[TokenLen] = 0;
						ch = GetChar();
						return(Token = Q_IS_EQUAL);
					}
					else {
						TokenStr[TokenLen] = 0;
						return(Token = Q_ASSIGNMENT);
					}
				case '!' :
					TokenStr[TokenLen++] = (byte) ch;
					ch = GetChar();
					if (ch == '=') {
						TokenStr[TokenLen++] = (byte) ch;
						TokenStr[TokenLen] = 0;
						ch = GetChar();
						return(Token = Q_IS_NOT_EQUAL);
					}
					else {
						TokenStr[TokenLen] = 0;
						return(Token = Q_NOT);
					}
				case '&' :
					TokenStr[TokenLen++] = (byte) ch;
					ch = GetChar();
					if (ch == '&') {
						TokenStr[TokenLen++] = (byte) ch;
						TokenStr[TokenLen] = 0;
						ch = GetChar();
						return(Token = Q_AND);
					}
					else {
						TokenStr[TokenLen] = 0;
						return(Token = Q_ILLEGAL);
					}
				case '|' :
					TokenStr[TokenLen++] = (byte) ch;
					ch = GetChar();
					if (ch == '|') {
						TokenStr[TokenLen++] = (byte) ch;
						TokenStr[TokenLen] = 0;
						ch = GetChar();
						return(Token = Q_OR);
					}
					else {
						TokenStr[TokenLen] = 0;
						return(Token = Q_ILLEGAL);
					}
				default :
					if (ch == 0x0a)
						LineNo++;
					TokenStr[TokenLen++] = (byte) ch;
					TokenStr[TokenLen] = 0;
					ch = GetChar();
					return(Token = Q_ILLEGAL);
			}
		}
	}
}

/*--------------------------------------------------------------------------*/
/*	Name		:	CnvtToUpper												*/
/*	Input		:	token, pointer to token string.							*/
/*	Output		:	None													*/
/*	Synopsis	:	Converts the token to upper case.						*/
/*--------------------------------------------------------------------------*/

void	CnvtToUpper(byte *token)
{
	for (; *token; token++)
		if (*token >= 'a' && *token <= 'z')
			*token -= 'a' - 'A';
}

/*--------------------------------------------------------------------------*/
/*	Name		:	CheckForResdWord										*/
/*	Input		:	token, pointer to token string.							*/
/*	Output		:	token type.												*/
/*	Synopsis	:	Checks the token for reserved words and returns type.	*/
/*--------------------------------------------------------------------------*/

int		CheckForResdWord(byte *token)
{
	int		i;

	for (i = 0; i < NoOfResdWords; i++)
		if (!strcmp(token, ResdWords[i]))
			return(i + Q_IF);
	return(Q_ID);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	HexValue												*/
/*	Input		:	ch, input character.									*/
/*	Output		:	Hex value.												*/
/*	Synopsis	:	Returs the hex value of the input character.			*/
/*--------------------------------------------------------------------------*/

int		HexValue(int ch)
{
	if (ch >= '0' && ch <= '9')
		return(ch - '0');
	if (ch >= 'a' && ch <= 'f')
		return(ch - 'a' + 10);
	if (ch >= 'A' && ch <= 'F')
		return(ch - 'A' + 10);
	return(-1);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	SkipComment												*/
/*	Input		:	ch_ptr, pointer to look ahead character.				*/
/*	Output		:	0 if skipped, else -1.									*/
/*	Synopsis	:	Skips the comment in the input stream.					*/
/*--------------------------------------------------------------------------*/

int		SkipComment(int *ch_ptr)
{
	while (1) {
		*ch_ptr = GetChar();
		if (*ch_ptr == 0x0a)
			LineNo++;
		if (*ch_ptr == -1)
			break;
		if (*ch_ptr == '*') {
			*ch_ptr = GetChar();
			if (*ch_ptr == 0x0a)
				LineNo++;
			if (*ch_ptr == -1)
				break;
			if (*ch_ptr == '/') {
				*ch_ptr = GetChar();
				if (*ch_ptr == 0x0a)
					LineNo++;
				break;
			}
		}
		else {
			if (*ch_ptr == '/') {
				*ch_ptr = GetChar();
				if (*ch_ptr == 0x0a)
					LineNo++;
				if (*ch_ptr == -1)
					break;
				if (*ch_ptr == '*') {
					SkipComment(ch_ptr);
					*ch_ptr = GetChar();
					if (*ch_ptr == 0x0a)
						LineNo++;
				}
			}
		}
	}
	if (*ch_ptr == -1)
		return(-1);
	else
		return(0);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	Error													*/
/*	Input		:	err_id, error index.									*/
/*	Output		:	None													*/
/*	Synopsis	:	Prints the error message.								*/
/*--------------------------------------------------------------------------*/

void	Error(int err_id)
{
	byte	buffer[MAX_TOKEN_LEN];
	int		file_handle;

	if (err_id < NoOfErrMsgs) {
		sprintf(buffer, "Line %d -- %s\r\n", LineNo, ErrMsgs[err_id]);

		/*	If error file name given and not open, try to create it.	*/
		if (ErrorFileHandle == -1 && ErrorFileName) {
			/*	Create the file, close it, and open it in	*/
			/*	read/write exclusive mode.	*/
			ErrorFileHandle = Create(ErrorFileName);
			if (ErrorFileHandle >= 0) {
				Close(ErrorFileHandle);
				ErrorFileHandle = Open(ErrorFileName, READWRITE | EXCLUSIVE);
			}
			if (ErrorFileHandle < 0)
				ErrorFileHandle = -2;	/*	Don't try to create again.	*/
		}
		/*	If error file open, write to error file; otherwise, if	*/
		/*	psuedo code file given, write to that; if neither available	*/
		/*	ignore the error message.	*/
		file_handle = -1;
		if (ErrorFileHandle >= 0)
			file_handle = ErrorFileHandle;
		else
			if (OutFileHandle >= 0)
				file_handle = OutFileHandle;
		if (file_handle >= 0) {
			FWrite(file_handle, buffer, strlen(buffer));
#ifdef WIN
		WriteLine(buffer);
#endif
		}
		ErrCount++;
	}
}

/*--------------------------------------------------------------------------*/
/*	Name		:	CnvtLineNo												*/
/*	Input		:	None													*/
/*	Output		:	Pointer to the string with the line no.					*/
/*	Synopsis	:	Converts the line number to a string.					*/
/*--------------------------------------------------------------------------*/

byte	*CnvtLineNo(void)
{
	static	byte	LineNoStr[10];

	itoa(LineNo, LineNoStr, 10);
	return(LineNoStr);
}
