/* ------------------------------------------------------------------------
	File		:	DLGBOX.C
	Synopsis	:	Modifies the dialog control colors and draws borders
					for Listbox, Edit controls and group box.
	Author		:	Srinivasan S / Prasad KVS
	Date		:	20 Apr 1993
 ----------------------------------------------------------------------- */

#include <windows.h>
#include <memory.h>
#include <commdlg.h>

#include "dlgbox.h"

/* ************************* Internal Globals *************************** */

HINSTANCE	hDLGInst;
HBRUSH		hBkGndBrush;
HPEN		hNullPen;
HBRUSH		hBorderBrush;
HPEN		hWhitePen;	  			// white pen handle
HPEN		hGreyPen;	  			// Grey pen handle
HBRUSH		hGreyBrush;				// grey brush handle
int			ShadeHt = 4;
RECT		DlgRect;
HWND		hDlgHandle;

/* -------------------------------------------------------------------------
	Function	:	DLGInit(HINSTANCE hInst)
	Synopsis	:	Inits the Dlg module.
	Input		:	Instance handle.
	Output		:	TRUE on success, FALSE otherwise.
 ------------------------------------------------------------------------ */
BOOL FAR PASCAL
DLGInit(HINSTANCE hInst, int BackColor, int BorderColor, int ShadowHt)
{
	COLORREF	BkColor, BordColor;

	/* Init Globals */
	hDLGInst = hInst;

	switch (BackColor) {
		case DLG_BLACK:
			BkColor = RGB(0x00, 0x00, 0x00);
			break;

		case DLG_WHITE:
			BkColor = RGB(0xFF, 0xFF, 0xFF);
			break;

		case DLG_LTGRAY:
			BkColor = RGB(0xC0, 0xC0, 0xC0);
			break;

		case DLG_DKGRAY:
			BkColor = RGB(0x80, 0x80, 0x80);
			break;

		default:
			return (FALSE);
	}

	switch (BorderColor) {
		case DLG_BLACK:
			BordColor = RGB(0x00, 0x00, 0x00);
			break;

		case DLG_WHITE:
			BordColor = RGB(0xFF, 0xFF, 0xFF);
			break;

		case DLG_LTGRAY:
			BordColor = RGB(0xC0, 0xC0, 0xC0);
			break;

		case DLG_DKGRAY:
			BordColor = RGB(0x80, 0x80, 0x80);
			break;

		default:
			return (FALSE);
	}

	/* Create the brush and pen of required color and width */
	hBorderBrush = CreateSolidBrush(BordColor);
	hBkGndBrush = CreateSolidBrush(BkColor);
	hWhitePen			= CreatePen (PS_SOLID, 1, RGB(0xFF, 0xFF, 0xFF));
	hGreyPen			= CreatePen (PS_SOLID, 1, RGB(0x80, 0x80, 0x80));
	hGreyBrush 			= CreateSolidBrush(RGB(0x80, 0x80, 0x80));
	ShadeHt = ShadowHt;
	hNullPen			= CreatePen (PS_NULL,  1, RGB(   0,    0,    0));
	return (TRUE);
}

/* -------------------------------------------------------------------------
	Function	:	DLGClose(void)
	Synopsis	:	Closes the Dlg module by freeing up local resources.
	Input		:	None.
	Output		:	None.
 ------------------------------------------------------------------------ */
void FAR PASCAL DLGClose (void)
{
	DeleteObject(hNullPen);
	DeleteObject(hBorderBrush);
	DeleteObject(hBkGndBrush);
	DeleteObject(hWhitePen);
	DeleteObject(hGreyPen);
	DeleteObject(hGreyBrush);
}




/* -------------------------  End of File  -------------------------- */
