/****************************************************************************
 * FILE		: edit.c
 * PURPOSE	: Loads, saves, and edits mew script files
 ****************************************************************************/

#include 	"windows.h"
#include	<sys\types.h>
#include	<sys\stat.h>

#include	"edit.h"
#include	"file.h"

#include	"ourdlgbx.h"
#include	"dlgbox.h"


/****************************************************************************
    FUNCTION: SetNewBuffer(HWND, HANDLE, PSTR)
    PURPOSE: Set new buffer for edit window
    COMMENTS:
        Point the edit window to the new buffer, update the window title, and
        redraw the edit window.  If hNewBuffer is NULL, then create an empty
        1K buffer, and return its handle.
****************************************************************************/
void SetNewBuffer (HWND hWnd, HANDLE hNewBuffer, PSTR Title)
{
   HANDLE hOldBuffer ;

   hOldBuffer = (HANDLE) SendMessage (hEditWnd, EM_GETHANDLE, 0, 0L) ;
   LocalFree ((HANDLE) hOldBuffer) ;
   if (!hNewBuffer)  /* Allocates a buffer if none exists */
		hNewBuffer = (HANDLE) LocalAlloc (LMEM_MOVEABLE | LMEM_ZEROINIT, 1) ;

    /* Updates the buffer and displays new buffer */
	SendMessage (hEditWnd, EM_SETHANDLE, hNewBuffer, 0L) ;

   SetWindowText (hWnd, Title) ;
   SetFocus (hEditWnd) ;
   bEdited = FALSE ;
}

/****************************************************************************
 * FUNCTION	: QuerySaveEditFile(HWND);
 * PURPOSE	: Called when some action might lose current contents
 ****************************************************************************/
BOOL QuerySaveEditFile (HWND hWnd)
{
    int Response ;

    if (bEdited)
	 {
		lstrcpy (TmpStr, "Save current changes : ") ;
		lstrcat (TmpStr, EditFileName) ;
		Response = MessageBox (hWnd, TmpStr, "Script", 
								MB_YESNO | MB_ICONEXCLAMATION) ;
      if (Response == IDYES) 
		{
        	wsprintf (TmpStr, ScriptTitle, (LPSTR) EditFileName) ;
			SetWindowText (hWnd, TmpStr) ;
         SaveEditFile (hWnd) ;
		}
	}
	return TRUE ;
}

/****************************************************************************
 * FUNCTION	: SaveEditFile(HWND)
 * PURPOSE	: Save current file
 ****************************************************************************/
BOOL SaveEditFile (HWND hWnd)
{
	BOOL bSuccess ;
	int IOStatus ;
	HCURSOR hSaveCursor ;		/* save cursor */
	OFSTRUCT	OfStruct ;

	MakeFullFileName (TmpStr, ScriptFilesDir, EditFileName) ;
   if ((hFile = OpenFile (TmpStr, &OfStruct,
        					OF_PROMPT | OF_CANCEL | OF_CREATE)) < 0) 
	{
		wsprintf (TmpStr, "Error creating file  %s", (LPSTR) EditFileName) ;
		MessageBox (hWnd, TmpStr, "Router Script", MB_OK | MB_ICONEXCLAMATION) ;
      return FALSE ;
   }
	/* Lock the edit buffer and keep it ready for write to disk */
   hEditBuffer = (HANDLE) SendMessage (hEditWnd, EM_GETHANDLE, 0, 0L) ;
   pEditBuffer = LocalLock (hEditBuffer) ;

   /* Set the cursor to an hourglass during the file transfer */
   hSaveCursor = SetCursor (hHourGlass) ;

	/* write all the database entries */
   IOStatus = _lwrite (hFile, pEditBuffer, lstrlen (pEditBuffer)) ;
   _lclose (hFile) ;
	hCurCursor = hSaveCursor ;
   SetCursor (hSaveCursor) ;
	if (IOStatus != lstrlen (pEditBuffer)) 
	{
		wsprintf (TmpStr, "Error writing to  %s", (LPSTR) EditFileName) ;
		MessageBox (hWnd, TmpStr, "Router Script", MB_OK | MB_ICONHAND) ;
      bSuccess = FALSE ;
   }
   else 
	{
   	bSuccess = TRUE ;          /* Indicates the file was saved      */
      bEdited = FALSE ;          /* Indicates changes have been saved */
   }
   LocalUnlock (hEditBuffer) ;
   return bSuccess ;
}
