// stpfilt.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "stpfilt.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

int DisplayMessage (char *, LPCSTR, int) ;
extern void RightJustify (char *, char *, int) ;
int IsHexString (char *) ;
int IsDecimalString (char *) ;
/////////////////////////////////////////////////////////////////////////////
// STPFiltering dialog


STPFiltering::STPFiltering(CWnd* pParent /*=NULL*/)
	: CDialog(STPFiltering::IDD, pParent)
{
	//{{AFX_DATA_INIT(STPFiltering)
	m_STPFilterDefaultAction = "";
	//}}AFX_DATA_INIT
}

void STPFiltering::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(STPFiltering)
	DDX_Control(pDX, IDC_COMBO_STP_FILTER, m_STPFilterDefaultActionControl);
	DDX_Control(pDX, IDC_LIST_STP_FILTER, m_STPFilterListControl);
	DDX_Control(pDX, IDC_BUTTON_STP_FILTER_REMOVE, m_STPFilterRemoveControl);
	DDX_Control(pDX, IDC_BUTTON_STP_FILTER_EDIT, m_STPFilterEditControl);
	DDX_Control(pDX, IDC_BUTTON_STP_FILTER_ADD, m_STPFilterAddControl);
	DDX_CBString(pDX, IDC_COMBO_STP_FILTER, m_STPFilterDefaultAction);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(STPFiltering, CDialog)
	//{{AFX_MSG_MAP(STPFiltering)
	ON_BN_CLICKED(IDC_BUTTON_STP_FILTER_ADD, OnButtonStpFilterAdd)
	ON_BN_CLICKED(IDC_BUTTON_STP_FILTER_EDIT, OnButtonStpFilterEdit)
	ON_BN_CLICKED(IDC_BUTTON_STP_FILTER_REMOVE, OnButtonStpFilterRemove)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#define FILTER_STRING_LEN 80
#define MAX_FILTER_STRING_LENGTH 100

/////////////////////////////////////////////////////////////////////////////
// STPFiltering message handlers

char STPFilteringCfgChanged = 0 ;
BOOL STPFiltering::OnInitDialog()
{
   char FilterString[FILTER_STRING_LEN], IniString[257], far *NextAddress ;
   char StringToSearch[MAX_FILTER_STRING_LENGTH] ;
   int FilterType, PortNumber ;
   char DefaultAction[10] ;
   char Index[8] = "$A " ;
   int nTabStops=2, TabStops[] = {110, 140, 335} ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

   STPFilteringCfgChanged = 0 ;

	CDialog::OnInitDialog();
   CenterWindow() ;
   m_STPFilterListControl.SetTabStops (nTabStops, &TabStops[0]) ;

   GetPrivateProfileString (STSectionHeader, "Spanning Tree Default Action",
                            StrNull, (LPSTR)DefaultAction, 10, (LPCSTR)IniInWinForm) ;

   if (strcmpi (DefaultAction, DefFilterString) == NULL)
      m_STPFilterDefaultActionControl.SetCurSel(0) ;
   else
      m_STPFilterDefaultActionControl.SetCurSel(1) ;

   for (FilterType = 0 ; FilterType < NUMBER_OF_STP_FILTERS ; FilterType++)
   {
      strcpy (Index, "$A ") ;
      while (1)
      {
         strcpy (StringToSearch, Index) ;
         Index[1]++ ;
         strcat (StringToSearch, FilterStrings[FilterType+STP_FILTERS_BASE_INDEX]) ;
         GetPrivateProfileString (STSectionHeader, StringToSearch,
                                  StrNull, (LPSTR)IniString, 256, (LPCSTR)IniInWinForm) ;

         if (IniString[0] == 0)
            break ;

         sscanf (&IniString[0], "%d", &PortNumber) ;
         PortNumber-- ; /* Make it zero-based */

         NextAddress = &IniString[0] ;
         while ((*NextAddress != ',') && (*NextAddress != 0)) NextAddress++ ;
         NextAddress++ ;
         while (1)
         {
            FilterString[0] = 0 ;
            strcat (FilterString, &FilterStrings[FilterType+STP_FILTERS_BASE_INDEX][14]) ;
            strcat (FilterString, "\t") ;
            strcat (FilterString, PortTypes[PortNumber]) ;
            strcat (FilterString, "\t") ;
            strncat (FilterString, NextAddress, 12) ;
            m_STPFilterListControl.AddString (FilterString) ;

            while ((*NextAddress != ',') && (*NextAddress != 0)) NextAddress++ ;
            if (*NextAddress == 0)
               break ;
            NextAddress++ ;
         }
      }
   }

   UpdateData (FALSE) ;
	return TRUE;  // return TRUE  unless you set the focus to a control
}


void STPFiltering::OnCancel()
{
	// TODO: Add extra cleanup here

	CDialog::OnCancel();
}


#define MAX_FILTERS_PER_STRING 3
void STPFiltering::OnOK()
{
	// TODO: Add extra validation here
   int PortNumber, FirstPosition, NextPosition, DefaultActionIndex, i, j, NumberOfFiltersInCurrentString, NumberOfFilters ;
   char DisplayString[80], SearchString[100], FilterStringLHS[100], FilterStringRHS[250], FilterIndex[5], TempBuff[5] ;
   char *TempPointer, *DefaultActionStrings[] = {"filter", "forward"} ;

   DefaultActionIndex = m_STPFilterDefaultActionControl.GetCurSel() ;
   NumberOfFilters = m_STPFilterListControl.GetCount() ;
   sprintf (TempBuff, "%d", NumberOfFilters) ;
   
   if (DefaultActionIndex != CB_ERR)
   {
      WritePrivateProfileString (STSectionHeader, (LPCSTR) "Spanning Tree Default Action",
                                 DefaultActionStrings[DefaultActionIndex], (LPCSTR) IniInWinForm) ;

   }

   if (STPFilteringCfgChanged == 0)
   {
      CDialog::OnOK() ;
      return ;
   }

   for (i = 0 ; i < NUMBER_OF_STP_FILTERS ; i++)
   {
		/* Wipe off all old strings */
		strcpy (FilterIndex, "$A ") ;
		while (1)
		{
		   strcpy (SearchString, FilterIndex) ;
		   strcat (SearchString, FilterStrings[STP_FILTERS_BASE_INDEX+i]) ;
		   
		   GetPrivateProfileString (STSectionHeader, SearchString,
		                         StrNull, (LPSTR)FilterStringRHS, 250, (LPCSTR)IniInWinForm) ;
		   if (FilterStringRHS[0] == 0)
		      break ;
		   WritePrivateProfileString (STSectionHeader, SearchString,
		                         NULL, (LPCSTR) IniInWinForm) ;
			FilterIndex[1]++ ;
		}

		strcpy (FilterIndex, "$A ") ;
      for (j = 0 ; j < NUMBER_OF_PORTS ; j++)
      {
         PortNumber = j+1 ;

         strcpy (SearchString, &FilterStrings[STP_FILTERS_BASE_INDEX+i][14]) ;
         strcat (SearchString, "\t") ;
         strcat (SearchString, PortTypes[j]) ;

         FirstPosition = NextPosition = m_STPFilterListControl.FindString(-1, SearchString) ;
         sprintf (TempBuff, "%02d", PortNumber) ;
         if (FirstPosition == LB_ERR)
            continue ;

         NumberOfFiltersInCurrentString = 0 ;

         strcpy (FilterStringLHS, FilterIndex) ;
         strcat (FilterStringLHS, FilterStrings[STP_FILTERS_BASE_INDEX+i]) ;
         strcpy (FilterStringRHS, TempBuff) ;

         while (1)
         {
            strcat (FilterStringRHS, ",") ;
            m_STPFilterListControl.GetText(NextPosition, DisplayString) ;
            TempPointer = strchr (DisplayString, '\t') ;
            TempPointer++ ;
            TempPointer = strchr (TempPointer, '\t') ;
            TempPointer++ ;

            NumberOfFiltersInCurrentString++ ;
            strcat (FilterStringRHS, TempPointer) ;
            NextPosition = m_STPFilterListControl.FindString(NextPosition, SearchString) ;
            if (NextPosition <= FirstPosition)
               break ;

            if (NumberOfFiltersInCurrentString >= MAX_FILTERS_PER_STRING)
            {
               WritePrivateProfileString (STSectionHeader, (LPCSTR)FilterStringLHS,
                                         FilterStringRHS, (LPCSTR) IniInWinForm) ;

               FilterIndex[1]++ ;
               strcpy (FilterStringLHS, FilterIndex) ;
               strcat (FilterStringLHS, FilterStrings[STP_FILTERS_BASE_INDEX+i]) ;
               sprintf (TempBuff, "%02d", PortNumber) ;
               strcpy (FilterStringRHS, TempBuff) ;
               NumberOfFiltersInCurrentString = 0 ;
            }
         }
         if (NumberOfFiltersInCurrentString != 0)
			{
            WritePrivateProfileString (STSectionHeader, FilterStringLHS,
                                       FilterStringRHS, (LPCSTR) IniInWinForm) ;
				FilterIndex[1]++ ;
			}

#if 0
DeleteOldSTPStrings :
         while (1)
         {
            strcpy (SearchString, FilterIndex) ;
            strcat (SearchString, FilterStrings[STP_FILTERS_BASE_INDEX+i]) ;
            
            GetPrivateProfileString (STSectionHeader, SearchString,
                                  StrNull, (LPSTR)FilterStringRHS, 250, (LPCSTR)IniInWinForm) ;
            if (FilterStringRHS[0] == 0)
               break ;
            if (strncmp (FilterStringRHS, TempBuff, strlen (TempBuff)) == 0)
               WritePrivateProfileString (STSectionHeader, SearchString,
                                  StrNull, (LPCSTR) IniInWinForm) ;
				FilterIndex[1]++ ;
         }
#endif

      }
   }
   STPFilteringCfgChanged = 0 ;
	
	CDialog::OnOK();
}

char NewEthernetAddress[13] ;
int NewSTPPortNumber, NewSTPFilterType ;
char NewSTPFilterAdded = 0 ;
      
void STPFiltering::OnButtonStpFilterAdd()
{
   char FilterString[FILTER_STRING_LEN] ;

	// TODO: Add your control notification handler code here
   AddSTPFilter NewSTPFilter ;

   NewSTPFilter.DoModal() ;
   if (NewSTPFilterAdded == 0)
      return ;

   FilterString[0] = 0 ;
   strcat (FilterString, &FilterStrings[STP_FILTERS_BASE_INDEX+NewSTPFilterType][14]) ;
   strcat (FilterString, "\t") ;
   strcat (FilterString, PortTypes[NewSTPPortNumber]) ;
   strcat (FilterString, "\t") ;
   strncat (FilterString, NewEthernetAddress, 12) ;
   m_STPFilterListControl.AddString(FilterString) ;

   STPFilteringCfgChanged = 1 ;

   UpdateData(FALSE) ;
   NewSTPFilterAdded = 0 ;

   return ;

}

char EditSTPFilter = 0 ;
char EditSTPFilterType[30], EditSTPFilterPort[6], EditSTPFilterAddress[13] ;
void STPFiltering::OnButtonStpFilterEdit()
{
   char FilterString[FILTER_STRING_LEN] ;
	int Index, i ;
	char *TempPointer ;

	Index = m_STPFilterListControl.GetCurSel() ;
	if (Index == LB_ERR)
		return ;

	/* Fill up the existing feilds */
	m_STPFilterListControl.GetText (Index, FilterString) ;
	TempPointer = &FilterString[0] ;

	i = 0 ;
	while (*TempPointer != '\t')
		EditSTPFilterType[i++] = *TempPointer++ ;
	EditSTPFilterType[i] = 0 ;
	TempPointer++ ;

	i = 0 ;
	while (*TempPointer != '\t')
		EditSTPFilterPort[i++] = *TempPointer++ ;
	EditSTPFilterPort[i] = 0 ;
	TempPointer++ ;

	for (i = 0 ; i < 12 ; i++)
		EditSTPFilterAddress[i] = *TempPointer++ ;
	EditSTPFilterAddress[13] = 0 ;
	TempPointer++ ;

   AddSTPFilter NewSTPFilter ;

	EditSTPFilter = 1 ;
   NewSTPFilter.DoModal() ;
	EditSTPFilter = 0 ;
   if (NewSTPFilterAdded == 0)
      return ;

	m_STPFilterListControl.DeleteString (Index) ;

   FilterString[0] = 0 ;
   strcat (FilterString, &FilterStrings[STP_FILTERS_BASE_INDEX+NewSTPFilterType][14]) ;
   strcat (FilterString, "\t") ;
   strcat (FilterString, PortTypes[NewSTPPortNumber]) ;
   strcat (FilterString, "\t") ;
   strncat (FilterString, NewEthernetAddress, 12) ;
   m_STPFilterListControl.AddString(FilterString) ;

   STPFilteringCfgChanged = 1 ;

   UpdateData(FALSE) ;
   NewSTPFilterAdded = 0 ;

   return ;

}


void STPFiltering::OnButtonStpFilterRemove()
{
	// TODO: Add your control notification handler code here

   int Index ;
   Index = m_STPFilterListControl.GetCurSel() ;
   if (Index == LB_ERR)
      return ;

   m_STPFilterListControl.DeleteString (Index) ;
   STPFilteringCfgChanged =1 ;

   UpdateData(FALSE) ;
}
/////////////////////////////////////////////////////////////////////////////
// AddSTPFilter dialog

AddSTPFilter::AddSTPFilter(CWnd* pParent /*=NULL*/)
	: CDialog(AddSTPFilter::IDD, pParent)
{
	//{{AFX_DATA_INIT(AddSTPFilter)
	m_STPNewFilterAddress = "";
	//}}AFX_DATA_INIT
}

void AddSTPFilter::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AddSTPFilter)
	DDX_Control(pDX, IDC_EDIT_STP_NEW_FILTER_ADDRESS, m_STPNewFilterAddressControl);
	DDX_Control(pDX, IDC_COMBO_STP_NEW_FILTER_POR, m_STPNewFilterPortControl);
	DDX_Control(pDX, IDC_COMBO_STP_FILTER_TYPE, m_STPNewFilterTypeControl);
	DDX_Text(pDX, IDC_EDIT_STP_NEW_FILTER_ADDRESS, m_STPNewFilterAddress);
	DDV_MaxChars(pDX, m_STPNewFilterAddress, 12);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(AddSTPFilter, CDialog)
	//{{AFX_MSG_MAP(AddSTPFilter)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// AddSTPFilter message handlers

BOOL AddSTPFilter::OnInitDialog()
{
   char *TempPointer, NumberOfPortsString[10] ;
   int i, DefPortNumber, DefFilterType, NumberOfPorts ;

	CDialog::OnInitDialog();
	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	if (EditSTPFilter)
	{	
		TempPointer = strstr (WindowHeader, " Add Spanning Tree Filter") ;
		if (TempPointer != NULL)
		{
			*TempPointer++ = 'E' ;
			*TempPointer++ = 'd' ;
			*TempPointer++ = 'i' ;
			*TempPointer++ = 't' ;
		}
	}
	SetWindowText (WindowHeader) ;

	
   GetPrivateProfileString (STSectionHeader, "Spanning Tree Number of Ports",
              StrNull, (LPSTR)NumberOfPortsString, 5, (LPCSTR)IniInWinForm) ;
   sscanf (NumberOfPortsString, "%d", &NumberOfPorts) ;
   NumberOfPorts++ ;	//Add for one LAN port
	if ( NumberOfPorts > 15 )
		NumberOfPorts = 15;

	// TODO: Add extra initialization here
   for (i = 0 ; i < NumberOfPorts ; i++)
      m_STPNewFilterPortControl.InsertString (i, PortTypes[i]) ;

	if (EditSTPFilter)
	{
		m_STPNewFilterAddress = EditSTPFilterAddress ;
		DefPortNumber = 0 ;
		while (strcmpi (PortTypes[DefPortNumber], EditSTPFilterPort))
		{
			if (DefPortNumber >= NumberOfPorts)
				break ;
			DefPortNumber++ ;
		}

		DefFilterType = 0 ;
		while (strcmpi (EditSTPFilterType, &FilterStrings[STP_FILTERS_BASE_INDEX+DefFilterType][14]))
		{
			if (DefFilterType >= NUMBER_OF_STP_FILTERS)
				break ;
			DefFilterType++ ;
		}
		if (DefFilterType >= NUMBER_OF_STP_FILTERS)
			DefFilterType = 0 ;
	}

	m_STPNewFilterTypeControl.SetCurSel(DefFilterType) ;
   m_STPNewFilterPortControl.SetCurSel(DefPortNumber) ;

   m_STPNewFilterAddressControl.LimitText(12) ;

	UpdateData (FALSE) ;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void AddSTPFilter::OnCancel()
{
	// TODO: Add extra cleanup here

   NewSTPFilterAdded = 0 ;
	
	CDialog::OnCancel();
}

void AddSTPFilter::OnOK()
{
	// TODO: Add extra validation here
   char TempBuff[20] ;

   UpdateData (TRUE) ;

	// Added by cfp on 8-4-96
	if (m_STPNewFilterAddress.IsEmpty() ||
				AllZeroesInAddress (m_STPNewFilterAddress))
	{
		NewSTPFilterAdded = 0 ;
		RouMsgBox (MSG_FILT_INVALID_MAC_ADDRESS,
							FilteringMsgHeader, MB_OK | MB_ICONSTOP) ;
		m_STPNewFilterAddressControl.SetFocus() ;
		return ;
	}

   m_STPNewFilterAddress.MakeUpper() ;
   RightJustify (m_STPNewFilterAddress.GetBuffer(0), TempBuff, 12) ;
   strcpy (NewEthernetAddress, TempBuff) ;

	if (!(IsHexString (TempBuff)))
	{
		NewSTPFilterAdded = 0 ;
		RouMsgBox (MSG_FILT_INVALID_MAC_ADDRESS,
						FilteringMsgHeader, MB_OK | MB_ICONSTOP) ;
		m_STPNewFilterAddressControl.SetFocus() ;
		return ;
	}
	else
	{
   	NewSTPPortNumber = m_STPNewFilterPortControl.GetCurSel() ;
		// Added by cfp on 8-4-96
		if (NewSTPPortNumber == CB_ERR)
		{
			NewSTPFilterAdded = 0 ;
			RouMsgBox (MSG_FILT_INVALID_ST_PORT_NO,
							FilteringMsgHeader, MB_OK | MB_ICONSTOP) ;
			m_STPNewFilterPortControl.SetFocus() ;
			return ;
		}

   	NewSTPFilterType = m_STPNewFilterTypeControl.GetCurSel() ;
		// Added by cfp on 8-4-96
		if (NewSTPFilterType == CB_ERR)
		{
			NewSTPFilterAdded = 0 ;
			RouMsgBox (MSG_FILT_INVALID_ST_TYPE,
							FilteringMsgHeader, MB_OK | MB_ICONSTOP) ;
			m_STPNewFilterTypeControl.SetFocus() ;
			return ;
		}

   	NewSTPFilterAdded = 1 ;
	}

	CDialog::OnOK();
   return ;
}

void STPFiltering::OnHelp()
{
	// TODO: Add your control notification handler code here
   AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_STP_FILTERING,HELP_CONTEXT);
	
}

void AddSTPFilter::OnHelp()
{
	// TODO: Add your control notification handler code here
   AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_STP_NEW_FILTERING,HELP_CONTEXT);
	
}

int	AddSTPFilter::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}

// Added by cfp on 12-4-96
BOOL AddSTPFilter::AllZeroesInAddress (CString &NetAddr)
{
	CString ZeroesAddr ;
	ZeroesAddr = NetAddr ;

	int nAddrLen = ZeroesAddr.GetLength() ;
	int zero_count = 0 ;
	char Alpha ;
	for (int index = 0 ; index < nAddrLen ; ++ index)
	{
		Alpha = ZeroesAddr.GetAt (index) ;
		if (Alpha == '0')
			zero_count ++ ;
		else
			return FALSE ;
	}
	if (zero_count == nAddrLen)
		return TRUE ;
	return FALSE ;
}

