// tabdlg.h : interface of the CTabDialog class
// Written by Gerry High & David Hollifield
// V1.2 4/13/94
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __MFX_TABDLG_H__
#define __MFX_TABDLG_H__

//#define __CTL3D__       // comment out this line if you do not want to use
					//  CTL3D.DLL/CTL3DV2.DLL

#include "tabarray.h"
#define  MIN_TAB_NUM    2  //MInimum number of tabs

class CTabDialog : public CDialog             
{
	DECLARE_DYNAMIC(CTabDialog)
protected:
	CTabDialog();

public:
	CTabDialog(LPCSTR lpszTemplateName, CWnd* pParentWnd = NULL);
	CTabDialog(UINT nIDTemplate, CWnd* pParentWnd = NULL);

// Attributes
public:

// Operations
public:
	virtual CDialog*        addTabView(CDialog* pDialog, char* tabLabel, BOOL border = FALSE, BOOL show = FALSE,int tabWidth = 100);
	BOOL                            doSysCommand(UINT nID,LONG lParam);
	void                            enableView(int viewIndex, BOOL bEnable = TRUE);
	void                            setFrameBorderOn(BOOL on = TRUE);
	void                            setLAF(eLookAndFeel LAF=LAF_MSWORD);
	void                            setMargin(int margin=7);
	void                            setTabHeight(int height=25);
	void                            setTabPosition(eTabPosition tabPos=TABSONTOP);
	virtual void            switchTab(int viewIndex);

// Implementation
public:
	virtual                         ~CTabDialog();
	virtual int             DoModal( );

protected:
	virtual CDialog*        createTabView(CDialog* pDialog, CWnd* parentWnd, BOOL border,BOOL show);
	virtual void            createFonts();
	virtual void            destroyFonts();
	
	void                            repositionViews();
	BOOL                            switchTopTab(CPoint point);
	BOOL                            switchVerticalTab(CPoint point);

#ifdef _DEBUG
	virtual void            AssertValid() const;
	virtual void            Dump(CDumpContext& dc) const;
#endif

private:
	void Construct();

protected:
	// implementation data
	int m_width;                            // view width
	int m_height;                           // view height
	int m_nTabs;                            // number of tabs
	CTabArray m_tabArray;           // array of CTabInfo objects
	CDialog* m_curView;                     // current view
	eLookAndFeel m_lookAndFeel;     // Look of Tabs (either LAF_CHICAGO or LAF_MSWORD)
	
// Generated message map functions
protected:
	//{{AFX_MSG(CTabDialog)
	afx_msg LRESULT OnCommandHelp(WPARAM wParam, LPARAM lParam);
	virtual void    OnCancel();
	afx_msg BOOL    OnEraseBkgnd(CDC* pDC);
	afx_msg LRESULT OnHelpHitTest(WPARAM wParam, LPARAM lParam);
	virtual BOOL    OnInitDialog();
	afx_msg void    OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg LRESULT OnMenuChar(UINT character, UINT menu_flags, CMenu* menu_handle);
	afx_msg int     OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	virtual void    OnOK();
	afx_msg void    OnPaint();
	afx_msg void    OnSetFocus(CWnd* pOldWnd);
	afx_msg void    OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG

#ifdef  __CTL3D__
	afx_msg HBRUSH  OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg BOOL    OnNcActivate(BOOL);
	afx_msg void    OnNcPaint();
#endif

	DECLARE_MESSAGE_MAP()
};


extern const UINT NEAR msgSwitchFrom;
extern const UINT NEAR msgSwitchTo;

#endif

/////////////////////////////////////////////////////////////////////////////
