#include	<windows.h>
#include	<commdlg.h>

#include	"main.h"
#include	"mew.h"
#include	"clrsetup.h"
#include	"emlnfuns.h"
#include	"wstdio.h"
#include	"looks.h"
#include	"dlgbox.h"

 
ColorSetupType	DefColorSetup = { 7, 0, 15, 7, 7, 0, 7};
ColorSetupType 	ColorSetup = { 7, 0, 15, 7, 7, 0, 7};
ColorSetupType	ClrStp;
int			ClrSelection;
extern	char	TmpStr[];
/****************************************************************************
If any of the color values is absurd, set everyting to defaults
****************************************************************************/
void	CheckColorVals(void)
{
	int i;

	BYTE	*ptr = (BYTE *)&ColorSetup;
	for (i = sizeof(ColorSetup) - 1; i >= 0; i--) {
		if (ptr[i] > 15) {
SetDefColors:
			ColorSetup = DefColorSetup;
			return;
		}
	}
	if (ColorSetup.TermFg > 7 || ColorSetup.TermBg > 7) {
		ColorSetup.TermFg = 7;
		ColorSetup.TermBg = 0;
	}
	if ((ColorSetup.TermFg == ColorSetup.TermBg) ||
					(ColorSetup.KeyFg == ColorSetup.KeyBg) ||
					(ColorSetup.KeyFg == ColorSetup.StatBg))
		goto SetDefColors;

}
void	ClearTermBg(void);
extern	HBRUSH		hBlackBrush;			// black brush handle
/*****************************************************************************
Function	:	DrawButtonControl
Synop		:	This routine handles all the major portions of color setup.
*****************************************************************************/
void	DrawButtonControl(HWND hWnd, LPDRAWITEMSTRUCT DrawItem)
{
	int		color;
	HBRUSH	hOldBrush, hBrush;
	RECT	frect;

	switch (DrawItem->CtlID) {
		case 300: color = BLACK; break;
		case 301: color = RED; break;
		case 302: color = GREEN; break;
		case 303: color = YELLOW; break;
		case 304: color = BLUE; break;
		case 305: color = MAGENTA; break;
		case 306: color = CYAN; break;
		case 307: color = WHITE; break;
		case 308: color = HI_BLACK; break;		// this id disabled
		case 309: color = HI_RED; break;
		case 310: color = HI_GREEN; break;
		case 311: color = HI_YELLOW; break;
		case 312: color = HI_BLUE; break;
		case 313: color = HI_MAGENTA; break;
		case 314: color = HI_CYAN; break;
		case 315: color = HI_WHITE; break;

		case 200: color = ColorSetup.TermFg; break;
		case 201: color = ColorSetup.TermBg; break;
		case 202: color = ColorSetup.TermWin; break;
		case 203: color = ColorSetup.Tbar; break;
		case 204: color = ColorSetup.KeyBg; break;
		case 205: color = ColorSetup.KeyFg; break;
		case 206: color = ColorSetup.StatBg; break;

		default : color = ClrSelection; break;
	}
	if (DrawItem->itemAction & ODA_DRAWENTIRE) {
		// select the BRUSH
		hBrush = CreateSolidBrush(ColorTable[color]);
		hOldBrush = SelectObject (DrawItem->hDC, hBrush);
		// draw a rectangle
		Rectangle (DrawItem->hDC, (DrawItem->rcItem).left,
			(DrawItem->rcItem).top, (DrawItem->rcItem).right,
			(DrawItem->rcItem).bottom);
		SelectObject (DrawItem->hDC, hOldBrush);
		DeleteObject(hBrush);
		if (DrawItem->itemState & ODS_FOCUS)
			goto DrawFocus;
	}							  
	if ((DrawItem->itemAction & ODA_FOCUS) &&
						(DrawItem->itemState & ODS_FOCUS)) {
DrawFocus:
		if ( IS_OPTIONS_ID(DrawItem->CtlID) || IS_FIELDS_ID(DrawItem->CtlID)) {
			frect = DrawItem->rcItem;
			frect.left += CLR_FOCUS_MARGIN;
			frect.top += CLR_FOCUS_MARGIN;
			frect.right -= CLR_FOCUS_MARGIN;
			frect.bottom -= CLR_FOCUS_MARGIN;
			DrawFocusRect(DrawItem->hDC, (LPRECT)&frect);
		}
	}
	if ((DrawItem->itemAction  & ODA_SELECT) &&
							(DrawItem->itemState & ODS_SELECTED)) {
		if (IS_OPTIONS_ID(DrawItem->CtlID)) {
			// this is color selection
			ClrSelection = DrawItem->CtlID - 300;
			// reflect this selection in the "Selection" field
			InvalidateRect(GetDlgItem(hWnd, 124), NULL, TRUE);

		} else if (IS_FIELDS_ID(DrawItem->CtlID)) {
			if ((ClrSelection & 0x08) && (DrawItem->CtlID == 200)) {
				LoadString(hInst, 299, TmpStr, 128);
				DispMsgBox(hWnd, MSG_ER_COLOR1, TmpStr, MB_OK);
				return;
			}
			if ((ClrSelection & 0x08) && (DrawItem->CtlID == 201)) {
				LoadString(hInst, 299, TmpStr, 128);
				DispMsgBox(hWnd, MSG_ER_COLOR2, TmpStr, MB_OK);
				return;
			}

			// this is a field selection
			((BYTE *)&ColorSetup)[DrawItem->CtlID - 200] =
												(BYTE) ClrSelection;
			InvalidateRect(GetDlgItem(hWnd, DrawItem->CtlID), NULL, TRUE);
			/* Depending on ID we have to invalidate terminal portion */
			switch (DrawItem->CtlID) {
				case 200:			// terminal chars
				case 201:			// terminal background
					NormAttrib = (BYTE) (ColorSetup.TermBg << 4 |
											ColorSetup.TermFg);
					SetDispNormAtt();
					ClearTermBg();				// Change present bg attribs
					InvalidateRect(hTermWnd, NULL, TRUE);
					break;
				case 202:			// terminal border
					InvalidateRect(hMainWnd, &MainWndRect, TRUE);
					break;
				case 203:			// tool bar
					hBrush = CreateSolidBrush(ColorTable[ColorSetup.Tbar]);
					SetClassWord(hTbarWnd, GCW_HBRBACKGROUND,
						(WORD)hBrush);
					DeleteObject(hBrush);
					InvalidateRect(hTbarWnd, NULL, TRUE);
					break;
				case 204:			// pushbutton up and down
					InvalidateRect (hStatusWnd, NULL, TRUE);
					break;
				case 205:			// key and status window text
					InvalidateRect (hStatusWnd, NULL, TRUE);
				case 206:			// status window bg
					InvalidateRect (hTimeWnd, NULL, TRUE);
					break;
			}
		}
	}
}

int FAR PASCAL
ColorSetupDlgProc(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
	int		i;
	HBRUSH	hBrush;

	switch (message) {

	case WM_INITDIALOG:
		DLGCenterDialog(hDlg);
		memcpy(&ClrStp, &ColorSetup, sizeof(ColorSetup));	// copy current setup
		SetFocus(GetDlgItem(hDlg, IDOK));
		return FALSE;

	case WM_COMMAND :
		switch (wParam) {
			case IDOK:					// New colors are already displayed
			EndDialog(hDlg, TRUE);
			return TRUE;

		case IDCANCEL :
			if ((ColorSetup.TermBg != ClrStp.TermBg) ||
				(ColorSetup.TermFg != ClrStp.TermFg)) {
				NormAttrib = (BYTE) (ClrStp.TermBg << 4 |
										ClrStp.TermFg);
				SetDispNormAtt();
				ClearTermBg();				// Change present bg attribs
				InvalidateRect(hTermWnd, NULL, TRUE);
			}
			if (ColorSetup.TermWin != ClrStp.TermWin)
				InvalidateRect(hMainWnd, &MainWndRect, TRUE);
			if (ColorSetup.KeyFg != ClrStp.KeyFg) {
				InvalidateRect (hTimeWnd, NULL, TRUE);
				InvalidateRect (hStatusWnd, NULL, TRUE);
			}
			if (ColorSetup.StatBg != ClrStp.StatBg) {
				InvalidateRect (hTimeWnd, NULL, TRUE);
			}
			if (ColorSetup.KeyBg != ClrStp.KeyBg) {
				InvalidateRect (hStatusWnd, NULL, TRUE);
			}
			if (ColorSetup.Tbar != ClrStp.Tbar) {
				hBrush = CreateSolidBrush(ColorTable[ClrStp.Tbar]);
				SetClassWord(hTbarWnd, GCW_HBRBACKGROUND,
					(WORD)hBrush);
				DeleteObject(hBrush);
				InvalidateRect(hTbarWnd, NULL, TRUE);
			}
			// copy all the colors back;
			memcpy(&ColorSetup, &ClrStp, sizeof(ColorSetup));
			EndDialog(hDlg, FALSE);
			return TRUE;

		case 10:							// Set all colors to default
			ColorSetup = DefColorSetup;
			for (i = 200; i < 207; i++)		// redisplay current settings
				InvalidateRect(GetDlgItem(hDlg, i), NULL, TRUE);
			NormAttrib = (BYTE) (ColorSetup.TermBg << 4 |
										ColorSetup.TermFg);
			SetDispNormAtt();
			ClearTermBg();				// Change present bg attribs
			hBrush = CreateSolidBrush(ColorTable[ColorSetup.Tbar]);
			SetClassWord(hTbarWnd, GCW_HBRBACKGROUND,(WORD)hBrush);
			DeleteObject(hBrush);
			InvalidateRect(hTbarWnd, NULL, TRUE);
			InvalidateRect(hTermWnd, NULL, TRUE);
			InvalidateRect (hTimeWnd, NULL, TRUE);
			InvalidateRect (hStatusWnd, NULL, TRUE);
			InvalidateRect(hMainWnd, &MainWndRect, TRUE);
			return TRUE;
		}
		break;
	case WM_DRAWITEM:
		DrawButtonControl(hDlg, (LPDRAWITEMSTRUCT)lParam);
		break;
	}
	return FALSE;
}

