/****************************************************************************
 * PROGRAM	: file.c
 * PURPOSE	: Loads, saves, and restores the configuration settings related
 *			  to a specific session.
 ****************************************************************************/

#include <windows.h>
#include	<commdlg.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <fcntl.h>

#include "mew.h"
#include	"session.h"
#include "main.h"
#include "file.h"
#include	"config.h"
#include	"term.h"
#include	"emlntype.h"
#include	"wstdio.h"
#include	"time.h"
#include	"status.h"
#include	"emlnfuns.h"
#include	"dlgbox.h"

OPENFILENAME	OpenFileName;
char 	TmpStr[255];			/* scratch buffer */
int 	hFile;             		/* file handle */
BYTE	IOFilePathName[128];
struct	stat FileStatus;	/* information from fstat()        */

char	*NoneStr = "NONE";
char	*OddStr = "ODD";
char	*EvenStr = "EVEN";
char	*MarkStr = "MARK";
char	*NoTitleStr = "Untitled";
BYTE	GenericFilter[] = "Files present(*.*)\000*.*\000";
char	CurFileName[13];
/***************************************************************************
Routine	:	AddExtn(Name, Ext)
Input	:	Filename pointer, and needed extn (must be in ".xxx" form).
Return	:	
Synop	:	if no extension is present, the passed extn is added
***************************************************************************/
void
AddExtn(LPSTR Name, LPSTR Ext)
{
	Name[9] = NULL;
    while (*Name && *Name != '.')		//while not NULL or '.'
        Name++;							//traverse the name

    if (*Name != '.')					//if . no extn is present
        lstrcpy(Name, Ext);				//add the passed extn else just retn
}

/***************************************************************************
Routine	:	ForceExtn(Filename, Ext)
Input	:	Filename pointer, and needed extn (must be in ".xxx" format)
Return	:	
Synop	:	pointer Filename is forced to have Ext string as extension
***************************************************************************/
void	ForceExtn(LPSTR Name, LPSTR Ext)
{
	Name[8] = NULL;
	while (*Name && *Name != '.')
		Name++;
	lstrcpy(Name, Ext);
}

/***************************************************************************
Routine	:	StripExtn(LPSTR)
Input	:	Filename pointer
Return	:	
Synop	:	pointer Name stripped off extension
***************************************************************************/
void	StripExtn(LPSTR Name)
{
	Name[8] = NULL;
	while (*Name && (*Name != '.') && (*Name != '\t') && (*Name != ' '))
		Name++;
	*Name = 0;
}

/***************************************************************************
Routine	:	ChangeDefExtn(Filename, Ext)
Input	:	Filename pointer, and needed extn
Return	:	
Synop	:	pointer Filename is forced to have Ext string as extension
***************************************************************************/
void	ChangeDefExtn(LPSTR Name, LPSTR Ext)
{
	Name[8] = NULL;
    while (*Name && *Name != '.')
        Name++;
    if (*Name)
        if (!_fstrchr(Name, '*') && !_fstrchr(Name, '?'))
            lstrcpy(Name, Ext);
}

/****************************************************************************
 * FUNCTION	: SeparateFile(LPSTR, LPSTR, LPSTR)
 * PURPOSE	: Separate filename and pathname
 ****************************************************************************/
void
SeparateFile(LPSTR lpDestPath, LPSTR lpDestFileName, LPSTR lpSrcFileName)
{
    LPSTR lpTmp;
    char  cTmp;

    lpTmp = lpSrcFileName + (long) lstrlen(lpSrcFileName);
    while (*lpTmp != ':' && *lpTmp != '\\' && lpTmp > lpSrcFileName)
        lpTmp = AnsiPrev(lpSrcFileName, lpTmp);
    if (*lpTmp != ':' && *lpTmp != '\\') {
        lstrcpy(lpDestFileName, lpSrcFileName);
        lpDestPath[0] = 0;
        return;
    }
    lstrcpy(lpDestFileName, lpTmp + 1);
    cTmp = *(lpTmp + 1);
    lstrcpy(lpDestPath, lpSrcFileName);
     *(lpTmp + 1) = cTmp;
    lpDestPath[(lpTmp - lpSrcFileName) + 1] = 0;
ProcessDirName(lpDestPath);
}


/****************************************************************************
 * FUNCTION	: CheckFileName(HWND, PSTR, PSTR, PSTR)
 * PURPOSE	: Check for wildcards, add extension if needed
 ****************************************************************************/
BOOL
CheckFileName(HWND hWnd, LPSTR pDest, LPSTR pSrc, LPSTR extn)
{
    LPSTR pTmp;

    if (!pSrc[0])
        return (FALSE);               /* Indicates no filename was specified */

    pTmp = pSrc;
    while (*pTmp) {                     /* Searches the string for wildcards */
        switch (*pTmp++) {
            case '*':
            case '?':
				LoadString(hInst, 299, TmpStr, 128);
                DispMsgBox(hWnd, MSG_NO_WILDCARDS, TmpStr,
											MB_OK | MB_ICONEXCLAMATION);
                return (FALSE);
        }
    }

    AddExtn(pSrc, extn);            /* Adds the default extension if needed */
    strcpy(pDest, pSrc);
    return (TRUE);
}
/****************************************************************************
Routine	:	ProcessDirName()
Input	:
Return	:	returns 1 if name OK and direcotry exists, 0 if name OK and
			directory not present  and -1 if name not OK (Sets name to NULL)
Synop	:	Scans name. returns -1 if wild cards. if name OK and dir present
			returns 1. if dir not present returns 0; also strupr is done
****************************************************************************/
int		ProcessDirName(LPSTR DirName)
{
	int		index;

	_fstrupr(DirName);
	for(index = 0; DirName[index]; index++) {
		if (DirName[index] == '*' || DirName[index] == '?') {
WrongName:
			return -1;
		}
		if (index != 1 && DirName[index] == ':')	// check wrong : char
			goto WrongName;
	}
	/* Check for back slash at end */
	if (index)
		index--;
	if (index && DirName[index] == '\\') {
		index--;
		if (index && DirName[index] != ':')		// : can't be wrong now
			DirName[index+1] = 0;
	}
	return 0;
}

/****************************************************************************
Routine	:	MakeFullFileName
Input	:	pointers to destination, pathname and file name
Return	:	pointer to dest
Synop	:	filename is concatenated to pathname and \ is added if needed
****************************************************************************/
LPSTR	MakeFullFileName(LPSTR dest, LPSTR pathname, LPSTR filename)
{
	int		len;

	len = lstrlen(pathname);
	lstrcpy(dest, pathname);
	if (pathname[len-1] != '\\' && pathname[len-1] != ':')
		lstrcat(dest, "\\");
	lstrcat(dest, filename);
	return dest;
}

/***************************************************************************
*	Routine	:	GetSaveFilePathName()
*	Input	:	
*	Return	:	
*	Synopsis:	Gets a file name for saving data (edit, selcopy, fxfile)
***************************************************************************/
BOOL	GetSaveFilePathName(HWND hWnd, LPSTR InitDir, LPSTR Head,
		BOOL AskOverWrite, LPSTR Filter, LPSTR Extn)
{

	IOFilePathName[0] = NULL;

	memset (&OpenFileName, 0, sizeof(OPENFILENAME));
	OpenFileName.lStructSize = sizeof(OPENFILENAME);
	OpenFileName.hwndOwner = hWnd;
	if (Filter)
		OpenFileName.lpstrFilter = Filter;
	else
		OpenFileName.lpstrFilter = GenericFilter;

	OpenFileName.nFilterIndex = 1;
	OpenFileName.lpstrFile = IOFilePathName;
	OpenFileName.nMaxFile = 128;
	OpenFileName.lpstrFileTitle = NULL;
	OpenFileName.nMaxFileTitle = 0;
	OpenFileName.lpstrInitialDir = InitDir;
	OpenFileName.lpstrTitle = Head;
	OpenFileName.lpstrDefExt = Extn;
	if (AskOverWrite)
		OpenFileName.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
	else
		OpenFileName.Flags = OFN_HIDEREADONLY;

	if (GetSaveFileName(&OpenFileName)) {
		_fstrupr(IOFilePathName);						//Convert to upper case
		return TRUE;
	}
	return FALSE;
}

/***************************************************************************
*	Routine	:	GetOpenFilePathName()
*	Input	:	
*	Return	:	
*	Synopsis:	Gets a file name for opening
***************************************************************************/
BOOL	GetOpenFilePathName(HWND hWnd, LPSTR InitDir, LPSTR Head,
		LPSTR Filter, LPSTR Extn)
{

	IOFilePathName[0] = NULL;
	memset (&OpenFileName, 0, sizeof(OPENFILENAME));
	OpenFileName.lStructSize = sizeof(OPENFILENAME);
	OpenFileName.hwndOwner = hWnd;
	if (Filter)
		OpenFileName.lpstrFilter = Filter;
	else
		OpenFileName.lpstrFilter = GenericFilter;

	OpenFileName.nFilterIndex = 1;
	OpenFileName.lpstrFile = IOFilePathName;
	OpenFileName.nMaxFile = 128;
	OpenFileName.lpstrFileTitle = NULL;
	OpenFileName.nMaxFileTitle = 0;
	OpenFileName.lpstrInitialDir = InitDir;
	OpenFileName.lpstrTitle = Head;
	OpenFileName.lpstrDefExt = Extn;
	OpenFileName.Flags = OFN_FILEMUSTEXIST |
							OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;

	if (GetOpenFileName(&OpenFileName)) {
		_fstrupr(IOFilePathName);
		return TRUE;
	}
	return FALSE;
}

