/*---------------------------------------------------------------------------
*	File		:	kbd.c
*	Purpose		:	keboard remapping of keys
*	Package		:	MultiExpress (Windows) - Version 1.00
*	Authors		:	Vidy
*	Date		:	
---------------------------------------------------------------------------*/
#include	<windows.h>
#include	<fcntl.h>
#include	<commdlg.h>

#include	"main.h"
#include	"mew.h"
#include	"session.h"
#include	"emlncons.h"
#include	"emlntype.h"
#include	"emlndata.h"
#include	"emlnfuns.h"
#include	"kbd.h"
#include	"term.h"
#include	"file.h"
#include	"fnkey.h"
#include	"dlgbox.h"

BYTE	KeyScan;
BYTE	FlgExt;
BYTE	*OrgExpn[3];
BYTE	MapChanged;
BYTE	*SameProg = "<Same as normal>";
BYTE	*SysKey = "<System key>";
BYTE	CheckingDblClick;					/* a bool to show checking is on */
FARPROC	lpDblClickTimerProc;
WORD	DblClickTimerId;

KeyExpansionType	*TrmExpList;		/* contains current trm key list */
KeyExpansionType	*TmpExpList;		/* contains current edits */
BYTE	CurTrmIdx;

BOOL	WriteFnKeysInfo (BYTE *filename, KeyExpansionType *keylist);


/* Converts Control id in KBD map dialog to unshifted scan code */
BYTE	CtrlIdToScan[] = { 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40, 0x41,
	0x42, 0x43, 0x44, 0x57, 0x58, 0x0E, 0x37, 0x4A, 0x0F, 0x47, 0x48,
	0x49, 0x4E, 0x4B, 0x4C, 0x4D, 0x4F, 0x50, 0x51, 0x52, 0x53,
	/* THE REMAINING KEYS FALL INTO THE EXTENDED SECTION */
	0x52, 0x47, 0x49, 0x35, 0x53, 0x4F, 0x51, 0x48, 0x4B, 0x50,
	0x4D, 0x1C
};

BYTE GlobalKbdFlags;

/****************************************************************************
	If the key is a number key and numlock is pressed, return false
	if any other programmed key return FALSE
	else return TRUE
*****************************************************************************/
BOOL	IsExpandedKey(WORD wParam, DWORD lParam)
{
	BYTE	scan;
	BYTE	flag;

	scan = (BYTE) (lParam >> 16);
	/* check if number key, if numlock is on number keys are not xlated */
	if ( (scan >= 0x47) && (scan != 0x4A) &&
					(scan != 0x4E) && (scan <= 0x53)) {
		if ( GetKeyState (VK_NUMLOCK))
			return FALSE;
	}
	flag = 0;
	/* get the status of shift key */
	if ( GetKeyState(VK_SHIFT) < 0)
		flag |= FLG_SHIFT;
	/* get the status of control key */
	if (GetKeyState(VK_CONTROL) < 0)
		flag |= FLG_CONTROL;
	/* get the extened key status */
	if (lParam & (long)0x1000000)
		flag |= FLG_EXTENDED;
	/* Send the key out if expanded and return, else call default proc */
	if (IsProgrammed(scan, flag))
		return TRUE;
	return FALSE;
}
/*--------------------------------------------------------------------------*/
/*	Name		:	GetExpansion											*/
/*	Input		:	info, ascii and scan code of the key.					*/
/*	Output		:	pointer to expansion str if any, else null.				*/
/*	Synopsis	:	This routine checks if the key is to expanded, and if	*/
/*						so, returns a pointer to the expansion, else null.	*/
/*--------------------------------------------------------------------------*/
BYTE	*GetExpansion(WORD info, KeyExpansionType *exp_list)
{
	KeyExpansionType		*tmpptr = exp_list;

	while(tmpptr) {
		if (tmpptr->Key == info)
			return tmpptr->Expansion;
		tmpptr = tmpptr->Next;
	}
	return NULL;
}

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	Called during WM_KEYDOWN message form wstdio only.
---------------------------------------------------------------------------*/
BOOL	SendIfProgrammed(BYTE scan, BYTE flags)
{
	BYTE	*ptr;
	WORD	scanascii;

	scanascii = GetScanAscii(scan, flags);

	if (ptr = GetExpansion(scanascii, KeyExpansion)) {
//		ExpandAndXmit(ptr);
		return TRUE;
	}
	return FALSE;
}

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	
---------------------------------------------------------------------------*/
BOOL	IsProgrammed(BYTE scan, BYTE flags)
{
	BYTE	*ptr;
	WORD	scanascii;

	scanascii = GetScanAscii(scan, flags);
	if (ptr = GetExpansion(scanascii, KeyExpansion))
		return TRUE;
	return FALSE;
}

/*---------------------------------------------------------------------------
 Function	:	PurgeExpList
 Inputs		:	None
 Outputs	:	None
 Synopsis	:	Demolish key list used for the key mapping.
---------------------------------------------------------------------------*/
void	PurgeExpList(KeyExpansionType *exp_list)
{
	KeyExpansionType		*tmpptr;

	while(exp_list) {
		tmpptr = exp_list->Next;				/* save ptr to next node */
		MemFree((LPSTR)exp_list->Expansion);	/* Free the expansion mem */
		MemFree((LPSTR)exp_list);				/* Free the node mem */
		exp_list = tmpptr;					/* advance to next node */
	}
}

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	Removes nodes which don't have any expansion list
---------------------------------------------------------------------------*/
KeyExpansionType	*RemoveNullExpansions(KeyExpansionType *exp_list)
{
	KeyExpansionType		*tmpptr, *lastptr;

	tmpptr = lastptr = exp_list;
	while(tmpptr) {
		if (tmpptr->Expansion[0]) {		/* There is an expansion */
			lastptr = tmpptr;			/* make lastptr tmpptr */
			tmpptr = tmpptr->Next;		/* advance tmpptr */
		} else {
			MemFree((LPSTR) tmpptr->Expansion);		/* release mem for exp */
			if (lastptr == tmpptr) {	/* we haven't found non-NULL head yet */
				tmpptr = tmpptr->Next;
				MemFree((LPSTR) lastptr);		/* free the node */
				lastptr = exp_list = tmpptr;
			} else {						/* already head is fixed */
				lastptr->Next = tmpptr->Next;
				MemFree((LPSTR) tmpptr);
				tmpptr = lastptr->Next;
			}
		}
	}
	return exp_list;
}

/*---------------------------------------------------------------------------
 Function	:	RemoveKeyNode()
 Inputs		:	WORD - key value and the list pointer
 Outputs	:	returns the list head pointer. needed since the head itselef
 				may be the node to be removed.
 Synopsis	:	removes a node from list whose Key matches parameter key
---------------------------------------------------------------------------*/
KeyExpansionType *RemoveKeyNode( WORD key, KeyExpansionType *list)
{
	KeyExpansionType	*tmpptr, *lastptr;

	tmpptr = lastptr = list;
	while(tmpptr) {
		if (tmpptr->Key != key) {
			lastptr = tmpptr;
			tmpptr = tmpptr->Next;
		} else {
			MemFree((LPSTR) tmpptr->Expansion);	/* release the Expansion mem */
			if (lastptr == tmpptr)				/* this is first node */
				list = tmpptr->Next;			/* adjust the head */
			else
				lastptr->Next = tmpptr->Next;	/* adjust the link */
			MemFree((LPSTR) tmpptr);				/* release the node mem */
			break;
		}
	}
	return list;		/* no node with the key value found */
}

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	Search the ExpList for the Key. If present
 NOTE		:	Assumes that the expansion string is present in ExpStr and
				The ScanAscii contains the key code.
---------------------------------------------------------------------------*/
void	UpdateExpList(WORD Key, BYTE *ExpStr, KeyExpansionType **ExpList)
{
	KeyExpansionType	*tmpptr = *ExpList;

	while(tmpptr) {
		if (tmpptr->Key == Key) {	/* Key already in TmpList */
			/* Free old memory for expansion */
			MemFree ((LPSTR) tmpptr->Expansion);
			tmpptr->Expansion = NULL;
			break;
		}
		tmpptr = tmpptr->Next;
	}
	if (!tmpptr) {		/* This key is not yet in the TmpExpList */
		/* Get a node */
		if ( ! (tmpptr = (KeyExpansionType *)
						MemAlloc(sizeof (KeyExpansionType))) )
			return;
		
		/* hook it onto the head of the list */
		tmpptr->Key = Key;
		tmpptr->Next = *ExpList;
		*ExpList = tmpptr;
	}
	/* Get memory for the expansion */
	if ( ! (tmpptr->Expansion = (BYTE *)MemAlloc(strlen(ExpStr) + 1)))
		return;

	/* copy the expansion */
	strcpy(tmpptr->Expansion, ExpStr);
}

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	Given scan code and shift, control flags fill scanascii table
---------------------------------------------------------------------------*/
void	FillScanCodes(WORD *base, BYTE scan, BYTE flag)
{
	base[0] = GetScanAscii (scan, (BYTE) (flag | FLG_NORMAL));
	base[1] = GetScanAscii (scan, (BYTE) (flag | FLG_SHIFT));
	base[2] = GetScanAscii (scan, (BYTE) (flag | FLG_CONTROL));
	if (base[0] == base[1])
		base[1] = 0;
}

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	Handle the key map info for the key defined in ScanAscii word.
---------------------------------------------------------------------------*/
int FAR PASCAL
KeyMapEditDlgProc (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
	BYTE	*expptr;
	WORD	code_array[3];
	DWORD	lparam;
	BYTE	i;

	switch (message) {
		case WM_INITDIALOG :
			DLGCenterDialog(hDlg);
			/* Show the name of the key to the user */
			lparam = KeyScan;
			lparam <<= 16;
			if (FlgExt)
				lparam = lparam | LPARAM_EXTEND;
			GetKeyNameText(lparam, (LPSTR) TmpStr, 20);
			SetWindowText( GetDlgItem (hDlg, 1701), TmpStr);

			/* Get the ScanASCII code for normal, shift+ and control+ */
			FillScanCodes(code_array, KeyScan, FlgExt);

			/* Show all the current values to the user */
			for (i = 0; i < 3; i++ ) {
				if (code_array[i] == 0x4400) {		/* F10 is system key */
					SetWindowText( GetDlgItem (hDlg, IDC_KBD_EDT_NORMAL + i), SysKey);
					EnableWindow( GetDlgItem (hDlg, IDC_KBD_EDT_NORMAL + i), FALSE);
					continue;
				}
				if ( !code_array[i]) {	/* no separate program, same as normal */
					SetWindowText( GetDlgItem (hDlg, IDC_KBD_EDT_NORMAL + i), SameProg);
					EnableWindow( GetDlgItem (hDlg, IDC_KBD_EDT_NORMAL + i), FALSE);
					continue;
				}
			 	/* search for the key in tmp exp List first */
			 	expptr = GetExpansion (code_array[i], TmpExpList);
			 	/* if not present in TmpExpList, search Trm Expansion list */
			 	if ( ! expptr)
		 			expptr = GetExpansion(code_array[i], TrmExpList);
			 	/* if found in either case, set the edit window text */
		 		if (expptr)
					SetWindowText( GetDlgItem (hDlg, IDC_KBD_EDT_NORMAL + i), expptr);
				/* store pointer to the strings for later comparison */
				OrgExpn[i] = expptr;
			}
			return TRUE;

		case WM_COMMAND :
			switch (wParam) {

				case IDOK :
				/* Get the Strings one by one and compare with the origs */
				/* Get the ScanASCII code for normal, shift+ and control+ */
				FillScanCodes(code_array, KeyScan, FlgExt);

				/* Show all the current values to the user */
				for (i = 0; i < 3; i++ ) {
					if (! code_array[i])
						continue;
					/* Get the string in the edit box */
					GetDlgItemText(hDlg, IDC_KBD_EDT_NORMAL + i,
												TmpStr, MAX_ACTION_STR);

					/* compare with the string before edit */
					if (strcmp (OrgExpn[i], TmpStr))
						UpdateExpList (code_array[i], TmpStr, &TmpExpList);
				}
				case IDCANCEL :
					EndDialog(hDlg, TRUE);
					return TRUE;
			}
	}
	return FALSE;
}
/*---------------------------------------------------------------------------
 Function	:	FormNewKeyList(void)
 Inputs		:	none
 Outputs	:	none
 Synopsis	:	At the end of a key mode map edit, check in the TmpExpList
 				for possible new mappings and modification of existing ones.
				Rearrange and make a new list
---------------------------------------------------------------------------*/
BOOL	FormNewKeyList(void)
{
	KeyExpansionType	*tmpptr;

	if (!TmpExpList)				/* no keys in the temporary list */
		return FALSE;				/* so old mappings still hold good */
	if (!TrmExpList) {			/* no old mappings */
		TrmExpList = TmpExpList;
		goto clean_exit;
	}
	/* for each node in TmpExpList, search in TrmExpList and remove
	if present */
	for (tmpptr = TmpExpList; tmpptr; tmpptr = tmpptr->Next)
		TrmExpList = RemoveKeyNode(tmpptr->Key, TrmExpList);

	/* if TrmExpList is still not NULL append to it TmpExpList */
	if (TrmExpList) {
		tmpptr = TrmExpList;
		while(tmpptr->Next)
			tmpptr = tmpptr->Next;
		tmpptr->Next = TmpExpList;
	} else {	/* else TmpExpList becomes ExpList */
		TrmExpList = TmpExpList;
	}
clean_exit:
	/* before exiting remove the NULL expansions */
	TrmExpList = RemoveNullExpansions(TrmExpList);
	TmpExpList = NULL;		/* to avoid accidental release of nodes */
	return TRUE;
}

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	Display the current program info in the kbd dialog (static)
---------------------------------------------------------------------------*/
void	StaticDispKeyProg (HWND hDlg, BYTE scan, BYTE flag)
{
	DWORD	lprm;
	BYTE	*expptr;
	WORD	code_array[3];
	BYTE	i;

	/* set the Key Name */
	lprm = (DWORD) scan;
	lprm <<= 16;
	if (flag & FLG_EXTENDED)
		lprm = lprm | LPARAM_EXTEND;	/* set extend bit mask in lParam */
	GetKeyNameText(lprm, (LPSTR) TmpStr, 20);
	SetWindowText( GetDlgItem (hDlg, 147), TmpStr);

	FillScanCodes(code_array, scan, flag);

	/* Set the normal, shift+ and control+ program info */
	for (i = 0; i < 3; i++) {
		if ( !code_array[i]) {	/* no separate program, same as normal */
			SetWindowText( GetDlgItem (hDlg, 148 + i), SameProg);
			continue;
		}
	 	/* search for the key in the TmpExpList first */
	 	expptr = GetExpansion (code_array[i], TmpExpList);
	 	/* if not present in TmpExpList, search TrmExpList */
	 	if ( ! expptr)
 			expptr = GetExpansion(code_array[i], TrmExpList);
	 	/* set the static display text */
		if (expptr)
			SetWindowText( GetDlgItem (hDlg, 148 + i), expptr);
		else
			SetWindowText( GetDlgItem (hDlg, 148 + i), "");
	}
}

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	Double click checking timer.
---------------------------------------------------------------------------*/
void CALLBACK
DblClickTimerProc (HWND hWnd, WORD wMsg, int ID, DWORD dwTime)
{
	KillTimer(NULL, DblClickTimerId);
	DblClickTimerId = 0;
	CheckingDblClick = FALSE;
}

#define		CURFILE_NAME	((BYTE *) (TrmList + CurTrmIdx))

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	list all trm files, readin the key info for current trm.
 				allow display and editing of keys
---------------------------------------------------------------------------*/
int FAR PASCAL
KbdMapDlgProc (HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
	FARPROC	lpDlgFn;
	BYTE	indx;

	switch (message) {

		case WM_INITDIALOG :
			DLGCenterDialog(hDlg);
			CurTrmIdx = MapChanged = 0;
			TrmExpList = TmpExpList = NULL;
			CheckingDblClick = 0;
			DblClickTimerId = 0;

			/* Show the terminal list */
			if (TrmList) {					/* there is some trm file */
				for ( indx = 0; *(BYTE *) (TrmList + indx); indx++) {
					if ( ! strcmp (PbkEntry.TrmParams.TermName, 
										(BYTE *)(TrmList + indx)))
						CurTrmIdx = indx;
					SendDlgItemMessage (hDlg, IDC_KBD_LST_TERM,
							LB_ADDSTRING, NULL, (DWORD)(LPSTR)(TrmList + indx));
				}
				SendDlgItemMessage (hDlg, IDC_KBD_LST_TERM,
									LB_SETCURSEL, CurTrmIdx, (DWORD)NULL);
			} else {
				MessageBeep(0);
				EndDialog(hDlg, FALSE);
				return TRUE;
			}
			lpDblClickTimerProc = MakeProcInstance (DblClickTimerProc, hInst);
//			TrmExpList = ReadInKeyExpansion(hDlg, CURFILE_NAME);
			KeyScan = CtrlIdToScan[0];
			FlgExt = 0;
			StaticDispKeyProg(hDlg, KeyScan, FlgExt);
			return TRUE;

		case WM_COMMAND :
			switch (wParam) {
				default :			/* general processor */
					if (HIWORD(lParam != BN_CLICKED))
						return FALSE;
					if ((wParam < PROG_START_INDX) ||
							(wParam > PROG_END_INDX)) 		/* not pgmable */
						return FALSE;

					indx = (BYTE) (wParam - PROG_START_INDX);
					FlgExt = (wParam >= EXTD_START_INDX) ?
										(BYTE) FLG_EXTENDED : (BYTE) 0;
					KeyScan = CtrlIdToScan[indx];
					if (!CheckingDblClick) {
						StaticDispKeyProg (hDlg, KeyScan, FlgExt);
						CheckingDblClick = TRUE;
						DblClickTimerId = SetTimer(NULL, NULL, 400,
							lpDblClickTimerProc);
					} else {
						CheckingDblClick = FALSE;
						if (DblClickTimerId) {
							KillTimer(0, DblClickTimerId);
							DblClickTimerId = 0;
						}
						/* allow the user to program the key */
						lpDlgFn = MakeProcInstance (KeyMapEditDlgProc, hInst);
						DialogBox(hInst, "KBDEDITDLG", hDlg, lpDlgFn);
						FreeProcInstance (lpDlgFn);
						StaticDispKeyProg (hDlg, KeyScan, FlgExt);
					}
					return TRUE;
#if 0
				case IDC_RESET :		/* destroy all mappings */
					LoadString(hInst, 299, TmpStr, 128);
					if (DispMsgBox(hDlg, MSG_KBD_CLR_MAP,
										TmpStr, MB_YESNO) == IDNO)
						break;
					if (TrmExpList) {
						MapChanged = TRUE;
						PurgeExpList(TrmExpList);
						TrmExpList = NULL;
					}
					PurgeExpList(TmpExpList);
					TmpExpList = NULL;
					break;
#endif
				case IDOK:					/* Id for OK push button */
					/* merge the two key lists and form the new list */
					if ( FormNewKeyList() || MapChanged ) {
						LoadString(hInst, 299, TmpStr, 128);
						if (DispMsgBox_s(hDlg, MSG_KBD_QSAVE, TmpStr,
										CURFILE_NAME, MB_YESNO)==IDYES)
							if (!WriteFnKeysInfo(CURFILE_NAME, TrmExpList)) {
								LoadString(hInst, MSG_KBD_ER_SAVE,
															TmpStr, 128);
								ShowMesg(TmpStr);
							}
					}
					if ( ! strcmp(PbkEntry.TrmParams.TermName, CURFILE_NAME)) {
						PurgeExpList(KeyExpansion);
						KeyExpansion = TrmExpList;
					} else {
						PurgeExpList(TrmExpList);
					}
					if (DblClickTimerId)
						KillTimer(NULL, DblClickTimerId);
					FreeProcInstance(lpDblClickTimerProc);
					EndDialog(hDlg, TRUE);
					return TRUE;

				case IDCANCEL:
					/* destroy the temporary key list */
					PurgeExpList(TmpExpList);
					PurgeExpList(TrmExpList);

					/* Id for cancel push button */
					if (DblClickTimerId)
						KillTimer(NULL, DblClickTimerId);
					FreeProcInstance(lpDblClickTimerProc);
					EndDialog(hDlg, FALSE);
					return TRUE;

				case IDC_KBD_LST_TERM:			/* terminal list box */
					if (HIWORD(lParam) != LBN_SELCHANGE)
						break;
					indx = (BYTE)SendDlgItemMessage (hDlg, IDC_KBD_LST_TERM,
								LB_GETCURSEL, (WORD)NULL, (DWORD)NULL );
					/* if index same of error in indx return TRUE */
					if ((indx == LB_ERR) || (indx == CurTrmIdx))
						break;
					/* if current mapping changed query save */
					if ( FormNewKeyList() || MapChanged ) {
						LoadString(hInst, 299, TmpStr, 128);
						if (DispMsgBox_s(hDlg, MSG_KBD_QSAVE, TmpStr,
										CURFILE_NAME, MB_YESNO)==IDYES)
							if (! WriteFnKeysInfo(CURFILE_NAME, TrmExpList)) {
								LoadString(hInst, MSG_KBD_ER_SAVE,
															TmpStr, 128);
								ShowMesg(TmpStr);
							}
					}
					/* if current cur terminal is same as session's change KeyExpansion */
					if ( ! strcmp(PbkEntry.TrmParams.TermName, CURFILE_NAME)) {
						PurgeExpList(KeyExpansion);
						KeyExpansion = TrmExpList;
					} else {
						PurgeExpList(TrmExpList);
					}
					CurTrmIdx = indx;
//					TrmExpList = ReadInKeyExpansion(hDlg, CURFILE_NAME);
					KeyScan = CtrlIdToScan[0];
					FlgExt = 0;
					StaticDispKeyProg(hDlg, KeyScan, FlgExt);
					return TRUE;
			}
	}
	return FALSE;
}

/*#########################################################################
The following code is for getting the scan-ascii for the given scan and
flags. Only the function GetScanAscii(scan, flags) needs to be called
from outside routines. 
##########################################################################*/

/* WARNING - CHANGES HERE SHOULD BE REFLECTED IN MISC.C ALSO */

BYTE	ScanCodesArray[] = { 0x0E, 0x0F, /* 0x1C, */ 0x37, 0x3B, 0x3C, 0x3D,
	0x3E, 0x3F, 0x40, 0x41, 0x42, 0x43, 0x44, 0x47, 0x48, 0x49, 0x4A, 0x4B,
	0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x57, 0x58 };

BYTE	ExtScanCodesArray[] = { 0x1C, 0x35, 0x47, 0x48, 0x49, 0x4B, 0x4D,
	0x4F, 0x50, 0x51, 0x52, 0x53 };

int		NumMappedKeys = (sizeof (ScanCodesArray) / sizeof (BYTE));
int		ExtNumMappedKeys = (sizeof (ExtScanCodesArray) / sizeof (BYTE));

/* Scan to ASCII convertion Tables (SATs) */
/* Tables 1. converts scan to unshifted scan-ascii code */
WORD	NormSAT[] = { 0x0E08, 0x0F09, /* 0x1C0D, */ 0x372A, 0x3B00,
	0x3C00, 0x3D00, 0x3E00, 0x3F00, 0x4000, 0x4100, 0x4200, 0x4300,
	0x4400, 0x4700, 0x4800, 0x4900, 0x4A2D, 0x4B00, 0x4C00, 0x4D00,
	0x4E2B, 0x4F00, 0x5000, 0x5100, 0x5200, 0x5300, 0x8500, 0x8600 };

WORD	ExtNormSAT[] = { 0xE00D, 0xE02F, 0x47E0, 0x48E0, 0x49E0, 0x4BE0,
	0x4DE0, 0x4FE0, 0x50E0, 0x51E0, 0x52E0, 0x53E0 };

/* Tables 2. converts scan to shifted scan-ascii code */
WORD	ShiftSAT[] = { 0x0E08, 0x0F00, /* 0x1C0D, */ 0x372A, 0x5400,
	0x5500, 0x5600, 0x5700, 0x5800, 0x5900, 0x5A00, 0x5B00, 0x5C00,
	0x5D00, 0x4737, 0x4838, 0x4939, 0x4A2D, 0x4B34, 0x4C35, 0x4D36,
	0x4E2B, 0x4F31, 0x5032, 0x5133, 0x5230, 0x532E, 0x8700, 0x8800 };

/* Tables 3. converts scan to control+ scan-ascii code */
WORD	CtrlSAT[] = { 0x0E7F, 0x9400, /* 0x1C0D, */ 0x9600, 0x5E00,
	0x5F00, 0x6000, 0x6100, 0x6200, 0x6300, 0x6400, 0x6500, 0x6600,
	0x6700, 0x7700, 0x8D00, 0x8400, 0x8E00, 0x7300, 0x8F00, 0x7400,
	0x9000, 0x7500, 0x9100, 0x7600, 0x9200, 0x9300, 0x8900, 0x8A00 };

WORD	ExtCtrlSAT[] = { 0xE00A, 0x9500, 0x77E0, 0x8DE0, 0x84E0, 0x73E0,
	0x74E0, 0x75E0, 0x91E0, 0x76E0, 0x92E0, 0x93E0 };

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	
---------------------------------------------------------------------------*/
int		CompareRoutine (BYTE *elm1, BYTE *elm2)
{
	if (*elm1 < *elm2)
		return -1;
	if (*elm1 > *elm2)
		return 1;
	return 0;
}

/****************************************************************************
 *	Synopsis	:	Given the non-extened scan code, search in ScanCodesArray
 *					for this, return this index if present else return 0xFF
 ***************************************************************************/
BYTE	GetScanCodeIndex(BYTE scan)
{
	BYTE	*indx_ptr;

	indx_ptr = bsearch((void const *) &scan, (void const *)ScanCodesArray,
			(WORD) NumMappedKeys, (WORD) sizeof(BYTE), CompareRoutine);
	if (indx_ptr)
		return ((BYTE) (indx_ptr - ScanCodesArray));
	
	return 0xFF;
}

/****************************************************************************
 *	Synopsis	:	Given the extened scan code, search in ExtScanCodesArray
 *					for this, return this index if present else return 0xFF
 ***************************************************************************/
BYTE	GetExtScanCodeIndex(BYTE scan)
{
	BYTE	*indx_ptr;

	indx_ptr = bsearch((void const *) &scan, (void const *)ExtScanCodesArray,
			(WORD) ExtNumMappedKeys, (WORD) sizeof(BYTE), CompareRoutine);

	if (indx_ptr)
		return ((BYTE) (indx_ptr - ExtScanCodesArray));
	
	return 0xFF;
}

/****************************************************************************
 *	synop	:	routine which returns the scan-ascii value of extended keys
 **************************************************************************/
WORD	GetExtScanAscii(BYTE scan, BYTE flags)
{
	BYTE	scan_code_idx;

	if ((scan_code_idx = GetExtScanCodeIndex(scan)) == 0xFF) /* means no mapping */
		return 0;

	if (flags & FLG_CONTROL)
		return ExtCtrlSAT[scan_code_idx];

	/* For Extended keys the scan ascii is same for shifted and normal */
	return ExtNormSAT[scan_code_idx];
}

/***************************************************************************
 *	input	:	scan code, shift, control and extened flags
 *	return	:	scan ascii code in trm format
 *	synop	:	if extended falg is set pass to GetExtScanAscii routine, else
 *				get the index into the corresponding SAT(Scan ascii table).
 *				if noentry this key is not mappable, return 0. else depending
 *				on the status of shift, control flags return the SAT value
 **************************************************************************/
WORD	GetScanAscii (BYTE scan, BYTE flags)
{
	BYTE	scan_code_idx;

	if (flags & FLG_EXTENDED)
		return GetExtScanAscii(scan, flags);
	if ((scan_code_idx = GetScanCodeIndex(scan)) == 0xFF) /* means no mapping */
		return 0;

	if (flags & FLG_CONTROL)
		return CtrlSAT[scan_code_idx];
	if (flags & FLG_SHIFT)
		return ShiftSAT[scan_code_idx];
	return NormSAT[scan_code_idx];
}

/*---------------------------------------------------------------------------
 Function	:	
 Inputs		:	
 Outputs	:	
 Synopsis	:	Reads key expansion from "filename", makes TrmExpList.
---------------------------------------------------------------------------*/
KeyExpansionType	*ReadInKeyExpansion(HWND hDlg, BYTE *filename)
{
	return NULL;
}
