/****************************************************************************
*	File		:	kbd.h
*	Purpose		:	keboard remapping of keys
*	Package		:	MultiExpress (Windows) - Version 1.00
*	Authors		:	Vidy
*	Date		:	
****************************************************************************/

#define		FLG_NORMAL		0x00	/* key pressed without shift or control */
#define		FLG_LSHIFT		0x01	/* key pressed with left or right shift */
#define		FLG_RSHIFT		0x02
#define		FLG_SHIFT		(FLG_LSHIFT | FLG_RSHIFT)
#define		FLG_CONTROL		0x04	/* key pressed with control */
#define		FLG_EXTENDED	0x10	/* key is an extended key */
#define		SAT_NO_MAP		0		/* This key is can't be mapped */

#define		PROG_START_INDX	100		/* control id of first programmable key */
#define		EXTD_START_INDX	128		/* start of extened programmable keys */
#define		PROG_END_INDX	139		/* control id of last programmable key */
#define		LPARAM_EXTEND	0x01000000L		/* extend bit in lParam */

#define		SCAN_LSHIFT		0x2A
#define		SCAN_RSHIFT		0x36
#define		SCAN_CONTROL	0x1D

extern	BYTE	ScanCodesArray[];

/* control ids for the various dlg items */
#define		IDC_KBD_STAT_NAME		1700

#define		IDC_KBD_EDT_NORMAL		1400
#define		IDC_KBD_LST_TERM		1500

extern	BOOL	IsExpandedKey(WORD wParam, DWORD lParam);
extern	BOOL	IsProgrammed(BYTE scan, BYTE flags);
extern	WORD	GetScanAscii (BYTE ScanCode, BYTE flags);
extern	BYTE	*GetExpansion(WORD info, KeyExpansionType *exp_list);
extern	BOOL	SendIfProgrammed(BYTE scan, BYTE flags);
extern	void	ResetKeys(HWND hDlg);
extern	void	PurgeExpList(KeyExpansionType *exp_list);
extern	KeyExpansionType *RemoveNullExpansions(KeyExpansionType *exp_list);
extern	KeyExpansionType *RemoveKeyNode( WORD key, KeyExpansionType *list);
extern	void	UpdateExpList(WORD Key, BYTE *Expstr, KeyExpansionType **List);
extern	BOOL	FormNewKeyList(void);
extern	int		FAR PASCAL
	KeyMapEditDlgProc (HWND hDlg, unsigned message, WORD wParam, LONG lParam);
extern	int 	FAR PASCAL
	KbdMapDlgProc (HWND hDlg, unsigned message, WORD wParam, LONG lParam);
extern	void *bsearch(void const *ptr, void const *ScanCodesArray,
			WORD NumMappedKeys, WORD size,int (* CompareRoutine)());
extern	KeyExpansionType	*ReadInKeyExpansion(HWND hDlg, BYTE *filename);

