/***************************************************************************
	file	:	looks.h
	parameters which defines the looks of MEW
***************************************************************************/

#define		KEY_VERT_CLEARANCE		2
#define		KEY_HORZ_CLEARANCE		2
#define		KEY_HEIGHT				2
#define		KEY_STR_BORDER			1
#define		KEY_X_VERT				( (KEY_VERT_CLEARANCE + KEY_HEIGHT ) * 2)

#define		EXE_NAME_MAX_SIZE		128
#define		KEY_MARGIN				4
#define		TRM_SHADE				1
#define		TRM_IN_SHADE			2

#define		TB_HORZ_START			10
#define		TB_VERT_START			1
#define		TBB_X_SIZE				32
#define		TBB_Y_SIZE				32
#define		TBB_X_SHIFT				(TBB_X_SIZE + 1)
#define		TBAR_HEIGHT				(TBB_X_SIZE+ 5)

#define		IDTB_BASE				300
/* button selection macro */
#define TBBUTTONINDEX(x)	(x - IDTB_BASE)
#define TBBUTTON(x)	ghTBButtons[TBBUTTONINDEX(x)]

extern	HWND	ghTBButtons[];
extern	HWND	hSigWnd;
extern	HWND	hDtrtsWnd;

/* tool bar indices */
#define		IDTB_LOG					(IDTB_BASE + 0)
#define		IDTB_SCROLL				(IDTB_BASE + 1)
#define		IDTB_PRINT				(IDTB_BASE + 2)
#define		IDTB_CONFIG				(IDTB_BASE + 3)
#define		IDTB_FONTS				(IDTB_BASE + 4)
#define		IDTB_COLOR				(IDTB_BASE + 5)

#define		IDTB_SIG_WND			(IDTB_BASE + 50 - 1)

#define		NUM_OF_TBBUTTONS		6

/* the resourceIds for bmps */
#define		IDRN_LOG					200
#define		IDRD_LOG					201
#define		IDRG_LOG					202
#define		IDRN_ALT_LOG			203
#define		IDRD_ALT_LOG			204
#define		IDRG_ALT_LOG			205

#define		IDRN_SCROLL				210		/* oops!! 6 state button */
#define		IDRD_SCROLL				211
#define		IDRG_SCROLL				212
#define		IDRN_ALT_SCROLL		213
#define		IDRD_ALT_SCROLL		214
#define		IDRG_ALT_SCROLL		215

#define		IDRN_PRINT				220
#define		IDRD_PRINT				221
#define		IDRG_PRINT				222
#define		IDRN_ALT_PRINT			223
#define		IDRD_ALT_PRINT			224
#define		IDRG_ALT_PRINT			225

#define		IDRN_CONFIG				230
#define		IDRD_CONFIG				231
#define		IDRG_CONFIG				232

#define		IDRN_FONTS				240
#define		IDRD_FONTS				241
#define		IDRG_FONTS				242

#define		IDRN_COLOR				250
#define		IDRD_COLOR				251
#define		IDRG_COLOR				252

#define		IDRN_SIG_WIN			502
#define		IDRG_SIG_WIN			503

#define		IDR_SIG_ON				504
#define		IDR_SIG_OFF				505
#define		IDF_SIG_GRAY			506

extern	HPEN		hOldPen;				// old pen handle
extern	HPEN		hNullPen;  				// null pen handle
extern	HPEN		hBlackPen;				// black pen handle
extern	HPEN		hWhitePen;	  			// white pen handle
extern	HPEN		hLightGreyPen;			// light grey pen handle
extern	HPEN		hGreyPen;				// grey pen handle
extern	HPEN		hHatchPen;				// black and white hatch pen handle

extern	HBRUSH		hOldBrush;				// old brush handle
extern	HBRUSH		hBlackBrush;			// black brush handle
extern	HBRUSH		hWhiteBrush;			// white brush handle
extern	HBRUSH		hLightGreyBrush;		// light grey brush handle
extern	HBRUSH		hGreyBrush;				// grey brush handle
extern	HBRUSH		hGrBlBrush;				// grey brush handle

extern	long FAR PASCAL	SigWndProc (HWND hWnd,
					unsigned message, WORD wParam, LONG lParam);
extern	long FAR PASCAL	TbarWndProc (HWND hWnd,
					unsigned message, WORD wParam, LONG lParam);
extern	long FAR PASCAL	DragWndProc (HWND hWnd,
					unsigned message, WORD wParam, LONG lParam);
extern	void	RegisterDragClass(void);
extern	void	RegisterSigWndClass(void);
extern	void	tbCreateSigWnd(void);
extern	int		CreateTbarWnd (HWND hParentWnd);
extern	void	tbCreateUpldDropWin(void);
extern	void	tbCreateToolbar (void);
extern	void	tbCreateToolbarButton (int Button, int x, int y);
extern	void	tbEnableToolbarButton (int Button);
extern	void	tbDisableToolbarButton (int Button);
extern	void	tbUpdateToolbarButton(int	button);
extern	void	tbUpdateToolbar(void);
extern	void	tbShowToolbar(void);
extern	void	tbHideToolbar(void);
extern	void	tbShowHideToolbar(BOOL Enable, int Show);
extern	void	tbShowHideButton(int Button, BOOL Enable, int Show);
extern	int		tbDrawControl(HWND hWnd, LPDRAWITEMSTRUCT lpInfo);
extern	void	CreateBrushesAndPens(void);
extern	void	DeleteBrushesAndPens(void);
extern	void	DrawPushButton(HDC hDc, LPRECT rect, LPSTR str,
					BOOL button_up, BOOL horiz_center, BOOL button_type);
extern	void	DrawPushButtonUp(HDC hDc, LPRECT rect, LPSTR str);
extern	void	DrawPushButtonDn(HDC hDc, LPRECT rect, LPSTR str);
extern	void	DrawStatusWin(HDC hDc, LPRECT rect, LPSTR str);
extern	void	DisplayQHelp(HDC hDc, LPRECT rect, LPSTR str);
extern	void	DrawStatusWinText(HDC hDc, LPRECT rect, LPSTR str, BOOL EraseBk);
extern	void	GetMEWPathName( LPSTR szFileName);
extern	void	MakeHelpPathName(void);
extern	void	ClearTermBorder(HDC hDc);
/******************************   Last  Line   *****************************/
