/****************************************************************************
 * Filename   : main.c
 * Purpose    : This file contains the functions to create the MultiExpress
 *				windows and process the messages received by the main window.
****************************************************************************/

#include <windows.h>
#include	<commdlg.h>
#include <dde.h>

#include "mew.h"
#include "main.h"
#include	"session.h"
#include "term.h"
#include "fnkey.h"
#include "time.h"
#include	"file.h"
#include "status.h"
#include	"wstdio.h"
#include	"emlncons.h"
#include	"emlntype.h"
#include	"emlndata.h"
#include	"emlnfuns.h"
#include	"config.h"
#include	"scroll.h"
#include	"fonts.h"
#include	"myprint.h"
#include	"select.h"
#include	"selcopy.h"
#include	"kbd.h"
#include	"mewlog.h"
#include	"looks.h"
#include	"clrsetup.h"
#include	"dlgbox.h"
#include	"search.h"
#include	"ctl3d.h"
#include	"resource.h"

HANDLE	hInst = NULL;					/* application instance handle */
HWND	hMainWnd = NULL;		/* main window handle */
HWND	hTermWnd = NULL;		/* terminal window handle */
HWND	hTbarWnd = NULL;		/* Tbar window handle */
HWND	hStatusWnd = NULL;		/* status bar window handle */
HWND	hTimeWnd = NULL;		/* time bar window handle */
HANDLE	hMewAccTable;			/* accelerator table handle */
HANDLE	hMewScrlAccTable;			/* accelerator table handle */
HWND	hConfigWnd;				// Configuration window's handle

HCURSOR	hCurCursor;			/* current cursor */
HCURSOR	hSaveCursor;		/* save cursor */
HCURSOR	hStandard;			/* standard arrow cursor */
HCURSOR	hHourGlass;			/* hour glass cursor */
HCURSOR	hCross;				/* crosshair cursor for cut&paste */
HCURSOR hIBeam;				/* I-beam cursor in Terminal window */
HCURSOR hDrop;				/* */
HCURSOR hFinger;				/* */

RECT	MainWndRect;			/* main window dimensions */
RECT	TermWndRect;			/* terminal window dimensions */
RECT	TbarWndRect;			/* Tbar window dimensions */
RECT	StatusWndRect;			/* status bar window dimensions */
RECT	TimeWndRect;			/* time bar window dimensions */
RECT	MainDim;				/* complete main window dimensions */
char	LoadPath[128];

BOOL	ShowStatusWnd = TRUE;	/* show or hide status bar */
BOOL	ShowTimeWnd = TRUE;		/* show or hide time bar */
BOOL	ShowTbarWnd = TRUE;		/* show or hide Tbar window */
BOOL	ShowLogo = FALSE;		/* display logo or not */
BOOL	LogoTimer = TRUE;		/* logo timer active */
WORD	CurState = 0;			/* current state of the session */
BOOL	MuxSendResetSequence = FALSE;	/* ATRZ was sent by router */

BOOL	InMenu = FALSE;			/* whether currently in menu selection */
BOOL	Iconified = FALSE;		/* main window has been iconified */
BOOL	ConsoleHasFocus = TRUE;

BOOL	HelpFlag = FALSE;		/* global flag used in help */
int	WANChatPortSelected;
int	SelectedPort = -1 ;
int	SinglePortRouter;		//Vidy 29/12/96
BOOL	RebootAtEnd = TRUE;

COLORREF	ColorTable[MAX_COLORS];		/* some of the standard colors table */
extern	void	CreateBrushesAndPens(void);
extern	void	OpenSavePbkDlg(HWND hWnd);

#define	MAIN_MIN_X_SIZE		80
#define	MAIN_MIN_Y_SIZE		100

extern	long FAR PASCAL	DtrtsWndProc (HWND hWnd,
					unsigned message, WORD wParam, LONG lParam);
int	CommandLineArgument;

int	FAR *LineHdlPtr;
BOOL IsPortIP ;
int number_of_ports;

#define	LOGO_TIMER_ID		50
#define	LOGO_DISP_PERIOD	1


typedef	struct {
	WORD	MenuID;
	WORD	State;
} MenuItemType;

MenuItemType	MenuArr[] = {
	{ IDM_FILE_PAGESET, MF_GRAYED},
	{ IDM_FILE_PRINTERSET, MF_GRAYED},
	{ IDM_FILE_PRINT	, MF_GRAYED},
	{ IDM_FILE_EXIT	, MF_GRAYED},

	{ IDM_EDIT_BUFFTOCLIP, MF_GRAYED},
	{ IDM_EDIT_BUFFTOFILE, MF_GRAYED},
	{ IDM_EDIT_BUFFTOPRNT, MF_GRAYED},
	{ IDM_EDIT_SCROLL, MF_GRAYED},

	{ IDM_SET_FONTS	, MF_GRAYED},
	{ IDM_SET_COLOR	, MF_GRAYED},

	{ IDM_PER_RESET	, MF_GRAYED},
	{ IDM_PER_LOG		, MF_GRAYED},

	{ IDM_WIN_SETUP	, MF_GRAYED},
	{ IDM_WIN_TOP		, MF_GRAYED},
	{ IDM_WIN_BOT		, MF_GRAYED},
	{ IDM_WIN_TBAR		, MF_GRAYED},

	{ IDM_WANTALK_1	, MF_GRAYED},
	{ IDM_WANTALK_2	, MF_GRAYED},
	{ IDM_WANTALK_3	, MF_GRAYED},
	{ IDM_SET_DTR		, MF_GRAYED},
	{ IDM_RESET_DTR	, MF_GRAYED},
	{ IDM_INTERRUPT_PROCESS, MF_GRAYED},
	{ IDM_ABORT_OUTPUT, MF_GRAYED},
};
#define	NUM_MENU_ITEMS	(sizeof(MenuArr)/sizeof(MenuItemType))

#define	IDX_FILE_PAGESET			0
#define	IDX_FILE_PRINTERSET		1
#define	IDX_FILE_PRINT				2
#define	IDX_FILE_EXIT				3

#define	IDX_EDIT_BUFFTOCLIP		4
#define	IDX_EDIT_BUFFTOFILE		5
#define	IDX_EDIT_BUFFTOPRNT		6
#define	IDX_EDIT_SCROLL			7

#define	IDX_SET_FONTS				8
#define	IDX_SET_COLOR				9

#define	IDX_PER_RESET				10
#define	IDX_PER_LOG					11

#define	IDX_WIN_SETUP				12
#define	IDX_WIN_TOP					13
#define	IDX_WIN_BOT					14
#define	IDX_WIN_TBAR				15

#define	IDX_WIN_WANTALK1			16
#define	IDX_WIN_WANTALK2			17
#define	IDX_WIN_WANTALK3			18
#define	IDX_SET_DTR					19
#define	IDX_RESET_DTR				20
#define	IDX_TELNET_INTERRUPT_PROCESS 21
#define	IDX_TELNET_ABORT_OUTPUT 22


BOOL FAR PASCAL
WANChatPortDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BYTE	*NoPortSelectedMsg = "\n\n\rTo Setup a WAN device, you must select \
the port \n\ron which it is connected (use `WANTalk' Menu')\n\n\n\r";


int FAR PASCAL TermInitTerminal (HWND hCnfWnd, LPSTR ldpath,
		int FAR *idComDevPtr, int CLArgument, int ports)
{
	number_of_ports = ports;
	hConfigWnd = hCnfWnd ;
	lstrcpy (LoadPath, ldpath) ;

	LineHdlPtr = idComDevPtr ;		// store this pointer for COM writes

	//Sachin : To identify the port type
	if (*LineHdlPtr == -1)
		IsPortIP = TRUE ;
	else
		IsPortIP = FALSE ;
	SelectedPort = -1 ;

	CommandLineArgument = CLArgument;

	InitColorTable() ;			/* init the global color table */
	CreateBrushesAndPens() ;		/* colors are needed before reg classes */
	InitDefaultConfig() ;		/* initialise default config info */
	ReadSystemInfo() ;			/* read the system defaults from WIN.INI */

//	if ((MainDim.right - MainDim.left <= MAIN_MIN_X_SIZE) ||
//				(MainDim.bottom - MainDim.top <= MAIN_MIN_Y_SIZE))
//		MainDim.right = 0;		/* Force maximum size */

	if ((MainDim.left == 0) && (MainDim.top == 0)
			&& (MainDim.right == 0) && (MainDim.bottom == 0))
	{
		MainDim.right = GetSystemMetrics (SM_CXSCREEN) ;
		MainDim.bottom = GetSystemMetrics (SM_CYSCREEN) ; 
	}
	
	/* create the app. window */
	LoadString (hInst, 299, TmpStr, 128) ;

	hMainWnd = CreateWindow ("ROUTRM",
			 				TmpStr,
			 				WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN |
									WS_BORDER,
			 				(MainDim.right ? MainDim.left : CW_USEDEFAULT),
			 				(MainDim.right ? MainDim.top : CW_USEDEFAULT),
			 				(MainDim.right ? MainDim.right : CW_USEDEFAULT),
			 				(MainDim.right ? MainDim.bottom : CW_USEDEFAULT),
			 				(HWND) NULL,
			 				NULL,
			 				hInst,
			 				(LPSTR) NULL
						) ;

	if (!hMainWnd)
		return 0 ;

	// We need to hide the window in here and later in SetFocus we will
	// show the window

	ShowWindow (hMainWnd, SW_HIDE) ;				// we will hide this for now
	ConsoleHasFocus = FALSE ;

	ComputeWinDimensions (hMainWnd) ; /* compute all other window dimensions */
	UpdateWindow (hMainWnd) ;

	SetTimer (hMainWnd, LOGO_TIMER_ID, LOGO_DISP_PERIOD, NULL) ;
	hCurCursor = hStandard ;	/* reset the cursor to standard one */
	SetCursor (hCurCursor) ;
	return 1 ;
}

int FAR PASCAL	TermCloseTerminal (void)
{
	if (!hMainWnd)
		return FALSE ;
	hConfigWnd = NULL ;			// make it NULL for Exit Function not to send
	ExitFunctions (hMainWnd) ;
//	SendMessage(hMainWnd, WM_DESTROY, NULL, NULL);
	if (hMainWnd)
	{
		DestroyWindow (hMainWnd) ;	// a destroy message as we are called now
		hMainWnd = NULL ;
	}
	return TRUE ;
}

int FAR PASCAL	TermEmulation(char FAR *Buffer, int count)
{
	BYTE	FAR *CharPtr;
	int	idx;

	if ( ! hTermWnd || IN_SCROLL || ! count)
		return 0;
	if (CommandLineArgument == 4 || CommandLineArgument == 5)
	{
		for (CharPtr = Buffer, idx = 0; idx < count; idx++, CharPtr++)
		{
			if (CheckExitSequence(*CharPtr))
			{
				MuxSendResetSequence = TRUE;	/* ATRZ was sent by router */
				TermCloseTerminal();
				PostQuitMessage(0);
				return 0;
			}
		}
	}
	Emulation(Buffer, count);
	return 1;
}

int FAR PASCAL TermSetFocusTerminal (void)
{
	if ((!hMainWnd) || (!hTermWnd))
		return 0 ;
	ShowWindow (hMainWnd, SW_SHOWNORMAL) ;	// take care of ICONified state also
	SetFocus (GetLastActivePopup (hMainWnd)) ;
	ConsoleHasFocus = TRUE ;
	return 1 ;
}
int FAR PASCAL	TermNeedToRebootAtClose(BOOL reboot)
{
	RebootAtEnd = reboot;
}

/****************************************************************************
 * Synopsis   : Creates the main app. window, calls an initialization
 *		 		function and enters the message loop.
 ****************************************************************************/
int FAR PASCAL
LibMain (HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{

	if (!hInst)
		hInst = hInstance;
	else
		return 0;
	
	if (cbHeapSize != 0)
		UnlockData(0);

	/* Register the window classes if this is the first instance of the app. */
	if (!InitInstances (hInstance))
	    	return NULL;

	hStandard = LoadCursor (NULL, IDC_ARROW);
	hHourGlass = LoadCursor (NULL, IDC_WAIT);
	hCross = LoadCursor (NULL, IDC_CROSS);
	hIBeam = LoadCursor (NULL, IDC_IBEAM);
	hDrop = LoadCursor (NULL, IDC_UPARROW);
	hFinger = LoadCursor(hInst, "Finger");

//	hMewAccTable = LoadAccelerators (hInst, "MewAcc");
//	hMewScrlAccTable = LoadAccelerators (hInst, "ScrollAcc");

	return TRUE;
}
/****************************************************************************
 * Function : WEP
 * Synopsis : This is a termination function for the DLL, which performs the
 *			   cleanup before a DLL is unloaded.
 ****************************************************************************/
int FAR PASCAL WEP (int nParam)
{
	if (nParam == WEP_SYSTEM_EXIT) {	/* system shutdown in progress */
		return TRUE;
	}
	else {
		if (nParam == WEP_FREE_DLL) {	/* DLL use count is zero */
			return TRUE;
		}
	}
	return TRUE;
}

/****************************************************************************
 * Function   : InitInstances (hInstance)
 * Synopsis   : Registers the window classes.
 * returns    : TRUE	-  if RegisterClass() went off ok
 *		 		FALSE	-  otherwise.
 ****************************************************************************/
BOOL NEAR PASCAL
InitInstances (HANDLE hInstance)
{
    BOOL     bSuccess;
	WNDCLASS WndClass;				/* window class variable */

	/* register the parent window class */
    WndClass.style			= CS_DBLCLKS;
    WndClass.cbClsExtra		= 0;
    WndClass.cbWndExtra		= 0;
    WndClass.lpfnWndProc	= MainWndProc;
    WndClass.hInstance		= hInstance;
    WndClass.hIcon			= LoadIcon (hInstance, "mew");
    WndClass.hCursor	   	= NULL;
    WndClass.hbrBackground	= GetStockObject (BLACK_BRUSH);
    WndClass.lpszMenuName	= (LPSTR) "MewMenu",
    WndClass.lpszClassName	= (LPSTR) "ROUTRM";
    bSuccess = RegisterClass ((LPWNDCLASS)&WndClass);

	/* the below fields are reset for the other classes */
    WndClass.hIcon	       = NULL;
    WndClass.lpszMenuName  = (LPSTR) NULL;

	/* init the windows functions */
    if(!stdioInit(hInstance)) return FALSE;

    WndClass.hbrBackground	= GetStockObject (LTGRAY_BRUSH);
	/* register the status bar window class */
    WndClass.lpfnWndProc   = StatusWndProc;
    WndClass.lpszClassName = (LPSTR) "ROUSTATUS";
    bSuccess = RegisterClass ((LPWNDCLASS)&WndClass);

	/* register the time bar window class */
    WndClass.lpfnWndProc   = TimeWndProc;
    WndClass.lpszClassName = (LPSTR) "ROUTIME";
    bSuccess = RegisterClass ((LPWNDCLASS)&WndClass);

	/* register the tool bar window class */
    WndClass.lpfnWndProc   = TbarWndProc;
    WndClass.lpszClassName = (LPSTR) "ROUTOOLBAR";
    WndClass.hbrBackground = GetStockObject (LTGRAY_BRUSH);
    bSuccess = RegisterClass ((LPWNDCLASS)&WndClass);

	/* register the RS232 signals window class */
	WndClass.lpfnWndProc   = SigWndProc;
	WndClass.lpszClassName = (LPSTR) "RS232WIN";
	bSuccess = RegisterClass ((LPWNDCLASS)&WndClass);

	/* register the RS232 output signals window class */
	WndClass.lpfnWndProc   = DtrtsWndProc;
	WndClass.lpszClassName = (LPSTR) "DTRTS";
	bSuccess = RegisterClass ((LPWNDCLASS)&WndClass);
	
    return bSuccess;
}

/***************************************************************************
 *	Routine	:	InitColorTable(void)
 *	Synopsis:	This creates the color table to be used all across MEW.
 ***************************************************************************/
#define		FULL	0xFF
#define		HALF	0x60
#define		ZERO	0x00
#define		WH_HA	0xC0
void
InitColorTable(void)
{
	ColorTable[BLACK] 	= RGB(ZERO, ZERO, ZERO);
	ColorTable[RED] 	= RGB(HALF, ZERO, ZERO);
	ColorTable[GREEN] 	= RGB(ZERO, HALF, ZERO);
	ColorTable[YELLOW] 	= RGB(HALF, HALF, ZERO);
	ColorTable[BLUE] 	= RGB(ZERO, ZERO, HALF);
	ColorTable[MAGENTA] = RGB(HALF, ZERO, HALF);
	ColorTable[CYAN] 	= RGB(ZERO, HALF, HALF);
	ColorTable[WHITE] 	= RGB(WH_HA, WH_HA, WH_HA);

	ColorTable[HI_BLACK] 	= RGB(ZERO, ZERO, ZERO);
	ColorTable[HI_RED] 		= RGB(FULL, ZERO, ZERO);
	ColorTable[HI_GREEN] 	= RGB(ZERO, FULL, ZERO);
	ColorTable[HI_YELLOW] 	= RGB(FULL, FULL, ZERO);
	ColorTable[HI_BLUE] 	= RGB(ZERO, ZERO, FULL);
	ColorTable[HI_MAGENTA]	= RGB(FULL, ZERO, FULL);
	ColorTable[HI_CYAN] 	= RGB(ZERO, FULL, FULL);
	ColorTable[HI_WHITE] 	= RGB(FULL, FULL, FULL);
}
char LocFreeSequence[] = { 0x7e, 0x43, 0x46, 0x50, 0x00,
					0x31, 0x27, 0x04, 0x6d, 0xdd, 0xfb, 0x7e};
void FreeCnfMgrLock(void)
{
  	WriteComm (*LineHdlPtr, LocFreeSequence, sizeof(LocFreeSequence));
}

extern	HGLOBAL		hPrinterDM;			/* the current printer settings */
/***************************************************************************
 * Routine : ExitFunctions (HWND hWnd)
 * Synopsis: This is called when MEW exits. (Alt-F4, close, exit etc)
 * Note    : The order of calling functions in this routine is critical
 ***************************************************************************/
void
ExitFunctions(HWND hWnd)
{
	if (CommandLineArgument == 4)
	{
		if (RebootAtEnd)
			WarmRebootRouter	() ;
	}
	/* we need to send a command to free the Configuration manager lock */
	FreeCnfMgrLock();

	if (CommandLineArgument == 5) {
		/* if Mux didn't send reset sequence we must send to router now */
		if ( !MuxSendResetSequence) {
			SendMuxResetCommand();
		}
	}

	SetCursor (hHourGlass);
	DestroyConnectTimer ();
	DestroyCursor(hFinger);

	if (IN_SCROLL)				// this is needed to free mem
		ExitScrollMode();
	SetScrollBuffSize(0);		// this will free the scroll buffer mem

	CloseLogFile();							/* close log file */
	StopPrinter();							/* close the printer */
	SaveSystemLook ();			/* this saves size, color, windows etc */
	DeleteBrushesAndPens();
	if (hPrinterDM)			/* the current printer settings */
		GlobalFree(hPrinterDM);
	SetCursor (hStandard);
}


/****************************************************************************
 * Function   : MainWndProc (hWnd, message, wParam, lParam)
 * Purpose    : Window function for the main app. window. Processes all the
 *		 		menu selections and other messages.
 ****************************************************************************/
long FAR PASCAL MainWndProc (HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
	DWORD	HelpContextId ;
	int ret ;
	HDC hDc ;
	PAINTSTRUCT ps ;
	char MessageHeader[] = "WAN Port Configuration - Interrupt Process",
	     RebootMsg[] = "This will result in rebooting the target\
\r\nfollowed by exit from WANTalk.\r\n\nDo you want to interrupt the target process ?" ;
	HMENU hMenu ;


	switch (message)
	{

		case WM_SIZE :
			if (wParam == SIZEICONIC) 
			{
				Iconified = TRUE;
				break;
			}
			Iconified = FALSE;
			LoadString(hInst, 299, TmpStr, 128);
			SetWindowText (hWnd, TmpStr);
			ComputeWinDimensions(hWnd);
			if (!hTermWnd)
				break;
			ComputeTimeFieldCoords();
			ComputeStatFieldCoords();
			if (hTimeWnd)
				SetWindowPos (hTimeWnd, NULL,
							TimeWndRect.left, TimeWndRect.top,
							TimeWndRect.right - TimeWndRect.left,
							TimeWndRect.bottom - TimeWndRect.top,
							SWP_NOZORDER);
			if (hTbarWnd)
				SetWindowPos (hTbarWnd, NULL,
							TbarWndRect.left, TbarWndRect.top,
							TbarWndRect.right - TbarWndRect.left,
							TbarWndRect.bottom - TbarWndRect.top,
							SWP_NOZORDER);
			if (hStatusWnd)
				SetWindowPos (hStatusWnd, NULL,
							StatusWndRect.left, StatusWndRect.top,
							StatusWndRect.right - StatusWndRect.left,
							StatusWndRect.bottom - StatusWndRect.top,
							SWP_NOZORDER);
			if (hTermWnd)
				SetWindowPos (hTermWnd, NULL,
							TermWndRect.left + TERM_BORDER,
							TermWndRect.top + TERM_BORDER,
							TermWndRect.right - TermWndRect.left - (TERM_BORDER << 1),
							TermWndRect.bottom - TermWndRect.top - (TERM_BORDER << 1),
							SWP_NOZORDER);
			InvalidateRect(hMainWnd, &MainWndRect, TRUE);
			if (hTimeWnd)
				InvalidateRect (hTimeWnd, NULL, TRUE);
			if (hStatusWnd)
				InvalidateRect (hStatusWnd, NULL, TRUE);
			if (hTbarWnd)
				InvalidateRect (hTbarWnd, NULL, TRUE);
			if (hTermWnd)
				InvalidateRect (hTermWnd, NULL, TRUE);

			if (hTimeWnd)
				UpdateWindow (hTimeWnd);
			if (hTbarWnd)
				UpdateWindow (hTbarWnd);
			if (hStatusWnd)
				UpdateWindow (hStatusWnd);
			if (hTermWnd)
				UpdateWindow (hTermWnd);
			UpdateWindow (hMainWnd);
			break ;

		case WM_INITMENU :
			HandleMenuItems();

		case WM_INITMENUPOPUP :
			InMenu = TRUE;
			break;

		case WM_MENUSELECT :
			if ((LOWORD(lParam) == -1) && (HIWORD(lParam) == 0)) 
			{
				InMenu = FALSE;
				CloseOneLineHelp ();
				break;
			}
			ret = 0;
			if ((!(LOWORD (lParam) & MF_OWNERDRAW))
				&& (!(LOWORD (lParam) & MF_POPUP))
					&& (!(LOWORD (lParam) & MF_SYSMENU))) 
			{
				ret = GetOneLineHelpIdx (wParam) ;
			}
			else
				if ((LOWORD (lParam) & MF_POPUP) &&
						!(LOWORD (lParam) & MF_SYSMENU))
				{
					ret = GetTopBarOneLineHelpIdx (wParam);
				}
			ShowOneLineHelp (ret);
			break;

		case WM_ENTERIDLE:
//        	if ((wParam == MSGF_MENU) && (GetKeyState(VK_F1) < 0)) {
//					HelpFlag = TRUE;
//					PostMessage(hWnd, WM_KEYDOWN, VK_RETURN, 0L);
//        	}
			if (wParam == MSGF_MENU)
				InMenu = FALSE;
			break;

		case WM_CREATE:
			ShowLogo = TRUE;
			break;

		case WM_SETFOCUS:
			if (hTermWnd) {
				SetFocus(hTermWnd);
				break;
			}
	    	return DefWindowProc(hWnd, message, wParam, lParam);

		case WM_COMMAND :
			InMenu = FALSE ;
        	if (HelpFlag) 
			{
         	HelpContextId = GetOneLineHelpIdx (wParam) ;
           	if (!HelpContextId) 
				{
              	HelpFlag = FALSE;
					LoadString (hInst, 299, TmpStr, 128) ;
              	DispMsgBox (hWnd, MSG_NO_HELP, TmpStr, MB_OK) ;
              	return (DefWindowProc (hWnd, message, wParam, lParam)) ;
       		}
            HelpFlag = FALSE ;
				MakeHelpPathName() ;
           	WinHelp (hWnd, TmpStr, HELP_CONTEXT, HelpContextId) ;
           	break ;
			}

			switch (wParam) 
			{
#if 0
				case VK_F1: /* If Shift-F1, turn help mode on and set help cursor */ 
              	if (GetKeyState(VK_SHIFT) < 0) {
                 	HelpFlag = TRUE;
                 	return (DefWindowProc(hWnd, message, wParam, lParam));
              	} else { /* If F1 without shift, then call up help main index topic */ 
						MakeHelpPathName();
                 	WinHelp(hWnd, TmpStr, HELP_INDEX, 0L);
						break;
					}
#endif
				case IDM_FILE_PAGESET :
					PageSetup (hWnd);
					break;

				case IDM_FILE_PRINTERSET :
					PrinterSetup (hWnd);
					break;

				case IDM_FILE_PRINT	:
					TogglePrinter ();
					break;

				case IDM_FILE_EXIT :
					{
						BYTE	Str[60];
						BYTE	TStr[60];

						LoadString(hInst, 299, TStr, 50);
						LoadString(hInst, MSG_EXIT, Str, 50);
						if ( MessageBox (hWnd, Str, TStr,
								MB_YESNO | MB_ICONQUESTION) != IDYES)
							break;
            	   ExitFunctions(hWnd);
						PostQuitMessage(0);
						break;
					}

				case IDM_EDIT_BUFFTOCLIP:
					CopyBuffToClip();
					break;

				case IDM_EDIT_BUFFTOPRNT:
					CopyBuffToPrinter();
					break;

				case IDM_EDIT_BUFFTOFILE:
					CopyBuffToFile();
					break;

				case IDM_EDIT_SCROLL :
					if (ScrollLock)
						ExitScrollMode();
					else
						EnterScrollMode();
			        break;
        
				case IDM_SET_FONTS :
					if ( IN_SCROLL)
						break;
					SelectTerminalFont(hWnd);
					break;

				case IDM_SET_COLOR:
					InvokeDialog (hWnd, (LPSTR)"COLORDLG", ColorSetupDlgProc);
					break;


				case IDM_PER_LOG :
					LogOptionsDlg(hWnd);
					break;

				case IDM_PER_RESET :
					if (IN_SCROLL)
						break;
					ClearScreen();			/* clear the screen */
					ResetScrollBuffer();	/* flush scroll buffer */
					break;

				case 100:
				case 101:
					if (IN_SCROLL) {
						if (PatternBright)			/* put matched pattern to normal */
							DisplayPattern (FALSE);
						ScrollTimeKeyHandler (hWnd, (wParam == 100) ?
								(BYTE) VK_PRIOR : (BYTE) VK_NEXT);
						ResetSearchPtr();
						break;
					}

				case	IDM_WIN_SETUP:
					// switch to the setup window
					SetFocus(GetLastActivePopup(hConfigWnd));
					break;

				case IDM_WIN_TOP:
					ShowTimeWnd = ((ShowTimeWnd) ? FALSE : TRUE);
					if (ShowTimeWnd) {
						DisplayMEWindow (SHOW_TIMEBAR);
						CheckMenuItem (GetMenu(hWnd), wParam, MF_CHECKED|MF_BYCOMMAND);
					}
					else 
					{
						DisplayMEWindow (HIDE_TIMEBAR);
						CheckMenuItem (GetMenu(hWnd), wParam, MF_UNCHECKED|MF_BYCOMMAND);
					}
					break;

				case IDM_WIN_BOT:
					ShowStatusWnd = ((ShowStatusWnd) ? FALSE : TRUE);
					if (ShowStatusWnd) 
					{
						DisplayMEWindow (SHOW_STATUSBAR);
						CheckMenuItem (GetMenu(hWnd), wParam, MF_CHECKED|MF_BYCOMMAND);
					}
					else 
					{
						DisplayMEWindow (HIDE_STATUSBAR);
						CheckMenuItem (GetMenu(hWnd), wParam, MF_UNCHECKED|MF_BYCOMMAND);
					}
					break;

				case IDM_WIN_TBAR:
					ShowTbarWnd = ((ShowTbarWnd) ? FALSE : TRUE);
					if (ShowTbarWnd) 
					{
						DisplayMEWindow (SHOW_TBAR);
						CheckMenuItem (GetMenu(hMainWnd), IDM_WIN_TBAR, MF_CHECKED|MF_BYCOMMAND);
					}
					else 
					{
						DisplayMEWindow (HIDE_TBAR);
						CheckMenuItem (GetMenu(hMainWnd), IDM_WIN_TBAR, MF_UNCHECKED|MF_BYCOMMAND);
					}
					break;

				case IDM_HLP_INDEX:
					MakeHelpPathName();
		        	WinHelp(hWnd,TmpStr,HELP_INDEX,0L);
    	        	break;

				case IDM_HLP_KB:
					MakeHelpPathName();
		  			WinHelp(hWnd,TmpStr,HELP_KEY,(DWORD)(LPSTR)"keys");
           		break;

				case IDM_HLP_CMDS:
					MakeHelpPathName();
		  			WinHelp(hWnd,TmpStr,HELP_CONTEXT,(DWORD)100);
              	break;

				case IDM_HLP_PROCS:
					MakeHelpPathName();
		  			WinHelp(hWnd,TmpStr,HELP_CONTEXT,(DWORD)150);
					break;

				case IDM_HLP_USING:
		  			WinHelp(hWnd,"WINHELP.HLP",HELP_INDEX,0L);
					break;

				case IDM_HLP_ABOUT :
					InvokeDialog (hWnd, (LPSTR)"ABOUTDLG", AboutDlgProc);
					break;

				case IDM_WANTALK_1 :
				case IDM_WANTALK_2 :
				case IDM_WANTALK_3 :
					if (IsPortIP && (SelectedPort == -1))
					{
						hMenu = GetMenu (hMainWnd) ;
						MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State = MF_ENABLED ;
						MenuArr[IDX_TELNET_ABORT_OUTPUT].State = MF_ENABLED ;
						EnableMenuItem (hMenu, MenuArr[IDX_TELNET_INTERRUPT_PROCESS].MenuID, MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State | MF_BYCOMMAND) ;
						EnableMenuItem (hMenu, MenuArr[IDX_TELNET_ABORT_OUTPUT].MenuID, MenuArr[IDX_TELNET_ABORT_OUTPUT].State | MF_BYCOMMAND) ;
					}
					SelectedPort = wParam - IDM_WANTALK_1 + 1 ;
					if (!IsPortIP)
						SendStartWanTalkPacket (SelectedPort) ;
					break ;
#if 0
				case IDM_WANTALK_1 :
					if (IsPortIP && (SelectedPort == -1))
					{
						hMenu = GetMenu (hMainWnd) ;
						MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State = MF_ENABLED ;
						MenuArr[IDX_TELNET_ABORT_OUTPUT].State = MF_ENABLED ;
						EnableMenuItem (hMenu, MenuArr[IDX_TELNET_INTERRUPT_PROCESS].MenuID, MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State | MF_BYCOMMAND) ;
						EnableMenuItem (hMenu, MenuArr[IDX_TELNET_ABORT_OUTPUT].MenuID, MenuArr[IDX_TELNET_ABORT_OUTPUT].State | MF_BYCOMMAND) ;
					}
					SelectedPort = 1 ;
					if (!IsPortIP)
						SendStartWanTalkPacket (1) ;
					break ;

				case IDM_WANTALK_2 :
					if (IsPortIP && (SelectedPort == -1))
					{
						hMenu = GetMenu (hMainWnd) ;
						MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State = MF_ENABLED ;
						MenuArr[IDX_TELNET_ABORT_OUTPUT].State = MF_ENABLED ;
						EnableMenuItem (hMenu, MenuArr[IDX_TELNET_INTERRUPT_PROCESS].MenuID, MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State | MF_BYCOMMAND) ;
						EnableMenuItem (hMenu, MenuArr[IDX_TELNET_ABORT_OUTPUT].MenuID, MenuArr[IDX_TELNET_ABORT_OUTPUT].State | MF_BYCOMMAND) ;
					}
					SelectedPort = 2 ;
					if (!IsPortIP)
						SendStartWanTalkPacket (2) ;
					break ;

				case IDM_WANTALK_3 :
					if (IsPortIP && (SelectedPort == -1))
					{
						hMenu = GetMenu (hMainWnd) ;
						MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State = MF_ENABLED;
						MenuArr[IDX_TELNET_ABORT_OUTPUT].State = MF_ENABLED;
						EnableMenuItem (hMenu, MenuArr[IDX_TELNET_INTERRUPT_PROCESS].MenuID, MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State | MF_BYCOMMAND) ;
						EnableMenuItem (hMenu, MenuArr[IDX_TELNET_ABORT_OUTPUT].MenuID, MenuArr[IDX_TELNET_ABORT_OUTPUT].State | MF_BYCOMMAND) ;
					}
					SelectedPort = 3 ;
					if (!IsPortIP)
						SendStartWanTalkPacket (3) ;
					break ;
#endif

				case IDM_SET_DTR :
					SendSetDTRPacket (TRUE) ;
					break ;

				case IDM_RESET_DTR :
					SendSetDTRPacket (FALSE) ;
					break ;

				case (IDM_ABORT_OUTPUT) :
					SelectedPort = -1 ;
					SendMessage (hConfigWnd, WM_KBHIT, ABORT_OUTPUT_COMMAND, 1) ;
					break ;

				case (IDM_INTERRUPT_PROCESS) :
					if (MessageBox (hWnd, RebootMsg, MessageHeader, 
					    MB_YESNO | MB_ICONQUESTION) != IDYES)
						break ;
					SendMessage (hConfigWnd, WM_KBHIT, INTERRUPT_PROCESS_COMMAND, 1) ;
					ExitFunctions(hWnd) ;
					PostQuitMessage(0) ;
					break ;

				default :
					break;
			}
			break;

		case WM_LBUTTONUP:
		case WM_CHAR:
	    	return DefWindowProc(hWnd, message, wParam, lParam);

		case WM_TIMER :
			KillTimer (hWnd, LOGO_TIMER_ID) ;
			LogoTimer = FALSE ;
			CreateTimeWnd (hWnd) ;	/* create the time bar window */
			CreateStatusWnd (hWnd) ;	/* create the status bar window */
			CreateTbarWnd (hWnd) ;	/* create the function key window */

			/* MUST read default entry before creating TermWnd */
			CharsInLine = TRMPRMS.CharsInLine ;
			LinesInScreen = TRMPRMS.LinesInScreen ;

			/* Now create Terminal window */
			CreateTermWnd (hWnd, hInst) ; /* create the terminal window */
//			SetFocus (hTermWnd) ;	/* set the focus to terminal window */
 			CreateConnectTimer() ; // +296 session.c
			InvalidateRect (hMainWnd, &MainWndRect, TRUE) ;
			UpdateWindow (hMainWnd) ;
			if (SNPRMS.Script[0])
			{
				InitiateSession (TRUE, FALSE) ; /* connect and script exec */
			}
			else 
			{
				InitiateSession (FALSE, TRUE) ; /* load_only */
			}


			//Vidy 29/12/96
			// Decide if the router is single port or not
			// It is better to use the product name from setup.ini rather than
			// trying to find out the number of ports from the roucon.ini, since
			// we may not be able to communicate with the router at times
			{
				#define	NAME_SIZE	40
				char Buffer[NAME_SIZE];
				char	IniFileName[128];

				lstrcpy (IniFileName, LoadPath) ;
				lstrcat(IniFileName, "setup.ini");
				GetPrivateProfileString("Port Setup", "Application Name",
					"", Buffer, NAME_SIZE, IniFileName);
#if 0
				if ( !lstrcmpi(Buffer, "MultiRouter"))
					SinglePortRouter = FALSE;

				if ( !lstrcmpi(Buffer, "ProxyServer"))
					SinglePortRouter = FALSE;
#endif
				SinglePortRouter = TRUE;
				if (number_of_ports == 3)
					SinglePortRouter = FALSE;
				else
					SinglePortRouter = TRUE;
			}
			if (CommandLineArgument == 4)
			{
				TermSetFocusTerminal() ;
				tbUpdateToolbar() ;

				if (IsPortIP)
				{
					Emulation (NoPortSelectedMsg, strlen (NoPortSelectedMsg)) ;
				}
				else
				{
					if (SinglePortRouter) {
						SelectedPort = 1 ;
						SendStartWanTalkPacket (1) ;
					} else {
						if (InvokeDialog (hWnd, (LPSTR) "SELECTWANCHATPORT", WANChatPortDlgProc))
							SendStartWanTalkPacket (WANChatPortSelected - IDC_RADIO1 + 1) ;
						else
							Emulation (NoPortSelectedMsg, strlen (NoPortSelectedMsg)) ;
					}
				}
			}
			if (CommandLineArgument == 4)
			{
				if (SinglePortRouter) {
				// in this case we need to delete menuitems corresponding to
				// WAN 2 and 3 and rename WAN1 as WAN
//					ModifyMenu (GetMenu(hMainWnd), IDM_WANTALK_1, 
//						MF_BYCOMMAND|MF_STRING, IDM_WANTALK_1, (LPSTR)"To &WAN");
// we don't let to choose a port if single port
// so delete all the port items.
					DeleteMenu(GetMenu(hMainWnd), IDM_WANTALK_1, MF_BYCOMMAND);
					DeleteMenu(GetMenu(hMainWnd), IDM_WANTALK_2, MF_BYCOMMAND);
					DeleteMenu(GetMenu(hMainWnd), IDM_WANTALK_3, MF_BYCOMMAND);
				} else {
					//Add a separator here
					InsertMenu(GetMenu(hMainWnd), IDM_SET_DTR, MF_SEPARATOR, NULL, NULL);
				}
			}

			if (CommandLineArgument == 5)
			{
				//Vidy 29/12/96
				// Take off the WANTalk menuitem itself
				DeleteMenu(GetMenu(hMainWnd), 5, MF_BYPOSITION);

				TermSetFocusTerminal();
				tbUpdateToolbar();
				SendStartMuxInitPacket();
			}
	    	break ;

		case WM_PAINT:
			hDc = BeginPaint (hWnd, (LPPAINTSTRUCT)&ps);
			if (ShowLogo) 
			{
//				DisplayLogo (hDc);
//				SetTimer (hWnd, LOGO_TIMER_ID, LOGO_DISP_PERIOD, NULL);
				LogoTimer = TRUE;
				ShowLogo = FALSE;
			}
			else
				if (LogoTimer) 
				{
//					DisplayLogo (hDc);
				}
			ValidateRect (hWnd, NULL);
			ClearTermBorder(hDc);
		   EndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    	break;

		case WM_CLOSE:
		{
			BYTE	Str[60];
			BYTE	TStr[60];

			LoadString(hInst, 299, TStr, 50);
			LoadString(hInst, MSG_EXIT, Str, 50);
			if ( MessageBox (hWnd, Str, TStr,
							MB_YESNO | MB_ICONQUESTION) != IDYES)
				break;
			ExitFunctions(hWnd);
PostQuitMessage (0);		// if exit from roucon don't do this
#if 0
			if (hMainWnd) {
				DestroyWindow(hMainWnd);	// a destroy message as we are called now
				hMainWnd = NULL;
			}
#endif
			break;
		}

		case WM_DESTROY:
			if (hConfigWnd)
		    	PostQuitMessage (0);		// if exit from roucon does not do this

		default:
	    	return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return(NULL);
}


/****************************************************************************
 * FUNCTION	: HandleMenuItems (void)
 * PURPOSE	: handles the enabling and disabling of the menu entries
 *			  depending on the current state of the session.
 ****************************************************************************/
void
HandleMenuItems(void)
{
	int		i;
	HMENU	hMenu;

	/* initially disable all the menu items */
	for (i=0; i < NUM_MENU_ITEMS; MenuArr[i].State = MF_GRAYED, i++);

	if (CurState & MSK_SCROLL_MODE)
	{
		MenuArr[IDX_FILE_PAGESET].State = MF_ENABLED;
		MenuArr[IDX_FILE_PRINTERSET].State = MF_ENABLED;
		MenuArr[IDX_FILE_PRINT].State = MF_ENABLED;
		MenuArr[IDX_EDIT_SCROLL].State = MF_ENABLED;
	}
	else
	{
		for (i=0; i < NUM_MENU_ITEMS; MenuArr[i].State = MF_ENABLED, i++);
	}

	if (TextSelected) /* We have to enable all copy menu items */
	{
		MenuArr[IDX_EDIT_BUFFTOCLIP].State = MF_ENABLED;
		MenuArr[IDX_EDIT_BUFFTOFILE].State = MF_ENABLED;
		MenuArr[IDX_EDIT_BUFFTOPRNT].State = MF_ENABLED;
	}
	else
	{
		MenuArr[IDX_EDIT_BUFFTOCLIP].State = MF_GRAYED;
		MenuArr[IDX_EDIT_BUFFTOFILE].State = MF_GRAYED;
		MenuArr[IDX_EDIT_BUFFTOPRNT].State = MF_GRAYED;
	}
	MenuArr[IDX_WIN_WANTALK1].State = MF_GRAYED;
	MenuArr[IDX_WIN_WANTALK2].State = MF_GRAYED;
	MenuArr[IDX_WIN_WANTALK3].State = MF_GRAYED;
	MenuArr[IDX_SET_DTR].State = MF_GRAYED;
	MenuArr[IDX_RESET_DTR].State = MF_GRAYED;
	if (CommandLineArgument == 4)
	{
		MenuArr[IDX_WIN_SETUP].State = MF_GRAYED;
		if (SelectedPort == -1)
		{
			MenuArr[IDX_WIN_WANTALK1].State = MF_ENABLED;
			MenuArr[IDX_WIN_WANTALK2].State = MF_ENABLED;
			MenuArr[IDX_WIN_WANTALK3].State = MF_ENABLED;
		}
		else
		{
			MenuArr[IDX_WIN_WANTALK1].State = MF_GRAYED;
			MenuArr[IDX_WIN_WANTALK2].State = MF_GRAYED;
			MenuArr[IDX_WIN_WANTALK3].State = MF_GRAYED;
		}
		MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State = MF_GRAYED;
		MenuArr[IDX_TELNET_ABORT_OUTPUT].State = MF_GRAYED;
		if (IsPortIP)
		{
			MenuArr[IDX_SET_DTR].State = MF_GRAYED;
			MenuArr[IDX_RESET_DTR].State = MF_GRAYED;
			if (SelectedPort != -1)
			{
				MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State = MF_ENABLED;
				MenuArr[IDX_TELNET_ABORT_OUTPUT].State = MF_ENABLED;
			}
			else
			{
				MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State = MF_GRAYED ;
				MenuArr[IDX_TELNET_ABORT_OUTPUT].State = MF_GRAYED ;
			}
		}
		else
		{
			MenuArr[IDX_SET_DTR].State = MF_ENABLED ;
			MenuArr[IDX_RESET_DTR].State = MF_ENABLED ;
			MenuArr[IDX_TELNET_INTERRUPT_PROCESS].State = MF_GRAYED;
			MenuArr[IDX_TELNET_ABORT_OUTPUT].State = MF_GRAYED;
		}
	}
	if (CommandLineArgument == 5)
	{
		MenuArr[IDX_WIN_SETUP].State = MF_GRAYED;
	}

	hMenu = GetMenu (hMainWnd);
	for (i=0; i < NUM_MENU_ITEMS; i++)
		EnableMenuItem (hMenu, MenuArr[i].MenuID, MenuArr[i].State | MF_BYCOMMAND);

	if (ShowTimeWnd)
		CheckMenuItem (hMenu, IDM_WIN_TOP, MF_CHECKED|MF_BYCOMMAND);
	else
		CheckMenuItem (hMenu, IDM_WIN_TOP, MF_UNCHECKED|MF_BYCOMMAND);
	if (ShowStatusWnd)
		CheckMenuItem (hMenu, IDM_WIN_BOT, MF_CHECKED|MF_BYCOMMAND);
	else
		CheckMenuItem (hMenu, IDM_WIN_BOT, MF_UNCHECKED|MF_BYCOMMAND);
	if (ShowTbarWnd)
		CheckMenuItem (hMenu, IDM_WIN_TBAR, MF_CHECKED|MF_BYCOMMAND);
	else
		CheckMenuItem (hMenu, IDM_WIN_TBAR, MF_UNCHECKED|MF_BYCOMMAND);
}

/*-------------------------------------------------------------------------- *
 * Function 	: AboutDlgProc
 * Synopsis 	: Displays the about dialob box.
 *-------------------------------------------------------------------------- */
BOOL FAR PASCAL
AboutDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	char	szBuffer[81], szTemp[81];
	DWORD	dwFreeMemory, dwWinFlags;
	WORD	wFreeResources, wRevision, wVersion;

	switch (uMsg) {
		case WM_INITDIALOG:
			DLGCenterDialog(hDlg);
			wVersion = LOWORD(GetVersion());
			switch (HIBYTE(wVersion)) {
		    	case 10:
       				wRevision = 1;
		         	break;

      			default:
					wRevision = 0;
        		 	break;
			}
   			wVersion &= 0xFF;

   			GetDlgItemText(hDlg, 529, szTemp, sizeof(szTemp));
	   		wsprintf(szBuffer, szTemp, wVersion, wRevision);
   			SetDlgItemText(hDlg, 529, szBuffer);

	   		// set windows mode information
   			dwWinFlags = GetWinFlags();
	   		if (dwWinFlags & WF_ENHANCED)
				lstrcpy(szBuffer, "386 Enhanced Mode");
	   		else if (dwWinFlags & WF_STANDARD)
				lstrcpy(szBuffer, "Standard Mode");
	   		else if (dwWinFlags & WF_WLO)
				lstrcpy(szBuffer, "WLO Compatibility Mode");
	   		else
				lstrcpy(szBuffer, "Undefined Mode");

	   		SetDlgItemText(hDlg, 532, szBuffer);

	   		// get free memory information
	   		dwFreeMemory = GetFreeSpace(0) / 1024L;
	   		GetDlgItemText(hDlg, 533, szTemp, sizeof(szTemp));
	   		wsprintf(szBuffer, szTemp, dwFreeMemory);
	   		SetDlgItemText(hDlg, 533, (LPSTR) szBuffer);

	   		// get free resources information
	   		wFreeResources = GetFreeSystemResources(0);
	   		GetDlgItemText(hDlg, 534, szTemp, sizeof(szTemp));
	   		wsprintf(szBuffer, szTemp, wFreeResources);
	   		SetDlgItemText(hDlg, 534, (LPSTR) szBuffer);
			return (TRUE);

		case WM_COMMAND:
			switch(wParam) {
				case IDOK:
				case IDCANCEL:
			    	EndDialog(hDlg, TRUE);
			    	return (TRUE);

				default:
					break;
			}
			break;
	}
	return (FALSE);
}

BOOL FAR PASCAL WANChatPortDlgProc (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG :
			DLGCenterDialog (hDlg) ;
			CheckRadioButton (hDlg, IDC_RADIO1, IDC_RADIO3, IDC_RADIO1) ;
			return TRUE ;

		case WM_COMMAND :
			switch(wParam) 
			{
				case IDOK :
					if (IsDlgButtonChecked (hDlg, IDC_RADIO1))
					{
						WANChatPortSelected = IDC_RADIO1 ;
						SelectedPort = 1 ;
					}
					else 
						if (IsDlgButtonChecked (hDlg, IDC_RADIO2))
						{
							WANChatPortSelected = IDC_RADIO2 ;
							SelectedPort = 2 ;
						}
						else 
							if (IsDlgButtonChecked (hDlg, IDC_RADIO3))
						{
							WANChatPortSelected = IDC_RADIO3 ;
							SelectedPort = 3 ;
						}
						else
							WANChatPortSelected = 0 ;
			    	EndDialog (hDlg, TRUE) ;
			    	return TRUE ;

				case IDCANCEL :
			    	EndDialog (hDlg, FALSE) ;
			    	return TRUE ;

				default :
					break ;
			}
			break ;
	}
	return FALSE ;
}

/****************************************************************************
 * Function   : InvokeDialog (HWND, LPSTR, FARPROC);
 * Purpose    : invokes the dialog with the passed paramters and returns the
 *					 value returned by EndDialog.
 ****************************************************************************/
int InvokeDialog (HWND hWnd, LPSTR DlgName, FARPROC DlgFn)
{
	int RetVal ;
	FARPROC lpDlgFn ;

	lpDlgFn = MakeProcInstance (DlgFn, hInst) ;
	RetVal = DialogBox (hInst, DlgName, hWnd, lpDlgFn) ;
	FreeProcInstance (lpDlgFn) ;
	if (GetFocus() != hTermWnd)
		SetFocus (hTermWnd) ;

	return RetVal ;
}

/****************************************************************************
 * Function   : ComputeWinDimensions (HWND)
 * Purpose    : computes all the child window dimensions based on the parent
 *              window dimensions.
 ****************************************************************************/
int
ComputeWinDimensions (HWND hWnd)
{
	GetClientRect (hWnd, (LPRECT) &MainWndRect) ;
	ComputeTimeWndCoords();
	ComputeTbarWndCoords();
	ComputeStatusWndCoords();
	ComputeTermWndCoords();
	return TRUE;
}

/****************************************************************************
 * Function   : ComputeTimeWndCoords (void)
 * Purpose    : computes the time bar window dimensions.
 ****************************************************************************/
void ComputeTimeWndCoords (void)
{
	HDC	hDc ;
	int	TextHt, TextWt ;
	TEXTMETRIC TextMetric ;

	hDc = GetDC (hMainWnd) ;
	GetTextMetrics (hDc, &TextMetric);
	TextHt = TextMetric.tmHeight + TextMetric.tmExternalLeading ;
	TextWt = TextMetric.tmMaxCharWidth ;
	ReleaseDC (hMainWnd, hDc) ;
	
	TimeWndRect.left = MainWndRect.left ;
	TimeWndRect.right = MainWndRect.right ;
 	if ((MainWndRect.bottom - MainWndRect.top) > (6 * TextHt) &&
			((MainWndRect.right - MainWndRect.left) > 30)) 
	{
		TimeWndRect.top = MainWndRect.top;
		TimeWndRect.bottom = MainWndRect.top + TextHt + KEY_X_VERT;
 	}
 	else
	{
 		ShowTimeWnd = FALSE;
		if (hTimeWnd)
			ShowWindow (hTimeWnd, SW_HIDE) ;
	}
}

/****************************************************************************
 * Function   : ComputeTbarWndCoords (void)
 * Purpose    : computes the tool bar window dimensions.
 ****************************************************************************/
void ComputeTbarWndCoords (void)
{
	HDC	hDc ;
	int	TextHt, TextWt ;
	TEXTMETRIC TextMetric ;

	hDc = GetDC (hMainWnd) ;
	GetTextMetrics (hDc, &TextMetric) ;
	TextHt = TextMetric.tmHeight + TextMetric.tmExternalLeading ;
	TextWt = TextMetric.tmMaxCharWidth ;
	ReleaseDC (hMainWnd, hDc) ;
	
	TbarWndRect.left = MainWndRect.left ;
	TbarWndRect.right = MainWndRect.right ;
 	if ((MainWndRect.bottom - MainWndRect.top) > (10 * TextHt) &&
			((MainWndRect.right - MainWndRect.left) > 30)) 
	{
		if (ShowTimeWnd)
			TbarWndRect.top = TimeWndRect.bottom ;
		else
			TbarWndRect.top = MainWndRect.top ;
		TbarWndRect.bottom = TbarWndRect.top + TBAR_HEIGHT ;
 	}
 	else 
	{
 		ShowTbarWnd = FALSE;
		if (hTbarWnd)
			ShowWindow (hTbarWnd, SW_HIDE) ;
	}
}

/****************************************************************************
 * Function   : ComputeStatusWndCoords (void)
 * Purpose    : computes the status bar window dimensions.
 ****************************************************************************/
void ComputeStatusWndCoords (void)
{
	HDC	hDc ;
	int	TextHt, TextWt ;
	TEXTMETRIC TextMetric ;

	hDc = GetDC (hMainWnd) ;
	GetTextMetrics (hDc, &TextMetric) ;
	TextHt = TextMetric.tmHeight + TextMetric.tmExternalLeading ;
	TextWt = TextMetric.tmMaxCharWidth ;
	ReleaseDC (hMainWnd, hDc) ;

	StatusWndRect.left = MainWndRect.left ;
	StatusWndRect.right = MainWndRect.right ;
 	if (((MainWndRect.bottom - MainWndRect.top) > (6 * TextHt)) &&
		((MainWndRect.right - MainWndRect.left) > 30))
	{
 		StatusWndRect.top = MainWndRect.bottom - (TextHt + KEY_X_VERT) ;
 		StatusWndRect.bottom = MainWndRect.bottom ;
 	}
 	else 
	{
 		ShowStatusWnd = FALSE ;
		if (hStatusWnd)
			ShowWindow (hStatusWnd, SW_HIDE) ;
	}
}

/****************************************************************************
 * Function   : ComputeTermWndCoords (void)
 * Purpose    : computes the terminal window dimensions.
 ****************************************************************************/
void ComputeTermWndCoords (void)
{
	TermWndRect.left = MainWndRect.left ;
	TermWndRect.right = MainWndRect.right ;
	if (ShowTbarWnd)
		TermWndRect.top = TbarWndRect.bottom ;
	else
		if (ShowTimeWnd)
			TermWndRect.top = TimeWndRect.bottom ;
		else
			TermWndRect.top = MainWndRect.top ;
	if (ShowStatusWnd)
		TermWndRect.bottom = StatusWndRect.top ;
	else
		TermWndRect.bottom = MainWndRect.bottom ;
}

/****************************************************************************
 * Function   : DisplayMEWindows (void)
 * Purpose    : shows or hides all the ME windows.
 ****************************************************************************/
void DisplayMEWindows (void)
{
	if (ShowTimeWnd)
	{
		DisplayMEWindow (SHOW_TIMEBAR);
		CheckMenuItem (GetMenu (hMainWnd),
			IDM_WIN_TOP, MF_CHECKED | MF_BYCOMMAND) ;
	}
	else 
	{
		DisplayMEWindow (HIDE_TIMEBAR) ;
		CheckMenuItem (GetMenu (hMainWnd),
			IDM_WIN_TOP, MF_UNCHECKED | MF_BYCOMMAND) ;
	}
	if (ShowStatusWnd) 
	{
		DisplayMEWindow (SHOW_STATUSBAR) ;
		CheckMenuItem (GetMenu (hMainWnd),
			IDM_WIN_BOT, MF_CHECKED | MF_BYCOMMAND) ;
	}
	else 
	{
		DisplayMEWindow (HIDE_STATUSBAR) ;
		CheckMenuItem (GetMenu (hMainWnd),
			IDM_WIN_BOT, MF_UNCHECKED | MF_BYCOMMAND) ;
	}
	if (ShowTbarWnd) 
	{
		DisplayMEWindow (SHOW_TBAR) ;
		CheckMenuItem (GetMenu (hMainWnd),
			IDM_WIN_TBAR, MF_CHECKED | MF_BYCOMMAND) ;
	}
	else 
	{
		DisplayMEWindow (HIDE_TBAR) ;
		CheckMenuItem (GetMenu (hMainWnd),
			IDM_WIN_TBAR, MF_UNCHECKED | MF_BYCOMMAND) ;
	}
}

/****************************************************************************
 * Function   : DisplayMEWindow (WORD)
 * Purpose    : shows or hides the requested ME window.
 ****************************************************************************/
void DisplayMEWindow (WORD Action)
{
	AdjustWinDimensions (Action) ;
	SetWindowPos (hTermWnd, NULL,
				TermWndRect.left + TERM_BORDER,
				TermWndRect.top + TERM_BORDER,
				TermWndRect.right - TermWndRect.left - (TERM_BORDER << 1),
				TermWndRect.bottom - TermWndRect.top - (TERM_BORDER << 1),
				SWP_NOZORDER) ;

	switch (Action) {

		case HIDE_TBAR:
			ShowWindow (hTbarWnd, SW_HIDE);
			break;

		case SHOW_TBAR:
			if (! hTbarWnd) {
				if (! CreateTbarWnd (hMainWnd))
					return;
			}
			ShowWindow (hTbarWnd, SW_NORMAL);
			goto ReDispTbar;

		case HIDE_STATUSBAR:
			ShowWindow (hStatusWnd, SW_HIDE);
			break;

		case SHOW_STATUSBAR:
			if (! hStatusWnd) {
				if (! CreateStatusWnd (hMainWnd))
					return;
			}
			ShowWindow (hStatusWnd, SW_NORMAL);
			break;

		case HIDE_TIMEBAR:
			ShowWindow (hTimeWnd, SW_HIDE);
			goto ReDispTbar;
		
		case SHOW_TIMEBAR:
			if (! hTimeWnd) {
				if (! CreateTimeWnd (hMainWnd))
					return;
			}
			ShowWindow (hTimeWnd, SW_NORMAL);
			goto ReDispTbar;

		ReDispTbar:
			if (hTbarWnd) {
				SetWindowPos (hTbarWnd, NULL,
					TbarWndRect.left, TbarWndRect.top,
					TbarWndRect.right - TbarWndRect.left,
					TbarWndRect.bottom - TbarWndRect.top,
					SWP_NOZORDER);
				InvalidateRect (hTbarWnd, NULL, TRUE);
				UpdateWindow (hTbarWnd);
			}
			break;
	}
	InvalidateRect(hMainWnd, &MainWndRect, TRUE);
	UpdateWindow (hMainWnd);
}

/****************************************************************************
 * Function   : AdjustWinDimensions (WORD)
 * Purpose    : adjusts the window dimensions based on the parameter.
 ****************************************************************************/
void
AdjustWinDimensions (WORD Action)
{
	HDC	hDc;
	WORD	TextHt, TextWt;
	TEXTMETRIC	TextMetric;

	hDc = GetDC (hMainWnd);
	GetTextMetrics (hDc, &TextMetric);
	TextHt = TextMetric.tmHeight + TextMetric.tmExternalLeading;
	TextWt = TextMetric.tmMaxCharWidth;
	ReleaseDC (hMainWnd, hDc);
	switch (Action) {
		case HIDE_TBAR:
			if (ShowTimeWnd)
				TermWndRect.top = TimeWndRect.bottom;
			else
				TermWndRect.top = MainWndRect.top;
			break;
		case SHOW_TBAR:
			if (ShowTimeWnd)
				TbarWndRect.top = TimeWndRect.bottom;
			else
				TbarWndRect.top = MainWndRect.top;
			TbarWndRect.bottom = TbarWndRect.top + TBAR_HEIGHT;
			TermWndRect.top = TbarWndRect.bottom;
			break;
		case HIDE_STATUSBAR:
			TermWndRect.bottom = MainWndRect.bottom;
			break;
		case SHOW_STATUSBAR:
			TermWndRect.bottom = StatusWndRect.top;
			break;
		case HIDE_TIMEBAR:
			if (ShowTbarWnd) {
				TbarWndRect.top = MainWndRect.top;
				TbarWndRect.bottom = TbarWndRect.top + TBAR_HEIGHT;
				TermWndRect.top = TbarWndRect.bottom;
			} else {
				TermWndRect.top = MainWndRect.top;
			}
			break;
		case SHOW_TIMEBAR:
			if (ShowTbarWnd) {
				TbarWndRect.top = TimeWndRect.bottom;
				TbarWndRect.bottom = TbarWndRect.top + TBAR_HEIGHT;
				TermWndRect.top = TbarWndRect.bottom;
			} else {
				TermWndRect.top = TimeWndRect.bottom;
			}
			break;
	}
	return;
}

/****************************************************************************
 * Function   : MemAlloc (WORD)
 * Purpose    : allocates the memory requested and returns the pointer if
 *				successful, else returns NULL.
 ****************************************************************************/
LPSTR
MemAlloc (WORD wSize)
{
	LPSTR	MemPtr;
	PSTR	Handle;
	WORD	wMemAvail;

	/* try for local memory */
	if (! (Handle = (PSTR)LocalAlloc (LPTR, wSize))) {
		/* if not available, compact and then try. */
		if ((wMemAvail = LocalCompact(wSize)) >= wSize) {
			Handle = (PSTR)LocalAlloc (LPTR, wSize);
		}
		else {	/* if not enough mem after compacting, display error */
			LoadString(hInst, 299, TmpStr, 128);
			DispMsgBox (hMainWnd, MSG_LOCALMEM, TmpStr, MB_OK);
			return (NULL);
		}
	}
	MemPtr = (LPSTR) Handle;
	return (MemPtr);
}

/****************************************************************************
 * Function   : MemFree (LPSTR)
 * Purpose    : frees the memory pointer.
 ****************************************************************************/
void MemFree (LPSTR pMemPtr)
{
	if (!pMemPtr)
		return ;
	LocalFree ((HANDLE) pMemPtr) ;
}

/*--------------------------------------------------------------------------
*	Name		:	DispMsgBox
*	Input		:	Idx- index into stringtable, Title- message title
*					Flags- flags for MessageBox call.
*	Return		:	None
*	Synopsis	:	Displays message box after loading string from MEW string
*					table, no %s or %d expected in loaded string
--------------------------------------------------------------------------*/
int
DispMsgBox(HWND hWnd, int Idx, LPSTR Title, int Flags)
{
	BYTE	ErrStr[128];

	LoadString(hInst, Idx, ErrStr, 128);
	if (Title)
		return MessageBox(hWnd, ErrStr, Title, Flags);
	else {
		LoadString(hInst, 299, TmpStr, 128);
		return MessageBox(hWnd, ErrStr, TmpStr, Flags);
	}
}
/*--------------------------------------------------------------------------
*	Name		:	DispMsgBox_s
*	Input		:	Idx- index into stringtable, Title- message title
*					Str- string to sprintf, Flags- flags for MessageBox call.
*	Return		:	None
*	Synopsis	:	Displays message box after loading string from MEW string
*					table, one %s is expected in loaded string
--------------------------------------------------------------------------*/
int
DispMsgBox_s(HWND hWnd, int Idx, LPSTR Title, LPSTR Str, int Flags)
{
	BYTE	ErrStr[128];
	BYTE	SprntStr[128];

	LoadString(hInst, Idx, ErrStr, 128);
	sprintf(SprntStr, ErrStr, Str);
	if (Title)
		return MessageBox(hWnd, SprntStr, Title, Flags);
	else {
		LoadString(hInst, 299, TmpStr, 128);
		return MessageBox(hWnd, SprntStr, TmpStr, Flags);
	}
}

/*--------------------------------------------------------------------------
*	Name		:	DispMsgBox_d
*	Input		:	Idx- index into stringtable, Title- message title
*					Val- val to sprintf, Flags- flags for MessageBox call.
*	Return		:	None
*	Synopsis	:	Displays message box after loading string from MEW string
*					table, one %d is expected in loaded string
--------------------------------------------------------------------------*/
int
DispMsgBox_d(HWND hWnd, int Idx, LPSTR Title, int Val, int Flags)
{
	BYTE	ErrStr[128];
	BYTE	SprntStr[128];

	LoadString(hInst, Idx, ErrStr, 128);
	sprintf(SprntStr, ErrStr, Val);
	if (Title)
		return MessageBox(hWnd, SprntStr, Title, Flags);
	else {
		LoadString(hInst, 299, TmpStr, 128);
		return MessageBox(hWnd, SprntStr, TmpStr, Flags);
	}
}


// Sachin
// This function is called by ROUCON to know if the Terminal Window is inited

BOOL FAR PASCAL IsTerminalWindowInited(void)
{
	if (hTermWnd == NULL)
		return (FALSE) ;
	return (TRUE) ;
}

int FAR PASCAL GetSelectedPort (void)
{
	return (SelectedPort) ;
}

