/****************************************************************************
 * Filename   : print.h
 * Purpose    : This file contains the macros and prototypes for print.c.
 ****************************************************************************/
/* Dialog box control ids for page setup  */
#define	IDC_PG_HEADER		1400
#define	IDC_PG_FOOTER		1401
#define	IDC_PG_MAR_LT		1402
#define	IDC_PG_MAR_RT		1403
#define	IDC_PG_MAR_TP		1404
#define	IDC_PG_MAR_BM		1405
#define	IDC_PG_DRAFT		3000

/* Dialog box control ids for Printer setup  */
#define	IDC_PRN_LB			1500

typedef	struct {
	BYTE	Header[80];		/* header for the report */
	BYTE	Footer[80];		/* footer for the report */
	int		TopMargin;		/* specified in mms */
	BYTE	TopMrgStr[6];	/* string dimension in inches */
	int		LeftMargin;		/* specified in mms */
	BYTE	LeftMrgStr[6];
	int		BottomMargin;	/* specified in mms */
	BYTE	BottomMrgStr[6];
	int		RightMargin;	/* specified in mms */
	BYTE	RightMrgStr[6];
	BYTE	DraftQuality;	/* draft quality */
} PageLayout;

extern	BYTE	PrintLogging;	/* is remote data logged on printer ? */

/* prototype declarations for functions in print.c */
HDC		OpenPrinter (HWND hWnd);
void 	ClosePrinter (HDC hPr);
HANDLE 	GetPrinterDC(HWND hWnd);
int		PrinterSetup (HWND hWnd);
int 	FAR PASCAL PrinterSetupDlgProc(HWND, unsigned, WORD, LONG);
void	SetupPrinter(HWND hPWnd);
BOOL 	InitPrinterInfo (void);
int		GetPrinterNames (LPSTR *lpPrType, LPSTR *lpPrDriver, LPSTR *lpPrPort);
int		PageSetup (HWND hWnd);
int 	FAR PASCAL PageSetupDlgProc(HWND, unsigned, WORD, LONG);

int		StartPrinter (void);
int		StopPrinter (void);
int		PrintBuffer (LPSTR buffer, WORD len);
int		PrintChar (BYTE ch);
int		TogglePrinter(void);
int 	FAR PASCAL PrintAbortProc(HDC hPr, int Code);
void	ComputePrinterVars (HDC hPr);
WORD	GetFormattedStr (HDC hDc, LPSTR Str, LPSTR FmtStr, int PageNum, WORD PageWidth);
int		CheckPrintError (short EscRet);

typedef WORD FAR PASCAL DeviceMode(HWND, HANDLE, LPSTR, LPSTR);
typedef DeviceMode FAR *LPDEVICEMODE;
