/*----------------------------------------------------------------------------
*	File		:	SCROLL.H
*	Purpose		:	Scroll buffer related header file
*	Package		:	MultiExpress (Windows) - Version 1.00
*	Authors		:	Vidy
*	Date		:	5th feb 1992.
*---------------------------------------------------------------------------*/

#define		VK_SCROLL_LOCK		0x91		/* virt key code for scroll lock */

//#define	MAX_SCROLL_BUFF_SIZE	(8*1024)	/* max of 8K */
#define		DEF_SCROLL_BUF_SIZE		(16*1024)	/* 4k */
#define		SCROLL_EOL_CHAR			0x0A		/* End of line char */
#define		SCROLL_ROOM_EXTRA		(132+1)		/* min extra room to make */

/* control ids for the search dialog box */
#define		IDC_SCRL_PATTERN	1400
#define		IDC_SCRL_TOS		3200			/* Id for top of screen */
#define		IDC_SCRL_TSB		3201			/* id for top of Scroll Buffer	*/

#define		MAX_SRCH_PAT_LEN	40		/* Maximum length of serach patern	*/
#define		ASCII_ESCAPE		0x1B

extern	BYTE	ScrollLock;				/* TRUE if we are in scroll mode */
extern	WORD	ScrollBuffSize;			/* Scroll Buffer size */
extern	WORD	NumLinesInScrlBuff;		/* Number of lines in scroll buffer */
extern	BYTE	SearchPattern[MAX_SRCH_PAT_LEN + 1];
extern	BYTE	FAR	*SearchPtr;			/* ptr to Scrollbuffer search postion */
extern	BYTE	FAR	**ScrollIndexTable;	/* line index array ptr */
extern	BYTE	FAR	*pScrlBuf;			/* lower boundary of scroll buffer */
extern	BYTE	FAR	*pScrlBufEnd;		/* upper boundary of ScrlBuf */
extern	WORD	ScrlDispIndx;			/* display mem start in ScrollIndexTable */

extern	WORD	NumLinesInScrlBuff;	/* Number of lines in scroll buffer */
extern	WORD	ScrlHead;			/* Beginnig of scrl buffer data */
extern	WORD	ScrlTail;			/* End of actual scrl buff data */
extern	WORD	ScrlTmpTail;		/* end of scrl buff + current screen */

extern	void	ResetScrollBuffer(void);
extern	BOOL	SetScrollBuffSize(WORD newsize);
extern	BOOL	LockScrollMem(void);
extern	BOOL	UnlockScrollMem(void);
extern	BOOL	EnterScrollMode(void);
extern	void	ExitScrollMode(void);
extern	void	SaveLineToScrlBuff (BYTE *lineptr);
extern	BOOL	CreateScrollIndexTable(void);
extern	WORD	GetScrollBufferSpace(void);
extern	void	MakeRoomInScrollBuffer(WORD nchars);
extern	void	CopyLineToScrollBuffer (BYTE *line, WORD count);
extern	void	SetDisplayFromIdx(WORD indx);
extern	BOOL	ScrollDisplayUp (WORD nlines);
extern	BOOL	ScrollDisplayDown (WORD nlines);
extern	void	ScrollInY (WORD command, WORD thumb_pos);
extern	void	UpdateScrollThumbs(void);
extern	void	CopyIndxLineFromScrlBuff (BYTE index);
//extern	BYTE	*CopyLineFromScrlBuff (BYTE *disp_ptr, BYTE *scrl_ptr);
extern	BOOL	GetUperLineToDispMem(void);
extern	BOOL	GetBottomLineToDispMem (void);
extern	void	ResetSearchPtr(void);
extern	void	ScrollTimeKeyHandler (HWND hWnd, BYTE key);
extern	int FAR PASCAL
		ScrlSrchDlgProc (HWND hDlg, WORD message, WORD wParam, LONG lParam);

