/*----------------------------------------------------------------------------
*	File		:	SEARCH.C
*	Purpose		:	Scroll buffer search related routines for MEW
*	Package		:	MultiExpress (Windows) - Version 1.00
*	Authors		:	Vidy
*	Date		:	29th feb 1992.
*---------------------------------------------------------------------------*/

#include	"windows.h"
#include	"main.h"
#include	"mew.h"
#include	"file.h"
#include	"scroll.h"
#include	"wstdio.h"
#include	"term.h"
#include	"search.h"

#define		HIGHLIGHT_BK_COLOR			0xFFL
#define		HIGHLIGHT_TEXT_COLOR		0x00FFFFFFL

BYTE	FAR *fpMatchLine;
WORD	wMatchIndex;
BYTE	bMatchOffset;
BYTE	PatLen;
BYTE	NextFunc[MAX_SRCH_PAT_LEN + 1];

DWORD	OldBkColor;
DWORD	OldTextColor;
BYTE	PatternBright;
BYTE	PatternFound;
BYTE	*SrchMsgHeader = "Pattern Search";


/***************************************************************************
*	Routine	:	GetMatchLineAndOffset(BYTE FAR *ptr)
*	Input	:	
*	Return	:	
*	Synopsis:	initialises the fpMatchLine to the matching line
*				bMatchOffset is set to the offset of pattern in the line
***************************************************************************/
void	GetMatchLineAndOffset(BYTE FAR *ptr)
{
	WORD	index;			/* index into ScrollIndexTable */

	/* use a linear search in the ScrollTableIndex */
	for (index = 0; ; index++) {
		/* does the current line wrap around ? */
		if ( ScrollIndexTable[index] < ScrollIndexTable[index + 1] ) {
			/* if no check pointer to be in the lines range */
			if ( (ptr >= ScrollIndexTable [index]) &&
							(ptr < ScrollIndexTable[index + 1]) )
				break;
		} else {
			/* The line wraps around */
			/* check if ptr is greater than indexline or
				less than index+1 line */
			if ( (ptr >= ScrollIndexTable[index] ) ||
							(ptr < ScrollIndexTable[index + 1]) )
				break;
		}
	}

	wMatchIndex = index;
	fpMatchLine = ScrollIndexTable[index];

	if ( ptr >= fpMatchLine)
		bMatchOffset = (BYTE) ((DWORD)ptr - (DWORD)fpMatchLine);
	else
		bMatchOffset = (BYTE) (ScrollBuffSize - 
					(WORD) ((DWORD)fpMatchLine - (DWORD)ptr));
}

/***************************************************************************
*	Routine	:	MakeNextFuncs()
*	Input	:	
*	Return	:	
*	Synopsis:	Support routine for the KMP search
***************************************************************************/
void	MakeNextFuncs(void)
{
	BYTE	i = 1, j = 0;

	NextFunc[0] = 0;
	while ( i < PatLen) {
		while (( j > 0) &&
				(SearchPattern [i - 1] != SearchPattern[j - 1]) ) {
			j = NextFunc[j - 1];
		}
		i++;
		j++;
		NextFunc[i - 1] = (SearchPattern[i - 1] == SearchPattern[j - 1]) ?
					SearchPattern[j - 1] : j;
	}
}

/***************************************************************************
*	Routine	:	InitKMPsearch(void)
*	Input	:	
*	Return	:	
*	Synopsis:	init the KMP variables
***************************************************************************/
void	InitKMPsearch(void)
{
	PatLen = (BYTE) strlen (SearchPattern);
	MakeNextFuncs();
}

/***************************************************************************
*	Routine	:	
*	Input	:	
*	Return	:	Character at offset position from SearchPtr
*	Synopsis:	
***************************************************************************/
BYTE	SearchChar(int offset)
{
	BYTE	FAR *end_ptr;

	end_ptr = SearchPtr + offset;

 	if ( end_ptr <= pScrlBufEnd )
		return * end_ptr;
	else
		return * (pScrlBuf + (end_ptr - pScrlBufEnd));
}

/***************************************************************************
*	Routine	:	KMPsearch (WORD str_len)
*	Input	:	
*	Return	:	offset if match found, else -1
*	Synopsis:	The Knuth-Morris-Pratt search algo.
***************************************************************************/
int		KMPsearch (WORD str_len)
{
	WORD		pat_offset;
	WORD		str_offset;

	for (pat_offset = str_offset = 1;
					(pat_offset <= PatLen) && (str_offset <= str_len); ) {
		while ( (pat_offset > 0)	&&
				(SearchPattern [pat_offset - 1] != SearchChar(str_offset - 1)) ) {
			pat_offset = NextFunc[pat_offset - 1];
		}
		pat_offset++;
		str_offset++;
	}
	if ( pat_offset > PatLen) {
		/* return the offset in buffer where the pattern begins */
		return (str_offset  - PatLen - 1);
	} else {
		/* in case of failure return -1 */
		return -1;
	}
}

/***************************************************************************
*	Routine	:	FindPattern (void)
*	Input	:	
*	Return	:	
*	Synopsis:	Searches for a pattern. If found takes the display to the
*				area and displays the screen with pattern
***************************************************************************/
void	FindPattern(void)
{
	WORD	search_len;
	int		offset;
	BYTE	FAR *match_ptr;
	BYTE	FAR *tailptr;

	if ( !SearchPattern[0]) {
		DispMsgBox(hTermWnd, MSG_SCRL_NO_PAT, SrchMsgHeader, MB_OK);
		return;
	}
		
	tailptr = pScrlBuf + ScrlTmpTail;

	/* calculate number of chars in the scroll buffer
	FROM the current SearchPtr */
	if (SearchPtr <= tailptr)
		search_len = (WORD) ((DWORD)tailptr - (DWORD)SearchPtr);
	else
		search_len = ScrollBuffSize -
					(WORD) ((DWORD)SearchPtr - (DWORD)tailptr) - 1;
	InitKMPsearch ();
	if ((offset = KMPsearch (search_len) ) < 0) {
		PatternFound = FALSE;
		DispMsgBox(hTermWnd, MSG_SCRL_NO_MATCH, SrchMsgHeader, MB_OK);
		return;
	} else {
		PatternFound = TRUE;
		/* we found a match. calculate the pointer value to match beginning */
		match_ptr = SearchPtr + offset;

		/* does it wrap around, if so adjust the pointer */
		if (match_ptr >= pScrlBufEnd)
			match_ptr = pScrlBuf + 
				(int)((DWORD)match_ptr - (DWORD)pScrlBufEnd);

		/* update SearchPtr for next */
		SearchPtr = match_ptr + 1;
		if ( SearchPtr >= pScrlBufEnd)
			SearchPtr = pScrlBuf;

		/* Calculate the match line and offset of pattern in line */
		GetMatchLineAndOffset(match_ptr);

		/* Display the pattern with highlight */
		DisplayMatch ();
	}
}
/****************************************************************************
Synop: returns true if the matched pattern is already fully in the display
****************************************************************************/
BOOL	MatchFullyInDisplay(void)
{
	/* Is it covered in the vertical display */
	if ( (wMatchIndex >= (ScrlDispIndx + WinOrgY) ) &&
				(wMatchIndex < (ScrlDispIndx + WinOrgY + RowsInWin)) )  {
		/* if yes, is it covered in the horizontal section */
		if ( (WinOrgX <= bMatchOffset) &&
						((WinOrgX + ClmsInWin) >= (bMatchOffset + PatLen)) ) {
			/* since pattern is fully in displayed area return TRUE */
			return TRUE;
		}
	} else {
		return FALSE;
	}
}

/***************************************************************************
*	Routine	:	DisplayMatch (void)
*	Input	:	
*	Return	:	
*	Synopsis:	positions the display memory and display window so as to
*				show the matched pattern in the string
***************************************************************************/
void	DisplayMatch (void)
{
	WORD	newscrlwinorgy;		/* the index of display window in ScrollBuffer*/

	/* If the match is fully in the display area don't change the display */
	if (MatchFullyInDisplay()) {
		DisplayPattern(TRUE);
		return;
	}
	/* compute the newscrlwinorgy */
	if ( wMatchIndex > (WORD) (RowsInWin >> 1) )	/* for positioning at top end */
		newscrlwinorgy = wMatchIndex - (RowsInWin >> 1);
	else
		newscrlwinorgy = 0;

	/* positioning at bottom end . display origin can't be
	greater than NumlinesInScrlBuff - RowsInWin */
	newscrlwinorgy = min (newscrlwinorgy, (NumLinesInScrlBuff - RowsInWin) );

	/* Check if we have enough lines in the dispmem */
	if ( (newscrlwinorgy < ScrlDispIndx) ||		/* to go up */
			((newscrlwinorgy + RowsInWin) > (ScrlDispIndx + LinesInScreen) ) )
		SetDisplayFromIdx (newscrlwinorgy);

	/* copute the new WinOrgY */
	WinOrgY = (BYTE) (newscrlwinorgy - ScrlDispIndx);

	/* get a proper WinOrgX value */
	if (ClmsInWin <= PatLen) {		/* We have very less length */
		WinOrgX = (bMatchOffset) ? (BYTE) (bMatchOffset - 1) : (BYTE) 0;
	} else {
		if (ClmsInWin >= (bMatchOffset + PatLen) )
			WinOrgX = 0;
		else
			WinOrgX = bMatchOffset + PatLen - ClmsInWin;
	}

	InvalidateRect(hTermWnd, NULL, FALSE);	/* invalidate the entire area */

	UpdateWindow (hTermWnd);
	DisplayPattern (TRUE);
}

/***************************************************************************
*	Routine	:	DisplayPattern (BOOL high_light)
*	Input	:	
*	Return	:	
*	Synopsis:	Displays the Search pattern in the normal or highlighted mode
***************************************************************************/
void	DisplayPattern (BOOL high_light)
{
	int		patindx, patindy;
	BYTE	attrib;

	/* calculate the x and y indices in the displayed window for the pattern */
	patindy = wMatchIndex - (ScrlDispIndx + WinOrgY);
	patindx = bMatchOffset - WinOrgX;

	attrib = * ( GetStdioLine(WinOrgY + patindy) + bMatchOffset + ScrnBufSize);

	if (high_light) {		/* Show the pattern in revese vedieo */
		OldBkColor = SetBkColor(hTermDC, ColorTable[FORE_GROUND(attrib)]);
		OldTextColor = SetTextColor (hTermDC,
							ColorTable[BACK_GROUND(attrib)]);
	} else {
		OldBkColor = SetBkColor(hTermDC, ColorTable [BACK_GROUND(attrib)] );
		OldTextColor = SetTextColor (hTermDC, ColorTable[FORE_GROUND(attrib)]);
	}
	TextOut (hTermDC, nStdioCharWidth * patindx,
			nStdioCharHeight * patindy, SearchPattern, PatLen);

	if (OldBkColor != 0x80000000)
		SetBkColor (hTermDC, OldBkColor);
	if (OldTextColor != 0x80000000)
		SetTextColor (hTermDC, OldTextColor);

	PatternBright = (high_light) ? (BYTE) TRUE : (BYTE) FALSE;
}

/****************************    Last  line   ****************************/
