/****************************************************************************
*	File		:	SELCOPY.C
*	Purpose		:	Scroll buffer copy related routines for MEW
*	Package		:	MultiExpress (Windows) - Version 1.00
*	Authors		:	Vidy
*	Date		:	8th MAY 1992.
****************************************************************************/

#include	"windows.h"

#include	"main.h"
#include	"mew.h"
#include	"select.h"
#include	"scroll.h"
#include	"emlnfuns.h"
#include	"emlncons.h"
#include	"term.h"
#include	"wstdio.h"
#include	"selcopy.h"
#include	"file.h"
#include	"myprint.h"


/***************************************************************************
*	Routine	:	CopyBufferData(LPSTR dstptr)
*	Input	:	Long byte pointer to the destination
*	Return	:	number of chars copied to the buffer excluding NULL
*	Synopsis:	copies the selected data into a far buffer.
***************************************************************************/
WORD	CopyBufferData(LPSTR dstptr)
{
	BYTE	FAR	*srcptr;
	BYTE	FAR *sel_end_ptr;
	BYTE	FAR *last_char;
	BYTE	FAR *line_start;
	BYTE	index;
	WORD	count = 0;

#if 0
	/* Lock scroll memory first */
	if ( ! ScrollLock) {
		LockScrollMem();
		CreateScrollIndexTable();
	}
#endif

	if ( !TextSelected)	
		return 0;

	/* use the ScrollIndexTable and get the pointers to start and
	endof selected data */
	srcptr = ScrollIndexTable [SelStartLineIndex] + SelStartOffset;
	sel_end_ptr = ScrollIndexTable [SelEndLineIndex] + SelEndOffset;

	last_char = NULL;
	line_start = dstptr;
	index = SelStartOffset;
	while (srcptr != sel_end_ptr) {
		if (*srcptr == SCROLL_EOL_CHAR) {
			if (last_char) {
				count -= dstptr - last_char - 1;
				dstptr = last_char + 1;
			} else {
				count -= dstptr - line_start;
				dstptr = line_start;
			}

			*dstptr++ = CR_ASCII;
			*dstptr = LF_ASCII;
			count += 2;
			index = 0;
			last_char = NULL;		/* To take care of NULL Lines */
			line_start = dstptr;
		} else {
			*dstptr = *srcptr;
			if (*dstptr != ' ')
				last_char = dstptr;
			index++;
			count++;
		}
		srcptr++; dstptr++;

		if (srcptr > pScrlBufEnd)
			srcptr = pScrlBuf;
	}
	*dstptr++ = *srcptr;	/* last char to copy */
	count++;
	index++;
	/* if line in scroll buffer is lesser fill the rest with blanks */
//	while (index <= SelEndOffset) {
//		*dstptr++ = ' ';	/* last char to copy */
//		count++;
//		index++;
//	}
	*dstptr = NULL;		/* clipboard data should be terminated with a NULL */

#if 0
	/* Unlock Scroll memory before return */
	if ( ! ScrollLock) {
		UnlockScrollMem();
		MemFree((PSTR) ScrollIndexTable);
	}
#endif

	return count;
}

/***************************************************************************
*	Routine	:	CopyBuffToClip()
*	Input	:	
*	Return	:	
*	Synopsis:	Copies the selected buffer into clipboard.
***************************************************************************/
void	CopyBuffToClip (void)
{
	HANDLE	memhandle;
	DWORD	size;
	LPSTR	dstptr;

	if (! TextSelected)
		return;
	if (OpenClipboard(hTermWnd) == 0) {
		return;
	}
	size = (CharsInLine + 2) * SelLines + 1;	/* space for chars + lf + cr + NULL */

	/* allocate global memory for sending data to clip board */
	if ( (memhandle = GlobalAlloc(GMEM_MOVEABLE, size)) == NULL) {
		LoadString(hInst, 299, TmpStr, 128);
		DispMsgBox(hTermWnd, MSG_GLMEM, TmpStr, MB_OK);
		return;
	}
	dstptr = GlobalLock(memhandle);
	/* copy the data into the allocated memory */
	CopyBufferData(dstptr);
	GlobalUnlock(memhandle);

	SetClipboardData(CF_TEXT, memhandle);

	CloseClipboard();
}

/***************************************************************************
*	Routine	:	CopyBuffToLine(void)
*	Input	:	None
*	Return	:	None
*	Synopsis:	Copy the selected text to communication line
***************************************************************************/
void	CopyBuffToLine(void)
{
	HANDLE	memhandle;
	DWORD	size;
	LPSTR	dstptr;
	WORD	count;

	size = (CharsInLine + 2) * SelLines + 1;	/* space for chars + lf + cr + NULL */

	/* allocate global memory for sending data to terminal */
	if ( (memhandle = GlobalAlloc(GMEM_MOVEABLE, size)) == NULL) {
		LoadString(hInst, 299, TmpStr, 128);
		DispMsgBox(hTermWnd, MSG_GLMEM, TmpStr, MB_OK);
		return;
	}
	dstptr = GlobalLock(memhandle);
	/* copy the data into the allocated memory */
	count = CopyBufferData(dstptr);

	if (ScrollLock)
		ExitScrollMode();

	SendChars(dstptr, count);
	GlobalUnlock(memhandle);
	GlobalFree(memhandle);
}

/***************************************************************************
*	Routine	:	CopyBuffToPrinter(void)
*	Input	:	None
*	Return	:	None
*	Synopsis:	Copy the selected text to communication line
***************************************************************************/
void	CopyBuffToPrinter(void)
{
	HANDLE	memhandle;
	DWORD	size;
	LPSTR	dstptr;
	WORD	count;

	size = (CharsInLine + 2) * SelLines + 1;	/* space for chars + lf + cr + NULL */

	/* allocate global memory for sending data to clip board */
	if ( (memhandle = GlobalAlloc(GMEM_MOVEABLE, size)) == NULL) {
		LoadString(hInst, 299, TmpStr, 128);
		DispMsgBox(hTermWnd, MSG_GLMEM, TmpStr, MB_OK);
		return;
	}
	dstptr = GlobalLock(memhandle);
	/* copy the data into the allocated memory */
	count = CopyBufferData(dstptr);

	PrintBuffer(dstptr, count);
	GlobalUnlock(memhandle);
	GlobalFree(memhandle);
}

/***************************************************************************
*	Routine	:	
*	Input	:	
*	Return	:	
*	Synopsis:	
***************************************************************************/
void	CopyBuffToFile(void)
{
	LPSTR	dstptr;
	HANDLE	memhandle;
	WORD	count;
	int		fd;
	int		size;

	CurFileName[0] = NULL;


	if ( ! GetSaveFilePathName(hMainWnd, ".", "Save buffer to",
					TRUE, NULL, NULL))
		return;

	/* Truncute if the file exists or create if not */
	_lcreat (IOFilePathName, 0);

	if ( (fd = _lopen (IOFilePathName, READ_WRITE)) < 0) {
		LoadString(hInst, MSG_FILECREATE, TmpStr, 128);
		sprintf (&TmpStr[128], TmpStr, IOFilePathName);
		ShowMesg((LPSTR)&TmpStr[128]);
		return;
	}
	size = (CharsInLine + 2) * SelLines + 1;	/* space for chars + lf + cr + NULL */
	/* allocate global memory for getting selected data */
	if ( (memhandle = GlobalAlloc(GMEM_MOVEABLE, size)) == NULL) {
		LoadString(hInst, 299, TmpStr, 128);
		DispMsgBox(hTermWnd, MSG_GLMEM, TmpStr, MB_OK);
		goto ext;
	}
	dstptr = GlobalLock(memhandle);
	/* copy the data into the allocated memory */
	count = CopyBufferData(dstptr);

	if ( _lwrite(fd, dstptr, count) != count) {		/* don't write NULL */
	 	LoadString(hInst, MSG_CLIPBOARD, TmpStr, 128);
		ShowMesg(TmpStr);
	}
	GlobalUnlock(memhandle);
	GlobalFree(memhandle);
ext:
	_lclose(fd);
}

/***************************************************************************
*	Routine	:	DataInClipboard(void)
*	Input	:	None
*	Return	:	TRUE if there is CF_TEXT format data in clipboard else FALSE
*	Synopsis:	Check if there is any CF_TEXT format data in the clipboard
***************************************************************************/
BOOL	DataInClipboard(void)
{
	BOOL	ret_val = TRUE;

	if (OpenClipboard(hTermWnd) == 0)
		return FALSE;
	if ( ! EnumClipboardFormats(CF_TEXT)) {
		ret_val = FALSE;
	}
	CloseClipboard();
	return ret_val;
}

/***************************************************************************
*	Routine	:	CopyClipboardToLine(void)
*	Input	:	None
*	Return	:	None
*	Synopsis:	Read the clipboard text data and send it over the comm link
***************************************************************************/
void	CopyClipboardToLine(void)
{
	LPSTR	dstptr;
	HANDLE	memhandle;
	WORD	count;

	if (OpenClipboard(hTermWnd) == 0) {
		return;
	}
	if ( ! EnumClipboardFormats(CF_TEXT))
		return;
	if ((memhandle = GetClipboardData(CF_TEXT)) == 0)
		return;
	dstptr = GlobalLock(memhandle);
	count = lstrlen(dstptr);

	SendChars(dstptr, count);
	GlobalUnlock(memhandle);
	CloseClipboard();
}

/***************************************************************************
*	Routine	:	
*	Input	:	
*	Return	:	
*	Synopsis:	
***************************************************************************/
void	CopyClipboardToFile(void)
{
	LPSTR	dstptr;
	HANDLE	memhandle;
	WORD	count;
	int		fd;

	CurFileName[0] = NULL;

	if ( ! GetSaveFilePathName(hMainWnd, ".", "Save clipboard to",
					TRUE, NULL, NULL))
		return;

	_lcreat (IOFilePathName, 0);

	/* Truncute if the file exists or create if not */
	if ( (fd = _lopen (IOFilePathName, READ_WRITE)) < 0) {
		LoadString(hInst, MSG_FILECREATE, &TmpStr[128], 128);
		sprintf (TmpStr, &TmpStr[128], IOFilePathName);
		ShowMesg((LPSTR)TmpStr);

		return;
	}

	if (OpenClipboard(hTermWnd) == 0)
		goto ext2;
	if ( ! EnumClipboardFormats(CF_TEXT))
		goto ext;
	if ((memhandle = GetClipboardData(CF_TEXT)) == 0)
		goto ext;
	dstptr = GlobalLock(memhandle);
	count = lstrlen(dstptr);

	if ( _lwrite(fd, dstptr, count) != count) {
		LoadString(hInst, MSG_CLIPBOARD, TmpStr, 128);
		ShowMesg(TmpStr);
	}
	GlobalUnlock(memhandle);
ext:
	CloseClipboard();
ext2:
	_lclose(fd);
}

/***************************************************************************
*	Routine	:	CopyClipboardToTerminal(void)
*	Input	:	None
*	Return	:	None
*	Synopsis:	Read the clipboard data if existing and copy call emulation
***************************************************************************/
void	CopyClipboardToTerminal(void)
{
	LPSTR	dstptr;
	HANDLE	memhandle;
	WORD	count;

	if (OpenClipboard(hTermWnd) == 0) {
		return;
	}
	if ( ! EnumClipboardFormats(CF_TEXT))
		return;
	if ((memhandle = GetClipboardData(CF_TEXT)) == 0)
		return;
	dstptr = GlobalLock(memhandle);
	count = lstrlen(dstptr);

	Emulation(dstptr, count);
	GlobalUnlock(memhandle);
	CloseClipboard();
}
/***************************************************************************
*	Routine	:	CheckForClipboardData
*	Input	:	None
*	Return	:	TRUE if clipboard has some text
*	Synopsis:	
***************************************************************************/
BOOL	CheckForClipboardData(void)
{
	BOOL result;

	if (OpenClipboard(hMainWnd) == 0)
		return FALSE;

	result = EnumClipboardFormats(CF_TEXT);

	CloseClipboard();

	if ( result )
		return TRUE;
	return FALSE;
}
/**********************   Last  line  *************************************/
