/****************************************************************************
 * Filename   : session.c
 * Purpose    : This file contains the functions related to connecting and
 *              handling the session related activities.
 ****************************************************************************/

#include 	<windows.h>
#include 	<dde.h>

#include	"mew.h"
#include	"session.h"
#include	"main.h"
#include	"fnkey.h"
#include	"time.h"
#include 	"status.h"
#include	"file.h"
#include	"config.h"
#include	"scroll.h"
#include	"emlncons.h"
#include	"emlntype.h"
#include	"emlnfuns.h"
#include	"emlndata.h"
#include	"kbd.h"
#include	"term.h"
#include	"looks.h"
#include	"dlgbox.h"
#include	"wstdio.h"

HWND	SetFocusBackWnd;

PbkEntryType	PbkEntry = {
	{ "Default", NULL, NULL, NULL, NULL, NULL, 
	DEF_CONNECT_TIME, DEF_RETRY_COUNT, DEF_RETRY_WAIT},
	{19200, NOPARITY, 8, ONESTOPBIT, 0, 200, 1, "COM1"},
	{ "ANSI", FALSE, FALSE, DEFAULT_TAB_STOP, TRUE, TRUE, TRUE, TRUE,
		TRUE, TRUE, FALSE, DEF_CHARS_IN_LINE, DEF_LINES_IN_SCREEN, FALSE,},
	1,
};

PbkEntryType	FAR *AddrCurPbkEntry = &PbkEntry;
SesnParamsType	*TmpSesnParams;
BYTE			*SetupErr = "Phone book entry error";

/*

IMPORTANT:

	THOSE PARAMETERS WHICH ARE NOT MERE FLAGS (like CharsInLine) SHOULD
	BE CHANGED CAREFULLY, AFTER TAKING CARE OF ALL SIDE EFFECTS  !!!
*/
void	SetDefSessionInfo(void)
{
//	memset(&PbkEntry, 0, sizeof(PbkEntryType));

	lstrcpy(SNPRMS.Name, NULL_STRING); // NULL_STRING = ""
	lstrcpy(SNPRMS.Description, NULL_STRING);
	lstrcpy(SNPRMS.Script, NULL_STRING);
	lstrcpy(SNPRMS.PhoneNumber, NULL_STRING);
	lstrcpy(SNPRMS.XtraMdmCmd, NULL_STRING);
	lstrcpy(SNPRMS.ConnectResp, NULL_STRING);
	SNPRMS.ConnectWaitTime = DEF_CONNECT_TIME;
	SNPRMS.ConnectRetryCount = DEF_RETRY_COUNT;
	SNPRMS.ConnectRetryWait = DEF_RETRY_WAIT;

	LNPRMS.BaudRate = 19200;
	LNPRMS.Parity = NOPARITY;
	LNPRMS.DataLen = 8;
	LNPRMS.StopBits = ONESTOPBIT;
//	LNPRMS.FlowControl = FLOW_RTSCTS;
	LNPRMS.BreakLen = 200;
//	LNPRMS.LineType = UART_TYPE;
	lstrcpy(LNPRMS.LineName, "COM1");
	/* Set the default protocol as Zmodem */
//	PbkEntry.Protocol;

	/*  Init default Terminal setup */
	SetTermDefaultCfg(); // +251 emuln.c
//	if ( ! CreatingPbkEntry)
//		DisplaySessionStatus();  +240 status.c
}

/****************************************************************************
 * Function   : Connect (void)
 * Purpose    : connects to the selected communication type.
 ****************************************************************************/
BOOL
Connect (void)
{
	return TRUE;
}

/****************************************************************************
 * Function   : DisConnect (void)
 * Purpose    : disconnects the selected communication link and invalidates
 *				the current line handle.
 ****************************************************************************/
BOOL

/* Init Protocol to Zmodem. also copy the default Zmodem Params */

DisConnect (void)
{
	return TRUE;
}

/****************************************************************************
 * Function   : ChangeConfigParams (void)
 * Purpose    : changes the configuration of the device once it is connected.
 ****************************************************************************/
BOOL
ChangeConfigParams (void)
{
	return TRUE;
}

/****************************************************************************
 * Function   : SendBreak (void)
 * Purpose    : Sends the break on the selected line for the specified time.
 ****************************************************************************/
void
SendBreak(void)
{
		return;
}

/*##########################################################################*/
/*------------------------ CONNECT TIMER FUNCTIONS -------------------------*/
/*##########################################################################*/

static	WORD	ConnectTimerID;
#define	CONNECT_TIMER_INT		1000		/* one second timer */

FARPROC	ConnectTimerFn;

BOOL
CreateConnectTimer (void)
{
	ConnectTimerFn = MakeProcInstance (ConnectTimer, hInst);
	if (! (ConnectTimerID = SetTimer(NULL, NULL, CONNECT_TIMER_INT, ConnectTimerFn)))
		return FALSE;
	return TRUE;
}

void
DestroyConnectTimer (void)
{
	if (ConnectTimerID)
		KillTimer (NULL, ConnectTimerID);
	FreeProcInstance (ConnectTimerFn);
}

WORD FAR PASCAL
ConnectTimer (HWND hWnd, WORD wMsg, int nIDEvent, DWORD dwTime)
{
	HDC		hDc;
	char	buf[40];

	if (++ConTime.second == 60) {
		ConTime.second = 0;
		if (++ConTime.minute == 60) {
			ConTime.minute = 0;
			if (++ConTime.hour == 24) {
				ConTime.hour = 0;
			}
		}
	}
	if (! ShowTimeWnd)
		return FALSE;
	hDc = GetDC (hTimeWnd);
	FormatAsciiTime (&ConTime, buf, TIME_NORMAL);
	DrawStatusWinText(hDc, (LPRECT) &TimeFields[CONTIME_FLD_IDX],
			(LPSTR)buf, FALSE);
	ReleaseDC (hTimeWnd, hDc);
	return TRUE;
}

/***************************************************************************
 *	Routine	:	ProcessFileName (BYTE *ptr, BYTE *ext)
 *	Input	:	
 *	Return	:	
 *	Synopsis:	Check a file name. returns false if \ or ? or * is present.
 *				if name + extension format is not 8 + 3 then also false is
 *				returned
 ***************************************************************************/
BOOL	ProcessFileName (BYTE *ptr, BYTE *ext)
{
	int		count;

	for (count = 0; (count < 8) && *ptr && (*ptr != '.'); count++) {
		if ( (*ptr == '?') || (*ptr == '*') || (*ptr == '\\') )
			return FALSE;
		ptr++;
	}
	if ( ! *ptr) {
		/* addexten, return true */
		AddExtn (ptr, ext);
		return TRUE;
	}
	if ( *ptr == '.')
		ptr++;
	else
		return FALSE;
	for (count = 0; (count < 3) && *ptr; count++)
		ptr++;
	if (*ptr)
		return FALSE;
	else
		return TRUE;
}

/***************************************************************************
 *	Routine	:	TerminateSession(void)
 *	Input	:	
 *	Return	:	
 *	Synopsis:	Terminates a session. A new session can be loaded after this
 ***************************************************************************/
void	TerminateSession(void)
{
}
/***************************************************************************
 *	Routine	:	InitiateSession(void)
 *	Input	:	
 *	Return	:	
 *	Synopsis:	Called after loading a session.
 ***************************************************************************/
BOOL
InitiateSession(BOOL exec_script, BOOL load_only)
{

	ChangeEmulationType(TRMPRMS.TermName);

	/* check if entry has new lines in screen */
	if (LinesInScreen != TRMPRMS.LinesInScreen)
		ChangeScreenHeight(TRMPRMS.LinesInScreen);
	/* Check if entry has a different CharsInLine */
	if (CharsInLine != TRMPRMS.CharsInLine)
		ChangeScreenWidth(TRMPRMS.CharsInLine);
										// must check for term type
	EmlnClearScreen();					// clear the emulation screen
	DisplaySessionStatus();				// update the status displays

	return TRUE;
}

