/****************************************************************************
 * Filename   : term.h
 * Purpose    : This file contains the prototype declarations for term.c.
 ****************************************************************************/
#define		TERM_POLL_TIMER		50			/* 50 ms poll time */
#define		TERM_BORDER			(6)		//6
/* Ids for the Terminal Settings dialog box Controls */
#define		IDC_TRM_80			3200
#define		IDC_TRM_132			3201
#define		IDC_TRM_H24			3205
#define		IDC_TRM_H25			3206
#define		IDC_TRM_TSEDIT		1400
#define		IDC_TRM_ECHO		3000
#define		IDC_TRM_FOCUR		3001
#define		IDC_TRM_CRLF		3002
#define		IDC_TRM_AUTOMARG	3003
#define		IDC_TRM_BS_CH		3004
#define		IDC_TRM_BS_ERASE	3005
#define		IDC_TRM_BS_WRAP		3006
#define		IDC_TRM_LF_STRIP	3007
#define		IDC_TRM_EMUL_LBX	1500

#define		NAME_LEN			8

typedef struct tagFileList {
	BYTE name[NAME_LEN + 1];
} FileListType;

extern	FileListType	*TrmList;	/* The terminal names list */
extern	char	*TermSpec;	/* terminal emuln files spec */

/* prototype declarations for term.c */
int		CreateTermWnd (HWND hParentWnd, HANDLE hInstance);
void	ReadAndDisp(void);
void	WritePort(BYTE ch);
void	WriteNchars ( LPSTR pointer, WORD count);
int 	FAR PASCAL TermDlgProc (HWND hDlg, unsigned message, WORD wParam, LONG lParam);
extern	void	CompactFileList(FileListType *flist, BYTE indx);
FileListType	*MakeFileList (char *DirPathName, char *FileSpec);
BOOL	ChangeScreenWidth (BYTE clms);
BOOL	ChangeScreenHeight (BYTE ros);
void	DumpStr (LPSTR Buf, int Count);
int	SendChars(BYTE FAR *ptr, WORD count);
void	SendStartWanTalkPacket(int PortNumber);
void	SendStartMuxInitPacket(void);
void	SendMuxResetCommand(void);
void	WarmRebootRouter(void);
BOOL	CheckExitSequence(char rcvchar);
void	SendSetDTRPacket(BOOL Set);

