/*----------------------------------------------------------------------------
*	File		:	WINDISP.H
*	Purpose		:	Terminal emulation display related prototypes
*	Package		:	MultiExpress (Windows) - Version 1.00
*	Authors		:	Vidy
*	Date		:	21st December 1991.
*---------------------------------------------------------------------------*/

extern	WORD	CurHideCnt;				/* number of HideCaret calls */


/*	functions defined in WINDISP.C	*/

extern	WORD	GetCursorPosition(void);
extern	void	SetCursorPosition(WORD position);
extern	void	CreateTermCursor(WORD position);
extern	void	DestroyTermCursor(void);
extern	void	EraseCursor(void);
extern	void	ReDrawCursor(void);
extern	void	DrawCursorIfInView(void);
extern	void	StoreLine(char *ptr);
extern	void	ClearLine(char *ptr);
extern	void	ScrlDispBuff(void);
extern	WORD	GetCursorType(void);
extern	void	SetCursorType(WORD cursor_type);
extern	void	ClearScreen(void);
extern	void	ScrollWinUp(BYTE x1, BYTE y1, BYTE x2, BYTE y2, BYTE n, BYTE attr);

extern	void	HideCur(void);
extern	void	UnHideCur(void);
extern	void	PutChar(BYTE chr);
extern	void	PutStr(BYTE *str);
extern	void	DispChar(BYTE ch, BYTE attrib, WORD cnt);
extern	void	DispStr(BYTE *str_ptr, BYTE attrib);
extern	void	WriteChar(BYTE ch);
extern	void	AdvanceCur(void);
extern	int		GetString(BYTE *str, WORD max_len);
extern	void	FlushKeyBoardBuffer(void);
extern	void	SpeakerOn(WORD freq_divisor);
extern	void	SpeakerOff(void);
extern	void	SaveIncomingChar(BYTE ch);
extern	void	SettingFocus(void);
extern	void	LoosingFocus(void);
extern	void	PaintTermBackGnd(void);

extern	void	DisplayCursor (void);
extern	void	RemoveCursor (void);
