/* TFTPCOMP.C -- Has code that calls compression routine to compress source 
** 				  binary file to a compressed destination file.
** NOTE: This replaces old code (now in TFTPCOMP.LZW) and uses the
**		   newer LZW with variable bits compression method.
** 23, Feb, 1996
** Sanjay S.
*/

#include <stdio.h>
#include "tftp.h"
#include "types.h"
#include "..\lzvc.h"

#define MAX_READ_SIZE (8 * 1024)
#define MAX_UNCOMP_SIZE (10 * 1024)

/* --Globals--------------------------------------------------------------- */
/* Note that buffer size used is 8K same as in the command port version
** for download. Change this and the amount of compression changes.
*/
static char ReadBuf[MAX_READ_SIZE];
static char CompBuf[MAX_UNCOMP_SIZE];

/* --Local Prototypes------------------------------------------------------ */
static void LZWCompressToFile(FILE *sfp, FILE *dfp);
unsigned short change_endian(unsigned short num);
unsigned long ltl_endian_word (unsigned long num) ; /* Jo */

/* --Code------------------------------------------------------------------ */
int TFTPCompress (unsigned char SourceFile[], unsigned char DestFile[])
{
	FILE *InputFile, *OutputFile ;


	InputFile = fopen (SourceFile, "rb") ;
	if (InputFile == NULL)
	{
		return -1 ;
	}

	OutputFile = fopen (DestFile, "wb") ;
	if (OutputFile == NULL)
	{
		fclose (InputFile) ;
		return -1 ;
	}

	LZWCompressToFile (InputFile, OutputFile) ;

	fclose (InputFile) ;
	fclose (OutputFile) ;

	return 0 ;
}


static void LZWCompressToFile (FILE *sfp, FILE *dfp)
{
	char *bptr ;
	unsigned short nread, comp_size, size_to_write ;

	while (nread = fread (ReadBuf, sizeof (ReadBuf[0]), sizeof (ReadBuf), sfp))
	{
		comp_size = LZ15VCompressBuf (ReadBuf, nread, CompBuf,
																	sizeof (CompBuf)) ;
		if (comp_size == 0 || comp_size == nread)
		{
			// Incompressible -- write out original data
			comp_size = nread ;
			bptr = ReadBuf ;
			size_to_write = change_endian (-comp_size) ;
		}
		else
		{
			bptr = CompBuf ;
			size_to_write = change_endian (comp_size) ;
		}
		fwrite (&size_to_write, sizeof (size_to_write), 1, dfp) ;
		fwrite (bptr, sizeof (char), comp_size, dfp) ;
	}
}

unsigned short change_endian (unsigned short num)
{
	unsigned short num2 ;
	unsigned char *str1, *str2 ;


	str1 = (unsigned char *) &num ;
	str2 = (unsigned char *) &num2 ;
	str2[0] = str1[1] ;
	str2[1] = str1[0] ;
	return num2 ;
}

unsigned long ltl_endian_word (unsigned long num)
{
	unsigned long num2 ;
	BYTE *str ;
	BYTE *str2 ;
	str = (BYTE *) &num ;
	str2 = (BYTE *) &num2 ;
	if ((int) sizeof (num) == (int) 4)
	{
		str2[3] = str[0] ;
		str2[2] = str[1] ;
		str2[1] = str[2] ;
		str2[0] = str[3] ;
	}
	else
	{ 
		str2[0] = str[1] ;
		str2[1] = str[0] ;
	}
	return num2 ;
}
