#include <memory.h>
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
/* Jo 11/01/99 */
#include <stdlib.h>
#include <malloc.h>
#include <winsock.h>

#include "tftp.h"
#include "tftpglob.h"
#include "tftpif.h"
#include "types.h"

#define MAJOR_VERSION	1
#define MINOR_VERSION	1
#define WSA_MAKEWORD(x,y)	((y) * 256 + (x)) /* HI:Minor, LO:Major */

char WinsockDLL[] = "WINSOCK.DLL" ;
int VersionRequested = WSA_MAKEWORD (MAJOR_VERSION, MINOR_VERSION) ;
int LastError ;
unsigned long InitialTimeout = INITIAL_TIMEOUT ;
unsigned int NumberOfRetries = RETRANSMISSIONS ;

extern char LastTFTPErrorMsg[] ;

/* Jo 11/01/99  Made changes for autodetection */
/* The same socket calls will be used for TFTP and for UDP broadcasts
during autodetection */

struct hostent *host_info ;
extern unsigned short change_endian(unsigned short num) ;  /* Jo */
unsigned long ltl_endian_word (unsigned long num) ; /* Jo */
void UnInitTFTP () ;
int not_a_duplicate_entry (SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS], 
								char mac_address_string[16], int number_of_entries) ;

int InitSocket (int value, char host_ip_address[16])
{
	WSADATA wsaData ;
   int option_value = 1, ret, name_len = 50 ;
	struct sockaddr_in LocalSocket ;
	char name_buff[50] ;
	int ncounter = 0;
	char name[5];

   WinsockHandle = LoadLibrary (WinsockDLL) ;
   if (WinsockHandle < HINSTANCE_ERROR)
	   return LOAD_LIBRARY_FAILED ;

   if ((DWSAStartup = GetProcAddress (WinsockHandle, "WSAStartup")) == NULL)
   	return GET_PROC_FAILED ;
  	if ((DWSACleanup = GetProcAddress (WinsockHandle, "WSACleanup")) == NULL)
     	return GET_PROC_FAILED ;
	if ((Dsocket = GetProcAddress (WinsockHandle, "socket")) == NULL)
     	return GET_PROC_FAILED ;
   if ((Dclosesocket = GetProcAddress (WinsockHandle, "closesocket")) ==
  															NULL)
      return GET_PROC_FAILED ;
	if ((Dsendto = GetProcAddress (WinsockHandle, "sendto")) == NULL)
      return GET_PROC_FAILED ;
   if ((Drecvfrom = GetProcAddress (WinsockHandle, "recvfrom")) == NULL)
      return GET_PROC_FAILED ;
   if ((DWSAGetLastError = GetProcAddress (WinsockHandle,
										"WSAGetLastError")) == NULL)
      return GET_PROC_FAILED ;
   if ((DWSAAsyncSelect = GetProcAddress (WinsockHandle,
									"WSAAsyncSelect")) == NULL)
      return GET_PROC_FAILED ;
   if ((Dbind = GetProcAddress (WinsockHandle, "bind")) == NULL)
      return GET_PROC_FAILED ;
/* Jo */

   if ((Dgethostname = GetProcAddress (WinsockHandle, "gethostname")) == NULL)
      return GET_PROC_FAILED ;

   if ((Dgethostbyname = GetProcAddress (WinsockHandle, "gethostbyname")) == NULL)
      return GET_PROC_FAILED ;

   if ((Dgetsockname = GetProcAddress (WinsockHandle, "getsockname")) == NULL)
      return GET_PROC_FAILED ;

   if ((Dsetsockopt = GetProcAddress (WinsockHandle, "setsockopt")) == NULL)
      return GET_PROC_FAILED ;

	if (((FARPROC) fpSetSockOptRtn = GetProcAddress (WinsockHandle, "SETSOCKOPT")) == NULL)
			return (GET_PROC_FAILED);

	if (((FARPROC) fpRecvFromRtn = GetProcAddress(WinsockHandle, "RECVFROM")) == NULL)
			return (GET_PROC_FAILED);
/* Jo */

   if ((Dntohs = GetProcAddress (WinsockHandle, "ntohs")) == NULL)
      return GET_PROC_FAILED ;
   if ((Dntohl = GetProcAddress (WinsockHandle, "ntohl")) == NULL)
      return GET_PROC_FAILED ;
   if ((Dhtons = GetProcAddress (WinsockHandle, "htons")) == NULL)
      return GET_PROC_FAILED ;


	ret = DWSAStartup (VersionRequested, &wsaData) ;
	if (ret != 0)
   {
   	FreeLibrary (WinsockHandle) ;
	   return ret ;
   }

	if (!value)
	{
		TFTPClientSocket = Dsocket (PF_INET, SOCK_DGRAM, 0) ;
		if (TFTPClientSocket == INVALID_SOCKET)
		{
			LastError = DWSAGetLastError() ;
	      FreeLibrary (WinsockHandle) ;
			return LastError ;
		}

		memset (&LocalSocket, 0, sizeof (LocalSocket)) ;
		LocalSocket.sin_family = PF_INET ;

		ret = Dbind (TFTPClientSocket, (struct sockaddr FAR *) &LocalSocket,
   													 sizeof (LocalSocket)) ;
		if (ret != 0)
		{
			LastError = DWSAGetLastError() ;
	      FreeLibrary (WinsockHandle) ;
			return LastError ;
		}
	}
	else
	{
		UDPClientSocket = Dsocket (PF_INET, SOCK_DGRAM, 0) ;
		if (UDPClientSocket == INVALID_SOCKET)
		{
			LastError = DWSAGetLastError() ;
			return LastError ;
		}

		if ((*fpSetSockOptRtn)(UDPClientSocket, SOL_SOCKET, SO_BROADCAST,
					(char *) &option_value, sizeof(int)) == SOCKET_ERROR)
		{
			LastError = DWSAGetLastError() ;
			return LastError ;
		}
		// Client Socket, take any port
		memset (&UDPLocalSocket, 0, sizeof (UDPLocalSocket)) ;

		UDPLocalSocket.sin_family = PF_INET ;
		UDPLocalSocket.sin_addr.s_addr = 0 ;
		UDPLocalSocket.sin_port = 0 ;

		ret = Dbind (UDPClientSocket, (struct sockaddr FAR *) &UDPLocalSocket,
   												 sizeof (UDPLocalSocket)) ;
		if (ret == SOCKET_ERROR)
		{
			LastError = DWSAGetLastError() ;
			return LastError ;
		}

/* Get host address */
		ret = Dgethostname ((char FAR * )name_buff, name_len) ;
		if (ret == SOCKET_ERROR)
		{
			LastError = DWSAGetLastError() ;
			return LastError ;
		}
		(struct hostent FAR *)host_info = (struct hostent FAR *) Dgethostbyname ((const char FAR *)name_buff) ;
		if (host_info == NULL)
		{
			LastError = DWSAGetLastError() ;
			return LastError ; 
		}
		else
		{
			strcpy(host_ip_address, "\0") ;
			while (ncounter != host_info->h_length)
			{
				itoa((int)host_info->h_addr_list[0][ncounter] & 0xff, name, 10) ;
				if(strlen(name) == 1)
				{
					name[2] = name[0] ;
					name[1] = name[0]= '0' ;
				}
				if(strlen(name) == 2)
				{
					name[2] = name[1] ;
					name[1] = name[0] ;
					name[0] = '0' ;
				}
				name[3] = '\0' ;
				strcat(host_ip_address, name) ;
				ncounter++ ;
				if (ncounter < host_info->h_length)
					strcat(host_ip_address, ".") ;
			}
#if 0
		sprintf(host_ip_address, "%03d.%03d.%03d.%03d", );
#endif
	
		}
	}
	return 0 ;
}

/* Jo 11/1/99 */
int FAR PASCAL _loadds UDPInitSocket (int value, char host_ip_address[16]) 
{
	int return_value ;

	if (TFTPClientState != STATE_NOOP)
	{
		DWSACleanup() ;
   	FreeLibrary (WinsockHandle) ;
	}
	return_value = InitSocket(value, host_ip_address)	;
	if (return_value != 0)
	{
		Dclosesocket (UDPClientSocket) ;
		DWSACleanup() ;
      FreeLibrary (WinsockHandle) ;
	}
	return return_value ;
}

void FAR PASCAL _loadds UnInitUDP()
{
	Dclosesocket (UDPClientSocket) ;
	DWSACleanup() ;
   FreeLibrary (WinsockHandle) ;
	return ;
}


int InitTFTP ()
{
	int ret ;

	ret = DWSAAsyncSelect (TFTPClientSocket, MainWindowHandle, 
												WM_TFTP, FD_READ) ;
	if (ret == -1)
	{
		LastError = DWSAGetLastError() ;
		return -1 ;
	}

	TFTPInited = 1 ;
	return 0 ;
}



void UnInitTFTP ()
{
	Dclosesocket (TFTPClientSocket) ;
	DWSACleanup() ;

	TFTPInited = 0 ;
	TFTPClientState = STATE_NOOP ;
   FreeLibrary (WinsockHandle) ;
	return ;
}


/* Jo 11/1/99 */
int FAR PASCAL _loadds StartAutoDetection (HWND WindowHandle, int *pError, 
			  unsigned long ip_address, BYTE mac_address[16], int flag) 
{
	int count, ret, i, number_of_retries = 3 ;
	UDP_DATA_PACKET_TYPE ServerDiscoverPacket ;
	char buff[100], desc_buff[25] ;
	UINT nTimerID = 0xFEFF ;

	if (!flag)
	{
		ret = DWSAAsyncSelect (UDPClientSocket, WindowHandle, 
												WM_UDP_EVENT_OCCURED, FD_READ) ;
		if (ret == SOCKET_ERROR)
		{
			*pError = DWSAGetLastError();
			return -1;
		}

		UDPSocketDstAddr.sin_family = AF_INET ;
		UDPSocketDstAddr.sin_addr.s_addr = UDP_BROADCAST ;
		UDPSocketDstAddr.sin_port = change_endian (SERVER_UDP_PORT) ;
		strcpy (desc_buff, "Discover Packet\0") ;
		ServerDiscoverPacket.packet_type = UDP_DISCOVER_PACKET_TYPE ;
	 }
	 else
	 {
		strcpy (desc_buff, "Configure Packet\0") ;
		ServerDiscoverPacket.packet_type = UDP_CONFIGURE_PACKET_TYPE ;
	 }
	 ServerDiscoverPacket.ip_address = ltl_endian_word(ip_address) ;
	 strcpy (ServerDiscoverPacket.mac_address, mac_address) ;
	 strcpy (ServerDiscoverPacket.description, desc_buff)  ;

	 count = 0 ;
	 memcpy (&buff[count++], &ServerDiscoverPacket.packet_type, sizeof(BYTE)) ;
	 memcpy (&buff[count], &ServerDiscoverPacket.ip_address, sizeof(unsigned long)) ;
	 count += sizeof (unsigned long) ;
	 memcpy (&buff[count], &ServerDiscoverPacket.mac_address, strlen(ServerDiscoverPacket.mac_address)) ;
	 count += strlen(ServerDiscoverPacket.mac_address) ;
	 memcpy (&buff[count], &ServerDiscoverPacket.description, strlen(ServerDiscoverPacket.description)) ;
	 count += strlen(ServerDiscoverPacket.description) ;
	 buff[count++]	= '\0' ;

	 if (flag)
	 {
		for (i = 0; i < number_of_retries; i++)
		{
 	 		ret = Dsendto (UDPClientSocket, (char far *)(buff), (int) count, 0,
	      	(struct sockaddr far *) &UDPSocketDstAddr, (int) sizeof(struct sockaddr)) ;

		 	if (ret == SOCKET_ERROR)			
		 	{				 
				*pError = DWSAGetLastError();
				return -1 ;
	 		}
		}
	 }
	 else
	 {
 	 	ret = Dsendto (UDPClientSocket, (char far *)(buff), (int) count, 0,
	      	(struct sockaddr far *) &UDPSocketDstAddr, (int) sizeof(struct sockaddr)) ;

		if (ret == SOCKET_ERROR)			
		{				 
			*pError = DWSAGetLastError();
			return -1 ;
	 	}
	 }
	 return 0 ;
}

#define UDP_RECEIVE_BUFFER_SIZE	512
int FAR PASCAL _loadds process_response_from_server (SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS], int *pError,
																		int *number_of_responses) 
{
	UDP_DATA_PACKET_TYPE ServerRespPacket ;
	int length, ret, number_of_retries = 2 ;
	BYTE *resp_packet, *temp_ptr ;
	struct sockaddr_in DstAddr ;

	length = sizeof(struct sockaddr_in) ;

	resp_packet = (BYTE *) malloc (UDP_RECEIVE_BUFFER_SIZE) ;
	if ( resp_packet == NULL )
  	 	return -1 ;
	ret = Drecvfrom(UDPClientSocket, (char FAR * )resp_packet, UDP_RECEIVE_BUFFER_SIZE, 0, (struct sockaddr FAR *) &DstAddr, (int FAR *)&length) ;
	if (ret == SOCKET_ERROR)
	{ 
		free(resp_packet) ;
		*pError = DWSAGetLastError();
		return -1 ;
	}
	temp_ptr = resp_packet ;
	ServerRespPacket.packet_type = *temp_ptr ;
	temp_ptr++ ;
	ServerRespPacket.ip_address = *(ULONG *)temp_ptr ;
	temp_ptr+= sizeof(ULONG) ;
	memcpy (ServerRespPacket.mac_address, temp_ptr, UDP_MAC_ADDRESS_LENGTH) ;
	ServerRespPacket.mac_address[UDP_MAC_ADDRESS_LENGTH] = '\0' ;

	switch (ServerRespPacket.packet_type)
	{
	   case UDP_DISCOVER_RESPONSE_PACKET_TYPE : 
						if (not_a_duplicate_entry (response_entries, ServerRespPacket.mac_address, *number_of_responses))
						{
							response_entries[*number_of_responses].server_ip_address = ltl_endian_word (ServerRespPacket.ip_address) ;				
							strcpy ((char *) response_entries[*number_of_responses].server_mac_address, (char *) ServerRespPacket.mac_address) ;
							*number_of_responses += 1 ;
						}
						break;
			
	   case UDP_CONFIGURE_RESPONSE_PACKET_TYPE : 
						break;
		default : break ;
	}
	if (resp_packet != NULL)
		free(resp_packet) ;
	return 0 ;
}

int not_a_duplicate_entry (SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS], 
								char mac_address_string[16], int number_of_entries)
{
	int i ;

	for (i = 0; i < number_of_entries; i++)
 	{
		if (strcmp(response_entries[i].server_mac_address, mac_address_string) == 0)
			return 0 ;
	}

	return 1 ;
}

/* Jo 11/1/99 */

/****************************************************************************
                       TFTP CLIENT STATE MACHINE
****************************************************************************/
int TFTPClientStateMachine()
{
	unsigned long SenderIPAddress ;
	int SenderProtocolPort ;
	TFTPPacketType *TFTPPacket ;
#if PROXY_SERVER
	BYTE *temp_ptr ;
#endif

	switch (TFTPClientState)
	{
		case STATE_NOOP :
			break ;

		case STATE_SEND_REQUEST :
			switch (TFTPRequest)
			{
				case TFTP_REQUEST_GET :
					TFTPFileLength = 0 ;
					TFTPBytesTransfered = 0 ;

#if PROXY_SERVER
					/* In case it is PORTSTAT.ONL, the TFTPFilePointer is set to
					the buffer pointer in TFTPGetFile */
					if (FileType != FILE_TYPE_PORT_STATUS)
#endif
						TFTPFilePointer = fopen (TFTPTempLocalFile, "wb") ;
					if (TFTPFilePointer == NULL)
						return -1 ;

					MakeFileOpenRequest (MODE_READ,
						TFTPServerIPAddress, TFTP_PROTOCOL_PORT,
							TFTPClientSocket, TFTPRemoteFile, MODE_OCTET) ;
					TFTPClientState = STATE_WAIT_FOR_DATA ;
					TFTPSequenceNumber = 1 ;
					TFTPRetryCount = NumberOfRetries ;
					TFTPSmoothedTimeout = InitialTimeout ;
					TFTPTimerCount = TFTPSmoothedTimeout ;
					break ;

				case TFTP_REQUEST_PUT :
					TFTPBytesTransfered = 0 ;

//#if PROXY_SERVER
					/* In case it is PORTSTAT.ONL, the TFTPFilePointer is set to
					the buffer pointer in TFTPGetFile */
//#endif			

					if (!strstr (TFTPTempLocalFile, "HUPANDREDIAL") || (FileType != FILE_TYPE_PORT_STATUS))
					{
						TFTPFilePointer = fopen (TFTPTempLocalFile, "rb") ;
						if (TFTPFilePointer == NULL)
							return -1 ;
					}
					MakeFileOpenRequest (MODE_WRITE,
						TFTPServerIPAddress, TFTP_PROTOCOL_PORT,
							TFTPClientSocket, TFTPRemoteFile, MODE_OCTET) ;
				if (strstr (TFTPTempLocalFile, "HUPANDREDIAL")) 
				{
					TFTPClientState = STATE_CLOSE_CONN ;
					TFTPFileTransferStatus = TFTP_FILE_TRANSFER_SUCCESSFUL ;
					return 0 ;
				}
					TFTPClientState = STATE_WAIT_FOR_ACK ;
					TFTPSequenceNumber = 0 ;
					TFTPRetryCount = NumberOfRetries ;
					TFTPSmoothedTimeout = InitialTimeout ;
					TFTPTimerCount = TFTPSmoothedTimeout ;
					break ;
			}
			break ;

		case STATE_RETRANSMIT_REQUEST :
			if (TFTPRetryCount == 0)
			{
				TFTPClientState = STATE_CLOSE_CONN ;
				TFTPFileTransferStatus = TFTP_NO_RESPONSE_FROM_TARGET ;
				return -1 ;
			}

			switch (TFTPRequest)
			{
				case TFTP_REQUEST_GET :
					MakeFileOpenRequest (MODE_READ,
						TFTPServerIPAddress, TFTP_PROTOCOL_PORT, 
							TFTPClientSocket, TFTPRemoteFile, MODE_OCTET) ;
					TFTPClientState = STATE_WAIT_FOR_DATA ;
					TFTPSequenceNumber = 1 ;
					TFTPSmoothedTimeout *= 2 ;
					TFTPTimerCount = TFTPSmoothedTimeout ;
					break ;

				case TFTP_REQUEST_PUT :
					MakeFileOpenRequest (MODE_WRITE,
						TFTPServerIPAddress, TFTP_PROTOCOL_PORT, 
							TFTPClientSocket, TFTPRemoteFile, MODE_OCTET) ;
					TFTPClientState = STATE_WAIT_FOR_ACK ;
					TFTPSequenceNumber = 0 ;
					TFTPSmoothedTimeout *= 2 ;
					TFTPTimerCount = TFTPSmoothedTimeout ;
					break ;
			}

			break ;

		case STATE_SEND_DATA :
			TFTPPacket = (TFTPPacketType*) TFTPSendBuffer ;
#if PROXY_SERVER
			/* Actually it should never come here */
			if (FileType == FILE_TYPE_PORT_STATUS)
				_fmemcpy (TFTPPacket->MessageType.FileData.BlockData,
			                            TFTPFilePointer, 512) ;
			else
#endif
			TFTPSentBufferLength = fread (
				TFTPPacket->MessageType.FileData.BlockData,
			                            1, 512, TFTPFilePointer) ;

			if (TFTPPacket->MessageType.FileData.BlockNumber > 1)
				TFTPBytesTransfered += TFTPSentBufferLength ;
			TFTPPacket->MessageType.FileData.BlockNumber = Dhtons (
													TFTPSequenceNumber) ;
			TFTPPacket->OpCode = Dhtons (OPCODE_DATA) ;
			SendDataPacket (TFTPServerIPAddress,
				ServerProtocolPort, TFTPClientSocket,
			          TFTPSendBuffer, TFTPSentBufferLength + 2 + 2) ;
			TFTPSmoothedTimeout = InitialTimeout ;
			TFTPTimerCount = TFTPSmoothedTimeout ;
			TFTPRetryCount = NumberOfRetries ;
			TFTPClientState = STATE_WAIT_FOR_ACK ;

			break ;

		case STATE_RETRANSMIT_DATA :
			TFTPPacket = (TFTPPacketType*) TFTPSendBuffer ;
			TFTPPacket->MessageType.FileData.BlockNumber = Dhtons (
													TFTPSequenceNumber) ;
			TFTPPacket->OpCode = Dhtons (OPCODE_DATA) ;
			SendDataPacket (TFTPServerIPAddress,
					ServerProtocolPort, TFTPClientSocket,
			           TFTPSendBuffer, TFTPSentBufferLength + 2 + 2) ;
			TFTPClientState = STATE_WAIT_FOR_ACK ;

			break ;

		case (STATE_WAIT_FOR_ACK) :
			if (!TFTPTimerCount)
			{
				TFTPSmoothedTimeout *= 2 ;
				TFTPTimerCount = TFTPSmoothedTimeout ;
				if (!TFTPRetryCount)
				{
					TFTPClientState = STATE_CLOSE_CONN ;
					TFTPFileTransferStatus = TFTP_NO_RESPONSE_FROM_TARGET ;
					return -1 ;
				}
				TFTPRetryCount -- ;
				if (TFTPSequenceNumber == 0)
					TFTPClientState = STATE_RETRANSMIT_REQUEST ;
				else
					TFTPClientState = STATE_RETRANSMIT_DATA ;
			}

			if (TFTPPacketReceivedFlag == 0)
				return -1 ;
			ReceiveData (&SenderIPAddress, &SenderProtocolPort,
				TFTPClientSocket, TFTPReceiveBuffer, 
							&TFTPReceivedBufferLength) ;
			ServerProtocolPort = SenderProtocolPort ;
			TFTPPacketReceivedFlag = 0 ;
			TFTPPacket = (TFTPPacketType*) TFTPReceiveBuffer ;
            if (Dntohs(TFTPPacket->OpCode) == OPCODE_ERR)
            {
	            _fstrncpy (LastTFTPErrorMsg,
					TFTPPacket->MessageType.Error.ErrorMessage, 99) ;
	            LastTFTPErrorMsg[99] = 0 ;
    	        TFTPClientState = STATE_CLOSE_CONN ;
        	    TFTPFileTransferStatus = TFTP_FILE_TRANSFER_FAILED ;
            	return -1 ;
	        }

			if ((Dntohs (TFTPPacket->OpCode) != (OPCODE_ACK)) ||
			    (Dntohs (TFTPPacket->MessageType.Ack.AckedBlockNumber) !=
														TFTPSequenceNumber))
	        {
				return -1 ;
            }

			if ((TFTPSentBufferLength < 512) && (TFTPSequenceNumber != 0))
			{
				TFTPClientState = STATE_CLOSE_CONN ;
				TFTPFileTransferStatus = TFTP_FILE_TRANSFER_SUCCESSFUL ;
				return 0 ;
			}

			TFTPSequenceNumber ++ ;
			TFTPClientState = STATE_SEND_DATA ;
			break ;

		case STATE_WAIT_FOR_DATA :
			if (TFTPTimerCount == 0)
			{
				if (TFTPRetryCount == 0)
				{
					TFTPClientState = STATE_CLOSE_CONN ;
					TFTPFileTransferStatus = TFTP_NO_RESPONSE_FROM_TARGET ;
					return -1 ;
				}
				TFTPRetryCount -- ;
				TFTPSmoothedTimeout *= 2 ;
				TFTPTimerCount = TFTPSmoothedTimeout ;
				if (TFTPSequenceNumber == 1)
				{
					TFTPClientState = STATE_RETRANSMIT_REQUEST ;
					return -1 ;
				}
			}
			if (TFTPPacketReceivedFlag == 0)
				return -1 ;

			ReceiveData (&SenderIPAddress,
				&SenderProtocolPort, TFTPClientSocket, 
					TFTPReceiveBuffer, &TFTPReceivedBufferLength) ;
			ServerProtocolPort = SenderProtocolPort ;
			TFTPPacketReceivedFlag = 0 ;
			TFTPPacket = (TFTPPacketType*) TFTPReceiveBuffer ;

	        if (Dntohs(TFTPPacket->OpCode) == OPCODE_ERR)
            {
            	_fstrncpy (LastTFTPErrorMsg,
					TFTPPacket->MessageType.Error.ErrorMessage, 99) ;
	            LastTFTPErrorMsg[99] = 0 ;
    	        TFTPClientState = STATE_CLOSE_CONN ;
        	    TFTPFileTransferStatus = TFTP_FILE_TRANSFER_FAILED ;
            	return -1 ;
	        }
			
            switch (Dntohs (TFTPPacket->OpCode))
			{
				case OPCODE_DATA :
					if ((TFTPReceivedBufferLength - 4) > 512)
						return -1 ;
					if (Dntohs (TFTPPacket->MessageType.FileData.BlockNumber)
							== TFTPSequenceNumber)
					{
#if PROXY_SERVER
					if (FileType == FILE_TYPE_PORT_STATUS)
					{
						_fmemcpy (TFTPFilePointer, TFTPPacket->MessageType.FileData.BlockData,
						  TFTPReceivedBufferLength - 4) ;
						temp_ptr = (BYTE *)TFTPFilePointer ;
						temp_ptr += TFTPReceivedBufferLength - 4 ;
						TFTPFilePointer = (FILE *)temp_ptr ;
					}
					else
#endif
						fwrite (TFTPPacket->MessageType.FileData.BlockData,
						  1, TFTPReceivedBufferLength - 4, TFTPFilePointer) ;

						if (TFTPSequenceNumber == 1)
						{
							switch (FileType)
							{
								case FILE_TYPE_CODE :
								case FILE_TYPE_CONFIG :
									memcpy (&TFTPFileHeader,
										TFTPPacket->MessageType.FileData.BlockData,
											TFTPReceivedBufferLength - 4) ;
									TFTPFileLength = Dntohl (
										TFTPFileHeader.CodeLength) ;
									TFTPBytesTransfered = 0 ;
									break ;

								case (FILE_TYPE_BOOT_CONFIG) :
									TFTPBytesTransfered = 0 ;
									TFTPFileLength = 512 ;
									break ;

								case (FILE_TYPE_USER_DATABASE) :
/* Jo 08/07/99 Changed UDB read */
									memcpy (&TFTPUDBFileHeader,	
										TFTPPacket->MessageType.FileData.BlockData,
											TFTPReceivedBufferLength - 4) ;
									TFTPFileLength = Dntohl (
										TFTPUDBFileHeader.code_length) ;
									TFTPBytesTransfered = 0 ;
									break ;

								default :
									break ;
							}
						}
						else
						{
							TFTPBytesTransfered += TFTPReceivedBufferLength -
																		4 ;
						}
					}
					else
						if (Dntohs (
							TFTPPacket->MessageType.FileData.BlockNumber) == 
								(TFTPSequenceNumber - 1))
						{
							TFTPSequenceNumber -- ;
							/* The previous ack was lost */
						}

					TFTPClientState = STATE_SEND_ACK ;
					break ;

				default :
					return -1 ;
			}
			break ;

		case STATE_SEND_ACK :
			SendAckPacket (TFTPServerIPAddress, 
				ServerProtocolPort, TFTPClientSocket, TFTPSequenceNumber) ;
			if ((TFTPReceivedBufferLength - 4) < 512) /* Last Packet */
			{
				TFTPClientState = STATE_CLOSE_CONN ;
				TFTPFileTransferStatus = TFTP_FILE_TRANSFER_SUCCESSFUL ;
			}
			else
				TFTPClientState = STATE_WAIT_FOR_DATA ;
			TFTPSequenceNumber ++ ;
			break ;

		case STATE_CLOSE_CONN :
			if (TFTPFilePointer)
			{
#if PROXY_SERVER
				if (FileType != FILE_TYPE_PORT_STATUS)
#endif
					fclose (TFTPFilePointer) ;
				TFTPFilePointer = (FILE *) NULL ;
			}

			if ((TFTPFileTransferStatus == TFTP_FILE_TRANSFER_SUCCESSFUL) &&
			    (TFTPRequest == TFTP_REQUEST_GET))
			{
#if PROXY_SERVER
				if (FileType != FILE_TYPE_PORT_STATUS)
#endif
/* Jo 08/07/99 Changed UDB read */
					if (FileType == FILE_TYPE_USER_DATABASE)
						StripTFTPHeader (TFTPTempLocalFile,
				         TFTPLocalFile, (char*) &TFTPUDBFileHeader) ;
					else
						StripTFTPHeader (TFTPTempLocalFile,
				         TFTPLocalFile, (char*) &TFTPFileHeader) ;
			}
			/* The file without the header is present in TFTPLocalFile */
#if PROXY_SERVER
				if (FileType != FILE_TYPE_PORT_STATUS)
#endif
					remove (TFTPTempLocalFile) ;

			UnInitTFTP () ;
			TFTPCompletionCode = TFTP_COMPLETE ;
			TFTPClientState = STATE_NOOP ;

			break ;
	}
	return 0 ;
}
