/****************************************************************************
  FILE     : TFTPIF.H	
  SYNOPSIS : This file contains the extern declarations of all the functions	
             that are callable from the UI. It further gives the defn. of	
             all the constants, return codes etc. shared between TFTP and	
             ROUCON. As such, this is the only file that needs to be included	
             by ROUCON to use TFTP.	
  DATE     : 13.11.95	

Jo : 13/1/99 Made changes for autodetection

****************************************************************************/

#ifndef _TFTPIF_H_

#define _TFTPIF_H_

#include "tftpdnld.h"


enum TFTP_FILE_TRANSFER_RESULT
{
	TFTP_SUCCESS = 0,
	TFTP_SOCKET_INITIALIZATION_FAILED,
	TFTP_COMPRESSION_FAILED,
	TFTP_NETWORK_SUBSYSTEM_NOT_READY,
	TFTP_VERSION_NOT_SUPPORTED,
    TFTP_INVALID_BIN_FILE,
    TFTP_LOAD_LIBRARY_FAILED,
    TFTP_GET_PROC_FAILED,
	TFTP_FAILURE = 0xFF
} ;

enum TFTP_FILE_TRANSFER_STATUS
{
	TFTP_FILE_TRANSFER_NOT_SCHEDULED = 0,
	TFTP_NO_RESPONSE_FROM_TARGET,
	TFTP_FILE_TRANSFER_IN_PROGRESS,
	TFTP_FILE_TRANSFER_SUCCESSFUL,
	TFTP_FILE_TRANSFER_FAILED = 0xFF
} ;

enum TFTP_COMPLETION_CODE_STATUS
{
	TFTP_COMPLETE = 0,
	TFTP_IN_PROGRESS,
	TFTP_NOT_SCHEDULED
} ;

#define WM_TFTP WM_USER + 25
/* Jo 09/01/99 */
#define WM_UDP_EVENT_OCCURED WM_USER + 26
/* #define AUTO_DETECTION_OVER WM_USER + 27 */
#define MAX_MAC_ADDRESS_LENGTH	 16

#define MAX_UDP_RESPONSE_WAIT 9000    /*9 secs timer*/
#define MAX_UDP_RETRY_RESPONSE_WAIT 3000    /*3 secs timer*/
#define 	AUTODETECT_TIMERID 	0xfe10
#define 	AUTODETECT_RETRY_TIMERID 	0xfe00
#define MAX_NUMBER_OF_SERVERS 15

#define UDP_DISCOVER_PACKET_TYPE 1
#define UDP_DISCOVER_RESPONSE_PACKET_TYPE 2
#define UDP_CONFIGURE_PACKET_TYPE 3
#define UDP_CONFIGURE_RESPONSE_PACKET_TYPE 4

/* Jo 09/01/99 */

#define PROXY_SERVER 1

extern "C"
{
extern enum TFTP_FILE_TRANSFER_RESULT FAR PASCAL __loadds

#if PROXY_SERVER

TFTPGetFile (char far *LocalFile, char RemoteFile[], char IPAddressString[], 
	HWND MainWindowHandle) ;

#else

TFTPGetFile (char LocalFile[], char RemoteFile[], char IPAddressString[], 
	HWND MainWindowHandle) ;

#endif

extern enum TFTP_FILE_TRANSFER_RESULT  FAR PASCAL __loadds
/* Jo 20/07/99 Changed for Default Setup */
TFTPPutFile (char LocalFile[], char RemoteFile[], char IPAddressString[], 
	HWND MainWindowHandle, TFTPCodeBurnStruct *CodeStructPtr, BYTE CommandLineArg) ;
extern void  FAR PASCAL __loadds TFTPProcess (void) ;
extern void  FAR PASCAL __loadds TFTPAbortProcess (void) ;
extern void  FAR PASCAL __loadds TFTPTimer (void) ;
extern void  FAR PASCAL __loadds AbortTFTPTransfer() ;
extern unsigned long FAR PASCAL __loadds TFTPGetFileLength() ;
extern unsigned long FAR PASCAL __loadds TFTPGetBytesTransfered() ;
extern enum TFTP_COMPLETION_CODE_STATUS FAR PASCAL __loadds 
	TFTPGetCompletionCode() ;
extern enum TFTP_FILE_TRANSFER_STATUS FAR PASCAL __loadds 
	TFTPGetFileTransferStatus() ;
extern int FAR PASCAL __loadds 
	TFTPGetLastErrorMessage (char far *ErrorMessage) ;

/* Jo 11/1/99 Functions to handle autodetection */
extern int FAR PASCAL __loadds UDPInitSocket (int value, char host_ip_address[16]) ;
extern int FAR PASCAL __loadds StartAutoDetection (HWND WindowHandle, int *pError,
					  unsigned long ip_address, BYTE mac_address[16], int flag) ; 

extern int FAR PASCAL __loadds process_response_from_server (SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS],
										int *pError, int *number_of_responses) ;
extern void FAR PASCAL __loadds UnInitUDP () ;


}

//extern enum TFTP_COMPLETION_CODE_STATUS TFTPCompletionCode ;
//extern enum TFTP_FILE_TRANSFER_STATUS TFTPFileTransferStatus ;
/* This variable keeps track of the TFTP file transfer status.
   This is absolutely necessary because any call to TFTPGetFile()
   or TFTPPutFile() will only schedule a file transfer and return.
   The completion and the success/failure of the file transfer is
   identified by looking at this variable */

//extern unsigned long TFTPFileLength, TFTPBytesTransfered ;

#endif


/****************************************************************************
	Overview of the TFTP File Transfer :
	----------------------------------
		Any application, seeking to do a TFTP file transfer needs to do the
	following :
	(a). Include the tftpif.h file.
	(b). Make a call to TFTPGetFile() or TFTPPutFile() as the case may be.
	     Having done this, the application should arrange to call TFTPTimer()
	     every 55 milliseconds and in the WindowProcedure, corresponding to
	     the Window Handle passed as a parameter to the above call, make a
		 call to TFTPProcess() on message WM_TFTP.
	(c). Note that TFTPGetFile() / TFTPPutFile() only prepare for file
	     transfer and return. The completion and result of the file transfer
	     are recorded in two globals, TFTPCompletionCode and
		 TFTPFileTransferStatus.
	     It is up to the application to detect the completion of the file
		 transfer by monitoring the two variables.

	TFTPCompletionCode : If this variable holds a non-zero value, it implies
		that file transfer is in progress. Once this variables becomes zero,
		it means that TFTP is done with the file transfer. Note that this
		variable does NOT convey the success/failure of the file transfer.

	TFTPFileTransferStatus : This variable has meaning only after
		TFTPCompletionCode becomes zero. The value reflects the result of the
		file transfer.

****************************************************************************/
