// tftpread.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "tftpread.h"
#include	"tftpif.h"
#include	"msgumain.h"
#include	"msguview.h"


extern LPCSTR MainMsgHeader ;
char TFTPMessageHeader[80] = "ProxyServer - TFTP File Transfer" ;
extern char ErrorMessage[] ;
BOOL LogTransfer;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define	FTP_READ_TIMER_ID			10			// timer id for ftp_read
#define	FTP_DLL_CLOCK_ID			11			// periodic timer for FTP dll

#define	FTP_READ_TIMER_PERIOD	1000		// one second timer
#define	FTP_DLL_CLOCK_PERIOD	55		// periodic timer for FTP dll

CHorzGauge *wndHorzReadGauge;

/////////////////////////////////////////////////////////////////////////////
// tftpread dialog


tftpread::tftpread(CWnd* pParent /*=NULL*/)
	: CDialog(tftpread::IDD, pParent)
{
	//{{AFX_DATA_INIT(tftpread)
	m_IPAddr = "";
	m_XferSize = "" ;
	m_Action = "";
	m_szRead = "";
	//}}AFX_DATA_INIT
}

void tftpread::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(tftpread)
	DDX_Text(pDX, IDC_STATIC_IP_ADDR, m_IPAddr);
	DDX_Text(pDX, IDC_STATIC_XFER_SIZE, m_XferSize);
	DDX_Text(pDX, IDC_STATIC_TFTP_READ, m_Action);
	DDX_Text(pDX, IDC_STATIC_CONFIG_READ, m_szRead);
	//}}AFX_DATA_MAP
}

LRESULT tftpread::OnTFTPReadCallBack(WPARAM wParam, LPARAM lParam)
{
	TFTPProcess() ;
	return NULL ;
}

BEGIN_MESSAGE_MAP(tftpread, CDialog)
	//{{AFX_MSG_MAP(tftpread)
	ON_WM_TIMER()
	ON_MESSAGE(WM_TFTP, OnTFTPReadCallBack)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
/////////////////////////////////////////////////////////////////////////////
// tftpread message handlers

void tftpread::OnCancel()
{
	// TODO: Add extra cleanup here
	TFTPAbortProcess() ;
	
	CDialog::OnCancel() ;
}

BOOL tftpread::OnInitDialog()
{
	char IPAddress[20] ;
	enum TFTP_FILE_TRANSFER_RESULT TFTPReadResult ;
	HWND ThisWindowHandle ;
	
	CDialog::OnInitDialog() ;
	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	if (!AbortBmpBtn.LoadBitmaps ("ABORT1", "ABORT2", "ABORT3", "ABORT4"))
		AfxMessageBox ("Failed to load ABORT bitmap");

	VERIFY (AbortBmpBtn.SubclassDlgItem (IDCANCEL, this));
	AbortBmpBtn.SizeToContent();

	GetWindowText (CurrentHeading, 80) ;
   m_Action = "Reading Configuration. Please wait..." ;
	m_szRead = "Configuration size (in bytes) : " ;

	// Now "Configuration Read" and "User Data Base Read"
	// share the same Dialog
	if (!strcmpi (TFTPGetRemoteFileName, "USER.DTB"))
	{
		strcpy (CurrentHeading, "ProxyServer - User Data Base") ;
	   m_Action = "Reading User Data Base. Please wait..." ;
		strcpy (TFTPMessageHeader, "ProxyServer - User Data Base Transfer") ;
	}
	else
		if (strstr (TFTPGetRemoteFileName, "PORT")
				|| strstr (TFTPGetRemoteFileName, "SCRIPT"))
		{
			strcpy (CurrentHeading, "ProxyServer - Script") ;
		   m_Action = "Reading Script. Please wait..." ;
			strcpy (TFTPMessageHeader, "ProxyServer - Script") ;
			m_szRead = "Script size (in bytes) : " ;
		}

	if (!strcmp (TFTPGetRemoteFileName, "events.log"))
	{
		LogTransfer = TRUE;
		strcpy (CurrentHeading, "ProxyServer - Log") ;
		m_Action = "Reading Log. Please wait...";
		strcpy (TFTPMessageHeader, "ProxyServer - Log") ;
		m_szRead = "Log size (in bytes) : " ;
	}

	SubHeadingPointer = strchr (CurrentHeading, (int) '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	// TODO: Add extra initialization here
	//Read the TFTP address in string form
	if (GetPrivateProfileString ((LPCSTR) "Port Setup",
			(LPCSTR) "Router IP Address",	(LPCSTR) "", (LPSTR) IPAddress,
				sizeof (IPAddress), (LPCSTR) OwnIniFile) <= 0)
	{
		CDialog::OnCancel() ;
	}

	m_IPAddr = IPAddress ;

	// create a gauge for read
	wndHorzReadGauge = new (CHorzGauge) ;        
   CRect rc ;

	GetDlgItem (IDC_STATIC_RECT)->GetWindowRect (&rc) ;
	ScreenToClient (&rc);

   wndHorzReadGauge->Create ((CWnd *) this, rc) ;
   wndHorzReadGauge->SetGaugeInfo ("", 0, 100, 
		  GU_ELEVATED, GU_DEPRESSED, TRUE, FALSE, FALSE, 
						RGB(0xff, 0xff, 0xff), RGB(0x80, 0x80, 0x80), 
							RGB(0, 0, 0xff), RGB(0xc0, 0xc0, 0xc0), 
								RGB(0, 0, 0)) ;

	// create a timer to check if read is over and also
	if (FTP_READ_TIMER_ID != SetTimer (FTP_READ_TIMER_ID,
														FTP_READ_TIMER_PERIOD, NULL))
		goto Exit2 ;

	// Call the TFTP DLL to start a get operation of configuration
	if (FTP_DLL_CLOCK_ID != SetTimer (FTP_DLL_CLOCK_ID,
													FTP_DLL_CLOCK_PERIOD, NULL))
		goto Exit1 ;

	ThisWindowHandle = GetSafeHwnd() ; // Sachin 27.11.95
	if ((TFTPReadResult = TFTPGetFile (TFTPGetLocalFileName,
				TFTPGetRemoteFileName, IPAddress,
					ThisWindowHandle)) != TFTP_SUCCESS)
	{
		KillTimer (FTP_DLL_CLOCK_ID) ;
Exit1:
		KillTimer (FTP_READ_TIMER_ID) ;
Exit2:
		wndHorzReadGauge->DestroyGauge() ;
		delete wndHorzReadGauge ;
		switch (TFTPReadResult)
		{
			case TFTP_SOCKET_INITIALIZATION_FAILED :
				RouMsgBox (MSG_TFTP_SOCKET_INIT_FAILED,
						TFTPMessageHeader, MB_OK | MB_ICONSTOP) ;
				break ;

			case TFTP_COMPRESSION_FAILED :
				RouMsgBox (MSG_TFTP_COMPRESSION_FAILED,
						TFTPMessageHeader, MB_OK | MB_ICONSTOP) ;
				break ;

			case TFTP_NETWORK_SUBSYSTEM_NOT_READY :
				RouMsgBox (MSG_TFTP_NO_DLL_SUPPORT,
						TFTPMessageHeader, MB_OK | MB_ICONSTOP) ;
				break ;

			case TFTP_VERSION_NOT_SUPPORTED :
				RouMsgBox (MSG_TFTP_NO_VERSION_SUPPORT,
						TFTPMessageHeader, MB_OK | MB_ICONSTOP) ;
				break ;

			case TFTP_LOAD_LIBRARY_FAILED :
				RouMsgBox (MSG_TFTP_WINSOCK_DLL_NOT_FOUND,
						TFTPMessageHeader, MB_OK | MB_ICONSTOP) ;
				break ;

			case TFTP_GET_PROC_FAILED :
				RouMsgBox (MSG_TFTP_REQD_FUNCTIONS_NOT_FOUND,
							TFTPMessageHeader, MB_OK | MB_ICONSTOP) ;
				break ;

			case TFTP_FAILURE :
            TFTPGetLastErrorMessage (ErrorMessage) ;
            DisplayMessage (ErrorMessage, TFTPMessageHeader,
						MB_OK | MB_ICONSTOP) ;
				break ;

			default :
				break ;
		}
		CDialog::OnCancel() ;
		return TRUE ;
	}

	UpdateData (FALSE) ;
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

unsigned long ReadTotalSize = 0 ;
unsigned long ReadCurrentSize = 0 ;
enum TFTP_FILE_TRANSFER_STATUS ReadTFTPStatus ;
enum TFTP_COMPLETION_CODE_STATUS ReadTFTPComplete ;

void tftpread::OnTimer (UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default

	int FileTransferPercentage ;

	if (nIDEvent == FTP_READ_TIMER_ID)
   {
		// this is around a second timer
		// get the CurrentSize and total size
		// display progress

		ReadTotalSize = TFTPGetFileLength() ;
		ReadCurrentSize = TFTPGetBytesTransfered() ;

		if (ReadTotalSize)
      		{
			//if ( ! strlen(m_XferSize))  This gives problems
         		{
				char Buf[20] ;
				ultoa (ReadTotalSize, Buf, 10) ;
				m_XferSize = Buf ;
				UpdateData (FALSE) ;
			}

			FileTransferPercentage = (int) ((ReadCurrentSize * 100L)
																	/ ReadTotalSize) ;
			wndHorzReadGauge->UpdateProgress (FileTransferPercentage) ;
		}
		else
      		{
				// Sachin 29.11.95
				char Buf[20] ;
				strcpy (Buf, "unknown") ;
				if (LogTransfer)
					strcpy (Buf, "N.A") ;
				m_XferSize = Buf ;
				UpdateData (FALSE) ;
				wndHorzReadGauge->UpdateProgress(0) ;

		}
		//ReadCurrentSize += 5;
		// if xfer done close Gauge and dialog

		ReadTFTPComplete = TFTPGetCompletionCode() ; // Sachin 27.11.95
		ReadTFTPStatus = TFTPGetFileTransferStatus() ; // Sachin 27.11.95
		
		 // Sachin 27.11.95
		if (ReadTFTPComplete == TFTP_COMPLETE)
		{
			// Because Total size is initially set to 0
			// at the end of a read (successful or otherwise we must 
			// destroy the gauge)
			wndHorzReadGauge->DestroyGauge();
			delete wndHorzReadGauge;
			KillTimer(FTP_READ_TIMER_ID);
			KillTimer(FTP_DLL_CLOCK_ID);
			CDialog::OnOK();
			
			switch (ReadTFTPStatus)
			{
				case TFTP_NO_RESPONSE_FROM_TARGET :
					RouMsgBox (MSG_TFTP_NO_RESPONSE_FROM_TARGET,
							TFTPMessageHeader, MB_OK | MB_ICONINFORMATION) ;
               break ;

				case TFTP_FILE_TRANSFER_FAILED :
               TFTPGetLastErrorMessage (ErrorMessage) ;
               if (ErrorMessage[0] != 0)
               {
                  DisplayMessage (ErrorMessage,
							TFTPMessageHeader, MB_OK | MB_ICONINFORMATION) ;
                  break ;
               }
					RouMsgBox (MSG_TFTP_FILE_TRANSFER_FAILURE,
						TFTPMessageHeader, MB_OK | MB_ICONINFORMATION) ;
               break ;

            default :
               break ;
			}
         // Next three lines have been put by Sachin (5.1.96)...... Check up
         // This is because Configuration program should stop in case of a
         // TFTP-Read-Configuration_failure.
         if (ReadTFTPStatus != TFTP_FILE_TRANSFER_SUCCESSFUL)
         {
            CDialog::OnTimer (nIDEvent) ;
            CDialog::OnCancel() ;
            return ;
         }
		}
	} 
   else
	{
		if (nIDEvent == FTP_DLL_CLOCK_ID)
			TFTPTimer() ;
	}
	
	CDialog::OnTimer(nIDEvent) ;
}

int tftpread::DisplayMessage (char *Message, LPCSTR Header, int Opts)
{
	int	Ret_val ;

 	Ret_val = MessageBox (Message, Header, Opts) ;
	return Ret_val ;
}

int tftpread::RouMsgBox (int StrId, LPCSTR Header, int Opts)
{
	CString Message ;
	int Ret_val ;
	char NewHeader[50] ;

	Message.LoadString (StrId) ;
	ModifyHeader (Header, (LPCSTR) &NewHeader[0]) ;
	Ret_val = MessageBox (Message, (LPCSTR) &NewHeader[0], Opts) ;
	return Ret_val ;
}
