// upgrade.h : header file
//
/////////////////////////////////////////////////////////////////////////////
// CUPGrade dialog

class CUPGrade : public CDialog
{
// Construction
public:
	CUPGrade(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CUPGrade)
	enum { IDD = IDD_UPGRADE };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CUPGrade)
	afx_msg void OnDestroy();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef	ULONG
#define	ULONG 	unsigned long 
#define	USHORT 	unsigned short 
#define	BYTE 		unsigned char 
#define	DWORD 	unsigned long
#define	NULL 		0
#endif

typedef struct CNF_UPGRADE_IP_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_ports ;  
      ULONG    default_gateway ;
      BYTE     dns_enabled ;
      ULONG    primary_address ;
      ULONG    secondary_address ;
} CNF_UPGRADE_IP_HEADER ;

typedef struct CNF_UPGRADE_IP_PORT_STRUCT {
      BYTE  isp_assigns_address ;
      BYTE  bootp ;
      ULONG ip_address ;
      ULONG subnet_mask ;
} CNF_UPGRADE_IP_PORT ;

typedef struct CNF_UPGRADE_IP_STRUCT {
     CNF_UPGRADE_IP_HEADER ip_header ;
     CNF_UPGRADE_IP_PORT ip_ports[4] ;
} CNF_UPGRADE_IP ;

typedef struct CNF_UPGRADE_PPP_PORT_STRUCT {
      BYTE     enabled ;
   	BYTE		user_name[128] ;
   	BYTE		user_password[128] ;
      BYTE     connection_dod ;
      USHORT   hangup_time ; 
      BYTE     ip ;
      BYTE     authentication_type ;

      CNF_PPP_OPTION   lcp_accm ;
      CNF_PPP_OPTION   remote_lcp_accm ;
      CNF_PPP_OPTION   lcp_mru ;   
      CNF_PPP_OPTION   remote_lcp_mru ;   
      CNF_PPP_OPTION   remote_lcp_authentication ;   
      CNF_PPP_OPTION   lcp_magic_number ;   
      CNF_PPP_OPTION   remote_lcp_magic_number ;   
      CNF_PPP_OPTION   ipcp_ip_address ;   
      CNF_PPP_OPTION   remote_ipcp_ip_address ;   
      CNF_PPP_OPTION   lcp_epd ;
      CNF_PPP_OPTION   remote_lcp_epd ;
      CNF_PPP_OPTION   lcp_mrru ;
      CNF_PPP_OPTION   remote_lcp_mrru ;
      CNF_PPP_OPTION   remote_lcp_callback ;
      CNF_PPP_OPTION   ipcp_dns_address1 ;
      CNF_PPP_OPTION   ipcp_dns_address2 ;
} CNF_UPGRADE_PPP_PORT ;

typedef struct CNF_UPGRADE_PPP_STRUCT {
   	CNF_PPP_HEADER	   ppp_header ;
   	CNF_UPGRADE_PPP_PORT_STRUCT   ppp_ports[3] ;
} CNF_UPGRADE_PPP ;

typedef struct CNF_UPGRADE_PROXY_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_ports ; 
      BYTE     enabled ;
		BYTE     proxy_any_app ;
} CNF_UPGRADE_PROXY_HEADER ;

typedef struct CNF_UPGRADE_PROXY_STRUCT {
      CNF_UPGRADE_PROXY_HEADER           		proxy_header ;
	   CNF_PROXY_APPLICATION      				proxy_application[1] ;
		CNF_PROXY_USER_DEFINED_APPLICATION    	proxy_user_defined_application[1] ;
      CNF_PROXY_VIRTUAL_SERVER   				proxy_virtual_server[1] ;
      CNF_PROXY_FILTER           				proxy_filter[1] ; 
      CNF_PROXY_PORT             				proxy_ports[4] ;
} CNF_UPGRADE_PROXY ;

typedef struct CNF_UPGRADE_DHCP_HEADER_STRUCT {
      USHORT   magic_number ;
      USHORT   section_length ;
      USHORT   number_of_address_range_entries ;
      BYTE     dhcp_server_enabled ;
} CNF_UPGRADE_DHCP_HEADER ;

typedef struct CNF_UPGRADE_DHCP_STRUCT {
      CNF_UPGRADE_DHCP_HEADER_STRUCT	dhcp_header ;
      CNF_DHCP_ADDRESS_RANGE    dhcp_address_range_entries[1] ;
} CNF_UPGRADE_DHCP ;
