/*----------------------------------------------------------------------------
	Module  : USERSADD.CPP
	Author  : CHETAN
	Project : REMOTE ACCESS DATABASE
----------------------------------------------------------------------------*/

// usersadd.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "userdata.h"
#include "usersadd.h"
#include "usersdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

char *UserPorts[] = {
		"WAN Port1",
		"WAN Port2",
		"WAN Port3",
		"WAN Port4",
		"WAN Port5",
		"WAN Port6",
		"WAN Port7",
		"WAN Port8",
		"WAN Port9",
		"WAN Port10",
		"WAN Port11",
		"WAN Port12",
		"WAN Port13",
		"WAN Port14",
		"WAN Port15"
		"WAN Port16"
		"WAN Port17"
		"WAN Port18"
		"WAN Port19"
		"WAN Port20"
		"WAN Port21"
		"WAN Port22"
		"WAN Port23"
} ;

/////////////////////////////////////////////////////////////////////////////
// CUsersAddDlg dialog


CUsersAddDlg::CUsersAddDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUsersAddDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUsersAddDlg)
	m_szUserName = "";
	m_szUserPassword = "";
	m_szCallBackNum = "";
	m_bProtocolIP = FALSE;
	m_bProtocolIPX = FALSE;
	m_bProtocolSpTree = FALSE;
	m_bCallBackEnabled = FALSE;
	m_bActionEdit = FALSE;
	m_nCallBackDelay = 10;
	m_bAdminCallBack = FALSE;
	//}}AFX_DATA_INIT
}

void CUsersAddDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUsersAddDlg)
	DDX_Control(pDX, IDC_CHECK_ADMIN_CALL_BACK, m_chkAdminCallBack);
	DDX_Control(pDX, IDC_STATIC_SECS_HDR, m_StatSecsHdr);
	DDX_Control(pDX, IDC_CALL_BACK_DELAY_HDR, m_StatCallBackDelayHdr);
	DDX_Control(pDX, IDC_USER_CALL_BACK_NUM_HDR, m_StatCallBackNumHdr);
	DDX_Control(pDX, IDC_EDIT_CALL_BACK_DELAY, m_CallBackDelayEditWnd);
	DDX_Control(pDX, IDC_DIAL_OUT_PORTS_LIST, m_LBoxDialOutPorts);
	DDX_Control(pDX, IDC_DIAL_IN_PORTS_LIST, m_LBoxDialInPorts);
	DDX_Control(pDX, IDC_CALL_BACK_CHECK, m_chkCallBack);
	DDX_Control(pDX, IDC_SP_TREE_CHECK, m_chkSpTree);
	DDX_Control(pDX, IDC_IPX_PROT_CHECK, m_chkIPX);
	DDX_Control(pDX, IDC_IP_PROT_CHECK, m_chkIP);
	DDX_Control(pDX, IDC_CALL_BACK_NUM_EDIT, m_CallBackNumWnd);
	DDX_Control(pDX, IDC_EDIT_USER_PASSWORD, m_UserPasswordWnd);
	DDX_Control(pDX, IDC_EDIT_USER_NAME, m_UserNameEditWnd);
	DDX_Text(pDX, IDC_EDIT_USER_NAME, m_szUserName);
	DDX_Text(pDX, IDC_EDIT_USER_PASSWORD, m_szUserPassword);
	DDX_Text(pDX, IDC_CALL_BACK_NUM_EDIT, m_szCallBackNum);
	DDX_Check(pDX, IDC_IP_PROT_CHECK, m_bProtocolIP);
	DDX_Check(pDX, IDC_IPX_PROT_CHECK, m_bProtocolIPX);
	DDX_Check(pDX, IDC_SP_TREE_CHECK, m_bProtocolSpTree);
	DDX_Check(pDX, IDC_CALL_BACK_CHECK, m_bCallBackEnabled);
	DDX_Text(pDX, IDC_EDIT_CALL_BACK_DELAY, m_nCallBackDelay);
	DDV_MinMaxUInt(pDX, m_nCallBackDelay, 0, 255);
	DDX_Check(pDX, IDC_CHECK_ADMIN_CALL_BACK, m_bAdminCallBack);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUsersAddDlg, CDialog)
	//{{AFX_MSG_MAP(CUsersAddDlg)
	ON_BN_CLICKED(IDC_CALL_BACK_CHECK, OnCallBackCheck)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_CHECK_ADMIN_CALL_BACK, OnCheckAdminCallBack)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CUsersAddDlg message handlers

BOOL CUsersAddDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, sizeof (CurrentHeading)) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	// The Window Header says "Add"
	// But while Editing, Edit Flag is Set
	// Using this condition the Window is made to show "Edit"
	// Also Disable User Name Window	while "Edit"

	if (m_bActionEdit)	
	{
		SubHeadingPointer = strchr (CurrentHeading, (int) '(') ;
		SubHeadingPointer ++ ;
		*SubHeadingPointer = 0x00 ;
		strcat (CurrentHeading, "Edit)") ;

		m_UserNameEditWnd.EnableWindow (FALSE) ;
	}

	// Change to Product Name
	ModifyHeader (CurrentHeading, WindowHeader) ;
	SetWindowText (WindowHeader) ;

	// Limit the Text Length in the Edit windows
	m_UserNameEditWnd.LimitText (USER_NAME_LEN - 1) ;
	m_UserPasswordWnd.LimitText (USER_PASSWORD_LEN - 1) ; 
	m_CallBackNumWnd.LimitText (USER_CALL_BACK_NUM_LEN - 1) ;

 	CUsersDlg *pParent = (CUsersDlg *) GetParent() ;

	USERDATA *pUserData ;

	if (m_bActionEdit)
	{
 		int nSelUserIndex = pParent->m_LBoxForUserNames.GetCurSel() ;

	 	// Get the Pointer to User Structure
 		pUserData = (USERDATA *)
				  pParent->m_LBoxForUserNames.GetItemDataPtr (nSelUserIndex) ;

		// Assign Class Data members with data members of Data Structure
		FillClassFields (pUserData) ; 

		PutPortsInListBox (m_LBoxDialInPorts, pUserData->DialInPortMask) ;
		PutPortsInListBox (m_LBoxDialOutPorts, pUserData->DialOutPortMask) ;
		m_UserPasswordWnd.SetFocus() ;
	}
	else
	{
		// While Adding an User, Enable all ports for him
		PutPortsInListBox (m_LBoxDialInPorts, (DWORD) 0xFFFF) ;
		PutPortsInListBox (m_LBoxDialOutPorts, (DWORD) 0xFFFF) ;

		// While Adding an User, Enable all protocols for him

/* Jo 29/06/99 Protocol is always IP */
//		GetFromProtocolMask ((BYTE) 0xFF) ;

		// Disable Call Back Facility for the user
		m_bCallBackEnabled = FALSE ;
		m_chkCallBack.SetCheck (0) ;
		m_chkCallBack.EnableWindow (FALSE) ;
		m_StatCallBackDelayHdr.EnableWindow (FALSE) ;
		m_StatSecsHdr.EnableWindow (FALSE) ;
		m_StatCallBackNumHdr.EnableWindow (FALSE) ;
		m_CallBackDelayEditWnd.EnableWindow (FALSE) ;
		m_CallBackNumWnd.EnableWindow (FALSE) ;
		
		m_UserNameEditWnd.SetFocus() ;
	}

	// Fill all the control windows with data
	UpdateData (FALSE) ;

	return FALSE ;  // return TRUE  unless you set the focus to a control
}

void CUsersAddDlg::FillClassFields (USERDATA *pUser) 
{
	if (pUser->CallBackEnabled)
	{
		m_chkAdminCallBack.SetCheck (1) ;
		m_bAdminCallBack = TRUE ;
	}
	else
	{
		m_chkAdminCallBack.SetCheck (0) ;
		m_bAdminCallBack = FALSE ;
	}

	if (pUser->CallBackSecurity)
	{
		m_chkCallBack.SetCheck (1) ;
		m_bCallBackEnabled = TRUE ;
	}
	else
	{
		m_chkCallBack.SetCheck (0) ;
		m_bCallBackEnabled = FALSE ;
	}

/* Jo 29/06/99 Protocol is always IP */
	// This is for Protocol fields
//	GetFromProtocolMask (pUser->ProtocolMask) ;

	OnCheckAdminCallBack() ;

	m_szUserName = pUser->UserName ;
	m_szUserPassword = pUser->UserPassword ;

	m_szCallBackNum = pUser->CallBackNumber ;
	m_nCallBackDelay = pUser->CallBackDelay ;

	return ;
}

void CUsersAddDlg::GetFromProtocolMask (BYTE Mask) 
{
	m_bProtocolIP = (Mask & (BYTE) 0x01) ? TRUE : FALSE ; 
	m_bProtocolIPX = (Mask & (BYTE) 0x02) ? TRUE : FALSE ;
	m_bProtocolSpTree = (Mask & (BYTE) 0x04) ? TRUE : FALSE ;

	if (m_bProtocolIP)
		m_chkIP.SetCheck (1) ;
	else
		m_chkIP.SetCheck (0) ;

	if (m_bProtocolIPX)
		m_chkIPX.SetCheck (1) ;
	else
		m_chkIPX.SetCheck (0) ;

	if (m_bProtocolSpTree)
		m_chkSpTree.SetCheck (1) ;
	else
		m_chkSpTree.SetCheck (0) ; 

	return ;
}

void CUsersAddDlg::PutPortsInListBox (CListBox &CPortsBox, DWORD dwMask)
{
	int nNumWANPorts ;
	BOOL bSetSelection ;
	BOOL IsDialinPort = FALSE;
	if (CPortsBox.GetDlgCtrlID() == IDC_DIAL_IN_PORTS_LIST)
		IsDialinPort = TRUE;	

	// NumberOfPorts is a UINT global
	// that is initialized to 2
	// Then it is reassigned by reading
	// BootConfigHeader in ROUCON.CPP
	// For IP Port and For COM Port in
	// USERSCOM.CPP
	nNumWANPorts = (int) (NumberOfPorts - 1) ;

	CPortsBox.ResetContent() ;
	////For ProxyServer, WAN1 is not added both in the dialin & dialout port
	////list boxes
/* Jo 30/09/99 Include WAN1 */
	for (int index = 0 ; index < nNumWANPorts ; index ++)
		CPortsBox.AddString (UserPorts[index]) ;

	for (index = 0 ; index <= nNumWANPorts ; index ++)
	{////Prabha 30/3/98, On Proxy, we don't permit dial-in or dial-out 
	 ////on WAN1, exclude when index = 0
		bSetSelection = ((dwMask) & ((DWORD) ((DWORD) 0x0001 << index))) ?
												TRUE : FALSE ;
		// Set selection based on mask
		CPortsBox.SetSel (index, bSetSelection) ;
	}
}

void CUsersAddDlg::OnOK()
{
	// TODO: Add extra validation here

	if (!UpdateData (TRUE))
		return ;

	if (!m_bActionEdit)
	{
		// Check for Empty User Name
		if (!ValidUserName())
		{
			MessageBox ((LPCSTR) "Invalid User name",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONINFORMATION) ;
			m_UserNameEditWnd.SetFocus() ;
			return ;
		}

		// duplicate User not allowed
		if (DuplicateUserName())
		{
			MessageBox ((LPCSTR) "Duplicate user name",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONINFORMATION) ;
			m_UserNameEditWnd.SetFocus() ;
			return ;
		}
	}

	if (m_bAdminCallBack && m_bCallBackEnabled)
	{
		if (m_szCallBackNum.IsEmpty())
		{
			MessageBox ("With CallBack security enabled, CallBack\
number is a must", "Users - Info", MB_OK | MB_ICONINFORMATION) ;
			m_CallBackNumWnd.SetFocus() ;
			return ;
		}
	}

	// In case of insufficient memory
	if (!FillStructureFields())
	{
		PostMessage (WM_COMMAND, IDCANCEL) ;
		return ; 
	}

	CUsersDlg *pParent = (CUsersDlg *) GetParent() ;
	pParent->m_bDBaseChanged = TRUE ;
	
	CDialog::OnOK();
}

BOOL CUsersAddDlg::DuplicateUserName (void)
{
	CUsersDlg *pParent = (CUsersDlg *) GetParent() ;
	if (pParent->m_LBoxForUserNames.FindStringExact (-1, m_szUserName)
																					!= LB_ERR)
		return TRUE ;

	return FALSE ;
}

BOOL CUsersAddDlg::FillStructureFields (void) 
{
	USERDATA *pUserData ;
 	CUsersDlg *pParent = (CUsersDlg *) GetParent() ;

	if (m_bActionEdit)
	{
	 	int nSelUserIndex = pParent->m_LBoxForUserNames.GetCurSel() ;

 		// Get the Pointer to User Structure
	 	pUserData = (USERDATA *)
				  pParent->m_LBoxForUserNames.GetItemDataPtr (nSelUserIndex) ;
	}
	else
	{
		pUserData = (USERDATA *) new USERDATA ;
		if (pUserData == NULL)
		{
			MessageBox ((LPCSTR) "Insufficient memory",
				(LPCSTR) "Users - Add", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
		int nIndex = pParent->m_LBoxForUserNames.AddString (m_szUserName) ;
		pParent->m_LBoxForUserNames.SetItemDataPtr (nIndex, pUserData) ;
	}
	
//   CopyCStringToBuffer (pUserData->UserName, m_szUserName) ;
//   CopyCStringToBuffer (pUserData->UserPassword, m_szUserPassword) ;
	lstrcpy ((LPSTR) pUserData->UserName, (LPCSTR) m_szUserName) ;
	lstrcpy ((LPSTR) pUserData->UserPassword, (LPCSTR) m_szUserPassword) ;

/* Jo 29/06/99 Protocol is always IP */
	// Protocol variable
//	pUserData->ProtocolMask = FormProtocolMask() ;

	// Port variables
	pUserData->DialInPortMask = FormPortsMask (m_LBoxDialInPorts) ;
	pUserData->DialOutPortMask = FormPortsMask (m_LBoxDialOutPorts) ;

	// Call Back variables
	pUserData->CallBackEnabled = m_bAdminCallBack ? 0x01 : 0x00 ;
	pUserData->CallBackSecurity = m_bCallBackEnabled ? 0x01 : 0x00 ;
	pUserData->CallBackDelay = m_nCallBackDelay ;
//   CopyCStringToBuffer (pUserData->CallBackNumber, m_szCallBackNum) ;
	lstrcpy ((LPSTR) pUserData->CallBackNumber, (LPCSTR) m_szCallBackNum) ;

	return TRUE ;
}

#if 0
void CUsersAddDlg::CopyCStringToBuffer (char *pBuf, CString &CStr) 
{
	int nLength = CStr.GetLength() ;

	for (int index = 0 ; index < nLength ; index ++, pBuf ++)
		*pBuf = CStr.GetAt (index) ;

	*pBuf = 0x00 ;
	return ;
}
#endif

BYTE CUsersAddDlg::FormProtocolMask (void) 
{
	BYTE Mask = 0x00 ;
	Mask |= ((m_bProtocolIP) ? 0x01 : 0x00) ;
	Mask |= ((m_bProtocolIPX) ? 0x02 : 0x00) ;
	Mask |= ((m_bProtocolSpTree) ? 0x04 : 0x00) ;
	return Mask ;
}

DWORD CUsersAddDlg::FormPortsMask (CListBox &cList)
{
	int nNumSelected = cList.GetSelCount() ;
	int *pSelected, *pTemp ;
	int index ;

	pSelected = (int *) new int [nNumSelected + 1] ;
	cList.GetSelItems (nNumSelected, (LPINT) pSelected) ;
 
	DWORD Mask = 0x0000 ;

	for (index = 0, pTemp = pSelected ;
				index < nNumSelected ; index ++, pTemp ++)
	{
/* Jo 30/09/99 Include WAN1 */
		Mask |= (DWORD) ((DWORD) 0x0001 << (*pTemp)) ;
	}

	delete [] pSelected ;
	return Mask ;
}

void CUsersAddDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CUsersAddDlg::OnCallBackCheck()
{
	// TODO: Add your control notification handler code here
	if (!UpdateData (TRUE))
		return ;

	BOOL fEnable = m_bAdminCallBack && m_bCallBackEnabled ;
	m_CallBackDelayEditWnd.EnableWindow (fEnable) ;
	m_CallBackNumWnd.EnableWindow (fEnable) ;
	m_StatSecsHdr.EnableWindow (fEnable) ;
	m_StatCallBackNumHdr.EnableWindow (fEnable) ;
	m_StatCallBackDelayHdr.EnableWindow (fEnable) ;

	UpdateData (FALSE) ;
	return ;
}


BOOL CUsersAddDlg::ValidUserName()
{
	int nLength ;

	nLength = m_szUserName.GetLength() ;

	// If user name is empty 
	if (nLength == 0)
		return FALSE ;

	// First strip off leading blanks
	char c ;
	int i ;
	
	for (i = 0 ; i < nLength ; )
	{
		c = m_szUserName.GetAt (i) ;
		if (c != ' ')
			break ;
		i ++ ;
	}

	// If only blanks
	if (i == nLength)
		return FALSE ;

	// The new user name without leading blanks
	char szName[USER_NAME_LEN] ;
	strcpy (szName, (LPCSTR) m_szUserName) ;
	m_szUserName = szName +	i ;

	strcpy (szName, (LPCSTR) m_szUserName) ;
	nLength = m_szUserName.GetLength() ;

	// Track the trailing blanks
	char *pszName = szName + nLength - 1 ;
	while (*pszName == ' ')
		pszName -- ;
	*(pszName + 1) = 0x00 ;

	// User name without trailing blanks
	m_szUserName = szName ;
	nLength = m_szUserName.GetLength() ;

	// No blanks in the name allowed
	for (i = 0 ; i < nLength ; i ++)
	{
		c = m_szUserName.GetAt (i) ;
		if (c == ' ')
			return FALSE ;
	}
	return TRUE ;
}		
	

void CUsersAddDlg::OnHelp()
{
	// TODO: Add your control notification handler code here

	AfxGetApp()->WinHelp (0x20000 + IDD_USER_ADD_OR_EDIT_DIALOG, HELP_CONTEXT);
}

void CUsersAddDlg::OnCheckAdminCallBack()
{
	// TODO: Add your control notification handler code here
	if (!UpdateData (TRUE))
		return ;

	m_chkCallBack.EnableWindow (m_bAdminCallBack) ;
	OnCallBackCheck() ;

	UpdateData (FALSE) ;
	return ;
}
