// userscom.cpp : implementation file

// Date Last Modified:  24 Nov 1999     
// Modifications   : 
    
// Jo 20/07/99     : Reboot only if we are not doing Wizard Setup
// Jo 29/06/99 	 :	Modified for UDB read and write. 
// Jo 24 Nov 1999. : UDB header length was sent as 512 instead of 
//						   64 and so all the other headers, script etc residing in 
//						   that 8k sector was overwritten.
//---------------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "com.h"
#include "compress.h"
#include "locport.h"
#include "boot.h"
#include "usersdlg.h"
#include "cnfread.h"
#include "msgumain.h"
#include "msguview.h"
#include "userscom.h"
#include "userdata.h"
#include "reboot.h"
#include "dialdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

DWORD UDBDnldAddress ;
extern CommandLineArgument ;
 
/////////////////////////////////////////////////////////////////////////////
// CUsersComDlg dialog


CUsersComDlg::CUsersComDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUsersComDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUsersComDlg)
	m_bTargetFound = FALSE;
	m_bRouterUp = FALSE;
	exitcount = 0;
	//}}AFX_DATA_INIT
}

void CUsersComDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUsersComDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUsersComDlg, CDialog)
	//{{AFX_MSG_MAP(CUsersComDlg)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CUsersComDlg message handlers

BOOL CUsersComDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here
	CenterWindow() ;

	OnReadDbaseYes() ;
	UpdateData (FALSE) ;
	return TRUE;  // return TRUE  unless you set the focus to a control
}



void CUsersComDlg::OnReadDbaseYes()
{
	// TODO: Add your control notification handler code here

	CString WindowHeader ;
	GetWindowText (WindowHeader) ;

	// Open COM port for communication
	if (!cUsersCom.Open_Comm())
	{
		RouMsgBox (MSG_COM_ERR_OPEN, (LPCSTR) WindowHeader,
													MB_OK | MB_ICONSTOP) ;
		CDialog::OnCancel() ;
		return ;
	}

	// Dial the Router if the Dial string is present.
	if (!Connect())
	{
		RouMsgBox (MSG_COM_ERR_CONNECT, (LPCSTR) WindowHeader,
														MB_OK | MB_ICONSTOP) ;
		CDialog::OnCancel() ;
		return ;
	}

	// Get the Router ID
	GetRouterStatus() ;
	if (!m_bTargetFound || !m_bRouterUp)
	{	// For now this message
		::MessageBox (GetParent()->GetSafeHwnd(), (LPCSTR) "ProxyServer not found",
						(LPCSTR) "COM Port - Read", MB_OK | MB_ICONSTOP) ;
		CDialog::OnCancel() ;
		return ;
	}

	// Get the number of LAN and WAN Ports
   if (!GetTheNumOfPorts())
	{	// For now this message
		::MessageBox (GetParent()->GetSafeHwnd(), (LPCSTR) "Ports Info. not found",
							(LPCSTR) "COM Port - Read", MB_OK | MB_ICONSTOP) ;
		CDialog::OnCancel() ;
		return ;
	}

	// Get the Compressed User DBase into "USER.DTB"
	// If the version is "v2.00", the UDB is not compressed
	// so just copy it
	char UDB_version[20] ;		// Space for UDB version string
	if (!GetComprDBase ((LPSTR) &UDB_version[0]))
	{	// For now this message
		::MessageBox (GetParent()->GetSafeHwnd(), (LPCSTR) "User Info. not found",
							(LPCSTR) "COM Port - Read", MB_OK | MB_ICONSTOP) ;
		CDialog::OnCancel() ;
		return ;
	}
	KillTimer (PollingTimerID) ;

	// UnCompress the DBase File into "USER.TMR"
	if (!ExpandDbase())
	{	// For now this message
		::MessageBox (GetParent()->GetSafeHwnd(), (LPCSTR) "UDB File not found",
							(LPCSTR) "File - Read", MB_OK | MB_ICONSTOP) ;
		CDialog::OnCancel() ;
		return ;
	}

	CUsersDlg cUsers (this) ;
	int nRetVal = cUsers.DoModal() ;

	if (nRetVal == IDCANCEL)
	{
		Disconnect() ;
		cUsersCom.Close_Comm() ;
		remove (UDBUnCompressedDBaseFile) ;
		CDialog::OnCancel() ;
		return ;
	}
	else
	{	  
		if (!WriteDBase())
		{	// For now this message
			::MessageBox (GetParent()->GetSafeHwnd(), (LPCSTR) "UDB File not found",
						(LPCSTR) "File - Write", MB_OK | MB_ICONSTOP) ;
			remove (UDBUnCompressedDBaseFile) ;
			CDialog::OnCancel() ;
			return ;
		}
		remove (UDBUnCompressedDBaseFile) ;
		Disconnect() ;
// Jo 20/07/99 Reboot only if we are not doing Wizard Setup
		if (CommandLineArgument != 3)
			Reboot() ;
		cUsersCom.Close_Comm() ;
		CDialog::OnCancel() ;
		return ;
	}
}


BOOL CUsersComDlg::Connect()
{
	char szBuf[50] ;
	CString m_InitString, m_InitResponse, m_DialString, m_ConnectResponse ;

	GetPrivateProfileString (LPortSectionHeader, DialString,
						(LPCSTR) "ATDP", (LPSTR) szBuf, sizeof (szBuf),
									(LPCSTR) OwnIniFile) ;
	m_DialString = szBuf ;

	// Direct Connection - Hence, Dial String Empty
	// Or Data Carrier Detected
	if (m_DialString.IsEmpty() || cUsersCom.IsDCDPresent())
		return TRUE ;

	// Dial the Router.
	UINT nTimerID = 100 ;
	char mdm_init_string[50] ;
	char mdm_resp[30] ;
		
	char *tmp ;

	CDialDlg cDialDlg (AfxGetMainWnd()) ;
	GetPrivateProfileString (LPortSectionHeader, InitString,
						(LPCSTR) "ATS0=1&E5", (LPSTR) szBuf, sizeof (szBuf),
							(LPCSTR) OwnIniFile) ;
	m_InitString = szBuf ;

	m_InitString += "^M" ;
	tmp = m_InitString.GetBuffer (50) ;
	cUsersCom.ConvertControls ((BYTE *) mdm_init_string, (BYTE *) tmp) ;
	m_InitString.ReleaseBuffer() ;

	GetPrivateProfileString (LPortSectionHeader, InitRespString,
						(LPCSTR) "OK", (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) OwnIniFile) ;
	m_InitResponse = szBuf ;
	tmp = m_InitResponse.GetBuffer (30) ;
	cUsersCom.ConvertControls ((BYTE *) mdm_resp, (BYTE *) tmp) ;
	m_InitResponse.ReleaseBuffer() ;

	cUsersCom.TimeOut = FALSE ;
	while (nTimerID != SetTimer (nTimerID, (UINT) 5000, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
								(LPCSTR) NULL, MB_RETRYCANCEL)) 
		{
				SendMessage (WM_CLOSE) ;
				goto Error_Exit ;
		}
	}

	// send modem init string and look for response
	cUsersCom.snd_mdm_command ((BYTE *) mdm_init_string, 
												strlen (mdm_init_string)) ;
	if (!cUsersCom.rcv_mdm_response ((BYTE *) mdm_resp, 
													(BOOL *) &cUsersCom.TimeOut))
	{
		// timeout occured and no response
		KillTimer (nTimerID) ;	
		RouMsgBox (MSG_PWN_NO_MDM_RESP, (LPCSTR) NULL, MB_OK | MB_ICONSTOP) ;	
		SendMessage (WM_CLOSE) ;	
		goto Error_Exit ;
	}

	KillTimer (nTimerID) ;

	// Modem initialized successfully now send the dial string.
	char mdm_dial_string[30] ;
	char mdm_connect_resp[30] ;

	m_DialString += "^M" ;
	tmp = m_DialString.GetBuffer (30) ;
	cUsersCom.ConvertControls ((BYTE *) mdm_dial_string, (BYTE *) tmp) ;
	m_DialString.ReleaseBuffer() ;

  	GetPrivateProfileString (LPortSectionHeader, ConnectString,
						(LPCSTR) "CONNECT", (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) OwnIniFile) ;
	m_ConnectResponse = szBuf ;
	tmp = m_ConnectResponse.GetBuffer (30) ;
	cUsersCom.ConvertControls ((BYTE *) mdm_connect_resp, (BYTE *) tmp) ;
	m_ConnectResponse.ReleaseBuffer() ;

	cUsersCom.TimeOut = FALSE ;
	nTimerID = 101 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) 45000, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
								(LPCSTR) NULL, MB_RETRYCANCEL)) 
		{
				SendMessage (WM_CLOSE) ;
				goto Error_Exit ;
		}
	}

	// Send the dial string and wait for connect response.
	cUsersCom.snd_mdm_command ((BYTE *) mdm_dial_string,
													strlen (mdm_dial_string)) ;
	if (!cUsersCom.rcv_mdm_response ((BYTE *) mdm_connect_resp, 
														(BOOL *) &cUsersCom.TimeOut))
	{
			KillTimer (nTimerID) ;
			UINT nTimerID = 102 ;
			cUsersCom.TimeOut = FALSE ;
			char mdm_hangup[2] ;

			while (nTimerID != SetTimer (nTimerID, (UINT) 2000, NULL))
			{
				if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
									(LPCSTR) NULL, MB_RETRYCANCEL)) 
				{
					SendMessage (WM_CLOSE);
					goto Error_Exit ;
				}
			}

			mdm_hangup[0] = 0x1b ;
			mdm_hangup[1] = 0 ;
			cUsersCom.hangup_mdm (mdm_hangup, (BOOL *) &cUsersCom.TimeOut) ;
			KillTimer (nTimerID) ;
 	}       
 	else 
 	{
 		KillTimer (nTimerID) ;
		cDialDlg.DestroyWindow() ;
 		return TRUE ;
 	}
Error_Exit :
	cDialDlg.DestroyWindow() ;
	return FALSE ;
}

void CUsersComDlg::GetRouterStatus()
{
	ReqType Request ;
	ResultType OpenConn ;
	int nRetry = 0 ;

	LED_Flash_Count = 0 ;	// Initialize the counter for LED flashing.
	Go_on = 1 ;					// Initialize to read char from COM port.
	CTRL_FLAG = 0 ;		 	// Initialize control to be with Timer routine.

   KillTimer (PollingTimerID) ; 	// Kill any previous Timer with this ID.

	// Set the timer for polling.
   while (PollingTimerID != SetTimer (PollingTimerID,
										   	(UINT) PollingInterval, NULL))
	{
      if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
		 						 	NULL, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
			 return ;    
		}
	}


	Request.Ptype = QUERY_BRIDGE_NAME ;		// 13

RETRY :

	cUsersCom.TimeOut = FALSE ;

	UINT nTimerID = 104 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) 4000, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
					(LPCSTR) NULL, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			return ;     
		}
	}

	while (TRUE)
	{
		cUsersCom.snd_packet ((BYTE *) &Request.Ptype, sizeof (Request)) ;
		if (!(cUsersCom.rcv_packet ((BYTE *) &OpenConn,
				sizeof (OpenConn), (BOOL *) &cUsersCom.TimeOut)))
		{
			break ;    // No CRC error
		}
	}
 
   KillTimer (nTimerID) ;
	m_bTargetFound = !cUsersCom.TimeOut ;
 
	if (!cUsersCom.TimeOut)
	{
		if(OpenConn.Ptype == RES_TYPE)		// 12
		{
			WORD ErrCode ;
			ErrCode = cUsersCom.ltl_endian_word (OpenConn.ErrorCode) ;
			switch (ErrCode)
			{
				case ERR_ROUTER_UP :
					m_bRouterUp = TRUE ;	 // Router is up
					break ;

				default :					 // Router not running
					break ;  
			}
		}
	}
	else
	{
		nRetry ++ ;
		if (nRetry <= 3)
			goto RETRY ;
	}
}

											 
BOOL CUsersComDlg::GetTheNumOfPorts()
{
	CTRL_FLAG = 0 ;
	BootConfigType SystemInfo ;
	ReadLocReqType RequestLocation ;
	ReadLocRespType RespondLocation ;
	int nRetry = 0 ;

	RequestLocation.Ptype =	READ_REQ_TYPE ;
	RequestLocation.Length = sizeof (BootConfigType) ;
 	RequestLocation.Address = cUsersCom.little_endian (
														(DWORD) FL_BOOT_HDR) ; 

RETRY :
	cUsersCom.TimeOut = FALSE ;

	UINT PortsTimerID = 110 ;
	while (PortsTimerID != SetTimer (PortsTimerID, (UINT) 4000, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
								(LPCSTR) NULL, MB_RETRYCANCEL)) 
		{
				SendMessage (WM_CLOSE) ;
				return FALSE ;
		}
	}

	while (TRUE)
	{
		cUsersCom.snd_packet ((BYTE *) &RequestLocation,
													sizeof (ReadLocReqType)) ;
		if (!cUsersCom.rcv_packet ((BYTE *) &RespondLocation,
						sizeof (RespondLocation), (BOOL *) &cUsersCom.TimeOut))
		{
			break ;  // No CRC error
		}
	}
	KillTimer (PortsTimerID) ;
		
	if (!cUsersCom.TimeOut)
	{
 		if (RespondLocation.ErrCode != 0)
			return FALSE ;

		memcpy (&SystemInfo, RespondLocation.buffer, sizeof (BootConfigType)) ;

		NumberOfPorts = SystemInfo.NumberOfPorts ;
		return TRUE ;
	}
	else
	{
		nRetry ++ ;
		if (nRetry <= 3)
			goto RETRY ;
		else
			return FALSE ;
	}
}



BOOL CUsersComDlg::GetComprDBase (LPSTR UDBVer)
{
	CTRL_FLAG = 0 ;

	ReadLocReqType RequestLocation ;
	ReadLocRespType RespondLocation ;
	HEADER_TYPE UDBType ;

/* Jo 29/06/99 Modified for UDB read and write */
	RequestLocation.Ptype =	READ_REQ_TYPE ;
	RequestLocation.Length = sizeof (HEADER_TYPE) ;
 	RequestLocation.Address = cUsersCom.little_endian (
												(DWORD) UDB_HEADER_START) ; 

	cUsersCom.TimeOut = FALSE ;
	
	UINT PortsTimerID = 111 ;
	while (PortsTimerID != SetTimer (PortsTimerID, (UINT) 4000, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
								(LPCSTR) NULL, MB_RETRYCANCEL)) 
		{
				SendMessage (WM_CLOSE) ;
				return FALSE ;
		}
	}

	while (TRUE)
	{
		cUsersCom.snd_packet ((BYTE *) &RequestLocation,
													sizeof (ReadLocReqType)) ;
		if (!cUsersCom.rcv_packet ((BYTE *) &RespondLocation,
					  sizeof (RespondLocation), (BOOL *) &cUsersCom.TimeOut))
		{
			break ;  // No CRC error
		}
	}
	KillTimer (PortsTimerID) ;

	CCNFRead cRead (this) ;
		
	if (!cUsersCom.TimeOut)
	{
 		if (RespondLocation.ErrCode != 0)
			return FALSE ;

		memcpy (&UDBType, RespondLocation.buffer, RequestLocation.Length) ;
		_fstrcpy ((LPSTR) UDBVer, (LPCSTR) UDBType.version) ;

		char szBuf[50] ;

		sprintf (szBuf, "0x%x", 
				cUsersCom.ltl_endian_word (UDBType.crc)) ;
		cRead.m_CRC = szBuf ;

		sprintf (szBuf, "%lu", cUsersCom.little_endian (UDBType.code_length)) ;
		cRead.m_Length = szBuf ;

		cRead.m_DateStamp.ShowWindow (SW_HIDE) ;

		cRead.UpdateData (FALSE) ;
		UDBDnldAddress = (DWORD) UDB_DNLD_ADDR ;
	}
	else
		return FALSE ;

   CStdioFile ComprDBase (UDBCompressedDBaseFile,
		CFile::modeCreate | CFile::modeWrite | CFile::typeBinary) ;

	//	Set the gauge to display progress of configuration read.
	
	CHorzGauge *wndHorzGauge = new CHorzGauge ;
   CRect rc ;

	cRead.SetWindowText ((LPCSTR) "User Data Base - Read") ;
	(cRead.GetDlgItem (IDC_STATIC_RECT))->GetWindowRect (&rc) ;
	cRead.ScreenToClient (&rc) ;

   wndHorzGauge->Create ((CWnd *) &cRead, rc) ;
   wndHorzGauge->SetGaugeInfo ("",
										  0,
									   100, 
							 GU_ELEVATED,
							GU_DEPRESSED,
									  TRUE,
									 FALSE,
									 FALSE, 
			  RGB (0xff, 0xff, 0xff),
			  RGB (0x80, 0x80, 0x80), 
			        RGB (0, 0, 0xff),
			  RGB (0xc0, 0xc0, 0xc0), 
						  RGB (0, 0, 0)
			  ) ;
    
   AfxGetApp()->LoadCursor (IDC_WAIT) ;
   AfxGetApp()->DoWaitCursor (1) ;

	DWORD nRead = 0 ;
	RequestLocation.Ptype =	READ_REQ_TYPE ;
	RequestLocation.Length = 128 ;
	RequestLocation.Address = UDBType.down_load_address ; 

	cUsersCom.CODE_CRC = 0xFFFF ;
	UDBType.code_length = cUsersCom.little_endian (UDBType.code_length) ;
	int nRetry = 0 ;
	if (UDBType.code_length)
	{
		while (nRead < UDBType.code_length)
		{
			if (UDBType.code_length)
	      	wndHorzGauge->UpdateProgress ((nRead * 100) / UDBType.code_length) ;

Retry :
			CTRL_FLAG = 0 ;
			cUsersCom.TimeOut = FALSE ;
			nUDBCount = 0 ;
			while (UDB_TIMER_ID != SetTimer (UDB_TIMER_ID, 
												(UINT) UDB_READ_TIME, NULL)) 
			{
				if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
										(LPCSTR) NULL, MB_RETRYCANCEL)) 
				{
					SendMessage (WM_CLOSE) ;
					return FALSE ;
				}
			}

			while (TRUE)
			{
				cUsersCom.snd_packet ((BYTE *) &RequestLocation,
													sizeof (RequestLocation)) ;
				if (!cUsersCom.rcv_packet ((BYTE *) &RespondLocation,
						sizeof (RespondLocation), (BOOL *) &cUsersCom.TimeOut))
				{
					break ;   // No CRC Error
				}
				if (cUsersCom.TimeOut)
					break ;
			}

			if (!cUsersCom.TimeOut)
			{
				switch (RespondLocation.Ptype)
				{
					case READ_RESP_TYPE :
						if (!RespondLocation.ErrCode)
						{
							int i ;
							nRead += 128 ;

							if (nRead <= UDBType.code_length)
							{
								ComprDBase.Write (RespondLocation.buffer, 128) ;
					
								for (i = 0 ; i < 128 ; i ++)
									cUsersCom.updatecrc (RespondLocation.buffer[i]) ;
							}
							else
							{
								int nLastRead ;
								nLastRead = 128 - (int) (nRead - UDBType.code_length) ;

								ComprDBase.Write (RespondLocation.buffer, nLastRead) ;

								for (i = 0 ; i < nLastRead ; i ++)
									cUsersCom.updatecrc (RespondLocation.buffer[i]) ;
							}
							RequestLocation.Address = 
								cUsersCom.little_endian (RequestLocation.Address) ;
							RequestLocation.Address += 128 ;
							RequestLocation.Address = 
								cUsersCom.little_endian (RequestLocation.Address) ;
						}
						break ;

					default :
						break ;
				}
			}	
			else
			{
				cUsersCom.FlushReadBuf() ;
				KillTimer (UDB_TIMER_ID) ;
				nRetry ++ ;
				if (nRetry <= 2)
					goto Retry ;
				else
				 	goto TimeUp ;
			}
			KillTimer (UDB_TIMER_ID) ;
		}
		cUsersCom.updatecrc ((BYTE) 0) ;
		cUsersCom.updatecrc ((BYTE) 0) ;
		if (cUsersCom.CODE_CRC != cUsersCom.ltl_endian_word (UDBType.crc))
			RouMsgBox (MSG_MAIN_CHK_ERR_MEM, NULL, MB_OK) ;
	}

TimeUp :
	KillTimer (UDB_TIMER_ID) ;
	wndHorzGauge->DestroyGauge() ;
	delete wndHorzGauge ;
	AfxGetApp()->DoWaitCursor (0) ;

	ComprDBase.Close() ;

	if (cUsersCom.TimeOut)
	{
		cRead.MessageBox ("Timed out", "Com Port - Read", MB_OK | MB_ICONHAND) ;
		return FALSE ;
	}
	return TRUE ;
}


BOOL CUsersComDlg::ExpandDbase()
{
// Jo 29/06/99 Modified UDB read and write 
	rename (UDBCompressedDBaseFile, UDBUnCompressedDBaseFile) ;
	return TRUE ;
}


int CUsersComDlg::RouMsgBox (int StrId, LPCSTR Header, int Opts)
{
	CString Message ;
	int Ret_val ;

	Message.LoadString (StrId) ;
	Ret_val = MessageBox (Message, Header, Opts) ;
	return Ret_val ;
}


void CUsersComDlg::OnTimer (UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default

	switch (nIDEvent)
	{
		case UDB_TIMER_ID :
			KillTimer (nIDEvent) ;
			cUsersCom.TimeOut = TRUE ;
			break ; 

		case PollingTimerID :
		 	// Timer for polling COM port.
			if (CTRL_FLAG == 1) 
			{
				exitcount ++ ;
				if (exitcount >= Max_exitcount)
					CTRL_FLAG = 0 ;
 			}
 			if (CTRL_FLAG == 0) 
 			{	// Can read char from COM port.
			 	char ch ;
				switch (Go_on)
				{
					case 0 :			// Timeout occured and char couldn't be read.
						Go_on = 2 ;	// Make it true.
						break ;		// So that it comes out of rcv_char.
							
					case 1 :
						Go_on = 0 ;
						if (!cUsersCom.timer_rcv_char (&ch))
						{
							break ;
						}
						if (ExpectingReplyPacket && (ch == (BYTE) 0x7e))
						{
							CTRL_FLAG = 1 ;	// Relinquish control to rcv_packet
						}
						break ;

					case 2 :
						Go_on = 1 ;	// Make it ready for reading char next time.
						break ;
				}
			}
			if (CTRL_FLAG == 3) 	
					CTRL_FLAG = 0 ;
			break ;
		
		default :
			KillTimer (nIDEvent) ;
			cUsersCom.TimeOut = TRUE ;
			break ;
	}
	
	CDialog::OnTimer (nIDEvent);
}
#if 0
void CUsersComDlg::OnReadDbaseNo()
{
	// TODO: Add your control notification handler code here

	CString WindowHeader ;
	GetWindowText (WindowHeader) ;
	int nRetVal = MessageBox ((LPCSTR) "Do you want to Exit ?",
											(LPCSTR) WindowHeader, MB_YESNO) ;
	if (nRetVal == IDNO)
		return ;
	CDialog::OnCancel() ;
}
#endif

void CUsersComDlg::Disconnect()
{
	char szBuf[50] ;
	CString m_InitString, m_InitResponse, m_DialString, m_ConnectResponse ;

	ShowWindow (SW_HIDE) ;
	GetPrivateProfileString (LPortSectionHeader, DialString,
					(LPCSTR) "ATDP", (LPSTR) szBuf, sizeof (szBuf),
							(LPCSTR) OwnIniFile) ;
	m_DialString = szBuf ;
	if (m_DialString.IsEmpty())
		return ;

	if (cUsersCom.IsDCDPresent())
	{
		if (RouMsgBox (MSG_GEN_ASK_HUP, (LPCSTR) NULL, MB_YESNO
									| MB_DEFBUTTON1 | MB_ICONQUESTION) != IDYES)
		{
			return ;
		}
	}

	UINT nTimerID = 200 ;
	cUsersCom.TimeOut = FALSE ;
	char mdm_hangup[2] ;

	while (nTimerID != SetTimer (nTimerID, (UINT) 2000, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER, 
										(LPCSTR) NULL,	MB_RETRYCANCEL)) 
		{
			return ;
		}
	}

	mdm_hangup[0] = 0x1b ;
	mdm_hangup[1] = 0 ;
	cUsersCom.hangup_mdm (mdm_hangup, (BOOL *) &cUsersCom.TimeOut) ;
	KillTimer (nTimerID) ;
}	// End of Disconnect



BOOL CUsersComDlg::WriteDBase()
{
	// Chetan - 1/8/96
	LED_Flash_Count = 0 ;	// Initialize the counter for LED flashing.
	Go_on = 1 ;					// Initialize to read char from COM port.
	CTRL_FLAG = 0 ;		 	// Initialize control to be with Timer routine.

	cUsersCom.TimeOut = FALSE ;
	cUsersCom.CODE_CRC = 0xFFFF ;
	cUsersCom.UDBPktCRC = 0xFFFF ;
	nUDBCount = 0 ;

   while (PollingTimerID != SetTimer (PollingTimerID,
										   	(UINT) PollingInterval, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER, NULL,	MB_RETRYCANCEL))
			return FALSE ;
	}

	cUsersCom.PrevComprCodeSize = 0 ;
	CString cFile = UDBUnCompressedDBaseFile ;

/* Jo 29/06/99 Modified UDB read and write */

	UDBDnldAddress = (DWORD) UDB_DNLD_ADDR ;
	if (!cUsersCom.LZWcompress ((BOOL *) &cUsersCom.TimeOut, cFile, TRUE, FALSE))
		return FALSE ;

	if (!SendUDBHeader())
	{
		::MessageBox (GetSafeHwnd(), "UDB Download unsuccessful",
													"COM Port - Write", MB_OK) ;
		return TRUE ;
	}

	KillTimer (PollingTimerID) ;
	return TRUE ;
}

BOOL CUsersComDlg::SendUDBHeader()
{
	HEADER_TYPE UDBHeader ;

/* Jo 29/06/99 Modified UDB read and write */
	char szBuf[64] ;

	strcpy (UDBHeader.version, UDB_VERSION) ;		//12/06/97 Vidy

	UINT nMagicNum = (WORD) MAGIC_NUM ;
	UDBHeader.magic_number = cUsersCom.ltl_endian_word (nMagicNum) ;


	cUsersCom.updatecrc ((BYTE) 0) ;
	cUsersCom.updatecrc ((BYTE) 0) ;
	UDBHeader.crc = cUsersCom.ltl_endian_word (cUsersCom.CODE_CRC) ;

	UDBHeader.code_length = cUsersCom.little_endian (cUsersCom.ComprCodeSize) ;

	UDBHeader.down_load_address = cUsersCom.little_endian (UDBDnldAddress) ;

	UDBHeader.load_address = UDBHeader.start_address =
									cUsersCom.little_endian ((DWORD) 0) ;

	CStdioFile input ;
   if (!input.Open (UDBUnCompressedDBaseFile,
							CFile::modeRead | CFile::typeText))
   {
      AfxMessageBox (MSG_COM_ERR_FILE_OPEN, MB_OK | MB_ICONINFORMATION) ;
      return FALSE ;
   }
   DWORD size =  input.GetLength() ;
	UDBHeader.no_of_users =
		(WORD) cUsersCom.ltl_endian_word ((WORD) ((DWORD) size / (DWORD) sizeof (USERDATA))) ; 

	strcpy (UDBHeader.Description, "USER DATABASE") ;

	memset (UDBHeader.padding, (BYTE) 0, sizeof (UDBHeader.padding)) ;

	memcpy (szBuf, &UDBHeader, sizeof (UDBHeader)) ;

	UDBDnldAddress = (DWORD) UDB_HEADER_START ;

	for (int i = 0 ; i < (512 / UDB_SENT_ONCE_COM) ; i ++)
	{
		UDBDnldAddress = (DWORD) ((DWORD) UDB_HEADER_START  + (DWORD) (UDB_SENT_ONCE_COM * i)) ;
		cUsersCom.PrevComprCodeSize = 0 ;
		cUsersCom.ComprCodeSize = 0 ;

		cUsersCom.ComprCodeSize += UDB_SENT_ONCE_COM ;
/* ...Jo Changed on 24 Nov 1999. UDB header length was sent as 512 instead of 64 and so all 
	the other headers, script etc residing in that 8k sector was overwritten */

		cUsersCom.UDBActualLen = FL_HEADER_SIZE ;

/* Jo Changed on 24 Nov 1999. UDB header length was sent as 512 instead of 64 and so all 
	the other headers, script etc residing in that 8k sector was overwritten ...*/

		if (cUsersCom.send_data_online ((BYTE *) szBuf, FL_HEADER_SIZE, 
												(BOOL *) &cUsersCom.TimeOut, TRUE) < 0)
			return FALSE ;
	}

	return TRUE ;
}

#define REBOOT_TIMER 5000   // 5 sec timer for booting 
/* Jo Added new function 29/06/99 */
void CUsersComDlg::Reboot()
{
	LPCSTR  RebootMsgHeader = "Proxy Server Setup - Rebooting";
   CReboot cReboot (this) ;

	RebootType rebootpkt ;
	BOOL RouterUp ;

	rebootpkt.Ptype = (BYTE) REBOOT_TYPE ;		//  22
	rebootpkt.BootType = WARM_BOOT_MODE ;			         // System Reboot


	cUsersCom.FlushReadBuf() ;		// Flush the receive buffer
	cUsersCom.snd_packet ((BYTE *) &rebootpkt, sizeof (rebootpkt)) ;
	
	UINT nTimerID = 20 ;
	cUsersCom.TimeOut = FALSE ;
	
	while (nTimerID != SetTimer (nTimerID, (UINT) REBOOT_TIMER, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
				RebootMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			return ;
		}
	}

   while (!cUsersCom.TimeOut)		// Delay (3 seconds)
	{
		MSG msg ;
		while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage (&msg) ;
			DispatchMessage (&msg) ;
		}
	}

	cUsersCom.FlushReadBuf() ;		// Flush the receive buffer

   RouterUp = FALSE ;
   for (int k = 0 ; (k < 20 && !RouterUp) ; k ++)
   {
		ReqType brd_req_type ;
	  	OpenConnectionType bridge1 ;
	  
		brd_req_type.Ptype = QUERY_BRIDGE_NAME ;		// 13
		cUsersCom.TimeOut = FALSE ;
		RouterUp = FALSE ;
		UINT nTimerID = 17 ;
		while (nTimerID != SetTimer (nTimerID, (UINT) REBOOT_TIMER, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
					RebootMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
			{
				return ;
			}
		}

		while (1)
		{
			cUsersCom.FlushReadBuf() ;		// Flush the receive buffer
			cUsersCom.snd_packet ((BYTE *) &brd_req_type.Ptype,
																sizeof (brd_req_type)) ;
			if (!cUsersCom.rcv_packet2 ((BYTE *) &bridge1,
							sizeof (bridge1), (BOOL *) &cUsersCom.TimeOut))
			{
				break ;	// No CRC error
			}
		}
    
	   if (!cUsersCom.TimeOut)
		{
	  	  	KillTimer (nTimerID) ;
			if (bridge1.Ptype == RES_TYPE)			// 12
			{
	     		BYTE *incor ;
				WORD pra ;
				incor = (BYTE *) &pra ;
				incor[0] = bridge1.BrdName[1] ;
				incor[1] = bridge1.BrdName[2] ;
				pra = cUsersCom.ltl_endian_word (pra) ;
				switch (pra)
				{
					case ERR_ROUTER_UP :       // RouterUp
						RouterUp = TRUE ; // Router is running and you can't Download
						break ;

					default :
						break ;
				}       
		  	}
		}
	}
   cReboot.DestroyWindow() ;
}	// end of Reboot
