// Author : JYOTHI
// Date : 15/06/97
// functions used to access the structure's contents 
// Jyothi : 03-Jan-2000, Added new functions to get next next available IP address for RAS clients : 
//				check_if_assigned_address_is_duplicate(), get_ip_address_and_check_for_wrap_around(), 
//				get_ip_address_for_ras_port()

#include <stdio.h>
#include <stdlib.h>
#include "stdafx.h"
#include "procon.h"
#include "maskdot.h"
#include "cnffile.h"
#include "utils.h"
#include "readbmp.h"
#include "prxfilt.h"
#include "natdlg.h"
#include "proxy.h"
#include "upgrade.h"

#define NUMBER_OF_PROXY_FILTERS		5

extern CNF_PROXY_HEADER  *proxy_header_ptr ;
extern FILT_ON_DEST_ADDRESS *filt_dest_start;
extern FILT_ON_SOURCE_ADDRESS *filt_source_start;
extern FILT_ON_APPLICATION *filt_applcn_start;
extern FILT_ON_MAC_ADDRESS *filt_mac_start;
extern FILT_ON_DOMAIN_NAME *filt_domain_name_start;
extern CNF_PPP *ppp_ptr ;
extern CNF_IP *ip_ptr ;

extern CNF_UPGRADE_IP *upgrade_ip_ptr ;
extern CNF_WAN *upgrade_wan_ptr ;
extern CNF_UPGRADE_PPP *upgrade_ppp_ptr ;
extern CNF_UPGRADE_PROXY_HEADER *upgrade_proxy_header_ptr ;
extern CNF_UPGRADE_DHCP_HEADER *upgrade_dhcp_header_ptr ; 

extern enum CNF_DATA_VALUE_DATA_TYPE change_endian_enum (enum CNF_DATA_VALUE_DATA_TYPE num) ;

unsigned short change_endian (unsigned short num)
{
	unsigned short num2 ;
	unsigned char *str1, *str2 ;

	str1 = (unsigned char *) &num ;
	str2 = (unsigned char *) &num2 ;
	str2[0] = str1[1] ;
	str2[1] = str1[0] ;
	return num2 ;
}

DWORD ltl_endian_word (DWORD num)
{
	DWORD num2 ;
	BYTE *str ;
	BYTE *str2 ;
	str = (BYTE *) &num ;
	str2 = (BYTE *) &num2 ;
	if ((int) sizeof (num) == (int) 4)
	{
		str2[3] = str[0] ;
		str2[2] = str[1] ;
		str2[1] = str[2] ;
		str2[0] = str[3] ;
	}
	else
	{ 
		str2[0] = str[1] ;
		str2[1] = str[0] ;
	}
	return num2 ;
}

void get_next_ip_address (char *obtd_host_ip_address, char *next_ip_address) 
{
	ULONG ulong_ip_address ;

	get_ip_address (obtd_host_ip_address, &ulong_ip_address)	;
	if ((++ulong_ip_address & 0xff) == 0xff)
	{
		ulong_ip_address&= 0xffffff00 ;
		ulong_ip_address|= 1 ;
	}
	get_dot_decimal_ip_address (ulong_ip_address, next_ip_address)	;
}

int check_if_ip_address_belongs_to_same_net (char *obtd_host_ip_address, char *ip_address)
{
	ULONG ip_address1, ip_address2, mask_value ;

	get_ip_address (obtd_host_ip_address, &ip_address1)	;
	get_ip_address (ip_address, &ip_address2)	;
	guess_mask (ip_address1, &mask_value) ;
	if ((ip_address1&mask_value) == (ip_address2&mask_value))
		return TRUE ;
	return FALSE ;
}

void	guess_mask (ULONG ip_address, ULONG *mask_value) 
{
	ip_address&= 0xff000000 ;
	ip_address>>=24 ;
	if (ip_address < 128)
		*mask_value = 0xff000000;
	else
		if (ip_address < 192)
			*mask_value = 0xffff0000;
		else
			*mask_value = 0xffffff00;
}

int ras_is_enabled()
{
	for (int i = 0; i < ppp_ptr->ppp_header.number_of_ports; i++)
		if (ppp_ptr->ppp_ports[i].remote_port_client_only)
			return TRUE ;
	return FALSE ;
}

int check_if_assigned_address_is_duplicate (ULONG *assigned_ip_address, int index)
{
	switch(index)
	{
		case 1 : if ((*assigned_ip_address == ip_ptr->ip_ports[index+1].remote_ip_address) ||
						 (*assigned_ip_address == ip_ptr->ip_ports[index+2].remote_ip_address))
							return TRUE ;
					else 
							return FALSE ;

		case 2 : if ((*assigned_ip_address == ip_ptr->ip_ports[index - 1].remote_ip_address) ||
						 (*assigned_ip_address == ip_ptr->ip_ports[index + 1].remote_ip_address))
							return TRUE ;
					else 
							return FALSE ;

		case 3 : if ((*assigned_ip_address == ip_ptr->ip_ports[index - 1].remote_ip_address) ||
						 (*assigned_ip_address == ip_ptr->ip_ports[index - 2].remote_ip_address))
							return TRUE ;
					else 
							return FALSE ;

		default : return FALSE ;
		
	}
}

void get_ip_address_and_check_for_wrap_around (ULONG temp_ulong_ip_address, ULONG *assigned_ip_address, int offset)
{
	if ((((temp_ulong_ip_address + offset) & 0xff) == 0xff) || 
			(((temp_ulong_ip_address + offset) & ip_ptr->ip_ports[0].subnet_mask) != (ip_ptr->ip_ports[0].ip_address & ip_ptr->ip_ports[0].subnet_mask)))
	{
		temp_ulong_ip_address&= 0xffffff00 ;
		temp_ulong_ip_address|= 1 ;
		*assigned_ip_address = temp_ulong_ip_address ;
	}
	else
		*assigned_ip_address = temp_ulong_ip_address + offset ;
}

void get_ip_address_for_ras_port (int index, ULONG *assigned_ip_address)
{
	int offset ;
	ULONG temp_ulong_ip_address = ip_ptr->ip_ports[0].ip_address ;

	offset = index ;
	get_ip_address_and_check_for_wrap_around (temp_ulong_ip_address, assigned_ip_address, offset) ;

	if (check_if_assigned_address_is_duplicate (assigned_ip_address, index))
	{
		while(1)
		{
			offset = 1 ;
			temp_ulong_ip_address = *assigned_ip_address ;
			get_ip_address_and_check_for_wrap_around (temp_ulong_ip_address, assigned_ip_address, offset) ;
			if (!check_if_assigned_address_is_duplicate (assigned_ip_address, index))
				break ;	
		}
		return ;
	}
	else
		return ;
}

int calculate_offset_of_proxy_application_entries (ULONG *offset)
{
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    *offset = (ULONG) proxy_application_ptr ;
    return TRUE;
}

int  calculate_offset_of_proxy_user_defined_application_entries (ULONG *offset)
{
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    *offset = (ULONG) proxy_user_defined_application_ptr ;
    return TRUE;
}

int  calculate_offset_of_proxy_filter (ULONG *offset)
{
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_FILTER *proxy_filter_ptr ; 
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *) proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;

    proxy_filter_ptr = ((CNF_PROXY_FILTER *)((char *)proxy_virtual_server_ptr + (sizeof(CNF_PROXY_VIRTUAL_SERVER) + ( 
                           (proxy_virtual_server_ptr->number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                           (proxy_virtual_server_ptr->number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
                           (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO))))) ; 
   *offset = (ULONG) proxy_filter_ptr ;
   return TRUE;
}

int calculate_offset_to_each_proxy_filter (ULONG *offset, ULONG *return_offset, int filter_number) 
{
   CNF_PROXY_FILTER *proxy_filter_ptr ; 

   proxy_filter_ptr = (CNF_PROXY_FILTER *) *offset ;
   switch (filter_number)
   {
    	case 0 : *return_offset = (ULONG) proxy_filter_ptr + (NUMBER_OF_PROXY_FILTERS * sizeof(USHORT)) ;
					break ;
    	case 1 : *return_offset = ((ULONG) proxy_filter_ptr + (NUMBER_OF_PROXY_FILTERS * sizeof(USHORT)) + 
				  		(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries)) ;
				   break ;
		case 2 : *return_offset = ((ULONG) proxy_filter_ptr + (NUMBER_OF_PROXY_FILTERS * sizeof(USHORT)) + 
				  		(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries) +
						(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_restricted_clients_entries)) ;
					break ;

		case 3 : *return_offset = ((ULONG) proxy_filter_ptr + (NUMBER_OF_PROXY_FILTERS * sizeof(USHORT)) + 
					  (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries) +
					  (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_restricted_clients_entries) +
					  (sizeof(CNF_PROXY_APP) * proxy_filter_ptr->number_of_restricted_application_entries)) ;
					break ;
		case 4 : *return_offset = ((ULONG) proxy_filter_ptr + (NUMBER_OF_PROXY_FILTERS * sizeof(USHORT)) + 
					  (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_forbidden_sites_entries) +
					  (sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_filter_ptr->number_of_restricted_clients_entries) +
					  (sizeof(CNF_PROXY_APP) * proxy_filter_ptr->number_of_restricted_application_entries) +
					  (sizeof(CNF_PROXY_MAC_ADDRESS_INFO) * proxy_filter_ptr->number_of_mac_address_entries)) ; 
					break ;
   }
   return TRUE ;
}

int calculate_offset_of_proxy_port (ULONG *offset, int port_number)
{
    CNF_PROXY_PORT *proxy_port_ptr ;
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_FILTER *proxy_filter_ptr ; 
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *)proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;
    proxy_filter_ptr = ((CNF_PROXY_FILTER *)((char *)proxy_virtual_server_ptr + (sizeof(CNF_PROXY_VIRTUAL_SERVER) + ( 
                           (proxy_virtual_server_ptr->number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                           (proxy_virtual_server_ptr->number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
                           (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO))))) ; 

   proxy_port_ptr = ((CNF_PROXY_PORT *)((char*) proxy_filter_ptr + sizeof(CNF_PROXY_FILTER) + (
                      (proxy_filter_ptr->number_of_forbidden_sites_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_restricted_clients_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_restricted_application_entries - 1) * sizeof(CNF_PROXY_APP) +
                      (proxy_filter_ptr->number_of_mac_address_entries - 1) * sizeof(CNF_PROXY_MAC_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_domain_name_entries - 1) * sizeof(CNF_PROXY_DOMAIN_NAME_INFO)))) ; 

   *offset = (ULONG) proxy_port_ptr ;
   for (int i = 0; i < port_number; i++)
   {
		proxy_port_ptr = (CNF_PROXY_PORT *) *offset ;
		*offset += sizeof (CNF_PROXY_PORT) + ((proxy_port_ptr->number_of_address_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO)) ;
   }	
   return TRUE;
}

int calculate_offset_of_proxy_virtual_entry (ULONG *offset)
{
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *) proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;

    *offset = (ULONG) proxy_virtual_server_ptr ;
    return TRUE;
}

int calculate_offset_to_each_proxy_entry (ULONG *offset, ULONG *return_offset, int entry_type) 
{
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;

    proxy_virtual_server_ptr = (CNF_PROXY_VIRTUAL_SERVER *) *offset ;
    switch (entry_type)
    {
    	case 0 : *return_offset = ((ULONG) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG)) ;
					break ;
    	case 1 : *return_offset = ((ULONG) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG) + 
						(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_virtual_server_ptr->number_of_global_address_entries)) ;
					break ;
		case 2 : *return_offset = ((ULONG) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG) + 
				  		(sizeof(CNF_PROXY_ADDRESS_INFO) * proxy_virtual_server_ptr->number_of_global_address_entries) +
					  	(sizeof(CNF_PROXY_STATIC_INFO) * proxy_virtual_server_ptr->number_of_static_mapping_entries)) ;
					break ;
    }
    return TRUE ;
}

int calculate_offset_of_dhcp_address_range_entries (ULONG *offset, int index) 
{
    CNF_DHCP_HEADER *temp_dhcp_header_ptr ;
    CNF_DHCP_ADDRESS_RANGE *temp_dhcp_address_range_ptr ;

    temp_dhcp_header_ptr = (CNF_DHCP_HEADER *) *offset ;
    temp_dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) ((char*) temp_dhcp_header_ptr + sizeof(CNF_DHCP_HEADER)) ;
    *offset = (ULONG) temp_dhcp_address_range_ptr ;

    for (int i = 0; i < index; i++)
    {
    	temp_dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) *offset ;
		*offset+= (sizeof(CNF_DHCP_ADDRESS_RANGE) + ((temp_dhcp_address_range_ptr->number_of_bindings_entries - 1) * sizeof(CNF_BINDING_INFO)))	;
    }
    return TRUE ;
}

int calculate_offset_of_dhcp_binding_entries (ULONG *offset, ULONG *return_offset) 
{
    USHORT OFFSET_TO_BINDING_ENTRIES ;
    CNF_DHCP_ADDRESS_RANGE *temp_dhcp_address_range_ptr ;

    temp_dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) *offset ;
    OFFSET_TO_BINDING_ENTRIES = (sizeof(CNF_DHCP_ADDRESS_RANGE) - sizeof(CNF_OPTIONS_INFO) - sizeof(CNF_BINDING_INFO)) ;
    *return_offset = ((ULONG)temp_dhcp_address_range_ptr + sizeof(CNF_OPTIONS_INFO) 
		     + OFFSET_TO_BINDING_ENTRIES) ; 
    return TRUE ;
}

int calculate_offset_of_static_route_info_entry (ULONG *offset)
{
	CNF_STATIC_ROUTES_HEADER *temp_static_routes_header_ptr ;
	CNF_STATIC_ROUTES_INFO *temp_static_routes_info_ptr ;

	temp_static_routes_header_ptr = (CNF_STATIC_ROUTES_HEADER *) *offset ;
	temp_static_routes_info_ptr = (CNF_STATIC_ROUTES_INFO *) ((char *)temp_static_routes_header_ptr + sizeof (CNF_STATIC_ROUTES_HEADER)) ;
	*offset = (ULONG)	temp_static_routes_info_ptr ;
    return TRUE;
}

int  calculate_offset_of_proxy_user_defined_application_entries_for_upgrading (ULONG *offset)
{
    CNF_UPGRADE_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_UPGRADE_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_UPGRADE_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    *offset = (ULONG) proxy_user_defined_application_ptr ;
    return TRUE;
}

int  calculate_offset_of_proxy_filter_for_upgrading (ULONG *offset)
{
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_FILTER *proxy_filter_ptr ; 
    CNF_UPGRADE_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_UPGRADE_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_UPGRADE_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *) proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;

    proxy_filter_ptr = ((CNF_PROXY_FILTER *)((char *)proxy_virtual_server_ptr + (sizeof(CNF_PROXY_VIRTUAL_SERVER) + ( 
                           (proxy_virtual_server_ptr->number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                           (proxy_virtual_server_ptr->number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
                           (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO))))) ; 
   *offset = (ULONG) proxy_filter_ptr ;
   return TRUE;
}

int calculate_offset_of_proxy_port_for_upgrading (ULONG *offset, int port_number)
{
    CNF_PROXY_PORT *proxy_port_ptr ;
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_PROXY_FILTER *proxy_filter_ptr ; 
    CNF_UPGRADE_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_UPGRADE_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_UPGRADE_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *)proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;
    proxy_filter_ptr = ((CNF_PROXY_FILTER *)((char *)proxy_virtual_server_ptr + (sizeof(CNF_PROXY_VIRTUAL_SERVER) + ( 
                           (proxy_virtual_server_ptr->number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                           (proxy_virtual_server_ptr->number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
                           (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO))))) ; 

   proxy_port_ptr = ((CNF_PROXY_PORT *)((char*) proxy_filter_ptr + sizeof(CNF_PROXY_FILTER) + (
                      (proxy_filter_ptr->number_of_forbidden_sites_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_restricted_clients_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_restricted_application_entries - 1) * sizeof(CNF_PROXY_APP) +
                      (proxy_filter_ptr->number_of_mac_address_entries - 1) * sizeof(CNF_PROXY_MAC_ADDRESS_INFO) +
                      (proxy_filter_ptr->number_of_domain_name_entries - 1) * sizeof(CNF_PROXY_DOMAIN_NAME_INFO)))) ; 

   *offset = (ULONG) proxy_port_ptr ;
   for (int i = 0; i < port_number; i++)
   {
		proxy_port_ptr = (CNF_PROXY_PORT *) *offset ;
		*offset += sizeof (CNF_PROXY_PORT) + ((proxy_port_ptr->number_of_address_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO)) ;
   }	
   return TRUE;
}

int calculate_offset_of_proxy_virtual_entry_for_upgrading (ULONG *offset)
{
    CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
    CNF_PROXY_APPLICATION   *proxy_application_ptr ;
    CNF_UPGRADE_PROXY_HEADER *temp_header_ptr = NULL ;
    CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;

    temp_header_ptr = (CNF_UPGRADE_PROXY_HEADER *) *offset ;
    proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)temp_header_ptr + sizeof(CNF_UPGRADE_PROXY_HEADER))) ; 
    proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (proxy_application_ptr->number_of_application_entries - 1))))) ; 
    proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *) proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - 1))))) ;

    *offset = (ULONG) proxy_virtual_server_ptr ;
    return TRUE;
}

int calculate_offset_of_dhcp_address_range_entries_for_upgrading (ULONG *offset, int index) 
{
    CNF_UPGRADE_DHCP_HEADER *temp_dhcp_header_ptr ;
    CNF_DHCP_ADDRESS_RANGE *temp_dhcp_address_range_ptr ;

    temp_dhcp_header_ptr = (CNF_UPGRADE_DHCP_HEADER *) *offset ;
    temp_dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) ((char*) temp_dhcp_header_ptr + sizeof(CNF_UPGRADE_DHCP_HEADER)) ;
    *offset = (ULONG) temp_dhcp_address_range_ptr ;

    for (int i = 0; i < index; i++)
    {
    	temp_dhcp_address_range_ptr = (CNF_DHCP_ADDRESS_RANGE *) *offset ;
		*offset+= (sizeof(CNF_DHCP_ADDRESS_RANGE) + ((temp_dhcp_address_range_ptr->number_of_bindings_entries - 1) * sizeof(CNF_BINDING_INFO))) ;
    }
    return TRUE ;
}

int add_forbidden_sites_entries (FILT_ON_DEST_ADDRESS *filt_dest_start) 
{
   int count = 0 ;
   ULONG offset, return_offset, int_ip_addr ;
   USHORT temp_number_of_entries ;
   CNF_PROXY_FILTER *proxy_filter_ptr ;
   FILT_ON_DEST_ADDRESS *dest_entry;
   CNF_PROXY_ADDRESS_INFO *proxy_forbidden_sites_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   temp_number_of_entries = proxy_filter_ptr->number_of_forbidden_sites_entries ;

   if ((dest_entry = (FILT_ON_DEST_ADDRESS *) malloc (sizeof (FILT_ON_DEST_ADDRESS))) == NULL)
   	return FALSE ;
   dest_entry = filt_dest_start ;
   while (dest_entry != NULL)
   {
   	count++ ;
   	dest_entry = dest_entry->ptr_to_next ;
   }	     
   proxy_filter_ptr->number_of_forbidden_sites_entries = count ;	

   if (temp_number_of_entries < proxy_filter_ptr->number_of_forbidden_sites_entries)
   {
		ULONG return_offset ;
   	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(ULONG) * (proxy_filter_ptr->number_of_forbidden_sites_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_filter (&offset) ;
   	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
     	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 0) ;
     	proxy_forbidden_sites_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

		return_offset += (temp_number_of_entries * sizeof(ULONG)) ;

		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset - 
			(sizeof(ULONG) * (proxy_filter_ptr->number_of_forbidden_sites_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (return_offset + ((proxy_filter_ptr->number_of_forbidden_sites_entries - temp_number_of_entries) * sizeof(ULONG))) ; 
		memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
   }
   else
   {
      if (temp_number_of_entries > proxy_filter_ptr->number_of_forbidden_sites_entries)
      {
		  	offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			calculate_offset_of_proxy_filter (&offset) ;
   		proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
     		calculate_offset_to_each_proxy_filter (&offset, &return_offset, 0) ;
	     	proxy_forbidden_sites_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

			return_offset += (temp_number_of_entries  * sizeof(ULONG)) ;

		  	ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset) ;
   		ULONG dst_offset = (ULONG) (return_offset - ((temp_number_of_entries - proxy_filter_ptr->number_of_forbidden_sites_entries) * sizeof(ULONG))) ;
	   	_fmemmove ((void FAR *) dst_offset, (void FAR *) return_offset, (int) SizeToMove) ;

  			ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(ULONG) * (proxy_filter_ptr->number_of_forbidden_sites_entries - temp_number_of_entries))) ;
	   	all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
   		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
	   	proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
   		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
      }
   }

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 0) ;
   proxy_forbidden_sites_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

   dest_entry = filt_dest_start;
   while (dest_entry != NULL)
   {
		get_ip_address (dest_entry->dest_ip, &int_ip_addr) ;
		proxy_forbidden_sites_ptr->address = int_ip_addr ;
    	dest_entry = dest_entry->ptr_to_next;
		proxy_forbidden_sites_ptr++ ;
   }
   return TRUE ;
}

int add_restricted_clients_entries (FILT_ON_SOURCE_ADDRESS *filt_source_start)
{
   int count = 0 ;
   ULONG offset, return_offset, int_ip_addr ;
   USHORT temp_number_of_entries ;
   CNF_PROXY_FILTER *proxy_filter_ptr ;
   FILT_ON_SOURCE_ADDRESS *src_entry;
   CNF_PROXY_ADDRESS_INFO *proxy_restricted_clients_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   temp_number_of_entries = proxy_filter_ptr->number_of_restricted_clients_entries ;

   if ((src_entry = (FILT_ON_SOURCE_ADDRESS *) malloc (sizeof (FILT_ON_SOURCE_ADDRESS))) == NULL)
   	return FALSE ;
   src_entry = filt_source_start ;
   while (src_entry != NULL)
   {
   	count++ ;
   	src_entry = src_entry->ptr_to_next ;
   }	     
   proxy_filter_ptr->number_of_restricted_clients_entries = count ;	

   if (temp_number_of_entries < proxy_filter_ptr->number_of_restricted_clients_entries)
   {
		ULONG return_offset ;
   	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(ULONG) * (proxy_filter_ptr->number_of_restricted_clients_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_filter (&offset) ;
   	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
     	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 1) ;
     	proxy_restricted_clients_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

		return_offset += (temp_number_of_entries * sizeof(ULONG)) ;

		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset - 
			(sizeof(ULONG) * (proxy_filter_ptr->number_of_restricted_clients_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (return_offset + ((proxy_filter_ptr->number_of_restricted_clients_entries - temp_number_of_entries) * sizeof(ULONG))) ;
		memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
   }
   else
   {
     if (temp_number_of_entries > proxy_filter_ptr->number_of_restricted_clients_entries)
     {
			offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			calculate_offset_of_proxy_filter (&offset) ;
   		proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
	     	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 1) ;
   	  	proxy_restricted_clients_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

			return_offset += (temp_number_of_entries * sizeof(ULONG)) ;

   		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset) ;
	   	ULONG dst_offset = (ULONG) (return_offset - ((temp_number_of_entries - proxy_filter_ptr->number_of_restricted_clients_entries) * sizeof(ULONG))) ;
   		_fmemmove ((void FAR *) dst_offset, (void FAR *) return_offset, (int) SizeToMove) ;

		  	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(ULONG) * (proxy_filter_ptr->number_of_restricted_clients_entries - temp_number_of_entries))) ;
   		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	   	all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
   		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
	   	proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
      }
   }
   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 1) ;
   proxy_restricted_clients_ptr = (CNF_PROXY_ADDRESS_INFO *) return_offset ;

   src_entry = filt_source_start;
   while (src_entry != NULL)
   {
		get_ip_address (src_entry->source_ip, &int_ip_addr) ;
		proxy_restricted_clients_ptr->address = int_ip_addr ;
    	src_entry = src_entry->ptr_to_next;
		proxy_restricted_clients_ptr++ ;
   }
   return TRUE ;
}

int add_restricted_application_entries (FILT_ON_APPLICATION *filt_applcn_start)
{
   int count = 0 ;
   ULONG offset, return_offset ;
   USHORT temp_number_of_entries, temp_int ;
   CNF_PROXY_FILTER *proxy_filter_ptr ;
   FILT_ON_APPLICATION *appl_entry ;
   CNF_PROXY_APP *proxy_restricted_application_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   temp_number_of_entries = proxy_filter_ptr->number_of_restricted_application_entries ;

   if ((appl_entry = (FILT_ON_APPLICATION *) malloc (sizeof (FILT_ON_APPLICATION))) == NULL)
   	return FALSE ;
   appl_entry = filt_applcn_start ;
   while (appl_entry != NULL)
   {
     	int ports = GetNumberOfPorts (appl_entry->port, appl_entry->protocol) ;
		if (ports > 1)
   	   count+= 2 ;
		else
   	   count++ ;
   	appl_entry = appl_entry->ptr_to_next ;
   }	     
   proxy_filter_ptr->number_of_restricted_application_entries = count ;	

   if (temp_number_of_entries < proxy_filter_ptr->number_of_restricted_application_entries)
   {
		ULONG return_offset ;
   	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_APP) * (proxy_filter_ptr->number_of_restricted_application_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_filter (&offset) ;
   	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
     	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 2) ;
     	proxy_restricted_application_ptr = (CNF_PROXY_APP *) return_offset ;

		return_offset += (temp_number_of_entries * sizeof(CNF_PROXY_APP)) ;

		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset - 
		(sizeof(CNF_PROXY_APP) * (proxy_filter_ptr->number_of_restricted_application_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (return_offset + ((proxy_filter_ptr->number_of_restricted_application_entries - temp_number_of_entries) * sizeof(CNF_PROXY_APP))) ;
		memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
   }
   else
   {
     if (temp_number_of_entries > proxy_filter_ptr->number_of_restricted_application_entries)
     {
			offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			calculate_offset_of_proxy_filter (&offset) ;
   		proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
	     	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 2) ;
   	  	proxy_restricted_application_ptr = (CNF_PROXY_APP *) return_offset ;

			return_offset += (temp_number_of_entries * sizeof(CNF_PROXY_APP)) ;

   		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset) ;
	   	ULONG dst_offset = (ULONG) (return_offset - ((temp_number_of_entries - proxy_filter_ptr->number_of_restricted_application_entries) * sizeof(CNF_PROXY_APP))) ;
   		_fmemmove ((void FAR *) dst_offset, (void FAR *) return_offset, (int) SizeToMove) ;

		  	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_APP) * (proxy_filter_ptr->number_of_restricted_application_entries - temp_number_of_entries))) ;
	   	all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
   		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
	   	proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
   		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
     }	
   }
   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 2) ;
   proxy_restricted_application_ptr = (CNF_PROXY_APP *) return_offset ;

   char port_buf[50], protocol_buf[5];
   appl_entry = filt_applcn_start;
   while (appl_entry != NULL)
   {
		GetProtocolNumber (protocol_buf, appl_entry->protocol) ;
     	int ports = GetNumberOfPorts (appl_entry->port, appl_entry->protocol) ;
     	for (int i = 1; i <= ports; i++)
		{
		   GetPortNumber (port_buf, appl_entry->port, appl_entry->protocol, i) ;
			sscanf (protocol_buf, "%d", &temp_int);
			proxy_restricted_application_ptr->protocol = temp_int ;
			sscanf (port_buf, "%d", &temp_int);
		   proxy_restricted_application_ptr->port = temp_int ;
		   proxy_restricted_application_ptr++ ;
		}
    	appl_entry = appl_entry->ptr_to_next;
//	proxy_restricted_application_ptr++ ;
   }
   return TRUE ;
}

int add_mac_address_entries (FILT_ON_MAC_ADDRESS *filt_mac_start)
{
   int count = 0 ;
   ULONG offset, return_offset ;
   USHORT temp_number_of_entries ;
   CNF_PROXY_FILTER *proxy_filter_ptr ;
   FILT_ON_MAC_ADDRESS *mac_address_entry;
   CNF_PROXY_MAC_ADDRESS_INFO *proxy_mac_address_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   temp_number_of_entries = proxy_filter_ptr->number_of_mac_address_entries ;

   if ((mac_address_entry = (FILT_ON_MAC_ADDRESS *) malloc (sizeof (FILT_ON_MAC_ADDRESS))) == NULL)
   	return FALSE ;
   mac_address_entry = filt_mac_start ;
   while (mac_address_entry != NULL)
   {
   	count++ ;
   	mac_address_entry = mac_address_entry->ptr_to_next ;
   }	     
   proxy_filter_ptr->number_of_mac_address_entries = count ;	

   if (temp_number_of_entries < proxy_filter_ptr->number_of_mac_address_entries)
   {
		ULONG return_offset ;
   	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_MAC_ADDRESS_INFO) * (proxy_filter_ptr->number_of_mac_address_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_filter (&offset) ;
   	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
     	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 3) ;
     	proxy_mac_address_ptr = (CNF_PROXY_MAC_ADDRESS_INFO *) return_offset ;

		return_offset += (temp_number_of_entries * sizeof(CNF_PROXY_MAC_ADDRESS_INFO)) ;

		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset - 
			(sizeof(CNF_PROXY_MAC_ADDRESS_INFO) * (proxy_filter_ptr->number_of_mac_address_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (return_offset + ((proxy_filter_ptr->number_of_mac_address_entries - temp_number_of_entries) * sizeof(CNF_PROXY_MAC_ADDRESS_INFO))) ;
		memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
   }
   else
   {
     if (temp_number_of_entries > proxy_filter_ptr->number_of_mac_address_entries)
     {
			offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			calculate_offset_of_proxy_filter (&offset) ;
   		proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
	     	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 3) ;
   	  	proxy_mac_address_ptr = (CNF_PROXY_MAC_ADDRESS_INFO *) return_offset ;

			return_offset += (temp_number_of_entries * sizeof(CNF_PROXY_MAC_ADDRESS_INFO)) ;

	   	ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset) ;
   		ULONG dst_offset = (ULONG) (return_offset - ((temp_number_of_entries - proxy_filter_ptr->number_of_mac_address_entries) * sizeof(CNF_PROXY_MAC_ADDRESS_INFO))) ;
   		_fmemmove ((void FAR *) dst_offset, (void FAR *) return_offset, (int) SizeToMove) ;

		  	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_MAC_ADDRESS_INFO) * (proxy_filter_ptr->number_of_mac_address_entries - temp_number_of_entries))) ;
   		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	   	all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
   		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
	   	proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
     }
   }
   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 3) ;
   proxy_mac_address_ptr = (CNF_PROXY_MAC_ADDRESS_INFO *) return_offset ;

   mac_address_entry = filt_mac_start;
   while (mac_address_entry != NULL)
   {
		strcpy ((char *)proxy_mac_address_ptr->address, mac_address_entry->mac_address) ;
    	mac_address_entry = mac_address_entry->ptr_to_next;
		proxy_mac_address_ptr++ ;
   }
   return TRUE ;
}

int add_domain_name_entries (FILT_ON_DOMAIN_NAME *filt_domain_name_start)
{
   int count = 0 ;
   ULONG offset, return_offset ;
   USHORT temp_number_of_entries ;
   CNF_PROXY_FILTER *proxy_filter_ptr ;
   FILT_ON_DOMAIN_NAME *domain_name_entry;
   CNF_PROXY_DOMAIN_NAME_INFO *proxy_domain_name_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   temp_number_of_entries = proxy_filter_ptr->number_of_domain_name_entries ;

   if ((domain_name_entry = (FILT_ON_DOMAIN_NAME *) malloc (sizeof (FILT_ON_DOMAIN_NAME))) == NULL)
   	return FALSE ;
   domain_name_entry = filt_domain_name_start ;
   while (domain_name_entry != NULL)
   {
   	count++ ;
   	domain_name_entry = domain_name_entry->ptr_to_next ;
   }	     
   proxy_filter_ptr->number_of_domain_name_entries = count ;	

   if (temp_number_of_entries < proxy_filter_ptr->number_of_domain_name_entries)
   {
		ULONG return_offset ;
   	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_DOMAIN_NAME_INFO) * (proxy_filter_ptr->number_of_domain_name_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_filter (&offset) ;
   	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
     	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 4) ;
     	proxy_domain_name_ptr = (CNF_PROXY_DOMAIN_NAME_INFO *) return_offset ;

		return_offset += (temp_number_of_entries * sizeof(CNF_PROXY_DOMAIN_NAME_INFO)) ;

		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset - 
			(sizeof(CNF_PROXY_DOMAIN_NAME_INFO) * (proxy_filter_ptr->number_of_domain_name_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (return_offset + ((proxy_filter_ptr->number_of_domain_name_entries - temp_number_of_entries) * sizeof(CNF_PROXY_DOMAIN_NAME_INFO))) ;
		memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
   }
   else
   {
     if (temp_number_of_entries > proxy_filter_ptr->number_of_domain_name_entries)
     {
			offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			calculate_offset_of_proxy_filter (&offset) ;
	   	proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   	  	calculate_offset_to_each_proxy_filter (&offset, &return_offset, 4) ;
     		proxy_domain_name_ptr = (CNF_PROXY_DOMAIN_NAME_INFO *) return_offset ;

			return_offset += (temp_number_of_entries * sizeof(CNF_PROXY_DOMAIN_NAME_INFO)) ;

   		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset) ;
	   	ULONG dst_offset = (ULONG) (return_offset - ((temp_number_of_entries - proxy_filter_ptr->number_of_domain_name_entries) * sizeof(CNF_PROXY_DOMAIN_NAME_INFO))) ;
   		_fmemmove ((void FAR *) dst_offset, (void FAR *) return_offset, (int) SizeToMove) ;

		  	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_DOMAIN_NAME_INFO) * (proxy_filter_ptr->number_of_domain_name_entries - temp_number_of_entries))) ;
   		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	   	all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
   		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
	   	proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
     }
   }
   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_filter (&offset) ;
   proxy_filter_ptr = (CNF_PROXY_FILTER *) offset ;
   calculate_offset_to_each_proxy_filter (&offset, &return_offset, 4) ;
   proxy_domain_name_ptr = (CNF_PROXY_DOMAIN_NAME_INFO *) return_offset ;

   domain_name_entry = filt_domain_name_start;
   while (domain_name_entry != NULL)
   {
		strcpy ((char *)proxy_domain_name_ptr->domain_name, domain_name_entry->domain_name) ;
    	domain_name_entry = domain_name_entry->ptr_to_next;
		proxy_domain_name_ptr++ ;
   }
   return TRUE ;
}


int add_proxy_application (PROXY_APPLICATION_ENTRIES *filt_appl_start, int number_of_entries) 
{
   ULONG offset ;
   USHORT temp_number_of_entries ;
   PROXY_APPLICATION_ENTRIES *app_entry ;
   CNF_PROXY_APPLICATION *proxy_application_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_application_entries (&offset) ;
   proxy_application_ptr = (CNF_PROXY_APPLICATION *) offset ;
   temp_number_of_entries = proxy_application_ptr->number_of_application_entries ;

   if ((app_entry = (PROXY_APPLICATION_ENTRIES *) malloc (sizeof (PROXY_APPLICATION_ENTRIES))) == NULL)
   	return FALSE ;
   app_entry = filt_appl_start ;

   proxy_application_ptr->number_of_application_entries = number_of_entries ;

   if (temp_number_of_entries < proxy_application_ptr->number_of_application_entries)
   {
		ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_APP) * (proxy_application_ptr->number_of_application_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
		
		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_application_entries (&offset) ;
      proxy_application_ptr = (CNF_PROXY_APPLICATION *) offset ;

		offset += (sizeof(USHORT) + (temp_number_of_entries * sizeof(CNF_PROXY_APP))) ;

		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset - 
			(sizeof(CNF_PROXY_APP) * (proxy_application_ptr->number_of_application_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (offset + (proxy_application_ptr->number_of_application_entries - temp_number_of_entries) * sizeof(CNF_PROXY_APP)) ;
		memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;
   }
   else
   {
     if (temp_number_of_entries > proxy_application_ptr->number_of_application_entries)
     {
			offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			calculate_offset_of_proxy_application_entries (&offset) ;
			proxy_application_ptr = (CNF_PROXY_APPLICATION *) offset ;

			offset += (sizeof(USHORT) + (temp_number_of_entries * sizeof(CNF_PROXY_APP))) ;

   		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset) ;
	   	ULONG dst_offset = (ULONG) (offset - ((temp_number_of_entries - proxy_application_ptr->number_of_application_entries) * sizeof(CNF_PROXY_APP))) ;
   		_fmemmove ((void FAR *) dst_offset, (void FAR *) offset, (int) SizeToMove) ;

		  	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_APP) * (proxy_application_ptr->number_of_application_entries - temp_number_of_entries))) ;
   		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	   	all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
   		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
	   	proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
     }
   }
   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_application_entries (&offset) ;
   proxy_application_ptr = (CNF_PROXY_APPLICATION *) offset ;

   int index = 0 ;
   app_entry = filt_appl_start ;
   while (app_entry != NULL)
   {
   	proxy_application_ptr->application_entries[index].protocol = app_entry->protocol ;
   	proxy_application_ptr->application_entries[index].port = app_entry->port ;
    	app_entry = app_entry->ptr_to_next;
		index++ ;
   }
   return TRUE ;
}

int add_proxy_user_defined_application (PROXY_USER_APPLICATION_ENTRIES *filt_appl_start, int number_of_entries) 
{
   ULONG offset ;
   USHORT temp_number_of_entries ;
   PROXY_USER_APPLICATION_ENTRIES *app_entry ;
   CNF_PROXY_USER_DEFINED_APPLICATION *proxy_user_defined_application_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_user_defined_application_entries (&offset) ;
   proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;
   temp_number_of_entries = proxy_user_defined_application_ptr->number_of_user_defined_application_entries ;

   if ((app_entry = (PROXY_USER_APPLICATION_ENTRIES *) malloc (sizeof (PROXY_USER_APPLICATION_ENTRIES))) == NULL)
   	return FALSE ;
   app_entry = filt_appl_start ;

   proxy_user_defined_application_ptr->number_of_user_defined_application_entries = number_of_entries ;

   if (temp_number_of_entries < proxy_user_defined_application_ptr->number_of_user_defined_application_entries)
   {
   	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_USER_DEFINED_APP) * 
	      (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_user_defined_application_entries (&offset) ;
		proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;

		offset += (sizeof(USHORT) + (temp_number_of_entries * sizeof(CNF_PROXY_USER_DEFINED_APP))) ;

		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset - 
			(sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (offset + 
		  (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - temp_number_of_entries) * sizeof(CNF_PROXY_USER_DEFINED_APP)) ;
		memmove ((void *) dst_offset, (void *) offset, (int) SizeToMove) ;
   }
   else
   {
     if (temp_number_of_entries > proxy_user_defined_application_ptr->number_of_user_defined_application_entries)
     {
			offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			calculate_offset_of_proxy_user_defined_application_entries (&offset) ;
			proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;

			offset += (sizeof(USHORT) + (temp_number_of_entries * sizeof(CNF_PROXY_USER_DEFINED_APP))) ;

   		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset) ;
	   	ULONG dst_offset = (ULONG) (offset - ((temp_number_of_entries - proxy_user_defined_application_ptr->number_of_user_defined_application_entries) * sizeof(CNF_PROXY_USER_DEFINED_APP))) ;
   		_fmemmove ((void FAR *) dst_offset, (void FAR *) offset, (int) SizeToMove) ;

		  	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (proxy_user_defined_application_ptr->number_of_user_defined_application_entries - temp_number_of_entries))) ;
   		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	   	all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
   		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
	   	proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
     }
   }
   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_user_defined_application_entries (&offset) ;
   proxy_user_defined_application_ptr = (CNF_PROXY_USER_DEFINED_APPLICATION *) offset ;

   int index = 0 ;
   app_entry = filt_appl_start ;
   while (app_entry != NULL)
   {
   	proxy_user_defined_application_ptr->user_defined_application_entries[index].protocol = app_entry->protocol ;
		proxy_user_defined_application_ptr->user_defined_application_entries[index].lower_port_number = app_entry->lower_port_number ;  
   	proxy_user_defined_application_ptr->user_defined_application_entries[index].higher_port_number = app_entry->higher_port_number ;
		strcpy ((char*)proxy_user_defined_application_ptr->user_defined_application_entries[index].port_description, app_entry->description) ; 
    	app_entry = app_entry->ptr_to_next;
		index++ ;
   }
   return TRUE ;
}

int add_proxy_static_mapping (STATIC_MAP_STRUCT *static_entry_start, int static_maps) 
{

   int count = 0 ;
   ULONG offset, return_offset, int_ip_addr ;
   USHORT temp_number_of_entries ;
   CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr ;
   STATIC_MAP_STRUCT *static_entry ;
   CNF_PROXY_STATIC_INFO  *static_mapping_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_virtual_entry (&offset) ;
   proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;

   if (static_maps == 0 && proxy_virtual_ptr->number_of_static_mapping_entries == 0)
   	return TRUE ;

   temp_number_of_entries = proxy_virtual_ptr->number_of_static_mapping_entries ;

   if ((static_entry = (STATIC_MAP_STRUCT *) malloc (sizeof (STATIC_MAP_STRUCT))) == NULL)
   	return FALSE ;

   proxy_virtual_ptr->number_of_static_mapping_entries = static_maps ;	

   if (temp_number_of_entries < proxy_virtual_ptr->number_of_static_mapping_entries)
   {
		ULONG return_offset ;
   	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_STATIC_INFO) * (proxy_virtual_ptr->number_of_static_mapping_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_virtual_entry (&offset) ;
		proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
   	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 1) ;
	   static_mapping_ptr = (CNF_PROXY_STATIC_INFO *) return_offset ;

		return_offset += (temp_number_of_entries * sizeof(CNF_PROXY_STATIC_INFO)) ;

		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset - 
			(sizeof(CNF_PROXY_STATIC_INFO) * (proxy_virtual_ptr->number_of_static_mapping_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (return_offset + ((proxy_virtual_ptr->number_of_static_mapping_entries - temp_number_of_entries) * sizeof(CNF_PROXY_STATIC_INFO))) ; 
		memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
   }
   else
   {
      if (temp_number_of_entries > proxy_virtual_ptr->number_of_static_mapping_entries)
      {
  			offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			calculate_offset_of_proxy_virtual_entry (&offset) ;
   		proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
	     	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 1) ;
   	  	static_mapping_ptr = (CNF_PROXY_STATIC_INFO *) return_offset ;

			return_offset += (temp_number_of_entries  * sizeof(CNF_PROXY_STATIC_INFO)) ;

   		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset) ;
	   	ULONG dst_offset = (ULONG) (return_offset - ((temp_number_of_entries - proxy_virtual_ptr->number_of_static_mapping_entries) * sizeof(CNF_PROXY_STATIC_INFO))) ;
   		_fmemmove ((void FAR *) dst_offset, (void FAR *) return_offset, (int) SizeToMove) ;

		  	ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_STATIC_INFO) * (proxy_virtual_ptr->number_of_static_mapping_entries - temp_number_of_entries))) ;
   		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	   	all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
   		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
	   	proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
      }
   }

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_virtual_entry (&offset) ;
   proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 1) ;
   static_mapping_ptr = (CNF_PROXY_STATIC_INFO *) return_offset ;

   static_entry = static_entry_start;
   while (static_entry != NULL)
   {
		get_ip_address (static_entry->local_addr, &int_ip_addr) ;
		static_mapping_ptr->local_address = int_ip_addr ;
		get_ip_address (static_entry->global_addr, &int_ip_addr) ;
		static_mapping_ptr->global_address = int_ip_addr ;
    	static_entry = static_entry->ptr_to_next;
		static_mapping_ptr++ ;
   }
   return TRUE ;
}

int add_proxy_dynamic_mapping (DYNAMIC_MAP_STRUCT *dynamic_entry_start, char dyn_global_addr[16], int dyn_maps) 
{
   int count = 0 ;
   ULONG offset, return_offset, int_ip_addr, SizeToRealloc ;
   USHORT temp_number_of_entries, temp_int ;
   CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_ptr ;
   DYNAMIC_MAP_STRUCT *dynamic_entry ;
   CNF_PROXY_DYNAMIC_INFO  *dynamic_mapping_ptr ;

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_virtual_entry (&offset) ;
   proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;

   if (dyn_maps == 0 && proxy_virtual_ptr->number_of_dynamic_mapping_entries == 0)
   	return TRUE ;

   temp_number_of_entries = proxy_virtual_ptr->number_of_dynamic_mapping_entries ;

   if ((dynamic_entry = (DYNAMIC_MAP_STRUCT *) malloc (sizeof (DYNAMIC_MAP_STRUCT))) == NULL)
   	return FALSE ;

   proxy_virtual_ptr->number_of_dynamic_mapping_entries = dyn_maps ;	

   if (temp_number_of_entries < proxy_virtual_ptr->number_of_dynamic_mapping_entries)
   {
   	SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_DYNAMIC_INFO) * (proxy_virtual_ptr->number_of_dynamic_mapping_entries - temp_number_of_entries))) ;
		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
		all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
		proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;

		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		calculate_offset_of_proxy_virtual_entry (&offset) ;
		proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
   	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 2) ;
	   dynamic_mapping_ptr = (CNF_PROXY_DYNAMIC_INFO *) return_offset ;

		return_offset += (temp_number_of_entries * sizeof(CNF_PROXY_DYNAMIC_INFO)) ;
		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset - 
			(sizeof(CNF_PROXY_DYNAMIC_INFO) * (proxy_virtual_ptr->number_of_dynamic_mapping_entries - temp_number_of_entries))) ;
		ULONG dst_offset = (return_offset + (proxy_virtual_ptr->number_of_dynamic_mapping_entries - temp_number_of_entries) * sizeof(CNF_PROXY_DYNAMIC_INFO)) ; 
		memmove ((void *) dst_offset, (void *) return_offset, (int) SizeToMove) ;
   }
   else
   {
      if (temp_number_of_entries > proxy_virtual_ptr->number_of_dynamic_mapping_entries)
      {
		  	offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			calculate_offset_of_proxy_virtual_entry (&offset) ;
   		proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
	     	calculate_offset_to_each_proxy_entry (&offset, &return_offset, 2) ;
   	  	dynamic_mapping_ptr = (CNF_PROXY_DYNAMIC_INFO *) return_offset ;

			return_offset += (temp_number_of_entries  * sizeof(CNF_PROXY_DYNAMIC_INFO)) ;

   		ULONG SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - return_offset) ;
	   	ULONG dst_offset = (ULONG) (return_offset - ((temp_number_of_entries - proxy_virtual_ptr->number_of_dynamic_mapping_entries) * sizeof(CNF_PROXY_DYNAMIC_INFO))) ;
   		_fmemmove ((void FAR *) dst_offset, (void FAR *) return_offset, (int) SizeToMove) ;

		  	SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(CNF_PROXY_DYNAMIC_INFO) * (proxy_virtual_ptr->number_of_dynamic_mapping_entries - temp_number_of_entries))) ;
   		all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
	   	all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
   		all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
   		proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
	   	proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
      }
   }

   offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
   calculate_offset_of_proxy_virtual_entry (&offset) ;
   proxy_virtual_ptr = (CNF_PROXY_VIRTUAL_SERVER *) offset ;
   calculate_offset_to_each_proxy_entry (&offset, &return_offset, 2) ;
   dynamic_mapping_ptr = (CNF_PROXY_DYNAMIC_INFO *) return_offset ;

   get_ip_address (dyn_global_addr, &int_ip_addr) ;
   proxy_virtual_ptr->dynamic_mapping_global_address = int_ip_addr ;

   dynamic_entry = dynamic_entry_start ;
   while (dynamic_entry != NULL)
   {
		get_ip_address (dynamic_entry->local_addr, &int_ip_addr) ;
		dynamic_mapping_ptr->local_address = int_ip_addr ;
		sscanf (dynamic_entry->protocol, "%d", &temp_int) ;
		dynamic_mapping_ptr->protocol = temp_int ;
      sscanf (dynamic_entry->port, "%d", &temp_int) ;
		dynamic_mapping_ptr->port = temp_int ;

    	dynamic_entry = dynamic_entry->ptr_to_next ;
		dynamic_mapping_ptr++ ;
   }
   return TRUE ;
}

void  change_old_ip_structure(int flag)
{
   int number_of_ports = 0 ;

	if (flag)
		number_of_ports = upgrade_ip_ptr->ip_header.number_of_ports ;
	else
      number_of_ports = change_endian (upgrade_ip_ptr->ip_header.number_of_ports) ;

   upgrade_ip_ptr->ip_header.magic_number = change_endian(upgrade_ip_ptr->ip_header.magic_number) ;
   upgrade_ip_ptr->ip_header.section_length = change_endian(upgrade_ip_ptr->ip_header.section_length) ;
   upgrade_ip_ptr->ip_header.number_of_ports = change_endian(upgrade_ip_ptr->ip_header.number_of_ports) ;
   upgrade_ip_ptr->ip_header.default_gateway = ltl_endian_word(upgrade_ip_ptr->ip_header.default_gateway) ;
   upgrade_ip_ptr->ip_header.primary_address = ltl_endian_word(upgrade_ip_ptr->ip_header.primary_address) ;
   upgrade_ip_ptr->ip_header.secondary_address = ltl_endian_word(upgrade_ip_ptr->ip_header.secondary_address) ;

   for (int i = 0; i < number_of_ports; i++)
   {
     upgrade_ip_ptr->ip_ports[i].ip_address = ltl_endian_word(upgrade_ip_ptr->ip_ports[i].ip_address) ;
     upgrade_ip_ptr->ip_ports[i].subnet_mask = ltl_endian_word(upgrade_ip_ptr->ip_ports[i].subnet_mask) ;
   }
}

void change_old_wan_structure (int flag)
{
   int number_of_ports = 0 ;
   if (flag)
   	number_of_ports = upgrade_wan_ptr->wan_header.number_of_ports ;
   else
      number_of_ports = change_endian (upgrade_wan_ptr->wan_header.number_of_ports) ;

   upgrade_wan_ptr->wan_header.magic_number = change_endian(upgrade_wan_ptr->wan_header.magic_number) ;
   upgrade_wan_ptr->wan_header.section_length = change_endian(upgrade_wan_ptr->wan_header.section_length) ;
   upgrade_wan_ptr->wan_header.number_of_ports = change_endian(upgrade_wan_ptr->wan_header.number_of_ports) ;

	for (int i = 0; i < number_of_ports; i++)
		upgrade_wan_ptr->wan_ports[i].speed = ltl_endian_word(upgrade_wan_ptr->wan_ports[i].speed) ;
}

void change_old_ppp_structure (int flag)
{
	int number_of_ports = 0 ;
   if (flag)
		number_of_ports = upgrade_ppp_ptr->ppp_header.number_of_ports ;
   else
      number_of_ports = change_endian (upgrade_ppp_ptr->ppp_header.number_of_ports) ;

   upgrade_ppp_ptr->ppp_header.magic_number = change_endian(upgrade_ppp_ptr->ppp_header.magic_number) ;
   upgrade_ppp_ptr->ppp_header.section_length = change_endian(upgrade_ppp_ptr->ppp_header.section_length) ;
   upgrade_ppp_ptr->ppp_header.number_of_ports = change_endian(upgrade_ppp_ptr->ppp_header.number_of_ports) ;
   
   for (int i = 0; i < number_of_ports; i++)
   {
      upgrade_ppp_ptr->ppp_ports[i].hangup_time = change_endian(upgrade_ppp_ptr->ppp_ports[i].hangup_time) ;
      upgrade_ppp_ptr->ppp_ports[i].lcp_accm.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].lcp_accm.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].remote_lcp_accm.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].remote_lcp_accm.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].lcp_mru.value_type =  change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].lcp_mru.value_type) ;   
      upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mru.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mru.value_type) ;   
      upgrade_ppp_ptr->ppp_ports[i].remote_lcp_authentication.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].remote_lcp_authentication.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].lcp_magic_number.value_type =  change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].lcp_magic_number.value_type) ;   
      upgrade_ppp_ptr->ppp_ports[i].remote_lcp_magic_number.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].remote_lcp_magic_number.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].ipcp_ip_address.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].ipcp_ip_address.value_type) ;   
      upgrade_ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].remote_ipcp_ip_address.value_type) ; 
      upgrade_ppp_ptr->ppp_ports[i].lcp_epd.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].lcp_epd.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].remote_lcp_epd.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].remote_lcp_epd.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].lcp_mrru.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].lcp_mrru.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mrru.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].remote_lcp_mrru.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].remote_lcp_callback.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].remote_lcp_callback.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address1.value_type = change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address1.value_type) ;
      upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address2.value_type =  change_endian_enum(upgrade_ppp_ptr->ppp_ports[i].ipcp_dns_address2.value_type) ;
   }
}  

void change_old_proxy_structure (int flag)
{
	CNF_PROXY_VIRTUAL_SERVER *proxy_virtual_server_ptr ;
   CNF_PROXY_APPLICATION   *proxy_application_ptr ;
   CNF_PROXY_USER_DEFINED_APPLICATION   *proxy_user_defined_application_ptr ;
   CNF_PROXY_FILTER *proxy_filter_ptr ; 
   CNF_PROXY_PORT *proxy_port_ptr ; 
   CNF_PROXY_ADDRESS_INFO *proxy_global_ptr ;
   CNF_PROXY_STATIC_INFO *static_mapping_ptr ;
   CNF_PROXY_DYNAMIC_INFO *dynamic_mapping_ptr ;
   CNF_PROXY_ADDRESS_INFO *proxy_forbidden_sites_ptr ;
   CNF_PROXY_ADDRESS_INFO *proxy_restricted_clients_ptr ;
   CNF_PROXY_APP *proxy_restricted_application_ptr ;

   int number_of_application_entries, number_of_user_defined_application_entries, number_of_ports ;
   int number_of_global_address_entries, number_of_static_mapping_entries, number_of_dynamic_mapping_entries ;
   int number_of_forbidden_sites_entries, number_of_restricted_clients_entries, number_of_mac_address_entries ;
   int number_of_domain_name_entries, number_of_restricted_application_entries, number_of_address_entries ;
	int i, k ;
   upgrade_proxy_header_ptr = ((CNF_UPGRADE_PROXY_HEADER *)(temp_upgrade_structures[PROXY_ID].ptr_to_struct)) ;

   upgrade_proxy_header_ptr->magic_number = change_endian(upgrade_proxy_header_ptr->magic_number) ;
   upgrade_proxy_header_ptr->section_length = change_endian(upgrade_proxy_header_ptr->section_length) ;

	if (flag)
		number_of_ports = upgrade_proxy_header_ptr->number_of_ports ;
	else
		number_of_ports = change_endian (upgrade_proxy_header_ptr->number_of_ports) ;

	upgrade_proxy_header_ptr->number_of_ports = change_endian(upgrade_proxy_header_ptr->number_of_ports) ;

   proxy_application_ptr = ((CNF_PROXY_APPLICATION *)((char *)upgrade_proxy_header_ptr + sizeof(CNF_UPGRADE_PROXY_HEADER))) ; 

   if (flag)
		number_of_application_entries = proxy_application_ptr->number_of_application_entries ;
	else
		number_of_application_entries = change_endian (proxy_application_ptr->number_of_application_entries) ;

	proxy_application_ptr->number_of_application_entries = change_endian(proxy_application_ptr->number_of_application_entries) ;
   for (i = 0; i < number_of_application_entries; i++)
   {
		proxy_application_ptr->application_entries[i].port = change_endian(proxy_application_ptr->application_entries[i].port) ;
      proxy_application_ptr->application_entries[i].protocol = change_endian(proxy_application_ptr->application_entries[i].protocol) ;
	}

   proxy_user_defined_application_ptr = ((CNF_PROXY_USER_DEFINED_APPLICATION *)((char *) proxy_application_ptr + (sizeof(CNF_PROXY_APPLICATION) + (sizeof(ULONG) * (number_of_application_entries - 1))))) ; 

   if (flag)
		number_of_user_defined_application_entries = proxy_user_defined_application_ptr->number_of_user_defined_application_entries ;
	else
		number_of_user_defined_application_entries = change_endian (proxy_user_defined_application_ptr->number_of_user_defined_application_entries) ;

	proxy_user_defined_application_ptr->number_of_user_defined_application_entries = change_endian (proxy_user_defined_application_ptr->number_of_user_defined_application_entries) ;

   for (i = 0; i < number_of_user_defined_application_entries; i++)
	{
		proxy_user_defined_application_ptr->user_defined_application_entries[i].protocol = change_endian(proxy_user_defined_application_ptr->user_defined_application_entries[i].protocol) ;
		proxy_user_defined_application_ptr->user_defined_application_entries[i].lower_port_number = change_endian(proxy_user_defined_application_ptr->user_defined_application_entries[i].lower_port_number) ; 
      proxy_user_defined_application_ptr->user_defined_application_entries[i].higher_port_number = change_endian(proxy_user_defined_application_ptr->user_defined_application_entries[i].higher_port_number) ;
	}

   proxy_virtual_server_ptr = ((CNF_PROXY_VIRTUAL_SERVER *)((char *)proxy_user_defined_application_ptr + (sizeof(CNF_PROXY_USER_DEFINED_APPLICATION) + (sizeof(CNF_PROXY_USER_DEFINED_APP) * (number_of_user_defined_application_entries - 1))))) ;

   if (flag)
   {
		number_of_global_address_entries = proxy_virtual_server_ptr->number_of_global_address_entries ;
		number_of_static_mapping_entries = proxy_virtual_server_ptr->number_of_static_mapping_entries ;
		number_of_dynamic_mapping_entries = proxy_virtual_server_ptr->number_of_dynamic_mapping_entries	;
   }
   else
   {
		number_of_global_address_entries = change_endian (proxy_virtual_server_ptr->number_of_global_address_entries) ;
		number_of_static_mapping_entries = change_endian (proxy_virtual_server_ptr->number_of_static_mapping_entries) ;
		number_of_dynamic_mapping_entries = change_endian (proxy_virtual_server_ptr->number_of_dynamic_mapping_entries) ;
   }
   proxy_virtual_server_ptr->number_of_global_address_entries = change_endian(proxy_virtual_server_ptr->number_of_global_address_entries) ;
   proxy_virtual_server_ptr->number_of_static_mapping_entries = change_endian(proxy_virtual_server_ptr->number_of_static_mapping_entries) ;
   proxy_virtual_server_ptr->number_of_dynamic_mapping_entries = change_endian(proxy_virtual_server_ptr->number_of_dynamic_mapping_entries) ;
   proxy_virtual_server_ptr->dynamic_mapping_global_address = ltl_endian_word(proxy_virtual_server_ptr->dynamic_mapping_global_address) ;

   proxy_global_ptr = ((CNF_PROXY_ADDRESS_INFO *) ((char *) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG))) ;

   for (i = 0; i < number_of_global_address_entries; i++)
   {
		proxy_global_ptr->address = ltl_endian_word(proxy_global_ptr->address) ;
		proxy_global_ptr++ ;
   }

   static_mapping_ptr = ((CNF_PROXY_STATIC_INFO *) ((char *) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG) +
		  (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_global_address_entries))) ;

   for (i = 0; i < number_of_static_mapping_entries; i++)
   {
		static_mapping_ptr->global_address = ltl_endian_word(static_mapping_ptr->global_address) ;
		static_mapping_ptr->local_address = ltl_endian_word(static_mapping_ptr->local_address) ;
		static_mapping_ptr++ ;
   }

   dynamic_mapping_ptr = ((CNF_PROXY_DYNAMIC_INFO *) ((char *) proxy_virtual_server_ptr + (3 * sizeof(USHORT)) + sizeof(ULONG) +
		   (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_global_address_entries) +
		   (sizeof(CNF_PROXY_STATIC_INFO) * number_of_static_mapping_entries))) ;

   for (i = 0; i < number_of_dynamic_mapping_entries; i++)
   {
		dynamic_mapping_ptr->local_address = ltl_endian_word(dynamic_mapping_ptr->local_address) ;
		dynamic_mapping_ptr->port = change_endian(dynamic_mapping_ptr->port) ;
		dynamic_mapping_ptr->protocol = change_endian(dynamic_mapping_ptr->protocol) ;
		dynamic_mapping_ptr++ ;
   }

   proxy_filter_ptr = ((CNF_PROXY_FILTER *)(((char *)proxy_virtual_server_ptr + sizeof(CNF_PROXY_VIRTUAL_SERVER)) + ( 
                          (number_of_global_address_entries - 1 ) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                          (number_of_static_mapping_entries - 1 ) * sizeof(CNF_PROXY_STATIC_INFO) +
                          (number_of_dynamic_mapping_entries - 1 ) * sizeof(CNF_PROXY_DYNAMIC_INFO)))) ; 

   if (flag)
   { 
   	number_of_forbidden_sites_entries = proxy_filter_ptr->number_of_forbidden_sites_entries ;  
		number_of_restricted_clients_entries = proxy_filter_ptr->number_of_restricted_clients_entries ;  
		number_of_restricted_application_entries = proxy_filter_ptr->number_of_restricted_application_entries ;  
		number_of_mac_address_entries = proxy_filter_ptr->number_of_mac_address_entries ;  
		number_of_domain_name_entries = proxy_filter_ptr->number_of_domain_name_entries ;  
   }
   else
   {
   	number_of_forbidden_sites_entries = change_endian(proxy_filter_ptr->number_of_forbidden_sites_entries) ;  
		number_of_restricted_clients_entries = change_endian(proxy_filter_ptr->number_of_restricted_clients_entries) ;  
		number_of_restricted_application_entries = change_endian(proxy_filter_ptr->number_of_restricted_application_entries) ;  
		number_of_mac_address_entries = change_endian(proxy_filter_ptr->number_of_mac_address_entries) ;  
		number_of_domain_name_entries = change_endian(proxy_filter_ptr->number_of_domain_name_entries) ;  
   }
   proxy_filter_ptr->number_of_forbidden_sites_entries = change_endian(proxy_filter_ptr->number_of_forbidden_sites_entries) ;  
   proxy_filter_ptr->number_of_restricted_clients_entries = change_endian(proxy_filter_ptr->number_of_restricted_clients_entries) ;  
   proxy_filter_ptr->number_of_restricted_application_entries = change_endian(proxy_filter_ptr->number_of_restricted_application_entries) ;  
   proxy_filter_ptr->number_of_mac_address_entries = change_endian(proxy_filter_ptr->number_of_mac_address_entries) ;  
   proxy_filter_ptr->number_of_domain_name_entries = change_endian(proxy_filter_ptr->number_of_domain_name_entries) ;  

   proxy_forbidden_sites_ptr = ((CNF_PROXY_ADDRESS_INFO *) ((char*) proxy_filter_ptr + (NUMBER_OF_PROXY_FILTERS * sizeof(USHORT)))) ;

   for (i = 0; i < number_of_forbidden_sites_entries; i++)
   {
		proxy_forbidden_sites_ptr->address = ltl_endian_word(proxy_forbidden_sites_ptr->address) ;
		proxy_forbidden_sites_ptr++ ;
   }

   proxy_restricted_clients_ptr = ((CNF_PROXY_ADDRESS_INFO *) ((char*) proxy_filter_ptr + (NUMBER_OF_PROXY_FILTERS * sizeof(USHORT)) +
				   (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_forbidden_sites_entries))) ;

   for (i = 0; i < number_of_restricted_clients_entries; i++)
   {
		proxy_restricted_clients_ptr->address = ltl_endian_word(proxy_restricted_clients_ptr->address) ;
		proxy_restricted_clients_ptr++ ;
   }

   proxy_restricted_application_ptr = ((CNF_PROXY_APP *) ((char*) proxy_filter_ptr + (NUMBER_OF_PROXY_FILTERS * sizeof(USHORT)) +
				       (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_forbidden_sites_entries) +
				       (sizeof(CNF_PROXY_ADDRESS_INFO) * number_of_restricted_clients_entries))) ;

   for (i = 0; i < number_of_restricted_application_entries; i++)
   {
		proxy_restricted_application_ptr->port = change_endian(proxy_restricted_application_ptr->port) ;
      proxy_restricted_application_ptr->protocol = change_endian(proxy_restricted_application_ptr->protocol) ; 
		proxy_restricted_application_ptr++ ;
   }

   proxy_port_ptr = ((CNF_PROXY_PORT *)((char*) proxy_filter_ptr + sizeof(CNF_PROXY_FILTER) + (
                      (number_of_forbidden_sites_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (number_of_restricted_clients_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO) +
                      (number_of_restricted_application_entries - 1) * sizeof(CNF_PROXY_APP) +
                      (number_of_mac_address_entries - 1) * sizeof(CNF_PROXY_MAC_ADDRESS_INFO) +
                      (number_of_domain_name_entries - 1) * sizeof(CNF_PROXY_DOMAIN_NAME_INFO)))) ; 

   for (i = 0; i < number_of_ports; i++) 
   {
		if (flag)
			number_of_address_entries = proxy_port_ptr->number_of_address_entries ;
		else
			number_of_address_entries = change_endian (proxy_port_ptr->number_of_address_entries) ;
		proxy_port_ptr->number_of_address_entries = change_endian(proxy_port_ptr->number_of_address_entries) ;
		proxy_port_ptr->number_of_connections_to_trigger = change_endian(proxy_port_ptr->number_of_connections_to_trigger) ;
		proxy_port_ptr->number_of_hosts_to_trigger = change_endian(proxy_port_ptr->number_of_hosts_to_trigger) ;
		for (k = 0; k < number_of_address_entries; k++) 
	   	proxy_port_ptr->port_address[k].address = ltl_endian_word(proxy_port_ptr->port_address[k].address) ;

		proxy_port_ptr =  ((CNF_PROXY_PORT *)((char*)proxy_port_ptr + sizeof(CNF_PROXY_PORT) + (number_of_address_entries - 1) * sizeof(CNF_PROXY_ADDRESS_INFO))) ;
   }
}

void change_old_dhcp_structure (int flag)
{
	CNF_DHCP_ADDRESS_RANGE *dhcp_address_range_entries_ptr ;
   int number_of_address_range_entries, number_of_bindings_entries ;
	int i, k ;

   upgrade_dhcp_header_ptr = (CNF_UPGRADE_DHCP_HEADER *) temp_upgrade_structures[DHCP_ID].ptr_to_struct ;

   if (flag)
   	number_of_address_range_entries = upgrade_dhcp_header_ptr->number_of_address_range_entries ;
   else
	   number_of_address_range_entries = change_endian (upgrade_dhcp_header_ptr->number_of_address_range_entries) ;

   upgrade_dhcp_header_ptr->magic_number = change_endian(upgrade_dhcp_header_ptr->magic_number) ;
   upgrade_dhcp_header_ptr->section_length = change_endian(upgrade_dhcp_header_ptr->section_length) ;
   upgrade_dhcp_header_ptr->number_of_address_range_entries = change_endian(upgrade_dhcp_header_ptr->number_of_address_range_entries) ;

   dhcp_address_range_entries_ptr = ((CNF_DHCP_ADDRESS_RANGE *)((char *)upgrade_dhcp_header_ptr + sizeof(CNF_UPGRADE_DHCP_HEADER))) ;
   for (i = 0; i < number_of_address_range_entries; i++)
   {
		if (flag)
      	number_of_bindings_entries = dhcp_address_range_entries_ptr->number_of_bindings_entries ;
		else
      	number_of_bindings_entries = change_endian(dhcp_address_range_entries_ptr->number_of_bindings_entries) ;

		dhcp_address_range_entries_ptr->lower_ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->lower_ip_address) ; 
		dhcp_address_range_entries_ptr->higher_ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->higher_ip_address) ; 
		dhcp_address_range_entries_ptr->address_mask = ltl_endian_word (dhcp_address_range_entries_ptr->address_mask) ; 
		dhcp_address_range_entries_ptr->number_of_bindings_entries = change_endian(dhcp_address_range_entries_ptr->number_of_bindings_entries) ;
		dhcp_address_range_entries_ptr->exclude_lower_ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->exclude_lower_ip_address) ; 
		dhcp_address_range_entries_ptr->exclude_higher_ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->exclude_higher_ip_address) ; 

		dhcp_address_range_entries_ptr->options_entries.router_address = ltl_endian_word (dhcp_address_range_entries_ptr->options_entries.router_address) ;      
		dhcp_address_range_entries_ptr->options_entries.reassembly_size = change_endian (dhcp_address_range_entries_ptr->options_entries.reassembly_size) ;      
		dhcp_address_range_entries_ptr->options_entries.mtu = change_endian (dhcp_address_range_entries_ptr->options_entries.mtu) ;      
		dhcp_address_range_entries_ptr->options_entries.lease_time = ltl_endian_word (dhcp_address_range_entries_ptr->options_entries.lease_time) ;      

		for (k = 0; k < number_of_bindings_entries; k++) 
      	dhcp_address_range_entries_ptr->bindings_entries[k].ip_address = ltl_endian_word (dhcp_address_range_entries_ptr->bindings_entries[k].ip_address) ;      

		dhcp_address_range_entries_ptr = ((CNF_DHCP_ADDRESS_RANGE *)((char *)dhcp_address_range_entries_ptr + sizeof(CNF_DHCP_ADDRESS_RANGE) +
                                  (number_of_bindings_entries - 1) * sizeof(CNF_BINDING_INFO))) ;  
   }
}
