// -------------------------------------------------------------------------
// Project Name	     :	MultiRouter Setup for Windows 
// File Name         :	WANDLG.CPP
// Description       :	Defines Classes :
//									CWANDlg		: Function of WAN Dialog
//									CWanPortDlg	: Function of WAN Port Tabs
//									CWanTab		: Function of WAN Port TabDialog
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:  17 Nov 1999     
// Modifications     :  2/11/95 Vidy added LSL speed updation for SNMP
// Modifications     :  2/11/95 Vidy fixed LSL speed updation 
// -------------------------------------------------------------------------
// Vidy   	  :  05/12/96 if only one wan don't show WAN 1
// Jyothi     : 22/06/98 made changes for small proxy
// Jyothi     : 22/06/98 structures used instead of INI files
//	Jyothi 	  : 17 Nov 1999. Made changes to handle MLPPP and Link Control Dependencies
// Jyothi	  : 29-Dec-1999. Made changes to prevent Assigned IP address from being overwritten 
//					 	and wrap around the address if required.
// Jyothi	  : 03-Jan-2000 Changed scheme to get next next available IP address for RAS clients 
//						that also includes duplication check
//
// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include <stdio.h>
#include "stdafx.h"
#include "procon.h"
#include "isdnta.h"
#include "wandlg.h"
#include "tabdlg.h"
#include "maindlg.h"
#include "modem.h"
#include "script.h"
#include "hardware.h"
#include "maskdot.h"
#include "cnffile.h"
#include "readbmp.h"
#include "utils.h"
					

// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------


LPCSTR DefaultConfigHeader = "Default Configs";
LPCSTR DefaultIniString = "Config1";
char TempSection[40];

LPCSTR IsdnMsgHeader = "ProxyServer Setup - Isdn Configuration" ; 

//Sudha 9 Dec 1997
char WanPortNum[12];
int m_cfgtype = 0;
LPCSTR MapHeader = "Port Mappings";
         
LPCSTR WANMsgHeader = "MultiRouter Setup - WAN" ;
LPCSTR WANSectionHeader = "WAN Serial Device Driver" ;
LPCSTR ScriptSectionHeader = "Script Section" ;

/* Jo 22/06/98 */
extern CNF_IP *ip_ptr ;
extern CNF_WAN *wan_ptr ;
extern CNF_PPP *ppp_ptr ;
extern CNF_PROXY_HEADER *proxy_header_ptr ;
extern CNF_DHCP_HEADER  *dhcp_header_ptr ;
/* Jo 22/06/98 */

static BOOL RouterStatus = FALSE ;
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


// Sudha 13 Feb 1998 
LPCSTR GetPriStr(LPCSTR strLHS)
{
   char strRHS[50];
   GetPrivateProfileString ( WANSectionHeader, strLHS,
         StrNull,strRHS,sizeof(strRHS),IniInWinForm );
   return strRHS;
}

/* Jo No ISDN */
#if 0
// Sudha 13 Feb 1998 
void ReadISDNInfoFromRouconIniToIsdntaIni(int PortIndex)
{
   char strLHS[50],strRHS[50],ConfigName[50];
   BOOL UsType = FALSE;
   int index = 0;
   
   sprintf ( strLHS,"ISDN WAN Port%d",PortIndex );
   strcpy ( strRHS,GetPriStr(strLHS));

   if ( strcmp ( strRHS,StrDisabled ) == 0)
   	return;

   sprintf ( strLHS,"ISDN WAN Port%d ConfigName",PortIndex);
   strcpy(ConfigName,GetPriStr(strLHS));
   if ( strcmp ( ConfigName,StrNull ) == 0 )
      return;

   else
   {
      sprintf ( strLHS,"ISDN Port%d Initialization String1",PortIndex);
      strcpy(strRHS,GetPriStr(strLHS));
      if ( strcmp ( strRHS,StrNull ) == 0 )
         return;
      switch ( strRHS[6] )
      {
         case '0' :
         case '1' :
         case '5' :
            UsType = TRUE;
            break;
         case '2' :
         case '3' :
         case '4' :
         case '6' :
            UsType = FALSE;
            break;
         default :
            UsType = FALSE;
            break;
      }
      if ( UsType )
      {
         strLHS[32]++;
         strcpy(strRHS,GetPriStr(strLHS));
         if (strcmp ( strRHS,StrNull))
            WritePrivateProfileString ( ConfigName,"DataSPID",&strRHS[6],ini_INIFilename );
         strLHS[32]++;
         strcpy(strRHS,GetPriStr(strLHS));
         if (strcmp ( strRHS,StrNull))
            WritePrivateProfileString ( ConfigName,"VoiceSPID",&strRHS[7],ini_INIFilename );
         strLHS[32]++;
         strcpy(strRHS,GetPriStr(strLHS));
         if (strcmp ( strRHS,StrNull))
            WritePrivateProfileString ( ConfigName,"DataDirectoryNumber",&strRHS[6],ini_INIFilename );
         strLHS[32]++;
         strcpy(strRHS,GetPriStr(strLHS));
         if (strcmp ( strRHS,StrNull))
            WritePrivateProfileString ( ConfigName,"VoiceDirectoryNumber",&strRHS[7],ini_INIFilename );
      }
      else
      {
         strLHS[32]+=3;
         strcpy(strRHS,GetPriStr(strLHS));
         if (strcmp ( strRHS,StrNull))
            WritePrivateProfileString ( ConfigName,
	        "DataMSN", &strRHS[6], ini_INIFilename );
         strLHS[32]++;
         strcpy(strRHS,GetPriStr(strLHS));
         if (strcmp ( strRHS,StrNull))
            WritePrivateProfileString ( ConfigName,
	        "VoiceMSN",&strRHS[7],ini_INIFilename );
      }
      return;
   }
}


//Sudha 10 Feb 1998 
BOOL IsSPIDorISDN ( const char *command )
{
   if ((!strcmp(command,"!C6=")) || (!strcmp(command,"*!C6=")))
      return TRUE;
   if ((!strcmp(command,"!N1=")) || (!strcmp(command,"*!N1=")))
      return TRUE;
   else
      return FALSE; 
}

#endif
/* Jo */
/////////////////////////////////////////////////////////////////////////////
// CWANDlg dialog


CWANDlg::CWANDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWANDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWANDlg)
	m_WANEnable = TRUE;
	m_Printf = FALSE;
	m_PrintfRx = FALSE;
	m_PrintfTx = FALSE;
	m_PrintfInitialize = FALSE;
	m_bNonCriticalScriptPrintf = FALSE;
	m_bAlarmScriptPrintf = FALSE;
	m_szPPINISection = "";
	m_modem_type = "";
	//}}AFX_DATA_INIT

	m_bMdmConfigChanged = FALSE;
	m_nSelectedModem = CB_ERR ;
	m_nSelectedIsdn = CB_ERR ;
	IsdnEnabled = FALSE;
	Create(IDD,NULL);
}

void CWANDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWANDlg)
	DDX_Control(pDX, IDC_STATIC_ISDN_CONFIG_TYPES, m_ctrl_static_isdn_config_types);
	DDX_Control(pDX, IDC_STATIC_ISDN_CONTROL, m_IsdnCtrlWnd);
	DDX_Control(pDX, IDC_ISDN_EDIT, m_EditConfig);
	DDX_Control(pDX, IDC_ISDN_DELETE, m_DeleteConfig);
	DDX_Control(pDX, IDC_ISDN_ADD, m_AddConfig);
	DDX_Control(pDX, IDC_EXISTING_CFGS, m_INISectionControl);
	DDX_Control(pDX, IDC_CHECK_NON_CRITICAL, m_ChkBoxScriptNonCritical);
	DDX_Control(pDX, IDC_CHECK_SCRIPT_ALARM, m_ChkBoxScriptAlarm);
	DDX_Control(pDX, IDC_STATIC_SCRIPT_PRINTF_GRP, m_ScriptCtrlGrp);
	DDX_Control(pDX, IDC_BTN_ADD_MODEM, m_BtnAdd);
	DDX_Control(pDX, IDC_STATIC_MODEM_CONTROL, m_MdmCtrlWnd);
	DDX_Control(pDX, IDC_BTN_EDIT_MODEM, m_BtnEdit);
	DDX_Control(pDX, IDC_BTN_DELETE_MODEM, m_BtnDelete);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPES, m_combBoxModemTypes);
	DDX_Check(pDX, IDC_PRINTF, m_Printf);
	DDX_Check(pDX, IDC_PRINTF_RX, m_PrintfRx);
	DDX_Check(pDX, IDC_PRINTF_TX, m_PrintfTx);
	DDX_Check(pDX, IDC_INITIALIZE, m_PrintfInitialize);
	DDX_Check(pDX, IDC_CHECK_NON_CRITICAL, m_bNonCriticalScriptPrintf);
	DDX_Check(pDX, IDC_CHECK_SCRIPT_ALARM, m_bAlarmScriptPrintf);
	DDX_CBString(pDX, IDC_EXISTING_CFGS, m_szPPINISection);
	DDV_MaxChars(pDX, m_szPPINISection, 40);
	DDX_CBString(pDX, IDC_COMBO_MODEM_TYPES, m_modem_type);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWANDlg, CDialog)
	//{{AFX_MSG_MAP(CWANDlg)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEM_TYPES, OnSelchangeComboModemTypes)
	ON_BN_CLICKED(IDC_BTN_ADD_MODEM, OnBtnAddModem)
	ON_BN_CLICKED(IDC_BTN_EDIT_MODEM, OnBtnEditModem)
	ON_BN_CLICKED(IDC_BTN_DELETE_MODEM, OnBtnDeleteModem)
	ON_BN_CLICKED(IDC_ISDN_EDIT, OnIsdnEdit)
	ON_BN_CLICKED(IDC_ISDN_DELETE, OnIsdnDelete)
	ON_BN_CLICKED(IDC_ISDN_ADD, OnIsdnAdd)
	ON_CBN_SELCHANGE(IDC_EXISTING_CFGS, OnCfgs)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWANDlg message handlers

BOOL CWANDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!AddBmpBtn1.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn1.SubclassDlgItem (IDC_BTN_ADD_MODEM, this));
	AddBmpBtn1.SizeToContent();

	if (!DeleteBmpBtn1.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn1.SubclassDlgItem (IDC_BTN_DELETE_MODEM, this));
	DeleteBmpBtn1.SizeToContent();

	if (!EditBmpBtn1.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditBmpBtn1.SubclassDlgItem (IDC_BTN_EDIT_MODEM, this));
	EditBmpBtn1.SizeToContent();

	if (!AddBmpBtn2.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn2.SubclassDlgItem (IDC_ISDN_ADD, this));
	AddBmpBtn2.SizeToContent();

	if (!DeleteBmpBtn2.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn2.SubclassDlgItem (IDC_ISDN_DELETE, this));
	DeleteBmpBtn2.SizeToContent();

	if (!EditBmpBtn2.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditBmpBtn2.SubclassDlgItem (IDC_ISDN_EDIT, this));
	EditBmpBtn2.SizeToContent();

	if (!GetModemTypes())
	{
		CDialog::OnCancel() ;
		return FALSE ;
	}

	if (m_nSelectedModem != CB_ERR)
	     m_combBoxModemTypes.SetCurSel (m_nSelectedModem) ;

	CenterWindow() ;

   // Update the Dialog Box fields.
	UpdateData (FALSE) ;
	return TRUE ;  // return TRUE  unless you set the focus to a control
}


void CWANDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_WAN_CONFIG,HELP_CONTEXT);
}


void CWANDlg::OnOK()
{
	// Update the parameters from the Dialog Box.
	if (!UpdateData (TRUE))
            return ;

	// Write the WAN parameters to the INI file.

	if (m_bMdmConfigChanged)
		WriteToCnfFile() ;
	CWanTab *pParent = (CWanTab *) GetParent();
	for (int i = 0 ; i < pParent->tabcount ; i ++)
		pParent->WriteModemInfoToIni ();

	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

/*----------------------------------------------------------------------------
	Module 	: WriteToCnfFile
	Author 	: CFP
	Input  	: None
	Output 	: Boolean indicating any error while writing
	Synopsis	: Writes the Modem Info into the MODEMS.CNF file
				  along with the Header
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL CWANDlg::WriteToCnfFile()
{
	char szFilePath[200] ;
	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	// Rewrite Modems.Cnf file with new Modems Info
	fModemsPtr = fopen (szFilePath, "wb") ;
	if (fModemsPtr == NULL)
	{
		MessageBox ("Could not create MODEMS.CNF file",
			"File Creation Error", MB_OK | MB_ICONSTOP) ;

		// Before returning free all the buffers allocated
		// with new
		ReleaseBuffers() ;
		return FALSE ;
	}

	int nItems = m_combBoxModemTypes.GetCount() ;

	MODEMS_HDR ModemsHdr ;

	ModemsHdr.ChkSum = (WORD) 0 ; // Just like that
	ModemsHdr.Version = '1' ;  // For the time being
	ModemsHdr.NumEntries = (WORD) nItems ; // No. of modems
	fwrite (&ModemsHdr, sizeof (ModemsHdr), 1, fModemsPtr) ;

	MODEM_SETUP *pModemSetup ;

	// Write each Modem Info. one by one
	for (int i = 0 ; i < nItems ; i ++)
	{
		pModemSetup = (MODEM_SETUP *)
			m_combBoxModemTypes.GetItemDataPtr (i) ;
		fwrite ((MODEM_SETUP *) pModemSetup, 
				sizeof (MODEM_SETUP), 1, fModemsPtr) ;
	}

	// This is to ensure that "Direct Connection"
	// still goes with the modems.cnf file
	MODEM_SETUP DirConnect ;
	memset (&DirConnect, 0x00, sizeof (MODEM_SETUP)) ;
	strcpy (DirConnect.ModemType, "Direct Connection") ;
	fwrite (&DirConnect, sizeof (MODEM_SETUP), 1, fModemsPtr) ;

	fclose (fModemsPtr) ;
		
	// Open Modems.Cnf file in Read-Write-Binary Mode
	fModemsPtr = fopen (szFilePath, "r+b") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(), "Error writing MODEMS.CNF!!!",
				"Warning", MB_OK) ;

		// Before returning free all the buffers allocated
		// with new
		ReleaseBuffers() ;
		return FALSE ;
	}
		
	if (!WriteCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(), "Error writing MODEMS.CNF!!!",
				"Warning", MB_OK) ;
	}
	fclose (fModemsPtr) ;

	// Before returning free all the buffers allocated
	// with new
	ReleaseBuffers() ;
	m_bMdmConfigChanged = FALSE;  // Jo 09/04/99
	return TRUE ;
}

/*----------------------------------------------------------------------------
	Module 	: ReleaseBuffers
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Releases all Buffers allocated for storing
				  the Modems Information	
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::ReleaseBuffers()
{
	int nItems = m_combBoxModemTypes.GetCount() ;
	MODEM_SETUP *pModemSetup ;

	for (int i = 0 ; i < nItems ; i ++)
	{
		pModemSetup = (MODEM_SETUP *) 
				m_combBoxModemTypes.GetItemDataPtr (i) ;
		delete pModemSetup ;
	}
	return ;
}

/*----------------------------------------------------------------------------
	Module 	: PutModemsInParentsList
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Puts the Modems List into each of the Tab's Combo Boxes
				  And depending on the previous selection	restores them
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::PutModemsInParentsList()
{
	CWanTab *pParent = (CWanTab *) GetParent() ;
	int nCount = m_combBoxModemTypes.GetCount() ;

	char szBuf[40] ;
	int nIndex ;

	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		// Get the previous selection
		nIndex = pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
		if (nIndex != CB_ERR)
		{
			pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText (nIndex, szBuf) ;
			pParent->m_pdlgWAN[i]->m_szOldModemSel = szBuf ;
		}
		else
			pParent->m_pdlgWAN[i]->m_szOldModemSel = "" ;
			
		// Refresh the Modems List in the Combo Box
		pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent() ;

		// Add Modems to List
		for (int j = 0 ; j < nCount ; j ++)
		{
			m_combBoxModemTypes.GetLBText (j, (LPSTR) szBuf) ;
			if (strcmp (szBuf, "Direct Connection") != 0)
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (szBuf) ;
		}

		// If there was a previous selection restore it
		if (!pParent->m_pdlgWAN[i]->m_szOldModemSel.IsEmpty())
		{
			nIndex =	
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1, 
								pParent->m_pdlgWAN[i]->m_szOldModemSel) ;								
			pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nIndex) ;
		}	
	}
	
}

void CWANDlg::PutIsdnConfigInParentsList (int index)
{
/* Jo No ISDN */
#if 0
	CWanTab *pParent = (CWanTab *) GetParent() ;
 	int nCount = m_INISectionControl.GetCount() ;

	char szBuf[40] ;
	int nIndex ;
	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		// Get the previous selection
		if ( i == index )
		{
			nIndex = pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
			if (nIndex != CB_ERR)
			{
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText (nIndex, szBuf) ;
				pParent->m_pdlgWAN[i]->m_szOldIsdnSel = szBuf ;
			}
			else
				pParent->m_pdlgWAN[i]->m_szOldIsdnSel = "" ;
			
			// Refresh the Isdn Configs List in the Combo Box
			pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent() ;
			
			// Add Isdn Configs to List
			for (int j = 0 ; j < nCount ; j ++)
			{
				m_INISectionControl.GetLBText (j, (LPSTR) szBuf) ;
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (szBuf) ;
			}

			// If there was a previous selection restore it
			if (!pParent->m_pdlgWAN[i]->m_szOldIsdnSel.IsEmpty())
			{
				nIndex =	
					pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1, 
									pParent->m_pdlgWAN[i]->m_szOldIsdnSel) ;								
				if ( nIndex == CB_ERR)
					nIndex = 0;
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nIndex) ;

			}
		}	
	}		
#endif
/* Jo */
}


/*----------------------------------------------------------------------------
	Module 	: OnBtnAddModem
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: On Clicking Add Modems Button processing takes place here
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::OnBtnAddModem()
{
	// TODO: Add your control notification handler code here

	CModemTypes cModem;
	cModem.m_bActionAdd = TRUE ;

	int nRetVal = cModem.DoModal() ;
	if (nRetVal == IDOK)
	{
		m_bMdmConfigChanged = TRUE ;
				
	}
	EnableButtons() ;
}

/*----------------------------------------------------------------------------
	Module 	: OnBtnDelModem
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Confirm and Delete selected Modem Info 
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::OnBtnDeleteModem()
{
	// TODO: Add your control notification handler code here

	int nSelected  = m_combBoxModemTypes.GetCurSel() ;

	// If none selected return
	if (nSelected == CB_ERR)
		return ;

	int nRetVal = ::MessageBox (GetSafeHwnd(),
			"Do you want to delete this modem ?",
				"Modem Information", MB_YESNO | MB_ICONQUESTION) ;
	if (nRetVal == IDNO)
		return ;

	MODEM_SETUP *pModemSetup = (MODEM_SETUP *) 
							m_combBoxModemTypes.GetItemDataPtr (nSelected) ;
	delete pModemSetup ;

	m_combBoxModemTypes.DeleteString (nSelected) ;
	CWanTab *pParent = (CWanTab *)GetParent();
	for (int index = 0; index < pParent->tabcount; index++)
		pParent->m_pdlgWAN[index]->m_ComBoxModemTypes.DeleteString (nSelected) ;

	m_bMdmConfigChanged = TRUE ;
	EnableButtons() ;
	PutModemsInParentsList() ;
	UpdateData (FALSE) ;

	return ;
}

/*----------------------------------------------------------------------------
	Module 	: OnBtnEditModem
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Let user Edit Modem Info 
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::OnBtnEditModem()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);

	int nSelected  = m_combBoxModemTypes.GetCurSel() ;
	// If none selected return
	if (nSelected == CB_ERR)
		return ;

	CModemTypes cModem;
	cModem.m_bActionAdd = FALSE ;
	int nRetVal = cModem.DoModal() ;
	if (nRetVal == IDOK)
	{
		m_bMdmConfigChanged = TRUE ;
//		int nCurSel = m_combBoxModemTypes.GetCurSel();
	}	
	EnableButtons() ;

	return ;
}

/*----------------------------------------------------------------------------
	Module 	: EnableButtons
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: If No modems in List disable Edit and Delete Buttons
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::EnableButtons() 
{
	BOOL fEnable = FALSE ;

	int nCount = m_combBoxModemTypes.GetCount() ;
	if (nCount)
		fEnable = TRUE ;

	m_BtnEdit.EnableWindow (fEnable) ;
	m_BtnDelete.EnableWindow (fEnable) ;
	
	return ;
}

/*----------------------------------------------------------------------------
	Module 	: GetModemTypes
	Author 	: CFP
	Input  	: None
	Output 	: Boolean indicating any read error
	Synopsis	: List all Modems from the Cnf file
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL CWANDlg::GetModemTypes()
{
	char szFilePath[200] ; // For MODEMS.CNF File

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	// Refresh the Combo Box
	m_combBoxModemTypes.ResetContent() ;

	fModemsPtr = fopen (szFilePath, "rb") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
					"File Open Error", MB_OK) ;
		EnableButtons() ;
		return TRUE ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(), "Invalid MODEMS.CNF file",
																"Warning", MB_OK) ;
		EnableButtons() ;
		return TRUE ;
	} 

	// Jump directly to Modems Info bypassing the header
	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;

	int nIndex ;

	while (TRUE)
	{
		MODEM_SETUP *MdmSetupPtr = (MODEM_SETUP *) new (MODEM_SETUP) ;
		if (MdmSetupPtr == NULL)
		{
			::MessageBox (GetSafeHwnd(), "Insufficient Memory",
				"Modem Setup", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
		if (fread (MdmSetupPtr, sizeof (MODEM_SETUP), 1, fModemsPtr) < 1)
		{
			delete MdmSetupPtr ;
			break ;
		}
		if (strcmp (MdmSetupPtr->ModemType, "Direct Connection") != 0)
		{
			nIndex = m_combBoxModemTypes.AddString (MdmSetupPtr->ModemType) ;
			m_combBoxModemTypes.SetItemDataPtr (nIndex, (MODEM_SETUP *) MdmSetupPtr) ;  
		}
	}
	EnableButtons() ;
	m_combBoxModemTypes.SetCurSel(0);
	fclose (fModemsPtr) ;
	return TRUE ;
}

void CWANDlg::OnSelchangeComboModemTypes()
{
	// TODO: Add your control notification handler code here
	int nIndex = m_combBoxModemTypes.GetCurSel() ;

	CString DirectConnectStr ;
	m_combBoxModemTypes.GetLBText (nIndex, DirectConnectStr) ;
	if (DirectConnectStr == MODEM_TYPE_DIRECT_CONNECT)
	{
		m_BtnEdit.EnableWindow (FALSE) ;
		return ;
	}
	m_BtnEdit.EnableWindow (TRUE) ;
	return ;
}


void CWANDlg::GetIsdnTypes ()
{
/* Jo No ISDN */
#if 0
	char strLHS[40],strRHS[40],buffer[512];
	char *token;
	char *seps = "\0";
	int length = 0;
	int total;
	CString szDefaultConfig;
	
	m_INISectionControl.ResetContent();
	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
		if ( m_INISectionControl.FindStringExact ( -1, strRHS ) == CB_ERR )
		{
			// Insert the string in the list box
			m_INISectionControl.AddString( strRHS );
		}
		strLHS[6]++;
   } 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	if ( total != 0 )
	{
		token = strtok ( buffer, seps );
		while ( token != NULL)
		{
			if ( m_INISectionControl.FindStringExact ( -1, token ) == CB_ERR )
			{
				// Insert the string in the list box
				m_INISectionControl.AddString( token );
			}	
			length = length + strlen ( token ) + 1;	// +1 for the NULL character
	      token = strtok( &buffer[length], seps );
		}
	}
	
	if ( m_nSelectedIsdn != CB_ERR )
	{
		m_INISectionControl.SetCurSel ( m_nSelectedIsdn );
      m_INISectionControl.GetLBText ( m_INISectionControl.GetCurSel(),m_szPPINISection );
	}
#endif
/* Jo */
}

void CWANDlg::OnIsdnEdit()
{
/* Jo No ISDN */
#if 0
	// TODO: Add your control notification handler code here
	
	m_cfgtype = kEdit;
	CIsdnTa Isdn (this);
	Isdn.DoModal();
#endif
/* Jo */
}

void CWANDlg::OnIsdnDelete()
{
/* Jo No ISDN */
#if 0
	// TODO: Add your control notification handler code here

	int			nCurSel, nMBResponse;
	CString		szConfig, szMsg, config ,deleted_config;
	char strRHS[40] ,strLHS[40];
	
	CIsdnTa Isdn;

	m_cfgtype = kDelete;

	if ( m_INISectionControl.GetCurSel() == CB_ERR)
	{
		::MessageBox(GetSafeHwnd(),"Select a Configuration file to delete",IsdnMsgHeader,MB_OK);
		m_INISectionControl.SetFocus();
		return;
	}
	else
	{
		nCurSel = m_INISectionControl.GetCurSel ();
   	m_INISectionControl.GetLBText ( nCurSel, m_szPPINISection );
		deleted_config = m_szPPINISection;

	   if ( nCurSel != CB_ERR )
	   { 
			m_INISectionControl.GetLBText ( nCurSel, szConfig );
			if ( Isdn.IsThisADefaultCfg ( szConfig ) )
			{	
				szMsg.LoadString(IDS_DELETE_DEFAULT_CONFIG);
				nMBResponse = AfxMessageBox ( szMsg );
				return;
			}
			sprintf(strLHS,"Port0");
			while ( GetPrivateProfileString ( MapHeader,strLHS,
				StrNull,strRHS,sizeof(strRHS),ini_INIFilename ))
		  	{
				if ( szConfig.CompareNoCase ( strRHS ) == 0 )
				{
 					::MessageBox ( GetSafeHwnd(),"This is the existing configuration.\
Before deleting this make sure to change the configuration.",IsdnMsgHeader,MB_OK);
					return;
				}
			 	strLHS[4]++;
			}
		   szMsg.LoadString(IDS_DELETE_CONFIG);
		   nMBResponse = AfxMessageBox ( szMsg, MB_YESNO, 0 );
			if ( nMBResponse == IDYES )
			{
				::WritePrivateProfileString ( szConfig, NULL, NULL, ini_INIFilename );
				::WritePrivateProfileString  (	"User Config", szConfig, NULL, ini_INIFilename );
				m_INISectionControl.DeleteString ( nCurSel );
			
				if ( nCurSel != m_INISectionControl.GetCount () )
					m_INISectionControl.SetCurSel ( (nCurSel) );
				else
					m_INISectionControl.SetCurSel ( nCurSel-1 );
			}
		}
		////Prabha, 4/2/98, To echo the deletion in the port tabs also
		CWanTab *pParent = (CWanTab *)GetParent();
		for (int port = 0; port < pParent->tabcount; port++)
		{
			pParent->m_pdlgWAN[port]->m_ComBoxModemTypes.GetLBText ( nCurSel, deleted_config );
			pParent->m_pdlgWAN[port]->m_ComBoxModemTypes.DeleteString (nCurSel);
		}
	}		
	return;
#endif
/* Jo */
}

void CWANDlg::OnIsdnAdd()
{
/* Jo No ISDN */
#if 0
	// TODO: Add your control notification handler code here

	m_cfgtype = kAdd;
	
	CIsdnTa Isdn (this);
	if (Isdn.DoModal() == IDOK)
	{
		////Prabha, 6/3/98, Put the newly added config in the list
		if (m_INISectionControl.FindStringExact (-1, Isdn.m_szPPSectionName ) == CB_ERR)
			m_INISectionControl.AddString ( Isdn.m_szPPSectionName );
		CWanTab *pParent = (CWanTab *) GetParent();
		for (int index = 0; index < pParent->tabcount; index++)
		{
			if ( pParent->m_pdlgWAN[index]->m_ComBoxModemTypes.FindStringExact ( -1, Isdn.m_szPPSectionName ) == CB_ERR )
				pParent->m_pdlgWAN[index]->m_ComBoxModemTypes.AddString ( Isdn.m_szPPSectionName );
		}
	}
	return;
#endif
/* Jo */
}

void CWANDlg::OnCfgs()
{
/* Jo No ISDN */
#if 0
	// TODO: Add your control notification handler code here
	
	if ( m_INISectionControl.GetCurSel() != CB_ERR )
	{
 		//m_INISectionControl.GetWindowText ( m_szPPINISection );
                m_INISectionControl.GetLBText ( 
                        m_INISectionControl.GetCurSel(),m_szPPINISection );

		sprintf ( TempSection,"%s",m_szPPINISection );
	}
	
#endif
/* Jo */
}

LRESULT CWANDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CWANDlg::PostNcDestroy(void)
{
	delete this;
}

void CWANDlg::OnCancel()
{
	// TODO: Add extra cleanup here

	if (m_bMdmConfigChanged)
	{
		int nRetVal = MessageBox ("Do you want to save changes?",
					"Modems - Information", MB_YESNO | MB_ICONQUESTION) ;
		if (nRetVal == IDYES)
		{
			PutModemsInParentsList() ;
			WriteToCnfFile() ;

			CWanTab *pParent = (CWanTab *) GetParent() ;
			pParent->WriteModemInfoToIni() ;
		}
	}
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

/////////////////////////////////////////////////////////////////////////////
// CWanPortDlg dialog


CWanPortDlg::CWanPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWanPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWanPortDlg)
	m_WANPort = FALSE;
	m_cboxAsyncBaud = "";
	m_cboxSyncIntClk = "";
	m_bDirConnect = FALSE;
	m_bRestartScriptOnCommFailure = FALSE;
	m_bScriptEnable = FALSE;
	m_active_connections = 0;
	m_host = "";
	m_szSectionName = "";
	m_active_hosts = 0 ;
	m_idle_time = 0;
	//}}AFX_DATA_INIT

	m_szOldModemSel = "";
	
	Create(IDD,NULL);
}

void CWanPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanPortDlg)
	DDX_Control(pDX, IDC_RAS_ONLY, m_BtnRasOnly);
	DDX_Control(pDX, IDC_PROXY_OR_RAS, m_BtnProxyOrRas);
	DDX_Control(pDX, IDC_PROXY_ONLY, m_BtnProxyOnly);
	DDX_Control(pDX, IDC_STATIC_LINK_USAGE_CONTROL, m_ctrl_link_usage_ctrl);
	DDX_Control(pDX, IDC_STATIC_HOST, m_static_list_host);
	DDX_Control(pDX, IDC_STATIC_ACTIVE_IP_HOST_MACHINES, m_ctrl_static_ip_hosts);
	DDX_Control(pDX, IDC_EDIT_IP_HOST_MACHINES, m_ctrl_active_ip_hosts);
	DDX_Control(pDX, IDC_STATIC_ACTIVE_CONNECTIONS, m_ctrl_static_active_connections);
	DDX_Control(pDX, IDC_EDIT_CONNECTIONS, m_ctrl_active_connections);
	DDX_Control(pDX, IDC_CHECK_LINK_CTRL_ENABLE, m_link_ctrl_enabled);
	DDX_Control(pDX, IDC_EDIT_IDLE_TIME, m_ctrl_idle_time);
	DDX_Control(pDX, IDC_STATIC_MINUTES, m_ctrl_minutes);
	DDX_Control(pDX, IDC_STATIC_IDLE_TIME, m_ctrl_static_idle_time);
	DDX_Control(pDX, IDC_BUTTON_DELETE, m_ctrl_delete);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_ctrl_add);
	DDX_Control(pDX, IDC_STATIC_BRING_UP, m_static_bring_up);
	DDX_Control(pDX, IDC_EDIT_HOST, m_ctrl_host);
	DDX_Control(pDX, IDC_LIST_HOST, m_list_host);
	DDX_Control(pDX, IDC_RADIO_ISDN, m_RBtnIsdn);
	DDX_Control(pDX, IDC_RADIO_MODEM, m_RBtnModem);
	DDX_Control(pDX, IDC_BTN_SCRIPT, m_BtnScript);
	DDX_Control(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_RestartScriptWnd);
	DDX_Control(pDX, IDC_CHECK_ENABLE_SCRIPT, m_ScriptEnableWnd);
	DDX_Control(pDX, IDC_CHECK_DIR_CONNECT, m_chkBtnDirConnect);
	DDX_Control(pDX, IDC_CHECK_IDLE_FLAGS, m_chkboxIdleFlags);
	DDX_Control(pDX, IDC_STATIC_MODEM_TYPES, m_StatModemTypes);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPES, m_ComBoxModemTypes);
	DDX_Control(pDX, IDC_CLK_SPEED_HDR, m_ClkSpeedHdr);
	DDX_Control(pDX, IDC_BAUD_HEADER, m_BaudHeader);
	DDX_Control(pDX, IDC_DIALLING, m_RBtnDialling);
	DDX_Control(pDX, IDC_ANSWERING, m_RBtnAnswering);
	DDX_Control(pDX, IDC_EXT_CLOCK, m_RBtnExtClk);
	DDX_Control(pDX, IDC_SYNC_INT_CLK, m_cboxSyncIntClkWnd);
	DDX_Control(pDX, IDC_INT_CLOCK, m_RBtnIntClk);
	DDX_Control(pDX, IDC_RADIO_SYNC, m_RBtnSync);
	DDX_Control(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaudWnd);
	DDX_Control(pDX, IDC_RADIO_ASYNC, m_RBtnAsync);
	DDX_Check(pDX, IDC_WAN_PORT, m_WANPort);
	DDX_CBString(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaud);
	DDV_MaxChars(pDX, m_cboxAsyncBaud, 15);
	DDX_CBString(pDX, IDC_SYNC_INT_CLK, m_cboxSyncIntClk);
	DDV_MaxChars(pDX, m_cboxSyncIntClk, 15);
	DDX_Check(pDX, IDC_CHECK_DIR_CONNECT, m_bDirConnect);
	DDX_Check(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_bRestartScriptOnCommFailure);
	DDX_Check(pDX, IDC_CHECK_ENABLE_SCRIPT, m_bScriptEnable);
	DDX_Text(pDX, IDC_EDIT_CONNECTIONS, m_active_connections);
	DDV_MinMaxInt(pDX, m_active_connections, 0, 9999);
	DDX_Text(pDX, IDC_EDIT_HOST, m_host);
	DDX_CBString(pDX, IDC_COMBO_MODEM_TYPES, m_szSectionName);
	DDX_Text(pDX, IDC_EDIT_IP_HOST_MACHINES, m_active_hosts);
	DDV_MinMaxInt(pDX, m_active_hosts, 0, 9);
	DDX_Text(pDX, IDC_EDIT_IDLE_TIME, m_idle_time);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanPortDlg, CDialog)
	//{{AFX_MSG_MAP(CWanPortDlg)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_REGISTERED_MESSAGE(msgSwitchTo, OnSwitchToIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_RADIO_ASYNC, OnRadioAsync)
	ON_BN_CLICKED(IDC_RADIO_SYNC, OnRadioSync)
	ON_BN_CLICKED(IDC_INT_CLOCK, OnIntClock)
	ON_BN_CLICKED(IDC_EXT_CLOCK, OnExtClock)
	ON_BN_CLICKED(IDC_ANSWERING, OnAnswering)
	ON_BN_CLICKED(IDC_DIALLING, OnDialling)
	ON_BN_CLICKED(IDC_CHECK_DIR_CONNECT, OnCheckDirConnect)
	ON_BN_CLICKED(IDC_BTN_SCRIPT, OnBtnScript)
	ON_BN_CLICKED(IDC_RADIO_ISDN, OnRadioIsdn)
	ON_BN_CLICKED(IDC_RADIO_MODEM, OnRadioModem)
	ON_BN_CLICKED(IDC_CHECK_LINK_CTRL_ENABLE, OnCheckLinkCtrlEnable)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEM_TYPES, OnSelchangeComboModemTypes)
	ON_BN_CLICKED(IDC_PROXY_ONLY, OnProxyOnly)
	ON_BN_CLICKED(IDC_RAS_ONLY, OnRasOnly)
	ON_BN_CLICKED(IDC_PROXY_OR_RAS, OnProxyOrRas)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanPortDlg message handlers

void CWanPortDlg::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void CWanPortDlg::OnOK()
{
	// TODO: Add extra validation here
	if (!UpdateData (TRUE))
		return ;

   if (!ValidEditFields())  
      return;
/* Jo check for RAS and other dependencies */
	
	CDialog::OnOK() ;
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

LRESULT CWanPortDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CWanPortDlg::PostNcDestroy(void)
{
	delete this;
}

void CWanPortDlg::OnHelp()
{
		AfxGetApp()->WinHelp(0x20000 + IDD_WAN_PORT_CONFIG,HELP_CONTEXT);
	
}

void CWanPortDlg::OnControl()
{
	UpdateData (TRUE) ;

	// Added by cfp on 25-3-96
	BOOL fAsync = m_RBtnAsync.GetCheck() ;	
	BOOL fIntClk = m_RBtnIntClk.GetCheck() ;

	//Sudha 9 Dec 1997
	BOOL fIsdn = m_RBtnIsdn.GetCheck();
	BOOL fModem = m_RBtnModem.GetCheck();

	if ( !fIsdn && !fModem )
		OnRadioModem () ;

	// Added by cfp on 27-3-96
	BOOL fAnswering = m_BtnRasOnly.GetCheck() ;

	m_StatModemTypes.EnableWindow (fAsync && !m_bDirConnect) ;
	m_ComBoxModemTypes.EnableWindow (fAsync && !m_bDirConnect) ;
	m_RBtnModem.EnableWindow (fAsync && !m_bDirConnect) ;
	m_RBtnIsdn.EnableWindow (fAsync && !m_bDirConnect) ;

	m_cboxAsyncBaudWnd.EnableWindow (fAsync) ;
	m_RBtnIntClk.EnableWindow (!fAsync) ;
	m_cboxSyncIntClkWnd.EnableWindow (!fAsync && fIntClk) ;
	m_RBtnExtClk.EnableWindow (!fAsync) ;
	m_BaudHeader.EnableWindow (fAsync) ;
	m_ClkSpeedHdr.EnableWindow (!fAsync && fIntClk) ;
	m_chkboxIdleFlags.EnableWindow (!fAsync) ;

	/* 9/7/97 chetan */
	m_BtnScript.EnableWindow (fAsync && RouterStatus && !m_bDirConnect) ;
	m_RestartScriptWnd.EnableWindow (fAsync && !m_bDirConnect);
	m_ScriptEnableWnd.EnableWindow (fAsync && !m_bDirConnect);
	/* 9/7/97 chetan */

/* Jo 24/06/99 Added for RAS */
	if (m_bDirConnect || ppp_ptr->ppp_ports[0].lcp_epd.valid)
		m_BtnProxyOrRas.EnableWindow (FALSE) ;
	else
		m_BtnProxyOrRas.EnableWindow (TRUE) ;
  	if (fAnswering)
		m_link_ctrl_enabled.SetCheck (0) ;

/* Jo check for link control dependencies */
}

BOOL CWanPortDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!AddBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn.SubclassDlgItem (IDC_BUTTON_ADD, this));
	AddBmpBtn.SizeToContent();

	if (!DeleteBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn.SubclassDlgItem (IDC_BUTTON_DELETE, this));
	DeleteBmpBtn.SizeToContent();

	if (!ScriptBmpBtn.LoadBitmaps ("SCRIPT1", "SCRIPT2", "SCRIPT3", "SCRIPT4"))
		AfxMessageBox ("Failed to load SCRIPT bitmap");

	VERIFY (ScriptBmpBtn.SubclassDlgItem (IDC_BTN_SCRIPT, this));
	ScriptBmpBtn.SizeToContent();

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

int	CWanPortDlg::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}

// Added by cfp
void CWanPortDlg::OnRadioAsync()
{
	// TODO: Add your control notification handler code here
	m_RBtnAsync.SetCheck (1) ;
	m_RBtnSync.SetCheck (0) ;		
	OnControl() ;

	BOOL fAnswering = m_RBtnAnswering.GetCheck() ;
}

// Added by cfp
void CWanPortDlg::OnRadioSync()
{
/* Jo WAN is always Async */
#if 0   
	// TODO: Add your control notification handler code here
	m_RBtnAsync.SetCheck (0) ;
	m_RBtnSync.SetCheck (1) ;		
	OnControl() ;
#endif
/* Jo */
}

// Added by cfp
void CWanPortDlg::OnIntClock()
{
/* Jo WAN is always Async */
#if 0   
	// TODO: Add your control notification handler code here
	if (m_RBtnSync.GetCheck())
	{
		m_RBtnAsync.SetCheck (0) ;
	   m_RBtnIntClk.SetCheck (1) ;      
		m_RBtnExtClk.SetCheck (0) ;		
		OnControl() ;
	   return ;
	}
	m_RBtnIntClk.SetCheck (0) ;      
	OnControl() ;
	return ;
#endif
/* Jo */
	return ;
}

// Added by cfp
void CWanPortDlg::OnExtClock()
{
/* Jo WAN is always Async */
#if 0   
	// TODO: Add your control notification handler code here
	if (m_RBtnSync.GetCheck())
	{
		m_RBtnAsync.SetCheck (0) ;
	   m_RBtnIntClk.SetCheck (0) ;      
		m_RBtnExtClk.SetCheck (1) ;		
		OnControl() ;
		return ;
	}
	m_RBtnExtClk.SetCheck (0) ;		
	OnControl() ;
	return ;
#endif
/* Jo */
	return ;
}



// Added by cfp
void CWanPortDlg::OnAnswering()
{
	// TODO: Add your control notification handler code here
	m_RBtnAnswering.SetCheck (1) ;
	m_RBtnDialling.SetCheck (0) ;
	OnControl() ;
}

// Added by cfp
void CWanPortDlg::OnDialling()
{
	// TODO: Add your control notification handler code here
	m_RBtnAnswering.SetCheck (0) ;
	m_RBtnDialling.SetCheck (1) ;
	OnControl() ; 

/* Jo SLIP not supported */
#if 0
	// If both PPP and SLIP are enabled, disable SLIP
	CMainDlg *maindlg = ((CMainDlg *)(GetParent()->GetParent()));
	int PortNo = GetMyID();
	if (PortNo == -1) return;
	if (maindlg->IsPPPEnabled(PortNo) && maindlg->IsSLIPEnabled(PortNo))
		maindlg->EnableSLIP (PortNo, FALSE);
#endif
	return ;
}

BOOL CWanPortDlg::ValidEditFields()
{
	CWanTab *pParent = (CWanTab *) GetParent() ;

	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
			break ;
	}
 
/* Jo 24/06/99 Added for RAS */
//	BOOL bDialAns = m_BtnProxyOrRas.GetCheck() ? TRUE : FALSE ;

	if (i < pParent->tabcount)
	{
		if (pParent->m_pdlgWAN[i]->m_BtnProxyOrRas.GetCheck() && !pParent->m_pdlgWAN[i]->m_link_ctrl_enabled.GetCheck())
		{
			::MessageBox (pParent->GetSafeHwnd(), "Link control should be enabled",
				"WAN - Info", MB_OK | MB_ICONINFORMATION) ;
			pParent->m_pdlgWAN[i]->m_link_ctrl_enabled.SetFocus();
			return FALSE ;
		}
	}

	if ((m_idle_time < 1) || (m_idle_time > 500))
	{
		::MessageBox (pParent->GetSafeHwnd(), "Enter an integer value between 1 and 500",
			"WAN - Info", MB_OK | MB_ICONINFORMATION);
		pParent->m_pdlgWAN[i]->m_ctrl_idle_time.SetFocus();
		return FALSE;
	}

#if 0
	if (i < pParent->tabcount)
	{
		if (pParent->m_pdlgWAN[i]->m_BtnRasOnly.GetCheck() || 
			 pParent->m_pdlgWAN[i]->m_BtnProxyOrRas.GetCheck())
		{
			::MessageBox (pParent->GetSafeHwnd(), "Make sure RAS in IP is enabled",
				"WAN - Info", MB_OK | MB_ICONINFORMATION) ;
			return TRUE ;
		}
	}
#endif
	return TRUE ;
}


void CWanPortDlg::OnCheckDirConnect()
{
	// TODO: Add your control notification handler code here
/* Jo check for dependencies */
	OnControl() ;
}


void CWanPortDlg::OnBtnScript()
{
	// TODO: Add your control notification handler code here

	CWanTab *pParent = (CWanTab *) GetParent() ;

	for (UINT i = 0 ; i < pParent->m_nPort ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
			break ;
	}
	CScriptDlg CScript ;
	CScript.m_nPortNum = (int)i ;
	CScript.DoModal() ;
}


LRESULT CWanPortDlg::OnSwitchToIden (WPARAM wParam, LPARAM lParam)
{
	UpdateData (TRUE) ;
	return 0L ;
}

int CWanPortDlg::GetMyID (void)
{
	CWanTab *parent = (CWanTab *)GetParent();
	int tabcount = parent->tabcount;
	
	for (int index = 0 ; index < tabcount ; index ++)
	{
			if (parent->m_pdlgWAN[index] == this)
			{
				return (index);
			}
	}
	return -1;
}

void CWanPortDlg::OnRadioIsdn()
{
/* Jo No ISDN */
#if 0
	// TODO: Add your control notification handler code here
	int Id;

	Id = GetMyID();
	m_RBtnModem.SetCheck(0);
	m_RBtnIsdn.SetCheck(1);
	OnControl();
	GetIsdnTypes(Id);	
#endif
/* Jo */
}

void CWanPortDlg::OnRadioModem()
{
	// TODO: Add your control notification handler code here
	int Id;

	Id = GetMyID();
	m_RBtnIsdn.SetCheck (0) ;
	m_RBtnModem.SetCheck (1) ;
	OnControl();
	
	GetTypesofmodems(Id);
	
}

void CWanPortDlg::GetIsdnTypes (int j)
{
/* Jo No ISDN */
#if 0
	char strLHS[40],strRHS[40],buffer[512];
	char token[40];
	char seps = '\0';
	int length = 0;
	int total;
	CString szDefaultConfig;
	int k;
	
	CWanTab *parent = (CWanTab *)GetParent();

	for (k = 0; k < parent->tabcount; k++ )
	{
		if ( j == k )
			break;
	}
	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.ResetContent();

	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
	 	if ( parent->m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, strRHS ) == CB_ERR )
	 	{
	 		// Insert the string in the list box
	 		parent->m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( strRHS );
	 	}
	 	strLHS[6]++;
   }
 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	while ( total > 0 )
	{
		strcpy ( token,&buffer[length]);
      if ( parent->m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, token ) == CB_ERR )
	        {
	       	   // Insert the string in the list box
		   parent->m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( token );
		}	

 	        length = length + strlen ( token ) + 1;	// +1 for the NULL character
		total = total - ( strlen ( token ) + 1 ) ;
	      //token = strtok( &buffer[length], seps );
	      //token = strchr( &buffer[length], seps );
	      //strcpy(token,&buffer[length]);
		//}
	}
	
	sprintf ( strLHS,"ISDN WAN Port%d ConfigName",j);
	GetPrivateProfileString ( WANSectionHeader, strLHS,
		StrNull,strRHS,sizeof(strRHS),IniInWinForm );
	if ( strcmp ( strRHS,StrNull ) == 0 )
		strcpy ( strRHS,"EuroIsdn");
	int nsel;
	nsel = parent->m_pdlgWAN[k]->m_ComBoxModemTypes	.FindStringExact(-1,strRHS );
	/*	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.SetCurSel (
                parent->m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact(
                -1,strRHS)); */
	if (nsel == CB_ERR )
	   nsel = 0;
	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.SetCurSel ( nsel );
	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.GetLBText (nsel,parent->m_pdlgWAN[k]->m_szSectionName );
	//parent->m_pdlgWAN[k]->m_ComBoxModemTypes.GetWindowText (parent->m_pdlgWAN[k]->m_szPPINISection );
#endif
/* Jo */
}

void CWanPortDlg::GetTypesofmodems(int k)
{
	char szFilePath[200] ; // For MODEMS.CNF File
	char strRHS[50];
	char szBlankBackSlash[100] ;

	CWanTab *parent = (CWanTab *) GetParent();

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;
	
	fModemsPtr = fopen (szFilePath, "rb") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetParent()->GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
				"Warning - File not found", MB_OK) ;
		return ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetParent()->GetSafeHwnd(),
			"Invalid MODEMS.CNF file", "Warning", MB_OK) ;
		return ;
	} 

	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;
	MODEM_SETUP ModemSetup ;
	int i ;

	for ( i = 0 ; i < parent->tabcount ; i++)
	{
		if ( i == k )
			break;
	}
	
	parent->m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent();

	while (TRUE)
	{
		if (fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) < 1)
			break ;
		if (strcmp (ModemSetup.ModemType, "Direct Connection") == 0)
			continue ;
		parent->m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (ModemSetup.ModemType) ;
	}

	fclose (fModemsPtr) ;

	strcpy (strRHS, (char *)wan_ptr->wan_ports[i].modem_type) ;

	int nToSel ;
	if (strRHS[0])
  	{
		ConvertBackSlashesToBlanks (szBlankBackSlash, strRHS) ;
		nToSel = 
			parent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1,
			szBlankBackSlash) ;
		if (nToSel == CB_ERR)
			nToSel = 0 ;
		parent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nToSel) ;
	}
	else
	{
      nToSel = 0;
		parent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel(nToSel);
	}
	parent->m_advdlgWAN->m_nSelectedModem = m_ComBoxModemTypes.GetCurSel();
	parent->m_advdlgWAN->m_combBoxModemTypes.SetCurSel(parent->m_advdlgWAN->m_nSelectedModem);
	return ;
}

void CWanPortDlg::OnCheckLinkCtrlEnable()
{
	// TODO: Add your control notification handler code here
	
	BOOL check; 
	CWanTab *pParent = (CWanTab *) GetParent() ;
	for (UINT i = 0 ; i < pParent->m_nPort ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
			break ;
	}

/* 23/03/99 Jo added to take care of MLPPP and link control dependencies */
	int is_mlppp_enabled = 0 ;
	if (i)
		is_mlppp_enabled = ppp_ptr->ppp_ports[0].lcp_epd.valid ;

	if ((!m_link_ctrl_enabled.GetCheck()) || (is_mlppp_enabled))
		check = FALSE;
	else
		check = TRUE;
	m_static_bring_up.EnableWindow (check);
	m_ctrl_static_active_connections.EnableWindow (check);
	m_ctrl_active_connections.EnableWindow (check);
	m_ctrl_static_ip_hosts.EnableWindow (check);
	m_ctrl_active_ip_hosts.EnableWindow (check);
	m_static_list_host.EnableWindow (check);
	m_list_host.EnableWindow (check);
	m_ctrl_host.EnableWindow (check);
	m_ctrl_add.EnableWindow (check);
	m_ctrl_delete.EnableWindow (check);

	if (!m_link_ctrl_enabled.GetCheck())
		check = FALSE;
	else
		check = TRUE;
	
	m_ctrl_static_idle_time.EnableWindow (check);
	m_ctrl_idle_time.EnableWindow (check);
	m_ctrl_minutes.EnableWindow (check);
	
	if (i == 0)
	{
		m_static_bring_up.EnableWindow (FALSE);
		m_ctrl_static_active_connections.EnableWindow (FALSE);
		m_ctrl_active_connections.EnableWindow (FALSE);
		m_ctrl_static_ip_hosts.EnableWindow (FALSE);
		m_ctrl_active_ip_hosts.EnableWindow (FALSE);
		m_static_list_host.EnableWindow (FALSE);
		m_list_host.EnableWindow (FALSE);
		m_ctrl_host.EnableWindow (FALSE);
		m_ctrl_add.EnableWindow (FALSE);
		m_ctrl_delete.EnableWindow (FALSE);
	}	
}

void CWanPortDlg::OnButtonAdd()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	if (m_host.IsEmpty())
	{
		::MessageBox (GetSafeHwnd(), "Enter the host address", (LPSTR) WANSectionHeader, MB_OK);
		m_ctrl_host.SetFocus();
		return;
	}

	if (!m_host.IsValid())
	{
		::MessageBox (GetSafeHwnd(), "Invalid Host Address", (LPSTR) WANSectionHeader, MB_OK);
		m_ctrl_host.SetFocus();
		return;
	}

	CString buf;
	unsigned long addr1, addr2;
	get_ip_address (m_host, &addr1);
	for (int index = 0; index < m_list_host.GetCount(); index++)
	{
		m_list_host.GetText (index, buf);
		get_ip_address (buf, &addr2);
		if (addr1 == addr2)
		{
			::MessageBox (GetSafeHwnd(), "Addresses should be unique",
				"WAN - Info", MB_OK | MB_ICONINFORMATION);
			m_ctrl_host.SetFocus();
			return;
		}
	}

	m_list_host.AddString (m_host);
	m_host.Empty();
	UpdateData (FALSE);
}

void CWanPortDlg::OnButtonDelete()
{
	// TODO: Add your control notification handler code here
	if (m_list_host.GetCurSel() == CB_ERR)
		return;
	else
		m_list_host.DeleteString (m_list_host.GetCurSel());
	UpdateData (FALSE);
}

void CWanPortDlg::OnSelchangeComboModemTypes()
{
	// TODO: Add your control notification handler code here
	
	CWanTab *parent = (CWanTab *) GetParent();

	int index = m_ComBoxModemTypes.GetCurSel();
	if ( index != CB_ERR )
	{
		parent->m_advdlgWAN->m_nSelectedModem = index;
 		parent->m_advdlgWAN->m_combBoxModemTypes.SetCurSel(index);
	}
}

void CWanPortDlg::OnProxyOnly()
{
	// TODO: Add your control notification handler code here
	m_BtnProxyOnly.SetCheck (1) ;
	m_BtnRasOnly.SetCheck (0) ;
	m_BtnProxyOrRas.SetCheck (0) ;

	BOOL flag = TRUE, LinkControl = TRUE ;
	int PortNo = GetMyID();
/* ...Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies */

	if (!PortNo || ppp_ptr->ppp_ports[0].lcp_epd.valid)
		flag = FALSE ;
	if (ppp_ptr->ppp_ports[0].lcp_epd.valid && PortNo)
	{
		LinkControl = FALSE ;
		m_link_ctrl_enabled.SetCheck (0) ;
	}
	else
		m_link_ctrl_enabled.SetCheck (1) ;

	m_link_ctrl_enabled.EnableWindow (LinkControl) ;
	m_ctrl_idle_time.EnableWindow (LinkControl) ;
	m_ctrl_minutes.EnableWindow (LinkControl) ;
	m_ctrl_static_idle_time.EnableWindow (LinkControl) ;
	m_ctrl_link_usage_ctrl.EnableWindow (LinkControl) ; 

/* Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies... */
	m_static_bring_up.EnableWindow (flag) ;
	m_ctrl_static_active_connections.EnableWindow (flag) ;
	m_ctrl_active_connections.EnableWindow (flag) ;
	m_ctrl_static_ip_hosts.EnableWindow (flag) ;
	m_ctrl_active_ip_hosts.EnableWindow (flag) ;
	m_static_list_host.EnableWindow (flag) ;
	m_list_host.EnableWindow (flag) ;
	m_ctrl_host.EnableWindow (flag) ;
	m_ctrl_add.EnableWindow (flag) ;
	m_ctrl_delete.EnableWindow (flag) ;
	OnControl() ;
}

void CWanPortDlg::OnRasOnly()
{
	// TODO: Add your control notification handler code here
	
	m_BtnRasOnly.SetCheck (1) ;
	m_BtnProxyOnly.SetCheck (0) ;
	m_BtnProxyOrRas.SetCheck (0) ;
	
	m_link_ctrl_enabled.SetCheck (0) ; 
	m_link_ctrl_enabled.EnableWindow (FALSE) ;
	m_ctrl_idle_time.EnableWindow (FALSE) ;
	m_ctrl_minutes.EnableWindow (FALSE) ;
	m_ctrl_static_idle_time.EnableWindow (FALSE) ;
	m_ctrl_link_usage_ctrl.EnableWindow (FALSE) ;
	m_static_bring_up.EnableWindow (FALSE) ;
	m_ctrl_static_active_connections.EnableWindow (FALSE) ;
	m_ctrl_active_connections.EnableWindow (FALSE) ;
	m_ctrl_static_ip_hosts.EnableWindow (FALSE) ;
	m_ctrl_active_ip_hosts.EnableWindow (FALSE) ;
	m_static_list_host.EnableWindow (FALSE) ;
	m_list_host.EnableWindow (FALSE) ; 
	m_ctrl_host.EnableWindow (FALSE) ;
	m_ctrl_add.EnableWindow (FALSE) ;
	m_ctrl_delete.EnableWindow (FALSE) ;
	OnControl() ;
}

void CWanPortDlg::OnProxyOrRas()
{
	// TODO: Add your control notification handler code here
	m_BtnProxyOrRas.SetCheck (1) ;
	m_BtnRasOnly.SetCheck (0) ;
	m_BtnProxyOnly.SetCheck (0) ;

/* ...Added by Jo on 26 Oct 1999 */
	BOOL flag = TRUE ;
	int PortNo = GetMyID();
	if (!PortNo)	
		flag = FALSE ;
/* ...Added by Jo on 26 Oct 1999 */

	m_link_ctrl_enabled.SetCheck (1) ;
	m_link_ctrl_enabled.EnableWindow (TRUE) ;
	m_ctrl_idle_time.EnableWindow (TRUE) ;
	m_ctrl_minutes.EnableWindow (TRUE) ;
	m_ctrl_static_idle_time.EnableWindow (TRUE) ;
	m_ctrl_link_usage_ctrl.EnableWindow (TRUE) ;
	m_static_bring_up.EnableWindow (flag) ;
	m_ctrl_static_active_connections.EnableWindow (flag) ;
	m_ctrl_active_connections.EnableWindow (flag) ;
	m_ctrl_static_ip_hosts.EnableWindow (flag) ;
	m_ctrl_active_ip_hosts.EnableWindow (flag) ;
	m_static_list_host.EnableWindow (flag) ;
	m_list_host.EnableWindow (flag) ;
	m_ctrl_host.EnableWindow (flag) ;
	m_ctrl_add.EnableWindow (flag) ;
	m_ctrl_delete.EnableWindow (flag) ;
	OnControl() ;
}

/////////////////////////////////////////////////////////////////////////////
// CWanTab dialog


CWanTab::CWanTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(CWanTab::IDD, pParent)
{

//{{AFX_DATA_INIT(CWanTab)
		// NOTE: the ClassWizard will add member initialization here
		m_nPort = 3 ;
	//}}AFX_DATA_INIT

     
	// Get the UINT parameter
	m_nPort = wan_ptr->wan_header.number_of_ports ; 
	if (m_nPort < 1 || m_nPort > 3)
		m_nPort = 3 ;

	tabcount = m_nPort ;
	
	// Limit the tabcount
	if (tabcount > n_PORTMAX_WAN)
		tabcount = n_PORTMAX_WAN ;
	if (tabcount < 1)
		tabcount = 1 ;

	for (int i = 0 ; i < tabcount ; i++)
		m_pdlgWAN [i] = new CWanPortDlg (this);
	m_advdlgWAN = new CWANDlg (this);
}

void CWanTab::DoDataExchange(CDataExchange* pDX)
{
	CTabDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanTab, CTabDialog)
	//{{AFX_MSG_MAP(CWanTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanTab message handlers
void CWanTab::GetConfig()
{
	char szBuf[80] ;
	BOOL fAsync, fIntClk, fAnswering, fDirConnect;
   // Get all the parameters for Ports
   // Get the BOOL parameters.      
  	

   for (int i = 0 ; i < tabcount ; i ++)
   {
		m_pdlgWAN[i]->m_WANPort = wan_ptr->wan_ports[i].enabled ;
		m_pdlgWAN[i]->m_RBtnAsync.SetCheck (1) ;
      m_pdlgWAN[i]->m_RBtnSync.SetCheck (0) ;
		fAsync = TRUE ;

	   m_pdlgWAN[i]->m_RBtnExtClk.SetCheck (0) ;
  	   m_pdlgWAN[i]->m_RBtnIntClk.SetCheck (0) ;
	   fIntClk = FALSE ;

   	m_pdlgWAN[i]->m_chkboxIdleFlags.SetCheck (0) ; 

	   m_pdlgWAN[i]->m_bScriptEnable = wan_ptr->wan_ports[i].script_enabled ;
	   m_pdlgWAN[i]->m_bRestartScriptOnCommFailure = wan_ptr->wan_ports[i].restart_script_on_comm_failure ;
	   m_pdlgWAN[i]->m_bDirConnect = wan_ptr->wan_ports[i].direct_connect ;
	   fDirConnect = m_pdlgWAN[i]->m_bDirConnect;

/* Jo 24/06/99 Added for RAS */

	   if (wan_ptr->wan_ports[i].auto_answer == 0)
	   {
		   m_pdlgWAN[i]->m_BtnRasOnly.SetCheck (0) ;
			if (ppp_ptr->ppp_ports[i].remote_port_client_only == 0)
			{
		   	m_pdlgWAN[i]->m_BtnProxyOnly.SetCheck (1) ;
	   		m_pdlgWAN[i]->m_BtnProxyOrRas.SetCheck (0) ;
			}
			else
			{
		   	m_pdlgWAN[i]->m_BtnProxyOrRas.SetCheck (1) ;
		   	m_pdlgWAN[i]->m_BtnProxyOnly.SetCheck (0) ;
			}
	   }
	   else
	   {
	   	m_pdlgWAN[i]->m_BtnRasOnly.SetCheck (1) ;
	   	m_pdlgWAN[i]->m_BtnProxyOnly.SetCheck (0) ;
		  	m_pdlgWAN[i]->m_BtnProxyOrRas.SetCheck (0) ;
	   }

      // Get the CString parameters.

	   sprintf (szBuf, "%lu", wan_ptr->wan_ports[i].speed) ; 
	   m_pdlgWAN[i]->m_cboxAsyncBaud = szBuf ;

	   int nToSelect ;

		m_pdlgWAN[i]->m_RBtnIsdn.ShowWindow (SW_HIDE);	  
		m_pdlgWAN[i]->GetTypesofmodems(i) ;
		char szBlankBackSlash[100] ;
	   
		if (!fDirConnect)
	   	m_pdlgWAN[i]->m_RBtnModem.SetCheck (1) ;
		strcpy (szBuf, (char *)wan_ptr->wan_ports[i].modem_type) ;
		if (szBuf[0])
		{
		 	ConvertBackSlashesToBlanks (szBlankBackSlash, szBuf) ;
		 	nToSelect = m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1, szBlankBackSlash) ;	
			if (nToSelect == CB_ERR)
			   nToSelect = 0 ;
			m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nToSelect) ;
		} 

		m_pdlgWAN[i]->m_cboxAsyncBaudWnd.EnableWindow (fAsync) ;
		m_pdlgWAN[i]->m_cboxSyncIntClkWnd.EnableWindow (!fAsync && fIntClk) ;
	   m_pdlgWAN[i]->m_RBtnIntClk.EnableWindow (!fAsync ) ;
		m_pdlgWAN[i]->m_RBtnExtClk.EnableWindow (!fAsync) ; 
		m_pdlgWAN[i]->m_BaudHeader.EnableWindow (fAsync) ;
	   m_pdlgWAN[i]->m_ClkSpeedHdr.EnableWindow (!fAsync && fIntClk) ;
/* chetan 9/7/97 */
		m_pdlgWAN[i]->m_ScriptEnableWnd.EnableWindow (fAsync && !fDirConnect);
		m_pdlgWAN[i]->m_RestartScriptWnd.EnableWindow (fAsync && !fDirConnect);
	   m_pdlgWAN[i]->m_BtnScript.EnableWindow (RouterStatus && fAsync && !fDirConnect) ;
/* chetan 9/7/97 */

//		m_pdlgWAN[i]->m_RBtnModem.SetCheck(1);		
		m_pdlgWAN[i]->m_StatModemTypes.EnableWindow (fAsync && 
	   										!m_pdlgWAN[i]->m_bDirConnect) ;
	   m_pdlgWAN[i]->m_ComBoxModemTypes.EnableWindow (fAsync && 
	   										!m_pdlgWAN[i]->m_bDirConnect) ;
		m_pdlgWAN[i]->m_chkboxIdleFlags.EnableWindow (!fAsync) ;

////Prabha, 19/2/98
   	BOOL linkcontrol;
		char prefix_alphabet = 65;
		int tempnum, index, entrynum = 0, prefix_num = 0;
	   USHORT temp_ushort ;

		if (ppp_ptr->ppp_ports[i].connection_dod) 
		{
			linkcontrol = TRUE;
			m_pdlgWAN[i]->m_link_ctrl_enabled.SetCheck (1);
			m_pdlgWAN[i]->m_ctrl_idle_time.EnableWindow (TRUE);
	   	m_pdlgWAN[i]->m_ctrl_minutes.EnableWindow (TRUE);
	   	m_pdlgWAN[i]->m_ctrl_static_idle_time.EnableWindow (TRUE);
		}
		else
	   {
	   	linkcontrol = FALSE;
	   	m_pdlgWAN[i]->m_link_ctrl_enabled.SetCheck (0);
	   	m_pdlgWAN[i]->m_ctrl_idle_time.EnableWindow (FALSE);
	   	m_pdlgWAN[i]->m_ctrl_minutes.EnableWindow (FALSE);
	   	m_pdlgWAN[i]->m_ctrl_static_idle_time.EnableWindow (FALSE);
		}

		temp_ushort = ppp_ptr->ppp_ports[i].hangup_time ;
	   m_pdlgWAN[i]->m_idle_time = temp_ushort / 60 ;

		if (i != 0)
		{
			CNF_PROXY_PORT *proxy_port_ptr ;
			ULONG offset ;
			offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct;
			calculate_offset_of_proxy_port (&offset, i+1) ;
			proxy_port_ptr = (CNF_PROXY_PORT *) offset ;

			m_pdlgWAN[i]->m_active_connections = proxy_port_ptr->number_of_connections_to_trigger ;
	   	m_pdlgWAN[i]->m_active_hosts = proxy_port_ptr->number_of_hosts_to_trigger ;
			tempnum = proxy_port_ptr->number_of_address_entries ;
	   	for (index = 0; index < tempnum; index++)
	   	{
				get_dot_decimal_ip_address (proxy_port_ptr->port_address[index].address, szBuf) ;
	         m_pdlgWAN[i]->m_list_host.AddString (szBuf);
			}
		}

/* 23/03/99 Jo added to take care of MLPPP and link control dependencies */
		int is_mlppp_enabled ;
		if (i)
			is_mlppp_enabled = ppp_ptr->ppp_ports[0].lcp_epd.valid ;
	   if ((i == 0) || (is_mlppp_enabled) || (!ppp_ptr->ppp_ports[i].connection_dod) || (wan_ptr->wan_ports[i].auto_answer))
	   	linkcontrol = FALSE;
	   else
	   	linkcontrol = TRUE;
	   m_pdlgWAN[i]->m_static_bring_up.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_ctrl_static_active_connections.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_ctrl_active_connections.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_ctrl_static_ip_hosts.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_ctrl_active_ip_hosts.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_static_list_host.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_list_host.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_ctrl_host.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_ctrl_add.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_ctrl_delete.EnableWindow (linkcontrol);
	   m_pdlgWAN[i]->m_ctrl_active_ip_hosts.LimitText (5);

		if (!linkcontrol && wan_ptr->wan_ports[i].auto_answer)
		{
	   	m_pdlgWAN[i]->m_link_ctrl_enabled.SetCheck (0);
	   	m_pdlgWAN[i]->m_ctrl_idle_time.EnableWindow (FALSE);
	   	m_pdlgWAN[i]->m_ctrl_minutes.EnableWindow (FALSE);
	   	m_pdlgWAN[i]->m_ctrl_static_idle_time.EnableWindow (FALSE);
		}	

/* ...Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies */
		if (is_mlppp_enabled && i != 0)
		{
	   	m_pdlgWAN[i]->m_link_ctrl_enabled.SetCheck (0) ;
			m_pdlgWAN[i]->m_link_ctrl_enabled.EnableWindow (FALSE) ;
	   	m_pdlgWAN[i]->m_ctrl_idle_time.EnableWindow (FALSE) ;
	   	m_pdlgWAN[i]->m_ctrl_minutes.EnableWindow (FALSE) ;
	   	m_pdlgWAN[i]->m_ctrl_static_idle_time.EnableWindow (FALSE) ;
		}
/* Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies... */

// Update the Dialog fields  
	   m_pdlgWAN[i]->UpdateData (FALSE) ;

/* 28/06/99 Jo Added for RAS */
										  
		if (m_pdlgWAN[i]->m_bDirConnect)
			m_pdlgWAN[i]->m_BtnProxyOrRas.EnableWindow (FALSE) ;
		if (ppp_ptr->ppp_ports[0].lcp_epd.valid)
		{
			m_pdlgWAN[i]->m_BtnRasOnly.EnableWindow (FALSE) ;
			m_pdlgWAN[i]->m_BtnProxyOrRas.EnableWindow (FALSE) ;
		}
   } 
}

BOOL CWanTab::OnInitDialog()
{
	CDialog::OnInitDialog() ;
	
	char Buf[4][16] ;
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	switch (tabcount)
	{
	case 1:
		strcpy (Buf[0], " &WAN ") ;
		strcpy (Buf[1], " &Advanced ") ;
		break;
	case 3:
		strcpy (Buf[0], "WAN  &1") ;
		strcpy (Buf[1], "WAN  &2") ;
		strcpy (Buf[2], "WAN  &3") ;
		strcpy (Buf[3], " &Advanced ") ;
		break;
	default:
		break;		
	}

	// Add the Tabs
	for (int i = 0 ; i < tabcount ; i ++)
		addTabView (m_pdlgWAN[i], Buf[i], TRUE, (i == 0), 80) ;
	addTabView (m_advdlgWAN, Buf[tabcount], TRUE, FALSE, 80);
	
   // Get all the parameters of all the ports from INI file
   CenterWindow() ;

	CMainDlg *pMainDialog = (CMainDlg *) GetParent() ;
	RouterStatus = pMainDialog->RouterUp && pMainDialog->TargetFound ;

	GetConfig() ; 
   AfxGetApp()->DoWaitCursor(0) ;
	
   CTabDialog::OnInitDialog() ;
                                               
	return FALSE ;
}


int CWanTab::AcceptConfig()
{
	LPCSTR temp ;
	char m_szTempBuf[21] ;
	temp = (char *) m_szTempBuf ;

	char TempLSL[] = "LSL ", TempWAN[] = "WAN " ;
	char TempPort[] = "Port", TempPortNumber[10], TempSpeed[] = " Speed" ;
	char TempBuff[40] ;
	char prefix_alphabet = 65;
	int prefix_num = 0;

	char sztemp[15] ; // added by cfp on 26-3-96

   //Write all parameters for Ports
   //Write BOOL parameters
	char field[80] ;

	WriteModemInfoToIni() ;
	for (int i = 0 ; i < tabcount ; i ++)
	{
  	   m_pdlgWAN[i]->UpdateData (TRUE) ;
	   char Buf[12] ;

	   wan_ptr->wan_ports[i].enabled = m_pdlgWAN[i]->m_WANPort ;

	// Chida - 21 Apr 1997		
		char szLHS[100];
	// Chida - 21 Apr 1997		

/* Jo 19/02/99 If WAN is disabled do not disable PPP if we do so it
creats a lot of problem because of a bug in code which requires PPP to
be enabled all the time */

/* Jo 24/06/99 Added for RAS */
		CNF_PROXY_PORT *proxy_port_ptr ;
		ULONG offset ;
		offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct;
		calculate_offset_of_proxy_port (&offset, i+1) ;
		proxy_port_ptr = (CNF_PROXY_PORT *) offset ;

		if (m_pdlgWAN[i]->m_BtnRasOnly.GetCheck())
			proxy_port_ptr->enabled = 0 ;
		else
			proxy_port_ptr->enabled = 1 ;

		if (m_pdlgWAN[i]->m_BtnProxyOnly.GetCheck())
		{
			wan_ptr->wan_ports[i].auto_answer = 0 ;
			ppp_ptr->ppp_ports[i].remote_port_client_only = 0 ;
		}
		else
			if (m_pdlgWAN[i]->m_BtnRasOnly.GetCheck())
			{
				wan_ptr->wan_ports[i].auto_answer = 1 ;
				ppp_ptr->ppp_ports[i].remote_port_client_only = 1 ;
			}
	  		else
			{
				wan_ptr->wan_ports[i].auto_answer = 0 ;
				ppp_ptr->ppp_ports[i].remote_port_client_only = 1 ;
			}

/* Jo 24/06/99 Added for RAS */

		strcpy (field, Buf) ;
   		strcat (field, " Direct Connect") ;
  		wsprintf (szLHS, "PPP Port%d Remote Option%%LCP%%CallBack", i);
   		
		if (m_pdlgWAN[i]->m_chkBtnDirConnect.GetCheck())
		{
			ppp_ptr->ppp_ports[i].remote_lcp_callback.valid = 0 ;
		}	
		else
		{
		   ppp_ptr->ppp_ports[i].remote_lcp_callback.option_type = 13 ;
			ppp_ptr->ppp_ports[i].remote_lcp_callback.Auto = 1 ;
			ppp_ptr->ppp_ports[i].remote_lcp_callback.NegNotReqd = 1 ;
			ppp_ptr->ppp_ports[i].remote_lcp_callback.Negotiable = 1 ;
			ppp_ptr->ppp_ports[i].remote_lcp_callback.value_type = H1 ;
			ppp_ptr->ppp_ports[i].remote_lcp_callback.valid = 1 ;
			strcpy ((char *)ppp_ptr->ppp_ports[i].remote_lcp_callback.option_value, "00") ;
		}
		wan_ptr->wan_ports[i].direct_connect = m_pdlgWAN[i]->m_chkBtnDirConnect.GetCheck() ;
		wan_ptr->wan_ports[i].script_enabled = m_pdlgWAN[i]->m_bScriptEnable ;
		wan_ptr->wan_ports[i].restart_script_on_comm_failure = m_pdlgWAN[i]->m_bRestartScriptOnCommFailure ;

		// Modified by cfp on 25-3-96
		// To See that no Null Speed is in Combo box
		// and later written to ini file
		char BaudBuf[15] ;
		if (m_pdlgWAN[i]->m_cboxAsyncBaud.IsEmpty())
			m_pdlgWAN[i]->m_cboxAsyncBaudWnd.GetLBText (0, (LPSTR) BaudBuf) ;
		else
			strcpy (BaudBuf, m_pdlgWAN[i]->m_cboxAsyncBaud) ;

#if 0 /* Sachin took this off */
		if ( i < 2 || (!m_pdlgWAN[0]->m_Backup && !m_pdlgWAN[1]->m_Backup))
#endif
		wan_ptr->wan_ports[i].speed = atol( BaudBuf) ;

		// Write CString Parameters

		int count = 0;
		char tempbuf[25];
		ULONG int_ip_addr ;

		ppp_ptr->ppp_ports[i].hangup_time = m_pdlgWAN[i]->m_idle_time * 60 ;

/* ...Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies.
	Link Control will be disabled and grayed out if MLPPP is enabled. So explicitly enable it	*/

		ppp_ptr->ppp_ports[i].connection_dod = m_pdlgWAN[i]->m_link_ctrl_enabled.GetCheck() ;
		if (ppp_ptr->ppp_ports[0].lcp_epd.valid && i != 0)
			ppp_ptr->ppp_ports[i].connection_dod = 1 ;
/* Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies... */

	   if (i != 0)
	   {
			CNF_PROXY_PORT *proxy_port_ptr ;
			ULONG offset ;
			USHORT temp_number_of_hosts ;
			offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct;
			calculate_offset_of_proxy_port (&offset, i+1) ;
			proxy_port_ptr = (CNF_PROXY_PORT *) offset ;

			temp_number_of_hosts = proxy_port_ptr->number_of_address_entries ;
			proxy_port_ptr->number_of_connections_to_trigger = 0 ;
			proxy_port_ptr->number_of_hosts_to_trigger = 0 ;
			proxy_port_ptr->number_of_address_entries = 0 ;

			if (m_pdlgWAN[i]->m_link_ctrl_enabled.GetCheck())
			{
			     proxy_port_ptr->number_of_connections_to_trigger = m_pdlgWAN[i]->m_active_connections ;
		   	  proxy_port_ptr->number_of_hosts_to_trigger = m_pdlgWAN[i]->m_active_hosts ;
			     proxy_port_ptr->number_of_address_entries = m_pdlgWAN[i]->m_list_host.GetCount() ;
		
			     if (temp_number_of_hosts < proxy_port_ptr->number_of_address_entries)
		   	  {
						ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(ULONG) * (proxy_port_ptr->number_of_address_entries - temp_number_of_hosts))) ;
						all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
						all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
						all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
						proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
						proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
		     
						offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
		   		  	calculate_offset_of_proxy_port (&offset, i+1) ;
				     	proxy_port_ptr = (CNF_PROXY_PORT *) offset ;

						offset += (sizeof(CNF_PROXY_PORT) + ((temp_number_of_hosts - 1) * sizeof(ULONG))) ;
						
				     	ULONG  SizeToMove = (ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset - 
							(sizeof(ULONG) * (proxy_port_ptr->number_of_address_entries - temp_number_of_hosts)) ;

						memmove ((void *) (offset + (proxy_port_ptr->number_of_address_entries - temp_number_of_hosts) * sizeof(ULONG)),
			         (void *) offset, (int) SizeToMove) ;
		     
		   	  }
			     else
			     {
						offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
			     		calculate_offset_of_proxy_port (&offset, i+1) ;
				     	proxy_port_ptr = (CNF_PROXY_PORT *) offset ;
				
						offset += (sizeof(CNF_PROXY_PORT) + ((temp_number_of_hosts - 1) * sizeof(ULONG))) ;

		   		  	ULONG  SizeToMove = ((ULONG) all_structures[PROXY_ID].ptr_to_struct + proxy_header_ptr->section_length - offset) ;
						ULONG dst_offset = (ULONG) (offset - ((temp_number_of_hosts - proxy_port_ptr->number_of_address_entries) * sizeof(ULONG))) ;
						_fmemmove ((void FAR *) dst_offset, (void FAR *) offset, (int) SizeToMove) ;

						ULONG SizeToRealloc = (proxy_header_ptr->section_length + (sizeof(ULONG) * (proxy_port_ptr->number_of_address_entries - temp_number_of_hosts))) ;
						all_structures[PROXY_ID].glblck = GlobalReAlloc (all_structures[PROXY_ID].glblck, SizeToRealloc, GMEM_ZEROINIT) ;
						all_structures[PROXY_ID].ptr_to_struct = GlobalLock (all_structures[PROXY_ID].glblck) ;
						all_structures[PROXY_ID].size_of_struct = (USHORT) SizeToRealloc ;
						proxy_header_ptr = (CNF_PROXY_HEADER *) all_structures[PROXY_ID].ptr_to_struct ;
						proxy_header_ptr->section_length = (USHORT) SizeToRealloc ;
			     }

			     offset = (ULONG) all_structures[PROXY_ID].ptr_to_struct ;
  	     	     calculate_offset_of_proxy_port (&offset, i+1) ;
			     proxy_port_ptr = (CNF_PROXY_PORT *) offset ;
			     for (int index = 0; index < m_pdlgWAN[i]->m_list_host.GetCount(); index++)
		   	  { 
						m_pdlgWAN[i]->m_list_host.GetText (index, tempbuf) ;				
						get_ip_address (tempbuf, &int_ip_addr) ;
						proxy_port_ptr->port_address[index].address = int_ip_addr ;
		   	  }
			}

	   } /* if */
/* Jo 28/06/99 Added for RAS */
	
		if (ppp_ptr->ppp_ports[0].lcp_epd.valid)
		{
			wan_ptr->wan_ports[i].auto_answer = 0 ;
			ppp_ptr->ppp_ports[i].remote_port_client_only = 0 ;

/* ...Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies */
			if (i != 0)
				ppp_ptr->ppp_ports[i].hangup_time = ppp_ptr->ppp_ports[0].hangup_time ;
/* Jo Added on 17 Nov 1999 to handle MLPPP and Link Control dependencies... */
		}
   } /* for */
	return TRUE ;
}					

void CWanTab::OnOK()
{
	int RASEnable = 0 ;

/* Jo 07/04/99 To reflect the addition of a new modem when OK 
	is pressed in any of the tabs not nessarily Advanced Tab */

	switch(tabcount) ;
	enableView(tabcount, TRUE)	;
	if (!m_advdlgWAN->UpdateData(TRUE))
		return ;
	if (m_advdlgWAN->m_bMdmConfigChanged) 
		m_advdlgWAN->WriteToCnfFile() ;

   for (int i = 0 ; i < tabcount ; i ++)
   {
      if (!m_pdlgWAN[i]->ValidEditFields())
      {
         switchTab(i);
			enableView(i,TRUE);
         return;
      }
   }

/* Jo Check for dependencies */
   if (!AcceptConfig()) 
   	return ;
	
   char	temp_dot_value[20] ; 
	char 	Buf[80] ;
/* 02/09/99 To set Remote IP Address as LAN + 1 if Dial Out port */
	for (i = 1; i <= ppp_ptr->ppp_header.number_of_ports; i++)
	{
		if (ppp_ptr->ppp_ports[i-1].remote_port_client_only)
 		{	
/* Jo 29-Dec-1999 Added the following to prevent Assigned IP address from being overwritten and wrap around the 
		address if required... */
			if ((!dhcp_header_ptr->dhcp_client_enabled) && (ip_ptr->ip_ports[i].remote_ip_address == 0))
			{
// Jo 03-Jan-2000 Changed scheme to get next next available IP address for RAS clients that also includes duplication check...

				ULONG next_available_ip_address ;

				get_ip_address_for_ras_port (i, &next_available_ip_address)	;
				ip_ptr->ip_ports[i].remote_ip_address = next_available_ip_address ;

// ...Jo 03-Jan-2000 Changed scheme to get next next available IP address for RAS clients that also includes duplication check

/* ...Jo 29-Dec-1999 Added the following to prevent Assigned IP address from being overwritten and wrap around the 
		address if required */

		      get_dot_decimal_ip_address (ip_ptr->ip_ports[i].remote_ip_address, temp_dot_value) ;
				sprintf (Buf, "Remote IP Address for WAN Port %d is set to %s", i, temp_dot_value) ;
				::MessageBox (GetSafeHwnd(), Buf, "ProxyServer - WAN Setup", MB_OK) ;
			}
		}
		else
			ip_ptr->ip_ports[i].remote_ip_address = 0 ;
	}
/* 02/09/99 To set Remote IP Address as LAN + 1 if Dial Out port */

	CTabDialog::OnOK() ;
    	return ;
}

void CWanTab::OnCancel()
{
	CTabDialog::OnCancel();
}

/*----------------------------------------------------------------------------
	Module 	: WriteModemInfoToIni
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Writes the Modems Info into the Roucon.Ini
				  file for each of the WAN Links under the WAN Section
	Globals
	Affected : None
----------------------------------------------------------------------------*/

void CWanTab::WriteModemInfoToIni()
{
	char szFilePath[200] ;
	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;
	fModemsPtr = fopen (szFilePath, "rb") ;

	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(),
			"Could not locate MODEMS.CNF file",
					"File Open Error", MB_OK | MB_ICONSTOP) ;
		return ;
	}

	WORD nModems ;
	MODEMS_HDR ModemsHdr ;
	fread (&ModemsHdr, sizeof (ModemsHdr), 1, fModemsPtr) ;
	nModems = ModemsHdr.NumEntries ;

	// To prevent user from Modifying the Modems.Cnf File
	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(), "Invalid MODEMS.CNF file",	"Checksum Error", MB_OK | MB_ICONSTOP) ;
		return ;
	}

	char szModemNameInCombo[80] ;
	MODEM_SETUP ModemSetup ;
	WORD j = 0 ;

	for (int i = 0 ; i < tabcount ; i ++)
	{
		// Get the Select Index of the Modem from the Combo Box
		int nCurSel = m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
		
		// If none selected write nulls to Ini file
		if (nCurSel == CB_ERR)
		{
			memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;
		}
		else
		{
			m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText (nCurSel, (LPSTR) szModemNameInCombo) ;
			// Offset from the Modems Header to First Modem Info
			fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;

			for (j = 0 ; j < nModems ; j ++)
			{
				fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) ;
				if (!strcmpi (szModemNameInCombo, ModemSetup.ModemType))
					break ;
			}
		}

		if (j == nModems)
			memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;

		WriteModemStringsToIni (i, &ModemSetup) ;
	}

	fclose (fModemsPtr) ;
	return ;
}

/*----------------------------------------------------------------------------
	Module 	: GetModemTypes
	Author 	: CFP
	Input  	: None
	Output 	: Boolean indicating any read error
	Synopsis: List all Modems from the Cnf file
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL CWanTab::GetModemTypes()
{
	char szFilePath[200] ; // For MODEMS.CNF File

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	fModemsPtr = fopen (szFilePath, "rb") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetParent()->GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
				"Warning - File not found", MB_OK) ;
		return FALSE ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetParent()->GetSafeHwnd(),
			"Invalid MODEMS.CNF file", "Warning", MB_OK) ;
		return FALSE ;
	} 

	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;
	MODEM_SETUP ModemSetup ;
	int i ;

	for (i = 0 ; i < tabcount ; i ++)
		m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent();
	while (TRUE)
	{
		if (fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) < 1)
			break ;
		if (strcmp (ModemSetup.ModemType, "Direct Connection") == 0)
			continue ;
		for (i = 0 ; i < tabcount ; i ++)
			m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (ModemSetup.ModemType) ;
	}

	fclose (fModemsPtr) ;
	return TRUE ;
}

/* Jo No ISDN */
#if 0
void CWanTab::GetIsdnTypes ()
{
	char strLHS[40],strRHS[40],buffer[512];
	char token[40];
	// char *seps = "\0";
	char seps = '\0';
	int length = 0;
	int total;
	CString szDefaultConfig;
	int k;
	
	for (k = 0; k < tabcount; k++ )
	{
		m_pdlgWAN[k]->m_ComBoxModemTypes.ResetContent();

		strcpy(strLHS,DefaultIniString);
		while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
			 StrNull, (LPSTR) strRHS,sizeof (strRHS),
				(LPCSTR) ini_INIFilename))
	  	{
		 	if ( m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, strRHS ) == CB_ERR )
		 	{
		 		// Insert the string in the list box
	 			m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( strRHS );
		 	}
		 	strLHS[6]++;
	   }
 
		total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
			buffer, sizeof(buffer), ini_INIFilename );

		while ( total > 0 )
		{
			strcpy ( token,&buffer[length]);
	      if ( m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, token ) == CB_ERR )
         {
	       	   // Insert the string in the list box
		   	m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( token );
			}	

 	      length = length + strlen ( token ) + 1;	// +1 for the NULL character
			total = total - ( strlen ( token ) + 1 ) ;
		}
	
		sprintf ( strLHS,"ISDN WAN Port%d ConfigName",k);
		GetPrivateProfileString ( WANSectionHeader, strLHS,
			StrNull,strRHS,sizeof(strRHS),IniInWinForm );
		if ( strcmp ( strRHS,StrNull ) == 0 )
			strcpy ( strRHS,"EuroIsdn");
		int nsel;
		nsel = m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact(-1,strRHS );
		if (nsel == CB_ERR )
	   nsel = 0;
		m_pdlgWAN[k]->m_ComBoxModemTypes.SetCurSel ( nsel );
		m_pdlgWAN[k]->m_ComBoxModemTypes.GetLBText (nsel,m_pdlgWAN[k]->m_szSectionName );
	}
}
#endif
//Sudha 9 Dec 1997

void CWanTab::WriteInfoInIni(char Buff[40],char RHS[40] )
{
/* Jo No ISDN */
#if 0
	char strLHS[40],strRHS[40] ;
	CIsdnTa Isdn;
	BOOL US = FALSE;
	
	//Configuration Name
	sprintf ( strLHS,"ISDN WAN %s ConfigName",Buff );
	WritePrivateProfileString(WANSectionHeader,strLHS,RHS,IniInWinForm);
	
	strcpy ( InitstrRHS,"AT");
	sprintf(InitstrLHS,"ISDN %s Initialization String1",Buff);

	//IDD_NETWORK_SWITCH_TYPE member
	WriteToRouconIni(RHS,"NetworkSwitchType","NI - 1",cfg_NetworkSwitchTypes,"!C0=");

	GetPrivateProfileString ( RHS,"NetworkSwitchType","NET3",strRHS,
		sizeof ( strRHS ),ini_INIFilename );
	US = Isdn.SwitchType ( strRHS );

	//IDD_NETWORK_CFG_I member
	WriteToRouconIni(RHS,"DataTEI","Auto TEI",cfg_TEI,"!D3=");
	WriteToRouconIni(RHS,"VoiceTEI","Auto TEI",cfg_TEI,"*!D3=");

	//IDD_NETWORK_CFG_II_US member
	WriteToRouconIni(RHS,"DataSPID","",cfg_null,"!C6=");
	WriteToRouconIni(RHS,"VoiceSPID","",cfg_null,"*!C6=");

	if ( US == TRUE )
	{
		WriteToRouconIni(RHS,"DataDirectoryNumber","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceDirectoryNumber","",cfg_null,"*!N1=");

	}
	
	//IDD_NETWORK_CFG_II_EUROPE
	else
	{	
		WriteToRouconIni(RHS,"DataMSN","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceMSN","",cfg_null,"*!N1=");

	}
	//IDD_CALL_CTRL_CFG
	
	WriteToRouconIni(RHS,"AutoAnswer","Yes",cfg_NoYes,"S0=");
	WriteToRouconIni(RHS,"PersistentDTRDialing","No",cfg_NoYes,"$D");
	WriteToRouconIni(RHS,"DialingMethod","Enbloc",cfg_DialingMethods,"%A97=");
	WriteToRouconIni(RHS,"RingsToAnswer","1",cfg_null,"S0=");
	WriteToRouconIni(RHS,"CallLineId","No",cfg_NoYes,"S50=");

	//IDD_DATA_PROTOCOL
	WriteToRouconIni(RHS,"DataProtocol","V.120",cfg_DataProtocols,"!Z=");
	WriteToRouconIni(RHS,"DataCompression","None",cfg_DataCompression,"&K");
	WriteToRouconIni(RHS,"AutoDetection","No",cfg_NoYes,"S52=");

	if ( strlen ( InitstrRHS ) > 2 )
	{
		WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
		InitstrLHS[32]++;
	}


	char max[2];
	int maxnum;

	sprintf ( max,"%c",InitstrLHS[32]);
	sscanf ( max,"%d",&maxnum);
 
	for ( int i = maxnum; i < 20;i++)
	{
		sprintf ( strLHS,"ISDN %s Initialization String%d",Buff,i);
		WritePrivateProfileString ( WANSectionHeader,strLHS,NULL,IniInWinForm );
	}
#endif
/* Jo */	
	return;
}

/* Jo No ISDN */
#if 0
void  CWanTab::WriteToRouconIni(LPCSTR Section,LPCSTR strLHS,LPCSTR Default,ini_tpValuePair Table,const char* command)
{
   char strRHS[40],tempstr[40];
	CString String;
	int value,len = 0;

	GetPrivateProfileString(Section,strLHS,Default,
		strRHS,sizeof(strRHS),ini_INIFilename);
	if (Table != cfg_null)
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			for(int i=0; Table[i].StringID;i++)
			{
				String.LoadString(Table[i].StringID );
				if (!strcmpi(String,strRHS))
				{	
					value = Table[i].nNum;
					break;
				}
			}
			sprintf(strRHS,"%s%d",command,value);
		}
	}
	else
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			sprintf(tempstr,"%s%s",command,strRHS);
			strcpy(strRHS,tempstr);
		}
	}

// Sudha 10 Feb 1998 
   if ( IsSPIDorISDN (command))
   {
   	if (!strcmp ( command,"!C6="))
      {      
      	WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
      }
	   strcat ( InitstrRHS , strRHS );
      WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
      strcpy ( InitstrRHS ,"AT");
	   InitstrLHS[32]++;
   }
   else
   {
		len = strlen ( strRHS ) + strlen ( InitstrRHS ) ;
		if ( len <= ( MAX_INIT_STRING_LENGTH - 2 ))
		strcat ( InitstrRHS , strRHS );
	
		if ( len >= ( MAX_INIT_STRING_LENGTH - 2 ))
		{
			WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
			if ( len > ( MAX_INIT_STRING_LENGTH - 2 ) )
				strcat ( InitstrRHS , strRHS );
		}
	}
	return ;
}
#endif
/* Jo */

/////////////////////////////////////////////////////////////////////////////

/* Jo Does not support ISDN */

#if 0
// CWanIsdnDlg dialog

CWanIsdnDlg::CWanIsdnDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWanIsdnDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWanIsdnDlg)
	m_WANEnable = TRUE;
	m_Printf = FALSE;
	m_PrintfRx = FALSE;
	m_PrintfTx = FALSE;
	m_PrintfInitialize = FALSE;
	m_bNonCriticalScriptPrintf = FALSE;
	m_bAlarmScriptPrintf = FALSE;
	m_szPPINISection = "";
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_nSelectedIsdn = CB_ERR ;
	IsdnEnabled = FALSE;
	Create(IDD,NULL);
}

void CWanIsdnDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanIsdnDlg)
	DDX_Control(pDX, IDC_STATIC_ISDN_CONTROL, m_IsdnCtrlWnd);
	DDX_Control(pDX, IDC_ISDN_EDIT, m_EditConfig);
	DDX_Control(pDX, IDC_ISDN_DELETE, m_DeleteConfig);
	DDX_Control(pDX, IDC_ISDN_ADD, m_AddConfig);
	DDX_Control(pDX, IDC_EXISTING_CFGS, m_INISectionControl);
	DDX_Control(pDX, IDC_CHECK_NON_CRITICAL, m_ChkBoxScriptNonCritical);
	DDX_Control(pDX, IDC_CHECK_SCRIPT_ALARM, m_ChkBoxScriptAlarm);
	DDX_Control(pDX, IDC_STATIC_SCRIPT_PRINTF_GRP, m_ScriptCtrlGrp);
	DDX_Check(pDX, IDC_PRINTF, m_Printf);
	DDX_Check(pDX, IDC_PRINTF_RX, m_PrintfRx);
	DDX_Check(pDX, IDC_PRINTF_TX, m_PrintfTx);
	DDX_Check(pDX, IDC_INITIALIZE, m_PrintfInitialize);
	DDX_Check(pDX, IDC_CHECK_NON_CRITICAL, m_bNonCriticalScriptPrintf);
	DDX_Check(pDX, IDC_CHECK_SCRIPT_ALARM, m_bAlarmScriptPrintf);
	DDX_CBString(pDX, IDC_EXISTING_CFGS, m_szPPINISection);
	DDV_MaxChars(pDX, m_szPPINISection, 40);
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanIsdnDlg, CDialog)
	//{{AFX_MSG_MAP(CWanIsdnDlg)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_ISDN_EDIT, OnIsdnEdit)
	ON_BN_CLICKED(IDC_ISDN_DELETE, OnIsdnDelete)
	ON_BN_CLICKED(IDC_ISDN_ADD, OnIsdnAdd)
	ON_CBN_SELCHANGE(IDC_EXISTING_CFGS, OnCfgs)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanIsdnDlg message handlers

BOOL CWanIsdnDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

/* Jo */ 
#if 0

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!AddBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn.SubclassDlgItem (IDC_ISDN_ADD, this));
	AddBmpBtn.SizeToContent();

	if (!DeleteBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn.SubclassDlgItem (IDC_ISDN_DELETE, this));
	DeleteBmpBtn.SizeToContent();

	if (!EditBmpBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditBmpBtn.SubclassDlgItem (IDC_ISDN_EDIT, this));
	EditBmpBtn.SizeToContent();

#endif	/* Jo */

	char szBuf[30] ;
	// Get the values of all WAN parameters from INI file.
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Printf", (LPCSTR) StrDisabled, (LPSTR) szBuf,
				sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_Printf = TRUE ;
	else 
		m_Printf = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Initialization Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfInitialize = TRUE ;
	else
		m_PrintfInitialize = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Rx Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfRx = TRUE ;
	else 
		m_PrintfRx = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Tx Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm);
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfTx = TRUE ;
	else
		m_PrintfTx = FALSE ;

	GetPrivateProfileString ((LPCSTR) ScriptSectionHeader, 
			(LPCSTR) "Script Alarm Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_bAlarmScriptPrintf = TRUE ;
	else
		m_bAlarmScriptPrintf = FALSE ;

	GetPrivateProfileString ((LPCSTR) ScriptSectionHeader, 
			(LPCSTR) "Script Non Critical Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_bNonCriticalScriptPrintf = TRUE ;
	else
		m_bNonCriticalScriptPrintf = FALSE ;

	GetIsdnTypes ();
	if (m_nSelectedIsdn != CB_ERR )
		m_INISectionControl.SetCurSel ( m_nSelectedIsdn );

	if ( m_INISectionControl.GetCurSel () == CB_ERR )
		m_INISectionControl.SetCurSel(m_INISectionControl.FindStringExact(-1,"EuroIsdn"));
   m_INISectionControl.GetLBText(m_INISectionControl.GetCurSel (),m_szPPINISection );
	sprintf ( TempSection ,"%s",m_szPPINISection );
	CenterWindow() ;

   // Update the Dialog Box fields.
	UpdateData (FALSE) ;
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

void CWanIsdnDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_WAN_ISDN_CONFIG,HELP_CONTEXT);
}

void CWanIsdnDlg::GetIsdnTypes ()
{
	char strLHS[40],strRHS[40],buffer[512];
	char *token;
	char *seps = "\0";
	int length = 0;
	int total;
	CString szDefaultConfig;
	
	m_INISectionControl.ResetContent();
	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
		if ( m_INISectionControl.FindStringExact ( -1, strRHS ) == CB_ERR )
		{
			// Insert the string in the list box
			m_INISectionControl.AddString( strRHS );
		}
		strLHS[6]++;
   } 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	if ( total != 0 )
	{
		token = strtok ( buffer, seps );
		while ( token != NULL)
		{
			if ( m_INISectionControl.FindStringExact ( -1, token ) == CB_ERR )
			{
				// Insert the string in the list box
				m_INISectionControl.AddString( token );
			}	
			length = length + strlen ( token ) + 1;	// +1 for the NULL character
	      token = strtok( &buffer[length], seps );
		}
	}
	
	if ( m_nSelectedIsdn != CB_ERR )
	{
		m_INISectionControl.SetCurSel ( m_nSelectedIsdn );
      m_INISectionControl.GetLBText ( m_INISectionControl.GetCurSel(),m_szPPINISection );
	}
}

void CWanIsdnDlg::OnIsdnEdit()
{
	// TODO: Add your control notification handler code here
	
	m_cfgtype = kEdit;
	CIsdnTa Isdn (this);
	Isdn.DoModal();

}

void CWanIsdnDlg::OnIsdnDelete()
{
	// TODO: Add your control notification handler code here

	int			nCurSel, nMBResponse;
	CString		szConfig, szMsg, config ,deleted_config;
	char strRHS[40] ,strLHS[40];
	
	CIsdnTa Isdn;

	m_cfgtype = kDelete;

	if ( m_INISectionControl.GetCurSel() == CB_ERR)
	{
		::MessageBox(GetSafeHwnd(),"Select a Configuration file to delete",IsdnMsgHeader,MB_OK);
		m_INISectionControl.SetFocus();
		return;
	}
	else
	{
		nCurSel = m_INISectionControl.GetCurSel ();
   	m_INISectionControl.GetLBText ( nCurSel, m_szPPINISection );
		deleted_config = m_szPPINISection;

	   if ( nCurSel != CB_ERR )
	   { 
			m_INISectionControl.GetLBText ( nCurSel, szConfig );
			if ( Isdn.IsThisADefaultCfg ( szConfig ) )
			{	
				szMsg.LoadString(IDS_DELETE_DEFAULT_CONFIG);
				nMBResponse = AfxMessageBox ( szMsg );
				return;
			}
			sprintf(strLHS,"Port0");
			while ( GetPrivateProfileString ( MapHeader,strLHS,
				StrNull,strRHS,sizeof(strRHS),ini_INIFilename ))
		  	{
				if ( szConfig.CompareNoCase ( strRHS ) == 0 )
				{
 					::MessageBox ( GetSafeHwnd(),"This is the existing configuration.\
Before deleting this make sure to change the configuration.",IsdnMsgHeader,MB_OK);
					return;
				}
			 	strLHS[4]++;
			}
		   szMsg.LoadString(IDS_DELETE_CONFIG);
		   nMBResponse = AfxMessageBox ( szMsg, MB_YESNO, 0 );
			if ( nMBResponse == IDYES )
			{
				::WritePrivateProfileString ( szConfig, NULL, NULL, ini_INIFilename );
				::WritePrivateProfileString  (	"User Config", szConfig, NULL, ini_INIFilename );
				m_INISectionControl.DeleteString ( nCurSel );
			
				if ( nCurSel != m_INISectionControl.GetCount () )
					m_INISectionControl.SetCurSel ( (nCurSel) );
				else
					m_INISectionControl.SetCurSel ( nCurSel-1 );
			}
		}
		////Prabha, 4/2/98, To echo the deletion in the port tabs also
		CWanIsdnTab *pParent = (CWanIsdnTab *)GetParent();
		pParent->m_pisdnWAN->m_ComBoxModemTypes.GetLBText ( nCurSel, deleted_config );
			pParent->m_pisdnWAN->m_ComBoxModemTypes.DeleteString (nCurSel);
	}		
	return;
}

void CWanIsdnDlg::OnIsdnAdd()
{
	// TODO: Add your control notification handler code here

	m_cfgtype = kAdd;
	
	CIsdnTa Isdn (this);
	if (Isdn.DoModal() == IDOK)
	{
		////Prabha, 6/3/98, Put the newly added config in the list
		if (m_INISectionControl.FindStringExact (-1, Isdn.m_szPPSectionName ) == CB_ERR)
			m_INISectionControl.AddString ( Isdn.m_szPPSectionName );
  		CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;
		if ( pParent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact ( -1, Isdn.m_szPPSectionName ) == CB_ERR )
				pParent->m_pisdnWAN->m_ComBoxModemTypes.AddString ( Isdn.m_szPPSectionName );
	}
}

void CWanIsdnDlg::OnCfgs()
{
	// TODO: Add your control notification handler code here
	
	if ( m_INISectionControl.GetCurSel() != CB_ERR )
	{
 		//m_INISectionControl.GetWindowText ( m_szPPINISection );
                m_INISectionControl.GetLBText ( 
                        m_INISectionControl.GetCurSel(),m_szPPINISection );

		sprintf ( TempSection,"%s",m_szPPINISection );
	}
	
}

void CWanIsdnDlg::PutIsdnConfigInParentsList (int index)
{
	CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;
 	int nCount = m_INISectionControl.GetCount() ;

	char szBuf[40] ;
	int nIndex ;
	int i = index;

	nIndex = pParent->m_pisdnWAN->m_ComBoxModemTypes.GetCurSel() ;
	if (nIndex != CB_ERR)
	{
		pParent->m_pisdnWAN->m_ComBoxModemTypes.GetLBText (nIndex, szBuf) ;
		pParent->m_pisdnWAN->m_szOldIsdnSel = szBuf ;
	}
	else
		pParent->m_pisdnWAN->m_szOldIsdnSel = "" ;
			
	// Refresh the Isdn Configs List in the Combo Box
	pParent->m_pisdnWAN->m_ComBoxModemTypes.ResetContent() ;
		
	// Add Isdn Configs to List
	for (int j = 0 ; j < nCount ; j ++)
	{
		m_INISectionControl.GetLBText (j, (LPSTR) szBuf) ;
		pParent->m_pisdnWAN->m_ComBoxModemTypes.AddString (szBuf) ;
	}

	// If there was a previous selection restore it
	if (!pParent->m_pisdnWAN->m_szOldIsdnSel.IsEmpty())
	{
		nIndex =	
			pParent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact (-1, 
							pParent->m_pisdnWAN->m_szOldIsdnSel) ;								
		if ( nIndex == CB_ERR)
			nIndex = 0;
		pParent->m_pisdnWAN->m_ComBoxModemTypes.SetCurSel (nIndex) ;
	}
}

LRESULT CWanIsdnDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CWanIsdnDlg::PostNcDestroy(void)
{
	delete this;
}

void CWanIsdnDlg::OnOK()
{
	// Update the parameters from the Dialog Box.
	if (!UpdateData (TRUE))
      return ;

	LPCSTR temp ;
	// Write the WAN parameters to the INI file.

	if (m_Printf)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) "WAN Printf", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
		
	if (m_PrintfInitialize)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Initialization Printf", (LPCSTR) temp,
				(LPCSTR) IniInWinForm) ;

	if (m_PrintfRx)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Rx Printf", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
			
	if (m_PrintfTx)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Tx Printf", temp, (LPCSTR) IniInWinForm) ;

	if (m_bAlarmScriptPrintf)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) ScriptSectionHeader, 
				(LPCSTR) "Script Alarm Printf", 
						(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_bNonCriticalScriptPrintf)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) ScriptSectionHeader, 
				(LPCSTR) "Script Non Critical Printf", 
						(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;
	PutIsdnConfigInParentsList(0) ;

	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

void CWanIsdnDlg::OnCancel()
{
	// TODO: Add extra cleanup here

	CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}


/////////////////////////////////////////////////////////////////////////////
// CWanIsdnPort dialog


CWanIsdnPort::CWanIsdnPort(CWnd* pParent /*=NULL*/)
	: CDialog(CWanIsdnPort::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWanIsdnPort)
	m_WANPort = FALSE;
	m_cboxAsyncBaud = "";
	m_bRestartScriptOnCommFailure = FALSE;
	m_bScriptEnable = FALSE;
	m_szSectionName = "";
	m_Idle_time = 0;
	//}}AFX_DATA_INIT
	Create(IDD,NULL);
}

void CWanIsdnPort::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanIsdnPort)
	DDX_Control(pDX, IDC_CHECK_DOD_ENABLE, m_LnkCtrlWnd);
	DDX_Control(pDX, IDC_BTN_SCRIPT, m_BtnScript);
	DDX_Control(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_RestartScriptWnd);
	DDX_Control(pDX, IDC_CHECK_ENABLE_SCRIPT, m_ScriptEnableWnd);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPES, m_ComBoxModemTypes);
	DDX_Control(pDX, IDC_BAUD_HEADER, m_BaudHeader);
	DDX_Control(pDX, IDC_DIALLING, m_RBtnDialling);
	DDX_Control(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaudWnd);
	DDX_Control(pDX, IDC_RADIO_ASYNC, m_RBtnAsync);
	DDX_Check(pDX, IDC_WAN_PORT, m_WANPort);
	DDX_CBString(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaud);
	DDV_MaxChars(pDX, m_cboxAsyncBaud, 15);
	DDX_Check(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_bRestartScriptOnCommFailure);
	DDX_Check(pDX, IDC_CHECK_ENABLE_SCRIPT, m_bScriptEnable);
	DDX_CBString(pDX, IDC_COMBO_MODEM_TYPES, m_szSectionName);
	DDX_Text(pDX, IDC_EDIT_IDLE_TIME, m_Idle_time);
	DDV_MinMaxUInt(pDX, m_Idle_time, 1, 500);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanIsdnPort, CDialog)
	//{{AFX_MSG_MAP(CWanIsdnPort)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_REGISTERED_MESSAGE(msgSwitchTo, OnSwitchToIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_BTN_SCRIPT, OnBtnScript)
	ON_BN_CLICKED(IDC_CHECK_DOD_ENABLE, OnCheckDodEnable)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanIsdnPort message handlers

BOOL CWanIsdnPort::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

/* Jo bitmap */
#if 0 

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!ScriptBmpBtn.LoadBitmaps ("SCRIPT1", "SCRIPT2", "SCRIPT3", "SCRIPT4"))
		AfxMessageBox ("Failed to load SCRIPT bitmap");

	VERIFY (ScriptBmpBtn.SubclassDlgItem (IDC_BTN_SCRIPT, this));
	ScriptBmpBtn.SizeToContent();

#endif 
/* Jo bitmap */

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWanIsdnPort::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void CWanIsdnPort::OnOK()
{
	// TODO: Add extra validation here
	if (!UpdateData (TRUE))
		return ;

	CDialog::OnOK() ;
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

LRESULT CWanIsdnPort::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CWanIsdnPort::PostNcDestroy(void)
{
	delete this;
}

void CWanIsdnPort::OnHelp()
{
		AfxGetApp()->WinHelp(0x20000 + IDD_WAN_ISDN_PORT_CONFIG,HELP_CONTEXT);
	
}

void CWanIsdnPort::OnBtnScript()
{
	// TODO: Add your control notification handler code here

	CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;

	CScriptDlg script ;
	script.m_nPortNum = (int)0 ;
	script.DoModal() ;
}

LRESULT CWanIsdnPort::OnSwitchToIden (WPARAM wParam, LPARAM lParam)
{
	UpdateData (TRUE) ;
	return 0L ;
}

void CWanIsdnPort::GetIsdnTypes (int j)
{
	char strLHS[40],strRHS[40],buffer[512];
	char token[40];
	// char *seps = "\0";
	char seps = '\0';
	int length = 0;
	int total;
	CString szDefaultConfig;
	int k = j;
	
	CWanIsdnTab *parent = (CWanIsdnTab *)GetParent();

	parent->m_pisdnWAN->m_ComBoxModemTypes.ResetContent();

	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
	 	if ( parent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact ( -1, strRHS ) == CB_ERR )
	 	{
	 		// Insert the string in the list box
	 		parent->m_pisdnWAN->m_ComBoxModemTypes.AddString( strRHS );
	 	}
	 	strLHS[6]++;
   }
 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	while ( total > 0 )
	{
		strcpy ( token,&buffer[length]);
      if ( parent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact ( -1, token ) == CB_ERR )
      {
     	   // Insert the string in the list box
		   parent->m_pisdnWAN->m_ComBoxModemTypes.AddString( token );
		}	

      length = length + strlen ( token ) + 1;	// +1 for the NULL character
		total = total - ( strlen ( token ) + 1 ) ;
	}
	
	sprintf ( strLHS,"ISDN WAN Port%d ConfigName",j);
	GetPrivateProfileString ( WANSectionHeader, strLHS,
		StrNull,strRHS,sizeof(strRHS),IniInWinForm );
	if ( strcmp ( strRHS,StrNull ) == 0 )
		strcpy ( strRHS,"EuroIsdn");
	int nsel;
	nsel = parent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact(-1,strRHS );
	if (nsel == CB_ERR )
	   nsel = 0;
	parent->m_pisdnWAN->m_ComBoxModemTypes.SetCurSel ( nsel );
	parent->m_pisdnWAN->m_ComBoxModemTypes.GetLBText (nsel,parent->m_pisdnWAN->m_szSectionName );

}

/////////////////////////////////////////////////////////////////////////////
// CWanIsdnTab dialog


CWanIsdnTab::CWanIsdnTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(CWanIsdnTab::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWanIsdnTab)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pisdnWAN = new CWanIsdnPort (this);
	m_advisdnWAN = new CWanIsdnDlg (this);
}

void CWanIsdnTab::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanIsdnTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanIsdnTab, CTabDialog)
	//{{AFX_MSG_MAP(CWanIsdnTab)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanIsdnTab message handlers

BOOL CWanIsdnTab::OnInitDialog()
{
	CDialog::OnInitDialog() ;
	
	char Buf[4][16] ;
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	strcpy (Buf[0], " &WAN ") ;
	strcpy (Buf[1], " &Advanced ") ;

	// Add the Tabs
	addTabView (m_pisdnWAN, Buf[0], TRUE, TRUE, 80) ;
	addTabView (m_advisdnWAN, Buf[1], TRUE, FALSE, 80);
	
   // Get all the parameters of all the ports from INI file
   CenterWindow() ;

	CMainDlg *pMainDialog = (CMainDlg *) GetParent() ;
	RouterStatus = pMainDialog->RouterUp && pMainDialog->TargetFound ;

	GetConfig() ; 
   AfxGetApp()->DoWaitCursor(0) ;
	
   CTabDialog::OnInitDialog() ;
                                               
	return FALSE ;
}


void CWanIsdnTab::GetConfig()
{
	char szBuf[80] ;
   // Get all the parameters for Ports
   // Get the BOOL parameters.      
  	char field[80] ;

  	int i = 0;
	char Buf[12] ;
	_itoa (i, Buf, 10) ;
		
	strcpy (field, "WAN Port") ;
	strcat (field, Buf) ;
	strcpy (Buf, field) ;
	GetPrivateProfileString (WANSectionHeader,
			(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
  	if (!strcmp (szBuf, StrEnabled))
  		m_pisdnWAN->m_WANPort = TRUE ;
  	else
   	m_pisdnWAN->m_WANPort = FALSE ;

	m_pisdnWAN->m_RBtnAsync.SetCheck (1) ;
	m_pisdnWAN->m_RBtnAsync.EnableWindow(FALSE);
	 
	strcpy (field, Buf) ;
	strcat (field, " Script") ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) StrDisabled, (LPSTR) szBuf,
				sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_pisdnWAN->m_bScriptEnable = TRUE ;
	else
		m_pisdnWAN->m_bScriptEnable = FALSE ;
        
	strcpy (field, Buf) ;
	strcat (field, " Restart Script On Comm Failure") ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) StrDisabled, (LPSTR) szBuf,
				sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_pisdnWAN->m_bRestartScriptOnCommFailure = TRUE ;
	else
		m_pisdnWAN->m_bRestartScriptOnCommFailure = FALSE ;

	m_pisdnWAN->m_RBtnDialling.SetCheck (1) ;
	m_pisdnWAN->m_RBtnDialling.EnableWindow(FALSE);

   // Get the CString parameters.
   strcpy (field, Buf) ;
   strcat (field, " Speed") ;
   GetPrivateProfileString (WANSectionHeader,
   	(LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),
	     (LPCSTR) IniInWinForm) ;

   m_pisdnWAN->m_cboxAsyncBaud = szBuf ;
   m_pisdnWAN->m_OldSpeedStr = szBuf ;

	m_pisdnWAN->GetIsdnTypes(0);	

//Vidy 30/4/98	  vvvv
	//DOD related control handling
	wsprintf (field, "PPP Port0 Connection Dial On Demand");
	GetPrivateProfileString ((LPCSTR) PPPSectionHeader, 
			(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
				(LPCSTR) IniInWinForm);
	if (!strcmp (szBuf, StrEnabled))
		m_pisdnWAN->m_LnkCtrlWnd.SetCheck(1);		
	else
		m_pisdnWAN->m_LnkCtrlWnd.SetCheck(0);		

//	m_pisdnWAN->OnCheckDodEnable();	//display controls greyed or not

	//get the idle time and update display
	int tempnum;
	wsprintf (field, "PPP Port%d Connection Idle Timer", i);
	tempnum = GetPrivateProfileInt ((LPCSTR) PPPSectionHeader, 
		(LPCSTR) field, 0, (LPCSTR) IniInWinForm);
	m_pisdnWAN->m_Idle_time = tempnum / 60;
//Vidy 30/4/98 ^^^^


  		// Update the Dialog fields  
	m_pisdnWAN->UpdateData (FALSE) ;
}

void CWanIsdnTab::OnOK()
{
	if (!AcceptConfig()) 
		return ;
	CTabDialog::OnOK() ;
	return ;
}

void CWanIsdnTab::OnCancel()
{
	CTabDialog::OnCancel();
}

int CWanIsdnTab::AcceptConfig()
{
	LPCSTR temp ;
	char m_szTempBuf[21] ;
	temp = (char *) m_szTempBuf ;

	char TempLSL[] = "LSL ", TempWAN[] = "WAN " ;
	char TempPort[] = "Port", TempSpeed[] = " Speed" ;

	BOOL FLAG ;
	
   //Write all parameters for Ports
   //Write BOOL parameters
	char field[80] ;

	int i = 0;
	char Buf[12] ;
	_itoa (i, Buf, 10) ;
		
	strcpy (field,"WAN Port") ;
	strcat (field,Buf) ;
	strcpy (Buf,field) ;     

  	m_pisdnWAN->UpdateData (TRUE) ;
	
   if (m_pisdnWAN->m_WANPort)
  		temp = StrEnabled ;
   else
   	temp = StrDisabled ;
	
   WritePrivateProfileString (WANSectionHeader,
	   	(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	// If WAN is disabled then disable PPP, SLIP and Frame Relay
	if (!m_pisdnWAN->m_WANPort)
	{
		CMainDlg *pParent = (CMainDlg *)GetParent();
		pParent->EnablePPP (i, FALSE);
		pParent->EnableSLIP (i, FALSE);
        }
			
  	strcpy (field, Buf) ;
   strcat (field, " Async") ;
   if (m_pisdnWAN->m_RBtnAsync.GetCheck())
		temp = StrEnabled ;
	else
		temp = StrDisabled ;                              

	FLAG = m_pisdnWAN->m_RBtnAsync.GetCheck() ? TRUE : FALSE ;
	
	WritePrivateProfileString (WANSectionHeader,
			(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	strcpy (field, Buf) ;
	strcat (field, " Script") ;
	if (m_pisdnWAN->m_bScriptEnable)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	strcpy (field, Buf) ;
	strcat (field, " Restart Script On Comm Failure") ; 
	if (m_pisdnWAN->m_bRestartScriptOnCommFailure)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	strcpy (field, Buf) ;
	strcat (field, " Speed") ;
	// Modified by cfp on 25-3-96
	// To See that no Null Speed is in Combo box
	// and later written to ini file
	char BaudBuf[15] ;
	if (m_pisdnWAN->m_cboxAsyncBaud.IsEmpty())
		m_pisdnWAN->m_cboxAsyncBaudWnd.GetLBText (0, (LPSTR) BaudBuf) ;
	else
		strcpy (BaudBuf, m_pisdnWAN->m_cboxAsyncBaud) ;
	WritePrivateProfileString(WANSectionHeader, (LPCSTR) field,
		(LPCSTR) BaudBuf, (LPCSTR) IniInWinForm) ;


	sprintf ( field,"ISDN WAN Port%d",i);
	WritePrivateProfileString ( WANSectionHeader,(LPCSTR) field,
		StrEnabled,IniInWinForm );
	strcpy (field, m_pisdnWAN->m_szSectionName);
	sprintf ( Buf,"Port%d",i);
	WriteInfoInIni ( Buf, field );

   // Write CString Parameters
	if (FLAG)
	{
		// 2/11/95 Vidy
		// Update the LSL speed also for SNMP to report it properly
		strcpy(field, "LSL Port1");
	   strcat (field," Speed") ;
		// Modified by cfp on 25-3-96
		WritePrivateProfileString(LSLSectionHeader, (LPCSTR) field,
			  (LPCSTR) m_pisdnWAN->m_cboxAsyncBaud, (LPCSTR) IniInWinForm) ;
  	}


//Vidy 30/4/98 vvvvvvv
	//Save the DOD parameteres
	if (m_pisdnWAN->m_LnkCtrlWnd.GetCheck())
		temp = StrEnabled ;
	else
		temp = StrDisabled ;

	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
		(LPCSTR) "PPP Port0 Connection Dial on Demand",
		(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_pisdnWAN->m_Idle_time < 0 || m_pisdnWAN->m_Idle_time > 500)
		m_pisdnWAN->m_Idle_time = 10;	// if limits exceed, set to default

	wsprintf (m_szTempBuf, "%d", m_pisdnWAN->m_Idle_time * 60);
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
		(LPCSTR) "PPP Port0 Connection Idle Timer",
		(LPCSTR) m_szTempBuf, (LPCSTR) IniInWinForm);

//Vidy 30/4/98	^^^^^^^

	return TRUE ;
}					

void CWanIsdnTab::WriteInfoInIni(char *Buff,char *RHS )
{
	char strLHS[40],strRHS[40] ;
	CIsdnTa Isdn;
	BOOL US = FALSE;
	
	//Configuration Name
	sprintf ( strLHS,"ISDN WAN %s ConfigName",Buff );
	WritePrivateProfileString(WANSectionHeader,strLHS,RHS,IniInWinForm);
	
	strcpy ( InitstrRHS,"AT");
	sprintf(InitstrLHS,"ISDN %s Initialization String1",Buff);

	//IDD_NETWORK_SWITCH_TYPE member
	WriteToRouconIni(RHS,"NetworkSwitchType","NI - 1",cfg_NetworkSwitchTypes,"!C0=");

	GetPrivateProfileString ( RHS,"NetworkSwitchType","NET3",strRHS,
		sizeof ( strRHS ),ini_INIFilename );
	US = Isdn.SwitchType ( strRHS );

	//IDD_NETWORK_CFG_I member
	WriteToRouconIni(RHS,"DataTEI","Auto TEI",cfg_TEI,"!D3=");
	WriteToRouconIni(RHS,"VoiceTEI","Auto TEI",cfg_TEI,"*!D3=");

	//IDD_NETWORK_CFG_II_US member
	WriteToRouconIni(RHS,"DataSPID","",cfg_null,"!C6=");
	WriteToRouconIni(RHS,"VoiceSPID","",cfg_null,"*!C6=");

	if ( US == TRUE )
	{
		WriteToRouconIni(RHS,"DataDirectoryNumber","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceDirectoryNumber","",cfg_null,"*!N1=");

	}
	
	//IDD_NETWORK_CFG_II_EUROPE
	else
	{	
		WriteToRouconIni(RHS,"DataMSN","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceMSN","",cfg_null,"*!N1=");

	}
	//IDD_CALL_CTRL_CFG
	
	WriteToRouconIni(RHS,"AutoAnswer","Yes",cfg_NoYes,"S0=");
	WriteToRouconIni(RHS,"PersistentDTRDialing","No",cfg_NoYes,"$D");
	WriteToRouconIni(RHS,"DialingMethod","Enbloc",cfg_DialingMethods,"%A97=");
	WriteToRouconIni(RHS,"RingsToAnswer","1",cfg_null,"S0=");
	WriteToRouconIni(RHS,"CallLineId","No",cfg_NoYes,"S50=");

	//IDD_DATA_PROTOCOL
	WriteToRouconIni(RHS,"DataProtocol","V.120",cfg_DataProtocols,"!Z=");
	WriteToRouconIni(RHS,"DataCompression","None",cfg_DataCompression,"&K");
	WriteToRouconIni(RHS,"AutoDetection","No",cfg_NoYes,"S52=");

	if ( strlen ( InitstrRHS ) > 2 )
	{
		WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
		InitstrLHS[32]++;
	}


	char max[2];
	int maxnum;

	sprintf ( max,"%c",InitstrLHS[32]);
	sscanf ( max,"%d",&maxnum);
 
	for ( int i = maxnum; i < 20;i++)
	{
		sprintf ( strLHS,"ISDN %s Initialization String%d",Buff,i);
		WritePrivateProfileString ( WANSectionHeader,strLHS,NULL,IniInWinForm );
	}
	
	return;
}

void  CWanIsdnTab::WriteToRouconIni(LPCSTR Section,LPCSTR strLHS,LPCSTR Default,ini_tpValuePair Table,const char* command)
{
   char strRHS[40],tempstr[40];
	CString String;
	int value,len = 0;

	GetPrivateProfileString(Section,strLHS,Default,
		strRHS,sizeof(strRHS),ini_INIFilename);
	if (Table != cfg_null)
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			for(int i=0; Table[i].StringID;i++)
			{
				String.LoadString(Table[i].StringID );
				if (!strcmpi(String,strRHS))
				{	
					value = Table[i].nNum;
					break;
				}
			}
			sprintf(strRHS,"%s%d",command,value);
		}
	}
	else
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			sprintf(tempstr,"%s%s",command,strRHS);
			strcpy(strRHS,tempstr);
		}
	}

// Sudha 10 Feb 1998 
   if ( IsSPIDorISDN (command))
   {
   	if (!strcmp ( command,"!C6="))
      {      
      	WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
      }
	   strcat ( InitstrRHS , strRHS );
      WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
      strcpy ( InitstrRHS ,"AT");
	   InitstrLHS[32]++;
   }
   else
   {
		len = strlen ( strRHS ) + strlen ( InitstrRHS ) ;
		if ( len <= ( MAX_INIT_STRING_LENGTH - 2 ))
		strcat ( InitstrRHS , strRHS );
	
		if ( len >= ( MAX_INIT_STRING_LENGTH - 2 ))
		{
			WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
			if ( len > ( MAX_INIT_STRING_LENGTH - 2 ) )
				strcat ( InitstrRHS , strRHS );
		}
	}
	return ;
}


void CWanIsdnPort::OnCheckDodEnable()
{
	// TODO: Add your control notification handler code here
	if (m_LnkCtrlWnd.GetCheck())
	{
	}
	else
	{
	}
}

#endif
/* Jo */

