// wandlg.h : header file
//
#include "tabdlg.h"
#include "dot.h"
//Sudha 9 Dec 1997
#include "isdnta.h"

#define MAX_INIT_STRING_LENGTH 41
#define n_PORTMAX_WAN 4
#define kEdit 0
#define kAdd 1
#define kDelete 2 
/////////////////////////////////////////////////////////////////////////////
// CWANDlg dialog

class CWANDlg : public CDialog
{
// Construction
public:
	CWANDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CWANDlg)
	enum { IDD = IDD_WAN_CONFIG };
	CStatic	m_ctrl_static_isdn_config_types;
	CButton	m_IsdnCtrlWnd;
	CButton	m_EditConfig;
	CButton	m_DeleteConfig;
	CButton	m_AddConfig;
	CComboBox	m_INISectionControl;
	CButton	m_ChkBoxScriptNonCritical;
	CButton	m_ChkBoxScriptAlarm;
	CButton	m_ScriptCtrlGrp;
	CButton	m_BtnAdd;
	CButton	m_MdmCtrlWnd;
	CButton	m_BtnEdit;
	CButton	m_BtnDelete;
	CComboBox	m_combBoxModemTypes;
	CEdit	m_PortWnd;
	BOOL	m_WANEnable;
	BOOL	m_Printf;
	BOOL	m_PrintfRx;
	BOOL	m_PrintfTx;
	BOOL	m_PrintfInitialize;
	BOOL	m_bNonCriticalScriptPrintf;
	BOOL	m_bAlarmScriptPrintf;
	CString	m_szPPINISection;
	CString	m_modem_type;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton AddBmpBtn1;
	CBitmapButton DeleteBmpBtn1;
	CBitmapButton EditBmpBtn1;
	CBitmapButton AddBmpBtn2;
	CBitmapButton DeleteBmpBtn2;
	CBitmapButton EditBmpBtn2;

// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
	BOOL GetModemTypes (void) ;
	BOOL WriteToCnfFile (void) ;
	void ReleaseBuffers (void) ;
	void PutModemsInParentsList (void) ;
	void PutIsdnConfigInParentsList (int index);
	void EnableButtons (void) ;
   void GetIsdnTypes ();
	BOOL m_bMdmConfigChanged ;
	int m_nSelectedModem ;
	int m_nSelectedIsdn ;
	BOOL IsdnEnabled ;

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
   BOOL ValidEditFields (void);

	// Generated message map functions
	//{{AFX_MSG(CWANDlg)
	afx_msg LRESULT OnSwitchFromIden(WPARAM, LPARAM);
	virtual void PostNcDestroy();
	virtual BOOL OnInitDialog();
	afx_msg void OnHelp();
	virtual void OnOK();
	afx_msg void OnSelchangeComboModemTypes();
	afx_msg void OnBtnAddModem();
	afx_msg void OnBtnEditModem();
	afx_msg void OnBtnDeleteModem();
	virtual void OnCancel();
	afx_msg void OnIsdnEdit();
	afx_msg void OnIsdnDelete();
	afx_msg void OnIsdnAdd();
	afx_msg void OnCfgs();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CWanPortDlg dialog

class CWanPortDlg : public CDialog
{
// Construction
public:
	CWanPortDlg(CWnd* pParent = NULL);	// standard constructor
	int GetMyID (void);

// Dialog Data
	//{{AFX_DATA(CWanPortDlg)
	enum { IDD = IDD_WAN_PORT_CONFIG };
	CButton	m_BtnRasOnly;
	CButton	m_BtnProxyOrRas;
	CButton	m_BtnProxyOnly;
	CButton	m_ctrl_link_usage_ctrl;
	CButton	m_static_list_host;
	CStatic	m_ctrl_static_ip_hosts;
	CEdit	m_ctrl_active_ip_hosts;
	CStatic	m_ctrl_static_active_connections;
	CEdit	m_ctrl_active_connections;
	CButton	m_link_ctrl_enabled;
	CEdit	m_ctrl_idle_time;
	CStatic	m_ctrl_minutes;
	CStatic	m_ctrl_static_idle_time;
	CButton	m_ctrl_delete;
	CButton	m_ctrl_add;
	CButton	m_static_bring_up;
	CEdit	m_ctrl_host;
	CListBox	m_list_host;
	CButton	m_RBtnIsdn;
	CButton	m_RBtnModem;
	CButton	m_BtnScript;
	CButton	m_RestartScriptWnd;
	CButton	m_ScriptEnableWnd;
	CButton	m_TermServerWnd;
	CButton	m_chkBtnDirConnect;
	CButton	m_chkboxIdleFlags;
	CStatic	m_StatModemTypes;
	CComboBox	m_ComBoxModemTypes;
	CStatic	m_ClkSpeedHdr;
	CStatic	m_BaudHeader;
	CButton	m_RBtnDialling;
	CButton	m_RBtnAnswering;
	CButton	m_RBtnExtClk;
	CComboBox	m_cboxSyncIntClkWnd;
	CButton	m_RBtnIntClk;
	CButton	m_RBtnSync;
	CComboBox	m_cboxAsyncBaudWnd;
	CButton	m_RBtnAsync;
	BOOL	m_WANPort;
	CString	m_OldSpeedStr;
	CString	m_cboxAsyncBaud;
	CString	m_cboxSyncIntClk;
	BOOL	m_bDirConnect;
	BOOL	m_bRestartScriptOnCommFailure;
	BOOL	m_bScriptEnable;
	BOOL	m_TermServer;
	CString	m_Line;
	int		m_active_connections;
	CDotDecimal	m_host;
	CString	m_szSectionName;
	int	m_active_hosts;
	UINT	m_idle_time;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton AddBmpBtn;
	CBitmapButton DeleteBmpBtn;
	CBitmapButton ScriptBmpBtn;

	CString  m_szOldModemSel;
	CString  m_szOldIsdnSel;


	// Chidanand - 25 Mar 1997 - PPP Dial Backup UI support	
	BOOL	m_Backup;
		// Corresponds to "Enable Backup" check box in WAN Dialog 
		

// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
	BOOL CheckDialString();
	void GetTypesofmodems (int k) ;
	BOOL ValidEditFields (void) ;
	void GetIsdnTypes ( int j ) ;
	
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CWanPortDlg)
	afx_msg LRESULT OnSwitchFromIden(WPARAM, LPARAM);
	afx_msg LRESULT OnSwitchToIden(WPARAM, LPARAM);
	virtual void OnCancel();
	virtual void OnOK();
	virtual void PostNcDestroy();
	afx_msg void OnHelp();
	afx_msg void OnControl();
	virtual BOOL OnInitDialog();
	afx_msg void OnRadioAsync();
	afx_msg void OnRadioSync();
	afx_msg void OnIntClock();
	afx_msg void OnExtClock();
	afx_msg void OnAnswering();
	afx_msg void OnDialling();
	afx_msg void OnCheckDirConnect();
	afx_msg void OnBtnScript();
	afx_msg void OnWanBackup();
	afx_msg void OnRadioIsdn();
	afx_msg void OnRadioModem();
	afx_msg void OnCheckLinkCtrlEnable();
	afx_msg void OnButtonAdd();
	afx_msg void OnButtonDelete();
	afx_msg void OnSelchangeComboModemTypes();
	afx_msg void OnProxyOnly();
	afx_msg void OnRasOnly();
	afx_msg void OnProxyOrRas();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#if 0
/////////////////////////////////////////////////////////////////////////////
// CWANBackupPortDlg dialog

class CWANBackupPortDlg : public CDialog
{
// Construction
public:
	CWANBackupPortDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CWANBackupPortDlg)
	enum { IDD = IDD_WAN_BACKUP_PORT_CONFIG };
	CStatic	m_staticDialNumber_2;
	CStatic	m_staticDialNumber_1;
	CButton	m_grpBackup_2;
	CButton	m_grpBackup_1;
	CButton	m_chkboxWAN2_High_Priority;
	CButton	m_chkboxWAN1_High_Priority;
	CEdit	m_EditDialNumberWnd_2;
	CString	m_StrDialNumber_2;
	CEdit	m_EditDialNumberWnd_1;
	CString	m_StrDialNumber_1;
	CComboBox	m_ComBoxModemTypes;
	CComboBox	m_cboxAsyncBaudWind;
	CString		m_cboxAsyncBaud;
	BOOL	m_bWAN1_High_Priority;
	BOOL	m_bWAN2_High_Priority;
	//}}AFX_DATA
	CString  m_szOldModemSel;

public :
	BOOL ValidEditFields (void) ;
	void EnableBackup_1 (BOOL pEnable);
	void EnableBackup_2 (BOOL pEnable);

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void PostNcDestroy();

	// Generated message map functions
	//{{AFX_MSG(CWANBackupPortDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnAdvanced();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg LRESULT OnSwitchFromIden(WPARAM, LPARAM);
	afx_msg LRESULT OnSwitchToIden(WPARAM, LPARAM);
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif

/////////////////////////////////////////////////////////////////////////////
// CWanTab dialog

class CWanTab : public CTabDialog
{
// Construction
public:
	CWanTab(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CWanTab)
	enum { IDD = IDD_WAN_TAB };
		// NOTE: the ClassWizard will add data members here

	// Added by cfp on 27-3-96
	UINT m_nPort ;

	//}}AFX_DATA
public:
	CWanPortDlg		*(m_pdlgWAN[n_PORTMAX_WAN]);
	CWANDlg			*m_advdlgWAN;
	
	int tabcount;
	char InitstrRHS[40],InitstrLHS[100];
	void WriteModemInfoToIni (void) ;
	void WriteInfoInIni(char Buff[40],char RHS[40] );
/* Jo 	void WriteToRouconIni(LPCSTR Section,LPCSTR strLHS,LPCSTR Default,ini_tpValuePair Table,const char* command); */

private:                                                    
	int AcceptConfig(void);
	void GetConfig(void);
	
	BOOL GetModemTypes (void) ;
/* Jo   void GetIsdnTypes (); */

// Implementation
public :
	int RouMsgBox (int, LPCSTR, int) ;
	void GetTabsRectDim (void) ;
	
	// Chidanand - 25 Mar 1997 - PPP Dial Backup UI support	
	void HandleBackupEnable (void);
		// If "Needs Dial Backup" check box is checked in either WAN 1 or WAN 2,
		// then this routine grays "WAN 3" dialog and enables "Backup Port" dialog.
		// Otherwise enables "WAN 3" dialog and grays "Backup Port" dialog.
		// This routine to be called whenever "Needs Dial Backup" check box is clicked
		// in any of WAN 1 or WAN 2	dialog boxes.

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CWanTab)
	virtual BOOL OnInitDialog();
  	virtual void OnOK();
	virtual void OnCancel();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#define MODEM_TYPE_DIRECT_CONNECT "Direct Connection"
/////////////////////////////////////////////////////////////////////////////
// CWanIsdnDlg dialog

/* Jo */
#if 0
class CWanIsdnDlg : public CDialog
{
// Construction
public:
	CWanIsdnDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CWanIsdnDlg)
	enum { IDD = IDD_WAN_ISDN_CONFIG };
	CButton	m_IsdnCtrlWnd;
	CButton	m_EditConfig;
	CButton	m_DeleteConfig;
	CButton	m_AddConfig;
	CComboBox	m_INISectionControl;
	CButton	m_ChkBoxScriptNonCritical;
	CButton	m_ChkBoxScriptAlarm;
	CButton	m_ScriptCtrlGrp;
	CEdit	m_PortWnd;
	BOOL	m_WANEnable;
	BOOL	m_Printf;
	BOOL	m_PrintfRx;
	BOOL	m_PrintfTx;
	BOOL	m_PrintfInitialize;
	BOOL	m_bNonCriticalScriptPrintf;
	BOOL	m_bAlarmScriptPrintf;
	CString	m_szPPINISection;
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton AddBmpBtn;
	CBitmapButton DeleteBmpBtn;
	CBitmapButton EditBmpBtn;

// Implementation
public:
	int	RouMsgBox(int, LPCSTR, int);
	void PutIsdnConfigInParentsList (int index);
   void GetIsdnTypes ();
	int m_nSelectedIsdn ;
	BOOL IsdnEnabled ;

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CWanIsdnDlg)
	afx_msg LRESULT OnSwitchFromIden(WPARAM, LPARAM);
	virtual void PostNcDestroy();
	virtual BOOL OnInitDialog();
	afx_msg void OnHelp();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnIsdnEdit();
	afx_msg void OnIsdnDelete();
	afx_msg void OnIsdnAdd();
	afx_msg void OnCfgs();
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CWanIsdnPort dialog

class CWanIsdnPort : public CDialog
{
// Construction
public:
	CWanIsdnPort(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CWanIsdnPort)
	enum { IDD = IDD_WAN_ISDN_PORT_CONFIG };
	CButton	m_LnkCtrlWnd;
	CButton	m_BtnScript;
	CButton	m_RestartScriptWnd;
	CButton	m_ScriptEnableWnd;
	CEdit	m_EditDialNumberWnd;
	CStatic	m_StatDialNumber;
	CComboBox	m_ComBoxModemTypes;
	CStatic	m_BaudHeader;
	CButton	m_RBtnDialling;
	CComboBox	m_cboxAsyncBaudWnd;
	CButton	m_RBtnAsync;
	BOOL	m_WANPort;
	CString	m_OldSpeedStr;
	CString	m_cboxAsyncBaud;
	CString	m_StrDialNumber;
	BOOL	m_bRestartScriptOnCommFailure;
	BOOL	m_bScriptEnable;
	CString	m_Line;
	CString	m_szSectionName;
	UINT	m_Idle_time;
	//}}AFX_DATA

	CString  m_szOldIsdnSel;

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton ScriptBmpBtn;

// Implementation
public:
	void GetIsdnTypes ( int j ) ;

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CWanIsdnPort)
	afx_msg LRESULT OnSwitchFromIden(WPARAM, LPARAM);
	afx_msg LRESULT OnSwitchToIden(WPARAM, LPARAM);
	virtual void OnCancel();
	virtual void OnOK();
	virtual void PostNcDestroy();
	afx_msg void OnHelp();
	virtual BOOL OnInitDialog();
	afx_msg void OnBtnScript();
	afx_msg void OnCheckDodEnable();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CWanIsdnTab dialog

class CWanIsdnTab : public CTabDialog
{
// Construction
public:
	CWanIsdnTab(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CWanIsdnTab)
	enum { IDD = IDD_WAN_ISDN_TAB };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA
public:
	CWanIsdnPort		*m_pisdnWAN;
	CWanIsdnDlg			*m_advisdnWAN;
	char InitstrRHS[40],InitstrLHS[100];
	void WriteInfoInIni(char *Buff,char *RHS );
	void WriteToRouconIni(LPCSTR Section,LPCSTR strLHS,LPCSTR Default,ini_tpValuePair Table,const char* command);

private:                                                    
	void GetConfig(void);
	int AcceptConfig(void);
// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CWanIsdnTab)
	virtual BOOL OnInitDialog();
  	virtual void OnOK();
	virtual void OnCancel();
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif 
/* Jo */
